/*
 * Decompiled with CFR 0.152.
 */
package output;

import components.sound.AY38910;
import components.sound.SCC;
import output.SMSSoundOutput;

public class MSXSoundOutput
extends SMSSoundOutput {
    private static final String[] CHANNEL_NAMES = new String[]{"Square Wave Channel 1", "Square Wave Channel 2", "Square Wave Channel 3", "Noise Channel", "FM Chip", "PSG Channel 1", "PSG Channel 2", "PSG Channel 3", "SCC Channel 1", "SCC Channel 2", "SCC Channel 3", "SCC Channel 4", "SCC Channel 5"};
    private static final int[] CHANNEL_MIN_VALUES;
    private static final int[] CHANNEL_MAX_VALUES;
    private AY38910 psg;
    private SCC scc;

    static {
        int[] nArray = new int[13];
        nArray[4] = -3072;
        nArray[8] = -2048;
        nArray[9] = -2048;
        nArray[10] = -2048;
        nArray[11] = -2048;
        nArray[12] = -2048;
        CHANNEL_MIN_VALUES = nArray;
        CHANNEL_MAX_VALUES = new int[]{2048, 2048, 2048, 2048, 3072, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048};
    }

    public MSXSoundOutput(String string, int n, int n2) {
        super(string, n, n2, 2);
    }

    public void setPSGay(AY38910 aY38910) {
        this.psg = aY38910;
    }

    public void setSCC(SCC sCC) {
        this.scc = sCC;
    }

    @Override
    public String[] getChannelNames() {
        return CHANNEL_NAMES;
    }

    @Override
    public int[] getChannelMinValues() {
        return CHANNEL_MIN_VALUES;
    }

    @Override
    public int[] getChannelMaxValues() {
        return CHANNEL_MAX_VALUES;
    }

    @Override
    protected int getNumberOfChannels() {
        return super.getNumberOfChannels() + 3 + 5;
    }

    @Override
    protected int getSamples(int n) {
        int n2 = super.getNumberOfChannels();
        if (n < n2) {
            return super.getSamples(n);
        }
        if ((n -= n2) < 3) {
            return this.psg.getSamples(n);
        }
        return this.scc.getSamples(n -= 3);
    }

    @Override
    protected void advance(int n) {
        super.advance(n);
        this.psg.advanceChannels(n);
        this.scc.advanceChannels(n);
    }

    @Override
    protected boolean isLeftEnabled(int n) {
        int n2 = super.getNumberOfChannels();
        if (n < n2) {
            return super.isLeftEnabled(n);
        }
        if ((n -= n2) < 3) {
            return true;
        }
        return this.scc.isChannelEnabled(n -= 3);
    }

    @Override
    protected boolean isRightEnabled(int n) {
        return this.isLeftEnabled(n);
    }
}

