/*
 * Decompiled with CFR 0.152.
 */
package filesystem;

import filesystem.CalendarBasedTime;
import java.io.File;
import java.util.Calendar;

public class FileLastModificationTime
extends CalendarBasedTime {
    private final File file;
    private long lastUpdateTime;
    private long lastAccessTime;
    private long lastModified;

    public FileLastModificationTime(File file) {
        this.file = file;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    @Override
    protected Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        long l = System.currentTimeMillis();
        if (l - this.lastAccessTime > 50L) {
            this.lastModified = this.file.lastModified();
            this.lastAccessTime = l;
        }
        calendar.setTimeInMillis(this.lastModified);
        return calendar;
    }

    public boolean update() {
        long l = this.file.lastModified();
        if (l == 0L || l > this.lastUpdateTime) {
            this.lastUpdateTime = l;
            return true;
        }
        return false;
    }
}

