/*
 * Decompiled with CFR 0.152.
 */
package disassembler.dialects;

import assembler.HexStrings;
import disassembler.Section;
import disassembler.SectionProvider;
import disassembler.Symbols;
import disassembler.Z80Disassembler;
import disassembler.dialects.AssemblerDialect;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import util.map.HashIntMap;
import util.map.HashMap;
import util.map.Map;
import util.set.IntHashSet;

public class WlaSmsDialect
implements AssemblerDialect {
    private static AssemblerDialect instance;
    private final int defaultSlot;

    private WlaSmsDialect() {
        this(2);
    }

    protected WlaSmsDialect(int n) {
        this.defaultSlot = n;
    }

    public static AssemblerDialect getInstance() {
        if (instance == null) {
            instance = new WlaSmsDialect();
        }
        return instance;
    }

    @Override
    public void writeHeader(List<Z80Disassembler.SourceLine> list, int[] nArray, boolean bl) {
        this.writeMemoryMap(list, nArray, bl);
    }

    @Override
    public void writeRAMdefinitions(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, SectionProvider sectionProvider, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.writeEnums(list, map, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    @Override
    public void updateRAMdefinitions(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, SectionProvider sectionProvider, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.rewriteEnums(list, map, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    @Override
    public void writePortDefinitions(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        WlaSmsDialect.writePortDefines(list, map, hashMap, string);
    }

    @Override
    public void updatePortDefinitions(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        WlaSmsDialect.rewritePortDefines(list, map, hashMap, string);
    }

    @Override
    public void writeStartOfBank(List<Z80Disassembler.SourceLine> list, int n, int n2) {
        if (list.get(list.size() - 1) != Z80Disassembler.SourceLine.EMPTY_LINE) {
            list.add(Z80Disassembler.SourceLine.EMPTY_LINE);
        }
        if (n2 != this.defaultSlot) {
            list.add(new Z80Disassembler.SourceLine(".BANK " + n + " SLOT " + n2));
        } else {
            list.add(new Z80Disassembler.SourceLine(".BANK " + n));
        }
        list.add(new Z80Disassembler.SourceLine(".ORG $0000"));
        list.add(Z80Disassembler.SourceLine.EMPTY_LINE);
    }

    @Override
    public void writeSection(List<Z80Disassembler.SourceLine> list, Section section) {
    }

    @Override
    public char getChildLabelChar() {
        return '@';
    }

    @Override
    public String getDataPrefix(int n) {
        if (n > 4) {
            return ".dsb";
        }
        return n == 2 ? ".dw" : ".db";
    }

    @Override
    public String getHighByte(String string) {
        return ">" + string;
    }

    @Override
    public String getLowByte(String string) {
        return "<" + string;
    }

    @Override
    public String getCurrentAddressSymbol() {
        return null;
    }

    @Override
    public boolean requiresDataCommas() {
        return false;
    }

    @Override
    public boolean requiresSquareBrackets() {
        return false;
    }

    @Override
    public boolean requiresAbsoluteAddressesForRelativeBranches() {
        return false;
    }

    @Override
    public boolean supportsAnonymousLabels() {
        return true;
    }

    @Override
    public String getIncBinLine(String string) {
        return string != null ? ".incbin \"" + string + "\"" : ".incbin ...";
    }

    protected void writeMemoryMap(List<Z80Disassembler.SourceLine> list, int[] nArray, boolean bl) {
        list.add(new Z80Disassembler.SourceLine(".MEMORYMAP"));
        if (bl) {
            list.add(new Z80Disassembler.SourceLine("SLOTSIZE $7FF0"));
            list.add(new Z80Disassembler.SourceLine("SLOT 0 $0000"));
            list.add(new Z80Disassembler.SourceLine("SLOTSIZE $10"));
            list.add(new Z80Disassembler.SourceLine("SLOT 1 $7FF0"));
            list.add(new Z80Disassembler.SourceLine("SLOTSIZE $4000"));
            list.add(new Z80Disassembler.SourceLine("SLOT 2 $8000"));
        } else {
            list.add(new Z80Disassembler.SourceLine("SLOTSIZE $4000"));
            list.add(new Z80Disassembler.SourceLine("SLOT 0 $0000"));
            list.add(new Z80Disassembler.SourceLine("SLOT 1 $4000"));
            list.add(new Z80Disassembler.SourceLine("SLOT 2 $8000"));
        }
        list.add(new Z80Disassembler.SourceLine("DEFAULTSLOT 2"));
        list.add(new Z80Disassembler.SourceLine(".ENDME"));
        list.add(new Z80Disassembler.SourceLine(".ROMBANKMAP"));
        list.add(new Z80Disassembler.SourceLine("BANKSTOTAL " + ((nArray.length - 1) / 16384 + 1)));
        if (bl) {
            list.add(new Z80Disassembler.SourceLine("BANKSIZE $7FF0"));
            list.add(new Z80Disassembler.SourceLine("BANKS 1"));
            list.add(new Z80Disassembler.SourceLine("BANKSIZE $10"));
            list.add(new Z80Disassembler.SourceLine("BANKS 1"));
            if ((nArray.length - 1) / 16384 + 1 - 2 > 0) {
                list.add(new Z80Disassembler.SourceLine("BANKSIZE $4000"));
                list.add(new Z80Disassembler.SourceLine("BANKS " + ((nArray.length - 1) / 16384 + 1 - 2)));
            }
        } else {
            list.add(new Z80Disassembler.SourceLine("BANKSIZE $4000"));
            list.add(new Z80Disassembler.SourceLine("BANKS " + ((nArray.length - 1) / 16384 + 1)));
        }
        list.add(new Z80Disassembler.SourceLine(".ENDRO"));
    }

    private void writeEnums(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.writeEnums(list, list.size(), map, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    private void writeEnums(List<Z80Disassembler.SourceLine> list, int n, Map<List<Symbols.Symbol>> map, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        int n2;
        int n3;
        if (n < 0) {
            return;
        }
        BitSet bitSet = hashMap.keyBitSet();
        BitSet bitSet2 = hashMap2.keyBitSet();
        BitSet bitSet3 = Symbols.getRamSymbolKeys(map);
        ArrayList<Z80Disassembler.SourceLine> arrayList = new ArrayList<Z80Disassembler.SourceLine>(2 * (hashMap.size() + hashMap2.size()));
        boolean bl = true;
        int n4 = 0;
        while (n4 < 65536) {
            Symbols.Symbol symbol;
            Symbols.Symbol symbol2 = symbol = bitSet3.get(0xC000 | n4) ? Symbols.findRAMSymbol(0xC000 | n4, map) : null;
            if (bitSet.get(n4) || symbol != null) {
                String string3;
                if (bl) {
                    arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
                    arrayList.add(new Z80Disassembler.SourceLine(".enum $" + Integer.toHexString(0xC000 | n4).toUpperCase() + " export"));
                    bl = false;
                }
                if ((n3 = (n2 = Math.min(bitSet.nextSetBit(n4 + 1) & Integer.MAX_VALUE, bitSet3.nextSetBit(n4 + 1) & Integer.MAX_VALUE)) - n4) > 1) {
                    int n5 = hashIntMap.get(n4);
                    int n6 = n3 = n5 != Integer.MIN_VALUE ? Math.min(n3, n5) : 1;
                }
                String string4 = n3 == 1 ? " db" : (string3 = n3 == 2 ? " dw" : " dsb $" + Integer.toHexString(n3));
                if (symbol != null) {
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(symbol.getLabel()) + string3 + (symbol.getComment() != null ? "\t" + symbol.getComment() : "")));
                } else {
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string, 0xC000 | n4)) + string3));
                }
                n4 += n3 - 1;
            } else {
                if (!bl) {
                    arrayList.add(new Z80Disassembler.SourceLine(".ende"));
                    bl = true;
                }
                if ((n2 = bitSet3.nextSetBit(49152 + n4)) < 65408) {
                    n2 -= 49152;
                }
                n4 = Math.min(bitSet.nextSetBit(n4) & Integer.MAX_VALUE, n2 & Integer.MAX_VALUE) - 1;
            }
            ++n4;
        }
        if (!bl) {
            arrayList.add(new Z80Disassembler.SourceLine(".ende"));
        }
        n4 = this.getSRAMsize();
        int n7 = n4 - 1;
        n2 = 0;
        while (n2 < this.getNumSRAMbanks()) {
            bl = true;
            n3 = 0;
            while (n3 < n4) {
                int n8 = n2 * n4 | n3 & n7;
                if (bitSet2.get(n8)) {
                    int n9;
                    int n10;
                    if (bl) {
                        arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
                        arrayList.add(new Z80Disassembler.SourceLine(".enum $" + Integer.toHexString(this.getSRAMstart() | n8 & n7).toUpperCase() + " export"));
                        bl = false;
                    }
                    if ((n10 = (n9 = bitSet2.nextSetBit(n8 + 1) & Integer.MAX_VALUE) - n8) > 1) {
                        int n11 = hashIntMap2.get(n8);
                        int n12 = n10 = n11 != Integer.MIN_VALUE ? Math.min(n10, n11) : 1;
                    }
                    String string5 = n10 == 1 ? " db" : (n10 == 2 ? " dw" : " dsb $" + Integer.toHexString(n10));
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string2, n8)) + string5));
                    n3 += n10 - 1;
                } else {
                    if (!bl) {
                        arrayList.add(new Z80Disassembler.SourceLine(".ende"));
                        bl = true;
                    }
                    n3 = (bitSet2.nextSetBit(n8) & Integer.MAX_VALUE) - n2 * n4 - 1;
                }
                ++n3;
            }
            if (!bl) {
                arrayList.add(new Z80Disassembler.SourceLine(".ende"));
            }
            ++n2;
        }
        arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
        list.addAll(n, arrayList);
    }

    protected int getNumSRAMbanks() {
        return 2;
    }

    protected int getSRAMsize() {
        return 16384;
    }

    protected int getSRAMstart() {
        return 32768;
    }

    /*
     * Unable to fully structure code
     */
    private static int removeEnums(List<Z80Disassembler.SourceLine> var0) {
        var1_1 = Z80Disassembler.findBeginningOfDisassembly(var0);
        while (var1_1 < var0.size()) {
            block3: {
                var2_2 = var0.get(var1_1);
                if (!var2_2.toString().startsWith(".enum")) break block3;
                var3_3 = var1_1 - 1;
                ** GOTO lbl12
                {
                    var2_2 = var0.get(++var1_1);
                    do {
                        if (!var2_2.toString().startsWith(".ende")) continue block1;
                        ++var1_1;
                        var2_2 = var0.get(++var1_1);
lbl12:
                        // 2 sources

                    } while (var2_2.toString().startsWith(".enum"));
                }
                var0.subList(var3_3, var1_1).clear();
                return var3_3;
            }
            ++var1_1;
        }
        return -1;
    }

    private void rewriteEnums(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.writeEnums(list, WlaSmsDialect.removeEnums(list), map, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    private static void writePortDefines(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        WlaSmsDialect.writePortDefines(list, list.size(), map, hashMap, string);
    }

    private static void writePortDefines(List<Z80Disassembler.SourceLine> list, int n, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        if (n < 0) {
            return;
        }
        ArrayList<Z80Disassembler.SourceLine> arrayList = new ArrayList<Z80Disassembler.SourceLine>(hashMap.size() + 4);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        IntHashSet intHashSet = new IntHashSet();
        IntHashSet intHashSet2 = new IntHashSet();
        for (Map.Entry<IntHashSet> entry : hashMap.entrySet()) {
            int n2 = entry.getKey();
            treeSet.add(n2);
            boolean bl = false;
            boolean bl2 = false;
            if (map.get(n2) != map.get(-n2)) {
                int[] nArray = entry.getValue().keys();
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = nArray[n4];
                    if (Z80Disassembler.isPortRead(n2, n5)) {
                        bl = true;
                    } else {
                        bl2 = true;
                    }
                    if (!bl || !bl2) {
                        ++n4;
                        continue;
                    }
                    break;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                intHashSet2.add(n2);
            }
            if (!bl) continue;
            intHashSet.add(n2);
        }
        if (!treeSet.isEmpty()) {
            arrayList.add(Z80Disassembler.SourceLine.PORTS_HEAD_COMMENT);
            Iterator<Map.Entry<IntHashSet>> iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                int n6 = (Integer)((Object)iterator.next());
                if (!intHashSet2.contains(n6) && intHashSet.contains(n6)) continue;
                String string2 = map.get(n6);
                if (string2 != null) {
                    arrayList.add(new Z80Disassembler.SourceLine(".define " + string2 + HexStrings.PREFIXED_HEX_STRINGS[n6]));
                    continue;
                }
                if (intHashSet2.contains(n6)) {
                    arrayList.add(new Z80Disassembler.SourceLine(".define " + String.format(string, n6) + HexStrings.PREFIXED_HEX_STRINGS[n6]));
                    continue;
                }
                arrayList.add(new Z80Disassembler.SourceLine(".define " + String.format(string, n6) + HexStrings.PREFIXED_HEX_STRINGS[n6]));
            }
            if (!intHashSet.isEmpty()) {
                arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
                arrayList.add(new Z80Disassembler.SourceLine("; Input Ports"));
                iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    int n7 = (Integer)((Object)iterator.next());
                    if (!intHashSet.contains(n7)) continue;
                    String string3 = map.get(-n7);
                    if (string3 != null) {
                        arrayList.add(new Z80Disassembler.SourceLine(".define " + string3 + HexStrings.PREFIXED_HEX_STRINGS[n7]));
                        continue;
                    }
                    if (intHashSet2.contains(n7)) {
                        arrayList.add(new Z80Disassembler.SourceLine(".define " + String.format(string, n7) + HexStrings.PREFIXED_HEX_STRINGS[n7]));
                        continue;
                    }
                    arrayList.add(new Z80Disassembler.SourceLine(".define " + String.format(string, n7) + HexStrings.PREFIXED_HEX_STRINGS[n7]));
                }
            }
            arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
        }
        list.addAll(n, arrayList);
    }

    private static int removePortDefines(List<Z80Disassembler.SourceLine> list) {
        int n = Z80Disassembler.findBeginningOfDisassembly(list);
        while (n < list.size()) {
            Z80Disassembler.SourceLine sourceLine = list.get(n);
            if (sourceLine == Z80Disassembler.SourceLine.PORTS_HEAD_COMMENT) {
                int n2 = n++;
                sourceLine = list.get(n);
                while (sourceLine.toString().startsWith(".define")) {
                    sourceLine = list.get(++n);
                }
                if ("; Input Ports".equals(list.get(n + 1).toString())) {
                    ++n;
                    sourceLine = list.get(++n);
                    while (sourceLine.toString().startsWith(".define")) {
                        sourceLine = list.get(++n);
                    }
                }
                list.subList(n2, ++n).clear();
                return n2;
            }
            if (sourceLine.getAddress() >= 0) {
                while (n > 0 && sourceLine != Z80Disassembler.SourceLine.EMPTY_LINE) {
                    sourceLine = list.get(--n);
                }
                return n + 1;
            }
            ++n;
        }
        return -1;
    }

    private static void rewritePortDefines(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        WlaSmsDialect.writePortDefines(list, WlaSmsDialect.removePortDefines(list), map, hashMap, string);
    }

    public String toString() {
        return "WLA DX";
    }
}

