/*
 * Decompiled with CFR 0.152.
 */
package variables;

import assembler.HexStrings;
import components.cartridge.GBCartridge;
import components.sound.GBSoundController;
import components.video.GBLCDController;
import java.awt.Component;
import java.awt.Graphics;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import system.GameBoy;
import system.GameBoyColor;
import variables.AbstractVariable;
import variables.AbstractVariables;
import variables.Variable;

public final class GameBoyVariables
extends AbstractVariables {
    private static final String[] PPU_REGISTER_NAMES = new String[]{"LCDC  ($FF40)", "STAT  ($FF41)", "SCY   ($FF42)", "SCX   ($FF43)", "LY    ($FF44)", "LYC   ($FF45)", "BGP   ($FF47)", "OBP0  ($FF48)", "OBP1  ($FF49)", "WY    ($FF4A)", "WX    ($FF4B)", "VBK   ($FF4F)", "HDMA1 ($FF51)", "HDMA2 ($FF52)", "HDMA3 ($FF53)", "HDMA4 ($FF54)", "HDMA5 ($FF55)", "RP    ($FF56)", "BCPS  ($FF68)", "BCPD  ($FF69)", "OCPS  ($FF9A)", "OCPD  ($FF9B)"};
    private static final String[] APU_REGISTER_NAMES = new String[]{"NR50 ($FF24)", "NR51 ($FF25)", "NR52 ($FF26)", "NR10 ($FF10)", "NR11 ($FF11)", "NR12 ($FF12)", "NR13 ($FF13)", "NR14 ($FF14)", "NR21 ($FF16)", "NR22 ($FF17)", "NR23 ($FF18)", "NR24 ($FF19)", "NR30 ($FF1A)", "NR31 ($FF1B)", "NR32 ($FF1C)", "NR33 ($FF1D)", "NR34 ($FF1E)", "NR41 ($FF20)", "NR42 ($FF21)", "NR43 ($FF22)", "NR44 ($FF23)"};
    private static final String[] BUTTON_NAMES = new String[]{"A     ", "B     ", "SELECT", "START ", "RIGHT ", "LEFT  ", "UP    ", "DOWN  "};
    private static final String[] SYSTEM_VARIABLE_NAMES = new String[]{"IE  ", "IF  ", "DIV ", "TIMA", "TMA ", "TAC ", "JOYP", "SB  ", "SC  ", "SVBK", "KEY1"};
    private static final int[] SYSTEM_VARIABLE_ADDRESS = new int[]{65535, 65295, 65284, 65285, 65286, 65287, 65280, 65281, 65282, 65392, 65357};
    private static final int NUM_GAME_BOY_COLOR_SYSTEM_VARIABLES = 2;
    private static final int NUM_GAME_BOY_COLOR_PPU_VARIABLES = 11;
    private static final String[] CHANNEL_NAMES = new String[]{"SQ1", "SQ2", "WAV", "NOI"};
    private static final DutyIcon[] DUTY_ICONS;
    private static final String[] DUTY_STRINGS;

    static {
        DutyIcon[] dutyIconArray = new DutyIcon[4];
        int[] nArray = new int[4];
        nArray[3] = 15;
        dutyIconArray[0] = new DutyIcon(nArray);
        int[] nArray2 = new int[4];
        nArray2[0] = 240;
        nArray2[3] = 15;
        dutyIconArray[1] = new DutyIcon(nArray2);
        int[] nArray3 = new int[4];
        nArray3[0] = 240;
        nArray3[2] = 15;
        nArray3[3] = 255;
        dutyIconArray[2] = new DutyIcon(nArray3);
        dutyIconArray[3] = new DutyIcon(new int[]{15, 255, 255, 240});
        DUTY_ICONS = dutyIconArray;
        DUTY_STRINGS = new String[]{"12.5%", "25%", "50%", "75%"};
    }

    protected GameBoyVariables(GameBoy gameBoy) {
        super(GameBoyVariables.createVariables(gameBoy));
    }

    private static Map<String, Variable[]> createVariables(GameBoy gameBoy) {
        LinkedHashMap<String, Variable[]> linkedHashMap = new LinkedHashMap<String, Variable[]>();
        linkedHashMap.put("PPU", GameBoyVariables.createPPUVariables(gameBoy));
        linkedHashMap.put("APU", GameBoyVariables.createAPUVariables(gameBoy));
        linkedHashMap.put("Cartridge", GameBoyVariables.createCartridgeVariables(gameBoy));
        linkedHashMap.put("Game Boy", GameBoyVariables.createSystemVariables(gameBoy));
        return linkedHashMap;
    }

    private static Variable[] createPPUVariables(final GameBoy gameBoy) {
        Variable[] variableArray = new Variable[(gameBoy instanceof GameBoyColor ? PPU_REGISTER_NAMES.length : PPU_REGISTER_NAMES.length - 11) + 3];
        int n = 0;
        while (n < variableArray.length - 3) {
            variableArray[n] = GameBoyVariables.createPPURegisterVariable(gameBoy, n);
            ++n;
        }
        final GBLCDController.State state = gameBoy.getState().getLCDstate();
        variableArray[variableArray.length - 3] = new AbstractVariable("Window line", "Internal window line counter"){

            @Override
            public String getValue() {
                return Integer.toString(state.getWindowLine());
            }
        };
        variableArray[variableArray.length - 2] = new AbstractVariable("RDiM", "Remaining dots in current mode"){

            @Override
            public String getValue() {
                return Integer.toString(gameBoy.calcDotsInModeLeft());
            }
        };
        variableArray[variableArray.length - 1] = new AbstractVariable("Dots until Vblank", "Remaining dots until next vblank"){

            @Override
            public String getValue() {
                return Integer.toString(gameBoy.calcDotsUntilVBlank());
            }
        };
        return variableArray;
    }

    private static Variable createPPURegisterVariable(final GameBoy gameBoy, final int n) {
        Variable[] variableArray;
        final GBLCDController.State state = gameBoy.getState().getLCDstate();
        String[][] stringArrayArray = new String[2][];
        stringArrayArray[0] = new String[]{"BG/Window Display/Priority", "OBJ (Sprite) Display Enable", "OBJ (Sprite) Size", "BG Tile Map Display Select", "BG & Window Tile Data Select", "Window Display Enable", "Window Tile Map Display Select", "LCD Display Enable"};
        String[] stringArray = new String[7];
        stringArray[1] = "Mode Flag";
        stringArray[2] = "Coincidence Flag";
        stringArray[3] = "Mode 0 H-Blank Interrupt";
        stringArray[4] = "Mode 1 V-Blank Interrupt";
        stringArray[5] = "Mode 2 OAM Interrupt";
        stringArray[6] = "LYC=LY Coincidence Interrupt";
        stringArrayArray[1] = stringArray;
        String[][] stringArrayArray2 = stringArrayArray;
        final String[][] stringArray2 = new String[][]{{"Off", "On"}, {"Off", "On"}, {"8x8", "8x16"}, {"$9800-$9BFF", "$9C00-$9FFF"}, {"$8800-97FF", "$8000-$8FFF"}, {"Off", "On"}, {"$9800-$9BFF", "$9C00-$9FFF"}, {"Off", "On"}};
        final String[] stringArray3 = new String[]{"H-Blank", "V-Blank", "OAM", "Render"};
        if (n < stringArrayArray2.length) {
            variableArray = new Variable[n == 0 ? stringArrayArray2[n].length : stringArrayArray2[n].length - 1];
            int n2 = 0;
            while (n2 < variableArray.length) {
                final int n3 = stringArrayArray2[n].length - 1 - n2;
                variableArray[n2] = new AbstractVariable("Bit " + n3 + " - " + stringArrayArray2[n][n3]){

                    @Override
                    public String getValue() {
                        if (n == 0) {
                            int n2 = state.getRegLCDC() >> n3 & 1;
                            return String.valueOf(n2) + " (" + stringArray2[n3][n2] + ")";
                        }
                        if (n3 > 2) {
                            return 4.toEnabledString((state.getRegSTAT() & 1 << n3) != 0);
                        }
                        if (n3 == 2) {
                            return (state.getRegSTAT() & 1 << n3) != 0 ? "LYC=LY" : "LYC<>LY";
                        }
                        int n4 = state.getRegSTAT() & 3;
                        return String.valueOf(n4) + " (" + stringArray3[n4] + ")";
                    }
                };
                ++n2;
            }
        } else {
            variableArray = Variable.NO_VARIABLES;
        }
        return new AbstractVariable(PPU_REGISTER_NAMES[n]){

            @Override
            public String getValue() {
                int n2;
                switch (n) {
                    case 0: {
                        n2 = state.getRegLCDC();
                        break;
                    }
                    case 1: {
                        n2 = state.getRegSTAT();
                        break;
                    }
                    case 2: {
                        n2 = state.getRegSCY();
                        break;
                    }
                    case 3: {
                        n2 = state.getRegSCX();
                        break;
                    }
                    case 4: {
                        n2 = state.getRegLY();
                        break;
                    }
                    case 5: {
                        n2 = state.getRegLYC();
                        break;
                    }
                    case 6: {
                        n2 = state.getRegBGP();
                        break;
                    }
                    case 7: {
                        n2 = state.getRegOBP0();
                        break;
                    }
                    case 8: {
                        n2 = state.getRegOBP1();
                        break;
                    }
                    case 9: {
                        n2 = state.getRegWY();
                        break;
                    }
                    case 10: {
                        n2 = state.getRegWX();
                        break;
                    }
                    case 11: {
                        n2 = state.getRegVBK();
                        break;
                    }
                    case 12: {
                        n2 = state.getRegHDMA1();
                        break;
                    }
                    case 13: {
                        n2 = state.getRegHDMA2();
                        break;
                    }
                    case 14: {
                        n2 = state.getRegHDMA3();
                        break;
                    }
                    case 15: {
                        n2 = state.getRegHDMA4();
                        break;
                    }
                    case 16: {
                        n2 = state.getRegHDMA5();
                        break;
                    }
                    case 17: {
                        n2 = gameBoy.peekByte(65366);
                        break;
                    }
                    case 18: {
                        n2 = state.getRegBGPI();
                        break;
                    }
                    case 19: {
                        n2 = gameBoy.peekByte(65384);
                        break;
                    }
                    case 20: {
                        n2 = state.getRegOBPI();
                        break;
                    }
                    case 21: {
                        n2 = gameBoy.peekByte(65386);
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException(n);
                    }
                }
                return HexStrings.PREFIXED_HEX_STRINGS[n2].substring(1);
            }

            @Override
            public boolean isEditable() {
                return true;
            }

            @Override
            public void setValue(String string) {
                try {
                    int n2 = Integer.parseInt(string.replaceAll("[^0-9A-Fa-f]", ""), 16);
                    switch (n) {
                        case 0: {
                            gameBoy.pokeByte(65344, n2);
                            break;
                        }
                        case 1: {
                            gameBoy.pokeByte(65345, n2);
                            break;
                        }
                        case 2: {
                            gameBoy.pokeByte(65346, n2);
                            break;
                        }
                        case 3: {
                            gameBoy.pokeByte(65347, n2);
                            break;
                        }
                        case 4: {
                            gameBoy.pokeByte(65348, n2);
                            break;
                        }
                        case 5: {
                            gameBoy.pokeByte(65349, n2);
                            break;
                        }
                        case 6: {
                            gameBoy.pokeByte(65351, n2);
                            break;
                        }
                        case 7: {
                            gameBoy.pokeByte(65352, n2);
                            break;
                        }
                        case 8: {
                            gameBoy.pokeByte(65353, n2);
                            break;
                        }
                        case 9: {
                            gameBoy.pokeByte(65354, n2);
                            break;
                        }
                        case 10: {
                            gameBoy.pokeByte(65355, n2);
                            break;
                        }
                        case 11: {
                            gameBoy.pokeByte(65359, n2);
                            break;
                        }
                        case 12: {
                            gameBoy.pokeByte(65361, n2);
                            break;
                        }
                        case 13: {
                            gameBoy.pokeByte(65362, n2);
                            break;
                        }
                        case 14: {
                            gameBoy.pokeByte(65363, n2);
                            break;
                        }
                        case 15: {
                            gameBoy.pokeByte(65364, n2);
                            break;
                        }
                        case 16: {
                            gameBoy.pokeByte(65365, n2);
                            break;
                        }
                        case 17: {
                            gameBoy.pokeByte(65366, n2);
                            break;
                        }
                        case 18: {
                            gameBoy.pokeByte(65384, n2);
                            break;
                        }
                        case 19: {
                            gameBoy.pokeByte(65385, n2);
                            break;
                        }
                        case 20: {
                            gameBoy.pokeByte(65386, n2);
                            break;
                        }
                        case 21: {
                            gameBoy.pokeByte(65387, n2);
                        }
                    }
                }
                catch (Exception exception) {}
            }

            @Override
            public Variable[] getVariables() {
                return variableArray;
            }
        };
    }

    private static Variable[] createAPUVariables(final GameBoy gameBoy) {
        final GBSoundController.State state = gameBoy.getState().getSoundState();
        Variable[] variableArray = new Variable[APU_REGISTER_NAMES.length + 1 + CHANNEL_NAMES.length];
        int n = 0;
        while (n < APU_REGISTER_NAMES.length) {
            variableArray[n] = GameBoyVariables.createAPUVariable(gameBoy, n);
            ++n;
        }
        final Variable[] variableArray2 = new Variable[16];
        int n2 = 0;
        while (n2 < variableArray2.length) {
            final int n3 = n2;
            variableArray2[n2] = new AbstractVariable("[$FF3" + Integer.toHexString(n3).toUpperCase() + "]"){

                @Override
                public String getValue() {
                    return HexStrings.PREFIXED_HEX_STRINGS[state.getWavePatternRAM()[n3]].substring(1);
                }

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setValue(String string) {
                    int n;
                    state.getWavePatternRAM()[n3] = n = Integer.parseInt(string.replaceAll("[^0-9A-Fa-f]", ""), 16) & 0xFF;
                }
            };
            ++n2;
        }
        final WaveIcon waveIcon = new WaveIcon();
        variableArray[GameBoyVariables.APU_REGISTER_NAMES.length] = new AbstractVariable("Wave Pattern"){

            @Override
            public String getValue() {
                return "";
            }

            @Override
            public Icon getValueIcon(Component component) {
                waveIcon.setComponent(component);
                waveIcon.setWaveRAM(state.getWavePatternRAM());
                return waveIcon;
            }

            @Override
            public Variable[] getVariables() {
                return variableArray2;
            }
        };
        int[] nArray = new int[]{10, 7, 5, 8};
        int n4 = 0;
        while (n4 < CHANNEL_NAMES.length) {
            final int n5 = n4;
            final Variable[] variableArray3 = new Variable[nArray[n5]];
            variableArray3[0] = new AbstractVariable("Cycles to next sample"){

                @Override
                public String getValue() {
                    return Integer.toString(state.getCounter(n5));
                }
            };
            variableArray3[1] = new AbstractVariable("Index"){

                @Override
                public String getValue() {
                    return Integer.toString(state.getGeneratorPhase(n5));
                }
            };
            variableArray3[2] = new AbstractVariable("Sample"){

                @Override
                public String getValue() {
                    return Integer.toString(state.getSample(n5));
                }
            };
            variableArray3[3] = new AbstractVariable("Cycles until length expires"){

                @Override
                public String getValue() {
                    boolean bl = false;
                    switch (n5) {
                        case 0: {
                            bl = (state.getRegNR14() & 0x40) != 0;
                            break;
                        }
                        case 1: {
                            bl = (state.getRegNR24() & 0x40) != 0;
                            break;
                        }
                        case 2: {
                            bl = (state.getRegNR34() & 0x40) != 0;
                            break;
                        }
                        case 3: {
                            boolean bl2 = bl = (state.getRegNR44() & 0x40) != 0;
                        }
                    }
                    if (!bl) {
                        return "Never";
                    }
                    return Integer.toString(gameBoy.calcNextSoundClock() + (Math.max(0, state.getLength(n5) - 1) * 2 + (state.getPhase() & 1)) * 0x400000 / 512);
                }
            };
            variableArray3[4] = new AbstractVariable("Volume"){

                @Override
                public String getValue() {
                    if (n5 == 2) {
                        int n = (state.getRegNR32() >> 5 & 3) - 1;
                        return String.valueOf(Integer.toString(100 >> n)) + "%";
                    }
                    return Integer.toString(state.getVolume(n5));
                }
            };
            if (variableArray3.length > 5) {
                variableArray3[5] = new AbstractVariable("Envelope Direction"){

                    @Override
                    public String getValue() {
                        int n = 0;
                        switch (n5) {
                            case 0: {
                                n = state.getRegNR12();
                                break;
                            }
                            case 1: {
                                n = state.getRegNR22();
                                break;
                            }
                            case 3: {
                                n = state.getRegNR42();
                            }
                        }
                        if ((n & 7) == 0) {
                            return "Disabled";
                        }
                        return (n & 8) != 0 ? "Louder" : "Quieter";
                    }
                };
                variableArray3[6] = new AbstractVariable("Cycles to next envelope"){

                    @Override
                    public String getValue() {
                        int n = 0;
                        switch (n5) {
                            case 0: {
                                n = state.getRegNR12();
                                break;
                            }
                            case 1: {
                                n = state.getRegNR22();
                                break;
                            }
                            case 3: {
                                n = state.getRegNR42();
                            }
                        }
                        if ((n & 7) == 0) {
                            return "Disabled";
                        }
                        return Integer.toString(gameBoy.calcNextSoundClock() + (Math.max(0, state.getDelayEnvelope(n5) - 1) * 8 + (8 - (state.getPhase() + 1))) * 0x400000 / 512);
                    }
                };
            }
            if (n5 == 0) {
                variableArray3[7] = new AbstractVariable("Sweep Frequency"){

                    @Override
                    public String getValue() {
                        return Integer.toString(state.getSweepFrequency());
                    }
                };
                variableArray3[8] = new AbstractVariable("Sweep Addend"){

                    @Override
                    public String getValue() {
                        return Integer.toString(state.getSweepAddend());
                    }
                };
                variableArray3[9] = new AbstractVariable("Cycles to next sweep"){

                    @Override
                    public String getValue() {
                        return Integer.toString(gameBoy.calcNextSoundClock() + (Math.max(0, state.getSweepCounter() - 1) * 4 + (4 - ((state.getPhase() + 1 & 3) + 1))) * 0x400000 / 512);
                    }
                };
            } else if (n5 == 3) {
                int n6 = 1;
                while (n6 < 6) {
                    variableArray3[n6] = variableArray3[n6 + 1];
                    ++n6;
                }
                variableArray3[6] = new AbstractVariable("LFSR"){

                    @Override
                    public String getValue() {
                        return String.format("%15s", Integer.toBinaryString(state.getRegLinearFeedbackShift())).replace(' ', '0');
                    }
                };
                variableArray3[7] = new AbstractVariable("Noise Counter"){

                    @Override
                    public String getValue() {
                        return Integer.toString(state.getNoiseCounter());
                    }
                };
            }
            variableArray[GameBoyVariables.APU_REGISTER_NAMES.length + 1 + n4] = new AbstractVariable("Channel " + (n4 + 1) + " (" + CHANNEL_NAMES[n4] + ")"){

                @Override
                public String getValue() {
                    return null;
                }

                @Override
                public Variable[] getVariables() {
                    return variableArray3;
                }
            };
            ++n4;
        }
        return variableArray;
    }

    private static Variable createAPUVariable(final GameBoy gameBoy, final int n) {
        Variable[] variableArray;
        final StringBuilder stringBuilder = n == 1 || n == 2 ? new StringBuilder() : null;
        final GBSoundController.State state = gameBoy.getState().getSoundState();
        if (stringBuilder != null) {
            Variable[] variableArray2 = new Variable[2];
            variableArray2[0] = new AbstractVariable("Channels left", "SQ1 SQ2 WAV NOI"){

                @Override
                public String getValue() {
                    stringBuilder.setLength(0);
                    int n = 0;
                    while (n < CHANNEL_NAMES.length) {
                        if (n > 0) {
                            stringBuilder.append(' ');
                        }
                        if ((state.getRegNR51() & 1 << n) != 0) {
                            stringBuilder.append(CHANNEL_NAMES[n]);
                        } else {
                            stringBuilder.append("---");
                        }
                        ++n;
                    }
                    return stringBuilder.toString();
                }
            };
            variableArray = variableArray2;
            variableArray2[1] = new AbstractVariable("Channels right", "SQ1 SQ2 WAV NOI"){

                @Override
                public String getValue() {
                    stringBuilder.setLength(0);
                    int n = 0;
                    while (n < CHANNEL_NAMES.length) {
                        if (n > 0) {
                            stringBuilder.append(' ');
                        }
                        if ((state.getRegNR51() & 16 << n) != 0) {
                            stringBuilder.append(CHANNEL_NAMES[n]);
                        } else {
                            stringBuilder.append("---");
                        }
                        ++n;
                    }
                    return stringBuilder.toString();
                }
            };
        } else {
            variableArray = null;
        }
        final Variable[] variableArray3 = variableArray;
        return new AbstractVariable(APU_REGISTER_NAMES[n], n == 1 || n == 2 ? "SQ1 SQ2 WAV NOI" : null){

            @Override
            public String getValue() {
                int n2;
                switch (n) {
                    case 0: {
                        n2 = state.getRegNR50();
                        break;
                    }
                    case 1: {
                        n2 = state.getRegNR51();
                        break;
                    }
                    case 2: {
                        n2 = state.getRegNR52();
                        break;
                    }
                    case 3: {
                        n2 = state.getRegNR10();
                        break;
                    }
                    case 4: {
                        n2 = state.getRegNR11();
                        break;
                    }
                    case 5: {
                        n2 = state.getRegNR12();
                        break;
                    }
                    case 6: {
                        n2 = state.getRegNR13();
                        break;
                    }
                    case 7: {
                        n2 = state.getRegNR14();
                        break;
                    }
                    case 8: {
                        n2 = state.getRegNR21();
                        break;
                    }
                    case 9: {
                        n2 = state.getRegNR22();
                        break;
                    }
                    case 10: {
                        n2 = state.getRegNR23();
                        break;
                    }
                    case 11: {
                        n2 = state.getRegNR24();
                        break;
                    }
                    case 12: {
                        n2 = state.getRegNR30();
                        break;
                    }
                    case 13: {
                        n2 = state.getRegNR31();
                        break;
                    }
                    case 14: {
                        n2 = state.getRegNR32();
                        break;
                    }
                    case 15: {
                        n2 = state.getRegNR33();
                        break;
                    }
                    case 16: {
                        n2 = state.getRegNR34();
                        break;
                    }
                    case 17: {
                        n2 = state.getRegNR41();
                        break;
                    }
                    case 18: {
                        n2 = state.getRegNR42();
                        break;
                    }
                    case 19: {
                        n2 = state.getRegNR43();
                        break;
                    }
                    case 20: {
                        n2 = state.getRegNR44();
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException(n);
                    }
                }
                return HexStrings.PREFIXED_HEX_STRINGS[n2].substring(1);
            }

            @Override
            public String getDisplayValue() {
                switch (n) {
                    case 0: {
                        return String.valueOf(super.getDisplayValue()) + " (Left: " + (state.getRegNR50() & 7) + ((state.getRegNR50() & 8) != 0 ? " + VIN" : "") + ", Right: " + (state.getRegNR50() >> 4 & 7) + ((state.getRegNR50() & 0x80) != 0 ? " + VIN)" : ")");
                    }
                    case 1: {
                        if (stringBuilder != null) {
                            stringBuilder.setLength(0);
                            stringBuilder.append(super.getDisplayValue());
                            stringBuilder.append(" (Left: ");
                            int n2 = 0;
                            while (n2 < CHANNEL_NAMES.length) {
                                if ((state.getRegNR51() & 1 << n2) != 0) {
                                    stringBuilder.append(1);
                                } else {
                                    stringBuilder.append(0);
                                }
                                ++n2;
                            }
                            stringBuilder.append(", Right: ");
                            n2 = 0;
                            while (n2 < CHANNEL_NAMES.length) {
                                if ((state.getRegNR51() & 16 << n2) != 0) {
                                    stringBuilder.append(1);
                                } else {
                                    stringBuilder.append(0);
                                }
                                ++n2;
                            }
                            return stringBuilder.append(')').toString();
                        }
                        return super.getDisplayValue();
                    }
                    case 2: {
                        if (stringBuilder != null) {
                            if ((state.getRegNR52() & 0x80) == 0) {
                                return String.valueOf(super.getDisplayValue()) + " (Off)";
                            }
                            stringBuilder.setLength(0);
                            stringBuilder.append(super.getDisplayValue());
                            stringBuilder.append(" (APU On,");
                            int n3 = 0;
                            while (n3 < CHANNEL_NAMES.length) {
                                stringBuilder.append(' ');
                                if ((state.getRegNR52() & 1 << n3) != 0) {
                                    stringBuilder.append(CHANNEL_NAMES[n3]);
                                } else {
                                    stringBuilder.append("---");
                                }
                                ++n3;
                            }
                            return stringBuilder.append(')').toString();
                        }
                    }
                    case 4: 
                    case 9: {
                        int n4 = n == 4 ? state.getRegNR11() : state.getRegNR21();
                        return String.valueOf(super.getDisplayValue()) + " (SQ" + (n / 5 + 1) + " Duty: " + DUTY_STRINGS[n4 >> 6] + ")";
                    }
                    case 12: {
                        return String.valueOf(super.getDisplayValue()) + " (WAV DAC: " + ((state.getRegNR30() & 0x80) != 0 ? "On)" : "Off)");
                    }
                    case 14: {
                        return String.valueOf(super.getDisplayValue()) + " (WAV Volume: " + (100 >> (state.getRegNR32() >> 5 & 3) - 1) + "%)";
                    }
                }
                return super.getDisplayValue();
            }

            @Override
            public Icon getValueIcon(Component component) {
                if (n == 4 || n == 9) {
                    int n2 = n == 4 ? state.getRegNR11() : state.getRegNR21();
                    DutyIcon dutyIcon = DUTY_ICONS[n2 >> 6];
                    dutyIcon.setComponent(component);
                    return dutyIcon;
                }
                return super.getValueIcon(component);
            }

            @Override
            public Variable[] getVariables() {
                if (n == 1) {
                    return variableArray3;
                }
                return super.getVariables();
            }

            @Override
            public boolean isEditable() {
                return true;
            }

            @Override
            public void setValue(String string) {
                try {
                    int n2 = Integer.parseInt(string.replaceAll("[^0-9A-Fa-f]", ""), 16);
                    switch (n) {
                        case 0: {
                            gameBoy.pokeByte(65316, n2);
                            break;
                        }
                        case 1: {
                            gameBoy.pokeByte(65317, n2);
                            break;
                        }
                        case 2: {
                            gameBoy.pokeByte(65318, n2);
                            break;
                        }
                        case 3: {
                            gameBoy.pokeByte(65296, n2);
                            break;
                        }
                        case 4: {
                            gameBoy.pokeByte(65297, n2);
                            break;
                        }
                        case 5: {
                            gameBoy.pokeByte(65298, n2);
                            break;
                        }
                        case 6: {
                            gameBoy.pokeByte(65299, n2);
                            break;
                        }
                        case 7: {
                            gameBoy.pokeByte(65300, n2);
                            break;
                        }
                        case 8: {
                            gameBoy.pokeByte(65302, n2);
                            break;
                        }
                        case 9: {
                            gameBoy.pokeByte(65303, n2);
                            break;
                        }
                        case 10: {
                            gameBoy.pokeByte(65304, n2);
                            break;
                        }
                        case 11: {
                            gameBoy.pokeByte(65305, n2);
                            break;
                        }
                        case 12: {
                            gameBoy.pokeByte(65306, n2);
                            break;
                        }
                        case 13: {
                            gameBoy.pokeByte(65307, n2);
                            break;
                        }
                        case 14: {
                            gameBoy.pokeByte(65308, n2);
                            break;
                        }
                        case 15: {
                            gameBoy.pokeByte(65309, n2);
                            break;
                        }
                        case 16: {
                            gameBoy.pokeByte(65310, n2);
                            break;
                        }
                        case 17: {
                            gameBoy.pokeByte(65312, n2);
                            break;
                        }
                        case 18: {
                            gameBoy.pokeByte(65313, n2);
                            break;
                        }
                        case 19: {
                            gameBoy.pokeByte(65314, n2);
                            break;
                        }
                        case 20: {
                            gameBoy.pokeByte(65315, n2);
                        }
                    }
                }
                catch (Exception exception) {}
            }
        };
    }

    private static Variable[] createCartridgeVariables(final GameBoy gameBoy) {
        Variable[] variableArray;
        final GBCartridge.RegularState regularState = (GBCartridge.RegularState)gameBoy.getState().getCartridgeState();
        Variable[] variableArray2 = variableArray = gameBoy.hasRTC() ? GameBoyVariables.createRTCVariables(regularState) : null;
        Variable[] variableArray3 = new Variable[variableArray != null ? 6 : (gameBoy.hasSRAM() ? 5 : 3)];
        final String string = gameBoy.getCartridgeTitle();
        final String string2 = gameBoy.getCartridgeType();
        variableArray3[0] = new AbstractVariable("Title"){

            @Override
            public String getValue() {
                return string;
            }
        };
        variableArray3[1] = new AbstractVariable("Type"){

            @Override
            public String getValue() {
                return string2;
            }
        };
        variableArray3[2] = new AbstractVariable("ROM Bank"){

            @Override
            public String getValue() {
                return HexStrings.PREFIXED_HEX_STRINGS[regularState.getROMBankNumber() & 0xFF].substring(1);
            }
        };
        if (variableArray != null || gameBoy.hasSRAM()) {
            variableArray3[3] = new AbstractVariable("SRAM"){

                @Override
                public String getValue() {
                    return 27.toEnabledString(gameBoy.isSRAMenabled());
                }
            };
            variableArray3[4] = new AbstractVariable("RAM Bank"){

                @Override
                public String getValue() {
                    return HexStrings.PREFIXED_HEX_STRINGS[regularState.getRAMBankNumber() & 0xFF].substring(1);
                }
            };
        }
        if (variableArray3.length > 5) {
            variableArray3[5] = new AbstractVariable("RTC"){

                @Override
                public String getValue() {
                    return null;
                }

                @Override
                public Variable[] getVariables() {
                    return variableArray;
                }
            };
        }
        return variableArray3;
    }

    private static Variable[] createRTCVariables(final GBCartridge.RegularState regularState) {
        Variable[] variableArray = new Variable[]{new AbstractVariable("Control"){

            @Override
            public String getValue() {
                return HexStrings.PREFIXED_HEX_STRINGS[regularState.getClockControl() & 0xFF].substring(1);
            }
        }, new AbstractVariable("Days"){

            @Override
            public String getValue() {
                return Integer.toString(regularState.getClockDays());
            }
        }, new AbstractVariable("Hours"){

            @Override
            public String getValue() {
                return Integer.toString(regularState.getClockHours());
            }
        }, new AbstractVariable("Minutes"){

            @Override
            public String getValue() {
                return Integer.toString(regularState.getClockMinutes());
            }
        }, new AbstractVariable("Seconds"){

            @Override
            public String getValue() {
                return Integer.toString(regularState.getClockSeconds());
            }
        }, new AbstractVariable("Microseconds"){

            @Override
            public String getValue() {
                return Integer.toString((int)((long)regularState.getClockCycles() * 1000000L / 0x400000L));
            }
        }, new AbstractVariable("Latched Control"){

            @Override
            public String getValue() {
                return HexStrings.PREFIXED_HEX_STRINGS[regularState.getClockLatchedControl() & 0xFF].substring(1);
            }
        }, new AbstractVariable("Latched Days"){

            @Override
            public String getValue() {
                return Integer.toString(regularState.getClockLatchedDays());
            }
        }, new AbstractVariable("Latched Hours"){

            @Override
            public String getValue() {
                return Integer.toString(regularState.getClockLatchedHours());
            }
        }, new AbstractVariable("Latched Minutes"){

            @Override
            public String getValue() {
                return Integer.toString(regularState.getClockLatchedMinutes());
            }
        }, new AbstractVariable("Latched Seconds"){

            @Override
            public String getValue() {
                return Integer.toString(regularState.getClockLatchedSeconds());
            }
        }};
        return variableArray;
    }

    private static Variable[] createSystemVariables(GameBoy gameBoy) {
        final GameBoy.State state = gameBoy.getState();
        boolean bl = gameBoy instanceof GameBoyColor;
        Variable[] variableArray = new Variable[1 + (bl ? SYSTEM_VARIABLE_NAMES.length + 2 : SYSTEM_VARIABLE_NAMES.length - 2)];
        variableArray[0] = GameBoyVariables.createInputVariable(gameBoy);
        int n = 1;
        while (n < variableArray.length) {
            variableArray[n] = GameBoyVariables.createSystemVariable(gameBoy, n - 1);
            ++n;
        }
        if (bl) {
            variableArray[variableArray.length - 2] = new AbstractVariable("Double Speed"){

                @Override
                public String getValue() {
                    return String.valueOf(state.isDoubleSpeed() ? "Enabled" : "Disabled") + (!state.isDmgMode() && (state.getHRam()[77] & 1) != 0 ? " (Preparing Switch)" : "");
                }
            };
            variableArray[variableArray.length - 1] = new AbstractVariable("DMG Mode"){

                @Override
                public String getValue() {
                    return 42.toEnabledString(state.isDmgMode());
                }
            };
        }
        return variableArray;
    }

    private static Variable createInputVariable(final GameBoy gameBoy) {
        final Variable[] variableArray = new Variable[BUTTON_NAMES.length];
        int n = 0;
        while (n < variableArray.length) {
            final int n2 = n++;
            variableArray[n2] = new AbstractVariable(BUTTON_NAMES[n2], "Boolean"){

                @Override
                public String getValue() {
                    return Boolean.toString(gameBoy.isButtonDown(n2));
                }

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setValue(String string) {
                    gameBoy.setButtonDownOverride(n2, Boolean.parseBoolean(string));
                }
            };
        }
        return new AbstractVariable("Input"){

            @Override
            public String getValue() {
                return null;
            }

            @Override
            public Variable[] getVariables() {
                return variableArray;
            }
        };
    }

    private static Variable createSystemVariable(final GameBoy gameBoy, int n) {
        Variable[] variableArray;
        if (n >= SYSTEM_VARIABLE_ADDRESS.length) {
            return null;
        }
        final int n2 = SYSTEM_VARIABLE_ADDRESS[n];
        switch (n) {
            case 0: 
            case 1: {
                variableArray = GameBoyVariables.createInterruptVariables(gameBoy, n);
                break;
            }
            default: {
                variableArray = Variable.NO_VARIABLES;
            }
        }
        return new AbstractVariable(String.format("%s ($%04X)", SYSTEM_VARIABLE_NAMES[n], 0xFF00 | n2)){

            @Override
            public String getValue() {
                return HexStrings.PREFIXED_HEX_STRINGS[gameBoy.peekByte(n2)].substring(1);
            }

            @Override
            public boolean isEditable() {
                return true;
            }

            @Override
            public void setValue(String string) {
                try {
                    int n = Integer.parseInt(string.replaceAll("[^0-9A-Fa-f]", ""), 16);
                    gameBoy.pokeByte(0xFF00 | n2, n);
                }
                catch (Exception exception) {}
            }

            @Override
            public Variable[] getVariables() {
                return variableArray;
            }
        };
    }

    private static Variable[] createInterruptVariables(final GameBoy gameBoy, int n) {
        String[] stringArray = new String[]{"V-Blank Interrupt", "LCD STAT Interrupt", "Timer Interrupt", "Serial Interrupt", "Joypad Interrupt"};
        Variable[] variableArray = new Variable[stringArray.length];
        final String string = n == 0 ? " (Enabled)" : " (Requested)";
        final int n2 = SYSTEM_VARIABLE_ADDRESS[n];
        int n3 = 0;
        while (n3 < stringArray.length) {
            final int n4 = n3;
            variableArray[n3] = new AbstractVariable(stringArray[n3]){

                @Override
                public String getValue() {
                    int n = gameBoy.peekByte(n2) >> n4 & 1;
                    return String.valueOf(n) + (n != 0 ? string : "");
                }
            };
            ++n3;
        }
        return variableArray;
    }

    static class DutyIcon
    extends WaveIcon {
        public DutyIcon(int[] nArray) {
            this.setWaveRAM(nArray);
        }
    }

    static class WaveIcon
    extends WaveformIcon {
        private int[] waveRAM;

        WaveIcon() {
        }

        public void setWaveRAM(int[] nArray) {
            this.waveRAM = nArray;
        }

        @Override
        protected int getNumberOfSamples() {
            return this.waveRAM.length * 2;
        }

        @Override
        protected int getSample(int n) {
            return this.waveRAM[n >> 1] >> (((n ^ 1) & 1) << 2) & 0xF;
        }
    }

    static abstract class WaveformIcon
    implements Icon {
        private final int horizPixelsPerValue = 4;
        private Component component;

        WaveformIcon() {
        }

        protected abstract int getNumberOfSamples();

        protected abstract int getSample(int var1);

        public void setComponent(Component component) {
            this.component = component;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (component == null) {
                component = this.component;
            }
            if (component != null) {
                graphics.setColor(component.getForeground());
            }
            int n3 = this.getNumberOfSamples();
            int n4 = n;
            int n5 = n2 + this.getIconHeight() - 1 - this.getSample(0);
            int n6 = 1;
            while (n6 < n3) {
                int n7 = n4 + 4;
                int n8 = n2 + this.getIconHeight() - 1 - this.getSample(n6);
                graphics.drawLine(n4, n5, n7 - 1, n5);
                graphics.drawLine(n7, n5, n7, n8);
                n4 = n7;
                n5 = n8;
                ++n6;
            }
            graphics.drawLine(n4, n5, n4 + 4 - 1, n5);
        }

        @Override
        public int getIconWidth() {
            return this.getNumberOfSamples() * 4;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }
}

