/*
 * Decompiled with CFR 0.152.
 */
package treetable;

import java.awt.AWTKeyStroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import sun.swing.UIAction;
import treetable.TreeTableCellEditor;
import treetable.TreeTableCellRenderer;
import treetable.TreeTableModel;
import treetable.TreeTableModelAdapter;

public class TreeTable
extends JTable {
    final TreeTableCellRenderer tree;

    public TreeTable(TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(this, treeTableModel);
        this.setModel(treeTableModel);
        this.tree.setSelectionModel(new DefaultTreeSelectionModel(){
            {
                TreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }

            private void handleMouseEvent(MouseEvent mouseEvent) {
                if (!(mouseEvent.isShiftDown() || mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isAltGraphDown() || mouseEvent.isMetaDown())) {
                    TreeTable.this.tree.setSelectionRow(TreeTable.this.getSelectedRow());
                }
            }
        });
        this.passThroughKeyStroke(KeyStroke.getKeyStroke(38, 0));
        this.passThroughKeyStroke(KeyStroke.getKeyStroke(40, 0));
        this.passThroughKeyStroke(KeyStroke.getKeyStroke(37, 0));
        this.passThroughKeyStroke(KeyStroke.getKeyStroke(39, 0));
        TreeTable.restoreTraversalKeys(this);
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor(this.tree));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    private static void restoreTraversalKeys(JTable jTable) {
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(jTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke("TAB"));
        jTable.setFocusTraversalKeys(0, hashSet);
        HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>(jTable.getFocusTraversalKeys(1));
        hashSet2.add(KeyStroke.getKeyStroke("shift TAB"));
        jTable.setFocusTraversalKeys(1, hashSet2);
    }

    public void passThroughKeyStroke(KeyStroke keyStroke) {
        final Object object = this.tree.getInputMap().get(keyStroke);
        Action action = this.tree.getActionMap().get(object);
        this.getInputMap().put(keyStroke, object);
        try {
            if (action instanceof UIAction) {
                this.getActionMap().put(object, new UIAction(((UIAction)action).getName()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTable.this.tree.getActionMap().get(object).actionPerformed(new ActionEvent(TreeTable.this.tree, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
                    }
                });
            } else {
                this.getActionMap().put(object, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTable.this.tree.getActionMap().get(object).actionPerformed(new ActionEvent(TreeTable.this.tree, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
                    }
                });
            }
        }
        catch (IllegalAccessError illegalAccessError) {
            this.getActionMap().put(object, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreeTable.this.tree.getActionMap().get(object).actionPerformed(new ActionEvent(TreeTable.this.tree, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
                }
            });
        }
    }

    public List<TreePath> getExpandedPaths() {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        int n = 0;
        while (n < this.tree.getRowCount()) {
            if (this.tree.isExpanded(n)) {
                arrayList.add(this.tree.getPathForRow(n));
            }
            ++n;
        }
        return arrayList;
    }

    public void expandPaths(List<TreePath> list) {
        for (TreePath treePath : list) {
            this.tree.expandPath(treePath);
        }
    }

    public void setModel(TreeTableModel treeTableModel) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TreeTableModelAdapter) {
            ((TreeTableModelAdapter)tableModel).uninstallTreeListeners();
        }
        this.tree.setModel(treeTableModel);
        TreeTableModelAdapter treeTableModelAdapter = new TreeTableModelAdapter(treeTableModel, this.tree);
        treeTableModelAdapter.installTreeListeners();
        super.setModel(treeTableModelAdapter);
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (this.getModel() != null) {
            throw new UnsupportedOperationException("table model of tree table must not be changed.");
        }
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null) {
            this.tree.setRowHeight(n);
        }
    }

    @Override
    public void doLayout() {
        try {
            int n = this.tree.getCellRenderer().getTreeCellRendererComponent((JTree)this.tree, (Object)this.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (boolean)false, (int)0, (boolean)false).getPreferredSize().height;
            if (n > 0) {
                this.setRowHeight(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        super.doLayout();
    }

    public void setSelectionEnabled(boolean bl) {
        this.setCellSelectionEnabled(bl);
        this.tree.setSelectionModel(bl ? new DefaultTreeSelectionModel(){
            {
                TreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        } : null);
    }

    public void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
    }

    public void setHideIcons(boolean bl) {
        this.tree.setHideIcons(bl);
    }

    public void setShowsRootHandles(boolean bl) {
        this.tree.setShowsRootHandles(bl);
    }

    public void expandFirstLevel() {
        TreeTableModel treeTableModel = (TreeTableModel)this.tree.getModel();
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        Object object = treeTableModel.getRoot();
        int n = treeTableModel.getChildCount(object);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(new TreePath(new Object[]{treeTableModel.getRoot(), treeTableModel.getChild(object, n2)}));
            ++n2;
        }
        this.expandPaths(arrayList);
    }
}

