/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import assembler.HexStrings;
import assembler.SourceMap;
import common.Properties;
import components.OutputListener;
import debugfiles.DebugFile;
import debugfiles.WarningHandler;
import disassembler.Symbols;
import disassembler.Z80Disassembler;
import evscript.EvscriptDebugInfo;
import evscript.EvscriptSourceMap;
import expressions.ConcatenatedExpression;
import expressions.Expression;
import expressions.FunctionProvider;
import expressions.ParseException;
import expressions.Tokenizer;
import expressions.UnknownVariableException;
import expressions.VariableProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.instrument.UnmodifiableClassException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import platform.DebuggableSystemDecorator;
import platform.Emulicious;
import platform.LabelProvider;
import platform.debugger.Breakpoint;
import platform.debugger.DebugFileInterpreter;
import platform.debugger.ExpressionEvaluator;
import platform.debugger.InvalidBreakpoint;
import platform.debugger.IsConstantException;
import platform.debugger.Watchpoint;
import platform.debugger.messages.MessageHandler;
import system.DebuggableSystem;
import system.EmulatableSystem;
import system.GameBoy;
import system.SystemEventListener;
import util.io.IOUtilities;
import util.map.HashMap;
import util.queue.CyclicIntStack;
import util.queue.CyclicLongStack;
import variables.AbstractVariable;
import variables.Variable;
import variables.Variables;
import variables.VariablesProvider;

public class SystemDebugger
extends DebuggableSystemDecorator
implements SystemEventListener {
    private static final String VARIABLE_NAME_BREAKPOINT_ADDRESS = "source";
    private static final String VARIABLE_NAME_BRANCH_DESTINATION = "destination";
    private static final String VARIABLE_NAME_BREAKPOINT_PORT = "port";
    private static final String VARIABLE_NAME_BREAKPOINT_OLDVALUE = "oldvalue";
    private static final String VARIABLE_NAME_BREAKPOINT_VALUE = "value";
    private static final String VARIABLE_NAME_BREAKPOINT_OPERATION = "op";
    private static final Breakpoint NULL_BREAKPOINT = SystemDebugger.createNullBreakpoint();
    private static final Breakpoint[] NO_BREAKPOINTS = new Breakpoint[0];
    private static final String COVERAGE_DATA_SIGNATURE = "EMULICIOUSCVG";
    private static final int COVERAGE_DATA_VERSION = 1;
    private static final int COVERAGE_DATA_MIN_VERSION = 1;
    private static final int WRITES_PER_SCANLINE = 5;
    private static final int READS_PER_SCANLINE = 5;
    private static final int SIZE_UNDO_STACK = 30;
    private final ExpressionEvaluator breakpointAddressEvaluator = new ExpressionEvaluator(){

        @Override
        public int evaluate(CharSequence charSequence) throws UnknownVariableException, ParseException {
            if (this.isAllHexDigits(charSequence)) {
                charSequence = "$" + charSequence;
            }
            return new Expression(charSequence, SystemDebugger.getTokenizer()).getValue(SystemDebugger.this.getVariables(), SystemDebugger.this.functions);
        }

        private boolean isAllHexDigits(CharSequence charSequence) {
            boolean bl = charSequence.length() > 0;
            int n = charSequence.length() - 1;
            while (bl && n >= 0) {
                char c = charSequence.charAt(n);
                bl = c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
                --n;
            }
            return bl;
        }

        @Override
        public boolean hasVariables(CharSequence charSequence) throws ParseException {
            if (this.isAllHexDigits(charSequence)) {
                charSequence = "$" + charSequence;
            }
            return !new Expression(charSequence, SystemDebugger.getTokenizer()).getVariableNames().isEmpty();
        }
    };
    private final LinkedList<Action> undoStack = new LinkedList();
    private final LinkedList<Action> redoStack = new LinkedList();
    private final CyclicStateBuffer stateBuffer = new CyclicStateBuffer(8);
    private final InputStack inputStack = new InputStack(10000);
    private int framesSinceLastState;
    private volatile boolean suspended;
    private boolean stepping;
    private Breakpoint breakpointHit;
    private String breakpointMessage;
    private final java.util.HashMap<String, Integer> breakpointVariables = new java.util.HashMap();
    private int stepOverVirtualAddress = -1;
    private int runToAddress = -1;
    private int runToVirtualAddress = -1;
    private int runBackToAddress = -1;
    private int runBackToVirtualAddress = -1;
    private long cyclesRunBackToAddress;
    private int runToScanline = -1;
    private long executedCycles;
    private int executedInstructions;
    private int executedScanlines;
    private int prevScanline;
    private int writesPerFrame = 5;
    private int halfPercentWritesPerFrame = 0;
    private boolean wasVBlank;
    private int haltedCycles;
    private int address;
    private boolean biosSkipped;
    private long prevInstructionExecutedCycles;
    private final CyclicLongStack callInstructionExecutedCycles = new CyclicLongStack(64);
    private long prevMappedInstructionExecutedCycles;
    private boolean skipBreakpoints;
    private boolean skipExceptions;
    private int tmpPrevSP;
    private int tmpPrevStackValue;
    private byte readsOnScanline;
    private int readOnScanlineAddress1;
    private int readOnScanlineAddress2;
    private boolean readOnScanlineToggle;
    private byte[] writesOnScanline = new byte[256];
    private int cpuUsage;
    private boolean interruptBreakpointEnabled;
    private boolean interruptBreakpointSuspend;
    private String interruptBreakpointCondition;
    private Expression interruptBreakpointConditionExp;
    private String interruptBreakpointMessage;
    private Expression interruptBreakpointMessageExp;
    private final Deque<InterruptedState> interruptedStates = new ArrayDeque<InterruptedState>();
    private int interruptedVA;
    private boolean lastVAwriteDuringInterrupt;
    private boolean uninitializedMemoryBreakpointEnabled;
    private boolean uninitializedMemoryBreakpointSuspend;
    private String uninitializedMemoryBreakpointCondition;
    private Expression uninitializedMemoryBreakpointConditionExp;
    private String uninitializedMemoryBreakpointMessage;
    private Expression uninitializedMemoryBreakpointMessageExp;
    private boolean dataExecutionBreakpointEnabled;
    private boolean dataExecutionBreakpointSuspend;
    private String dataExecutionBreakpointCondition;
    private Expression dataExecutionBreakpointConditionExp;
    private String dataExecutionBreakpointMessage;
    private Expression dataExecutionBreakpointMessageExp;
    private boolean stackRomWriteBreakpointEnabled;
    private boolean stackRomWriteBreakpointSuspend;
    private String stackRomWriteBreakpointCondition;
    private Expression stackRomWriteBreakpointConditionExp;
    private String stackRomWriteBreakpointMessage;
    private Expression stackRomWriteBreakpointMessageExp;
    private boolean bankSwapAtPCBreakpointEnabled;
    private boolean bankSwapAtPCBreakpointSuspend;
    private String bankSwapAtPCBreakpointCondition;
    private Expression bankSwapAtPCBreakpointConditionExp;
    private String bankSwapAtPCBreakpointMessage;
    private Expression bankSwapAtPCBreakpointMessageExp;
    private final boolean[] errorBreakpointEnabled;
    private final boolean[] errorBreakpointSuspend;
    private final String[] errorBreakpointCondition;
    private final Expression[] errorBreakpointConditionExp;
    private final String[] errorBreakpointMessage;
    private final Expression[] errorBreakpointMessageExp;
    private long lastGUIupdate;
    private long[] coverage;
    private long maxCoverage;
    private long sumCoverage;
    private int numCoverage;
    private BitSet coverageExclude;
    private long[] ramCoverage;
    private long maxRamCoverage;
    private long sumRamCoverage;
    private int numRamCoverage;
    private BitSet ramCoverageExclude;
    private boolean recordCoverage;
    private boolean suspendOnMappedLinesOnly;
    private boolean suspendOnNextMappedLine;
    private OutputListener portListener = new OutputListener(){

        @Override
        public void outputAvailable(int n, int n2, int n3) {
            boolean bl = SystemDebugger.this.isSuspended();
            if (n2 < 0) {
                SystemDebugger.this.readPort(n, n2 & Integer.MAX_VALUE);
            } else {
                SystemDebugger.this.writePort(n, n2);
            }
            if (!bl) {
                SystemDebugger.this.sleepWhileSuspended();
            }
        }
    };
    private int prevPC;
    private int pcToSet;
    private boolean shouldStepBack;
    private boolean shouldStepBackOver;
    private boolean shouldStepBackReturn;
    private int[] stackSources;
    private CyclicIntStack trace = new CyclicIntStack(4);
    private final List<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
    private util.map.Map<Breakpoint[]> romBreakpoints;
    private util.map.Map<Breakpoint[]> ramBreakpoints;
    private util.map.Map<Breakpoint[]> sramBreakpoints;
    private util.map.Map<Breakpoint[]> vramBreakpoints;
    private util.map.Map<Breakpoint[]> portBreakpoints;
    private Map<String, util.map.Map<Breakpoint[]>> memoryLocationBreakpoints;
    private static final Tokenizer tokenizer = new Tokenizer("(?:\\$|0x|0X)\\p{XDigit}+|\\d+|%[01][0_1]*|'(?:\\\\.|[^'])'", "<=|>=|==|!=|<<|>>|&&|\\|\\||@@|:|[+\\-*/#%=<>&\\|\\^~!@&]", "(?:\\p{Alpha}|_|\\.|\\?|:)(?:\\w|\\.|\\?|\\$|@\\w)*", "[\\(\\)]");
    private java.util.HashMap<Breakpoint, Expression> breakpointConditions = new java.util.HashMap();
    private java.util.HashMap<Breakpoint, Expression> breakpointMessages = new java.util.HashMap();
    private List<Symbols.Symbol> symbols;
    private util.map.Map<List<Symbols.Symbol>> symbolsByAddress;
    private util.map.Map<List<Symbols.Symbol>> ramSymbols;
    private DebugFile debugFile;
    private DebugFileInterpreter debugFileInterpreter;
    private LabelProvider labelProvider;
    private LabelProvider labelProviderRAM;
    private LabelProvider labelProviderSRAM;
    private LabelProvider labelProviderPorts;
    private VariableProvider additionalVariables;
    private final VariableProvider variables = new VariableProvider(){

        @Override
        public long getValue(String string, boolean bl) throws UnknownVariableException {
            int n;
            Object object;
            if (string.length() <= 2) {
                if ("va".equalsIgnoreCase(string)) {
                    return SystemDebugger.this.getVRAMaddress();
                }
                object = SystemDebugger.this.getRegisterNames();
                int n2 = 0;
                while (n2 < ((String[])object).length) {
                    if (object[n2].equalsIgnoreCase(string)) {
                        return SystemDebugger.this.getRegisterValue(n2);
                    }
                    if (string.length() == 1 && ((String)object[n2]).length() == 2) {
                        if (((String)object[n2]).substring(0, 1).equalsIgnoreCase(string)) {
                            return SystemDebugger.this.getRegisterValue(n2) >> 8;
                        }
                        if (((String)object[n2]).substring(1).equalsIgnoreCase(string)) {
                            return SystemDebugger.this.getRegisterValue(n2) & 0xFF;
                        }
                    }
                    ++n2;
                }
                if (string.length() == 2 && Character.toLowerCase(string.charAt(1)) == 'f') {
                    String[] stringArray = SystemDebugger.this.getFlagNames();
                    n = 0;
                    while (n < stringArray.length) {
                        if (Character.toUpperCase(string.charAt(0)) == stringArray[n].charAt(0) || stringArray[n].length() == 3 && stringArray[n].charAt(1) == '/' && Character.toUpperCase(string.charAt(0)) == stringArray[n].charAt(2)) {
                            return SystemDebugger.this.isFlagSet(n) ? 1 : 0;
                        }
                        ++n;
                    }
                }
            }
            if (string.length() == 3) {
                if (Character.toUpperCase(string.charAt(0)) == 'I') {
                    object = string.substring(0, 2);
                    char c = Character.toUpperCase(string.charAt(2));
                    if (c == 'H' || c == 'L') {
                        String[] stringArray = SystemDebugger.this.getRegisterNames();
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            if (stringArray[n3].equalsIgnoreCase((String)object)) {
                                if (c == 'H') {
                                    return SystemDebugger.this.getRegisterValue(n3) >> 8;
                                }
                                return SystemDebugger.this.getRegisterValue(n3) & 0xFF;
                            }
                            ++n3;
                        }
                    }
                } else if (string.substring(0, 2).equalsIgnoreCase("HL") && (Character.toUpperCase(string.charAt(2)) == 'I' || Character.toUpperCase(string.charAt(2)) == 'D')) {
                    object = SystemDebugger.this.getRegisterNames();
                    String string2 = string.substring(0, 2);
                    n = 0;
                    while (n < ((Object)object).length) {
                        if (((String)object[n]).equalsIgnoreCase(string2)) {
                            return SystemDebugger.this.getRegisterValue(n);
                        }
                        ++n;
                    }
                }
            }
            if (string.length() == 5 && string.startsWith("bank")) {
                if ("bank0".equals(string)) {
                    return SystemDebugger.this.getBank0();
                }
                if ("bank1".equals(string)) {
                    return SystemDebugger.this.getBank1();
                }
                if ("bank2".equals(string)) {
                    return SystemDebugger.this.getBank2();
                }
                if ("bank3".equals(string)) {
                    return SystemDebugger.this.getBank3();
                }
                if ("bankS".equals(string)) {
                    return SystemDebugger.this.getSRAMbank();
                }
            }
            if ((object = (Integer)SystemDebugger.this.breakpointVariables.get(string)) != null) {
                return ((Integer)object).intValue();
            }
            if ("address".equals(string)) {
                return SystemDebugger.this.address;
            }
            if ("sram".equals(string)) {
                return !SystemDebugger.this.hasSRAM() ? -1 : (SystemDebugger.this.isSRAMenabled() ? 1 : 0);
            }
            if ("ime".equals(string) || "ie".equals(string)) {
                return SystemDebugger.this.isInterruptsEnabled() ? 1 : 0;
            }
            if ("scanline".equals(string)) {
                return SystemDebugger.this.getScanline();
            }
            if ("vaddress".equals(string)) {
                return SystemDebugger.this.getVRAMaddress();
            }
            if (SystemDebugger.this.additionalVariables != null) {
                return SystemDebugger.this.additionalVariables.getValue(string, bl);
            }
            throw new UnknownVariableException(string);
        }

        @Override
        public int readValue(int n, boolean bl, boolean bl2) {
            if (SystemDebugger.this.additionalVariables != null) {
                return SystemDebugger.this.additionalVariables.readValue(n, bl, bl2);
            }
            int n2 = n / SystemDebugger.this.getMemoryLength();
            int n3 = bl2 || n2 > 0 ? SystemDebugger.this.getByte(n & SystemDebugger.this.getMemoryLength() - 1, n2 > 0 ? n2 : -1) : SystemDebugger.this.peekByte(n);
            return bl ? (int)n3 : n3;
        }

        @Override
        public int readLocation(String string, int n, boolean bl) throws UnknownVariableException {
            if ("^".equals(string)) {
                return SystemDebugger.this.additionalVariables.readValue(n, bl, true);
            }
            if (string.isEmpty()) {
                return SystemDebugger.this.additionalVariables.readValue(n, bl, false);
            }
            if ("rom".equalsIgnoreCase(string)) {
                return SystemDebugger.this.getByte(0x4000 | n & 0x3FFF, n / 16384);
            }
            if ("ram".equalsIgnoreCase(string)) {
                return SystemDebugger.this.getRAMvalue(n & SystemDebugger.this.getRAMlength() - 1);
            }
            if ("vram".equalsIgnoreCase(string)) {
                return SystemDebugger.this.getVRAM()[n];
            }
            if ("sram".equalsIgnoreCase(string)) {
                return SystemDebugger.this.getSRAM()[n];
            }
            if (string.toLowerCase().startsWith("word")) {
                if ((string = string.substring("word".length())).length() > 1 && string.charAt(0) == '.') {
                    string = string.substring(1);
                }
                int n2 = this.readLocation(string, n + 1, false) << 8 | this.readLocation(string, n, false);
                return bl ? (int)n2 : n2;
            }
            if (string.toLowerCase().startsWith("dword")) {
                if ((string = string.substring("dword".length())).length() > 1 && string.charAt(0) == '.') {
                    string = string.substring(1);
                }
                return this.readLocation(string, n + 3, bl) << 24 | this.readLocation(string, n + 2, bl) << 16 | this.readLocation(string, n + 1, bl) << 8 | this.readLocation(string, n, bl);
            }
            if (string.toLowerCase().startsWith("beword")) {
                if ((string = string.substring("beword".length())).length() > 1 && string.charAt(0) == '.') {
                    string = string.substring(1);
                }
                int n3 = this.readLocation(string, n, false) << 8 | this.readLocation(string, n + 1, false);
                return bl ? (int)n3 : n3;
            }
            if (string.toLowerCase().startsWith("bedword")) {
                if ((string = string.substring("bedword".length())).length() > 1 && string.charAt(0) == '.') {
                    string = string.substring(1);
                }
                return this.readLocation(string, n, bl) << 24 | this.readLocation(string, n + 1, bl) << 16 | this.readLocation(string, n + 2, bl) << 8 | this.readLocation(string, n + 3, bl);
            }
            throw new UnknownVariableException(string);
        }

        @Override
        public int getBankAt(int n) {
            return SystemDebugger.this.getBank(n);
        }

        @Override
        public long mapBank(int n, int n2) {
            return (long)n2 * (long)SystemDebugger.this.getMemoryLength() | (long)n;
        }

        @Override
        public boolean isConstant(String string) throws UnknownVariableException {
            int n;
            Object object;
            if (string.length() <= 2) {
                if ("va".equalsIgnoreCase(string)) {
                    return false;
                }
                object = SystemDebugger.this.getRegisterNames();
                int n2 = 0;
                while (n2 < ((String[])object).length) {
                    if (object[n2].equalsIgnoreCase(string)) {
                        return false;
                    }
                    if (string.length() == 1 && object[n2].length() == 2) {
                        if (object[n2].substring(0, 1).equalsIgnoreCase(string)) {
                            return false;
                        }
                        if (object[n2].substring(1).equalsIgnoreCase(string)) {
                            return false;
                        }
                    }
                    ++n2;
                }
                if (string.length() == 2 && Character.toLowerCase(string.charAt(1)) == 'f') {
                    String[] stringArray = SystemDebugger.this.getFlagNames();
                    n = 0;
                    while (n < stringArray.length) {
                        if (Character.toUpperCase(string.charAt(0)) == stringArray[n].charAt(0) || stringArray[n].length() == 3 && stringArray[n].charAt(1) == '/' && Character.toUpperCase(string.charAt(0)) == stringArray[n].charAt(2)) {
                            return false;
                        }
                        ++n;
                    }
                }
            }
            if (string.length() == 3) {
                if (Character.toUpperCase(string.charAt(0)) == 'I') {
                    object = string.substring(0, 2);
                    char c = Character.toUpperCase(string.charAt(2));
                    if (c == 'H' || c == 'L') {
                        String[] stringArray = SystemDebugger.this.getRegisterNames();
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            if (stringArray[n3].equalsIgnoreCase((String)object)) {
                                if (c == 'H') {
                                    return false;
                                }
                                return false;
                            }
                            ++n3;
                        }
                    }
                } else if (string.substring(0, 2).equalsIgnoreCase("HL") && (Character.toUpperCase(string.charAt(2)) == 'I' || Character.toUpperCase(string.charAt(2)) == 'D')) {
                    object = SystemDebugger.this.getRegisterNames();
                    String string2 = string.substring(0, 2);
                    n = 0;
                    while (n < ((String[])object).length) {
                        if (object[n].equalsIgnoreCase(string2)) {
                            return false;
                        }
                        ++n;
                    }
                }
            }
            if (string.length() == 5 && string.startsWith("bank")) {
                if ("bank0".equals(string)) {
                    return false;
                }
                if ("bank1".equals(string)) {
                    return false;
                }
                if ("bank2".equals(string)) {
                    return false;
                }
                if ("bank3".equals(string)) {
                    return false;
                }
                if ("bankS".equals(string)) {
                    return false;
                }
            }
            if ((object = (Integer)SystemDebugger.this.breakpointVariables.get(string)) != null) {
                return false;
            }
            if ("address".equals(string)) {
                return false;
            }
            if ("sram".equals(string)) {
                return false;
            }
            if ("ime".equals(string) || "ie".equals(string)) {
                return false;
            }
            if ("scanline".equals(string)) {
                return false;
            }
            if ("vaddress".equals(string)) {
                return false;
            }
            if (SystemDebugger.this.additionalVariables != null) {
                return SystemDebugger.this.additionalVariables.isConstant(string);
            }
            throw new UnknownVariableException(string);
        }

        @Override
        public boolean isConstantRead(int n) {
            return SystemDebugger.this.isROMaddress(n);
        }
    };
    private final FunctionProvider functions = new FunctionProvider(){

        @Override
        public int call(String string, int[] nArray) {
            return 0;
        }

        @Override
        public boolean isConstant(String string) {
            return true;
        }

        @Override
        public boolean isBoolean(String string) {
            return false;
        }
    };
    private final Variables systemVariables;
    private final MessageHandler messageHandler;
    private final LinkedList<SystemListener> systemListenerList = new LinkedList();
    private SystemListener[] systemListeners = new SystemListener[0];
    private final LinkedList<BreakpointListener> breakpointListenerList = new LinkedList();
    private BreakpointListener[] breakpointListeners = new BreakpointListener[0];
    private final LinkedList<MessageReceiver> messageReceiverList = new LinkedList();
    private MessageReceiver[] messageReceivers = new MessageReceiver[0];

    private static Breakpoint createNullBreakpoint() {
        try {
            return new Breakpoint(null, null, null);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (UnknownVariableException unknownVariableException) {
            unknownVariableException.printStackTrace();
        }
        return null;
    }

    public SystemDebugger(DebuggableSystem debuggableSystem) {
        super(debuggableSystem);
        this.romBreakpoints = new HashMap<Breakpoint[]>(NO_BREAKPOINTS);
        this.ramBreakpoints = new HashMap<Breakpoint[]>(NO_BREAKPOINTS);
        this.sramBreakpoints = new HashMap<Breakpoint[]>(NO_BREAKPOINTS);
        this.vramBreakpoints = new HashMap<Breakpoint[]>(NO_BREAKPOINTS);
        this.portBreakpoints = new HashMap<Breakpoint[]>(NO_BREAKPOINTS);
        this.memoryLocationBreakpoints = new java.util.HashMap<String, util.map.Map<Breakpoint[]>>();
        this.stackSources = new int[this.getStackLength()];
        int n = this.getErrorCodes().length;
        this.errorBreakpointEnabled = new boolean[n];
        this.errorBreakpointSuspend = new boolean[this.errorBreakpointEnabled.length];
        this.errorBreakpointCondition = new String[this.errorBreakpointEnabled.length];
        this.errorBreakpointConditionExp = new Expression[this.errorBreakpointCondition.length];
        this.errorBreakpointMessage = new String[this.errorBreakpointEnabled.length];
        this.errorBreakpointMessageExp = new Expression[this.errorBreakpointMessage.length];
        DebuggableSystem debuggableSystem2 = debuggableSystem instanceof DebuggableSystemDecorator ? ((DebuggableSystemDecorator)debuggableSystem).getDecoratedSystem() : debuggableSystem;
        this.systemVariables = VariablesProvider.getVariables(debuggableSystem2);
        this.messageHandler = Emulicious.getMessageHandler();
        this.setDebugger(this);
        this.resetDebugger();
        this.addSystemEventListener(this);
        this.addPortListener(this.portListener);
    }

    public void setRecordCoverage(boolean bl) {
        this.recordCoverage = bl;
        if (bl) {
            if (this.coverage == null) {
                this.coverage = new long[this.getROMsize()];
                this.maxCoverage = 0L;
                this.numCoverage = 0;
                this.sumCoverage = 0L;
                this.coverageExclude = new BitSet(this.getROMsize());
            }
            if (this.ramCoverage == null) {
                this.ramCoverage = new long[this.getRAM().length];
                this.maxRamCoverage = 0L;
                this.numRamCoverage = 0;
                this.sumRamCoverage = 0L;
                this.ramCoverageExclude = new BitSet(this.getRAM().length);
            }
        }
    }

    public void clearCoverageData() {
        if (!this.recordCoverage) {
            this.coverage = null;
        }
        if (this.coverage != null) {
            Arrays.fill(this.coverage, 0L);
        }
        this.maxCoverage = 0L;
        this.numCoverage = 0;
        this.sumCoverage = 0L;
        if (this.coverageExclude != null) {
            this.coverageExclude.clear();
        }
        if (!this.recordCoverage) {
            this.ramCoverage = null;
        }
        if (this.ramCoverage != null) {
            Arrays.fill(this.ramCoverage, 0L);
        }
        this.maxRamCoverage = 0L;
        this.numRamCoverage = 0;
        this.sumRamCoverage = 0L;
        if (this.ramCoverageExclude != null) {
            this.ramCoverageExclude.clear();
        }
    }

    public boolean hasCoverageData() {
        return this.coverage != null && this.numCoverage > 0 || this.ramCoverage != null && this.numRamCoverage > 0;
    }

    public void resetROMcoverage(int n) {
        boolean bl = false;
        if (this.coverage[n] == this.maxCoverage) {
            bl = true;
        }
        this.sumCoverage -= this.coverage[n];
        this.coverage[n] = 0L;
        --this.numCoverage;
        if (bl) {
            long l = 0L;
            int n2 = 0;
            while (n2 < this.coverage.length && l < this.maxCoverage) {
                if (this.coverage[n2] > l) {
                    l = this.coverage[n2];
                }
                ++n2;
            }
        }
    }

    public void resetRAMcoverage(int n) {
        boolean bl = false;
        if (this.ramCoverage[n] == this.maxRamCoverage) {
            bl = true;
        }
        this.sumRamCoverage -= this.ramCoverage[n];
        this.ramCoverage[n] = 0L;
        --this.numRamCoverage;
        if (bl) {
            long l = 0L;
            int n2 = 0;
            while (n2 < this.ramCoverage.length && l < this.maxRamCoverage) {
                if (this.ramCoverage[n2] > l) {
                    l = this.ramCoverage[n2];
                }
                ++n2;
            }
        }
    }

    public void setExcludedFromROMcoverage(int n, boolean bl) {
        if (this.coverageExclude != null) {
            this.coverageExclude.set(n, bl);
        }
    }

    public boolean isROMcoverageExcluded(int n) {
        return n < 0 || this.coverageExclude != null && this.coverageExclude.get(n);
    }

    public void setExcludedFromRAMcoverage(int n, boolean bl) {
        if (this.ramCoverageExclude != null) {
            this.ramCoverageExclude.set(n, bl);
        }
    }

    public boolean isRAMcoverageExcluded(int n) {
        return n < 0 || this.ramCoverageExclude != null && this.ramCoverageExclude.get(n);
    }

    public long getCoverage(int n) {
        if (this.coverage == null || n < 0 || n >= this.coverage.length) {
            return 0L;
        }
        return this.coverage[n];
    }

    public long getAverageCoverage() {
        if (this.numCoverage == 0 || this.sumCoverage == 0L) {
            return 1L;
        }
        return this.sumCoverage / (long)this.numCoverage;
    }

    public long getMaxCoverage() {
        return this.maxCoverage;
    }

    public long getRamCoverage(int n) {
        if (this.ramCoverage == null || n < 0) {
            return 0L;
        }
        int n2 = this.getRAM().length - 1;
        return this.ramCoverage[n &= n2];
    }

    public long getAverageRamCoverage() {
        if (this.numRamCoverage == 0 || this.sumRamCoverage == 0L) {
            return 1L;
        }
        return this.sumRamCoverage / (long)this.numRamCoverage;
    }

    public long getMaxRamCoverage() {
        return this.maxRamCoverage;
    }

    public boolean isRecordCoverage() {
        return this.recordCoverage;
    }

    public void setAdditionalVariables(VariableProvider variableProvider) {
        this.additionalVariables = variableProvider;
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setLabelProviderRAM(LabelProvider labelProvider) {
        this.labelProviderRAM = labelProvider;
    }

    public void setLabelProviderSRAM(LabelProvider labelProvider) {
    }

    public void setLabelProviderPorts(LabelProvider labelProvider) {
        this.labelProviderPorts = labelProvider;
    }

    public boolean isMemoryLocationBreakpoint(Breakpoint breakpoint) {
        try {
            return this.isMemoryLocationBreakpoint(this.locationToString(breakpoint), breakpoint);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return false;
        }
    }

    private boolean isMemoryLocationBreakpoint(String string, Breakpoint breakpoint) {
        util.map.Map<Breakpoint[]> map = this.memoryLocationBreakpoints.get(string = string.toLowerCase());
        return map != null && SystemDebugger.hasBreakpoint(map, breakpoint);
    }

    public boolean isPortBreakpoint(Breakpoint breakpoint) {
        return SystemDebugger.hasBreakpoint(this.portBreakpoints, breakpoint);
    }

    public boolean isROMbreakpoint(Breakpoint breakpoint) {
        return SystemDebugger.hasBreakpoint(this.romBreakpoints, breakpoint);
    }

    public boolean isRAMbreakpoint(Breakpoint breakpoint) {
        return SystemDebugger.hasBreakpoint(this.ramBreakpoints, breakpoint);
    }

    public boolean isVRAMbreakpoint(Breakpoint breakpoint) {
        return SystemDebugger.hasBreakpoint(this.vramBreakpoints, breakpoint);
    }

    public boolean isSRAMbreakpoint(Breakpoint breakpoint) {
        return SystemDebugger.hasBreakpoint(this.sramBreakpoints, breakpoint);
    }

    public boolean isCpuBreakpoint(Breakpoint breakpoint) {
        return SystemDebugger.hasBreakpoint(this.memoryLocationBreakpoints.get("cpu"), breakpoint);
    }

    public static Tokenizer getTokenizer() {
        return tokenizer;
    }

    public VariableProvider getVariables() {
        return this.variables;
    }

    public Variables getSystemVariables() {
        final boolean bl = this.hasLocalVariables();
        String[] stringArray = this.systemVariables.getScopes();
        final Variable[] variableArray = this.debugFileInterpreter != null ? this.debugFileInterpreter.getVariables() : null;
        final boolean bl2 = variableArray != null && variableArray.length > 0;
        final String[] stringArray2 = new String[stringArray.length + (bl ? 2 : 1) + (bl2 ? 1 : 0)];
        int n = 0;
        if (bl) {
            stringArray2[n++] = "Locals";
        }
        if (bl2) {
            stringArray2[n++] = "Debugfile";
        }
        stringArray2[n++] = "Registers";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        final Variable[] variableArray2 = this.createRegistersVariables();
        return new Variables(){

            @Override
            public Variable[] getVariables(String string) {
                if ("Registers".equals(string)) {
                    return variableArray2;
                }
                if ("Debugfile".equals(string)) {
                    return variableArray;
                }
                if ("Locals".equals(string)) {
                    return SystemDebugger.this.getLocalVariables();
                }
                return SystemDebugger.this.systemVariables.getVariables(string);
            }

            @Override
            public Variable[] getVariables(int n) {
                if (bl) {
                    if (n == 0) {
                        return SystemDebugger.this.getLocalVariables();
                    }
                    --n;
                }
                if (bl2) {
                    if (n == 0) {
                        return variableArray;
                    }
                    --n;
                }
                if (n == 0) {
                    return variableArray2;
                }
                return SystemDebugger.this.systemVariables.getVariables(--n);
            }

            @Override
            public String[] getScopes() {
                return stringArray2;
            }
        };
    }

    boolean hasLocalVariables() {
        return Z80Disassembler.getSourceMap() instanceof EvscriptSourceMap;
    }

    Variable[] getLocalVariables() {
        SourceMap sourceMap = Z80Disassembler.getSourceMap();
        if (!(sourceMap instanceof EvscriptSourceMap)) {
            return Variable.NO_VARIABLES;
        }
        EvscriptSourceMap evscriptSourceMap = (EvscriptSourceMap)sourceMap;
        EvscriptDebugInfo.DebugLine debugLine = evscriptSourceMap.getDebugLine(this.getAddress());
        if (debugLine == null) {
            return Variable.NO_VARIABLES;
        }
        List<EvscriptDebugInfo.Variable> list = debugLine.getVariables();
        Variable[] variableArray = new Variable[list.size()];
        int n = 0;
        while (n < variableArray.length) {
            final EvscriptDebugInfo.Variable variable = list.get(n);
            variableArray[n] = new AbstractVariable(variable.getName()){

                @Override
                public String getValue() {
                    int n;
                    int n2 = SystemDebugger.this.getRegisterValue(1) + variable.getOffset();
                    if (variable.getSize() == 2) {
                        n = SystemDebugger.this.peekByte(n2 + 1) << 8 | SystemDebugger.this.peekByte(n2);
                        if (variable.isSigned()) {
                            return Short.toString((short)n);
                        }
                    } else {
                        n = SystemDebugger.this.peekByte(n2);
                        if (variable.isSigned()) {
                            return Byte.toString((byte)n);
                        }
                    }
                    return Integer.toString(n);
                }
            };
            ++n;
        }
        return variableArray;
    }

    private Variable[] createRegistersVariables() {
        final String[] stringArray = this.getRegisterNames();
        Variable[] variableArray = new Variable[stringArray.length + 2];
        int n = 0;
        while (n < stringArray.length) {
            final int n2 = n;
            variableArray[n] = new AbstractVariable(stringArray[n]){

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setValue(String string) {
                    try {
                        int n = Integer.parseInt(string.replaceAll("[^0-9A-Fa-f]", ""), 16);
                        SystemDebugger.this.setRegValue(n2, n);
                    }
                    catch (Exception exception) {}
                }

                @Override
                public String getValue() {
                    int n = SystemDebugger.this.getRegisterValue(n2);
                    return String.valueOf(HexStrings.PREFIXED_HEX_STRINGS[n >> 8].substring(1)) + HexStrings.HEX_STRINGS[n & 0xFF];
                }

                @Override
                public String getDisplayValue() {
                    String string = SystemDebugger.this.getSymbol(SystemDebugger.this.getRegisterValue(n2));
                    String string2 = this.getValue();
                    return string != null ? String.valueOf(string2) + "  (" + string + ")" : string2;
                }

                @Override
                public String getType() {
                    String string = stringArray[n2];
                    String string2 = this.getValue();
                    int n = SystemDebugger.this.getRegisterValue(n2);
                    return String.valueOf(string) + "\n" + string2 + "\n" + "%" + String.format("%8s", Integer.toBinaryString(n >> 8)).replace(' ', '0') + " " + String.format("%8s", Integer.toBinaryString(n & 0xFF)).replace(' ', '0') + "\n" + string + ": " + n + "\n" + string.substring(0, 1) + ": " + (n >> 8) + "\n" + string.substring(1, 2) + ": " + (n & 0xFF) + "\n";
                }
            };
            ++n;
        }
        variableArray[variableArray.length - 2] = this.flagsAsVariable();
        variableArray[variableArray.length - 1] = new AbstractVariable("Interrupts"){

            @Override
            public String getValue() {
                return 8.toEnabledString(SystemDebugger.this.isInterruptsEnabled());
            }
        };
        return variableArray;
    }

    private Variable flagsAsVariable() {
        StringBuilder stringBuilder = new StringBuilder();
        final String[] stringArray = this.getFlagNames();
        int n = stringArray.length - 1;
        while (n >= 0) {
            stringBuilder.append(stringArray[n]);
            if (n > 0) {
                stringBuilder.append(' ');
            }
            --n;
        }
        final StringBuilder stringBuilder2 = new StringBuilder();
        return new AbstractVariable("Flags", stringBuilder.toString()){

            @Override
            public String getValue() {
                stringBuilder2.setLength(0);
                int n = stringArray.length - 1;
                while (n >= 0) {
                    stringBuilder2.append(SystemDebugger.this.isFlagSet(n) ? stringArray[n] : "-");
                    if (n > 0) {
                        stringBuilder2.append(' ');
                    }
                    --n;
                }
                return stringBuilder2.toString();
            }
        };
    }

    public FunctionProvider getFunctions() {
        return this.functions;
    }

    public Breakpoint[] getROMbreakpoints(int n) {
        return this.romBreakpoints.get(n);
    }

    public Breakpoint[] getRAMbreakpoints(int n) {
        Breakpoint[] breakpointArray;
        if (this.isRAMaddress(n) && (breakpointArray = this.getCpuBreakpoints(n)) != null) {
            return breakpointArray;
        }
        return this.ramBreakpoints.get(n);
    }

    public Breakpoint[] getVRAMbreakpoints(int n) {
        return this.vramBreakpoints.get(n);
    }

    public Breakpoint[] getSRAMbreakpoints(int n) {
        Breakpoint[] breakpointArray;
        if (this.isSRAMaddress(n) && (breakpointArray = this.getCpuBreakpoints(n)) != null) {
            return breakpointArray;
        }
        return this.sramBreakpoints.get(n);
    }

    public Breakpoint[] getPortBreakpoints(int n) {
        return this.portBreakpoints.get(n);
    }

    public Breakpoint[] getCpuBreakpoints(int n) {
        util.map.Map<Breakpoint[]> map = this.memoryLocationBreakpoints.get("cpu");
        if (map == null) {
            return NO_BREAKPOINTS;
        }
        return map.get(n);
    }

    public Breakpoint[] getMemoryLocationBreakpoints(String string, int n) {
        util.map.Map<Breakpoint[]> map = this.memoryLocationBreakpoints.get(string = string.toLowerCase());
        if (map == null) {
            return NO_BREAKPOINTS;
        }
        return map.get(n);
    }

    private static boolean hasBreakpoint(util.map.Map<Breakpoint[]> map, Breakpoint breakpoint) {
        Breakpoint[] breakpointArray;
        if (breakpoint == null || map == null) {
            return false;
        }
        Breakpoint[] breakpointArray2 = breakpointArray = map.get(breakpoint.getAddress());
        int n = breakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Breakpoint breakpoint2 = breakpointArray2[n2];
            if (breakpoint2 == breakpoint) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String[] toBreakpointExpressions(int n, int n2, LabelProvider labelProvider) {
        int n3;
        int n4;
        List<String> list;
        if (n2 < n) {
            n2 = n;
        }
        if (labelProvider == null) {
            return new String[]{Integer.toHexString(n).toUpperCase(), Integer.toHexString(n2).toUpperCase()};
        }
        int n5 = n;
        String string = null;
        while ((n5 + 1 & 0xFFFFC000) == (n5 & 0xFFFFC000)) {
            if (labelProvider.hasLabel(n5)) {
                list = labelProvider.getLabels(n5);
                string = list != null && !list.isEmpty() ? (String)list.get(list.size() - 1) : null;
                int n6 = n4 = string != null && !string.isEmpty() && Character.isJavaIdentifierStart(string.charAt(0)) ? 0 : 1;
                if (n4 == 0) {
                    try {
                        n3 = this.breakpointAddressEvaluator.evaluate(string);
                        if (n5 == this.mapAddress(n3 & 0xFFFF, n3 >> 16, true)) {
                            break;
                        }
                    }
                    catch (ParseException parseException) {
                    }
                    catch (UnknownVariableException unknownVariableException) {}
                }
            }
            --n5;
        }
        list = string != null ? ((n4 = n - n5) > 0 ? String.valueOf(string) + " + " + n4 : string) : Integer.toHexString(n).toUpperCase();
        n = n5;
        n5 = n2;
        string = null;
        while ((n5 + 1 & 0xFFFFC000) == (n5 & 0xFFFFC000)) {
            if (labelProvider.hasLabel(n5)) {
                List<String> list2 = labelProvider.getLabels(n5);
                string = list2 != null && !list2.isEmpty() ? list2.get(list2.size() - 1) : null;
                int n7 = n3 = string != null && !string.isEmpty() && Character.isJavaIdentifierStart(string.charAt(0)) ? 0 : 1;
                if (n3 == 0) {
                    try {
                        int n8 = this.breakpointAddressEvaluator.evaluate(string);
                        if (n5 == this.mapAddress(n8 & 0xFFFF, n8 >> 16, true)) {
                            break;
                        }
                    }
                    catch (ParseException parseException) {
                    }
                    catch (UnknownVariableException unknownVariableException) {}
                }
            }
            --n5;
        }
        String string2 = string != null ? ((n3 = n2 - n5) > 0 ? String.valueOf(string) + " + " + n3 : string) : Integer.toHexString(n2).toUpperCase();
        return new String[]{list, string2};
    }

    public Breakpoint addROMbreakpoint(int n, String string, String string2) {
        try {
            return this.addROMbreakpoint(n, new Breakpoint(string, string2, this.breakpointAddressEvaluator));
        }
        catch (Exception exception) {
            return this.addBreakpoint(n, InvalidBreakpoint.create(string, string2, exception));
        }
    }

    public Breakpoint addROMbreakpoint(int n, int n2) {
        return this.addROMbreakpoint(-1, n, n2);
    }

    public Breakpoint addROMbreakpoint(int n, int n2, int n3) {
        String[] stringArray = this.toBreakpointExpressions(n2, Math.min(this.getROMsize() - 1, n2 + n3 - 1), this.labelProvider);
        try {
            if (n3 >= 4096 || !Z80Disassembler.isCode(n2) || !Z80Disassembler.isCode(n2 + n3 - 1)) {
                return this.addROMbreakpoint(n, new Watchpoint(stringArray[0], stringArray[1], this.breakpointAddressEvaluator));
            }
            return this.addROMbreakpoint(n, new Breakpoint(stringArray[0], stringArray[1], this.breakpointAddressEvaluator));
        }
        catch (Exception exception) {
            return this.addBreakpoint(n, InvalidBreakpoint.create(stringArray[0], stringArray[1], exception));
        }
    }

    public Breakpoint addROMbreakpoint(Breakpoint breakpoint) {
        return this.addROMbreakpoint(-1, breakpoint);
    }

    public Breakpoint addROMbreakpoint(int n, Breakpoint breakpoint) {
        if (breakpoint.isVirtualAddress()) {
            if (!this.isROMaddress(breakpoint.getAddress() & 0xFFFF, true)) {
                throw new IllegalArgumentException(String.format("Breakpoint address $%04X is not a ROM address.", breakpoint.getAddress() & 0xFFFF));
            }
            if (!this.isROMaddress(breakpoint.getEnd() & 0xFFFF, true)) {
                throw new IllegalArgumentException(String.format("End address $%04X is not a ROM address.", breakpoint.getEnd() & 0xFFFF));
            }
        }
        this.ensureValidBreakpoint(breakpoint, this.getROMsize());
        return this.addBreakpoint(n, this.romBreakpoints, breakpoint);
    }

    public Breakpoint addWatchpoint(int n, String string, String string2) {
        try {
            return this.addMemoryLocationBreakpoint("cpu", n, new Watchpoint(string, string2, this.breakpointAddressEvaluator));
        }
        catch (Exception exception) {
            return this.addBreakpoint(n, InvalidBreakpoint.create(string, string2, exception));
        }
    }

    public Breakpoint addRAMbreakpoint(int n, int n2) {
        return this.addRAMbreakpoint(-1, n, n2);
    }

    public Breakpoint addRAMbreakpoint(int n, int n2, int n3) {
        String[] stringArray = this.toBreakpointExpressions(n2, Math.min(this.getMemoryLength() - 1, n2 + n3 - 1), this.labelProviderRAM);
        try {
            return this.addRAMbreakpoint(n, new Watchpoint(stringArray[0], stringArray[1], this.breakpointAddressEvaluator));
        }
        catch (Exception exception) {
            return this.addBreakpoint(n, InvalidBreakpoint.create(stringArray[0], stringArray[1], exception));
        }
    }

    private Breakpoint addRAMbreakpoint(Breakpoint breakpoint) {
        return this.addRAMbreakpoint(-1, breakpoint);
    }

    private Breakpoint addRAMbreakpoint(int n, Breakpoint breakpoint) {
        this.ensureValidBreakpoint(breakpoint, this.getRAMlength());
        return this.addBreakpoint(n, this.ramBreakpoints, breakpoint);
    }

    public Breakpoint addVRAMbreakpoint(int n, int n2) {
        return this.addVRAMbreakpoint(-1, n, n2);
    }

    public Breakpoint addVRAMbreakpoint(int n, int n2, int n3) {
        String[] stringArray = this.toBreakpointExpressions(n2, Math.min(this.getVRAM().length - 1, n2 + n3 - 1), null);
        try {
            return this.addVRAMbreakpoint(n, new Watchpoint(stringArray[0], stringArray[1], this.breakpointAddressEvaluator));
        }
        catch (Exception exception) {
            return this.addBreakpoint(n, InvalidBreakpoint.create(stringArray[0], stringArray[1], exception));
        }
    }

    private Breakpoint addVRAMbreakpoint(Breakpoint breakpoint) {
        return this.addVRAMbreakpoint(-1, breakpoint);
    }

    private Breakpoint addVRAMbreakpoint(int n, Breakpoint breakpoint) {
        this.ensureValidBreakpoint(breakpoint, this.getVRAM().length);
        return this.addBreakpoint(n, this.vramBreakpoints, breakpoint);
    }

    public Breakpoint addSRAMbreakpoint(int n, int n2) {
        return this.addSRAMbreakpoint(-1, n, n2);
    }

    public Breakpoint addSRAMbreakpoint(int n, int n2, int n3) {
        String[] stringArray = this.toBreakpointExpressions(n2, Math.min(this.getSRAM().length - 1, n2 + n3 - 1), this.labelProviderSRAM);
        try {
            return this.addSRAMbreakpoint(n, new Watchpoint(stringArray[0], stringArray[1], this.breakpointAddressEvaluator));
        }
        catch (Exception exception) {
            return this.addBreakpoint(n, InvalidBreakpoint.create(stringArray[0], stringArray[1], exception));
        }
    }

    private Breakpoint addSRAMbreakpoint(Breakpoint breakpoint) {
        return this.addSRAMbreakpoint(-1, breakpoint);
    }

    private Breakpoint addSRAMbreakpoint(int n, Breakpoint breakpoint) {
        this.ensureValidBreakpoint(breakpoint, this.getMemoryLength());
        return this.addBreakpoint(n, this.sramBreakpoints, breakpoint);
    }

    public Breakpoint addPortBreakpoint(int n, int n2) {
        return this.addPortBreakpoint(-1, n, n2);
    }

    public Breakpoint addPortBreakpoint(int n, int n2, int n3) {
        String[] stringArray = this.toBreakpointExpressions(n2, Math.min(this.getNumberOfPorts() - 1, n2 + n3 - 1), this.labelProviderPorts);
        try {
            return this.addPortBreakpoint(n, new Watchpoint(stringArray[0], stringArray[1], this.breakpointAddressEvaluator));
        }
        catch (Exception exception) {
            return this.addBreakpoint(n, InvalidBreakpoint.create(stringArray[0], stringArray[1], exception));
        }
    }

    public Breakpoint addPortBreakpoint(Breakpoint breakpoint) {
        return this.addPortBreakpoint(-1, breakpoint);
    }

    public Breakpoint addPortBreakpoint(int n, Breakpoint breakpoint) {
        this.ensureValidBreakpoint(breakpoint, this.getNumberOfPorts());
        return this.addBreakpoint(n, this.portBreakpoints, breakpoint);
    }

    public Breakpoint addMemoryLocationBreakpoint(String string, int n, int n2) {
        return this.addMemoryLocationBreakpoint(string, -1, n, n2);
    }

    public Breakpoint addMemoryLocationBreakpoint(String string, int n, int n2, int n3) {
        String[] stringArray = this.toBreakpointExpressions(n2, n2 + n3 - 1, null);
        try {
            return this.addMemoryLocationBreakpoint(string, n, new Watchpoint(stringArray[0], stringArray[1], this.breakpointAddressEvaluator));
        }
        catch (Exception exception) {
            return this.addBreakpoint(n, InvalidBreakpoint.create(stringArray[0], stringArray[1], exception));
        }
    }

    public Breakpoint addWatchpoint(int n, int n2, String string, String string2, String string3, String string4, boolean bl, boolean bl2) throws ParseException, UnknownVariableException {
        return this.addWatchpoint(n, n2, new Watchpoint(string, !string2.isEmpty() ? string2 : "-1", this.breakpointAddressEvaluator, true, true, bl, bl2, string3, string4));
    }

    private Breakpoint addWatchpoint(int n, int n2, Watchpoint watchpoint) {
        switch (n) {
            case 0: {
                return this.addMemoryLocationBreakpoint("cpu", n2, watchpoint);
            }
            case 1: {
                return this.addROMbreakpoint(n2, watchpoint);
            }
            case 2: {
                return this.addRAMbreakpoint(n2, watchpoint);
            }
            case 3: {
                return this.addVRAMbreakpoint(n2, watchpoint);
            }
            case 4: {
                return this.addSRAMbreakpoint(n2, watchpoint);
            }
            case 5: {
                return this.addPortBreakpoint(n2, watchpoint);
            }
            case 6: {
                return this.addMemoryLocationBreakpoint("palettes", n2, watchpoint);
            }
        }
        return this.addMemoryLocationBreakpoint(this.getAdditionalMemoryLocationName(n - 7), n2, watchpoint);
    }

    public String[] getBreakpointLocationNames() {
        String[] stringArray = new String[7 + this.getNumberOfAdditionalMemoryLocations()];
        stringArray[0] = "CPU";
        stringArray[1] = "ROM";
        stringArray[2] = "RAM";
        stringArray[3] = "VRAM";
        stringArray[4] = "SRAM";
        stringArray[5] = "Ports";
        stringArray[6] = "Palettes";
        int n = 7;
        while (n < stringArray.length) {
            stringArray[n] = this.getAdditionalMemoryLocationName(n - 7);
            ++n;
        }
        return stringArray;
    }

    public int indexOfBreakpointLocationAt(int n) {
        String string = this.getAdditionalMemoryLocationAt(n);
        if (string != null) {
            string = string.toUpperCase();
            int n2 = this.getNumberOfAdditionalMemoryLocations() - 1;
            while (n2 >= 0) {
                if (string.equals(this.getAdditionalMemoryLocationName(n2))) {
                    return 7 + n2;
                }
                --n2;
            }
        }
        if (this.isSRAMaddress(n)) {
            return 4;
        }
        if (this.isVRAMaddress(n)) {
            return 3;
        }
        if (this.isRAMaddress(n)) {
            return 2;
        }
        if (this.isROMaddress(n)) {
            return 1;
        }
        return 0;
    }

    public Breakpoint addMemoryLocationBreakpoint(String string, Breakpoint breakpoint) {
        return this.addMemoryLocationBreakpoint(string, -1, breakpoint);
    }

    public Breakpoint addMemoryLocationBreakpoint(String string, int n, Breakpoint breakpoint) {
        if ("palettes".equals(string = string.toLowerCase())) {
            this.ensureValidBreakpoint(breakpoint, this.getNumberOfPaletteBytes());
        } else if ("cpu".equals(string)) {
            if (breakpoint.isVirtualAddress()) {
                breakpoint = breakpoint.moveBankToCondition(this.getMemoryLength());
            }
            this.ensureValidBreakpoint(breakpoint, this.getMemoryLength());
        } else {
            boolean bl = false;
            int n2 = 0;
            while (!bl && n2 < this.getNumberOfAdditionalMemoryLocations()) {
                if (this.getAdditionalMemoryLocationName(n2).equalsIgnoreCase(string)) {
                    this.ensureValidBreakpoint(breakpoint, this.getAdditionalMemoryLocationLength(n2));
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                this.ensureValidBreakpoint(breakpoint, this.getMemoryLength());
            }
        }
        util.map.Map<Breakpoint[]> map = this.memoryLocationBreakpoints.get(string);
        if (map == null) {
            map = new HashMap<Breakpoint[]>(NO_BREAKPOINTS);
            this.memoryLocationBreakpoints.put(string, map);
        }
        return this.addBreakpoint(n, map, breakpoint);
    }

    private void ensureValidBreakpoint(Breakpoint breakpoint, int n) {
        if (breakpoint != null) {
            int n2;
            int n3;
            if (breakpoint.isVirtualAddress()) {
                n3 = this.mapAddress(breakpoint.getAddress() & 0xFFFF, breakpoint.getAddress() >> 16, true);
                n2 = this.mapAddress(breakpoint.getEnd() & 0xFFFF, breakpoint.getEnd() >> 16, true);
            } else {
                n3 = breakpoint.getAddress();
                n2 = breakpoint.getEnd();
            }
            if (n3 >= n) {
                throw new IllegalArgumentException("Address must be less than $" + Integer.toHexString(n));
            }
            if (n2 >= n) {
                throw new IllegalArgumentException("End address must be less than $" + Integer.toHexString(n));
            }
            if (n2 < n3) {
                throw new IllegalArgumentException("End address must be greater or equal to start address.");
            }
        }
    }

    private Breakpoint addBreakpoint(int n, util.map.Map<Breakpoint[]> map, Breakpoint breakpoint) {
        int n2;
        if (breakpoint == null) {
            return null;
        }
        if (breakpoint.isVirtualAddress()) {
            if (map != this.memoryLocationBreakpoints.get("cpu")) {
                n2 = this.mapAddress(breakpoint.getAddress() & 0xFFFF, breakpoint.getAddress() >> 16, true);
                int n3 = this.mapAddress(breakpoint.getEnd() & 0xFFFF, breakpoint.getEnd() >> 16, true);
                breakpoint = breakpoint.newInstance(n2, n3);
            } else {
                breakpoint = breakpoint.newInstance(breakpoint.getAddress(), breakpoint.getEnd());
            }
        }
        if (this.isRAMaddress(breakpoint.getAddress()) && map == this.ramBreakpoints || this.isSRAMaddress(breakpoint.getAddress()) && map == this.sramBreakpoints || this.isVRAMaddress(breakpoint.getAddress()) && map == this.vramBreakpoints) {
            return this.addMemoryLocationBreakpoint("cpu", n, breakpoint);
        }
        n2 = breakpoint.getAddress();
        while (n2 >= 0 && n2 <= breakpoint.getEnd()) {
            Breakpoint[] breakpointArray = map.get(n2);
            breakpointArray = Arrays.copyOf(breakpointArray, breakpointArray.length + 1);
            breakpointArray[breakpointArray.length - 1] = breakpoint;
            map.put(n2, breakpointArray);
            ++n2;
        }
        return this.addBreakpoint(n, breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Breakpoint addBreakpoint(int n, Breakpoint breakpoint) {
        List<Breakpoint> list = this.breakpoints;
        synchronized (list) {
            if (n >= 0) {
                this.breakpoints.add(n, breakpoint);
            } else {
                this.breakpoints.add(breakpoint);
            }
        }
        this.fireBreakpointAdded(breakpoint);
        return breakpoint;
    }

    public void toggleROMbreakpoint(int n, int n2) {
        if (n >= 0) {
            Breakpoint[] breakpointArray = this.getROMbreakpoints(n);
            int n3 = 1;
            while (n3 < n2 && breakpointArray.length == 0) {
                breakpointArray = this.getROMbreakpoints(n + n3);
                ++n3;
            }
            if (breakpointArray.length > 0) {
                this.removeBreakpoints(breakpointArray);
            } else {
                this.addROMbreakpoint(n, n2);
            }
        }
    }

    public void toggleRAMbreakpoint(int n, int n2) {
        if (n >= 0) {
            Breakpoint[] breakpointArray = this.getRAMbreakpoints(n);
            int n3 = 1;
            while (n3 < n2 && breakpointArray.length == 0) {
                breakpointArray = this.getRAMbreakpoints(n + n3);
                ++n3;
            }
            if (breakpointArray.length > 0) {
                this.removeBreakpoints(breakpointArray);
            } else {
                this.addRAMbreakpoint(n, n2);
            }
        }
    }

    public void toggleVRAMbreakpoint(int n, int n2) {
        if (n >= 0) {
            Breakpoint[] breakpointArray = this.getVRAMbreakpoints(n);
            int n3 = 1;
            while (n3 < n2 && breakpointArray.length == 0) {
                breakpointArray = this.getVRAMbreakpoints(n + n3);
                ++n3;
            }
            if (breakpointArray.length > 0) {
                this.removeBreakpoints(breakpointArray);
            } else {
                this.addVRAMbreakpoint(n, n2);
            }
        }
    }

    public void toggleSRAMbreakpoint(int n, int n2) {
        if (n >= 0) {
            Breakpoint[] breakpointArray = this.getSRAMbreakpoints(n);
            int n3 = 1;
            while (n3 < n2 && breakpointArray.length == 0) {
                breakpointArray = this.getSRAMbreakpoints(n + n3);
                ++n3;
            }
            if (breakpointArray.length > 0) {
                this.removeBreakpoints(breakpointArray);
            } else {
                this.addSRAMbreakpoint(n, n2);
            }
        }
    }

    public void togglePortBreakpoint(int n, int n2) {
        if (n >= 0) {
            Breakpoint[] breakpointArray = this.getPortBreakpoints(n);
            int n3 = 1;
            while (n3 < n2 && breakpointArray.length == 0) {
                breakpointArray = this.getPortBreakpoints(n + n3);
                ++n3;
            }
            if (breakpointArray.length > 0) {
                this.removeBreakpoints(breakpointArray);
            } else {
                this.addPortBreakpoint(n, n2);
            }
        }
    }

    public Breakpoint toggleMemoryLocationBreakpoint(String string, int n, int n2) {
        if (n >= 0) {
            Breakpoint[] breakpointArray = this.getMemoryLocationBreakpoints(string, n);
            int n3 = 1;
            while (n3 < n2 && breakpointArray.length == 0) {
                breakpointArray = this.getMemoryLocationBreakpoints(string, n + n3);
                ++n3;
            }
            if (breakpointArray.length <= 0) {
                return this.addMemoryLocationBreakpoint(string, n, n2);
            }
            this.removeBreakpoints(breakpointArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBreakpoints() {
        List<Breakpoint> list = this.breakpoints;
        synchronized (list) {
            this.breakpoints.clear();
        }
        this.romBreakpoints.clear();
        this.ramBreakpoints.clear();
        this.sramBreakpoints.clear();
        this.vramBreakpoints.clear();
        this.portBreakpoints.clear();
        this.memoryLocationBreakpoints.clear();
        this.breakpointConditions.clear();
        this.breakpointMessages.clear();
        this.fireBreakpointsCleared();
    }

    public void removeBreakpoints(Breakpoint[] breakpointArray) {
        Breakpoint[] breakpointArray2 = breakpointArray;
        int n = breakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Breakpoint breakpoint = breakpointArray2[n2];
            this.removeBreakpoint(breakpoint, false);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeBreakpoint(Breakpoint breakpoint, boolean bl) {
        List<Breakpoint> list = this.breakpoints;
        synchronized (list) {
            int n = this.breakpoints.indexOf(breakpoint);
            if (breakpoint instanceof InvalidBreakpoint) {
                this.breakpoints.remove(n);
                this.fireBreakpointRemoved(breakpoint, n, bl);
            } else if (this.isPortBreakpoint(breakpoint)) {
                this.removePortBreakpoint(breakpoint, bl);
            } else if (this.isROMbreakpoint(breakpoint)) {
                this.removeROMbreakpoint(breakpoint, bl);
            } else if (this.isRAMbreakpoint(breakpoint)) {
                this.removeRAMbreakpoint(breakpoint, bl);
            } else if (this.isVRAMbreakpoint(breakpoint)) {
                this.removeVRAMbreakpoint(breakpoint, bl);
            } else if (this.isSRAMbreakpoint(breakpoint)) {
                this.removeSRAMbreakpoint(breakpoint, bl);
            } else if (this.isMemoryLocationBreakpoint(breakpoint)) {
                this.removeMemoryLocationBreakpoint(breakpoint, bl);
            }
            this.breakpointConditions.remove(breakpoint);
            return n;
        }
    }

    private void removeROMbreakpoint(Breakpoint breakpoint, boolean bl) {
        this.removeBreakpoint(this.romBreakpoints, breakpoint, bl);
    }

    private void removeRAMbreakpoint(Breakpoint breakpoint, boolean bl) {
        this.removeBreakpoint(this.ramBreakpoints, breakpoint, bl);
    }

    private void removeVRAMbreakpoint(Breakpoint breakpoint, boolean bl) {
        this.removeBreakpoint(this.vramBreakpoints, breakpoint, bl);
    }

    private void removeSRAMbreakpoint(Breakpoint breakpoint, boolean bl) {
        this.removeBreakpoint(this.sramBreakpoints, breakpoint, bl);
    }

    private void removePortBreakpoint(Breakpoint breakpoint, boolean bl) {
        this.removeBreakpoint(this.portBreakpoints, breakpoint, bl);
    }

    private void removeMemoryLocationBreakpoint(Breakpoint breakpoint, boolean bl) {
        this.removeBreakpoint(this.memoryLocationBreakpoints.get(this.locationToString(breakpoint)), breakpoint, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBreakpoint(util.map.Map<Breakpoint[]> map, Breakpoint breakpoint, boolean bl) {
        int n = breakpoint.getAddress();
        while (n >= 0 && n <= breakpoint.getEnd()) {
            Breakpoint[] breakpointArray = map.get(n);
            if (breakpointArray.length == 1) {
                if (breakpointArray[0] == breakpoint) {
                    map.remove(n);
                }
            } else {
                int n2 = 0;
                while (n2 < breakpointArray.length) {
                    if (breakpointArray[n2] == breakpoint) {
                        if (n2 == breakpointArray.length - 1) {
                            map.put(n, Arrays.copyOf(breakpointArray, breakpointArray.length - 1));
                            break;
                        }
                        if (n2 == 0) {
                            map.put(n, Arrays.copyOfRange(breakpointArray, 1, breakpointArray.length));
                            break;
                        }
                        Breakpoint[] breakpointArray2 = new Breakpoint[breakpointArray.length - 1];
                        map.put(n, breakpointArray2);
                        System.arraycopy(breakpointArray, 0, breakpointArray2, 0, n2);
                        System.arraycopy(breakpointArray, n2 + 1, breakpointArray2, n2, breakpointArray2.length - n2);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        List<Breakpoint> list = this.breakpoints;
        synchronized (list) {
            int n3 = this.breakpoints.indexOf(breakpoint);
            this.breakpoints.remove(n3);
            this.fireBreakpointRemoved(breakpoint, n3, bl);
        }
    }

    public void setBreakpointEnabled(Breakpoint breakpoint, boolean bl) {
        breakpoint.setEnabled(bl);
        this.fireBreakpointChanged(breakpoint);
    }

    public void setBreakpointSuspend(Breakpoint breakpoint, boolean bl) {
        breakpoint.setSuspend(bl);
        this.fireBreakpointChanged(breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Breakpoint setBreakpointAddress(Breakpoint breakpoint, String string, String string2) {
        if (!(breakpoint == null || string.equals(breakpoint.getAddressString()) && string2.equals(breakpoint.getEndString()))) {
            List<Breakpoint> list = this.breakpoints;
            synchronized (list) {
                int n = this.breakpoints.indexOf(breakpoint);
                Breakpoint breakpoint2 = breakpoint.newInstance(string, string2, this.breakpointAddressEvaluator);
                try {
                    if (this.isPortBreakpoint(breakpoint)) {
                        this.removeBreakpoint(breakpoint, true);
                        this.addPortBreakpoint(n, breakpoint2);
                    } else if (this.isROMbreakpoint(breakpoint)) {
                        this.removeBreakpoint(breakpoint, true);
                        this.addROMbreakpoint(n, breakpoint2);
                    } else if (this.isRAMbreakpoint(breakpoint)) {
                        this.removeBreakpoint(breakpoint, true);
                        this.addRAMbreakpoint(n, breakpoint2);
                    } else if (this.isVRAMbreakpoint(breakpoint)) {
                        this.removeBreakpoint(breakpoint, true);
                        this.addVRAMbreakpoint(n, breakpoint2);
                    } else if (this.isSRAMbreakpoint(breakpoint)) {
                        this.removeBreakpoint(breakpoint, true);
                        this.addSRAMbreakpoint(n, breakpoint2);
                    } else if (this.isMemoryLocationBreakpoint(breakpoint)) {
                        String string3 = this.locationToString(breakpoint);
                        this.removeBreakpoint(breakpoint, true);
                        this.addMemoryLocationBreakpoint(string3, n, breakpoint2);
                    }
                }
                catch (Exception exception) {
                    InvalidBreakpoint invalidBreakpoint = InvalidBreakpoint.create(string, string2, exception);
                    if (n >= 0) {
                        this.breakpoints.add(n, invalidBreakpoint);
                    } else {
                        this.breakpoints.add(invalidBreakpoint);
                    }
                    this.fireBreakpointAdded(invalidBreakpoint);
                    return invalidBreakpoint;
                }
                return breakpoint2;
            }
        }
        return breakpoint;
    }

    public void setBreakpointCondition(Breakpoint breakpoint, String string) throws ParseException, UnknownVariableException, IsConstantException {
        breakpoint.setCondition(string);
        this.breakpointConditions.remove(breakpoint);
        if (!string.isEmpty()) {
            try {
                Expression expression;
                boolean bl;
                if (breakpoint instanceof Watchpoint) {
                    if (this.isPortBreakpoint(breakpoint)) {
                        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_PORT, breakpoint.getAddress());
                    } else {
                        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OLDVALUE, 0);
                    }
                    this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_VALUE, 0);
                    this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, breakpoint.getAddress());
                    this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OPERATION, 0);
                    this.breakpointVariables.put(VARIABLE_NAME_BRANCH_DESTINATION, -1);
                }
                if (bl = (expression = new Expression(string, tokenizer).optimize(this.getVariables(), this.functions)).isConstant(this.getVariables(), this.functions)) {
                    throw new IsConstantException(expression.isTrue(this.getVariables(), this.functions) ? "true" : "false");
                }
                this.breakpointConditions.put(breakpoint, expression);
            }
            finally {
                this.breakpointVariables.clear();
            }
        }
        this.fireBreakpointChanged(breakpoint);
    }

    public void setBreakpointMessage(Breakpoint breakpoint, String string) throws ParseException, UnknownVariableException {
        breakpoint.setMessage(string);
        this.breakpointMessages.remove(breakpoint);
        if (!string.isEmpty()) {
            try {
                if (breakpoint instanceof Watchpoint) {
                    if (this.isPortBreakpoint(breakpoint)) {
                        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_PORT, breakpoint.getAddress());
                    } else {
                        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OLDVALUE, 0);
                    }
                    this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_VALUE, 0);
                    this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, breakpoint.getAddress());
                }
                Expression expression = new ConcatenatedExpression(string, tokenizer).optimize(this.getVariables(), this.functions);
                this.breakpointMessages.put(breakpoint, expression);
            }
            finally {
                this.breakpointVariables.clear();
            }
        }
        this.fireBreakpointChanged(breakpoint);
    }

    public void setWatchpointRead(Watchpoint watchpoint, boolean bl) {
        watchpoint.setRead(bl);
        this.fireBreakpointChanged(watchpoint);
    }

    public void setWatchpointWrite(Watchpoint watchpoint, boolean bl) {
        watchpoint.setWrite(bl);
        this.fireBreakpointChanged(watchpoint);
    }

    public boolean isBreakpointConditionMet(Breakpoint breakpoint) {
        VariableProvider variableProvider;
        if (breakpoint.getCondition().isEmpty()) {
            return true;
        }
        Expression expression = breakpoint.getConditionExpression() != null ? breakpoint.getConditionExpression() : this.breakpointConditions.get(breakpoint);
        VariableProvider variableProvider2 = variableProvider = breakpoint.getVariables() != null ? breakpoint.getVariables() : this.getVariables();
        if (expression == null) {
            try {
                expression = new Expression(breakpoint.getCondition(), tokenizer).optimize(variableProvider, this.functions);
                if (expression.isConstant(variableProvider, this.functions)) {
                    throw new IsConstantException(expression.getValueString(variableProvider, this.functions));
                }
                this.breakpointConditions.put(breakpoint, expression);
            }
            catch (ParseException parseException) {
                this.breakpointMessage = parseException.getMessage();
                this.breakpointConditions.remove(breakpoint);
                return true;
            }
            catch (UnknownVariableException unknownVariableException) {
                this.breakpointMessage = unknownVariableException.getMessage();
                this.breakpointConditions.remove(breakpoint);
                return true;
            }
            catch (IsConstantException isConstantException) {
                this.breakpointMessage = isConstantException.getMessage();
                this.breakpointConditions.remove(breakpoint);
                return true;
            }
        }
        try {
            return expression.isTrue(variableProvider, this.functions, breakpoint.isConditionSigned());
        }
        catch (UnknownVariableException unknownVariableException) {
            this.breakpointMessage = unknownVariableException.getMessage();
            return true;
        }
    }

    public int getNumberOfBreakpoints() {
        return this.getBreakpoints().size();
    }

    public List<Breakpoint> getBreakpoints() {
        return this.breakpoints;
    }

    public void setSkipBreakpoints(boolean bl) {
        this.skipBreakpoints = bl;
    }

    public boolean isSkipBreakpoints() {
        return this.skipBreakpoints;
    }

    private boolean isBreakpointEnabled(Breakpoint breakpoint) {
        return !this.skipBreakpoints && breakpoint.isEnabled();
    }

    public void setSkipExceptions(boolean bl) {
        this.skipExceptions = bl;
    }

    public boolean isSkipExceptions() {
        return this.skipExceptions;
    }

    public boolean isSuspended() {
        return this.suspended && Emulicious.isRunning() && !this.shouldStepBack && !this.shouldStepBackOver && !this.shouldStepBackReturn;
    }

    public void setSuspendOnMappedLinesOnly(boolean bl) {
        this.suspendOnMappedLinesOnly = bl;
        if (bl && !SystemDebugger.isSourceMapped(this.address)) {
            this.suspendOnNextMappedLine = this.suspended;
            this.suspended = false;
        }
    }

    public boolean isSuspendOnMappedLinesOnly() {
        return this.suspendOnMappedLinesOnly;
    }

    public void resume() {
        this.resume(null);
    }

    public void resume(String string) {
        this.resume(string, false);
    }

    private void resume(String string, boolean bl) {
        Emulicious.startSound();
        this.breakpointHit = null;
        this.breakpointMessage = null;
        this.breakpointVariables.clear();
        this.fireBreakpointHitCleared();
        if (string != null) {
            this.addAction(new Action(string, this.getState().clone()));
        }
        this.suspendOnNextMappedLine = false;
        this.stepping = bl;
        this.stepOverVirtualAddress = -1;
        this.runToAddress = -1;
        this.runToVirtualAddress = -1;
        this.runToScanline = -1;
        this.suspended = false;
    }

    public void stepInto() {
        if (this.isSuspended()) {
            this.resume("Step Into", true);
        }
    }

    public boolean canStepBack() {
        long l;
        if (!this.isSuspended()) {
            return false;
        }
        long l2 = l = this.isSuspendOnMappedLinesOnly() ? this.prevMappedInstructionExecutedCycles : this.prevInstructionExecutedCycles;
        return this.stateBuffer.indexOf(l) >= 0;
    }

    public void stepBack() {
        this.addAction(new Action("Step Back", this.getState().clone()));
        if (this.address == this.mapToRomAddress(this.getPC())) {
            this.doStepBack();
        } else {
            this.shouldStepBack = true;
        }
    }

    private void doStepBack() {
        if (this.isSuspended()) {
            long l = this.isSuspendOnMappedLinesOnly() ? this.prevMappedInstructionExecutedCycles : this.prevInstructionExecutedCycles;
            this.rewindTo(l);
        }
    }

    public boolean canStepBackReturn() {
        if (!this.isSuspended() || this.isSuspendOnMappedLinesOnly()) {
            return false;
        }
        return !this.callInstructionExecutedCycles.isEmpty() && this.stateBuffer.indexOf(this.callInstructionExecutedCycles.peek()) >= 0;
    }

    public void stepBackReturn() {
        this.addAction(new Action("Step Back Return", this.getState().clone()));
        if (this.address == this.mapToRomAddress(this.getPC())) {
            this.doStepBackReturn();
        } else {
            this.shouldStepBackReturn = true;
        }
    }

    private void doStepBackReturn() {
        if (this.isSuspended() && !this.isSuspendOnMappedLinesOnly() && !this.callInstructionExecutedCycles.isEmpty()) {
            this.rewindTo(this.callInstructionExecutedCycles.peek());
        }
    }

    public boolean canStepBackOver() {
        if (!this.isSuspended() || this.isSuspendOnMappedLinesOnly()) {
            return false;
        }
        return this.canStepBack();
    }

    public void stepBackOver() {
        this.addAction(new Action("Step Back Over", this.getState().clone()));
        if (this.address == this.mapToRomAddress(this.getPC())) {
            this.doStepBackOver();
        } else {
            this.shouldStepBackOver = true;
        }
    }

    private void doStepBackOver() {
        if (this.isSuspended() && !this.isSuspendOnMappedLinesOnly()) {
            int n = this.getPC();
            int n2 = this.getSP();
            this.doStepBack();
            int n3 = this.getPC();
            if (this.canStepBackReturn() && this.getSP() != n2 && (n3 > n || n3 < n - 1)) {
                this.doStepBackReturn();
            }
        }
    }

    private void rewindTo(long l) {
        int n = this.stateBuffer.indexOf(l);
        if (n >= 0) {
            StateContainer stateContainer = this.stateBuffer.get(n);
            int n2 = this.inputStack.indexOf(l);
            long l2 = this.inputStack.getCycles(n2 + 1);
            this.stateBuffer.dropStatesAfter(l);
            this.breakpointHit = null;
            this.breakpointMessage = null;
            this.breakpointVariables.clear();
            this.fireBreakpointHitCleared();
            this.suspendOnNextMappedLine = false;
            this.stepping = false;
            this.stepOverVirtualAddress = -1;
            this.runToAddress = -1;
            this.runToVirtualAddress = -1;
            this.runToScanline = -1;
            Emulicious.setFreezeImage(true);
            super.setDebugger(null);
            super.removePortListener(this.portListener);
            this.removeSystemEventListener(this);
            super.setState(stateContainer.getState(), false, true);
            this.address = this.mapToRomAddress(this.getPC());
            this.executedCycles = stateContainer.getCycles();
            this.prevInstructionExecutedCycles = stateContainer.getPrevInstructionExecutedCycles();
            this.prevMappedInstructionExecutedCycles = stateContainer.getPrevMappedInstructionExecutedCycles();
            while (!this.callInstructionExecutedCycles.isEmpty() && this.callInstructionExecutedCycles.peek() >= l) {
                this.callInstructionExecutedCycles.pop();
            }
            if (n2 >= 0) {
                this.setInputState(this.inputStack.getInputState(n2));
            }
            long l3 = l - this.executedCycles;
            while (l3 > 0L) {
                int n3;
                int n4 = this.getPC();
                int n5 = this.getSP();
                if (!this.isHalted()) {
                    this.prevInstructionExecutedCycles = this.executedCycles;
                }
                if (SystemDebugger.isSourceMapped(this.mapToRomAddress(this.getPC()))) {
                    this.prevMappedInstructionExecutedCycles = this.prevInstructionExecutedCycles;
                }
                int n6 = -super.executeOnce(0);
                l3 -= (long)n6;
                int n7 = this.getSP();
                if (n7 != n5) {
                    n3 = this.peekByte(n7 + 1) << 8 | this.peekByte(n7);
                    if (n3 == n4 + 3 || n3 == n4 + 1 || n3 == n4) {
                        this.callInstructionExecutedCycles.push(this.prevInstructionExecutedCycles);
                    } else {
                        int n8 = this.peekByte(n7 - 1) << 8 | this.peekByte(n7 - 2);
                        if (n8 == this.getPC() && !this.callInstructionExecutedCycles.isEmpty()) {
                            this.callInstructionExecutedCycles.pop();
                        }
                    }
                }
                this.updateTrace();
                n3 = this.getPC();
                this.address = this.mapToRomAddress(n3);
                this.executedCycles += (long)n6;
                if (this.address == this.runBackToAddress || this.runBackToVirtualAddress >= 0 && this.getVirtualAddress() == this.runBackToVirtualAddress) {
                    this.cyclesRunBackToAddress = this.executedCycles;
                }
                if (this.executedCycles < l2) continue;
                this.setInputState(this.inputStack.getInputState(++n2));
                l2 = this.inputStack.getCycles(n2 + 1);
            }
            this.setInputState(this.inputStack.getInputState(++n2));
            this.inputStack.dropInputAfter(this.executedCycles);
            if (this.isSuspendOnMappedLinesOnly() && !SystemDebugger.isSourceMapped(this.mapToRomAddress(this.getPC()))) {
                this.undo();
            }
            super.setDebugger(this);
            super.addPortListener(this.portListener);
            this.addSystemEventListener(this);
            this.prevScanline = this.getScanline();
            this.suspended = true;
            this.syncLazyState();
            this.requestGUIupdate();
            Emulicious.setFreezeImage(false);
        }
    }

    public synchronized void stepOver() {
        if (this.isSuspended()) {
            if (this.canStepOver()) {
                this.resume("Step Over");
                this.stepOverVirtualAddress = this.getVirtualAddress();
            } else {
                this.stepInto();
            }
        }
    }

    public boolean canStepReturn() {
        return this.isSuspended() && this.getReturnAddress() >= 0;
    }

    public void stepReturn() {
        this.runToAddress(this.getReturnAddress(), false);
    }

    public synchronized void advanceFrame() {
        if (this.isSuspended()) {
            if (this.runToScanline > 0 && this.prevScanline == this.getScanline()) {
                --this.runToScanline;
            }
            this.resume("Advance Frame");
            this.runToScanline = this.getScanline();
        }
    }

    public synchronized void runToAddress(int n, boolean bl) {
        if (n >= 0 && this.isSuspended()) {
            this.resume("Run To Address");
            if (bl) {
                this.runToAddress = n;
            } else {
                this.runToVirtualAddress = this.toVirtualAddress(n);
            }
        }
    }

    public synchronized void runBackToAddress(int n, boolean bl) {
        if (this.isSuspended()) {
            if (bl) {
                this.runBackToAddress = n;
            } else {
                this.runBackToVirtualAddress = this.toVirtualAddress(n);
            }
            this.cyclesRunBackToAddress = 0L;
            if (n >= 0) {
                this.addAction(new Action("Run Back To Address", this.getState().clone()));
                this.doStepBack();
                if (this.cyclesRunBackToAddress > 0L) {
                    this.rewindTo(this.cyclesRunBackToAddress);
                }
                this.runBackToAddress = -1;
                this.runBackToVirtualAddress = -1;
            }
        }
    }

    void sleepWhileSuspended() {
        if (this.isSuspended()) {
            if (Emulicious.isRunnerThread()) {
                this.syncLazyState();
                while (this.isSuspended()) {
                    if (this.lastGUIupdate == 0L) {
                        this.fireChangeOccurred();
                        this.lastGUIupdate = System.currentTimeMillis();
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            } else {
                System.err.println("Only the runner thread should get suspended.");
            }
        }
    }

    public void suspend() {
        if (this.suspendOnMappedLinesOnly && !SystemDebugger.isSourceMapped(this.address) && !this.isExceptionHit()) {
            this.suspendOnNextMappedLine = true;
            return;
        }
        this.suspendOnNextMappedLine = false;
        if (!this.suspended) {
            this.suspended = true;
            if (Emulicious.isRunning()) {
                this.syncLazyState();
                this.requestGUIupdate();
                Emulicious.stopSound();
            }
        }
    }

    public void handleDataExecution(int n) {
        if (this.skipExceptions || !this.isDataExecutionBreakpointEnabled()) {
            return;
        }
        if (this.isDataExecutionBreakpointConditionMet()) {
            this.setErrorBreakpointHit("Executing data at " + this.cpuAddressToString(n).trim(), this.getDataExecutionBreakpointMessageExpression(), this.isDataExecutionBreakpointSuspend(), false);
        }
    }

    private void handleStackRomWrite(int n) {
        if (this.skipExceptions || !this.isStackRomWriteBreakpointEnabled()) {
            return;
        }
        if (this.isStackRomWriteBreakpointConditionMet()) {
            this.setErrorBreakpointHit("Trying to push to ROM at " + this.cpuAddressToString(n).trim(), this.getStackRomWriteBreakpointMessageExpression(), this.isStackRomWriteBreakpointSuspend(), false);
        }
    }

    public int getStackSource(int n) {
        if (this.stackSources.length != this.getStackLength()) {
            this.stackSources = new int[this.getStackLength()];
            Arrays.fill(this.stackSources, -1);
        }
        return this.stackSources[n & this.stackSources.length - 1];
    }

    public int removeStackSource(int n) {
        if (n < 0) {
            return -1;
        }
        if (this.stackSources.length != this.getStackLength()) {
            this.stackSources = new int[this.getStackLength()];
            Arrays.fill(this.stackSources, -1);
        }
        int n2 = this.stackSources[n &= this.stackSources.length - 1];
        this.stackSources[n] = -1;
        return n2;
    }

    public void setStackSource(int n, int n2) {
        if (this.stackSources.length != this.getStackLength()) {
            this.stackSources = new int[this.getStackLength()];
            Arrays.fill(this.stackSources, -1);
        }
        this.stackSources[n & this.stackSources.length - 1] = n2;
    }

    private void handleStackWrite(int n, int n2) {
        this.setStackSource(n, this.mapToRomAddress(this.prevPC));
        this.fireStackWriteOccurred(n, n2);
        if (n2 == this.getPC() || n2 - 2 == this.getPC()) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.getRegisterNames().length && n3 <= 1) {
                if (!this.isAdditionalRegister(n4) && n4 != this.indexOfPC() && this.getRegisterValue(n4) == n2) {
                    ++n3;
                }
                ++n4;
            }
            if (n3 <= 0) {
                this.setStackSource(n, 0);
            }
        }
    }

    private void handleStackRead(int n, int n2) {
        this.fireStackReadOccurred(n);
        this.removeStackSource(n);
        if (!this.interruptedStates.isEmpty() && this.interruptedStates.peek().isAt(n, n2)) {
            this.address = this.mapToRomAddress(n2);
            this.handleInterruptExited(this.interruptedStates.pop());
        }
    }

    public boolean isExecutingInterrupt() {
        return !this.interruptedStates.isEmpty();
    }

    public boolean isInterruptBreakpointEnabled() {
        return this.interruptBreakpointEnabled;
    }

    public void setInterruptBreakpointEnabled(boolean bl) {
        this.interruptBreakpointEnabled = bl;
    }

    public boolean isInterruptBreakpointSuspend() {
        return this.interruptBreakpointSuspend;
    }

    public void setInterruptBreakpointSuspend(boolean bl) {
        this.interruptBreakpointSuspend = bl;
    }

    public String getInterruptBreakpointCondition() {
        if (this.interruptBreakpointCondition == null) {
            return "";
        }
        return this.interruptBreakpointCondition;
    }

    public void setInterruptBreakpointCondition(String string) {
        this.interruptBreakpointCondition = string;
        this.interruptBreakpointConditionExp = null;
    }

    public String getInterruptBreakpointMessage() {
        if (this.interruptBreakpointMessage == null) {
            return "";
        }
        return this.interruptBreakpointMessage;
    }

    private Expression getInterruptBreakpointMessageExpression() {
        if (this.interruptBreakpointMessageExp == null) {
            this.interruptBreakpointMessageExp = this.createErrorBreakpointMessageExpression(this.getInterruptBreakpointMessage());
        }
        return this.interruptBreakpointMessageExp;
    }

    public void setInterruptBreakpointMessage(String string) {
        this.interruptBreakpointMessage = string;
        this.interruptBreakpointMessageExp = null;
    }

    public boolean isInterruptBreakpointConditionMet() {
        if (this.interruptBreakpointCondition == null || this.interruptBreakpointCondition.isEmpty()) {
            return true;
        }
        if (this.interruptBreakpointConditionExp == null) {
            try {
                this.interruptBreakpointConditionExp = new Expression(this.interruptBreakpointCondition, tokenizer).optimize(this.getVariables(), this.functions);
                if (this.interruptBreakpointConditionExp.isConstant(this.getVariables(), this.functions)) {
                    throw new IsConstantException(this.interruptBreakpointConditionExp.getValueString(this.getVariables(), this.functions));
                }
            }
            catch (ParseException parseException) {
                this.breakpointMessage = parseException.getMessage();
                this.interruptBreakpointConditionExp = null;
                return true;
            }
            catch (UnknownVariableException unknownVariableException) {
                this.breakpointMessage = unknownVariableException.getMessage();
                this.interruptBreakpointConditionExp = null;
                return true;
            }
            catch (IsConstantException isConstantException) {
                this.breakpointMessage = isConstantException.getMessage();
                this.interruptBreakpointConditionExp = null;
                return true;
            }
        }
        try {
            return this.interruptBreakpointConditionExp.isTrue(this.variables, this.functions);
        }
        catch (UnknownVariableException unknownVariableException) {
            this.breakpointMessage = unknownVariableException.getMessage();
            return true;
        }
    }

    public boolean isBankSwapAtPCBreakpointEnabled() {
        return this.bankSwapAtPCBreakpointEnabled;
    }

    public void setBankSwapAtPCBreakpointEnabled(boolean bl) {
        this.bankSwapAtPCBreakpointEnabled = bl;
    }

    public boolean isBankSwapAtPCBreakpointSuspend() {
        return this.bankSwapAtPCBreakpointSuspend;
    }

    public void setBankSwapAtPCBreakpointSuspend(boolean bl) {
        this.bankSwapAtPCBreakpointSuspend = bl;
    }

    public String getBankSwapAtPCBreakpointCondition() {
        if (this.bankSwapAtPCBreakpointCondition == null) {
            return "";
        }
        return this.bankSwapAtPCBreakpointCondition;
    }

    public void setBankSwapAtPCBreakpointCondition(String string) {
        this.bankSwapAtPCBreakpointCondition = string;
        this.bankSwapAtPCBreakpointConditionExp = null;
    }

    public String getBankSwapAtPCBreakpointMessage() {
        if (this.bankSwapAtPCBreakpointMessage == null) {
            return "";
        }
        return this.bankSwapAtPCBreakpointMessage;
    }

    private Expression getBankSwapAtPCBreakpointMessageExpression() {
        if (this.bankSwapAtPCBreakpointMessageExp == null) {
            this.bankSwapAtPCBreakpointMessageExp = this.createErrorBreakpointMessageExpression(this.getBankSwapAtPCBreakpointMessage());
        }
        return this.bankSwapAtPCBreakpointMessageExp;
    }

    public void setBankSwapAtPCBreakpointMessage(String string) {
        this.bankSwapAtPCBreakpointMessage = string;
        this.bankSwapAtPCBreakpointMessageExp = null;
    }

    public boolean isBankSwapAtPCBreakpointConditionMet() {
        if (this.bankSwapAtPCBreakpointCondition == null || this.bankSwapAtPCBreakpointCondition.isEmpty()) {
            return true;
        }
        if (this.bankSwapAtPCBreakpointConditionExp == null) {
            try {
                this.bankSwapAtPCBreakpointConditionExp = new Expression(this.bankSwapAtPCBreakpointCondition, tokenizer).optimize(this.getVariables(), this.functions);
                if (this.bankSwapAtPCBreakpointConditionExp.isConstant(this.getVariables(), this.functions)) {
                    throw new IsConstantException(this.bankSwapAtPCBreakpointConditionExp.getValueString(this.getVariables(), this.functions));
                }
            }
            catch (ParseException parseException) {
                this.breakpointMessage = parseException.getMessage();
                this.bankSwapAtPCBreakpointConditionExp = null;
                return true;
            }
            catch (UnknownVariableException unknownVariableException) {
                this.breakpointMessage = unknownVariableException.getMessage();
                this.bankSwapAtPCBreakpointConditionExp = null;
                return true;
            }
            catch (IsConstantException isConstantException) {
                this.breakpointMessage = isConstantException.getMessage();
                this.bankSwapAtPCBreakpointConditionExp = null;
                return true;
            }
        }
        try {
            return this.bankSwapAtPCBreakpointConditionExp.isTrue(this.variables, this.functions);
        }
        catch (UnknownVariableException unknownVariableException) {
            this.breakpointMessage = unknownVariableException.getMessage();
            return true;
        }
    }

    private Expression createErrorBreakpointMessageExpression(String string) {
        if (!string.isEmpty()) {
            try {
                return new ConcatenatedExpression(string, tokenizer).optimize(this.getVariables(), this.functions);
            }
            catch (ParseException parseException) {
                this.breakpointMessage = parseException.getMessage();
            }
            catch (UnknownVariableException unknownVariableException) {
                this.breakpointMessage = unknownVariableException.getMessage();
            }
        }
        return null;
    }

    public boolean isUninitializedMemoryBreakpointEnabled() {
        return this.uninitializedMemoryBreakpointEnabled;
    }

    public void setUninitializedMemoryBreakpointEnabled(boolean bl) {
        this.uninitializedMemoryBreakpointEnabled = bl;
    }

    public boolean isUninitializedMemoryBreakpointSuspend() {
        return this.uninitializedMemoryBreakpointSuspend;
    }

    public void setUninitializedMemoryBreakpointSuspend(boolean bl) {
        this.uninitializedMemoryBreakpointSuspend = bl;
    }

    public String getUninitializedMemoryBreakpointCondition() {
        if (this.uninitializedMemoryBreakpointCondition == null) {
            return "";
        }
        return this.uninitializedMemoryBreakpointCondition;
    }

    public void setUninitializedMemoryBreakpointCondition(String string) {
        this.uninitializedMemoryBreakpointCondition = string;
        this.uninitializedMemoryBreakpointConditionExp = null;
    }

    public String getUninitializedMemoryBreakpointMessage() {
        if (this.uninitializedMemoryBreakpointMessage == null) {
            return "";
        }
        return this.uninitializedMemoryBreakpointMessage;
    }

    private Expression getUninitializedMemoryBreakpointMessageExpression() {
        if (this.uninitializedMemoryBreakpointMessageExp == null) {
            this.uninitializedMemoryBreakpointMessageExp = this.createErrorBreakpointMessageExpression(this.getUninitializedMemoryBreakpointMessage());
        }
        return this.uninitializedMemoryBreakpointMessageExp;
    }

    public void setUninitializedMemoryBreakpointMessage(String string) {
        this.uninitializedMemoryBreakpointMessage = string;
        this.uninitializedMemoryBreakpointMessageExp = null;
    }

    public boolean isUninitializedMemoryBreakpointConditionMet() {
        if (this.uninitializedMemoryBreakpointCondition == null || this.uninitializedMemoryBreakpointCondition.isEmpty()) {
            return true;
        }
        if (this.uninitializedMemoryBreakpointConditionExp == null) {
            try {
                this.uninitializedMemoryBreakpointConditionExp = new Expression(this.uninitializedMemoryBreakpointCondition, tokenizer).optimize(this.getVariables(), this.functions);
                if (this.uninitializedMemoryBreakpointConditionExp.isConstant(this.getVariables(), this.functions)) {
                    throw new IsConstantException(this.uninitializedMemoryBreakpointConditionExp.getValueString(this.getVariables(), this.functions));
                }
            }
            catch (ParseException parseException) {
                this.breakpointMessage = parseException.getMessage();
                this.uninitializedMemoryBreakpointConditionExp = null;
                return true;
            }
            catch (UnknownVariableException unknownVariableException) {
                this.breakpointMessage = unknownVariableException.getMessage();
                this.uninitializedMemoryBreakpointConditionExp = null;
                return true;
            }
            catch (IsConstantException isConstantException) {
                this.breakpointMessage = isConstantException.getMessage();
                this.uninitializedMemoryBreakpointConditionExp = null;
                return true;
            }
        }
        try {
            return this.uninitializedMemoryBreakpointConditionExp.isTrue(this.variables, this.functions);
        }
        catch (UnknownVariableException unknownVariableException) {
            this.breakpointMessage = unknownVariableException.getMessage();
            return true;
        }
    }

    public boolean isDataExecutionBreakpointEnabled() {
        return this.dataExecutionBreakpointEnabled;
    }

    public void setDataExecutionBreakpointEnabled(boolean bl) {
        this.dataExecutionBreakpointEnabled = bl;
    }

    public boolean isDataExecutionBreakpointSuspend() {
        return this.dataExecutionBreakpointSuspend;
    }

    public void setDataExecutionBreakpointSuspend(boolean bl) {
        this.dataExecutionBreakpointSuspend = bl;
    }

    public String getDataExecutionBreakpointCondition() {
        if (this.dataExecutionBreakpointCondition == null) {
            return "";
        }
        return this.dataExecutionBreakpointCondition;
    }

    public void setDataExecutionBreakpointCondition(String string) {
        this.dataExecutionBreakpointCondition = string;
        this.dataExecutionBreakpointConditionExp = null;
    }

    public String getDataExecutionBreakpointMessage() {
        if (this.dataExecutionBreakpointMessage == null) {
            return "";
        }
        return this.dataExecutionBreakpointMessage;
    }

    private Expression getDataExecutionBreakpointMessageExpression() {
        if (this.dataExecutionBreakpointMessageExp == null) {
            this.dataExecutionBreakpointMessageExp = this.createErrorBreakpointMessageExpression(this.getDataExecutionBreakpointMessage());
        }
        return this.dataExecutionBreakpointMessageExp;
    }

    public void setDataExecutionBreakpointMessage(String string) {
        this.dataExecutionBreakpointMessage = string;
        this.dataExecutionBreakpointMessageExp = null;
    }

    public boolean isDataExecutionBreakpointConditionMet() {
        if (this.dataExecutionBreakpointCondition == null || this.dataExecutionBreakpointCondition.isEmpty()) {
            return true;
        }
        if (this.dataExecutionBreakpointConditionExp == null) {
            try {
                this.dataExecutionBreakpointConditionExp = new Expression(this.dataExecutionBreakpointCondition, tokenizer).optimize(this.getVariables(), this.functions);
                if (this.dataExecutionBreakpointConditionExp.isConstant(this.getVariables(), this.functions)) {
                    throw new IsConstantException(this.dataExecutionBreakpointConditionExp.getValueString(this.getVariables(), this.functions));
                }
            }
            catch (ParseException parseException) {
                this.breakpointMessage = parseException.getMessage();
                this.dataExecutionBreakpointConditionExp = null;
                return true;
            }
            catch (UnknownVariableException unknownVariableException) {
                this.breakpointMessage = unknownVariableException.getMessage();
                this.dataExecutionBreakpointConditionExp = null;
                return true;
            }
            catch (IsConstantException isConstantException) {
                this.breakpointMessage = isConstantException.getMessage();
                this.dataExecutionBreakpointConditionExp = null;
                return true;
            }
        }
        try {
            return this.dataExecutionBreakpointConditionExp.isTrue(this.variables, this.functions);
        }
        catch (UnknownVariableException unknownVariableException) {
            this.breakpointMessage = unknownVariableException.getMessage();
            return true;
        }
    }

    public boolean isStackRomWriteBreakpointEnabled() {
        return this.stackRomWriteBreakpointEnabled;
    }

    public void setStackRomWriteBreakpointEnabled(boolean bl) {
        this.stackRomWriteBreakpointEnabled = bl;
    }

    public boolean isStackRomWriteBreakpointSuspend() {
        return this.stackRomWriteBreakpointSuspend;
    }

    public void setStackRomWriteBreakpointSuspend(boolean bl) {
        this.stackRomWriteBreakpointSuspend = bl;
    }

    public String getStackRomWriteBreakpointCondition() {
        if (this.stackRomWriteBreakpointCondition == null) {
            return "";
        }
        return this.stackRomWriteBreakpointCondition;
    }

    public void setStackRomWriteBreakpointCondition(String string) {
        this.stackRomWriteBreakpointCondition = string;
        this.stackRomWriteBreakpointConditionExp = null;
    }

    public String getStackRomWriteBreakpointMessage() {
        if (this.stackRomWriteBreakpointMessage == null) {
            return "";
        }
        return this.stackRomWriteBreakpointMessage;
    }

    private Expression getStackRomWriteBreakpointMessageExpression() {
        if (this.stackRomWriteBreakpointMessageExp == null) {
            this.stackRomWriteBreakpointMessageExp = this.createErrorBreakpointMessageExpression(this.getStackRomWriteBreakpointMessage());
        }
        return this.stackRomWriteBreakpointMessageExp;
    }

    public void setStackRomWriteBreakpointMessage(String string) {
        this.stackRomWriteBreakpointMessage = string;
        this.stackRomWriteBreakpointMessageExp = null;
    }

    public boolean isStackRomWriteBreakpointConditionMet() {
        if (this.stackRomWriteBreakpointCondition == null || this.stackRomWriteBreakpointCondition.isEmpty()) {
            return true;
        }
        if (this.stackRomWriteBreakpointConditionExp == null) {
            try {
                this.stackRomWriteBreakpointConditionExp = new Expression(this.stackRomWriteBreakpointCondition, tokenizer).optimize(this.getVariables(), this.functions);
                if (this.stackRomWriteBreakpointConditionExp.isConstant(this.getVariables(), this.functions)) {
                    throw new IsConstantException(this.stackRomWriteBreakpointConditionExp.getValueString(this.getVariables(), this.functions));
                }
            }
            catch (ParseException parseException) {
                this.breakpointMessage = parseException.getMessage();
                this.stackRomWriteBreakpointConditionExp = null;
                return true;
            }
            catch (UnknownVariableException unknownVariableException) {
                this.breakpointMessage = unknownVariableException.getMessage();
                this.stackRomWriteBreakpointConditionExp = null;
                return true;
            }
            catch (IsConstantException isConstantException) {
                this.breakpointMessage = isConstantException.getMessage();
                this.stackRomWriteBreakpointConditionExp = null;
                return true;
            }
        }
        try {
            return this.stackRomWriteBreakpointConditionExp.isTrue(this.variables, this.functions);
        }
        catch (UnknownVariableException unknownVariableException) {
            this.breakpointMessage = unknownVariableException.getMessage();
            return true;
        }
    }

    public boolean isErrorBreakpointEnabled(int n) {
        return n < this.errorBreakpointEnabled.length && this.errorBreakpointEnabled[n];
    }

    public void setErrorBreakpointEnabled(int n, boolean bl) {
        if (n < this.errorBreakpointEnabled.length) {
            this.errorBreakpointEnabled[n] = bl;
        }
    }

    public boolean isErrorBreakpointSuspend(int n) {
        return n < this.errorBreakpointSuspend.length && this.errorBreakpointSuspend[n];
    }

    public void setErrorBreakpointSuspend(int n, boolean bl) {
        if (n < this.errorBreakpointSuspend.length) {
            this.errorBreakpointSuspend[n] = bl;
        }
    }

    public String getErrorBreakpointCondition(int n) {
        if (n >= this.errorBreakpointCondition.length || this.errorBreakpointCondition[n] == null) {
            return "";
        }
        return this.errorBreakpointCondition[n];
    }

    public void setErrorBreakpointCondition(int n, String string) {
        this.errorBreakpointCondition[n] = string;
        this.errorBreakpointConditionExp[n] = null;
    }

    public String getErrorBreakpointMessage(int n) {
        if (n >= this.errorBreakpointMessage.length || this.errorBreakpointMessage[n] == null) {
            return "";
        }
        return this.errorBreakpointMessage[n];
    }

    private Expression getErrorBreakpointMessageExpression(int n) {
        if (n < this.errorBreakpointMessageExp.length && this.errorBreakpointMessageExp[n] == null) {
            this.errorBreakpointMessageExp[n] = this.createErrorBreakpointMessageExpression(this.getErrorBreakpointMessage(n));
        }
        return null;
    }

    public void setErrorBreakpointMessage(int n, String string) {
        this.errorBreakpointMessage[n] = string;
        this.errorBreakpointMessageExp[n] = null;
    }

    private boolean isErrorBreakpointConditionMet(int n) {
        String string = this.getErrorBreakpointCondition(n);
        if (string.isEmpty()) {
            return true;
        }
        Expression expression = this.errorBreakpointConditionExp[n];
        if (expression == null) {
            try {
                expression = new Expression(string, tokenizer).optimize(this.getVariables(), this.functions);
                if (expression.isConstant(this.getVariables(), this.functions)) {
                    throw new IsConstantException(expression.getValueString(this.getVariables(), this.functions));
                }
                this.errorBreakpointConditionExp[n] = expression;
            }
            catch (ParseException parseException) {
                this.breakpointMessage = parseException.getMessage();
                this.errorBreakpointConditionExp[n] = null;
                return true;
            }
            catch (UnknownVariableException unknownVariableException) {
                this.breakpointMessage = unknownVariableException.getMessage();
                this.errorBreakpointConditionExp[n] = null;
                return true;
            }
            catch (IsConstantException isConstantException) {
                this.breakpointMessage = isConstantException.getMessage();
                this.errorBreakpointConditionExp[n] = null;
                return true;
            }
        }
        try {
            return expression.isTrue(this.variables, this.functions);
        }
        catch (UnknownVariableException unknownVariableException) {
            this.breakpointMessage = unknownVariableException.getMessage();
            return true;
        }
    }

    private void handleFrameFinished() {
        int n = 0;
        byte[] byArray = this.writesOnScanline;
        int n2 = this.writesOnScanline.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3];
            n += by;
            ++n3;
        }
        if (this.haltedCycles > 0) {
            this.cpuUsage = (this.getCyclesPerFrame() - this.haltedCycles) * 100 / this.getCyclesPerFrame();
            this.haltedCycles = 0;
        } else {
            this.cpuUsage = (n + this.halfPercentWritesPerFrame) * 100 / this.writesPerFrame;
        }
        Arrays.fill(this.writesOnScanline, (byte)0);
        this.fireFrameFinished();
    }

    public int getCpuUsage() {
        return this.cpuUsage;
    }

    private void registerWriteOnScanline(int n) {
        if (this.writesOnScanline.length <= n) {
            this.writesOnScanline = Arrays.copyOf(this.writesOnScanline, this.writesOnScanline.length + this.writesOnScanline.length / 2);
        }
        if (this.writesOnScanline[n] < 5) {
            int n2 = n;
            this.writesOnScanline[n2] = (byte)(this.writesOnScanline[n2] + 1);
        }
    }

    private void handleInterruptTaken(int n) {
        InterruptedState interruptedState = new InterruptedState(this.peekByte(this.getSP() + 1) << 8 | this.peekByte(this.getSP()), this.getSP());
        this.interruptedStates.push(interruptedState);
        this.fireInterruptTaken(n, this.interruptedStates.size());
        if (!this.skipExceptions && this.isInterruptBreakpointEnabled()) {
            this.interruptedVA = this.getVRAMaddress();
            interruptedState.populate();
        }
    }

    private void handleInterruptExited(InterruptedState interruptedState) {
        this.fireInterruptExited(this.interruptedStates.size());
        if (!this.skipExceptions && this.isInterruptBreakpointEnabled() && this.isInterruptBreakpointConditionMet() && interruptedState.getRegisters() != null) {
            int[] nArray = interruptedState.getRegisters();
            int[] nArray2 = interruptedState.getBanks();
            int n = 0;
            while (n < nArray.length) {
                if (n != this.indexOfPC() && this.getRegisterValue(n) != nArray[n]) {
                    this.setErrorBreakpointHit(String.format("Inconsistent state after interrupt: " + this.getRegisterNames()[n] + " changed from %04X to %04X", nArray[n], this.getRegisterValue(n)), this.getInterruptBreakpointMessageExpression(), this.isInterruptBreakpointSuspend());
                    return;
                }
                ++n;
            }
            if (this.getBank0() != nArray2[0]) {
                this.setErrorBreakpointHit(String.format("Inconsistent state after interrupt: bank 0 changed from %02X to %02X", nArray2[0], this.getBank0()), this.getInterruptBreakpointMessageExpression(), this.isInterruptBreakpointSuspend());
            } else if (this.getBank1() != nArray2[1]) {
                this.setErrorBreakpointHit(String.format("Inconsistent state after interrupt: bank 1 changed from %02X to %02X", nArray2[1], this.getBank1()), this.getInterruptBreakpointMessageExpression(), this.isInterruptBreakpointSuspend());
            } else if (this.getBank2() != nArray2[2]) {
                this.setErrorBreakpointHit(String.format("Inconsistent state after interrupt: bank 2 changed from %02X to %02X", nArray2[2], this.getBank2()), this.getInterruptBreakpointMessageExpression(), this.isInterruptBreakpointSuspend());
            } else if (this.getBank3() != nArray2[3]) {
                this.setErrorBreakpointHit(String.format("Inconsistent state after interrupt: bank 3 changed from %02X to %02X", nArray2[3], this.getBank3()), this.getInterruptBreakpointMessageExpression(), this.isInterruptBreakpointSuspend());
            }
        }
    }

    private void handleBankSwapAtPC() {
        if (!this.skipExceptions && this.isBankSwapAtPCBreakpointEnabled() && this.isBankSwapAtPCBreakpointConditionMet()) {
            this.setErrorBreakpointHit("Swapped the bank at PC", this.getBankSwapAtPCBreakpointMessageExpression(), this.isBankSwapAtPCBreakpointSuspend());
        }
    }

    private final void updateCoverage(int n) {
        if (this.isROMaddress(n)) {
            if (this.isROMcoverageExcluded(n = this.mapAddress(n))) {
                return;
            }
            if (this.getCoverage(n) == 0L) {
                ++this.numCoverage;
            }
            if (this.getCoverage(n) < Long.MAX_VALUE) {
                int n2 = n;
                this.coverage[n2] = this.coverage[n2] + 1L;
            }
            if (this.getCoverage(n) > this.maxCoverage) {
                this.maxCoverage = this.getCoverage(n);
            }
            if (this.sumCoverage < Long.MAX_VALUE) {
                ++this.sumCoverage;
            }
        } else if (this.isRAMaddress(n)) {
            if (this.isRAMcoverageExcluded(n = this.mapAddress(n))) {
                return;
            }
            if (this.getRamCoverage(n) == 0L) {
                ++this.numRamCoverage;
            }
            if (this.getRamCoverage(n) < Long.MAX_VALUE) {
                int n3 = n;
                this.ramCoverage[n3] = this.ramCoverage[n3] + 1L;
            }
            if (this.getRamCoverage(n) > this.maxRamCoverage) {
                this.maxRamCoverage = this.getRamCoverage(n);
            }
            if (this.sumRamCoverage < Long.MAX_VALUE) {
                ++this.sumRamCoverage;
            }
        }
    }

    private final void handleReadUninitializedMemory(int n, int n2) {
        if (this.skipExceptions || !this.isUninitializedMemoryBreakpointEnabled()) {
            return;
        }
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, n);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OLDVALUE, n2);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_VALUE, n2);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OPERATION, n == this.getPrevPC() || n == this.getPC() || n == this.getPC() - 1 ? 2 : 0);
        if (this.isUninitializedMemoryBreakpointConditionMet()) {
            Symbols.Symbol symbol = Symbols.findRAMSymbol(n, this.symbolsByAddress);
            this.setErrorBreakpointHit("Reading from uninitialized memory at " + (symbol != null ? symbol.getLabel() : this.cpuAddressToString(n).trim()), this.getUninitializedMemoryBreakpointMessageExpression(), this.isUninitializedMemoryBreakpointSuspend());
            this.sleepWhileSuspended();
        }
    }

    private final void handleReadWatchpoint(Watchpoint watchpoint, boolean bl, int n, int n2) {
        int n3;
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, n);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OLDVALUE, n2);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_VALUE, n2);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OPERATION, bl || n == this.getPC() || n == this.getPC() - 1 ? 2 : 0);
        if (bl) {
            boolean bl2 = this.getDecoratedSystem() instanceof GameBoy;
            int n4 = this.peekByte(n);
            n3 = (n4 & 0xC7) == 199 ? n4 - 199 : (n4 == 233 ? this.getRegisterValue(2) : ((n4 & 0xF7) == 16 && (!bl2 || n4 != 16) || (n4 & 0xE7) == 32 ? n + 2 + (byte)this.peekByte(n + 1) : (n4 == 195 || n4 == 205 || (n4 & 0xC7) == 196 || (n4 & (bl2 ? 231 : 199)) == 194 ? this.peekByte(n + 2) << 8 | this.peekByte(n + 1) : -1)));
        } else {
            n3 = -1;
        }
        this.breakpointVariables.put(VARIABLE_NAME_BRANCH_DESTINATION, n3);
        if (watchpoint.isRead() && this.isBreakpointConditionMet(watchpoint)) {
            Symbols.Symbol symbol = this.isRAMaddress(n) ? Symbols.findRAMSymbol(n, this.symbolsByAddress) : (this.isROMaddress(n) ? Symbols.findSymbol(this.mapAddress(n), this.symbolsByAddress) : null);
            this.setBreakpointHit(watchpoint, String.format("Watchpoint hit: Reading %02X from %s", n2, symbol != null ? symbol.getLabel() : this.cpuAddressToString(n).trim()), watchpoint.isSuspend());
        }
    }

    @Override
    public int readByte(int n, int n2) {
        int n3 = super.readByte(n, n2);
        try {
            Breakpoint[] breakpointArray;
            boolean bl = this.isRAMaddress(n);
            if (this.recordCoverage) {
                this.updateCoverage(n);
            }
            this.prevPC = this.getPrevPC();
            if (n == this.prevPC) {
                boolean bl2;
                boolean bl3 = bl2 = this.isSuspended();
                Breakpoint[] breakpointArray2 = this.getMemoryLocationBreakpoints("cpu", n);
                int n4 = breakpointArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    Breakpoint breakpoint = breakpointArray2[n5];
                    if (breakpoint instanceof Watchpoint && this.isBreakpointEnabled(breakpoint) && ((Watchpoint)breakpoint).isRead()) {
                        this.handleReadWatchpoint((Watchpoint)breakpoint, true, n, n3);
                        if (!bl3 && this.isSuspended()) {
                            bl3 = true;
                        }
                    }
                    ++n5;
                }
                if (bl3 && !bl2) {
                    this.sleepWhileSuspended();
                }
                return n3;
            }
            int n6 = this.getSP();
            boolean bl4 = false;
            if (n + 1 == n6) {
                boolean bl5 = bl4 = !this.isROMaddress(n);
                if (bl4 && this.tmpPrevSP + 1 == n6) {
                    this.handleStackRead(n - 1, n3 << 8 | this.tmpPrevStackValue);
                }
                this.tmpPrevSP = n + 1;
                this.tmpPrevStackValue = n3;
            }
            if (bl && !bl4) {
                if (n != this.readOnScanlineAddress1 && n != this.readOnScanlineAddress2) {
                    this.readsOnScanline = 0;
                }
                this.readsOnScanline = (byte)(this.readsOnScanline + 1);
                if (this.readOnScanlineToggle) {
                    this.readOnScanlineAddress2 = n;
                } else {
                    this.readOnScanlineAddress1 = n;
                }
                this.readOnScanlineToggle = !this.readOnScanlineToggle;
            }
            boolean bl6 = this.isSuspended();
            Breakpoint[] breakpointArray3 = this.getMemoryLocationBreakpoints("cpu", n);
            int n7 = breakpointArray3.length;
            int n8 = 0;
            while (n8 < n7) {
                breakpointArray = breakpointArray3[n8];
                if (breakpointArray instanceof Watchpoint && this.isBreakpointEnabled((Breakpoint)breakpointArray) && ((Watchpoint)breakpointArray).isRead()) {
                    this.handleReadWatchpoint((Watchpoint)breakpointArray, false, n, n3);
                }
                ++n8;
            }
            if (this.getAdditionalMemoryLocationAt(n) == null) {
                Breakpoint[] breakpointArray4 = breakpointArray = this.isROMaddress(n) ? this.getROMbreakpoints(this.mapAddress(n)) : (bl ? this.getRAMbreakpoints(this.mapAddress(n)) : (this.isSRAMaddress(n) ? this.getSRAMbreakpoints(this.mapAddress(n)) : NO_BREAKPOINTS));
                int n9 = breakpointArray.length;
                n7 = 0;
                while (n7 < n9) {
                    Breakpoint breakpoint = breakpointArray4[n7];
                    if (breakpoint instanceof Watchpoint && this.isBreakpointEnabled(breakpoint) && ((Watchpoint)breakpoint).isRead()) {
                        this.handleReadWatchpoint((Watchpoint)breakpoint, false, n, n3);
                    }
                    ++n7;
                }
            }
            if (!bl6) {
                this.sleepWhileSuspended();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }

    public void readPort(int n, int n2) {
        this.readsOnScanline = (byte)(this.readsOnScanline + 1);
        Breakpoint[] breakpointArray = this.getPortBreakpoints(n);
        int n3 = breakpointArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Breakpoint breakpoint = breakpointArray[n4];
            if (breakpoint instanceof Watchpoint && this.isBreakpointEnabled(breakpoint)) {
                Watchpoint watchpoint = (Watchpoint)breakpoint;
                this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, n);
                this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_PORT, n);
                this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_VALUE, n2);
                this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OPERATION, 0);
                if (watchpoint.isRead() && this.isBreakpointConditionMet(watchpoint)) {
                    this.setBreakpointHit(breakpoint, String.format("Watchpoint hit: Reading %02X from port %X", n2, n), watchpoint.isSuspend());
                }
            }
            ++n4;
        }
    }

    public void writePort(int n, int n2) {
        this.registerWriteOnScanline(this.getScanline());
        Breakpoint[] breakpointArray = this.getPortBreakpoints(n);
        int n3 = breakpointArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Breakpoint breakpoint = breakpointArray[n4];
            if (breakpoint instanceof Watchpoint && this.isBreakpointEnabled(breakpoint)) {
                Watchpoint watchpoint = (Watchpoint)breakpoint;
                this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, n);
                this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_PORT, n);
                this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_VALUE, n2);
                this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OPERATION, 1);
                if (watchpoint.isWrite() && this.isBreakpointConditionMet(watchpoint)) {
                    this.setBreakpointHit(breakpoint, String.format("Watchpoint hit: Writing %02X to port %X", n2, n), watchpoint.isSuspend());
                }
            }
            ++n4;
        }
    }

    private final void handleWriteWatchpoint(Watchpoint watchpoint, int n, int n2) {
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, n);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OLDVALUE, this.peekByte(n));
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_VALUE, n2);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OPERATION, 1);
        if (watchpoint.isWrite() && this.isBreakpointConditionMet(watchpoint)) {
            Symbols.Symbol symbol = this.isRAMaddress(n) ? Symbols.findRAMSymbol(n, this.symbolsByAddress) : (this.isROMaddress(n) ? Symbols.findSymbol(this.mapAddress(n), this.symbolsByAddress) : null);
            this.setBreakpointHit(watchpoint, String.format("Watchpoint hit: Writing %02X to %s", n2, symbol != null ? symbol.getLabel() : this.cpuAddressToString(n).trim()), watchpoint.isSuspend());
        }
    }

    private int indexOfErrorCode(int n) {
        int[] nArray = this.getErrorCodes();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return nArray.length;
    }

    private final void handleErrorBreakpoint(int n, int n2) {
        int n3 = this.indexOfErrorCode(n);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, n2);
        if (!this.skipExceptions && this.isErrorBreakpointEnabled(n3) && this.isErrorBreakpointConditionMet(n3)) {
            this.setErrorBreakpointHit(Emulicious.getErrorMessage(n3), this.getErrorBreakpointMessageExpression(n3), this.isErrorBreakpointSuspend(n3));
        }
    }

    @Override
    public void writeByte(int n, int n2, int n3) {
        Breakpoint breakpoint;
        int n4 = this.mapAddress(this.getPrevPC());
        boolean bl = this.isSuspended();
        Breakpoint[] breakpointArray = this.getMemoryLocationBreakpoints("cpu", n);
        int n5 = breakpointArray.length;
        int n6 = 0;
        while (n6 < n5) {
            breakpoint = breakpointArray[n6];
            if (breakpoint instanceof Watchpoint && this.isBreakpointEnabled(breakpoint) && ((Watchpoint)breakpoint).isWrite()) {
                this.handleWriteWatchpoint((Watchpoint)breakpoint, n, n2);
            }
            ++n6;
        }
        if (this.isROMaddress(n)) {
            breakpointArray = this.getROMbreakpoints(this.mapAddress(n));
            n5 = breakpointArray.length;
            n6 = 0;
            while (n6 < n5) {
                breakpoint = breakpointArray[n6];
                if (breakpoint instanceof Watchpoint && this.isBreakpointEnabled(breakpoint) && ((Watchpoint)breakpoint).isWrite()) {
                    this.handleWriteWatchpoint((Watchpoint)breakpoint, n, n2);
                }
                ++n6;
            }
            if (n == this.getSP()) {
                this.handleStackRomWrite(n);
            }
            if (!bl) {
                this.sleepWhileSuspended();
            }
            super.writeByte(n, n2, n3);
            int n7 = this.mapAddress(this.getPrevPC());
            if (n7 != n4) {
                this.handleBankSwapAtPC();
            }
            return;
        }
        if (this.getAdditionalMemoryLocationAt(n) == null) {
            boolean bl2 = this.isRAMaddress(n);
            n6 = this.isSRAMaddress(n) ? 1 : 0;
            if (this.recordCoverage && bl2) {
                this.updateCoverage(n);
            }
            Breakpoint[] breakpointArray2 = n6 != 0 ? this.getSRAMbreakpoints(this.mapAddress(n)) : (bl2 ? this.getRAMbreakpoints(this.mapAddress(n)) : NO_BREAKPOINTS);
            int n8 = breakpointArray2.length;
            int n9 = 0;
            while (n9 < n8) {
                Breakpoint breakpoint2 = breakpointArray2[n9];
                if (breakpoint2 instanceof Watchpoint && this.isBreakpointEnabled(breakpoint2) && ((Watchpoint)breakpoint2).isWrite()) {
                    this.handleWriteWatchpoint((Watchpoint)breakpoint2, n, n2);
                }
                ++n9;
            }
        }
        if (!bl) {
            this.sleepWhileSuspended();
        }
        boolean bl3 = false;
        if (n == this.getSP()) {
            if (this.tmpPrevSP == n + 1) {
                this.handleStackWrite(n, this.tmpPrevStackValue << 8 | n2);
            }
            bl3 = true;
            this.tmpPrevSP = n;
            this.tmpPrevStackValue = n2;
        } else if (n == this.getSP() + 1) {
            if (this.tmpPrevSP == n - 1) {
                this.handleStackWrite(n - 1, n2 << 8 | this.tmpPrevStackValue);
            }
            bl3 = true;
        } else if (this.removeStackSource(n) < 0) {
            this.removeStackSource(n - 1);
        }
        if (!bl3) {
            this.registerWriteOnScanline(this.getScanline());
        }
        super.writeByte(n, n2, n3);
        n6 = this.mapAddress(this.getPrevPC());
        if (n6 != n4) {
            this.handleBankSwapAtPC();
        }
    }

    @Override
    public void setState(EmulatableSystem.State state, boolean bl, boolean bl2) {
        super.setState(state, bl, bl2);
        this.resetDebugger();
    }

    public void performReset() {
        Emulicious.performReset();
    }

    public void setPC(int n) {
        if (this.address == this.mapToRomAddress(this.getPC())) {
            this.setRegValue(this.indexOfPC(), n);
            this.pcToSet = -1;
        } else {
            this.shouldStepBack = true;
            this.pcToSet = n;
        }
    }

    @Override
    public void reset() {
        super.setDebugger(null);
        super.removePortListener(this.portListener);
        this.removeSystemEventListener(this);
        super.reset();
        super.setDebugger(this);
        super.addPortListener(this.portListener);
        this.addSystemEventListener(this);
        this.resetDebugger();
    }

    private void pushState() {
        this.stateBuffer.push(this.getState(), this.executedCycles, this.prevInstructionExecutedCycles, this.prevMappedInstructionExecutedCycles);
    }

    private void resetDebugger() {
        this.address = this.mapToRomAddress(this.getPC());
        this.biosSkipped = this.isCartridgeEnabled();
        this.shouldStepBack = false;
        this.shouldStepBackOver = false;
        this.shouldStepBackReturn = false;
        this.prevPC = -1;
        this.pcToSet = -1;
        this.prevScanline = 0;
        this.runToAddress = -1;
        this.runToVirtualAddress = -1;
        this.runToScanline = -1;
        this.stepOverVirtualAddress = -1;
        this.executedCycles = 1L;
        this.executedInstructions = 0;
        this.executedScanlines = 0;
        this.stateBuffer.clear();
        this.inputStack.clear();
        this.framesSinceLastState = 0;
        this.prevInstructionExecutedCycles = 0L;
        this.prevMappedInstructionExecutedCycles = 0L;
        this.callInstructionExecutedCycles.clear();
        Arrays.fill(this.stackSources, -1);
        this.breakpointHit = null;
        this.breakpointMessage = null;
        this.breakpointVariables.clear();
        this.interruptedStates.clear();
        this.lastVAwriteDuringInterrupt = false;
        this.cpuUsage = 0;
        this.clearTrace();
        this.syncLazyState();
        this.lastGUIupdate = 0L;
        this.fireReset();
        this.fireBreakpointHitCleared();
        if (this.debugFileInterpreter != null) {
            this.debugFileInterpreter.reset();
        }
    }

    @Override
    public int execute(int n) {
        if (!this.biosSkipped && !this.isCartridgeEnabled()) {
            super.setDebugger(null);
            super.removePortListener(this.portListener);
            this.removeSystemEventListener(this);
            n = this.getCyclesPerSecond() * 8;
            while (!(this.biosSkipped || n <= 0 || this.isCartridgeEnabled() && !this.isRAMaddress(this.getPC()))) {
                n += super.executeOnce(0);
            }
            n = 0;
            if (this.biosSkipped) {
                return 0;
            }
            super.setDebugger(this);
            super.addPortListener(this.portListener);
            this.addSystemEventListener(this);
            this.prevScanline = this.getScanline();
            this.address = this.mapToRomAddress(this.getPC());
            this.fireInstructionExecuted();
            this.syncLazyState();
            this.biosSkipped = true;
            this.fireChangeOccurred();
            if (this.isSuspended()) {
                Emulicious.stopSound();
            }
            this.lastGUIupdate = System.currentTimeMillis();
            this.handleLineBreakpoints(this.address);
            this.pushState();
        }
        while (Emulicious.isRunning() && n > 0) {
            int n2;
            int n3;
            if (this.isSuspended()) {
                this.address = this.mapToRomAddress(this.getPC());
                if (this.lastGUIupdate == 0L) {
                    this.fireChangeOccurred();
                    this.lastGUIupdate = System.currentTimeMillis();
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                return 0;
            }
            this.fireExecutingInstruction();
            boolean bl = this.isInterruptsEnabled();
            int n4 = this.getPC();
            int n5 = this.getSP();
            this.tmpPrevSP = -1;
            this.prevInstructionExecutedCycles = this.executedCycles;
            if (SystemDebugger.isSourceMapped(this.address)) {
                this.prevMappedInstructionExecutedCycles = this.prevInstructionExecutedCycles;
            }
            int n6 = this.isHalted() ? n - super.executeOnce(n) : -super.executeOnce(0);
            n -= n6;
            if (this.shouldStepBack) {
                this.shouldStepBack = false;
                this.doStepBack();
                if (this.pcToSet < 0) break;
                this.address = this.mapToRomAddress(this.getPC());
                this.setPC(this.pcToSet);
                break;
            }
            if (this.shouldStepBackOver) {
                this.shouldStepBackOver = false;
                this.doStepBackOver();
                break;
            }
            if (this.shouldStepBackReturn) {
                this.shouldStepBackReturn = false;
                this.doStepBackReturn();
                break;
            }
            this.updateTrace();
            int n7 = this.getPC();
            if (this.tmpPrevSP >= 0) {
                n3 = this.peekByte(this.tmpPrevSP + 1) << 8 | this.peekByte(this.tmpPrevSP);
                if (n3 == n4 + 3 || n3 == n4 + 1 || n3 == n4) {
                    this.callInstructionExecutedCycles.push(this.prevInstructionExecutedCycles);
                    this.fireCallExecuted(n7, n3);
                } else {
                    n2 = this.peekByte(this.tmpPrevSP - 1) << 8 | this.peekByte(this.tmpPrevSP - 2);
                    if (n2 == n7 && !this.callInstructionExecutedCycles.isEmpty()) {
                        this.callInstructionExecutedCycles.pop();
                    }
                }
            }
            if (this.getSP() - n5 < -2 && this.stackSources.length == this.getStackLength() && this.isRAMaddress(this.getSP()) && (n2 = n5 & this.stackSources.length - 1) > (n3 = this.getSP() & this.stackSources.length - 1)) {
                Arrays.fill(this.stackSources, n3, n2, -1);
            }
            this.address = this.mapToRomAddress(n7);
            this.executedCycles += (long)n6;
            ++this.executedInstructions;
            n3 = this.getScanline();
            if (this.isHalted()) {
                this.haltedCycles += n6;
            }
            if (n3 != this.prevScanline) {
                if (this.haltedCycles <= 0 && this.readsOnScanline < 5) {
                    n2 = 0;
                    while (n2 < 5) {
                        this.registerWriteOnScanline(n3);
                        ++n2;
                    }
                }
                this.readsOnScanline = 0;
                ++this.executedScanlines;
                if (n3 < this.prevScanline) {
                    this.writesPerFrame = this.prevScanline * 5;
                    this.halfPercentWritesPerFrame = (this.writesPerFrame + 100) / 200;
                    if (++this.framesSinceLastState == 15) {
                        this.pushState();
                    }
                }
                if (!this.wasVBlank && this.isVBlank()) {
                    this.handleFrameFinished();
                }
                if (n3 == this.runToScanline) {
                    this.suspend();
                }
                this.wasVBlank = this.isVBlank();
            }
            this.prevScanline = n3;
            if (this.tmpPrevSP >= 0 && bl && !this.isInterruptsEnabled() && this.isInterruptAddress(n7)) {
                this.handleInterruptTaken(n7);
            }
            this.fireInstructionExecuted();
            this.handleLineBreakpoints(this.address);
            if (this.isStepping() || this.address == this.runToAddress || this.suspendOnNextMappedLine) {
                this.suspend();
                continue;
            }
            if (this.runToVirtualAddress < 0 && this.stepOverVirtualAddress < 0 || (n2 = this.getVirtualAddress()) != this.runToVirtualAddress && (this.stepOverVirtualAddress < 0 || n2 <= this.stepOverVirtualAddress || n2 - this.stepOverVirtualAddress > 5)) continue;
            this.suspend();
        }
        if (!this.isSuspended() && System.currentTimeMillis() - this.lastGUIupdate >= 100L) {
            this.fireChangeOccurred();
            this.lastGUIupdate = System.currentTimeMillis();
        }
        return n;
    }

    private void handleLineBreakpoints(int n) {
        Breakpoint[] breakpointArray = this.getROMbreakpoints(n);
        int n2 = breakpointArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Breakpoint breakpoint = breakpointArray[n3];
            if (this.isBreakpointEnabled(breakpoint) && this.isBreakpointConditionMet(breakpoint) && !(breakpoint instanceof Watchpoint)) {
                this.setBreakpointHit(breakpoint, "Line Breakpoint hit", null, breakpoint.isSuspend(), false);
                break;
            }
            ++n3;
        }
    }

    public void requestGUIupdate() {
        if (this.isSuspended()) {
            this.lastGUIupdate = 0L;
        }
    }

    public boolean isStepping() {
        return this.stepping && !this.isHalted();
    }

    public boolean isBiosSkipped() {
        return this.biosSkipped;
    }

    private static boolean isSourceMapped(int n) {
        return Z80Disassembler.isSourceMapped(n);
    }

    private void clearTrace() {
        this.trace.fill(Integer.MIN_VALUE);
    }

    private void updateTrace() {
        this.trace.add(this.getAddress());
    }

    public int convertAddress(int n) {
        if (n <= -this.getMemoryLength() - 2 || n == -1) {
            return n;
        }
        return -n - 2;
    }

    public CyclicIntStack getTrace() {
        return this.trace;
    }

    private void setErrorBreakpointHit(String string, Expression expression, boolean bl, boolean bl2) {
        this.setBreakpointHit(NULL_BREAKPOINT, string, expression, bl, bl2);
    }

    private void setErrorBreakpointHit(String string, Expression expression, boolean bl) {
        this.setBreakpointHit(NULL_BREAKPOINT, string, expression, bl);
    }

    private void setBreakpointHit(Breakpoint breakpoint, String string, Expression expression, boolean bl) {
        this.setBreakpointHit(breakpoint, string, expression, bl, true);
    }

    private void setBreakpointHit(Breakpoint breakpoint, String string, boolean bl) {
        this.setBreakpointHit(breakpoint, string, null, bl);
    }

    private void setBreakpointHit(Breakpoint breakpoint, String string, Expression expression, boolean bl, boolean bl2) {
        Breakpoint.Action action = breakpoint.getAction();
        if (action != null) {
            action.performAction();
            if (this.suspended) {
                this.breakpointHit = breakpoint;
                this.addDebugEvent(breakpoint == NULL_BREAKPOINT ? DebuggableSystem.DebugEvent.EXCEPTION : DebuggableSystem.DebugEvent.BREAKPOINT, string);
                this.fireBreakpointHit(breakpoint, this.breakpoints.indexOf(breakpoint), this.getPrevPC(), string);
            }
            return;
        }
        if (expression == null) {
            expression = this.breakpointMessages.get(breakpoint);
        }
        if (expression == null && !breakpoint.getMessage().isEmpty()) {
            try {
                expression = new ConcatenatedExpression(breakpoint.getMessage(), tokenizer).optimize(this.getVariables(), this.functions);
                this.breakpointMessages.put(breakpoint, expression);
            }
            catch (ParseException parseException) {
                string = parseException.getMessage();
                this.breakpointConditions.remove(breakpoint);
            }
            catch (UnknownVariableException unknownVariableException) {
                string = unknownVariableException.getMessage();
                this.breakpointConditions.remove(breakpoint);
            }
        }
        if (expression != null) {
            String string2;
            string = string2 = expression.getValueString(this.getVariables(), this.functions);
        }
        if (bl) {
            this.breakpointHit = breakpoint;
            this.breakpointMessage = this.breakpointMessage != null && this.breakpointMessage.length() < 100 ? String.valueOf(this.breakpointMessage) + " - " + string : string;
            this.suspend();
        }
        this.addDebugEvent(breakpoint == NULL_BREAKPOINT ? DebuggableSystem.DebugEvent.EXCEPTION : DebuggableSystem.DebugEvent.BREAKPOINT, string);
        this.fireBreakpointHit(breakpoint, this.breakpoints.indexOf(breakpoint), this.getPrevPC(), string);
        if (bl && bl2) {
            this.sleepWhileSuspended();
        }
    }

    public Breakpoint getBreakpointHit() {
        return this.breakpointHit;
    }

    public boolean isBreakpointHit() {
        return this.breakpointHit != null;
    }

    public boolean isExceptionHit() {
        return this.breakpointHit == NULL_BREAKPOINT;
    }

    public void setBreakpointMessage(String string) {
        this.breakpointMessage = string;
    }

    public String getBreakpointMessage() {
        return this.breakpointMessage;
    }

    public long getExecutedCycles() {
        return this.executedCycles;
    }

    public int getExecutedInstructions() {
        return this.executedInstructions;
    }

    public int getExecutedScanlines() {
        return this.executedScanlines;
    }

    public util.map.Map<List<Symbols.Symbol>> getSymbols() {
        return this.symbolsByAddress;
    }

    public util.map.Map<List<Symbols.Symbol>> getRamSymbols() {
        return this.ramSymbols;
    }

    public util.map.Map<List<Symbols.Symbol>> loadSymbols(File file) {
        this.symbols = Symbols.loadSymbols(file);
        this.ramSymbols = new HashMap<List<Symbols.Symbol>>();
        this.symbolsByAddress = Symbols.getSymbolsByAddress(this.symbols, this.ramSymbols, this);
        return this.symbolsByAddress;
    }

    public DebugFile loadDebugFile(File file, String string, WarningHandler warningHandler) throws IOException {
        if (this.debugFileInterpreter != null) {
            this.debugFileInterpreter.dispose();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("va");
        String[] stringArray = this.getRegisterNames();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].toLowerCase();
            arrayList.add(string2);
            arrayList.add(string2.substring(0, 1));
            arrayList.add(string2.substring(1));
            ++n;
        }
        String[] stringArray2 = this.getFlagNames();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            String string3 = stringArray2[n2].toLowerCase();
            if (string3.length() == 3 && string3.charAt(1) == '/') {
                arrayList.add(String.valueOf(string3.substring(0, 1)) + "f");
                arrayList.add(String.valueOf(string3.substring(2)) + "f");
            } else {
                arrayList.add(String.valueOf(string3) + "f");
            }
            ++n2;
        }
        arrayList.add("bank0");
        arrayList.add("bank1");
        arrayList.add("bank2");
        arrayList.add("bank3");
        arrayList.add("bankS");
        arrayList.add("address");
        arrayList.add("sram");
        arrayList.add("vaddress");
        arrayList.add("scanline");
        arrayList.add("ime");
        arrayList.add("ie");
        this.debugFile = DebugFile.from(file, this.symbols, arrayList, string, warningHandler);
        this.debugFileInterpreter = new DebugFileInterpreter(this, this.debugFile);
        return this.debugFile;
    }

    public Set<File> getDebugfileIncludedFiles() {
        if (this.debugFile != null) {
            return this.debugFile.getIncludedFiles();
        }
        return Collections.emptySet();
    }

    public String getSymbol(int n) {
        Symbols.Symbol symbol;
        if (this.isRAMaddress(n)) {
            Symbols.Symbol symbol2;
            Symbols.Symbol symbol3 = Symbols.findRAMSymbol(n, this.symbolsByAddress);
            if (symbol3 == null && (symbol2 = Symbols.findRAMSymbol(n - 1, this.symbolsByAddress)) != null) {
                return String.valueOf(symbol2.getLabel()) + " + 1";
            }
            return symbol3 != null ? symbol3.getLabel() : null;
        }
        Symbols.Symbol symbol4 = Symbols.findSymbol(n, this.symbolsByAddress);
        if (symbol4 == null && (symbol = Symbols.findSymbol(n, this.symbolsByAddress)) != null) {
            return String.valueOf(symbol.getLabel()) + " + 1";
        }
        return symbol4 != null ? symbol4.getLabel() : null;
    }

    public void loadCoverage(File file) {
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[COVERAGE_DATA_SIGNATURE.length()];
            bufferedInputStream.read(byArray);
            String string = new String(byArray);
            if (!COVERAGE_DATA_SIGNATURE.equals(string)) {
                bufferedInputStream.close();
                throw new UnsupportedOperationException("Invalid signature!");
            }
            int n2 = bufferedInputStream.read();
            if (n2 < 1 || n2 > 1) {
                bufferedInputStream.close();
                throw new UnsupportedOperationException("Invalid version number!");
            }
            GZIPInputStream gZIPInputStream = new GZIPInputStream(bufferedInputStream);
            byArray = IOUtilities.toByteArray(gZIPInputStream);
            gZIPInputStream.close();
            boolean bl = this.recordCoverage;
            this.setRecordCoverage(false);
            this.clearCoverageData();
            this.setRecordCoverage(true);
            this.setRecordCoverage(bl);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
            int n3 = byteBuffer.getInt();
            if (n3 != this.coverage.length) {
                throw new UnsupportedOperationException("Invalid size!");
            }
            this.numCoverage = byteBuffer.getInt();
            this.sumCoverage = byteBuffer.getLong();
            this.maxCoverage = byteBuffer.getLong();
            this.numRamCoverage = byteBuffer.getInt();
            this.sumRamCoverage = byteBuffer.getLong();
            this.maxRamCoverage = byteBuffer.getLong();
            byArray = new byte[this.coverageExclude.size() / 8];
            byteBuffer.get(byArray);
            this.coverageExclude.clear();
            int n4 = 0;
            while (n4 < byArray.length) {
                n = 0;
                while (n < 8) {
                    this.coverageExclude.set(n4 * 8 + (n ^ 7), (byArray[n4] & 1 << n) != 0);
                    ++n;
                }
                ++n4;
            }
            byteBuffer.get(byArray);
            this.ramCoverageExclude.clear();
            n4 = 0;
            while (n4 < byArray.length) {
                n = 0;
                while (n < 8) {
                    this.ramCoverageExclude.set(n4 * 8 + (n ^ 7), (byArray[n4] & 1 << n) != 0);
                    ++n;
                }
                ++n4;
            }
            LongBuffer longBuffer = byteBuffer.asLongBuffer();
            longBuffer.get(this.coverage);
            longBuffer.get(this.ramCoverage);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveCoverage(File file) {
        if (this.numCoverage > 0) {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                bufferedOutputStream.write(COVERAGE_DATA_SIGNATURE.getBytes());
                bufferedOutputStream.write(1);
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bufferedOutputStream);
                ByteBuffer byteBuffer = ByteBuffer.allocate(8 * (this.coverage.length + this.ramCoverage.length)).order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.putInt(this.coverage.length);
                byteBuffer.putInt(this.numCoverage);
                byteBuffer.putLong(this.sumCoverage);
                byteBuffer.putLong(this.maxCoverage);
                byteBuffer.putInt(this.numRamCoverage);
                byteBuffer.putLong(this.sumRamCoverage);
                byteBuffer.putLong(this.maxRamCoverage);
                gZIPOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
                byteBuffer.rewind();
                byte[] byArray = new byte[this.coverageExclude.size() / 8];
                int n = 0;
                while (n < this.coverageExclude.size()) {
                    if (this.coverageExclude.get(n)) {
                        int n2 = n / 8;
                        byArray[n2] = (byte)(byArray[n2] | 1 << (n & 7 ^ 7));
                    }
                    ++n;
                }
                gZIPOutputStream.write(byArray);
                Arrays.fill(byArray, (byte)0);
                n = 0;
                while (n < this.ramCoverageExclude.size()) {
                    if (this.ramCoverageExclude.get(n)) {
                        int n3 = n / 8;
                        byArray[n3] = (byte)(byArray[n3] | 1 << (n & 7 ^ 7));
                    }
                    ++n;
                }
                gZIPOutputStream.write(byArray);
                LongBuffer longBuffer = byteBuffer.asLongBuffer();
                longBuffer.put(this.coverage);
                longBuffer.put(this.ramCoverage);
                gZIPOutputStream.write(byteBuffer.array());
                gZIPOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recreateInvalidBreakpoints() {
        List<Breakpoint> list = this.breakpoints;
        synchronized (list) {
            int n = 0;
            while (n < this.breakpoints.size()) {
                InvalidBreakpoint invalidBreakpoint;
                Breakpoint breakpoint;
                Breakpoint breakpoint2 = this.breakpoints.get(n);
                if (breakpoint2 instanceof InvalidBreakpoint && (breakpoint = (invalidBreakpoint = (InvalidBreakpoint)breakpoint2).recreate(this.breakpointAddressEvaluator)) != breakpoint2) {
                    String string = invalidBreakpoint.getAttributes().get("location");
                    int n2 = this.removeBreakpoint(invalidBreakpoint, true);
                    try {
                        if (VARIABLE_NAME_BREAKPOINT_PORT.equals(string)) {
                            this.addPortBreakpoint(n, breakpoint);
                        } else if ("ram".equals(string)) {
                            this.addRAMbreakpoint(n, breakpoint);
                        } else if ("vram".equals(string)) {
                            this.addVRAMbreakpoint(n, breakpoint);
                        } else if ("sram".equals(string)) {
                            this.addSRAMbreakpoint(n, breakpoint);
                        } else if (string != null && !"rom".equals(string)) {
                            this.addMemoryLocationBreakpoint(string, n, breakpoint);
                        } else {
                            this.addROMbreakpoint(n, breakpoint);
                        }
                    }
                    catch (Exception exception) {
                        this.breakpoints.add(n2, invalidBreakpoint);
                    }
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBreakpoints(File file) {
        Properties properties = Emulicious.getProperties();
        String string = this.getDecoratedSystem().getClass().getSimpleName();
        int[] nArray = this.getErrorCodes();
        int n = 0;
        while (n < this.errorBreakpointEnabled.length) {
            int n2 = nArray[n];
            this.errorBreakpointEnabled[n] = Boolean.parseBoolean(properties.getProperty(String.valueOf(string) + "ErrorBreakpointEnabled" + n2));
            this.errorBreakpointSuspend[n] = Boolean.parseBoolean(properties.getProperty(String.valueOf(string) + "ErrorBreakpointSuspend" + n2, "true"));
            this.errorBreakpointCondition[n] = properties.getProperty(String.valueOf(string) + "ErrorBreakpointCondition" + n2);
            this.errorBreakpointMessage[n] = properties.getProperty(String.valueOf(string) + "ErrorBreakpointMessage" + n2);
            ++n;
        }
        List<Breakpoint> list = this.breakpoints;
        synchronized (list) {
            this.clearBreakpoints();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    try {
                        Map<String, String> map = Breakpoint.parseAttributes(string2);
                        Breakpoint breakpoint = Breakpoint.create(map, this.breakpointAddressEvaluator);
                        if (breakpoint instanceof InvalidBreakpoint) {
                            this.breakpoints.add(breakpoint);
                        } else if (breakpoint != null) {
                            String string3 = map.get("location");
                            if (VARIABLE_NAME_BREAKPOINT_PORT.equals(string3)) {
                                this.addPortBreakpoint(breakpoint);
                            } else if ("ram".equals(string3)) {
                                this.addRAMbreakpoint(breakpoint);
                            } else if ("vram".equals(string3)) {
                                this.addVRAMbreakpoint(breakpoint);
                            } else if ("sram".equals(string3)) {
                                this.addSRAMbreakpoint(breakpoint);
                            } else if (string3 != null && !"rom".equals(string3)) {
                                this.addMemoryLocationBreakpoint(string3, breakpoint);
                            } else {
                                this.addROMbreakpoint(breakpoint);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void saveBreakpoints(File file) {
        Properties properties = Emulicious.getProperties();
        String string = this.getDecoratedSystem().getClass().getSimpleName();
        int[] nArray = this.getErrorCodes();
        int n = 0;
        while (n < this.errorBreakpointEnabled.length) {
            int n2 = nArray[n];
            if (Emulicious.getErrorBreakpointLabel(this.getDecoratedSystem(), n) != null) {
                properties.setProperty(String.valueOf(string) + "ErrorBreakpointEnabled" + n2, Boolean.toString(this.errorBreakpointEnabled[n]));
                properties.setProperty(String.valueOf(string) + "ErrorBreakpointSuspend" + n2, Boolean.toString(this.errorBreakpointSuspend[n]));
                properties.setProperty(String.valueOf(string) + "ErrorBreakpointCondition" + n2, this.getErrorBreakpointCondition(n));
                properties.setProperty(String.valueOf(string) + "ErrorBreakpointMessage" + n2, this.getErrorBreakpointMessage(n));
            }
            ++n;
        }
        List<Breakpoint> list = this.getBreakpoints();
        if (!list.isEmpty()) {
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                for (Breakpoint breakpoint : list) {
                    try {
                        printWriter.println(breakpoint + (breakpoint instanceof Watchpoint ? " location=" + this.locationToString(breakpoint) : ""));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            file.delete();
        }
    }

    public final String locationToString(Breakpoint breakpoint) {
        if (breakpoint == null || breakpoint instanceof InvalidBreakpoint) {
            return "";
        }
        if (this.isPortBreakpoint(breakpoint)) {
            return VARIABLE_NAME_BREAKPOINT_PORT;
        }
        if (this.isROMbreakpoint(breakpoint)) {
            return "rom";
        }
        if (this.isRAMbreakpoint(breakpoint)) {
            return "ram";
        }
        if (this.isVRAMbreakpoint(breakpoint)) {
            return "vram";
        }
        if (this.isSRAMbreakpoint(breakpoint)) {
            return "sram";
        }
        for (String string : this.memoryLocationBreakpoints.keySet()) {
            if (!this.isMemoryLocationBreakpoint(string, breakpoint)) continue;
            return string;
        }
        throw new IllegalArgumentException("Location of breakpoint is unknown: " + breakpoint);
    }

    @Override
    public void memoryChanged(int n) {
        this.fireMemoryChanged(n);
    }

    @Override
    public void messageSent(String string) {
        this.fireMessageReceived(this.messageHandler != null ? this.messageHandler.handleMessage(this.getDecoratedSystem(), string) : string);
    }

    @Override
    public void errorOccurred(int n, int n2) {
        if (n == -1) {
            this.handleReadUninitializedMemory(n2, this.peekByte(n2));
        } else {
            this.handleErrorBreakpoint(n, n2);
        }
    }

    @Override
    public void inputStateChanged(long l) {
        this.inputStack.push(this.executedCycles, l);
    }

    @Override
    public void vramRead(int n, int n2) {
        if (!this.skipExceptions && this.isInterruptBreakpointEnabled() && this.isInterruptBreakpointConditionMet() && !this.isExecutingInterrupt() && this.lastVAwriteDuringInterrupt && this.getVRAMaddress() != this.interruptedVA) {
            this.setErrorBreakpointHit(String.format("Inconsistent state after interrupt: VRAM address changed from %04X to %04X", this.interruptedVA, this.getVRAMaddress()), this.getInterruptBreakpointMessageExpression(), this.isInterruptBreakpointSuspend());
            return;
        }
        boolean bl = this.isSuspended();
        Breakpoint[] breakpointArray = this.getVRAMbreakpoints(n);
        int n3 = breakpointArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Breakpoint breakpoint = breakpointArray[n4];
            if (breakpoint instanceof Watchpoint && this.isBreakpointEnabled(breakpoint) && ((Watchpoint)breakpoint).isRead()) {
                this.handleVRAMreadWatchpoint((Watchpoint)breakpoint, n, n2);
            }
            ++n4;
        }
        if (!bl) {
            this.sleepWhileSuspended();
        }
    }

    @Override
    public void vramWrite(int n, int n2, int n3) {
        if (!this.skipExceptions && this.isInterruptBreakpointEnabled() && this.isInterruptBreakpointConditionMet() && !this.isExecutingInterrupt() && this.lastVAwriteDuringInterrupt && this.getVRAMaddress() != this.interruptedVA) {
            this.setErrorBreakpointHit(String.format("Inconsistent state after interrupt: VRAM address changed from %04X to %04X", this.interruptedVA, this.getVRAMaddress()), this.getInterruptBreakpointMessageExpression(), this.isInterruptBreakpointSuspend());
            return;
        }
        boolean bl = this.isSuspended();
        Breakpoint[] breakpointArray = this.getVRAMbreakpoints(n);
        int n4 = breakpointArray.length;
        int n5 = 0;
        while (n5 < n4) {
            Breakpoint breakpoint = breakpointArray[n5];
            if (breakpoint instanceof Watchpoint && this.isBreakpointEnabled(breakpoint) && ((Watchpoint)breakpoint).isWrite()) {
                this.handleVRAMwriteWatchpoint((Watchpoint)breakpoint, n, n2, n3);
            }
            ++n5;
        }
        if (!bl) {
            this.sleepWhileSuspended();
        }
    }

    @Override
    public void vramAddressWritten() {
        this.lastVAwriteDuringInterrupt = this.isExecutingInterrupt();
    }

    @Override
    public void vramAddressWriteCancelled() {
        if (!this.skipExceptions && this.isExecutingInterrupt() && this.isInterruptBreakpointEnabled() && this.isInterruptBreakpointConditionMet()) {
            this.setErrorBreakpointHit("VRAM address write cancelled by interrupt", this.getInterruptBreakpointMessageExpression(), this.isInterruptBreakpointSuspend());
        }
    }

    private final void handleVRAMwriteWatchpoint(Watchpoint watchpoint, int n, int n2, int n3) {
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, n);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OLDVALUE, n2);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_VALUE, n3);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OPERATION, 1);
        if (watchpoint.isWrite() && this.isBreakpointConditionMet(watchpoint)) {
            this.setBreakpointHit(watchpoint, String.format("Watchpoint hit: Writing %02X to VRAM at %s", n3, this.vramAddressToString(n)), watchpoint.isSuspend());
        }
    }

    private final void handleVRAMreadWatchpoint(Watchpoint watchpoint, int n, int n2) {
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, n);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OLDVALUE, n2);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_VALUE, n2);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OPERATION, 0);
        if (watchpoint.isRead() && this.isBreakpointConditionMet(watchpoint)) {
            this.setBreakpointHit(watchpoint, String.format("Watchpoint hit: Reading %02X from VRAM at %s", n2, this.vramAddressToString(n)), watchpoint.isSuspend());
        }
    }

    @Override
    public void memoryLocationWrite(String string, int n, int n2, int n3) {
        boolean bl = this.isSuspended();
        Breakpoint[] breakpointArray = this.getMemoryLocationBreakpoints(string, n);
        int n4 = breakpointArray.length;
        int n5 = 0;
        while (n5 < n4) {
            Breakpoint breakpoint = breakpointArray[n5];
            if (breakpoint instanceof Watchpoint && this.isBreakpointEnabled(breakpoint) && ((Watchpoint)breakpoint).isWrite()) {
                this.handleWatchpointWrite((Watchpoint)breakpoint, n, n2, n3);
            }
            ++n5;
        }
        if (!bl) {
            this.sleepWhileSuspended();
        }
    }

    private final void handleWatchpointWrite(Watchpoint watchpoint, int n, int n2, int n3) {
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, n);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OLDVALUE, n2);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_VALUE, n3);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OPERATION, 1);
        if (watchpoint.isWrite() && this.isBreakpointConditionMet(watchpoint)) {
            this.setBreakpointHit(watchpoint, String.format("%s Watchpoint hit: Writing %02X to %X", this.locationToString(watchpoint).toUpperCase(), n3, n), watchpoint.isSuspend());
        }
    }

    @Override
    public void memoryLocationRead(String string, int n, int n2) {
        boolean bl = this.isSuspended();
        Breakpoint[] breakpointArray = this.getMemoryLocationBreakpoints(string, n);
        int n3 = breakpointArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Breakpoint breakpoint = breakpointArray[n4];
            if (breakpoint instanceof Watchpoint && this.isBreakpointEnabled(breakpoint) && ((Watchpoint)breakpoint).isRead()) {
                this.handleWatchpointRead((Watchpoint)breakpoint, n, n2);
            }
            ++n4;
        }
        if (!bl) {
            this.sleepWhileSuspended();
        }
    }

    private final void handleWatchpointRead(Watchpoint watchpoint, int n, int n2) {
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_ADDRESS, n);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OLDVALUE, n2);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_VALUE, n2);
        this.breakpointVariables.put(VARIABLE_NAME_BREAKPOINT_OPERATION, n == this.getPrevPC() || n == this.getPC() || n == this.getPC() - 1 ? 2 : 0);
        if (watchpoint.isRead() && this.isBreakpointConditionMet(watchpoint)) {
            this.setBreakpointHit(watchpoint, String.format("%s Watchpoint hit: Reading %02X from %X", this.locationToString(watchpoint).toUpperCase(), n2, n), watchpoint.isSuspend());
        }
    }

    public int mapToRomAddress(int n) {
        if (this.isROMaddress(n)) {
            return this.mapAddress(n);
        }
        return this.convertAddress(n);
    }

    public int getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(int n, int n2) {
        super.setAddress(n, n2);
        this.address = this.mapToRomAddress(this.getPC());
        this.requestGUIupdate();
    }

    public int getReturnAddress() {
        int n = this.getStackStart() + this.getStackLength();
        int n2 = this.getStackPointer();
        while (n2 + 1 < n) {
            if (this.getStackSource(n2) == 0) {
                return this.peekByte(n2 + 1) << 8 | this.peekByte(n2);
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public void setMemoryAt(int n, int[] nArray) {
        super.setMemoryAt(n, nArray);
        this.syncLazyState();
        this.requestGUIupdate();
    }

    @Override
    public void setRegValue(int n, int n2) {
        super.setRegValue(n, n2);
        if (n == this.indexOfPC()) {
            this.address = this.mapToRomAddress(this.getPC());
        }
        this.requestGUIupdate();
    }

    @Override
    public void setFlagSet(int n, boolean bl) {
        super.setFlagSet(n, bl);
        this.requestGUIupdate();
    }

    @Override
    public void setDebugger(DebuggableSystem debuggableSystem) {
        if (debuggableSystem != this) {
            this.biosSkipped = true;
            this.removeSystemEventListener(this);
            this.removePortListener(this.portListener);
            this.suspended = false;
            Emulicious.startSound();
        }
        super.setDebugger(debuggableSystem);
    }

    private void addAction(Action action) {
        this.undoStack.push(action);
        this.redoStack.clear();
        if (this.undoStack.size() > 30 / Math.max(1, this.getRAM().length / 524288)) {
            this.undoStack.removeLast();
        }
    }

    public boolean canUndo() {
        return this.isSuspended() && !this.undoStack.isEmpty();
    }

    public boolean canRedo() {
        return this.isSuspended() && !this.redoStack.isEmpty();
    }

    public void undo() {
        if (this.canUndo()) {
            Action action = this.undoStack.pop();
            this.redoStack.push(new Action(action.getName(), this.getState().clone()));
            this.setState(action.getState(), false, false);
        }
    }

    public void redo() {
        if (this.canRedo()) {
            Action action = this.redoStack.pop();
            this.undoStack.push(new Action(action.getName(), this.getState().clone()));
            this.setState(action.getState(), false, false);
        }
    }

    public String getUndoText() {
        return this.canUndo() ? "Undo " + this.undoStack.peek().getName() : "Undo";
    }

    public String getRedoText() {
        return this.canRedo() ? "Redo " + this.redoStack.peek().getName() : "Redo";
    }

    public final void fireReset() {
        SystemListener[] systemListenerArray = this.systemListeners;
        int n = this.systemListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SystemListener systemListener = systemListenerArray[n2];
            systemListener.reset();
            ++n2;
        }
    }

    public final void fireChangeOccurred() {
        SystemListener[] systemListenerArray = this.systemListeners;
        int n = this.systemListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SystemListener systemListener = systemListenerArray[n2];
            systemListener.changeOccurred();
            ++n2;
        }
    }

    public final void fireExecutingInstruction() {
        SystemListener[] systemListenerArray = this.systemListeners;
        int n = this.systemListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SystemListener systemListener = systemListenerArray[n2];
            systemListener.executingInstruction();
            ++n2;
        }
    }

    public final void fireInstructionExecuted() {
        SystemListener[] systemListenerArray = this.systemListeners;
        int n = this.systemListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SystemListener systemListener = systemListenerArray[n2];
            systemListener.instructionExecuted();
            ++n2;
        }
    }

    public final void fireMemoryChanged(int n) {
        SystemListener[] systemListenerArray = this.systemListeners;
        int n2 = this.systemListeners.length;
        int n3 = 0;
        while (n3 < n2) {
            SystemListener systemListener = systemListenerArray[n3];
            systemListener.memoryChanged(n);
            ++n3;
        }
    }

    public final void fireCallExecuted(int n, int n2) {
        SystemListener[] systemListenerArray = this.systemListeners;
        int n3 = this.systemListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemListener systemListener = systemListenerArray[n4];
            systemListener.callExecuted(n, n2);
            ++n4;
        }
    }

    public final void fireStackReadOccurred(int n) {
        SystemListener[] systemListenerArray = this.systemListeners;
        int n2 = this.systemListeners.length;
        int n3 = 0;
        while (n3 < n2) {
            SystemListener systemListener = systemListenerArray[n3];
            systemListener.stackReadOccurred(n);
            ++n3;
        }
    }

    public final void fireStackWriteOccurred(int n, int n2) {
        SystemListener[] systemListenerArray = this.systemListeners;
        int n3 = this.systemListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemListener systemListener = systemListenerArray[n4];
            systemListener.stackWriteOccurred(n, n2);
            ++n4;
        }
    }

    public final void fireInterruptTaken(int n, int n2) {
        SystemListener[] systemListenerArray = this.systemListeners;
        int n3 = this.systemListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemListener systemListener = systemListenerArray[n4];
            systemListener.interruptTaken(n, n2);
            ++n4;
        }
    }

    public final void fireInterruptExited(int n) {
        SystemListener[] systemListenerArray = this.systemListeners;
        int n2 = this.systemListeners.length;
        int n3 = 0;
        while (n3 < n2) {
            SystemListener systemListener = systemListenerArray[n3];
            systemListener.interruptExited(n);
            ++n3;
        }
    }

    public final void fireFrameFinished() {
        SystemListener[] systemListenerArray = this.systemListeners;
        int n = this.systemListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SystemListener systemListener = systemListenerArray[n2];
            systemListener.frameFinished();
            ++n2;
        }
    }

    public final void fireBreakpointHit(Breakpoint breakpoint, int n, int n2, String string) {
        BreakpointListener[] breakpointListenerArray = this.breakpointListeners;
        int n3 = this.breakpointListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            BreakpointListener breakpointListener = breakpointListenerArray[n4];
            breakpointListener.breakpointHit(breakpoint, n, n2, string);
            ++n4;
        }
    }

    public final void fireBreakpointHitCleared() {
        BreakpointListener[] breakpointListenerArray = this.breakpointListeners;
        int n = this.breakpointListeners.length;
        int n2 = 0;
        while (n2 < n) {
            BreakpointListener breakpointListener = breakpointListenerArray[n2];
            breakpointListener.breakpointHitCleared();
            ++n2;
        }
    }

    public final void fireBreakpointsCleared() {
        BreakpointListener[] breakpointListenerArray = this.breakpointListeners;
        int n = this.breakpointListeners.length;
        int n2 = 0;
        while (n2 < n) {
            BreakpointListener breakpointListener = breakpointListenerArray[n2];
            breakpointListener.breakpointsCleared();
            ++n2;
        }
    }

    public final void fireBreakpointAdded(Breakpoint breakpoint) {
        BreakpointListener[] breakpointListenerArray = this.breakpointListeners;
        int n = this.breakpointListeners.length;
        int n2 = 0;
        while (n2 < n) {
            BreakpointListener breakpointListener = breakpointListenerArray[n2];
            breakpointListener.breakpointAdded(breakpoint);
            ++n2;
        }
    }

    public final void fireBreakpointChanged(Breakpoint breakpoint) {
        BreakpointListener[] breakpointListenerArray = this.breakpointListeners;
        int n = this.breakpointListeners.length;
        int n2 = 0;
        while (n2 < n) {
            BreakpointListener breakpointListener = breakpointListenerArray[n2];
            breakpointListener.breakpointChanged(breakpoint);
            ++n2;
        }
    }

    public final void fireBreakpointRemoved(Breakpoint breakpoint, int n, boolean bl) {
        BreakpointListener[] breakpointListenerArray = this.breakpointListeners;
        int n2 = this.breakpointListeners.length;
        int n3 = 0;
        while (n3 < n2) {
            BreakpointListener breakpointListener = breakpointListenerArray[n3];
            breakpointListener.breakpointRemoved(breakpoint, n, bl);
            ++n3;
        }
    }

    public final void fireMessageReceived(String string) {
        MessageReceiver[] messageReceiverArray = this.messageReceivers;
        int n = this.messageReceivers.length;
        int n2 = 0;
        while (n2 < n) {
            MessageReceiver messageReceiver = messageReceiverArray[n2];
            messageReceiver.messageReceived(string);
            ++n2;
        }
    }

    public final void fireAlert(String string) {
        MessageReceiver[] messageReceiverArray = this.messageReceivers;
        int n = this.messageReceivers.length;
        int n2 = 0;
        while (n2 < n) {
            MessageReceiver messageReceiver = messageReceiverArray[n2];
            messageReceiver.alert(string);
            ++n2;
        }
    }

    public final void addSystemListener(SystemListener systemListener) {
        if (!this.systemListenerList.contains(systemListener)) {
            this.systemListenerList.add(systemListener);
            this.systemListeners = this.systemListenerList.toArray(new SystemListener[this.systemListenerList.size()]);
        }
    }

    public final void removeSystemListener(SystemListener systemListener) {
        if (this.systemListenerList.remove(systemListener)) {
            this.systemListeners = this.systemListenerList.toArray(new SystemListener[this.systemListenerList.size()]);
        }
    }

    public final void addBreakpointListener(BreakpointListener breakpointListener) {
        if (!this.breakpointListenerList.contains(breakpointListener)) {
            this.breakpointListenerList.add(breakpointListener);
            this.breakpointListeners = this.breakpointListenerList.toArray(new BreakpointListener[this.breakpointListenerList.size()]);
        }
    }

    public final void removeBreakpointListener(BreakpointListener breakpointListener) {
        if (this.breakpointListenerList.remove(breakpointListener)) {
            this.breakpointListeners = this.breakpointListenerList.toArray(new BreakpointListener[this.breakpointListenerList.size()]);
        }
    }

    public final void addMessageReceiver(MessageReceiver messageReceiver) {
        if (!this.messageReceiverList.contains(messageReceiver)) {
            this.messageReceiverList.add(messageReceiver);
            this.messageReceivers = this.messageReceiverList.toArray(new MessageReceiver[this.messageReceiverList.size()]);
        }
    }

    public final void removeMessageReceiver(MessageReceiver messageReceiver) {
        if (this.messageReceiverList.remove(messageReceiver)) {
            this.messageReceivers = this.messageReceiverList.toArray(new MessageReceiver[this.messageReceiverList.size()]);
        }
    }

    private static class Action {
        private final String name;
        private final EmulatableSystem.State state;

        public Action(String string, EmulatableSystem.State state) {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("name must not be null or empty");
            }
            if (state == null) {
                throw new IllegalArgumentException("state must not be null");
            }
            this.name = string;
            this.state = state;
        }

        public String getName() {
            return this.name;
        }

        public EmulatableSystem.State getState() {
            return this.state;
        }
    }

    public static interface BreakpointListener {
        public void breakpointHit(Breakpoint var1, int var2, int var3, String var4);

        public void breakpointHitCleared();

        public void breakpointsCleared();

        public void breakpointAdded(Breakpoint var1);

        public void breakpointRemoved(Breakpoint var1, int var2, boolean var3);

        public void breakpointChanged(Breakpoint var1);
    }

    private class CyclicStateBuffer {
        private final StateContainer[] elements;
        private final int MASK;
        private int head;
        private int tail;

        public CyclicStateBuffer(int n) {
            --n;
            n |= n >>> 1;
            n |= n >>> 2;
            n |= n >>> 4;
            n |= n >>> 8;
            n |= n >>> 16;
            if (++n < 0) {
                n >>>= 1;
            }
            this.elements = new StateContainer[n];
            int n2 = 0;
            while (n2 < this.elements.length) {
                this.elements[n2] = new StateContainer();
                ++n2;
            }
            this.MASK = this.elements.length - 1;
        }

        public void push(EmulatableSystem.State state, long l, long l2, long l3) {
            this.head = this.head - 1 & this.MASK;
            this.elements[this.head].setState(state, l, l2, l3);
            if (this.head == this.tail) {
                this.tail = this.tail - 1 & this.MASK;
            }
            SystemDebugger.this.framesSinceLastState = 0;
        }

        public int indexOf(long l) {
            if (this.head == this.tail) {
                return -1;
            }
            int n = this.head & this.MASK;
            do {
                if (l - this.elements[n].getCycles() < 0L) continue;
                return n - this.head & this.MASK;
            } while ((n = n + 1 & this.MASK) != this.tail);
            return -1;
        }

        public void dropStatesAfter(long l) {
            while (this.head != this.tail && this.elements[this.head].getCycles() > l) {
                this.head = this.head + 1 & this.MASK;
            }
        }

        public StateContainer get(int n) {
            return this.elements[this.head + n & this.MASK];
        }

        public void clear() {
            this.tail = 0;
            this.head = 0;
        }
    }

    private class InputStack {
        private long[] elements;
        private int size;
        private int capacityIncrement;

        public InputStack(int n) {
            this(n, n);
        }

        public InputStack(int n, int n2) {
            this.elements = new long[n * 2];
            this.capacityIncrement = n2 * 2;
        }

        public void push(long l, long l2) {
            if (this.size + 2 >= this.elements.length) {
                long[] lArray = new long[this.elements.length + this.capacityIncrement];
                System.arraycopy(this.elements, 0, lArray, 0, this.elements.length);
                this.elements = lArray;
            }
            this.elements[this.size++] = l;
            this.elements[this.size++] = l2;
        }

        public int indexOf(long l) {
            if (this.size == 0) {
                return -1;
            }
            int n = this.size - 2;
            while (n - 2 >= 0 && l - this.elements[n - 2] >= 0L) {
                n -= 2;
            }
            return n / 2;
        }

        public long getCycles(int n) {
            if (n * 2 >= this.size) {
                return Long.MAX_VALUE;
            }
            return this.elements[n * 2];
        }

        public long getInputState(int n) {
            if (n * 2 >= this.size) {
                return 0L;
            }
            return this.elements[n * 2 + 1];
        }

        public void dropInputAfter(long l) {
            while (this.size - 2 >= 0 && this.elements[this.size - 2] > l) {
                this.size -= 2;
            }
        }

        public void clear() {
            this.size = 0;
        }
    }

    private class InterruptedState {
        private final int address;
        private final int stackAddress;
        private int[] registers;
        private int[] banks = new int[4];

        public InterruptedState(int n, int n2) {
            this.address = n;
            this.stackAddress = n2;
        }

        boolean isAt(int n, int n2) {
            return n >= this.stackAddress && n2 == this.address;
        }

        void populate() {
            this.registers = SystemDebugger.this.getRegValues();
            boolean bl = false;
            int n = this.registers.length - 1;
            while (n >= 0 && !bl) {
                if (!SystemDebugger.this.isAdditionalRegister(n) && this.registers[n] == SystemDebugger.this.getSP() && !bl) {
                    int n2 = n;
                    this.registers[n2] = this.registers[n2] + 2;
                    bl = true;
                }
                --n;
            }
            this.registers[SystemDebugger.this.indexOfPC()] = SystemDebugger.this.getPrevPC();
            this.banks[0] = SystemDebugger.this.getBank0();
            this.banks[1] = SystemDebugger.this.getBank1();
            this.banks[2] = SystemDebugger.this.getBank2();
            this.banks[3] = SystemDebugger.this.getBank3();
        }

        int[] getRegisters() {
            return this.registers;
        }

        int[] getBanks() {
            return this.banks;
        }
    }

    public static interface MessageReceiver {
        public void messageReceived(String var1);

        public void alert(String var1);
    }

    private class StateContainer {
        private final EmulatableSystem.State state;
        private long cycles;
        private long prevInstructionExecutedCycles;
        private long prevMappedInstructionExecutedCycles;

        private StateContainer() {
            this.state = SystemDebugger.this.createMutableState();
        }

        public void setState(EmulatableSystem.State state, long l, long l2, long l3) {
            try {
                this.state.setState(state);
                this.cycles = l;
                this.prevInstructionExecutedCycles = l2;
                this.prevMappedInstructionExecutedCycles = l3;
            }
            catch (UnmodifiableClassException unmodifiableClassException) {
                unmodifiableClassException.printStackTrace();
            }
        }

        public long getCycles() {
            return this.cycles;
        }

        public long getPrevInstructionExecutedCycles() {
            return this.prevInstructionExecutedCycles;
        }

        public long getPrevMappedInstructionExecutedCycles() {
            return this.prevMappedInstructionExecutedCycles;
        }

        public EmulatableSystem.State getState() {
            return this.state;
        }
    }

    public static interface SystemListener {
        public void reset();

        public void changeOccurred();

        public void executingInstruction();

        public void instructionExecuted();

        public void memoryChanged(int var1);

        public void callExecuted(int var1, int var2);

        public void stackReadOccurred(int var1);

        public void stackWriteOccurred(int var1, int var2);

        public void interruptTaken(int var1, int var2);

        public void interruptExited(int var1);

        public void frameFinished();
    }
}

