/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import disassembler.Z80Disassembler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import platform.Emulicious;
import platform.debugger.Debugger;

public class ReferenceHierarchyWindow
extends JDialog {
    private static ReferenceHierarchyWindow window;
    final Debugger debugger;

    private ReferenceHierarchyWindow(Window window, final Debugger debugger, Z80Disassembler.Reference reference) {
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Reference Hierarchy");
        this.setIconImages(window.getIconImages());
        this.debugger = debugger;
        final JTree jTree = new JTree(new ReferenceTreeNode(reference)){

            @Override
            public void setRowHeight(int n) {
                if (n > 0) {
                    super.setRowHeight(n);
                    if (this.getCellRenderer() != null && this.getMaxIconHeight() != n - 2) {
                        try {
                            this.scaleIcons((float)(n - 2) / (float)this.getMaxDefaultIconHeight());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }

            private int getMaxIconHeight() {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
                if (defaultTreeCellRenderer == null) {
                    return 0;
                }
                return Math.max(this.getIconHeight(defaultTreeCellRenderer.getOpenIcon()), Math.max(this.getIconHeight(defaultTreeCellRenderer.getClosedIcon()), this.getIconHeight(defaultTreeCellRenderer.getLeafIcon())));
            }

            private int getIconHeight(Icon icon) {
                if (icon == null) {
                    return 0;
                }
                return icon.getIconHeight();
            }

            private int getMaxDefaultIconHeight() {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
                if (defaultTreeCellRenderer == null) {
                    return 0;
                }
                return Math.max(this.getIconHeight(defaultTreeCellRenderer.getDefaultOpenIcon()), Math.max(this.getIconHeight(defaultTreeCellRenderer.getDefaultClosedIcon()), this.getIconHeight(defaultTreeCellRenderer.getDefaultLeafIcon())));
            }

            private Icon scaleIcon(Icon icon, float f) {
                if (icon == null || (int)((float)icon.getIconWidth() * f) >= Integer.MAX_VALUE || (int)((float)icon.getIconHeight() * f) >= Integer.MAX_VALUE) {
                    return icon;
                }
                BufferedImage bufferedImage = new BufferedImage(Math.round((float)icon.getIconWidth() * f), Math.round((float)icon.getIconHeight() * f), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.scale(f, f);
                icon.paintIcon(this, graphics2D, 0, 0);
                graphics2D.dispose();
                return new ImageIcon(bufferedImage);
            }

            private void scaleIcons(float f) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
                if (defaultTreeCellRenderer != null) {
                    if (defaultTreeCellRenderer.getOpenIcon() != null) {
                        defaultTreeCellRenderer.setOpenIcon(this.scaleIcon(defaultTreeCellRenderer.getDefaultOpenIcon(), f));
                    }
                    if (defaultTreeCellRenderer.getClosedIcon() != null) {
                        defaultTreeCellRenderer.setClosedIcon(this.scaleIcon(defaultTreeCellRenderer.getDefaultClosedIcon(), f));
                    }
                    if (defaultTreeCellRenderer.getLeafIcon() != null) {
                        defaultTreeCellRenderer.setLeafIcon(this.scaleIcon(defaultTreeCellRenderer.getDefaultLeafIcon(), f));
                    }
                }
            }

            @Override
            public boolean isLargeModel() {
                return true;
            }

            @Override
            public Color getForeground() {
                return debugger.getTableForeground();
            }

            @Override
            public Color getBackground() {
                return debugger.getTableBackground();
            }

            @Override
            public void doLayout() {
                this.setRowHeight(this.getCellRenderer().getTreeCellRendererComponent((JTree)this, (Object)"Outline", (boolean)false, (boolean)false, (boolean)false, (int)-1, (boolean)false).getPreferredSize().height);
                super.doLayout();
            }
        };
        jTree.setToggleClickCount(0);
        jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                TreePath treePath;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0 && (treePath = jTree.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) instanceof ReferenceTreeNode) {
                    ReferenceTreeNode referenceTreeNode = (ReferenceTreeNode)object;
                    if (referenceTreeNode.isPortReference()) {
                        debugger.setSelectedPort(referenceTreeNode.getAddress());
                    } else if (referenceTreeNode.isRAMreference()) {
                        debugger.setSelectedRAMaddress(referenceTreeNode.getAddress());
                    } else if (referenceTreeNode.isSRAMreference()) {
                        debugger.setSelectedSRAMaddress(referenceTreeNode.getAddress());
                    } else {
                        debugger.setSelectedAddress(referenceTreeNode.getAddress());
                    }
                }
            }
        });
        jTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (object instanceof ReferenceTreeNode) {
                    ReferenceTreeNode referenceTreeNode = (ReferenceTreeNode)object;
                    this.setIcon(ReferenceHierarchyWindow.this.debugger.getDefaultIcon(this.getIcon(), bl3, referenceTreeNode.getIconChar()));
                } else if (n < 0) {
                    this.setIcon(null);
                }
                return component;
            }

            @Override
            public Color getTextSelectionColor() {
                return debugger.getTableSelectionForeground();
            }

            @Override
            public Color getTextNonSelectionColor() {
                return debugger.getTableForeground();
            }

            @Override
            public Color getBackgroundSelectionColor() {
                return debugger.getTableSelectionBackground();
            }

            @Override
            public Color getBackgroundNonSelectionColor() {
                return debugger.getTableBackground();
            }

            @Override
            public Font getFont() {
                return debugger.getFont();
            }
        });
        this.add((Component)new JScrollPane(jTree), "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ReferenceHierarchyWindow.close();
            }
        });
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "Close");
        this.getRootPane().getActionMap().put("Close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferenceHierarchyWindow.close();
            }
        });
        this.setDefaultCloseOperation(2);
        debugger.installRunActions(this.getRootPane());
    }

    private JTree getTree() {
        JScrollPane jScrollPane = (JScrollPane)this.getContentPane().getComponent(0);
        return (JTree)jScrollPane.getViewport().getView();
    }

    public static void close() {
        if (window != null) {
            window.dispose();
            window = null;
        }
    }

    public static void open(Window window, Debugger debugger, Z80Disassembler.Reference reference) {
        ReferenceHierarchyWindow.open(window, debugger, reference, -1);
    }

    public static void open(Window window, Debugger debugger, Z80Disassembler.Reference reference, int n) {
        if (ReferenceHierarchyWindow.window == null) {
            ReferenceHierarchyWindow.window = new ReferenceHierarchyWindow(window, debugger, reference);
        } else {
            JTree jTree = ReferenceHierarchyWindow.window.getTree();
            ReferenceHierarchyWindow referenceHierarchyWindow = ReferenceHierarchyWindow.window;
            referenceHierarchyWindow.getClass();
            jTree.setModel(new JTree(referenceHierarchyWindow.new ReferenceTreeNode(reference)).getModel());
        }
        if (n < 0) {
            ReferenceHierarchyWindow.window.getTree().setSelectionRow(0);
        } else {
            ArrayList<Z80Disassembler.Reference> arrayList = new ArrayList<Z80Disassembler.Reference>(reference.getChildren(Debugger.getLabelProvider()));
            int n2 = 0;
            while (n2 < arrayList.size()) {
                if (((Z80Disassembler.Reference)arrayList.get(n2)).getAddress() == n) {
                    ReferenceHierarchyWindow.window.getTree().setSelectionRow(1 + n2);
                    break;
                }
                ++n2;
            }
        }
        ReferenceHierarchyWindow.window.pack();
        ReferenceHierarchyWindow.window.setLocationRelativeTo(window);
        ReferenceHierarchyWindow.window.setVisible(true);
    }

    private class ReferenceTreeNode
    implements TreeNode {
        private final ReferenceTreeNode parent;
        private final Z80Disassembler.Reference reference;
        private ArrayList<ReferenceTreeNode> children;

        private ReferenceTreeNode(Z80Disassembler.Reference reference, ReferenceTreeNode referenceTreeNode) {
            this.parent = referenceTreeNode;
            this.reference = reference;
        }

        public ReferenceTreeNode(Z80Disassembler.Reference reference) {
            this(reference, null);
        }

        public Enumeration<ReferenceTreeNode> children() {
            return Collections.enumeration(this.getChildren());
        }

        private ArrayList<ReferenceTreeNode> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList();
                for (Z80Disassembler.Reference reference : this.reference.getChildren(Debugger.getLabelProvider())) {
                    this.children.add(new ReferenceTreeNode(reference, this));
                }
            }
            return this.children;
        }

        public int getAddress() {
            return this.reference.getAddress();
        }

        public boolean isPortReference() {
            return this.reference instanceof Z80Disassembler.PortReference;
        }

        public boolean isRAMreference() {
            return this.reference instanceof Z80Disassembler.RamReference;
        }

        public boolean isSRAMreference() {
            return this.reference instanceof Z80Disassembler.SramReference;
        }

        public char getIconChar() {
            return this.reference.isCode() ? (char)'C' : 'D';
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int n) {
            return this.getChildren().get(n);
        }

        @Override
        public int getChildCount() {
            return this.getChildren().size();
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return this.getChildren().indexOf(treeNode);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildren().isEmpty();
        }

        public String toString() {
            if (this.parent == null) {
                if (this.reference.getLabelAddress(Debugger.getLabelProvider()) < 0) {
                    String string = this.reference.getLabelAddress(Debugger.getLabelProvider()) == -3 ? ReferenceHierarchyWindow.this.debugger.getPortLabel(this.reference.getAddress()) : (this.reference.getLabelAddress(Debugger.getLabelProvider()) == -2 ? Debugger.getSramLabel(this.reference.getAddress()) : ReferenceHierarchyWindow.this.debugger.getRamLabel(this.reference.getAddress()));
                    return "References to " + string;
                }
                return "References to " + ReferenceHierarchyWindow.this.debugger.getLabel(this.reference.getLabelAddress(Debugger.getLabelProvider()));
            }
            return String.valueOf(ReferenceHierarchyWindow.this.debugger.getLabel(this.reference.getLabelAddress(Debugger.getLabelProvider()))) + " : " + Integer.toHexString(this.getAddress()).toUpperCase();
        }
    }
}

