/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import assembler.AbstractZ80ParseResult;
import assembler.LR35902Assembler;
import assembler.Z80Assembler;
import assembler.Z80Instruction;
import assembler.Z80SourceLine;
import assembler.parsers.ExpressionEvaluator;
import assembler.parsers.UnknownIdentifierException;
import assembler.rgbds.RGBDSParser;
import assembler.wladx.WLAParser;
import disassembler.Symbols;
import disassembler.Z80Disassembler;
import disassembler.dialects.AssemblerDialect;
import disassembler.dialects.RgbdsDialect;
import expressions.ParseException;
import expressions.UnknownVariableException;
import expressions.VariableProvider;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import platform.Emulicious;
import platform.debugger.Debugger;

public class AssemblerWindow
extends JDialog {
    private static final int MAX_BYTE_PREFIX = 16;

    private AssemblerWindow(Window window, final Debugger debugger, char c, final int n, final Map<String, List<Symbols.Symbol>> map, final Map<String, Integer> map2) {
        super(window, String.valueOf(Emulicious.TITLE) + " - Assembler", DEFAULT_MODALITY_TYPE);
        this.setIconImages(window.getIconImages());
        JLabel jLabel = new JLabel("<html>This assembler currently is a prototype and will be improved in the future.<br>Please report any issues you might enocunter.</html>");
        jLabel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.add((Component)jLabel, "North");
        final JTextPane jTextPane = new JTextPane();
        jTextPane.setText("\t\t\t\t\t\n\n\n\n\n\n\n\n\n\n");
        this.add((Component)new JScrollPane(jTextPane), "Center");
        JPanel jPanel = new JPanel();
        final JButton jButton = new JButton("OK");
        final HashMap hashMap = new HashMap();
        final VariableProvider variableProvider = new VariableProvider(){

            @Override
            public int readValue(int n, boolean bl, boolean bl2) {
                throw new UnsupportedOperationException("Cannot read variables");
            }

            @Override
            public int readLocation(String string, int n, boolean bl) throws UnknownVariableException {
                throw new UnsupportedOperationException("Cannot read locations");
            }

            @Override
            public int getBankAt(int n) {
                throw new UnsupportedOperationException("Cannot retrieve bank");
            }

            @Override
            public long mapBank(int n, int n2) {
                return debugger.mapAddress(n, n2);
            }

            @Override
            public boolean isConstant(String string) throws UnknownVariableException {
                if (!string.isEmpty() && string.charAt(0) == ':') {
                    string = string.substring(1);
                }
                if (!map.containsKey(string) && !map2.containsKey(string)) {
                    throw new UnknownVariableException(string);
                }
                return true;
            }

            @Override
            public boolean isConstantRead(int n) {
                return true;
            }

            @Override
            public long getValue(String string, boolean bl) throws UnknownVariableException {
                List list;
                boolean bl2;
                boolean bl3 = bl2 = !string.isEmpty() && string.charAt(0) == ':';
                if (bl2) {
                    string = string.substring(1);
                }
                if ((list = (List)map.get(string)) == null) {
                    Integer n = (Integer)map2.get(string);
                    if (n != null) {
                        return n.intValue();
                    }
                    Integer n2 = (Integer)hashMap.get(string);
                    if (n2 != null) {
                        return n2 >= 16384 ? 0x4000 | n2 & 0x3FFF : n2;
                    }
                    int n3 = debugger.getLabelAddress(string);
                    if (n3 >= 0) {
                        return bl2 ? n3 / 16384 : (n3 >= 16384 ? 0x4000 | n3 & 0x3FFF : n3);
                    }
                    throw new UnknownVariableException(string);
                }
                Symbols.Symbol symbol = (Symbols.Symbol)list.get(0);
                if (bl2) {
                    return symbol.getBank();
                }
                return symbol.getAddress();
            }
        };
        final int[] nArray = new int[]{Integer.MIN_VALUE};
        final boolean[] blArray = new boolean[]{true};
        final ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(){

            @Override
            public int evaluate(CharSequence charSequence) throws UnknownIdentifierException {
                try {
                    int n = debugger.parseExpression(charSequence.toString()).getValue(variableProvider);
                    if (nArray[0] != Integer.MIN_VALUE) {
                        n -= nArray[0];
                        nArray[0] = Integer.MIN_VALUE;
                    }
                    return n;
                }
                catch (UnknownVariableException unknownVariableException) {
                    if (blArray[0]) {
                        throw new UnknownIdentifierException(unknownVariableException.getMessage());
                    }
                    throw new RuntimeException(unknownVariableException);
                }
                catch (ParseException parseException) {
                    throw new RuntimeException(parseException);
                }
            }
        };
        final AssemblerDialect assemblerDialect = Z80Disassembler.getDialect();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Z80Assembler z80Assembler = assemblerDialect instanceof RgbdsDialect ? new LR35902Assembler(expressionEvaluator){

                        @Override
                        public Z80Instruction assemble(String string) throws assembler.parsers.ParseException {
                            return super.assemble(string.replace('[', '(').replace(']', ')'));
                        }
                    } : new Z80Assembler(expressionEvaluator){

                        @Override
                        public Z80Instruction assemble(String string) throws assembler.parsers.ParseException {
                            return super.assemble(string.replace('[', '(').replace(']', ')').replace("$-", "-"));
                        }
                    };
                    blArray[0] = true;
                    AbstractZ80ParseResult abstractZ80ParseResult = assemblerDialect instanceof RgbdsDialect ? RGBDSParser.readLines(jTextPane.getText(), 16, z80Assembler, expressionEvaluator) : WLAParser.readLines(jTextPane.getText(), 16, z80Assembler, expressionEvaluator);
                    int n2 = n;
                    for (Z80SourceLine z80SourceLine : abstractZ80ParseResult.getLines()) {
                        if (z80SourceLine.getSize() > 0) {
                            n2 += z80SourceLine.getSize();
                            continue;
                        }
                        Object object2 = object = assemblerDialect instanceof RgbdsDialect ? RGBDSParser.parseLabel(z80SourceLine.toString(), true) : WLAParser.parseLabel(z80SourceLine.toString());
                        if (object == null || object.length() <= 0) continue;
                        hashMap.put(object.toString(), n2);
                    }
                    blArray[0] = false;
                    AbstractZ80ParseResult abstractZ80ParseResult2 = abstractZ80ParseResult = assemblerDialect instanceof RgbdsDialect ? RGBDSParser.readLines(jTextPane.getText(), 16, z80Assembler, expressionEvaluator) : WLAParser.readLines(jTextPane.getText(), 16, z80Assembler, expressionEvaluator);
                    if (!abstractZ80ParseResult.getExceptions().isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder("Assembling failed because of the following Errors:");
                        for (Exception exception : abstractZ80ParseResult.getExceptions()) {
                            stringBuilder.append('\n').append(exception.getMessage());
                        }
                        JOptionPane.showMessageDialog(AssemblerWindow.this, stringBuilder.toString(), "Assembling failed", 0);
                        return;
                    }
                    n2 = n;
                    for (Z80SourceLine z80SourceLine : abstractZ80ParseResult.getLines()) {
                        if (z80SourceLine.getInstruction() != null && z80SourceLine.getInstruction().isRelative()) {
                            try {
                                nArray[0] = n2 + z80SourceLine.getSize();
                                object = z80SourceLine.getBytes();
                                Z80Instruction z80Instruction = z80Assembler.assemble(z80SourceLine.toString());
                                object[1] = z80Instruction.getArg() & 0xFF;
                                debugger.setMemoryBytes(n2, (int[])object);
                            }
                            catch (assembler.parsers.ParseException parseException) {
                                parseException.printStackTrace();
                            }
                            nArray[0] = Integer.MIN_VALUE;
                        } else {
                            debugger.setMemoryBytes(n2, z80SourceLine.getBytes());
                        }
                        n2 += z80SourceLine.getSize();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                AssemblerWindow.this.dispose();
            }
        });
        final JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AssemblerWindow.this.dispose();
            }
        });
        jTextPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && (keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    jButton.doClick();
                }
                if (keyEvent.getKeyCode() == 27) {
                    jButton2.doClick();
                }
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.add((Component)jPanel, "South");
        this.pack();
        this.setLocationRelativeTo(window);
        jTextPane.setText(Character.toString(c));
        this.setVisible(true);
    }

    public static void open(Window window, Debugger debugger, char c, int n, Map<String, List<Symbols.Symbol>> map, Map<String, Integer> map2) {
        if (c > ' ' && Character.isJavaIdentifierPart(c)) {
            new AssemblerWindow(window, debugger, c, n, map, map2);
        }
    }
}

