/*
 * Decompiled with CFR 0.152.
 */
package platform;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import output.SoundAmplitudeListener;
import platform.SoundOutput;

public final class SoundRecorder
implements SoundAmplitudeListener {
    private static final OutputStream[] NO_OUTPUT = new OutputStream[0];
    private static final int SIGNED_RANGE = 65535;
    private static final int UNSIGNED_RANGE = Short.MAX_VALUE;
    private static SoundOutput soundOutput;
    private int[] channelMin;
    private int[] channelMax;
    private File[] rawFiles = new File[0];
    private File rawFileSum;
    private OutputStream[] out = NO_OUTPUT;
    private OutputStream outSum;
    private int sampleSumLeft;
    private int sampleSumRight;
    private boolean firstSample;
    private boolean keepRaw;
    private boolean writeWav = true;
    private boolean writeAiff;
    private static SoundRecorder instance;

    private SoundRecorder() {
    }

    public static SoundRecorder getInstance() {
        if (instance == null) {
            instance = new SoundRecorder();
        }
        return instance;
    }

    public static boolean isRecording() {
        return instance != null && SoundRecorder.instance.out.length > 0;
    }

    @Override
    public void amplitude(int n, boolean bl, int n2) {
        if (this.out.length <= 0 && this.outSum == null) {
            return;
        }
        if (!this.firstSample && this.outSum != null && n == 0) {
            int n3 = this.channelMin[0];
            int n4 = this.channelMax[0];
            int n5 = 1;
            while (n5 < this.channelMin.length) {
                n3 += this.channelMin[n5];
                n4 += this.channelMax[n5];
                ++n5;
            }
            if (bl) {
                SoundRecorder.writeSample(this.outSum, this.sampleSumRight, n3, n4);
                this.sampleSumRight = 0;
            } else {
                SoundRecorder.writeSample(this.outSum, this.sampleSumLeft, n3, n4);
                this.sampleSumLeft = 0;
            }
        }
        this.firstSample = false;
        if (bl) {
            this.sampleSumRight += n2;
        } else {
            this.sampleSumLeft += n2;
        }
        if (n < this.out.length && this.out[n] != null) {
            SoundRecorder.writeSample(this.out[n], n2, this.channelMin[n], this.channelMax[n]);
        }
    }

    private static void writeSample(OutputStream outputStream, int n, int n2, int n3) {
        if (outputStream != null) {
            try {
                int n4 = (n2 + n3 == 0 ? 65535 : Short.MAX_VALUE) * n / (n3 - n2);
                if (n4 > Short.MAX_VALUE) {
                    n4 = Short.MAX_VALUE;
                } else if (n4 < Short.MIN_VALUE) {
                    n4 = Short.MIN_VALUE;
                }
                outputStream.write(n4 & 0xFF);
                outputStream.write(n4 >>> 8);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void boundsChanged() {
    }

    public static void setSoundOutput(SoundOutput soundOutput) {
        if (instance != null && SoundRecorder.soundOutput != null) {
            instance.stopRecording();
        }
        SoundRecorder.soundOutput = soundOutput;
    }

    public void startRecording(File file, File file2, boolean[] blArray) {
        this.startRecording(file, file2, blArray, false);
    }

    public void startRecording(File file, File file2, boolean[] blArray, boolean bl) {
        int n;
        if (this.out.length > 0) {
            return;
        }
        if (soundOutput != null) {
            soundOutput.addAmplitudeListener(this);
        }
        this.channelMin = soundOutput.getChannelMinValues();
        this.channelMax = soundOutput.getChannelMaxValues();
        File[] fileArray = new File[soundOutput.getChannelNames().length];
        OutputStream[] outputStreamArray = new OutputStream[fileArray.length];
        String string = "";
        if (!bl) {
            n = 0;
            while (SoundRecorder.hasNameCollision(file, file2, string)) {
                string = "_" + ++n;
            }
        }
        n = 0;
        while (n < fileArray.length) {
            if (n + 1 < blArray.length && blArray[n + 1]) {
                fileArray[n] = new File(file, String.valueOf(file2.getName()) + string + "_ch" + (n + 1) + ".raw");
                try {
                    outputStreamArray[n] = new BufferedOutputStream(new FileOutputStream(fileArray[n]));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
            ++n;
        }
        this.rawFiles = fileArray;
        this.out = outputStreamArray;
        this.firstSample = true;
        if (blArray[0]) {
            try {
                this.rawFileSum = new File(file, String.valueOf(file2.getName()) + string + ".raw");
                this.outSum = new BufferedOutputStream(new FileOutputStream(this.rawFileSum));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    private static boolean hasNameCollision(File file, File file2, String string) {
        if (new File(file, String.valueOf(file2.getName()) + string + ".raw").exists() || new File(file, String.valueOf(file2.getName()) + string + ".wav").exists() || new File(file, String.valueOf(file2.getName()) + string + ".aiff").exists()) {
            return true;
        }
        int n = 0;
        while (n < soundOutput.getChannelNames().length) {
            if (new File(file, String.valueOf(file2.getName()) + string + "_ch" + (n + 1) + ".raw").exists() || new File(file, String.valueOf(file2.getName()) + string + "_ch" + (n + 1) + ".wav").exists() || new File(file, String.valueOf(file2.getName()) + string + "_ch" + (n + 1) + ".aiff").exists()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void stopRecording() {
        if (soundOutput != null) {
            soundOutput.removeAmplitudeListener(this);
        }
        int n = 0;
        while (n < this.out.length) {
            OutputStream outputStream = this.out[n];
            if (outputStream != null) {
                try {
                    outputStream.close();
                    if (this.writeWav) {
                        try {
                            soundOutput.writeWav(this.rawFiles[n], new File(this.rawFiles[n].getParentFile(), this.rawFiles[n].getName().replace(".raw", ".wav")));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    if (this.writeAiff) {
                        try {
                            soundOutput.writeAiff(this.rawFiles[n], new File(this.rawFiles[n].getParentFile(), this.rawFiles[n].getName().replace(".raw", ".aiff")));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (!this.keepRaw) {
                    this.rawFiles[n].delete();
                }
            }
            ++n;
        }
        if (this.outSum != null) {
            try {
                this.outSum.close();
                if (this.writeWav) {
                    try {
                        soundOutput.writeWav(this.rawFileSum, new File(this.rawFileSum.getParentFile(), this.rawFileSum.getName().replace(".raw", ".wav")));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (this.writeAiff) {
                    try {
                        soundOutput.writeAiff(this.rawFileSum, new File(this.rawFileSum.getParentFile(), this.rawFileSum.getName().replace(".raw", ".aiff")));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (!this.keepRaw) {
                this.rawFileSum.delete();
            }
            this.outSum = null;
        }
        this.out = NO_OUTPUT;
    }
}

