/*
 * Decompiled with CFR 0.152.
 */
package platform;

import common.FileChooser;
import common.KeySettings;
import common.Properties;
import common.PropertyBasedKeySettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import platform.Emulicious;
import platform.debugger.Debugger;

public class KeySetupDialog
extends JDialog {
    private final Properties properties = new Properties();
    private final Properties currentProperties = new Properties();
    private final Properties defaultProperties = new Properties();
    private final KeySettings keySettings = new PropertyBasedKeySettings(this.properties, "");
    private final JTable table;
    private final KeySettingsTableModel tableModel;
    private final JComboBox<String> schemeSelection = new JComboBox<String>(new String[]{"Current", "Default"});
    private final String[] WHEN = new String[]{"In Debugger", "In Main Window", "In Debugger or Main Window"};
    private final JComboBox<String> whenSelection = new JComboBox<String>(this.WHEN);
    private File[] schemes;

    public KeySetupDialog(JFrame jFrame) {
        super(jFrame, String.valueOf(Emulicious.TITLE) + " - Key Setup", true);
        Serializable serializable;
        Object object;
        Serializable serializable2;
        Object object2;
        Map.Entry<Object, Object> entry22;
        Debugger.loadDefaultKeySettings(this.defaultProperties);
        Emulicious.loadDefaultKeySettings(this.defaultProperties);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> object32 : Debugger.getKeyCategories().entrySet()) {
            hashMap.put("DebuggerKeys" + object32.getKey(), object32.getValue());
        }
        for (Map.Entry<String, String> entry : Emulicious.getKeyCategories().entrySet()) {
            hashMap.put("Keys" + entry.getKey(), entry.getValue());
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.defaultProperties.size());
        for (Map.Entry<Object, Object> entry22 : this.defaultProperties.entrySet()) {
            object2 = entry22.getKey().toString();
            if (!((String)object2).endsWith("When")) {
                arrayList.add((String)object2);
            }
            this.properties.put(object2, Emulicious.getProperties().getProperty((String)object2));
        }
        this.currentProperties.putAll((Map<?, ?>)this.properties);
        this.tableModel = new KeySettingsTableModel(arrayList, hashMap);
        this.table = new JTable(this.tableModel){

            @Override
            public void setFont(Font font) {
                super.setFont(UIManager.getFont("Label.font"));
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                dimension.width = this.getPreferredSize().width;
                return dimension;
            }

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                return keyEvent.getKeyCode() != 27 && super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
        };
        this.table.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (n2 == 0 && object instanceof String) {
                    object = this.idToString((String)object);
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }

            private String idToString(String string) {
                if (string == null || string.isEmpty()) {
                    return "";
                }
                string = KeySetupDialog.this.stripPrefix(string);
                StringBuilder stringBuilder = new StringBuilder(string.length() + 5);
                stringBuilder.append(string.charAt(0));
                int n = 1;
                while (n < string.length()) {
                    if (Character.isUpperCase(string.charAt(n)) && Character.isLowerCase(string.charAt(n - 1))) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(string.charAt(n));
                    ++n;
                }
                return stringBuilder.toString();
            }
        });
        this.table.setDefaultRenderer(KeyStroke.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (n2 == 1 && object instanceof KeyStroke) {
                    object = this.keyStrokeToString((KeyStroke)object);
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }

            private String keyStrokeToString(KeyStroke keyStroke) {
                if (keyStroke == null) {
                    return "";
                }
                return keyStroke.toString().replace("pressed ", "");
            }
        });
        this.table.setFillsViewportHeight(true);
        entry22 = new JTextField(){

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke, final KeyEvent keyEvent, int n, boolean bl) {
                boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
                if (!bl2 && !this.isFocusOwner()) {
                    this.requestFocusInWindow();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.processKeyEvent(keyEvent);
                        }
                    });
                }
                return bl2;
            }
        };
        ((JTextField)((Object)entry22)).setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (this.getLength() == 0) {
                    super.insertString(n, string.replace("pressed ", ""), attributeSet);
                }
            }

            @Override
            public void remove(int n, int n2) throws BadLocationException {
                if (n == 0 && n2 == this.getLength()) {
                    super.remove(n, n2);
                }
            }
        });
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JTextField)((Object)entry22));
        ((Component)((Object)entry22)).addKeyListener(new KeyAdapter((JTextField)((Object)entry22), defaultCellEditor){
            private final /* synthetic */ JTextField val$editorTextField;
            private final /* synthetic */ DefaultCellEditor val$editor;
            {
                this.val$editorTextField = jTextField;
                this.val$editor = defaultCellEditor;
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.val$editorTextField.setText(KeyStroke.getKeyStrokeForEvent(keyEvent).toString());
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.val$editor.stopCellEditing();
            }
        });
        defaultCellEditor.setClickCountToStart(1);
        this.table.setDefaultEditor(KeyStroke.class, defaultCellEditor);
        object2 = this.table.getColumnModel().getColumn(3);
        DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(this.whenSelection);
        defaultCellEditor2.setClickCountToStart(1);
        ((TableColumn)object2).setCellEditor(defaultCellEditor2);
        this.table.putClientProperty("terminateEditOnFocusLost", true);
        this.table.setAutoCreateRowSorter(true);
        this.table.getRowSorter().toggleSortOrder(0);
        this.table.setSelectionMode(0);
        this.table.setShowGrid(false);
        this.table.setRowHeight(((JTextField)((Object)entry22)).getPreferredSize().height);
        int n = 0;
        while (n < this.table.getColumnCount()) {
            serializable2 = this.table.getColumnModel().getColumn(n);
            object = ((TableColumn)serializable2).getHeaderRenderer();
            if (object == null) {
                object = this.table.getTableHeader().getDefaultRenderer();
            }
            int n2 = object.getTableCellRendererComponent((JTable)this.table, (Object)((TableColumn)serializable2).getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
            int n3 = 0;
            while (n3 < this.table.getRowCount()) {
                serializable = this.table.getCellRenderer(n3, n).getTableCellRendererComponent(this.table, this.table.getValueAt(n3, n), false, false, n3, n).getPreferredSize();
                n2 = Math.max(n2, ((Dimension)serializable).width + this.table.getIntercellSpacing().width);
                ++n3;
            }
            ((TableColumn)serializable2).setMinWidth(n2);
            ++n;
        }
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "North");
        jPanel.add(new JLabel("Scheme:"));
        this.updateSchemes();
        this.schemeSelection.setSelectedIndex(0);
        this.schemeSelection.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                int n = KeySetupDialog.this.schemeSelection.getItemCount();
                final int n2 = KeySetupDialog.this.schemeSelection.getSelectedIndex();
                KeySetupDialog.this.updateSchemes();
                if (KeySetupDialog.this.schemeSelection.getItemCount() != n) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KeySetupDialog.this.schemeSelection.showPopup();
                            if (n2 >= 0) {
                                KeySetupDialog.this.schemeSelection.setSelectedIndex(n2);
                            }
                        }
                    });
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.schemeSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = KeySetupDialog.this.schemeSelection.getSelectedIndex();
                if (n >= 0) {
                    if (n == 0) {
                        KeySetupDialog.this.properties.putAll((Map<?, ?>)KeySetupDialog.this.currentProperties);
                    } else if (n == 1) {
                        KeySetupDialog.this.properties.putAll((Map<?, ?>)KeySetupDialog.this.defaultProperties);
                    } else {
                        try {
                            FileInputStream fileInputStream = new FileInputStream(KeySetupDialog.this.schemes[n - 2]);
                            KeySetupDialog.this.properties.load(fileInputStream);
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    KeySetupDialog.this.tableModel.update();
                }
            }
        });
        jPanel.add(this.schemeSelection);
        serializable2 = new JButton("Export Bindings");
        jPanel.add((Component)serializable2);
        ((AbstractButton)serializable2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeySetupDialog.this.showExportFileChooser();
            }
        });
        object = new JPanel(new BorderLayout());
        this.add((Component)object, "Center");
        ((Container)object).add((Component)new JScrollPane(this.table), "Center");
        JPanel jPanel2 = new JPanel();
        ((Container)object).add((Component)jPanel2, "South");
        JButton jButton = new JButton("Restore Binding");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeySetupDialog.this.restoreSelectedBinding();
            }
        });
        jPanel2.add(jButton);
        serializable = new JButton("Unbind");
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeySetupDialog.this.unbindSelectedBinding();
            }
        });
        jPanel2.add((Component)serializable);
        JPanel jPanel3 = new JPanel();
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Emulicious.getProperties().putAll((Map<?, ?>)KeySetupDialog.this.properties);
                KeySetupDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(jButton2);
        jPanel3.add(jButton2);
        JButton jButton3 = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeySetupDialog.this.dispose();
            }
        });
        jPanel3.add(jButton3);
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    final JDialog jDialog = new JDialog((Dialog)KeySetupDialog.this, true);
                    jDialog.setUndecorated(true);
                    jDialog.setSize(0, 0);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jDialog.dispose();
                        }
                    });
                    jDialog.setVisible(true);
                }
            });
        }
        this.add((Component)jPanel3, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setVisible(true);
    }

    void showExportFileChooser() {
        FileChooser fileChooser = new FileChooser(Emulicious.getKeyPresetsDir());
        fileChooser.setDialogTitle("Export Keys...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Debugger Key Bindings (*.ini)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".ini") || file.isDirectory();
            }
        });
        if (fileChooser.showSaveDialog(this) == 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(fileChooser.getSelectedFile());
                this.properties.store(fileOutputStream, String.valueOf(Emulicious.TITLE) + " Key Bindings");
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    void updateSchemes() {
        File file = Emulicious.getKeyPresetsDir();
        if (file.isDirectory()) {
            this.schemes = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(".ini");
                }
            });
            if (this.schemeSelection.getItemCount() - 2 != this.schemes.length) {
                this.schemeSelection.removeAllItems();
                this.schemeSelection.addItem("Current");
                this.schemeSelection.addItem("Default");
                File[] fileArray = this.schemes;
                int n = this.schemes.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray[n2];
                    this.schemeSelection.addItem(file2.getName().substring(0, file2.getName().length() - ".ini".length()));
                    ++n2;
                }
            }
        }
    }

    String stripPrefix(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("DebuggerKeys")) {
            return string.substring("DebuggerKeys".length());
        }
        if (string.startsWith("Keys")) {
            return string.substring("Keys".length());
        }
        return string;
    }

    void unbindSelectedBinding() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            this.table.setValueAt("", n, 1);
        }
    }

    void restoreSelectedBinding() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            String string = (String)this.table.getValueAt(n, 0);
            this.table.setValueAt(this.defaultProperties.getProperty(string), n, 1);
            this.table.setValueAt(this.defaultProperties.getProperty(String.valueOf(string) + "When"), n, 3);
        }
    }

    class KeySettingsTableModel
    extends DefaultTableModel {
        private final List<String> ids;
        private final Map<String, String> categories;
        private final String[] COLUMNS = new String[]{"Command", "Binding", "Category", "When"};

        public KeySettingsTableModel(List<String> list, Map<String, String> map) {
            this.ids = list;
            this.categories = map;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 || n2 == 3;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object == null) {
                return;
            }
            String string = this.ids.get(n);
            if (n2 == 3) {
                int n3 = 0;
                while (n3 < KeySetupDialog.this.WHEN.length) {
                    if (KeySetupDialog.this.WHEN[n3].equals(object.toString())) {
                        KeySetupDialog.this.properties.setProperty(String.valueOf(string) + "When", Integer.toString(n3));
                    }
                    ++n3;
                }
            } else if (n2 == 1) {
                KeySetupDialog.this.keySettings.setKeyStroke(string, KeyStroke.getKeyStroke(object.toString()));
                this.fireTableRowsUpdated(n, n);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = this.ids.get(n);
            if (n2 == 0) {
                return string;
            }
            if (n2 == 2) {
                return this.categories.get(string);
            }
            if (n2 == 3) {
                try {
                    return KeySetupDialog.this.WHEN[Integer.parseInt(KeySetupDialog.this.properties.getProperty(String.valueOf(string) + "When"))];
                }
                catch (Exception exception) {
                    return KeySetupDialog.this.WHEN[0];
                }
            }
            return KeySetupDialog.this.keySettings.getKeyStroke(string);
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMNS[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return KeyStroke.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        @Override
        public int getRowCount() {
            return this.ids != null ? this.ids.size() : 0;
        }

        public void update() {
            this.fireTableDataChanged();
        }
    }
}

