/*
 * Decompiled with CFR 0.152.
 */
package output;

import components.video.V9938;
import java.awt.Dimension;
import java.util.Arrays;
import output.SMSDisplayWindow;
import output.ViewerCache;
import platform.DisplayWindow;
import platform.viewers.ViewerWindow;

public class MSXDisplayWindow
extends SMSDisplayWindow {
    private static final int MAX_WIDTH = 256;
    private static final String[] PALETTE_NAMES = new String[]{"Transparent", "Backdrop Color", "Color 1", "Pink", "Black on Transparent"};
    private static final String[] BASE_ADDRESS_NAMES = new String[]{"Auto", "1F800", "1F000", "1E800", "1E000", "1D800", "1D000", "1C800", "1C000", "1B800", "1B000", "1A800", "1A000", "19800", "19000", "18800", "18000", "17800", "17000", "16800", "16000", "15800", "15000", "14800", "14000", "13800", "13000", "12800", "12000", "11800", "11000", "10800", "10000", "F800", "F000", "E800", "E000", "D800", "D000", "C800", "C000", "B800", "B000", "A800", "A000", "9800", "9000", "8800", "8000", "7800", "7000", "6800", "6000", "5800", "5000", "4800", "4000", "3800", "3000", "2800", "2000", "1800", "1000", "800", "0"};
    private static final String[] BASE_ADDRESS_NAMES_BITMAP = new String[]{"Auto", "0", "8000", "10000", "18000"};
    private static final int[] TMS_COLORS = new int[]{DisplayWindow.toPlatformColor(0, 0, 0), DisplayWindow.toPlatformColor(0, 0, 0), DisplayWindow.toPlatformColor(33, 200, 66), DisplayWindow.toPlatformColor(94, 220, 120), DisplayWindow.toPlatformColor(84, 85, 237), DisplayWindow.toPlatformColor(125, 118, 252), DisplayWindow.toPlatformColor(212, 82, 77), DisplayWindow.toPlatformColor(66, 235, 245), DisplayWindow.toPlatformColor(252, 85, 84), DisplayWindow.toPlatformColor(255, 121, 120), DisplayWindow.toPlatformColor(212, 193, 84), DisplayWindow.toPlatformColor(230, 206, 128), DisplayWindow.toPlatformColor(33, 176, 59), DisplayWindow.toPlatformColor(201, 91, 186), DisplayWindow.toPlatformColor(204, 204, 204), DisplayWindow.toPlatformColor(255, 255, 255)};
    private int[] paletteOverride = new int[TMS_COLORS.length];

    public MSXDisplayWindow(DisplayWindow displayWindow) {
        super(displayWindow, 0, false, false);
        Arrays.fill(this.paletteOverride, -1);
    }

    @Override
    public Dimension getTilemapDimension(boolean bl) {
        if (this.renderer instanceof Mode1wideRenderer) {
            return new Dimension(bl ? 559 : 480, bl ? this.vdp.getScreenHeight() + (this.vdp.getScreenHeight() - 1) / 8 : this.vdp.getScreenHeight());
        }
        return super.getTilemapDimension(bl);
    }

    @Override
    protected int getNumTilesetPages() {
        if (this.renderer instanceof BitmapRenderer && !this.isMode2Renderer()) {
            return 1;
        }
        return super.getNumTilesetPages();
    }

    @Override
    protected boolean isMode2Renderer() {
        if (this.renderer instanceof BitmapRenderer) {
            int n = 0;
            while (n < this.modeBits.length) {
                int n2 = this.modeBits[n];
                int n3 = n2 & 0xFFFFFFF9 | (n2 & 2) << 1 | (n2 & 4) >> 1;
                if (n3 == 8) {
                    return true;
                }
                ++n;
            }
        }
        return super.isMode2Renderer();
    }

    @Override
    protected int getTilemapLines() {
        if (this.modeBits[0] >= 8) {
            return 256;
        }
        return super.getTilemapLines();
    }

    @Override
    public String[] getBaseAddressNames() {
        if (this.vdp == null) {
            return super.getBaseAddressNames();
        }
        int n = this.modeBits[0];
        int n2 = n & 0xFFFFFFF9 | (n & 2) << 1 | (n & 4) >> 1;
        return n2 == 12 || n2 == 16 || n2 == 20 || n2 == 28 ? BASE_ADDRESS_NAMES_BITMAP : (((V9938)this.vdp).isV9938mode() ? BASE_ADDRESS_NAMES : super.getBaseAddressNames());
    }

    @Override
    public boolean isDisplayOn(int n) {
        return super.isDisplayOn(Math.min(1023, n));
    }

    @Override
    public int getHorizontalScroll(int n) {
        return super.getHorizontalScroll(Math.min(1023, n));
    }

    @Override
    public int[] getTilemapData(int n, int[] nArray, ViewerCache viewerCache) {
        if (this.renderer instanceof Mode1wideRenderer) {
            int[] nArray2 = this.vdp.getVRAM();
            int[] nArray3 = nArray != null && nArray.length == 1920 ? nArray : new int[1920];
            int n2 = n < 0 ? this.vdp.getScreenMapBaseAddress(0) : this.getBaseAddressNames().length - 2 - n << 11;
            System.arraycopy(nArray2, n2, nArray3, 0, Math.min(nArray2.length - n2, nArray3.length));
            return nArray3;
        }
        return super.getTilemapData(n, nArray, viewerCache);
    }

    @Override
    public int getVRAMAddressOfTilemapEntry(int n, int n2, ViewerCache viewerCache) {
        int n3 = this.modeBits[0];
        int n4 = n3 & 0xFFFFFFF9 | (n3 & 2) << 1 | (n3 & 4) >> 1;
        if (n4 == 12 || n4 == 16 || n4 == 20 || n4 == 28) {
            int n5;
            int n6 = --n2 < 0 ? this.vdp.getScreenMapBaseAddress(0) : n2 << 15;
            int n7 = n5 = n4 == 16 || n4 == 20 ? 512 : 256;
            int n8 = n4 == 12 || n4 == 20 ? 4 : (n4 == 16 ? 2 : 8);
            int n9 = n5 * n8 / 8;
            int n10 = n / 32;
            int n11 = n2 < 0 ? this.baseAddressValues[n10 * 8] : n6;
            return n11 + n10 * 8 * n9 + n % 32 * n8;
        }
        return super.getVRAMAddressOfTilemapEntry(n, n2, viewerCache);
    }

    @Override
    public void renderTilemap(ViewerWindow viewerWindow, int n, int n2, boolean bl, boolean bl2, ViewerCache viewerCache) {
        super.renderTilemap(viewerWindow, n, n2, bl, bl2, viewerCache);
        int n3 = this.vdp.getScreenHeight();
        int n4 = this.getTilemapLines();
        int n5 = 0;
        while (n5 < n3) {
            int n6 = n5 + this.getVerticalScroll() & 0xFF;
            if (n5 == 0 && n6 > 0 && n6 < n4) {
                viewerWindow.xorColor(MSXDisplayWindow.toTilemapCoord(Math.max(0, -1), bl), MSXDisplayWindow.toTilemapCoord(n6 - 1, bl), MSXDisplayWindow.toTilemapCoord(Math.min(256, 257), bl), DisplayWindow.COLOR_WHITE);
            } else if (n5 == n3 - 1 && n6 < n4 - 1) {
                viewerWindow.xorColor(MSXDisplayWindow.toTilemapCoord(Math.max(0, -1), bl), MSXDisplayWindow.toTilemapCoord(n6 + 1, bl), MSXDisplayWindow.toTilemapCoord(Math.min(256, 257), bl), DisplayWindow.COLOR_WHITE);
            }
            ++n5;
        }
    }

    @Override
    protected void renderTilemapLine(ViewerWindow viewerWindow, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = n2 & 0xFFFFFFF9 | (n2 & 2) << 1 | (n2 & 4) >> 1;
        if (n4 == 12 || n4 == 16 || n4 == 20 || n4 == 28) {
            int n5;
            int n6 = n3 < 0 ? this.vdp.getScreenMapBaseAddress(0) : n3 << 15;
            int n7 = n5 = n4 == 16 || n4 == 20 ? 512 : 256;
            int n8 = n4 == 12 || n4 == 20 ? 4 : (n4 == 16 ? 2 : 8);
            boolean bl3 = n4 != 28 && this.vdp.hasTransparency();
            int n9 = 8 / n8;
            int n10 = (1 << n8) - 1;
            int n11 = n6 + n * n5 * n8 / 8;
            int n12 = 0;
            while (n12 < n5) {
                int n13 = this.vram[n11];
                int n14 = 0;
                while (n14 < n9) {
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    if (n5 > 256) {
                        n18 = n13 & n10;
                        n17 = this.getTmsColor(n18 > 0 || !bl3 ? n18 : this.vdp.getBackDropColor() & n10);
                        n18 = (n13 >>= n8) & n10;
                        n16 = this.getTmsColor(n18 > 0 || !bl3 ? n18 : this.vdp.getBackDropColor() & n10);
                        n15 = (n17 & 0xFF0000) + (n16 & 0xFF0000) >> 1 & 0xFF0000 | (n17 & 0xFF00) + (n16 & 0xFF00) >> 1 & 0xFF00 | (n17 & 0xFF) + (n16 & 0xFF) >> 1;
                        viewerWindow.setColor((n12 + n9 - 1 - n14) / 2 + (bl ? n12 / 16 : 0), n + (bl ? n / 8 : 0), n15);
                        ++n14;
                    } else {
                        n18 = n13 & n10;
                        if (n4 == 28) {
                            n16 = n18 >> 5;
                            n15 = n18 >> 2 & 7;
                            int n19 = n18 & 3;
                            n17 = DisplayWindow.toPlatformColor(n15 * 255 / 7, n16 * 255 / 7, n19 * 255 / 3);
                        } else {
                            n17 = this.getTmsColor(n18 > 0 || !bl3 ? n18 : this.vdp.getBackDropColor() & n10);
                        }
                        viewerWindow.setColor(n12 + n9 - 1 - n14 + (bl ? n12 / 8 : 0), n + (bl ? n / 8 : 0), n17);
                    }
                    n13 >>= n8;
                    ++n14;
                }
                n12 += n9;
                ++n11;
            }
        } else {
            if (n2 == 9) {
                n2 = 1;
            } else if (n2 == 8) {
                n2 = 2;
            }
            super.renderTilemapLine(viewerWindow, n, n2, n3, bl, bl2);
        }
    }

    @Override
    public void setMode(int n) {
        if (n >= 8) {
            n = n & 0xFFFFFFF9 | (n & 2) << 1 | (n & 4) >> 1;
            switch (n) {
                case 8: {
                    this.renderer = new Mode4Renderer();
                    this.displayWindow.setDimensions(284, this.vdp.getScreenHeight() + this.vdp.getLinesTopBorder() + this.vdp.getLinesBottomBorder());
                    this.spriteBuffer = new int[8];
                    break;
                }
                case 9: {
                    this.renderer = new Mode1wideRenderer();
                    this.displayWindow.setDimensions(540, this.vdp.getScreenHeight() + this.vdp.getLinesTopBorder() + this.vdp.getLinesBottomBorder());
                    this.spriteBuffer = new int[0];
                    break;
                }
                case 12: {
                    this.renderer = new Mode5Renderer();
                    this.displayWindow.setDimensions(284, this.vdp.getScreenHeight() + this.vdp.getLinesTopBorder() + this.vdp.getLinesBottomBorder());
                    this.spriteBuffer = new int[8];
                    break;
                }
                case 16: {
                    this.renderer = new Mode6Renderer();
                    this.displayWindow.setDimensions(284, this.vdp.getScreenHeight() + this.vdp.getLinesTopBorder() + this.vdp.getLinesBottomBorder());
                    this.spriteBuffer = new int[8];
                    break;
                }
                case 20: {
                    this.renderer = new Mode7Renderer();
                    this.displayWindow.setDimensions(284, this.vdp.getScreenHeight() + this.vdp.getLinesTopBorder() + this.vdp.getLinesBottomBorder());
                    this.spriteBuffer = new int[8];
                    break;
                }
                case 28: {
                    this.renderer = new Mode8Renderer();
                    this.displayWindow.setDimensions(284, this.vdp.getScreenHeight() + this.vdp.getLinesTopBorder() + this.vdp.getLinesBottomBorder());
                    this.spriteBuffer = new int[8];
                }
            }
            return;
        }
        this.displayWindow.setDimensions(284, this.vdp.getScreenHeight() + this.vdp.getLinesTopBorder() + this.vdp.getLinesBottomBorder());
        super.setMode(n);
    }

    public void displayAdjustUpdated() {
        this.displayWindow.setBorders(13 - this.vdp.getDisplayAdjustHorizontal(), this.vdp.getLinesTopBorder(), 15 - this.vdp.getDisplayAdjustHorizontal(), this.vdp.getLinesBottomBorder());
    }

    @Override
    public String[] getPaletteNames() {
        return PALETTE_NAMES;
    }

    @Override
    public void updateColor(int n) {
        this.updateColor(n, 0, true);
    }

    @Override
    public void updateColor(int n, int n2, boolean bl) {
        if (!((V9938)this.vdp).isV9938mode()) {
            return;
        }
        int n3 = this.vdp.getCRAM()[n];
        int n4 = n3 >> 8 & 7;
        int n5 = n3 >> 4 & 7;
        int n6 = n3 & 7;
        this.paletteOverride[n] = DisplayWindow.toPlatformColor(n5 * 255 / 7, n4 * 255 / 7, n6 * 255 / 7);
    }

    @Override
    protected int getTmsColor(int n) {
        int n2 = this.paletteOverride[n];
        if (n2 < 0) {
            return TMS_COLORS[n];
        }
        return n2;
    }

    @Override
    protected int getTmsSpriteAttributes(int n, int n2) {
        if (this.modeBits[0] >= 8) {
            return this.vram[this.vdp.getSpriteAttributeTableAddress(n) & 0xFFFFFDFF | (n & ((V9938)this.vdp).getSpriteAttributeIndexMask()) << 4 | n2];
        }
        return super.getTmsSpriteAttributes(n, n2);
    }

    @Override
    public int getColor(int n) {
        return this.vdp.getColor(n);
    }

    @Override
    public int getVerticalScroll() {
        if (this.vdp == null) {
            return 0;
        }
        return this.vdp.getDisplayOffset();
    }

    @Override
    public boolean hasSpriteAttributes() {
        return true;
    }

    @Override
    public String getSpriteAttributes(int n) {
        if (this.modeBits[0] >= 8) {
            int n2 = this.getTmsSpriteAttributes(n, 0);
            return String.valueOf(String.format("$%02X", n2)) + " | IC: " + ((n2 & 0x20) != 0) + " | CC: " + ((n2 & 0x40) != 0) + " | EC: " + ((n2 & 0x80) != 0);
        }
        return super.getSpriteAttributes(n);
    }

    @Override
    public int getAddressOfSpriteAttributes(int n) {
        return this.vdp.getSpriteAttributeTableAddress(n) & 0xFFFFFDFF | (n & ((V9938)this.vdp).getSpriteAttributeIndexMask()) << 4;
    }

    @Override
    public boolean hasTilemapAttributes() {
        return false;
    }

    abstract class BitmapRenderer
    extends SMSDisplayWindow.TMSRenderer {
        private final int[] mixedSprites = new int[64];

        BitmapRenderer() {
        }

        @Override
        public void renderLine() {
            if (MSXDisplayWindow.this.vdp.getLine() < this.HEIGHT) {
                Arrays.fill(this.mixedSprites, -1);
                if (MSXDisplayWindow.this.vdp.isDisplayOn()) {
                    int n = MSXDisplayWindow.this.vdp.getLine();
                    int n2 = this.getWidth();
                    int n3 = this.getBitsPerPixel();
                    boolean bl = this.hasTransparency();
                    int n4 = 8 / n3;
                    int n5 = (1 << n3) - 1;
                    int n6 = MSXDisplayWindow.this.vdp.getScreenMapBaseAddress() + (n + MSXDisplayWindow.this.vdp.getDisplayOffset() & 0xFF) * n2 * n3 / 8;
                    int n7 = 0;
                    while (n7 < n2) {
                        int n8 = MSXDisplayWindow.this.vram[n6];
                        int n9 = 0;
                        while (n9 < n4) {
                            int n10;
                            if (n2 > 256) {
                                n10 = n8 & n5;
                                int n11 = this.getColor(n10 > 0 || !bl ? n10 : MSXDisplayWindow.this.vdp.getBackDropColor() & n5);
                                n10 = (n8 >>= n3) & n5;
                                int n12 = this.getColor(n10 > 0 || !bl ? n10 : MSXDisplayWindow.this.vdp.getBackDropColor() & n5);
                                int n13 = (n11 & 0xFF0000) + (n12 & 0xFF0000) >> 1 & 0xFF0000 | (n11 & 0xFF00) + (n12 & 0xFF00) >> 1 & 0xFF00 | (n11 & 0xFF) + (n12 & 0xFF) >> 1;
                                MSXDisplayWindow.this.displayWindow.setColor((n7 + n4 - 1 - n9) / 2, n, n13);
                                ++n9;
                            } else {
                                n10 = n8 & n5;
                                MSXDisplayWindow.this.displayWindow.setColor(n7 + n4 - 1 - n9, n, this.getColor(n10 > 0 || !bl ? n10 : MSXDisplayWindow.this.vdp.getBackDropColor() & n5));
                            }
                            n8 >>= n3;
                            ++n9;
                        }
                        n7 += n4;
                        ++n6;
                    }
                    this.renderVerticalBorders();
                    this.renderSprites();
                } else {
                    this.renderDisabledLine();
                }
            } else if (MSXDisplayWindow.this.vdp.getLine() < this.HEIGHT + MSXDisplayWindow.this.vdp.getLinesBottomBorder()) {
                this.renderBlankLine(MSXDisplayWindow.this.vdp.getLinesTopBorder() + MSXDisplayWindow.this.vdp.getLine());
            } else if (MSXDisplayWindow.this.vdp.getLine() >= MSXDisplayWindow.this.vdp.getScanlines() - MSXDisplayWindow.this.vdp.getLinesTopBorder()) {
                this.renderBlankLine(MSXDisplayWindow.this.vdp.getLine() - MSXDisplayWindow.this.vdp.getScanlines() + MSXDisplayWindow.this.vdp.getLinesTopBorder());
            }
        }

        @Override
        protected void renderBlankLine(int n) {
            int n2 = Math.min(256, this.getWidth()) + 13 + 15;
            int n3 = MSXDisplayWindow.this.vdp.getColorTableAddress();
            int n4 = (1 << this.getBitsPerPixel()) - 1;
            int n5 = 0;
            while (n5 < n2) {
                MSXDisplayWindow.this.displayWindow.setColorDirect(n5, n, this.getColor((MSXDisplayWindow.this.vdp.getTextColor() << 4 | MSXDisplayWindow.this.vdp.getBackDropColor(n5, n3)) & n4));
                ++n5;
            }
        }

        @Override
        protected void renderVerticalBorders() {
            int n = MSXDisplayWindow.this.vdp.getLinesTopBorder() + MSXDisplayWindow.this.vdp.getLine();
            int n2 = 13 - MSXDisplayWindow.this.vdp.getDisplayAdjustHorizontal();
            int n3 = 15 + MSXDisplayWindow.this.vdp.getDisplayAdjustHorizontal();
            int n4 = MSXDisplayWindow.this.vdp.getColorTableAddress();
            int n5 = (1 << this.getBitsPerPixel()) - 1;
            int n6 = Math.min(256, this.getWidth()) + n2;
            int n7 = 0;
            while (n7 < n3) {
                MSXDisplayWindow.this.displayWindow.setColorDirect(n6, n, this.getColor((MSXDisplayWindow.this.vdp.getTextColor() << 4 | MSXDisplayWindow.this.vdp.getBackDropColor(n6, n4)) & n5));
                ++n7;
                ++n6;
            }
            n6 = 0;
            while (n6 < n2) {
                MSXDisplayWindow.this.displayWindow.setColorDirect(n6, n, this.getColor((MSXDisplayWindow.this.vdp.getTextColor() << 4 | MSXDisplayWindow.this.vdp.getBackDropColor(n6, n4)) & n5));
                ++n6;
            }
        }

        protected abstract int getBitsPerPixel();

        protected abstract int getWidth();

        protected boolean hasTransparency() {
            return MSXDisplayWindow.this.vdp.hasTransparency();
        }

        @Override
        protected int getSpriteAttributes(int n, int n2) {
            return MSXDisplayWindow.this.vram[MSXDisplayWindow.this.vdp.getSpriteAttributeTableAddress(n) & 0xFFFFFDFF | (n & ((V9938)MSXDisplayWindow.this.vdp).getSpriteAttributeIndexMask()) << 4 | n2];
        }

        @Override
        protected boolean isIgnoreSpriteCollisions(int n, int n2) {
            return (this.getSpriteAttributes(n, n2) & 0x20) != 0;
        }

        @Override
        protected boolean isSpriteXdoubled() {
            return Math.min(256, this.getWidth()) == 512;
        }

        private boolean isMixSpriteColors(int n, int n2) {
            return (this.getSpriteAttributes(n, n2) & 0x40) != 0;
        }

        @Override
        protected void handleSpriteCollision(int n, int n2, int n3, int n4, int n5, boolean bl) {
            if (this.isMixSpriteColors(n2, n4) && (this.mixedSprites[n2] < 0 || this.mixedSprites[n2] == n)) {
                if (bl) {
                    MSXDisplayWindow.this.lineBuffer[n3] = n5 << 8 | 0x40 | MSXDisplayWindow.this.lineBuffer[n3] & 0xFFFFFFC0 | n;
                }
                this.mixedSprites[n2] = n;
            } else {
                super.handleSpriteCollision(n, n2, n3, n4, n5, bl);
            }
        }

        @Override
        public void prepareSprites() {
            super.prepareSprites();
            int n = 0;
            while (n < MSXDisplayWindow.this.lineBuffer.length) {
                if ((MSXDisplayWindow.this.lineBuffer[n] & 0x80) != 0 && this.mixedSprites[MSXDisplayWindow.this.lineBuffer[n] & 0x3F] < 0) {
                    int n2 = 0;
                    while (n2 < 8) {
                        if (this.isMixSpriteColors(MSXDisplayWindow.this.lineBuffer[n] & 0x3F, n2)) {
                            MSXDisplayWindow.this.lineBuffer[n] = 0;
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    class Mode1wideRenderer
    extends SMSDisplayWindow.Mode1Renderer {
        public Mode1wideRenderer() {
            super(80);
        }

        @Override
        protected void renderBlankLine(int n) {
            MSXDisplayWindow.this.displayWindow.setColorDirect(0, n, 540, this.getColor(MSXDisplayWindow.this.vdp.getBackDropColor()));
        }

        @Override
        protected void renderVerticalBorders() {
            int n = this.getColor(MSXDisplayWindow.this.vdp.getBackDropColor());
            int n2 = 0;
            while (n2 < 16) {
                MSXDisplayWindow.this.displayWindow.setNextColor(n);
                ++n2;
            }
            n2 = MSXDisplayWindow.this.vdp.getLinesTopBorder() + MSXDisplayWindow.this.vdp.getLine();
            int n3 = 13 - MSXDisplayWindow.this.vdp.getDisplayAdjustHorizontal();
            int n4 = 15 + MSXDisplayWindow.this.vdp.getDisplayAdjustHorizontal();
            MSXDisplayWindow.this.displayWindow.setColorDirect(512 + n3, n2, n4, n);
            MSXDisplayWindow.this.displayWindow.setColorDirect(0, n2, n3, n);
        }
    }

    class Mode4Renderer
    extends SMSDisplayWindow.Mode2Renderer {
        private final int[] mixedSprites = new int[64];

        Mode4Renderer() {
        }

        @Override
        public void renderLine() {
            if (MSXDisplayWindow.this.vdp.getLine() < this.HEIGHT) {
                Arrays.fill(this.mixedSprites, -1);
            }
            super.renderLine();
        }

        @Override
        protected int getSpriteAttributes(int n, int n2) {
            return MSXDisplayWindow.this.vram[MSXDisplayWindow.this.vdp.getSpriteAttributeTableAddress(n) & 0xFFFFFDFF | (n & ((V9938)MSXDisplayWindow.this.vdp).getSpriteAttributeIndexMask()) << 4 | n2];
        }

        @Override
        protected boolean isIgnoreSpriteCollisions(int n, int n2) {
            return (this.getSpriteAttributes(n, n2) & 0x20) != 0;
        }

        private boolean isMixSpriteColors(int n, int n2) {
            return (this.getSpriteAttributes(n, n2) & 0x40) != 0;
        }

        @Override
        protected void handleSpriteCollision(int n, int n2, int n3, int n4, int n5, boolean bl) {
            if (this.isMixSpriteColors(n2, n4) && (this.mixedSprites[n2] < 0 || this.mixedSprites[n2] == n)) {
                if (bl) {
                    MSXDisplayWindow.this.lineBuffer[n3] = n5 << 8 | 0x40 | MSXDisplayWindow.this.lineBuffer[n3] & 0xFFFFFFC0 | n;
                }
                this.mixedSprites[n2] = n;
            } else {
                super.handleSpriteCollision(n, n2, n3, n4, n5, bl);
            }
        }

        @Override
        public void prepareSprites() {
            super.prepareSprites();
            int n = 0;
            while (n < MSXDisplayWindow.this.lineBuffer.length) {
                if ((MSXDisplayWindow.this.lineBuffer[n] & 0x80) != 0 && this.mixedSprites[MSXDisplayWindow.this.lineBuffer[n] & 0x3F] < 0) {
                    int n2 = 0;
                    while (n2 < 8) {
                        if (this.isMixSpriteColors(MSXDisplayWindow.this.lineBuffer[n] & 0x3F, n2)) {
                            MSXDisplayWindow.this.lineBuffer[n] = 0;
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    class Mode5Renderer
    extends BitmapRenderer {
        Mode5Renderer() {
        }

        @Override
        protected int getBitsPerPixel() {
            return 4;
        }

        @Override
        protected int getWidth() {
            return 256;
        }
    }

    class Mode6Renderer
    extends BitmapRenderer {
        Mode6Renderer() {
        }

        @Override
        protected int getBitsPerPixel() {
            return 2;
        }

        @Override
        protected int getWidth() {
            return 512;
        }
    }

    class Mode7Renderer
    extends BitmapRenderer {
        Mode7Renderer() {
        }

        @Override
        protected int getBitsPerPixel() {
            return 4;
        }

        @Override
        protected int getWidth() {
            return 512;
        }
    }

    class Mode8Renderer
    extends BitmapRenderer {
        private final int[][] SPRITE_COLORS;

        Mode8Renderer() {
            int[][] nArrayArray = new int[16][];
            nArrayArray[0] = new int[3];
            int[] nArray = new int[3];
            nArray[2] = 2;
            nArrayArray[1] = nArray;
            int[] nArray2 = new int[3];
            nArray2[1] = 3;
            nArrayArray[2] = nArray2;
            int[] nArray3 = new int[3];
            nArray3[1] = 3;
            nArray3[2] = 2;
            nArrayArray[3] = nArray3;
            int[] nArray4 = new int[3];
            nArray4[0] = 3;
            nArrayArray[4] = nArray4;
            int[] nArray5 = new int[3];
            nArray5[0] = 3;
            nArray5[2] = 2;
            nArrayArray[5] = nArray5;
            int[] nArray6 = new int[3];
            nArray6[0] = 3;
            nArray6[1] = 3;
            nArrayArray[6] = nArray6;
            nArrayArray[7] = new int[]{3, 3, 2};
            nArrayArray[8] = new int[]{4, 7, 2};
            int[] nArray7 = new int[3];
            nArray7[2] = 7;
            nArrayArray[9] = nArray7;
            int[] nArray8 = new int[3];
            nArray8[1] = 7;
            nArrayArray[10] = nArray8;
            int[] nArray9 = new int[3];
            nArray9[1] = 7;
            nArray9[2] = 7;
            nArrayArray[11] = nArray9;
            int[] nArray10 = new int[3];
            nArray10[0] = 7;
            nArrayArray[12] = nArray10;
            int[] nArray11 = new int[3];
            nArray11[0] = 7;
            nArray11[2] = 7;
            nArrayArray[13] = nArray11;
            int[] nArray12 = new int[3];
            nArray12[0] = 7;
            nArray12[1] = 7;
            nArrayArray[14] = nArray12;
            nArrayArray[15] = new int[]{7, 7, 7};
            this.SPRITE_COLORS = nArrayArray;
        }

        @Override
        protected int getBitsPerPixel() {
            return 8;
        }

        @Override
        protected int getWidth() {
            return 256;
        }

        @Override
        protected boolean hasTransparency() {
            return false;
        }

        @Override
        protected int getColor(int n) {
            int n2 = n >> 5;
            int n3 = n >> 2 & 7;
            int n4 = n & 3;
            return DisplayWindow.toPlatformColor(n3 * 255 / 7, n2 * 255 / 7, n4 * 255 / 3);
        }

        @Override
        protected int getSpriteColor(int n) {
            int[] nArray = this.SPRITE_COLORS[n];
            return DisplayWindow.toPlatformColor(nArray[1] * 255 / 7, nArray[0] * 255 / 7, nArray[2] * 255 / 7);
        }
    }
}

