/*
 * Decompiled with CFR 0.152.
 */
package evscript;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EvscriptDebugInfo {
    private final List<ScriptHandler> scriptHandlers;
    private final List<DebugLine> debugLines;

    private EvscriptDebugInfo(File file) throws IOException {
        ArrayList<ScriptHandler> arrayList = new ArrayList<ScriptHandler>();
        ArrayList<DebugLine> arrayList2 = new ArrayList<DebugLine>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String string = bufferedReader.readLine();
        while (string != null) {
            try {
                if (string.indexOf(58) >= 0) {
                    arrayList2.add(DebugLine.from(string));
                } else if (string.indexOf(32) >= 0) {
                    arrayList.add(ScriptHandler.from(string));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        this.scriptHandlers = Collections.unmodifiableList(arrayList);
        this.debugLines = Collections.unmodifiableList(arrayList2);
    }

    public List<ScriptHandler> getScriptHandlers() {
        return this.scriptHandlers;
    }

    public List<DebugLine> getDebugLines() {
        return this.debugLines;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ScriptHandler object : this.scriptHandlers) {
            stringBuilder.append(object).append('\n');
        }
        for (DebugLine debugLine : this.debugLines) {
            stringBuilder.append(debugLine).append('\n');
        }
        return stringBuilder.toString();
    }

    public static EvscriptDebugInfo parse(File file) throws IOException {
        return new EvscriptDebugInfo(file);
    }

    public static class DebugLine {
        private final String label;
        private final String filename;
        private final int lineNumber;
        private final List<Variable> variables;

        private DebugLine(String string, String string2, int n, List<Variable> list) {
            this.label = string;
            this.filename = string2;
            this.lineNumber = n;
            this.variables = Collections.unmodifiableList(list);
        }

        public String getLabel() {
            return this.label;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public List<Variable> getVariables() {
            return this.variables;
        }

        public String toString() {
            return String.valueOf(this.label) + ":" + this.filename + ":" + this.lineNumber + ":" + this.variables;
        }

        static DebugLine from(String string) {
            String[] stringArray = string.split(":");
            if (stringArray.length < 3 || stringArray.length > 4) {
                throw new IllegalArgumentException("Invalid debug line: " + string);
            }
            try {
                int n = Integer.parseInt(stringArray[2]);
                String[] stringArray2 = stringArray[stringArray.length - 1].split(",");
                ArrayList<Variable> arrayList = new ArrayList<Variable>();
                int n2 = 0;
                while (n2 + 3 < stringArray2.length) {
                    arrayList.add(new Variable(stringArray2[n2], Integer.parseInt(stringArray2[n2 + 1].trim()), Integer.parseInt(stringArray2[n2 + 2].trim()), stringArray2[n2 + 3].trim().charAt(0) == 'S'));
                    n2 += 4;
                }
                return new DebugLine(stringArray[0], stringArray[1], n, arrayList);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Failed to parse debug line: " + string, numberFormatException);
            }
        }
    }

    public static class ScriptHandler {
        private final String start;
        private final String next;
        private final String end;

        private ScriptHandler(String string, String string2, String string3) {
            this.start = string;
            this.next = string2;
            this.end = string3;
        }

        public String getStart() {
            return this.start;
        }

        public String getNext() {
            return this.next;
        }

        public String getEnd() {
            return this.end;
        }

        public String toString() {
            return String.valueOf(this.start) + " " + this.next + " " + this.end;
        }

        static ScriptHandler from(String string) {
            String[] stringArray = string.split(" ");
            if (stringArray.length != 3) {
                throw new IllegalArgumentException("Invalid debug line: " + string);
            }
            return new ScriptHandler(stringArray[0], stringArray[1], stringArray[2]);
        }
    }

    public static class Variable {
        private final String name;
        private final int offset;
        private final int size;
        private final boolean signed;

        public Variable(String string, int n, int n2, boolean bl) {
            this.name = string;
            this.offset = n;
            this.size = n2;
            this.signed = bl;
        }

        public String getName() {
            return this.name;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isSigned() {
            return this.signed;
        }

        public String toString() {
            return String.valueOf(this.name) + ", " + this.offset + ", " + this.size + ", " + (this.signed ? "S" : "U");
        }
    }
}

