/*
 * Decompiled with CFR 0.152.
 */
package components.input;

import components.input.AbstractSMSInputDevice;
import components.input.ButtonInputProvider;
import components.input.PointerInputProvider;
import components.video.SMS2VDP;

public class SMSLightPhaser
extends AbstractSMSInputDevice {
    private static final int[][] BUTTON_IDENTIFIERS = new int[][]{{12}, {18}};
    private final int[] buttonIdentifiers;
    private final int port;
    private SMS2VDP vdp;
    private final ButtonInputProvider buttonInputProvider;
    private final PointerInputProvider pointerInputProvider;

    public SMSLightPhaser(int n, ButtonInputProvider buttonInputProvider, PointerInputProvider pointerInputProvider) {
        super(BUTTON_IDENTIFIERS[n & 1].length);
        if (buttonInputProvider == null) {
            throw new IllegalArgumentException("buttonInputProvider must not be null");
        }
        if (pointerInputProvider == null) {
            throw new IllegalArgumentException("pointerInputProvider must not be null");
        }
        this.port = n;
        this.buttonInputProvider = buttonInputProvider;
        this.pointerInputProvider = pointerInputProvider;
        this.buttonIdentifiers = BUTTON_IDENTIFIERS[n & 1];
    }

    public PointerInputProvider getPointerInputProvider() {
        return this.pointerInputProvider;
    }

    public void setVDP(SMS2VDP sMS2VDP) {
        this.vdp = sMS2VDP;
    }

    @Override
    public void frameFinished() {
        this.pointerInputProvider.frameFinished();
    }

    @Override
    public int readData(int n) {
        int n2 = 255;
        if (this.port == 0 && this.vdp.isTH0low(n) || this.vdp.isTH1low(n)) {
            n2 &= 0xFFFFFFBF;
        }
        if (this.isButtonDown(0)) {
            n2 &= 0xFFFFFFEF;
        }
        return n2;
    }

    @Override
    protected boolean isButtonPressed(int n) {
        return this.buttonInputProvider.isButtonDown(this.buttonIdentifiers[0]);
    }
}

