/*
 * Decompiled with CFR 0.152.
 */
package assembler.rgbds;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class RGBDSCharmap {
    private final Node root = new Node();

    public RGBDSCharmap() {
    }

    public RGBDSCharmap(RGBDSCharmap rGBDSCharmap) {
        if (rGBDSCharmap != null) {
            this.copy(this.root, rGBDSCharmap.root);
        }
    }

    private Node copy(Node node, Node node2) {
        if (node2 == null) {
            return null;
        }
        node.value = node2.value;
        if (node2.next != null) {
            node.next = new Node[255];
            int n = 0;
            while (n < node2.next.length) {
                node.next[n] = this.copy(new Node(), node2.next[n]);
                ++n;
            }
        }
        return node;
    }

    public Character put(String string, char c) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            Node node = this.root;
            int n = 0;
            while (n < byArray.length) {
                Node node2 = node.getNext(byArray[n]);
                if (node2 != null) {
                    node = node2;
                } else {
                    Node node3 = new Node();
                    node.setNext(byArray[n], node3);
                    node = node3;
                }
                ++n;
            }
            Character c2 = node.value;
            node.value = Character.valueOf(c);
            return c2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public String map(String string) {
        if (this.root.next == null) {
            return string;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            Node node = this.root;
            Node node2 = null;
            byte[] byArray = string.getBytes("UTF-8");
            int n2 = 0;
            while (n2 - n < byArray.length) {
                Node node3;
                Node node4 = node3 = n2 < byArray.length ? node.getNext(byArray[n2]) : null;
                if (node3 != null) {
                    node = node3;
                    if (node.value != null) {
                        node2 = node;
                        n = 0;
                    } else {
                        ++n;
                    }
                } else {
                    n2 -= n;
                    if (node2 != null) {
                        stringBuilder.append(node2.value);
                        --n2;
                    } else if (n2 < byArray.length) {
                        if (byArray[n2] < 128) {
                            stringBuilder.append((char)byArray[n2]);
                        } else {
                            char c = new String(byArray, n2, byArray.length - n2, "UTF-8").charAt(0);
                            stringBuilder.append(c);
                            n2 += Character.toString(c).getBytes("UTF-8").length - 1;
                        }
                    }
                    n = 0;
                    node = this.root;
                    node2 = null;
                }
                ++n2;
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private List<String> collectEntries(Node node, String string, List<String> list) {
        if (node != null) {
            if (node.value != null) {
                list.add(String.valueOf(string) + " = " + node.value.charValue());
            }
            if (node.next != null) {
                int n = 0;
                while (n < node.next.length) {
                    this.collectEntries(node.next[n], String.valueOf(string) + (char)(n + 1), list);
                    ++n;
                }
            }
        }
        return list;
    }

    public String toString() {
        return this.collectEntries(this.root, "", new ArrayList<String>()).toString();
    }

    static class Node {
        Character value;
        Node[] next;

        Node() {
        }

        Node getNext(byte by) {
            if (this.next == null) {
                return null;
            }
            return this.next[by - 1 & 0xFF];
        }

        void setNext(byte by, Node node) {
            if (this.next == null) {
                this.next = new Node[255];
            }
            this.next[by - 1 & 0xFF] = node;
        }
    }
}

