/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.spi.TimeZoneNameProvider;
import sun.util.calendar.ZoneInfo;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleServiceProviderPool;
import sun.util.locale.provider.TimeZoneNameProviderImpl;

public final class TimeZoneNameUtility {
    private static ConcurrentHashMap<Locale, SoftReference<String[][]>> cachedZoneData = new ConcurrentHashMap();
    private static final Map<String, SoftReference<Map<Locale, String[]>>> cachedDisplayNames = new ConcurrentHashMap<String, SoftReference<Map<Locale, String[]>>>();

    public static String[][] getZoneStrings(Locale locale) {
        String[][] stringArray;
        SoftReference<String[][]> softReference = cachedZoneData.get(locale);
        if (softReference == null || (stringArray = softReference.get()) == null) {
            stringArray = TimeZoneNameUtility.loadZoneStrings(locale);
            softReference = new SoftReference<String[][]>(stringArray);
            cachedZoneData.put(locale, softReference);
        }
        return stringArray;
    }

    private static String[][] loadZoneStrings(Locale locale) {
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(TimeZoneNameProvider.class, locale);
        TimeZoneNameProvider timeZoneNameProvider = localeProviderAdapter.getTimeZoneNameProvider();
        if (timeZoneNameProvider instanceof TimeZoneNameProviderImpl) {
            return ((TimeZoneNameProviderImpl)timeZoneNameProvider).getZoneStrings(locale);
        }
        Set<String> set = LocaleProviderAdapter.forJRE().getLocaleResources(locale).getZoneIDs();
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        for (String string : set) {
            String[] stringArray = TimeZoneNameUtility.retrieveDisplayNamesImpl(string, locale);
            if (stringArray == null) continue;
            linkedList.add(stringArray);
        }
        String[][] stringArrayArray = new String[linkedList.size()][];
        return (String[][])linkedList.toArray((T[])stringArrayArray);
    }

    public static String[] retrieveDisplayNames(String string, Locale locale) {
        if (string == null || locale == null) {
            throw new NullPointerException();
        }
        return TimeZoneNameUtility.retrieveDisplayNamesImpl(string, locale);
    }

    public static String retrieveGenericDisplayName(String string, int n, Locale locale) {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(TimeZoneNameProvider.class);
        return localeServiceProviderPool.getLocalizedObject(TimeZoneNameGetter.INSTANCE, locale, "generic", n, string);
    }

    public static String retrieveDisplayName(String string, boolean bl, int n, Locale locale) {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(TimeZoneNameProvider.class);
        return localeServiceProviderPool.getLocalizedObject(TimeZoneNameGetter.INSTANCE, locale, bl ? "dst" : "std", n, string);
    }

    private static String[] retrieveDisplayNamesImpl(String string, Locale locale) {
        String[] stringArray;
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(TimeZoneNameProvider.class);
        SoftReference<Map<Locale, String[]>> softReference = cachedDisplayNames.get(string);
        if (softReference != null && (stringArray = softReference.get()) != null) {
            String[] stringArray2 = stringArray.get(locale);
            if (stringArray2 != null) {
                return stringArray2;
            }
            stringArray2 = localeServiceProviderPool.getLocalizedObject(TimeZoneNameArrayGetter.INSTANCE, locale, string, new Object[0]);
            if (stringArray2 != null) {
                stringArray.put(locale, stringArray2);
            }
            return stringArray2;
        }
        stringArray = localeServiceProviderPool.getLocalizedObject(TimeZoneNameArrayGetter.INSTANCE, locale, string, new Object[0]);
        if (stringArray != null) {
            ConcurrentHashMap<Locale, String[]> concurrentHashMap = new ConcurrentHashMap<Locale, String[]>();
            concurrentHashMap.put(locale, stringArray);
            softReference = new SoftReference(concurrentHashMap);
            cachedDisplayNames.put(string, softReference);
        }
        return stringArray;
    }

    private TimeZoneNameUtility() {
    }

    private static class TimeZoneNameArrayGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<TimeZoneNameProvider, String[]> {
        private static final TimeZoneNameArrayGetter INSTANCE = new TimeZoneNameArrayGetter();

        private TimeZoneNameArrayGetter() {
        }

        @Override
        public String[] getObject(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string, Object ... objectArray) {
            Map<String, String> map;
            assert (objectArray.length == 0);
            String[] stringArray = TimeZoneNameArrayGetter.buildZoneStrings(timeZoneNameProvider, locale, string);
            if (stringArray == null && (map = ZoneInfo.getAliasTable()) != null) {
                String string2 = map.get(string);
                if (string2 != null) {
                    stringArray = TimeZoneNameArrayGetter.buildZoneStrings(timeZoneNameProvider, locale, string2);
                }
                if (stringArray == null) {
                    stringArray = TimeZoneNameArrayGetter.examineAliases(timeZoneNameProvider, locale, string2 == null ? string : string2, map);
                }
            }
            if (stringArray != null) {
                stringArray[0] = string;
            }
            return stringArray;
        }

        private static String[] examineAliases(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string, Map<String, String> map) {
            if (map.containsValue(string)) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!entry.getValue().equals(string)) continue;
                    String string2 = entry.getKey();
                    String[] stringArray = TimeZoneNameArrayGetter.buildZoneStrings(timeZoneNameProvider, locale, string2);
                    if (stringArray != null) {
                        return stringArray;
                    }
                    stringArray = TimeZoneNameArrayGetter.examineAliases(timeZoneNameProvider, locale, string2, map);
                    if (stringArray == null) continue;
                    return stringArray;
                }
            }
            return null;
        }

        private static String[] buildZoneStrings(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string) {
            String[] stringArray = new String[5];
            block5: for (int i = 1; i <= 4; ++i) {
                stringArray[i] = timeZoneNameProvider.getDisplayName(string, i >= 3, i % 2, locale);
                if (stringArray[i] != null) continue;
                switch (i) {
                    case 1: {
                        return null;
                    }
                    case 2: 
                    case 4: {
                        stringArray[i] = stringArray[i - 1];
                        continue block5;
                    }
                    case 3: {
                        stringArray[3] = stringArray[1];
                    }
                }
            }
            return stringArray;
        }
    }

    private static class TimeZoneNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<TimeZoneNameProvider, String> {
        private static final TimeZoneNameGetter INSTANCE = new TimeZoneNameGetter();

        private TimeZoneNameGetter() {
        }

        @Override
        public String getObject(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string, Object ... objectArray) {
            Map<String, String> map;
            String string2;
            assert (objectArray.length == 2);
            int n = (Integer)objectArray[0];
            String string3 = TimeZoneNameGetter.getName(timeZoneNameProvider, locale, string, n, string2 = (String)objectArray[1]);
            if (string3 == null && (map = ZoneInfo.getAliasTable()) != null) {
                String string4 = map.get(string2);
                if (string4 != null) {
                    string3 = TimeZoneNameGetter.getName(timeZoneNameProvider, locale, string, n, string4);
                }
                if (string3 == null) {
                    string3 = TimeZoneNameGetter.examineAliases(timeZoneNameProvider, locale, string, string4 != null ? string4 : string2, n, map);
                }
            }
            return string3;
        }

        private static String examineAliases(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string, String string2, int n, Map<String, String> map) {
            if (map.containsValue(string2)) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!entry.getValue().equals(string2)) continue;
                    String string3 = entry.getKey();
                    String string4 = TimeZoneNameGetter.getName(timeZoneNameProvider, locale, string, n, string3);
                    if (string4 != null) {
                        return string4;
                    }
                    string4 = TimeZoneNameGetter.examineAliases(timeZoneNameProvider, locale, string, string3, n, map);
                    if (string4 == null) continue;
                    return string4;
                }
            }
            return null;
        }

        private static String getName(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String string, int n, String string2) {
            String string3 = null;
            switch (string) {
                case "std": {
                    string3 = timeZoneNameProvider.getDisplayName(string2, false, n, locale);
                    break;
                }
                case "dst": {
                    string3 = timeZoneNameProvider.getDisplayName(string2, true, n, locale);
                    break;
                }
                case "generic": {
                    string3 = timeZoneNameProvider.getGenericDisplayName(string2, n, locale);
                }
            }
            return string3;
        }
    }
}

