/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.WSDLOperationMapping;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.util.QNameMap;
import com.sun.xml.internal.ws.wsdl.DispatchException;
import com.sun.xml.internal.ws.wsdl.WSDLOperationFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

final class PayloadQNameBasedOperationFinder
extends WSDLOperationFinder {
    private static final Logger LOGGER = Logger.getLogger(PayloadQNameBasedOperationFinder.class.getName());
    public static final String EMPTY_PAYLOAD_LOCAL = "";
    public static final String EMPTY_PAYLOAD_NSURI = "";
    public static final QName EMPTY_PAYLOAD = new QName("", "");
    private final QNameMap<WSDLOperationMapping> methodHandlers = new QNameMap();
    private final QNameMap<List<String>> unique = new QNameMap();

    public PayloadQNameBasedOperationFinder(WSDLPort wSDLPort, WSBinding wSBinding, @Nullable SEIModel sEIModel) {
        super(wSDLPort, wSBinding, sEIModel);
        if (sEIModel != null) {
            QName qName;
            for (JavaMethodImpl object : ((AbstractSEIModelImpl)sEIModel).getJavaMethods()) {
                List<String> list;
                if (object.getMEP().isAsync) continue;
                qName = object.getRequestPayloadName();
                if (qName == null) {
                    qName = EMPTY_PAYLOAD;
                }
                if ((list = this.unique.get(qName)) == null) {
                    list = new ArrayList<String>();
                    this.unique.put(qName, list);
                }
                list.add(object.getMethod().getName());
            }
            for (QNameMap.Entry entry : this.unique.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                LOGGER.warning(ServerMessages.NON_UNIQUE_DISPATCH_QNAME(entry.getValue(), entry.createQName()));
            }
            for (JavaMethodImpl javaMethodImpl : ((AbstractSEIModelImpl)sEIModel).getJavaMethods()) {
                qName = javaMethodImpl.getRequestPayloadName();
                if (qName == null) {
                    qName = EMPTY_PAYLOAD;
                }
                if (this.unique.get(qName).size() != 1) continue;
                this.methodHandlers.put(qName, this.wsdlOperationMapping(javaMethodImpl));
            }
        } else {
            for (WSDLBoundOperation wSDLBoundOperation : wSDLPort.getBinding().getBindingOperations()) {
                QName qName = wSDLBoundOperation.getRequestPayloadName();
                if (qName == null) {
                    qName = EMPTY_PAYLOAD;
                }
                this.methodHandlers.put(qName, this.wsdlOperationMapping(wSDLBoundOperation));
            }
        }
    }

    @Override
    public WSDLOperationMapping getWSDLOperationMapping(Packet packet) throws DispatchException {
        String string;
        Message message = packet.getMessage();
        String string2 = message.getPayloadLocalPart();
        if (string2 == null) {
            string2 = "";
            string = "";
        } else {
            string = message.getPayloadNamespaceURI();
            if (string == null) {
                string = "";
            }
        }
        WSDLOperationMapping wSDLOperationMapping = this.methodHandlers.get(string, string2);
        if (wSDLOperationMapping == null && !this.unique.containsKey(string, string2)) {
            String string3 = "{" + string + "}" + string2;
            String string4 = ServerMessages.DISPATCH_CANNOT_FIND_METHOD(string3);
            throw new DispatchException(SOAPFaultBuilder.createSOAPFaultMessage(this.binding.getSOAPVersion(), string4, this.binding.getSOAPVersion().faultCodeClient));
        }
        return wSDLOperationMapping;
    }
}

