/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public final class JAXWSUtils {
    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getFileOrURLName(String string) {
        try {
            try {
                return JAXWSUtils.escapeSpace(new URL(string).toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                return new File(string).getCanonicalFile().toURL().toExternalForm();
            }
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static URL getFileOrURL(String string) throws IOException {
        try {
            URL uRL = new URL(string);
            String string2 = String.valueOf(uRL.getProtocol()).toLowerCase();
            if (string2.equals("http") || string2.equals("https")) {
                return new URL(uRL.toURI().toASCIIString());
            }
            return uRL;
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(string).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return new File(string).toURL();
        }
    }

    public static URL getEncodedURL(String string) throws MalformedURLException {
        URL uRL = new URL(string);
        String string2 = String.valueOf(uRL.getProtocol()).toLowerCase();
        if (string2.equals("http") || string2.equals("https")) {
            try {
                return new URL(uRL.toURI().toASCIIString());
            }
            catch (URISyntaxException uRISyntaxException) {
                MalformedURLException malformedURLException = new MalformedURLException(uRISyntaxException.getMessage());
                malformedURLException.initCause(uRISyntaxException);
                throw malformedURLException;
            }
        }
        return uRL;
    }

    private static String escapeSpace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') {
                stringBuilder.append("%20");
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static String absolutize(String string) {
        try {
            URL uRL = new File(".").getCanonicalFile().toURL();
            return new URL(uRL, string).toExternalForm();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public static void checkAbsoluteness(String string) {
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("system ID '" + string + "' isn't absolute", uRISyntaxException);
            }
        }
    }

    public static boolean matchQNames(QName qName, QName qName2) {
        if (qName == null || qName2 == null) {
            return false;
        }
        if (qName2.getNamespaceURI().equals(qName.getNamespaceURI())) {
            String string = qName2.getLocalPart().replaceAll("\\*", ".*");
            return Pattern.matches(string, qName.getLocalPart());
        }
        return false;
    }
}

