/*
 * Decompiled with CFR 0.152.
 */
package platform.viewers;

import common.CheckBoxMenuItem;
import common.ScreenUtilities;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import platform.Emulicious;
import platform.viewers.PaletteViewer;
import platform.viewers.SpriteViewer;
import platform.viewers.TileViewer;
import platform.viewers.TilemapViewer;

public class VideoViewer {
    final Window owner;
    final Window window;
    private static VideoViewer viewer;
    private final Container tilemapViewer;
    private final Container tileViewer;
    private final Container spriteViewer;
    private final Container paletteViewer;

    private VideoViewer(Window window, boolean bl, String string, boolean bl2) {
        this.window = bl2 ? new JFrame() : new JDialog();
        this.owner = window;
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Video Viewer");
        this.window.setIconImages(window.getIconImages());
        this.tilemapViewer = TilemapViewer.stealContentPane(window);
        this.tileViewer = TileViewer.stealContentPane(window);
        this.spriteViewer = SpriteViewer.stealContentPane(window);
        this.paletteViewer = PaletteViewer.stealContentPane(window);
        this.setContentPane(bl ? VideoViewer.createTabbedLayout(this.tileViewer, this.spriteViewer, this.tilemapViewer, this.paletteViewer, string) : VideoViewer.createGridLayout(this.tileViewer, this.spriteViewer, this.tilemapViewer, this.paletteViewer));
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                VideoViewer.stopRefreshTimers();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = this.makeMenuView();
        jMenuBar.add(jMenu);
        if (viewer == null || !viewer.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.pack();
                this.window.setSize(Math.max(980, this.getWidth()), Math.max(940, this.getHeight()));
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private void setContentPane(Container container) {
        if (this.window instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)this.window)).setContentPane(container);
        }
    }

    private Container getContentPane() {
        return this.window instanceof RootPaneContainer ? ((RootPaneContainer)((Object)this.window)).getContentPane() : null;
    }

    private void setJMenuBar(JMenuBar jMenuBar) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setJMenuBar(jMenuBar);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setJMenuBar(jMenuBar);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    private JMenu makeMenuView() {
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic('v');
        final CheckBoxMenuItem checkBoxMenuItem = new CheckBoxMenuItem("Always Scale to Integer Multiples", VideoViewer.isIntegerScaling());
        checkBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoViewer.setIntegerScaling(checkBoxMenuItem.isSelected());
            }
        });
        jMenu.add(checkBoxMenuItem);
        final CheckBoxMenuItem checkBoxMenuItem2 = new CheckBoxMenuItem("Show Grid", VideoViewer.isShowGrid());
        checkBoxMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoViewer.setShowGrid(checkBoxMenuItem2.isSelected());
            }
        });
        jMenu.add(checkBoxMenuItem2);
        jMenu.addSeparator();
        jMenu.add(TileViewer.makeLayoutMenu());
        jMenu.addSeparator();
        final CheckBoxMenuItem checkBoxMenuItem3 = new CheckBoxMenuItem("Arrange in Tabs");
        jMenu.add(checkBoxMenuItem3);
        checkBoxMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoViewer.setTabbedLayout(checkBoxMenuItem3.isSelected());
            }
        });
        JMenuItem jMenuItem = new JMenuItem("Split Video Viewers");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoViewer.split(VideoViewer.this.owner);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                checkBoxMenuItem3.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("VideoViewerTabbedLayout")));
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private String getSelectedTab() {
        return ((JTabbedPane)this.getContentPane()).getTitleAt(((JTabbedPane)this.getContentPane()).getSelectedIndex());
    }

    private void setSelectedTab(String string) {
        if (this.getContentPane() instanceof JTabbedPane) {
            VideoViewer.setSelectedTab((JTabbedPane)this.getContentPane(), string);
        }
    }

    private static void setSelectedTab(JTabbedPane jTabbedPane, String string) {
        if (string != null) {
            int n = 0;
            while (n < jTabbedPane.getTabCount()) {
                if (string.equals(jTabbedPane.getTitleAt(n))) {
                    jTabbedPane.setSelectedIndex(n);
                    break;
                }
                ++n;
            }
        }
    }

    private static Container createGridLayout(Container container, Container container2, Container container3, Container container4) {
        JSplitPane jSplitPane = new JSplitPane(0, true, container, container2);
        jSplitPane.setResizeWeight(0.5);
        JSplitPane jSplitPane2 = new JSplitPane(0, true, container3, container4);
        jSplitPane2.setResizeWeight(0.8);
        JSplitPane jSplitPane3 = new JSplitPane(1, true, jSplitPane, jSplitPane2);
        jSplitPane3.setResizeWeight(0.4);
        return jSplitPane3;
    }

    private static Container createTabbedLayout(Container container, Container container2, Container container3, Container container4, String string) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Tilemap", container3);
        jTabbedPane.addTab("Tiles", container);
        jTabbedPane.addTab("Sprites", container2);
        jTabbedPane.addTab("Palettes", container4);
        VideoViewer.setSelectedTab(jTabbedPane, string);
        return jTabbedPane;
    }

    private static boolean isIntegerScaling() {
        return TileViewer.isIntegerScaling() && TilemapViewer.isIntegerScaling() && SpriteViewer.isIntegerScaling();
    }

    static void setIntegerScaling(boolean bl) {
        TileViewer.setIntegerScaling(bl);
        TilemapViewer.setIntegerScaling(bl);
        SpriteViewer.setIntegerScaling(bl);
    }

    private static boolean isShowGrid() {
        return TileViewer.isShowGrid() && TilemapViewer.isShowGrid() && SpriteViewer.isShowGrid();
    }

    static void setShowGrid(boolean bl) {
        TileViewer.setShowGrid(bl);
        TilemapViewer.setShowGrid(bl);
        SpriteViewer.setShowGrid(bl);
    }

    static void stopRefreshTimers() {
        TileViewer.stopRefreshTimer();
        TilemapViewer.stopRefreshTimer();
        SpriteViewer.stopRefreshTimer();
        PaletteViewer.stopRefreshTimer();
    }

    private static void restartRefreshTimers() {
        TileViewer.restartRefreshTimer();
        TilemapViewer.restartRefreshTimer();
        SpriteViewer.restartRefreshTimer();
        PaletteViewer.restartRefreshTimer();
    }

    public static void setTabbedLayout(boolean bl) {
        Emulicious.getProperties().setProperty("VideoViewerTabbedLayout", Boolean.toString(bl));
        if (viewer != null) {
            if (viewer.getContentPane() instanceof JTabbedPane) {
                Emulicious.getProperties().setProperty("VideoViewerSelectedTab", viewer.getSelectedTab());
            }
            viewer.setContentPane(bl ? VideoViewer.createTabbedLayout(VideoViewer.viewer.tileViewer, VideoViewer.viewer.spriteViewer, VideoViewer.viewer.tilemapViewer, VideoViewer.viewer.paletteViewer, Emulicious.getProperties().getProperty("VideoViewerSelectedTab")) : VideoViewer.createGridLayout(VideoViewer.viewer.tileViewer, VideoViewer.viewer.spriteViewer, VideoViewer.viewer.tilemapViewer, VideoViewer.viewer.paletteViewer));
            VideoViewer.viewer.window.revalidate();
            VideoViewer.viewer.window.repaint();
        }
    }

    public static void open(Window window, String string, boolean bl) {
        if (string == null) {
            string = Emulicious.getProperties().getProperty("VideoViewerSelectedTab");
        }
        if (viewer == null) {
            viewer = new VideoViewer(window, Boolean.parseBoolean(Emulicious.getProperties().getProperty("VideoViewerTabbedLayout")), string, Emulicious.isUseFrames());
            viewer.setVisible(true);
        } else if (!bl) {
            viewer.setSelectedTab(string);
            viewer.setVisible(true);
        }
        if (viewer.isShowing()) {
            VideoViewer.restartRefreshTimers();
        }
        Emulicious.getProperties().setProperty("CombineVideoViewers", "true");
    }

    public static void split(Window window) {
        boolean bl = viewer != null && viewer.isVisible();
        TileViewer.close();
        TilemapViewer.close();
        SpriteViewer.close();
        PaletteViewer.close();
        if (viewer != null) {
            viewer.setVisible(false);
        }
        VideoViewer.close();
        Emulicious.getProperties().remove("CombineVideoViewers");
        if (bl) {
            TileViewer.open(window, true);
            TilemapViewer.open(window, true);
            SpriteViewer.open(window, true);
            PaletteViewer.open(window, true);
        }
    }

    public static boolean isCombined() {
        return viewer != null && viewer.isVisible() || Boolean.parseBoolean(Emulicious.getProperties().getProperty("CombineVideoViewers"));
    }

    public static void close() {
        if (viewer != null) {
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Open", "" + viewer.isVisible());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "X", "" + viewer.getX());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Y", "" + viewer.getY());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Width", "" + viewer.getWidth());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Height", "" + viewer.getHeight());
            if (viewer.getContentPane() instanceof JTabbedPane) {
                Emulicious.getProperties().setProperty("VideoViewerSelectedTab", viewer.getSelectedTab());
            }
            viewer.dispose();
            viewer = null;
        }
    }
}

