/*
 * Decompiled with CFR 0.152.
 */
package platform.viewers;

import common.CheckBoxMenuItem;
import common.ClickableJLabel;
import common.ScreenUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import output.SpriteRenderer;
import platform.DisplayWindow;
import platform.Emulicious;
import platform.MemoryTracer;
import platform.MemoryTracerWindow;
import platform.viewers.TileViewer;
import platform.viewers.VideoViewer;
import platform.viewers.ViewerWindow;

public class SpriteViewer {
    static SpriteRenderer spriteRenderer;
    static final Cursor HAND_CURSOR;
    static final Cursor DEFAULT_CURSOR;
    final Window owner;
    final Window window;
    private final ViewerWindow viewerWindow = new ViewerWindow();
    final JCheckBox autoRefresh = new JCheckBox("Auto Refresh");
    private final ButtonGroup transparency = new ButtonGroup();
    private final JRadioButton transparencyNoColor = new JRadioButton("No Color", true);
    private final JRadioButton transparencyColor16 = new JRadioButton("Color 0");
    private final JRadioButton transparencyColorPink = new JRadioButton("Pink");
    private final ClickableJLabel index = new ClickableJLabel("0 ($0)"){

        @Override
        protected boolean canClick(int n) {
            return true;
        }

        @Override
        protected void indexClicked(int n) {
            Emulicious.openMemoryEditor(spriteRenderer.getNameOfSpriteLocation(), spriteRenderer.getAddressOfSpriteVpos(SpriteViewer.this.getIndex()));
        }
    };
    private final JLabel vPosHpos = new JLabel();
    private final JLabel tile = new JLabel();
    private final JLabel attributes = new JLabel();
    private final MemoryTracerWindow.SourceLabel sourceVpos = MemoryTracerWindow.createSourceLabel();
    private final MemoryTracerWindow.SourceLabel sourceHpos = MemoryTracerWindow.createSourceLabel();
    private final MemoryTracerWindow.SourceLabel sourceTile = MemoryTracerWindow.createSourceLabel();
    private final MemoryTracerWindow.SourceLabel sourceAttributes = MemoryTracerWindow.createSourceLabel();
    private final JPanel infoPanel;
    private final JButton refreshButton = SpriteViewer.createRefreshButton();
    int selectedIndex;
    int[][] spriteData;
    private long[] sources;
    private static SpriteViewer viewer;
    private final Timer refreshTimer = new Timer(50, new ActionListener(){
        private int exceptionCounter;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SpriteViewer.refresh();
                this.exceptionCounter = 0;
            }
            catch (RuntimeException runtimeException) {
                if (++this.exceptionCounter >= 2) {
                    SpriteViewer.this.autoRefresh.setSelected(false);
                    throw runtimeException;
                }
                runtimeException.printStackTrace();
            }
        }
    });

    static {
        HAND_CURSOR = Cursor.getPredefinedCursor(12);
        DEFAULT_CURSOR = Cursor.getDefaultCursor();
    }

    private SpriteViewer(Window window, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        this.owner = window;
        final ViewerWindow viewerWindow = this.viewerWindow;
        final Timer timer = this.refreshTimer;
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Sprite Viewer");
        this.window.setIconImages(window.getIconImages());
        this.infoPanel = new JPanel(new BorderLayout());
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.window.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)viewerWindow, "Center");
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.updateInfoPanel();
        this.window.add((Component)jPanel, "Center");
        this.window.add((Component)this.infoPanel, "South");
        viewerWindow.setBackground(this.window.getBackground());
        viewerWindow.setIntegerScaling(Boolean.parseBoolean(Emulicious.getProperties().getProperty("SpriteViewerIntegerScaling")));
        viewerWindow.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Dimension dimension = spriteRenderer.getSpritesDimension(SpriteViewer.isShowGrid());
                int n = viewerWindow.toScreenX(mouseEvent.getX());
                int n2 = viewerWindow.toScreenY(mouseEvent.getY());
                int n3 = dimension.width;
                int n4 = dimension.height;
                if (SpriteViewer.this.spriteData != null && n >= 0 && n < n3 && n2 >= 0 && n2 < n4) {
                    int n5;
                    int n6 = SpriteViewer.isShowGrid() ? 9 : 8;
                    int n7 = n5 = SpriteViewer.isShowGrid() ? 17 : 16;
                    if (spriteRenderer.isWideSprites()) {
                        n6 = SpriteViewer.isShowGrid() ? 17 : 16;
                    }
                    int n8 = (dimension.width - 1) / n6 + 1;
                    int n9 = n2 / n5 * n8 + n / n6;
                    int n10 = spriteRenderer.getSpriteWidth(n9);
                    int n11 = spriteRenderer.getSpriteHeight(n9);
                    if (n9 < SpriteViewer.this.spriteData.length) {
                        viewerWindow.setHighlightCursor(n - n % n6, n2 - n2 % n5, n10, n11);
                        spriteRenderer.setSpriteToHighlight(n9);
                        SpriteViewer.this.updateLabels(n9);
                        viewerWindow.setCursor(HAND_CURSOR);
                        TileViewer.setHighlightedTile(spriteRenderer.getSpriteTile(n9, SpriteViewer.this.spriteData));
                    }
                } else {
                    spriteRenderer.setSpriteToHighlight(-1);
                    viewerWindow.setCursor(DEFAULT_CURSOR);
                    viewerWindow.hideHighlightCursor();
                    SpriteViewer.this.updateLabels(SpriteViewer.this.selectedIndex);
                    TileViewer.setHighlightedTile(-1);
                }
            }
        });
        viewerWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Dimension dimension = spriteRenderer.getSpritesDimension(SpriteViewer.isShowGrid());
                int n = viewerWindow.toScreenX(mouseEvent.getX());
                int n2 = viewerWindow.toScreenY(mouseEvent.getY());
                int n3 = dimension.width;
                int n4 = dimension.height;
                if (SpriteViewer.this.spriteData != null && n >= 0 && n < n3 && n2 >= 0 && n2 < n4) {
                    int n5;
                    int n6 = SpriteViewer.isShowGrid() ? 9 : 8;
                    int n7 = n5 = SpriteViewer.isShowGrid() ? 17 : 16;
                    if (spriteRenderer.isWideSprites()) {
                        n6 = SpriteViewer.isShowGrid() ? 17 : 16;
                    }
                    int n8 = (dimension.width - 1) / n6 + 1;
                    int n9 = n2 / n5 * n8 + n / n6;
                    int n10 = spriteRenderer.getSpriteWidth(n9);
                    int n11 = spriteRenderer.getSpriteHeight(n9);
                    if (n9 < SpriteViewer.this.spriteData.length) {
                        viewerWindow.setSelectionCursor(n - n % n6, n2 - n2 % n5, n10, n11);
                        SpriteViewer.this.updateLabels(n9);
                        SpriteViewer.this.selectedIndex = n9;
                        viewerWindow.setCursor(HAND_CURSOR);
                        TileViewer.setSelectedTile(spriteRenderer.getSpriteTile(n9, SpriteViewer.this.spriteData));
                    }
                } else {
                    viewerWindow.setCursor(DEFAULT_CURSOR);
                    viewerWindow.hideHighlightCursor();
                    SpriteViewer.this.updateLabels(SpriteViewer.this.selectedIndex);
                    TileViewer.setSelectedTile(-1);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                spriteRenderer.setSpriteToHighlight(-1);
                viewerWindow.setCursor(DEFAULT_CURSOR);
                viewerWindow.hideHighlightCursor();
                SpriteViewer.this.updateLabels(SpriteViewer.this.selectedIndex);
                TileViewer.setHighlightedTile(-1);
            }
        });
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                timer.stop();
                if (spriteRenderer != null) {
                    spriteRenderer.setSpriteToHighlight(-1);
                }
            }
        });
        this.autoRefresh.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                if (jCheckBox.isSelected()) {
                    timer.restart();
                } else {
                    timer.stop();
                }
            }
        });
        this.autoRefresh.setSelected(Boolean.parseBoolean(Emulicious.getProperties().getProperty("AutoRefresh" + this.getClass().getSimpleName())));
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = this.makeMenuView();
        jMenuBar.add(jMenu);
        if (spriteRenderer != null) {
            viewerWindow.setDimensions(spriteRenderer.getSpritesDimension(SpriteViewer.isShowGrid()));
        }
        viewerWindow.setScale(1.0f);
        this.window.pack();
        this.window.setMinimumSize(this.window.getSize());
        if (viewer == null || !viewer.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                viewerWindow.setScale(3.0f);
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private Container getContentPane() {
        return this.window instanceof RootPaneContainer ? ((RootPaneContainer)((Object)this.window)).getContentPane() : null;
    }

    private void setJMenuBar(JMenuBar jMenuBar) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setJMenuBar(jMenuBar);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setJMenuBar(jMenuBar);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    private JMenu makeMenuView() {
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic('v');
        final CheckBoxMenuItem checkBoxMenuItem = new CheckBoxMenuItem("Always Scale to Integer Multiples", this.viewerWindow.isIntegerScaling());
        checkBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpriteViewer.setIntegerScaling(checkBoxMenuItem.isSelected());
            }
        });
        jMenu.add(checkBoxMenuItem);
        final CheckBoxMenuItem checkBoxMenuItem2 = new CheckBoxMenuItem("Show Grid", SpriteViewer.isShowGrid());
        checkBoxMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Emulicious.getProperties().setProperty("SpriteViewerShowGrid", Boolean.toString(checkBoxMenuItem2.isSelected()));
            }
        });
        jMenu.add(checkBoxMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Combine Video Viewers");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoViewer.open(SpriteViewer.this.owner, "Sprites", false);
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private void updateInfoPanel() {
        this.infoPanel.removeAll();
        boolean bl = spriteRenderer.hasSpriteAttributes();
        JPanel jPanel = new JPanel(new GridLayout(bl ? 10 : 8, 1));
        this.infoPanel.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel(new GridLayout(bl ? 10 : 8, 1));
        this.infoPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 3));
        jPanel3.add(this.transparencyNoColor);
        jPanel3.add(this.transparencyColor16);
        jPanel3.add(this.transparencyColorPink);
        this.transparency.add(this.transparencyNoColor);
        this.transparency.add(this.transparencyColor16);
        this.transparency.add(this.transparencyColorPink);
        jPanel.add(new JLabel("Transparency: "));
        jPanel2.add(jPanel3);
        jPanel.add(new JLabel("Index: "));
        jPanel2.add(this.index);
        jPanel.add(new JLabel("Y / X: "));
        jPanel2.add(this.vPosHpos);
        jPanel.add(new JLabel("Tile Index: "));
        jPanel2.add(this.tile);
        if (bl) {
            jPanel.add(new JLabel("Attributes: "));
            jPanel2.add(this.attributes);
        }
        jPanel.add(new JLabel("Source Y: "));
        jPanel2.add(this.sourceVpos);
        jPanel.add(new JLabel("Source X: "));
        jPanel2.add(this.sourceHpos);
        jPanel.add(new JLabel("Source Tile Index: "));
        jPanel2.add(this.sourceTile);
        if (bl) {
            jPanel.add(new JLabel("Source Attributes: "));
            jPanel2.add(this.sourceAttributes);
        }
        jPanel.add(this.autoRefresh);
        jPanel2.add(this.refreshButton);
    }

    void updateLabels(int n) {
        if (this.spriteData != null && n < this.spriteData.length) {
            boolean bl = spriteRenderer.hasSpriteAttributes();
            int n2 = spriteRenderer.getAddressOfSpriteVpos(n);
            String string = spriteRenderer.getCPUAddressOfSprite(n);
            if (string != null) {
                this.index.setText(String.format("%d ($%X) @ %s %s", n, n, spriteRenderer.getNameOfSpriteLocation(), string));
            } else {
                this.index.setText(String.format("%d ($%X) @ %s %04X", n, n, spriteRenderer.getNameOfSpriteLocation(), n2));
            }
            this.vPosHpos.setText(String.format("$%02X / $%02X | %d / %d", this.spriteData[n][0] & 0xFF, this.spriteData[n][1] & 0xFF, this.spriteData[n][0], this.spriteData[n][1]));
            int n3 = spriteRenderer.getSpriteTile(n, this.spriteData);
            this.tile.setText(String.format("%d ($%03X)", n3, n3));
            if (bl) {
                this.attributes.setText(spriteRenderer.getSpriteAttributes(n));
            }
            if (this.sources != null) {
                this.sourceVpos.setSource(this.sources[spriteRenderer.getAddressOfSpriteVpos(n)]);
                this.sourceHpos.setSource(this.sources[spriteRenderer.getAddressOfSpriteHpos(n)]);
                this.sourceTile.setSource(this.sources[spriteRenderer.getAddressOfSpriteTile(n)]);
                if (bl) {
                    this.sourceAttributes.setSource(this.sources[spriteRenderer.getAddressOfSpriteAttributes(n)]);
                }
            } else {
                this.sourceVpos.setSource(0L);
                this.sourceHpos.setSource(0L);
                this.sourceTile.setSource(0L);
                this.sourceAttributes.setSource(0L);
            }
        }
    }

    int getIndex() {
        return Integer.parseInt(this.index.getText().substring(0, this.index.getText().indexOf(32)));
    }

    private static JButton createRefreshButton() {
        JButton jButton = new JButton("Refresh");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpriteViewer.refresh();
            }
        });
        return jButton;
    }

    static void setShowGrid(boolean bl) {
        Emulicious.getProperties().setProperty("SpriteViewerShowGrid", Boolean.toString(bl));
    }

    static boolean isShowGrid() {
        return Boolean.parseBoolean(Emulicious.getProperties().getProperty("SpriteViewerShowGrid"));
    }

    static void setIntegerScaling(boolean bl) {
        if (viewer != null) {
            SpriteViewer.viewer.viewerWindow.setIntegerScaling(bl);
            Emulicious.getProperties().setProperty("SpriteViewerIntegerScaling", Boolean.toString(bl));
        }
    }

    static boolean isIntegerScaling() {
        return Boolean.parseBoolean(Emulicious.getProperties().getProperty("SpriteViewerIntegerScaling"));
    }

    public static boolean isOpen() {
        return viewer != null && viewer.isVisible();
    }

    public static void open(Window window, boolean bl) {
        if (VideoViewer.isCombined()) {
            VideoViewer.open(window, "Sprites", bl);
        } else {
            if (viewer == null) {
                viewer = new SpriteViewer(window, Emulicious.isUseFrames());
                viewer.setVisible(true);
            } else if (!bl) {
                viewer.setVisible(true);
            }
            if (viewer.isShowing() && SpriteViewer.viewer.autoRefresh.isSelected()) {
                SpriteViewer.viewer.refreshTimer.restart();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpriteViewer.refresh();
                }
            });
        }
    }

    static Container stealContentPane(Window window) {
        if (viewer == null) {
            viewer = new SpriteViewer(window, false);
        }
        if (SpriteViewer.viewer.autoRefresh.isSelected()) {
            SpriteViewer.viewer.refreshTimer.restart();
        }
        Container container = viewer.getContentPane();
        viewer.dispose();
        return container;
    }

    static void stopRefreshTimer() {
        if (viewer != null) {
            SpriteViewer.viewer.refreshTimer.stop();
        }
    }

    static void restartRefreshTimer() {
        if (viewer != null && SpriteViewer.viewer.autoRefresh.isSelected()) {
            SpriteViewer.viewer.refreshTimer.restart();
        }
    }

    public static void setSpriteRenderer(SpriteRenderer spriteRenderer) {
        SpriteViewer.spriteRenderer = spriteRenderer;
        if (spriteRenderer != null && viewer != null) {
            viewer.updateInfoPanel();
        }
    }

    public static void close() {
        if (viewer != null) {
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Open", "" + viewer.isVisible());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "X", "" + viewer.getX());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Y", "" + viewer.getY());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Width", "" + viewer.getWidth());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Height", "" + viewer.getHeight());
            if (SpriteViewer.viewer.autoRefresh.isSelected()) {
                Emulicious.getProperties().remove("AutoRefresh" + viewer.getClass().getSimpleName());
            } else {
                Emulicious.getProperties().setProperty("AutoRefresh" + viewer.getClass().getSimpleName(), "false");
            }
            SpriteViewer.viewer.refreshTimer.stop();
            SpriteViewer.viewer.autoRefresh.setSelected(false);
            viewer.dispose();
            viewer = null;
        }
    }

    static void refresh() {
        if (viewer != null && SpriteViewer.viewer.viewerWindow.isShowing()) {
            SpriteViewer.viewer.spriteData = spriteRenderer.getSpriteData(SpriteViewer.viewer.spriteData);
            SpriteViewer.viewer.sources = MemoryTracer.getSpriteSources(SpriteViewer.viewer.sources);
            SpriteViewer.viewer.viewerWindow.setDimensions(spriteRenderer.getSpritesDimension(SpriteViewer.isShowGrid()));
            SpriteViewer.viewer.viewerWindow.fill(DisplayWindow.COLOR_GRAY);
            if (SpriteViewer.viewer.transparencyNoColor.isSelected()) {
                spriteRenderer.renderSprites(SpriteViewer.viewer.viewerWindow, SpriteViewer.viewer.window.getBackground().getRGB(), SpriteViewer.isShowGrid());
            } else if (SpriteViewer.viewer.transparencyColorPink.isSelected()) {
                spriteRenderer.renderSprites(SpriteViewer.viewer.viewerWindow, Color.PINK.getRGB(), SpriteViewer.isShowGrid());
            } else if (SpriteViewer.viewer.transparencyColor16.isSelected()) {
                spriteRenderer.renderSprites(SpriteViewer.viewer.viewerWindow, SpriteViewer.isShowGrid());
            }
            SpriteViewer.viewer.viewerWindow.repaint();
            viewer.updateLabels(viewer.getIndex());
        }
    }
}

