/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import debugfiles.Action;
import debugfiles.ActionGroup;
import debugfiles.Address;
import debugfiles.AddressRange;
import debugfiles.BankLValue;
import debugfiles.DebugFile;
import debugfiles.MemoryAccess;
import debugfiles.VariableLValue;
import debugfiles.commands.AlertCommand;
import debugfiles.commands.Command;
import debugfiles.commands.DisableCommand;
import debugfiles.commands.EnableCommand;
import debugfiles.commands.IfCommand;
import debugfiles.commands.JumpCommand;
import debugfiles.commands.MessageCommand;
import debugfiles.commands.SetCommand;
import debugfiles.commands.SkipCommand;
import debugfiles.commands.ToggleCommand;
import disassembler.Symbols;
import expressions.Expression;
import expressions.ParseException;
import expressions.UnknownVariableException;
import expressions.VariableProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import platform.debugger.Breakpoint;
import platform.debugger.ExpressionEvaluator;
import platform.debugger.SystemDebugger;
import platform.debugger.Watchpoint;
import variables.AbstractVariable;
import variables.Variable;

public class DebugFileInterpreter {
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private final SystemDebugger systemDebugger;
    private final DebugFile debugFile;
    private Set<Action> disabledActions = new HashSet<Action>();
    private Set<Action> performedActions = new HashSet<Action>();
    private List<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
    private Map<String, Value> variableValues = new HashMap<String, Value>();
    private final Variables variables = new Variables(this){

        @Override
        public long getValue(String string, boolean bl) throws UnknownVariableException {
            if ("op".equals(string) || "@op".equals(string)) {
                long l = super.getValue(string, bl);
                if (l == 0L) {
                    int n;
                    int n2 = systemDebugger.getPrevPC();
                    int n3 = systemDebugger.peekByte(n2);
                    if (n3 == 203 ? ((n = systemDebugger.peekByte(n2 + 1)) & 7) == 6 && (n & 0xC0) != 64 : n3 == 52 || n3 == 53) {
                        return 3L;
                    }
                }
                return l;
            }
            return super.getValue(string, bl);
        }
    };
    private final Variables variablesRW = new Variables(this){

        @Override
        public long getValue(String string, boolean bl) throws UnknownVariableException {
            long l;
            if ("op".equals(string) || "@op".equals(string)) {
                long l2 = super.getValue(string, bl);
                if (l2 == 0L) {
                    int n;
                    int n2 = systemDebugger.getPrevPC();
                    int n3 = systemDebugger.peekByte(n2);
                    if (n3 == 203 ? ((n = systemDebugger.peekByte(n2 + 1)) & 7) == 6 && (n & 0xC0) != 64 : n3 == 52 || n3 == 53) {
                        return 3L;
                    }
                }
                return l2;
            }
            if (("value".equals(string) || "@value".equals(string)) && (l = super.getValue("op", bl)) == 0L) {
                int n = systemDebugger.getPrevPC();
                int n4 = systemDebugger.peekByte(n);
                if (n4 == 203) {
                    int n5 = systemDebugger.peekByte(n + 1);
                    if ((n5 & 7) == 6) {
                        int n6 = (n5 & 0x38) >> 3;
                        if ((n5 & 0xC0) == 0) {
                            long l3 = super.getValue(string, bl);
                            if (n6 == 0) {
                                return (l3 & 0x7FL) << 1 | (l3 & 0x80L) >> 7;
                            }
                            if (n6 == 1) {
                                return (l3 & 1L) << 7 | (l3 & 0xFEL) >> 1;
                            }
                            if (n6 == 2) {
                                return (l3 & 0x7FL) << 1 | super.getValue("cf", bl);
                            }
                            if (n6 == 3) {
                                return super.getValue("cf", bl) << 7 | (l3 & 0xFFL) >> 1;
                            }
                            if (n6 == 4) {
                                return (l3 & 0x7FL) << 1;
                            }
                            if (n6 == 5) {
                                return l3 & 0x80L | (l3 & 0xFEL) >> 1;
                            }
                            if (n6 == 6) {
                                return (l3 & 0xFL) << 4 | (l3 & 0xF0L) >> 4;
                            }
                            if (n6 == 7) {
                                return (l3 & 0xFEL) >> 1;
                            }
                        } else {
                            if ((n5 & 0xC0) == 128) {
                                return super.getValue(string, bl) & (long)(~(1 << n6));
                            }
                            if ((n5 & 0xC0) == 192) {
                                return super.getValue(string, bl) | (long)(1 << n6);
                            }
                        }
                    }
                } else {
                    if (n4 == 52) {
                        return super.getValue(string, bl) + 1L & 0xFFL;
                    }
                    if (n4 == 53) {
                        return super.getValue(string, bl) - 1L & 0xFFL;
                    }
                }
            }
            return super.getValue(string, bl);
        }
    };
    private final Variables variablesM = new Variables();
    private final Variables variablesXX = new Variables(this){

        @Override
        public long getValue(String string, boolean bl) throws UnknownVariableException {
            if ("target".equals(string) || "@target".equals(string)) {
                return systemDebugger.getVariables().getValue("destination", bl);
            }
            return super.getValue(string, bl);
        }
    };

    String evaluateString(String string, int n, boolean bl, Map<String, Symbols.Symbol> map) {
        this.debugFile.setLocals(map);
        StringBuilder stringBuilder = null;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c = string.charAt(n4);
            if (c == '{') {
                int n5 = n4;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(string.substring(n3, n4));
                while (n4 < n2 && string.charAt(n4) != '}') {
                    ++n4;
                }
                if (n4 >= n2) {
                    throw new IllegalArgumentException("Missing } in string: " + string);
                }
                stringBuilder.append(this.evaluateEscapeSequence(string.substring(n5, ++n4), n, bl, map));
                n3 = n4;
            }
            ++n4;
        }
        if (stringBuilder != null) {
            stringBuilder.append(string.substring(n3));
            return stringBuilder.toString();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String evaluateEscapeSequence(String string, int n, boolean bl, Map<String, Symbols.Symbol> map) {
        String[] stringArray;
        if (string.charAt(0) != '{') throw new IllegalArgumentException("Not an escapeSequence: " + string);
        if (string.charAt(string.length() - 1) != '}') {
            throw new IllegalArgumentException("Not an escapeSequence: " + string);
        }
        String string2 = string.substring(1, string.length() - 1);
        if (string2.charAt(0) != '[') {
            stringArray = string2.split("\\s*\\:\\s*");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string2;
        }
        String[] stringArray3 = stringArray;
        try {
            String string3;
            int n2;
            if (stringArray3.length > 1) {
                if (stringArray3.length != 2) {
                    int n3 = (int)Math.min((long)(stringArray3.length - 1 - 1), new Expression(stringArray3[0], DebugFile.getTokenizer(), n, true, true).getValue(this.variables, null, bl) & 0xFFFFFFFFL);
                    String string4 = this.debugFile.getString(stringArray3[1 + n3].trim());
                    if (string4 != null) return this.evaluateString(string4, n, bl, map);
                    throw new IllegalArgumentException("Debugfile selection escape sequence is referencing unknown string '" + stringArray3[1 + n3].trim() + "' in " + string2);
                }
                if (!stringArray3[0].isEmpty()) {
                    String string5 = this.debugFile.getString(stringArray3[1].trim());
                    if (string5 != null) return this.evaluateString(string5, n, bl, map);
                    throw new IllegalArgumentException("Debugfile escape sequence is referencing unknown string '" + stringArray3[1].trim() + "' in " + string2);
                }
                String string6 = stringArray3[1].trim();
                if (string6.length() != 1) throw new IllegalArgumentException("Illegal character replacement escape sequence encountered: " + string);
                switch (string6.charAt(0)) {
                    case 'c': {
                        return "}";
                    }
                    case 'n': {
                        return "\n";
                    }
                    case 'o': {
                        return "{";
                    }
                    case 'q': {
                        return "\"";
                    }
                    case 't': {
                        return "\t";
                    }
                }
                throw new IllegalArgumentException("Illegal character replacement escape sequence encountered: " + string);
            }
            int n4 = string2.indexOf(44);
            long l = new Expression(n4 >= 0 ? string2.substring(0, n4) : string2, DebugFile.getTokenizer(), n, true, true).getValue(this.variables, null, bl);
            String string7 = n4 >= 0 ? string2.substring(n4 + 1).trim() : (n == 2 ? "%" : (n == 16 ? "$" : "#"));
            String string8 = string7.substring(0, string7.length() - 1);
            int n5 = !string8.isEmpty() ? Integer.parseInt(string8) : (n2 = Character.isDigit(string7.charAt(string7.length() - 1)) ? Integer.parseInt(string7) : 0);
            int n6 = !Character.isDigit(string7.charAt(string7.length() - 1)) ? (int)string7.charAt(string7.length() - 1) : (n == 2 ? 37 : (n == 16 ? 36 : 35));
            switch (n6) {
                case 35: {
                    string3 = String.format("%" + (n2 > 0 ? "0" + n2 : "") + "d", l & 0xFFFFFFFFL);
                    break;
                }
                case 36: {
                    string3 = String.format("%" + (n2 > 0 ? "0" + n2 : "") + "X", l & 0xFFFFFFFFL);
                    break;
                }
                case 37: {
                    string3 = String.format("%" + (n2 > 0 ? Integer.valueOf(n2) : "") + "s", Long.toBinaryString(l & 0xFFFFFFFFL)).replace(' ', '0');
                    break;
                }
                case 45: {
                    string3 = String.format("%" + (n2 > 0 ? "0" + n2 : "") + "d", l);
                    break;
                }
                case 43: {
                    string3 = String.valueOf(l >= 0L ? "+" : "") + String.format("%" + (n2 > 0 ? "0" + n2 : "") + "d", l);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal formatting character encountered: " + string);
                }
            }
            if (n2 <= 0) return string3;
            if (string3.length() <= n2) return string3;
            return string3.substring(string3.length() - n2);
        }
        catch (UnknownVariableException unknownVariableException) {
            this.systemDebugger.fireMessageReceived("ERROR in debugfile string expression: " + unknownVariableException.getMessage() + "\n");
            return string;
        }
        catch (ParseException parseException) {
            this.systemDebugger.fireMessageReceived("ERROR in debugfile string expression: " + parseException.getMessage() + "\n");
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.systemDebugger.fireMessageReceived("ERROR in debugfile string expression: " + illegalArgumentException.getMessage() + "\n");
        }
        return string;
    }

    public DebugFileInterpreter(SystemDebugger systemDebugger, DebugFile debugFile) {
        this.debugFile = debugFile;
        this.systemDebugger = systemDebugger;
        if (systemDebugger != null) {
            systemDebugger.addSystemListener(new SystemDebugger.SystemListener(){

                @Override
                public void instructionExecuted() {
                    DebugFileInterpreter.this.performedActions.clear();
                }

                @Override
                public void stackWriteOccurred(int n, int n2) {
                }

                @Override
                public void stackReadOccurred(int n) {
                }

                @Override
                public void reset() {
                }

                @Override
                public void memoryChanged(int n) {
                }

                @Override
                public void callExecuted(int n, int n2) {
                }

                @Override
                public void interruptTaken(int n, int n2) {
                }

                @Override
                public void interruptExited(int n) {
                }

                @Override
                public void frameFinished() {
                }

                @Override
                public void executingInstruction() {
                }

                @Override
                public void changeOccurred() {
                }
            });
            this.addWatchpoints(debugFile.getUngroupedActions());
            for (ActionGroup actionGroup : debugFile.getGroups().values()) {
                this.addWatchpoints(actionGroup.getActions());
            }
        }
        this.reset();
    }

    private void addWatchpoints(List<Action> list) {
        for (Action action : list) {
            AddressRange[] addressRangeArray = action.getCondition().getAddressRanges();
            int n = addressRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AddressRange addressRange = addressRangeArray[n2];
                try {
                    String string = action.getCondition().getFlags();
                    if (!string.contains("b") || string.contains("bb")) {
                        if (string.contains("xx")) {
                            this.breakpoints.add(this.systemDebugger.addMemoryLocationBreakpoint("cpu", new DebugFileWatchpoint(addressRange, "xx", action)));
                            string = string.replace("xx", "");
                        }
                        if (!string.isEmpty()) {
                            this.breakpoints.add(this.systemDebugger.addMemoryLocationBreakpoint("cpu", new DebugFileWatchpoint(addressRange, string, action)));
                        }
                    }
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                catch (UnknownVariableException unknownVariableException) {
                    unknownVariableException.printStackTrace();
                }
                ++n2;
            }
        }
    }

    public Variable[] getVariables() {
        Map<String, debugfiles.Variable> map = this.debugFile.getVariables();
        Variable[] variableArray = new Variable[map.size()];
        int n = 0;
        for (debugfiles.Variable variable : map.values()) {
            final String string = variable.getName();
            variableArray[n++] = new AbstractVariable(string){

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setValue(String string2) {
                    try {
                        ((Value)DebugFileInterpreter.this.variableValues.get(string)).value = new Expression(string2, DebugFile.getTokenizer()).getValue(DebugFileInterpreter.this.variables, null);
                    }
                    catch (UnknownVariableException unknownVariableException) {
                        unknownVariableException.printStackTrace();
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                }

                @Override
                public String getValue() {
                    return Integer.toString((int)((Value)DebugFileInterpreter.this.variableValues.get(string)).value);
                }
            };
        }
        return variableArray;
    }

    /*
     * WARNING - void declaration
     */
    public void reset() {
        this.performedActions.clear();
        this.disabledActions.clear();
        for (Action object : this.debugFile.getUngroupedActions()) {
            if (!object.getCondition().getFlags().contains("d")) continue;
            this.disabledActions.add(object);
        }
        for (ActionGroup actionGroup : this.debugFile.getGroups().values()) {
            for (Action action : actionGroup.getActions()) {
                if (!action.getCondition().getFlags().contains("d")) continue;
                this.disabledActions.add(action);
            }
        }
        for (debugfiles.Variable variable : this.debugFile.getVariables().values()) {
            void var3_11;
            Value value = this.variableValues.get(variable.getName());
            if (value == null) {
                Value value2 = new Value();
                this.variableValues.put(variable.getName(), value2);
            }
            ((Value)var3_11).value = variable.getInitialValue();
        }
    }

    public void dispose() {
        for (Breakpoint breakpoint : this.breakpoints) {
            try {
                this.systemDebugger.removeBreakpoint(breakpoint, false);
            }
            catch (Exception exception) {}
        }
    }

    class DebugFileWatchpoint
    extends Watchpoint {
        private final Action action;
        private final Breakpoint.Action breakpointAction;
        private final int address;
        private final String addressString;
        private final int end;
        private final String endString;
        private final Expression condition;
        private final String conditionString;
        private final VariableProvider variables;
        private final String flags;

        public DebugFileWatchpoint(AddressRange addressRange, String string, final Action action) throws ParseException, UnknownVariableException {
            int n;
            String string2;
            super(null, null, null);
            this.flags = string;
            this.action = action;
            boolean bl = "xx".equals(string);
            this.variables = bl ? DebugFileInterpreter.this.variablesXX : (string.contains("m") ? DebugFileInterpreter.this.variablesM : (string.contains("r") && string.contains("w") ? DebugFileInterpreter.this.variablesRW : DebugFileInterpreter.this.variables));
            String string3 = addressRange.getFrom().toString();
            Address address = addressRange.getFrom();
            Address address2 = addressRange.getTo();
            String string4 = string2 = address2 != null ? address2.toString() : null;
            if (bl) {
                this.address = 0;
                this.addressString = "$0000";
                this.end = 65535;
                this.endString = "$FFFF";
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("op=2");
                if (address2 != null) {
                    if (address2.getAddress() != address.getAddress()) {
                        stringBuilder.append("&&target>=").append(address.getAddress()).append("&&target<=").append(address2.getAddress());
                    } else {
                        stringBuilder.append("&&target=").append(address.getAddress());
                    }
                    if (address.getBank() >= 0) {
                        int n2 = n = address2.getBank() >= 0 ? address2.getBank() : address.getBank();
                        if (n != address.getBank()) {
                            stringBuilder.append("&&(&target>=").append(address.getBank()).append(")&&(&target<=").append(n).append(')');
                        } else {
                            stringBuilder.append("&&(&target=").append(address.getBank()).append(')');
                        }
                    }
                } else {
                    stringBuilder.append("&&target=").append(addressRange.getFrom().getAddress());
                    if (address.getBank() >= 0) {
                        stringBuilder.append("&&(&target=").append(address.getBank()).append(')');
                    }
                }
                this.condition = Expression.andExpressions(new Expression(stringBuilder.toString(), DebugFile.getTokenizer()), action.getCondition().getConditionExpression());
            } else {
                Expression expression;
                this.address = addressRange.getFrom().getAddress();
                int n3 = string3.indexOf(58);
                this.addressString = n3 >= 0 ? string3.substring(n3 + 1) : string3;
                this.end = address2 != null ? address2.getAddress() : this.address;
                n3 = string2 != null ? string2.indexOf(58) : -1;
                String string5 = this.endString = string2 != null && n3 >= 0 ? string2.substring(n3 + 1) : string2;
                if (address.getBank() >= 0) {
                    int n4;
                    StringBuilder stringBuilder = new StringBuilder();
                    int n5 = n4 = address2 != null && address2.getBank() >= 0 ? address2.getBank() : address.getBank();
                    if (n4 != address.getBank()) {
                        stringBuilder.append("(&target>=").append(address.getBank()).append(")&&(&target<=").append(n4).append(')');
                    } else {
                        stringBuilder.append("(&target=").append(address.getBank()).append(')');
                    }
                    expression = new Expression(stringBuilder.toString(), DebugFile.getTokenizer());
                } else {
                    expression = null;
                }
                this.condition = Expression.andExpressions(Expression.andExpressions(this.flagsToExpression(string), expression), action.getCondition().getConditionExpression());
            }
            this.conditionString = this.condition != null ? this.condition.toString() : "";
            final int n6 = action.getRadix();
            n = action.getSignedness() ? 1 : 0;
            final boolean bl2 = string.contains("m");
            this.breakpointAction = new Breakpoint.Action(n != 0){
                private final /* synthetic */ boolean val$signedness;
                {
                    this.val$signedness = bl22;
                }

                @Override
                public void performAction() {
                    if (!bl2) {
                        DebugFileInterpreter.this.performedActions.add(action);
                    }
                    DebugFileInterpreter.this.debugFile.setLocals(action.getLocals());
                    String string = "";
                    boolean bl = false;
                    Command[] commandArray = action.getCommands();
                    int n = 0;
                    while (n < commandArray.length) {
                        Command command = commandArray[n];
                        switch (command.getKeyword()) {
                            case ALERT: {
                                if (!string.isEmpty()) {
                                    string = String.valueOf(string) + "\n";
                                }
                                string = String.valueOf(string) + DebugFileInterpreter.this.evaluateString(((AlertCommand)command).getMessage(), n6, action.getSignedness(), action.getLocals());
                                break;
                            }
                            case BREAK: {
                                DebugFileInterpreter.this.systemDebugger.suspend();
                                break;
                            }
                            case DISABLE: {
                                if (((DisableCommand)command).getGroup().isEmpty()) {
                                    DebugFileInterpreter.this.disabledActions.add(action);
                                    break;
                                }
                                Object object = DebugFileInterpreter.this.debugFile.getGroups().get(((DisableCommand)command).getGroup());
                                DebugFileInterpreter.this.disabledActions.addAll(((ActionGroup)object).getActions());
                                break;
                            }
                            case DONE: {
                                n = commandArray.length;
                                break;
                            }
                            case ELSE: {
                                if (!bl) break;
                                ++n;
                                break;
                            }
                            case ENABLE: {
                                if (((EnableCommand)command).getGroup().isEmpty()) {
                                    DebugFileInterpreter.this.disabledActions.remove(action);
                                    break;
                                }
                                Object object = DebugFileInterpreter.this.debugFile.getGroups().get(((EnableCommand)command).getGroup());
                                DebugFileInterpreter.this.disabledActions.removeAll(((ActionGroup)object).getActions());
                                break;
                            }
                            case IF: {
                                Object object = ((IfCommand)command).getCondition();
                                if (object != null) {
                                    try {
                                        bl = ((Expression)object).isTrue(DebugFileWatchpoint.this.variables, null, this.val$signedness);
                                    }
                                    catch (UnknownVariableException unknownVariableException) {
                                        unknownVariableException.printStackTrace();
                                    }
                                }
                                if (bl) break;
                                ++n;
                                break;
                            }
                            case JUMP: {
                                Object object;
                                try {
                                    object = ((JumpCommand)command).getAddress().getBank();
                                    int n2 = (int)((JumpCommand)command).getAddress().getAddress().getValue(DebugFileWatchpoint.this.variables, null, this.val$signedness);
                                    if (object != null) {
                                        DebugFileInterpreter.this.systemDebugger.setBank(n2, (int)((Expression)object).getValue(DebugFileWatchpoint.this.variables, null, this.val$signedness));
                                    }
                                    DebugFileInterpreter.this.systemDebugger.setPC(n2);
                                }
                                catch (UnknownVariableException unknownVariableException) {
                                    DebugFileInterpreter.this.systemDebugger.fireMessageReceived("ERROR in debugfile jump command: " + unknownVariableException.getMessage() + "\n");
                                }
                                break;
                            }
                            case MESSAGE: {
                                Object object = DebugFileInterpreter.this.evaluateString(((MessageCommand)command).getMessage(), n6, action.getSignedness(), action.getLocals());
                                DebugFileInterpreter.this.systemDebugger.setBreakpointMessage((String)object);
                                DebugFileInterpreter.this.systemDebugger.fireMessageReceived(String.valueOf(object) + "\n");
                                break;
                            }
                            case NOP: {
                                break;
                            }
                            case RESET: {
                                DebugFileInterpreter.this.systemDebugger.performReset();
                                break;
                            }
                            case SET: {
                                Object object;
                                try {
                                    int n2;
                                    Object unknownVariableException;
                                    object = ((SetCommand)command).getLvalue();
                                    Expression object3 = ((SetCommand)command).getExpression();
                                    if (object instanceof VariableLValue) {
                                        unknownVariableException = ((VariableLValue)object).getVariableName();
                                        long n62 = object3.getValue(DebugFileWatchpoint.this.variables, null, this.val$signedness);
                                        if (((String)unknownVariableException).charAt(0) == '_') {
                                            Value stringArray = (Value)DebugFileInterpreter.this.variableValues.get(unknownVariableException);
                                            if (stringArray == null) break;
                                            stringArray.value = n62;
                                            break;
                                        }
                                        String[] n8 = DebugFileInterpreter.this.systemDebugger.getRegisterNames();
                                        int stringArray2 = 0;
                                        while (stringArray2 < n8.length) {
                                            if (n8[stringArray2].equalsIgnoreCase((String)unknownVariableException)) {
                                                DebugFileInterpreter.this.systemDebugger.setRegValue(stringArray2, (int)n62 & 0xFFFF);
                                            } else if (((String)unknownVariableException).length() == 1 && n8[stringArray2].length() == 2) {
                                                if (n8[stringArray2].substring(0, 1).equalsIgnoreCase((String)unknownVariableException)) {
                                                    DebugFileInterpreter.this.systemDebugger.setRegValue(stringArray2, ((int)n62 & 0xFF) << 8 | DebugFileInterpreter.this.systemDebugger.getRegisterValue(stringArray2) & 0xFF);
                                                } else if (n8[stringArray2].substring(1).equalsIgnoreCase((String)unknownVariableException)) {
                                                    DebugFileInterpreter.this.systemDebugger.setRegValue(stringArray2, (DebugFileInterpreter.this.systemDebugger.getRegisterValue(stringArray2) & 0xFF) << 8 | (int)n62 & 0xFF);
                                                }
                                            }
                                            ++stringArray2;
                                        }
                                        if (((String)unknownVariableException).length() == 2 && Character.toLowerCase(((String)unknownVariableException).charAt(1)) == 'f') {
                                            String[] l = DebugFileInterpreter.this.systemDebugger.getFlagNames();
                                            int n3 = 0;
                                            while (n3 < l.length) {
                                                if (Character.toUpperCase(((String)unknownVariableException).charAt(0)) == l[n3].charAt(0) || l[n3].length() == 3 && l[n3].charAt(1) == '/' && Character.toUpperCase(((String)unknownVariableException).charAt(0)) == l[n3].charAt(2)) {
                                                    DebugFileInterpreter.this.systemDebugger.setFlagSet(n3, n62 != 0L);
                                                }
                                                ++n3;
                                            }
                                            break;
                                        }
                                        if ("ime".equalsIgnoreCase((String)unknownVariableException)) {
                                            DebugFileInterpreter.this.systemDebugger.setInterruptsEnabled(n62 != 0L);
                                            break;
                                        }
                                        if (!"sram".equalsIgnoreCase((String)unknownVariableException)) break;
                                        DebugFileInterpreter.this.systemDebugger.setSRAMenabled(n62 != 0L);
                                        break;
                                    }
                                    if (object instanceof BankLValue) {
                                        unknownVariableException = (BankLValue)object;
                                        int expression = (int)object3.getValue(DebugFileWatchpoint.this.variables, null, this.val$signedness);
                                        n2 = (int)((BankLValue)unknownVariableException).getExpression().getValue(DebugFileWatchpoint.this.variables, null, this.val$signedness);
                                        DebugFileInterpreter.this.systemDebugger.setBank(n2, expression);
                                        break;
                                    }
                                    if (!(object instanceof MemoryAccess)) break;
                                    try {
                                        int n4;
                                        unknownVariableException = (MemoryAccess)object;
                                        Expression expression = ((MemoryAccess)unknownVariableException).getAddress().getBank();
                                        n2 = expression != null ? expression.getValue(DebugFileWatchpoint.this.variables, null) : -1;
                                        int n5 = (int)((MemoryAccess)unknownVariableException).getAddress().getAddress().getValue(DebugFileWatchpoint.this.variables, null, this.val$signedness);
                                        long l = object3.getValue(DebugFileWatchpoint.this.variables, null, this.val$signedness);
                                        if (((MemoryAccess)unknownVariableException).isBigEndian()) {
                                            n4 = ((MemoryAccess)unknownVariableException).getSize() - 1;
                                            while (n4 >= 0) {
                                                if (n2 >= 0 || ((MemoryAccess)unknownVariableException).isElevated()) {
                                                    DebugFileInterpreter.this.systemDebugger.setByte(n5 + n4, n2 >= 0 ? n2 : DebugFileInterpreter.this.systemDebugger.getBank(n5), (int)l & 0xFF);
                                                } else {
                                                    DebugFileInterpreter.this.systemDebugger.pokeByte(n5 + n4, (int)l & 0xFF);
                                                }
                                                l >>= 8;
                                                --n4;
                                            }
                                        } else {
                                            n4 = 0;
                                            while (n4 < ((MemoryAccess)unknownVariableException).getSize()) {
                                                if (n2 >= 0 || ((MemoryAccess)unknownVariableException).isElevated()) {
                                                    DebugFileInterpreter.this.systemDebugger.setByte(n5 + n4, n2 >= 0 ? n2 : DebugFileInterpreter.this.systemDebugger.getBank(n5), (int)l & 0xFF);
                                                } else {
                                                    DebugFileInterpreter.this.systemDebugger.pokeByte(n5 + n4, (int)l & 0xFF);
                                                }
                                                l >>= 8;
                                                ++n4;
                                            }
                                        }
                                    }
                                    catch (UnknownVariableException unknownVariableException2) {
                                        DebugFileInterpreter.this.systemDebugger.fireMessageReceived("ERROR in debugfile set command: " + unknownVariableException2.getMessage() + "\n");
                                    }
                                }
                                catch (UnknownVariableException unknownVariableException) {
                                    DebugFileInterpreter.this.systemDebugger.fireMessageReceived("ERROR in debugfile set command: " + unknownVariableException.getMessage() + "\n");
                                }
                                break;
                            }
                            case SKIP: {
                                n += ((SkipCommand)command).getAmount();
                                break;
                            }
                            case TOGGLE: {
                                if (((ToggleCommand)command).getGroup().isEmpty()) {
                                    if (DebugFileInterpreter.this.disabledActions.add(action)) break;
                                    DebugFileInterpreter.this.disabledActions.remove(action);
                                    break;
                                }
                                Object object = DebugFileInterpreter.this.debugFile.getGroups().get(((ToggleCommand)command).getGroup());
                                for (Action action2 : ((ActionGroup)object).getActions()) {
                                    if (DebugFileInterpreter.this.disabledActions.add(action2)) continue;
                                    DebugFileInterpreter.this.disabledActions.remove(action2);
                                }
                                break;
                            }
                        }
                        ++n;
                    }
                    if (!DebugFileInterpreter.this.systemDebugger.isSuspended()) {
                        DebugFileInterpreter.this.systemDebugger.setBreakpointMessage(null);
                    }
                    if (!string.isEmpty()) {
                        DebugFileInterpreter.this.systemDebugger.fireAlert(string);
                    }
                }
            };
        }

        @Override
        public Breakpoint newInstance(int n, int n2) {
            return this;
        }

        @Override
        public Breakpoint newInstance(String string, String string2, ExpressionEvaluator expressionEvaluator) {
            return this;
        }

        private Expression flagsToExpression(String string) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = string.contains("x");
                boolean bl2 = string.contains("r");
                boolean bl3 = string.contains("w");
                if (bl) {
                    if (!bl2) {
                        if (bl3) {
                            stringBuilder.append("((op=2)||(op=1))");
                        } else {
                            stringBuilder.append("(op=2)");
                        }
                    }
                } else if (bl2) {
                    stringBuilder.append("(op!=2)");
                }
                if (string.contains("ww")) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("&&");
                    }
                    stringBuilder.append("((op!=1)||(value!=oldvalue))");
                }
                return stringBuilder.length() > 0 ? new Expression(stringBuilder.toString(), DebugFile.getTokenizer()) : null;
            }
            catch (ParseException parseException) {
                throw new RuntimeException(this.endString);
            }
        }

        @Override
        public String getAddressString() {
            return this.addressString;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public String getEndString() {
            return this.endString;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public boolean isRead() {
            return this.flags.contains("r") || this.flags.contains("x");
        }

        @Override
        public boolean isWrite() {
            return this.flags.contains("w");
        }

        @Override
        public boolean isEnabled() {
            return !DebugFileInterpreter.this.disabledActions.contains(this.action) && !DebugFileInterpreter.this.performedActions.contains(this.action);
        }

        @Override
        public String getCondition() {
            return this.conditionString;
        }

        @Override
        public Expression getConditionExpression() {
            DebugFileInterpreter.this.debugFile.setLocals(this.action.getLocals());
            return this.condition;
        }

        @Override
        public boolean isConditionSigned() {
            return this.action.getSignedness();
        }

        @Override
        public String getMessage() {
            Command[] commandArray = this.action.getCommands();
            Object[] objectArray = new String[commandArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = commandArray[n].getKeyword().toString();
                ++n;
            }
            return Arrays.toString(objectArray);
        }

        @Override
        public boolean isSuspend() {
            return false;
        }

        @Override
        public Breakpoint.Action getAction() {
            return this.breakpointAction;
        }

        @Override
        public VariableProvider getVariables() {
            return this.variables;
        }

        @Override
        public String toString() {
            return "";
        }
    }

    class Value {
        private long value;

        Value() {
        }
    }

    class Variables
    implements VariableProvider {
        Variables() {
        }

        @Override
        public int readValue(int n, boolean bl, boolean bl2) {
            return DebugFileInterpreter.this.systemDebugger.getVariables().readValue(n, bl, bl2);
        }

        @Override
        public int readLocation(String string, int n, boolean bl) throws UnknownVariableException {
            return DebugFileInterpreter.this.systemDebugger.getVariables().readLocation(string, n, bl);
        }

        @Override
        public int getBankAt(int n) {
            return DebugFileInterpreter.this.systemDebugger.getVariables().getBankAt(n);
        }

        @Override
        public long mapBank(int n, int n2) {
            return DebugFileInterpreter.this.systemDebugger.getVariables().mapBank(n, n2);
        }

        @Override
        public boolean isConstantRead(int n) {
            return DebugFileInterpreter.this.systemDebugger.getVariables().isConstantRead(n);
        }

        @Override
        public boolean isConstant(String string) throws UnknownVariableException {
            char c = string.charAt(0);
            if (c == '_') {
                Value value = (Value)DebugFileInterpreter.this.variableValues.get(string);
                if (value != null) {
                    return false;
                }
            } else if (c == '@') {
                string = string.substring(1);
            }
            if ("target".equals(string)) {
                string = "source";
            }
            return DebugFileInterpreter.this.systemDebugger.getVariables().isConstant(string);
        }

        @Override
        public long getValue(String string, boolean bl) throws UnknownVariableException {
            Symbols.Symbol symbol = DebugFileInterpreter.this.debugFile.resolveSymbol(string);
            if (symbol != null) {
                if (symbol.getBank() >= 0) {
                    return (long)symbol.getBank() << 16 | (long)symbol.getAddress();
                }
                return symbol.getAddress();
            }
            char c = string.charAt(0);
            if (c == '@' && string.length() > 1) {
                string = string.substring(1);
            }
            if ((c = string.charAt(0)) == '_') {
                Value value = (Value)DebugFileInterpreter.this.variableValues.get(string);
                if (value == null) {
                    throw new UnknownVariableException(string);
                }
                return value.value;
            }
            if ("pc".equals(string)) {
                return DebugFileInterpreter.this.systemDebugger.getPrevPC();
            }
            if ("target".equals(string)) {
                string = "source";
            }
            if ("next".equals(string)) {
                int n = DebugFileInterpreter.this.systemDebugger.getPrevPC();
                int n2 = DebugFileInterpreter.this.systemDebugger.peekByte(n);
                if (n2 < 64) {
                    if (n2 == 8 || (n2 & 0xCF) == 1) {
                        return n + 3 & 0xFFFF;
                    }
                    if (n2 == 24 || (n2 & 0xC7) == 6 || (n2 & 0xE7) == 32) {
                        return n + 2 & 0xFFFF;
                    }
                    return n + 1 & 0xFFFF;
                }
                if (n2 < 128) {
                    return n + 1 & 0xFFFF;
                }
                if (n2 == 203 || (n2 & 0xE7) == 224 || (n2 & 0xEF) == 226 || (n2 & 0xC7) == 198) {
                    return n + 2 & 0xFFFF;
                }
                if (n2 == 195 || n2 == 205 || (n2 & 0xE7) == 194 || (n2 & 0xE7) == 196 || (n2 & 0xEF) == 234) {
                    return n + 3 & 0xFFFF;
                }
                return n + 1 & 0xFFFF;
            }
            long l = DebugFileInterpreter.this.systemDebugger.getVariables().getValue(string, bl);
            if (bl) {
                if (string.length() == 1 && Character.toLowerCase(string.charAt(0)) != 'f' || "value".equals(string)) {
                    return (byte)l;
                }
                if (string.length() == 2 && !"sp".equals(string) && !"pc".equals(string)) {
                    String[] stringArray = DebugFileInterpreter.this.systemDebugger.getRegisterNames();
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String string2 = stringArray[n3];
                        if (string2.equals(string)) {
                            return (short)l;
                        }
                        ++n3;
                    }
                }
            }
            return l;
        }
    }
}

