/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import common.ComponentWrapper;
import common.ScreenUtilities;
import expressions.ParseException;
import expressions.UnknownVariableException;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import platform.Emulicious;
import platform.debugger.AddBreakpointDialog;
import platform.debugger.Breakpoint;
import platform.debugger.Console;
import platform.debugger.Debugger;
import platform.debugger.DebuggerIcons;
import platform.debugger.InvalidBreakpoint;
import platform.debugger.IsConstantException;
import platform.debugger.SystemDebugger;
import platform.debugger.Watchpoint;

class BreakpointWindow
implements SystemDebugger.BreakpointListener {
    private static final String[] EXCEPTION_DESCRIPTIONS = new String[]{"Break on inconsistent state after interrupt", "Break on read of uninitialized memory", "Break on execution of data", "Break on bank swap at PC", "Break on push to ROM"};
    private static final int MAX_LINES = 10000;
    private static final int BUFFER_SIZE = 65536;
    private static BreakpointWindow breakpointWindow;
    private final JTable table;
    private final JTable exceptionsTable;
    private final Console console;
    private static BreakpointTableModel model;
    private static ExceptionsTableModel exceptionsModel;
    private final Debugger debugger;
    final Window window;

    private BreakpointWindow(Window window, Debugger debugger, boolean bl) {
        JTable jTable;
        Console console;
        JTable jTable2;
        this.window = bl ? new JFrame() : new JDialog();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Breakpoints");
        this.window.setIconImage(window.getIconImages().get(0));
        this.debugger = debugger;
        this.table = jTable2 = BreakpointWindow.createBreakpointsTable(debugger);
        this.console = console = new Console(4, 80, 65536, 10000){

            @Override
            public Color getForeground() {
                return jTable2.getForeground();
            }

            @Override
            public Color getSelectedTextColor() {
                return jTable2.getSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return jTable2.getBackground();
            }

            @Override
            public Color getSelectionColor() {
                return jTable2.getSelectionBackground();
            }

            @Override
            public Font getFont() {
                return jTable2.getFont();
            }
        };
        final JCheckBox jCheckBox = new JCheckBox("Skip Breakpoints");
        jCheckBox.setModel(debugger.getSkipBreakpointsModel());
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTable2.setEnabled(!jCheckBox.isSelected());
            }
        });
        this.exceptionsTable = jTable = BreakpointWindow.createExceptionsTable(debugger);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        JPanel jPanel = BreakpointWindow.createBreakpointsPanel(jTable2, debugger);
        jPanel.setBorder(BorderFactory.createTitledBorder("Breakpoints"));
        jPanel.add((Component)ComponentWrapper.wrapComponent(jCheckBox), "North");
        jTable2.setEnabled(!jCheckBox.isSelected());
        jTable2.getSelectionModel().setSelectionInterval(0, 0);
        final JCheckBox jCheckBox2 = new JCheckBox("Skip Exceptions");
        jCheckBox2.setModel(debugger.getSkipExceptionsModel());
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTable.setEnabled(!jCheckBox2.isSelected());
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Exceptions"));
        jPanel2.add((Component)ComponentWrapper.wrapComponent(jCheckBox2), "North");
        jPanel2.add(jScrollPane);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)jPanel, "Center");
        console.setEditable(false);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JScrollPane(console), "Center");
        JButton jButton = new JButton("Clear Log");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                console.setText("");
            }
        });
        JPanel jPanel5 = new JPanel(new FlowLayout(2));
        jPanel5.add(jButton);
        jPanel4.add((Component)jPanel5, "North");
        JSplitPane jSplitPane = new JSplitPane(0, true, jPanel3, jPanel4);
        jSplitPane.setResizeWeight(0.8f);
        this.window.add((Component)jSplitPane, "Center");
        debugger.installRunActions(this.getRootPane());
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuAdd());
        if (breakpointWindow == null || !breakpointWindow.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private JRootPane getRootPane() {
        if (this.window instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)this.window)).getRootPane();
        }
        return null;
    }

    private void setJMenuBar(JMenuBar jMenuBar) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setJMenuBar(jMenuBar);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setJMenuBar(jMenuBar);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    private JMenu makeMenuAdd() {
        JMenu jMenu = new JMenu("Add");
        jMenu.setMnemonic('a');
        JMenuItem jMenuItem = new JMenuItem("Add Watchpoint", 97);
        jMenuItem.setIcon(DebuggerIcons.ADD_WATCHPOINT_ICON);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointWindow.this.openAddWatchpointDialog();
            }
        });
        return jMenu;
    }

    void openAddWatchpointDialog() {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        new AddBreakpointDialog(this.window, this.debugger);
        this.table.requestFocus();
    }

    static JPanel createBreakpointsPanel(JTable jTable, Debugger debugger) {
        JPanel jPanel = new JPanel(new BorderLayout());
        Debugger debugger2 = debugger;
        debugger2.getClass();
        jPanel.add((Component)debugger2.new Debugger.DebuggerScrollPane(jTable), "Center");
        jPanel.add((Component)BreakpointWindow.createBreakpointProperties(jTable, debugger), "South");
        return jPanel;
    }

    private static JPanel createBreakpointProperties(final JTable jTable, final Debugger debugger) {
        int n = ComponentWrapper.wrapComponent((JComponent)new JCheckBox()).getPreferredSize().height;
        final JPanel jPanel = new JPanel(n){
            private int minHeight;
            {
                this.minHeight = n;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.height > this.minHeight) {
                    this.minHeight = dimension.height;
                } else {
                    dimension.height = this.minHeight;
                }
                return dimension;
            }

            @Override
            public Color getBackground() {
                return jTable.getParent() instanceof JViewport ? jTable.getParent().getParent().getBackground() : super.getBackground();
            }

            @Override
            public Color getForeground() {
                return jTable.getParent() instanceof JViewport ? jTable.getParent().getParent().getForeground() : super.getForeground();
            }
        };
        jPanel.setLayout(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (jTable.getSelectedRowCount() > 1) {
                        BreakpointWindow.updateBreakpointProperties(debugger, jPanel, -1);
                    } else {
                        BreakpointWindow.updateBreakpointProperties(debugger, jPanel, jTable.getSelectedRow());
                    }
                }
            }
        });
        jTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (jTable.getSelectedRowCount() > 1) {
                    BreakpointWindow.updateBreakpointProperties(debugger, jPanel, -1);
                } else {
                    BreakpointWindow.updateBreakpointProperties(debugger, jPanel, jTable.getSelectedRow());
                }
            }
        });
        return jPanel;
    }

    static JTable createBreakpointsTable(Debugger debugger) {
        if (model == null) {
            model = new BreakpointTableModel(debugger);
        }
        return BreakpointWindow.createBreakpointsTable(debugger, model);
    }

    private static JTable createBreakpointsTable(final Debugger debugger, final BreakpointTableModel breakpointTableModel) {
        final JTable jTable = new JTable((TableModel)breakpointTableModel){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                InputEvent inputEvent;
                int n3;
                if (eventObject instanceof KeyEvent && (n3 = ((KeyEvent)(inputEvent = (KeyEvent)eventObject)).getKeyCode()) >= 116 && n3 <= 120) {
                    return false;
                }
                if (eventObject instanceof MouseEvent && ((inputEvent = (MouseEvent)eventObject).getModifiers() & (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 2 | 1)) != 0) {
                    return false;
                }
                return super.editCellAt(n, n2, eventObject);
            }

            @Override
            public void setFont(Font font) {
                Component component = this.getEditorComponent();
                if (component == null) {
                    component = this.getDefaultEditor(Object.class).getTableCellEditorComponent(this, null, false, 0, 0);
                }
                component.setFont(this.getFont());
            }

            @Override
            public Color getForeground() {
                return debugger.getTableForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return debugger.getTableSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return debugger.getTableBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return debugger.getTableSelectionBackground();
            }

            @Override
            public Color getGridColor() {
                Color color = super.getGridColor();
                if (color != null && color.equals(Color.WHITE)) {
                    return Color.GRAY;
                }
                return color;
            }

            @Override
            public Font getFont() {
                return debugger.getFont();
            }

            @Override
            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Component component = super.prepareEditor(tableCellEditor, n, n2);
                component.setFont(this.getFont());
                component.setForeground(this.getSelectionForeground());
                component.setBackground(this.getSelectionBackground());
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setCaretColor(component.getForeground());
                }
                return component;
            }

            @Override
            public void updateUI() {
                super.updateUI();
                int n = this.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                TableColumn tableColumn = this.getColumnModel().getColumn(0);
                tableColumn.setMaxWidth(Integer.MAX_VALUE);
                tableColumn.setMinWidth(n);
                tableColumn.setMaxWidth(n);
                tableColumn = this.getColumnModel().getColumn(1);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.getTableHeader().getDefaultRenderer();
                }
                n = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)1).getPreferredSize().width;
                tableColumn.setMaxWidth(Integer.MAX_VALUE);
                tableColumn.setMinWidth(n + this.getIntercellSpacing().width);
                tableColumn.setMaxWidth(n + this.getIntercellSpacing().width);
                tableColumn = this.getColumnModel().getColumn(2);
                n = this.getCellRenderer((int)(this.getRowCount() - 1), (int)2).getTableCellRendererComponent((JTable)this, (Object)"Add Breakpoint", (boolean)false, (boolean)false, (int)(this.getRowCount() - 1), (int)2).getPreferredSize().width;
                tableColumn.setMinWidth(n + this.getIntercellSpacing().width);
                int n2 = this.getRowCount() - 1;
                int n3 = this.getCellRenderer((int)n2, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)n2, (int)0), (boolean)false, (boolean)false, (int)n2, (int)0).getPreferredSize().height;
                this.setRowHeight(Math.max(n3, this.getCellRenderer((int)n2, (int)2).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)n2, (int)2), (boolean)false, (boolean)false, (int)n2, (int)2).getPreferredSize().height));
            }
        };
        breakpointTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TableCellEditor tableCellEditor;
                if (tableModelEvent.getType() == 1) {
                    jTable.getSelectionModel().removeSelectionInterval(tableModelEvent.getFirstRow(), tableModelEvent.getFirstRow());
                }
                if ((tableCellEditor = jTable.getCellEditor()) != null) {
                    tableCellEditor.cancelCellEditing();
                }
            }
        });
        jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        jTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                boolean bl3;
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                boolean bl4 = bl3 = n >= jTable.getRowCount() - 1 || (Boolean)jTable.getValueAt(n, 0) != false;
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setToolTipText(null);
                    if (n < jTable.getRowCount() - 1) {
                        if (!bl3) {
                            jComponent.setToolTipText("<html>This breakpoint is disabled.<br />Disabled breakpoints are ignored completely.<br />You can use the left-most checkbox to enable it.</html>");
                        } else if (n2 == 3) {
                            jComponent.setToolTipText("<html>" + (object != null && !object.toString().isEmpty() ? String.valueOf(object.toString().replace("<", "&lt;")) + "<br /><br />" : "") + "Conditions can use arbitrary expressions as described in the Expressions Help dialog.<br>An example is <b>value != oldvalue</b> to only break when the value of the given address changed.<br>Click the question mark (?) in this tab's toolbar at the top right for more examples.</html>");
                        } else if (n2 == 4) {
                            jComponent.setToolTipText("<html>" + (object != null && !object.toString().isEmpty() ? String.valueOf(object.toString().replace("<", "&lt;")) + "<br /><br />" : "") + "Here you can specify the message to print using arbitrary expressions as described in the Expressions Help dialog.<br>You can use commas to concatenate strings.<br>An example is the following:<br><b>\"Value changed from \",oldvalue,\" to \",value\"</b><br>Click the question mark (?) in this tab's toolbar at the top right for more examples.</html>");
                        } else if (object != null) {
                            jComponent.setToolTipText(object.toString());
                        }
                    }
                }
                component.setEnabled(jTable.isEnabled() && (n2 != 5 || bl3));
                if (n < jTable.getRowCount() - 1 && BreakpointWindow.getBreakpointAt(debugger, n) == debugger.getBreakpointHit() && !breakpointTableModel.hasError(n)) {
                    component.setForeground(Color.WHITE);
                    component.setBackground(Color.RED);
                } else {
                    component.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
                    component.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                }
                if (n2 == 2 && n == jTable.getRowCount() - 1) {
                    if (component instanceof JLabel) {
                        ((JLabel)component).setText("Add Breakpoint");
                    }
                } else if (n2 >= 2 && breakpointTableModel.hasError(n) && component instanceof JLabel && object != null) {
                    ((JLabel)component).setText("<html><body style=\"white-space:nowrap\"><font color=\"red\">" + object.toString().replace("<", "&lt;").replace(">", "&gt;") + "</font></body></html>");
                    ((JLabel)component).setToolTipText(jTable.getValueAt(n, 5).toString());
                }
                return component;
            }
        });
        jTable.setDefaultRenderer(Boolean.class, new TableCellRenderer(jTable){
            private final TableCellRenderer defaultBooleanRenderer;
            {
                this.defaultBooleanRenderer = jTable.getDefaultRenderer(Boolean.class);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                boolean bl3;
                Component component = this.defaultBooleanRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                boolean bl4 = bl3 = n >= jTable.getRowCount() - 1 || (Boolean)jTable.getValueAt(n, 0) != false;
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setToolTipText(null);
                    if (n < jTable.getRowCount() - 1) {
                        if (!bl3) {
                            jComponent.setToolTipText("<html>This breakpoint is disabled.<br />Disabled breakpoints are ignored completely.<br />You can use the left-most checkbox to enable it.</html>");
                        } else if (n2 == 0) {
                            jComponent.setToolTipText("<html>This breakpoint is enabled.<br>Enabled breakpoints always log to the Console.<br>You can make this breakpoint only log to Console by unchecking the checkbox in the Suspend column.</html>");
                        } else if (n2 == 1) {
                            jComponent.setToolTipText("<html>This breakpoint is set to " + ((Boolean)object != false ? "suspend." : "<b>not</b> suspend. So it will only log to Console.") + "<br>Enabled breakpoints always log to the Console but only suspend execution if this checkbox is checked.</html>");
                        } else {
                            jComponent.setToolTipText(object.toString());
                        }
                    }
                }
                component.setEnabled(jTable.isEnabled() && (n2 != 1 || bl3));
                if (n < jTable.getRowCount() - 1 && BreakpointWindow.getBreakpointAt(debugger, n) == debugger.getBreakpointHit() && !breakpointTableModel.hasError(n)) {
                    component.setForeground(Color.WHITE);
                    component.setBackground(Color.RED);
                } else {
                    component.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
                    component.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                }
                return component;
            }
        });
        ((DefaultCellEditor)jTable.getDefaultEditor(Object.class)).setClickCountToStart(1);
        jTable.setSurrendersFocusOnKeystroke(true);
        jTable.setAutoResizeMode(3);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Breakpoint breakpoint;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0 && (breakpoint = BreakpointWindow.getBreakpointAt(debugger, jTable.getSelectedRow())) != null) {
                    debugger.setSelection(breakpoint);
                }
            }
        });
        jTable.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        jTable.getInputMap().put(KeyStroke.getKeyStroke("BACK_SPACE"), "delete");
        jTable.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = jTable.getSelectedRows();
                int n = nArray.length - 1;
                while (n >= 0) {
                    debugger.removeBreakpoint(BreakpointWindow.getBreakpointAt(debugger, nArray[n]));
                    --n;
                }
            }
        });
        BreakpointWindow.restoreTraversalKeys(jTable);
        jTable.setFillsViewportHeight(true);
        return jTable;
    }

    private static void restoreTraversalKeys(JTable jTable) {
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(jTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke("TAB"));
        jTable.setFocusTraversalKeys(0, hashSet);
        HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>(jTable.getFocusTraversalKeys(1));
        hashSet2.add(KeyStroke.getKeyStroke("shift TAB"));
        jTable.setFocusTraversalKeys(1, hashSet2);
    }

    static JTable createExceptionsTable(Debugger debugger) {
        if (exceptionsModel == null) {
            exceptionsModel = new ExceptionsTableModel(debugger);
        }
        return BreakpointWindow.createExceptionsTable(debugger, exceptionsModel);
    }

    private static JTable createExceptionsTable(final Debugger debugger, ExceptionsTableModel exceptionsTableModel) {
        JTable jTable = new JTable((TableModel)exceptionsTableModel){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                InputEvent inputEvent;
                int n3;
                if (eventObject instanceof KeyEvent && (n3 = ((KeyEvent)(inputEvent = (KeyEvent)eventObject)).getKeyCode()) >= 116 && n3 <= 120) {
                    return false;
                }
                if (eventObject instanceof MouseEvent && ((inputEvent = (MouseEvent)eventObject).getModifiers() & (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 2 | 1)) != 0) {
                    return false;
                }
                return super.editCellAt(n, n2, eventObject);
            }

            @Override
            public void setFont(Font font) {
                Component component = this.getEditorComponent();
                if (component == null) {
                    component = this.getDefaultEditor(Object.class).getTableCellEditorComponent(this, null, false, 0, 0);
                }
                component.setFont(this.getFont());
            }

            @Override
            public Color getForeground() {
                return debugger.getTableForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return debugger.getTableSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return debugger.getTableBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return debugger.getTableSelectionBackground();
            }

            @Override
            public Color getGridColor() {
                Color color = super.getGridColor();
                if (color != null && color.equals(Color.WHITE)) {
                    return Color.GRAY;
                }
                return color;
            }

            @Override
            public Font getFont() {
                return debugger.getFont();
            }

            @Override
            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Component component = super.prepareEditor(tableCellEditor, n, n2);
                component.setFont(this.getFont());
                component.setForeground(this.getSelectionForeground());
                component.setBackground(this.getSelectionBackground());
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setCaretColor(component.getForeground());
                }
                return component;
            }

            @Override
            public void updateUI() {
                super.updateUI();
                this.packColumns();
            }

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                super.tableChanged(tableModelEvent);
                if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == -1 && tableModelEvent.getFirstRow() == -1) {
                    this.packColumns();
                }
            }

            private void packColumns() {
                if (this.getTableHeader() == null) {
                    return;
                }
                int n = this.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                TableColumn tableColumn = this.getColumnModel().getColumn(0);
                tableColumn.setPreferredWidth(n);
                tableColumn.setMaxWidth(n);
                tableColumn = this.getColumnModel().getColumn(1);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.getTableHeader().getDefaultRenderer();
                }
                n = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)1).getPreferredSize().width;
                tableColumn.setMaxWidth(Integer.MAX_VALUE);
                tableColumn.setMinWidth(n + this.getIntercellSpacing().width);
                tableColumn.setMaxWidth(n + this.getIntercellSpacing().width);
                tableColumn = this.getColumnModel().getColumn(2);
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.getRowCount()) {
                    n2 = Math.max(n2, this.getCellRenderer((int)n3, (int)2).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)n3, (int)2), (boolean)false, (boolean)false, (int)n3, (int)2).getPreferredSize().width);
                    ++n3;
                }
                tableColumn.setMaxWidth(n2 + this.getIntercellSpacing().width);
                tableColumn.setPreferredWidth(n2 + this.getIntercellSpacing().width);
                n3 = this.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height;
                this.setRowHeight(Math.max(n3, this.getCellRenderer((int)0, (int)2).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)0, (int)2), (boolean)false, (boolean)false, (int)0, (int)2).getPreferredSize().height));
            }
        };
        jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        BreakpointWindow.restoreTraversalKeys(jTable);
        jTable.setFillsViewportHeight(true);
        jTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                boolean bl3 = (Boolean)jTable.getValueAt(n, 0);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setToolTipText(null);
                    if (!bl3) {
                        jComponent.setToolTipText("<html>This exception breakpoint is disabled.<br />Disabled exception breakpoints are ignored completely.<br />You can use the left-most checkbox to enable it.</html>");
                    } else if (n2 == 3) {
                        jComponent.setToolTipText("<html>" + (!object.toString().isEmpty() ? String.valueOf(object.toString().replace("<", "&lt;")) + "<br /><br />" : "") + "Conditions can use arbitrary expressions as described in the Expressions Help dialog.<br>An example is <b>pc != $1234</b> to avoid breaking for this exception at the given PC.<br>Click the question mark (?) in this tab's toolbar at the top right for more examples.</html>");
                    } else if (n2 == 4) {
                        jComponent.setToolTipText("<html>" + (!object.toString().isEmpty() ? String.valueOf(object.toString().replace("<", "&lt;")) + "<br /><br />" : "") + "Here you can specify the message to print using arbitrary expressions as described in the Expressions Help dialog.<br>You can use commas to concatenate strings.<br>An example is the following:<br><b>\"The register HL held the value \",hl,\" when an invalid access was made.\"</b><br>Click the question mark (?) in this tab's toolbar at the top right for more examples.</html>");
                    } else {
                        jComponent.setToolTipText(object.toString());
                    }
                }
                component.setEnabled(jTable.isEnabled() && (n2 != 4 || bl3));
                return component;
            }
        });
        jTable.setDefaultRenderer(Boolean.class, new TableCellRenderer(jTable){
            private final TableCellRenderer defaultBooleanRenderer;
            {
                this.defaultBooleanRenderer = jTable.getDefaultRenderer(Boolean.class);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                boolean bl3;
                Component component = this.defaultBooleanRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                boolean bl4 = bl3 = n >= jTable.getRowCount() - 1 || (Boolean)jTable.getValueAt(n, 0) != false;
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setToolTipText(null);
                    if (n < jTable.getRowCount() - 1) {
                        if (!bl3) {
                            jComponent.setToolTipText("<html>This exception breakpoint is disabled.<br />Disabled exception breakpoints are ignored completely.<br />You can use the left-most checkbox to enable it.</html>");
                        } else if (n2 == 0) {
                            jComponent.setToolTipText("<html>This exception breakpoint is enabled.<br>Enabled breakpoints always log to the Console.<br>You can make this exception breakpoint only log to Console by unchecking the checkbox in the Suspend column.</html>");
                        } else if (n2 == 1) {
                            jComponent.setToolTipText("<html>This exception breakpoint is set to " + ((Boolean)object != false ? "suspend." : "<b>not</b> suspend. So it will only log to Console.") + "<br>Enabled exception breakpoints always log to the Console but only suspend execution if this checkbox is checked.</html>");
                        } else {
                            jComponent.setToolTipText(object.toString());
                        }
                    }
                }
                component.setEnabled(jTable.isEnabled() && (n2 != 1 || bl3));
                return component;
            }
        });
        ((DefaultCellEditor)jTable.getDefaultEditor(Object.class)).setClickCountToStart(1);
        jTable.setSurrendersFocusOnKeystroke(true);
        BreakpointWindow.updateErrorBreakpoints(debugger);
        jTable.setPreferredScrollableViewportSize(new Dimension(jTable.getPreferredScrollableViewportSize().width, jTable.getRowHeight() * Math.min(8, jTable.getRowCount())));
        return jTable;
    }

    static String[] getAllExceptionBreakpointDescriptions() {
        String[] stringArray = new String[exceptionsModel.getRowCount()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = BreakpointWindow.exceptionsModel.getDescription(n);
            ++n;
        }
        return stringArray;
    }

    static String[] getExceptionDescriptions() {
        return EXCEPTION_DESCRIPTIONS;
    }

    static int[] getErrorBreakpointMapping() {
        return exceptionsModel.getErrorBreakpointMapping();
    }

    static boolean isExceptionBreakpointEnabled(int n) {
        return exceptionsModel.isEnabled(n);
    }

    static void setExceptionBreakpointSuspend(int n, boolean bl) {
        if (bl) {
            exceptionsModel.setEnabled(n, true);
        }
        exceptionsModel.setSuspend(n, bl);
    }

    private static void updateErrorBreakpoints(Debugger debugger) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < debugger.getNumberOfErrorCodes()) {
            String string = debugger.getErrorBreakpointLabel(n);
            if (string != null) {
                arrayList.add(n);
            }
            ++n;
        }
        int[] nArray = new int[arrayList.size()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = (Integer)arrayList.get(n2);
            ++n2;
        }
        if (exceptionsModel != null) {
            exceptionsModel.setErrorBreakpointMapping(nArray);
        }
    }

    static void updateBreakpointProperties(final Debugger debugger, JPanel jPanel, int n) {
        Breakpoint breakpoint = BreakpointWindow.getBreakpointAt(debugger, n);
        jPanel.removeAll();
        if (breakpoint instanceof Watchpoint) {
            final Watchpoint watchpoint = (Watchpoint)breakpoint;
            final JCheckBox jCheckBox = new JCheckBox("Write", watchpoint.isWrite());
            jCheckBox.setOpaque(false);
            jCheckBox.setForeground(null);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    debugger.setWatchpointWrite(watchpoint, jCheckBox.isSelected());
                }
            });
            jPanel.add(jCheckBox);
            final JCheckBox jCheckBox2 = new JCheckBox("Read", watchpoint.isRead());
            jCheckBox2.setOpaque(false);
            jCheckBox2.setForeground(null);
            jCheckBox2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    debugger.setWatchpointRead(watchpoint, jCheckBox2.isSelected());
                }
            });
            jPanel.add(jCheckBox2);
        }
        jPanel.revalidate();
        jPanel.repaint();
    }

    static Breakpoint getBreakpointAt(Debugger debugger, int n) {
        if (n < 0 || n >= debugger.getBreakpoints().size()) {
            return null;
        }
        return debugger.getBreakpoints().get(n);
    }

    @Override
    public void breakpointHit(Breakpoint breakpoint, int n, int n2, String string) {
        if (n2 >= 0) {
            this.console.append(String.valueOf(this.debugger.cpuAddressToString(n2)) + ": " + string + "\n");
        } else {
            this.console.append(String.valueOf(string) + "\n");
        }
        this.table.repaint();
    }

    @Override
    public void breakpointHitCleared() {
        this.table.repaint();
    }

    @Override
    public void breakpointsCleared() {
    }

    @Override
    public void breakpointAdded(Breakpoint breakpoint) {
    }

    @Override
    public void breakpointChanged(Breakpoint breakpoint) {
    }

    @Override
    public void breakpointRemoved(Breakpoint breakpoint, int n, boolean bl) {
    }

    private void selectBreakpoint(Breakpoint breakpoint) {
        if (breakpoint == null) {
            this.table.getSelectionModel().setSelectionInterval(-1, -1);
            return;
        }
        int n = 0;
        for (Breakpoint breakpoint2 : this.debugger.getBreakpoints()) {
            if (breakpoint2 == breakpoint) {
                this.table.getSelectionModel().setSelectionInterval(n, n);
                this.scrollRowToVisible(n);
                break;
            }
            ++n;
        }
    }

    private boolean scrollRowToVisible(int n) {
        Rectangle rectangle = this.table.getCellRect(n, 0, true);
        Rectangle rectangle2 = this.table.getVisibleRect();
        rectangle.x = rectangle2.x;
        rectangle.width = rectangle2.width;
        rectangle.height = rectangle2.height / 2;
        rectangle.y -= rectangle.height / 2;
        this.table.scrollRectToVisible(rectangle);
        return this.table.getVisibleRect().y != rectangle2.y;
    }

    public static void registerBreakpointListener(SystemDebugger systemDebugger) {
        if (breakpointWindow != null) {
            systemDebugger.addBreakpointListener(breakpointWindow);
        }
        if (model != null) {
            systemDebugger.addBreakpointListener(model);
        }
    }

    public static void unregisterBreakpointListener(SystemDebugger systemDebugger) {
        if (breakpointWindow != null) {
            systemDebugger.removeBreakpointListener(breakpointWindow);
        }
        if (model != null) {
            systemDebugger.removeBreakpointListener(model);
        }
    }

    public static void open(Window window, Debugger debugger, Breakpoint breakpoint, boolean bl) {
        if (breakpointWindow == null) {
            breakpointWindow = new BreakpointWindow(window, debugger, Emulicious.isUseFrames());
            breakpointWindow.setVisible(true);
        } else if (!bl) {
            breakpointWindow.setVisible(true);
        }
        breakpointWindow.selectBreakpoint(breakpoint);
    }

    public static void updateModel(Debugger debugger) {
        BreakpointWindow.updateErrorBreakpoints(debugger);
        if (breakpointWindow != null) {
            BreakpointWindow.breakpointWindow.exceptionsTable.setPreferredScrollableViewportSize(new Dimension(BreakpointWindow.breakpointWindow.exceptionsTable.getPreferredSize().width, BreakpointWindow.breakpointWindow.exceptionsTable.getRowHeight() * Math.min(8, BreakpointWindow.breakpointWindow.exceptionsTable.getRowCount())));
        }
    }

    public static void close() {
        if (breakpointWindow != null) {
            Emulicious.getProperties().setProperty("Window" + breakpointWindow.getClass().getSimpleName() + "Open", "" + breakpointWindow.isVisible());
            Emulicious.getProperties().setProperty("Window" + breakpointWindow.getClass().getSimpleName() + "X", "" + breakpointWindow.getX());
            Emulicious.getProperties().setProperty("Window" + breakpointWindow.getClass().getSimpleName() + "Y", "" + breakpointWindow.getY());
            Emulicious.getProperties().setProperty("Window" + breakpointWindow.getClass().getSimpleName() + "Width", "" + breakpointWindow.getWidth());
            Emulicious.getProperties().setProperty("Window" + breakpointWindow.getClass().getSimpleName() + "Height", "" + breakpointWindow.getHeight());
            breakpointWindow.dispose();
            breakpointWindow = null;
        }
        model = null;
        exceptionsModel = null;
    }

    static class BreakpointTableModel
    extends DefaultTableModel
    implements SystemDebugger.BreakpointListener {
        private final Debugger debugger;
        private int removedIndex = -1;
        private String[] errors = new String[0];

        BreakpointTableModel(Debugger debugger) {
            super(new Object[]{"", "Suspend", "Address", "Condition", "Message", "Description"}, 0);
            this.debugger = debugger;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n == this.getRowCount() - 1) {
                return n2 == 2;
            }
            if (BreakpointWindow.getBreakpointAt(this.debugger, n) instanceof InvalidBreakpoint) {
                return n2 == 2;
            }
            return n2 <= 4;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void setValueAt(Object var1_1, int var2_2, int var3_3) {
            var4_4 = BreakpointWindow.getBreakpointAt(this.debugger, var2_2);
            switch (var3_3) {
                case 0: {
                    if (var4_4 == null) break;
                    this.debugger.setBreakpointEnabled(var4_4, (Boolean)var1_1);
                    break;
                }
                case 1: {
                    if (var4_4 == null) break;
                    this.debugger.setBreakpointSuspend(var4_4, (Boolean)var1_1);
                    break;
                }
                case 2: {
                    if (var1_1.toString().isEmpty()) {
                        this.debugger.removeBreakpoint(var4_4);
                        break;
                    }
                    var5_5 = var1_1.toString().split("\\.\\.");
                    var6_6 = false;
                    try {
                        Long.parseLong(var5_5[0].substring(1), 16);
                        var6_6 = true;
                    }
                    catch (NumberFormatException v0) {}
                    var7_7 = var6_6 != false && var5_5[0].charAt(0) == 'p';
                    var8_8 = var6_6 != false && var5_5[0].charAt(0) == '0';
                    var9_9 = var6_6 != false && var5_5[0].charAt(0) == 'v';
                    var10_10 = var6_6 != false && var5_5[0].charAt(0) == 's';
                    var11_11 = var6_6 != false && var5_5[0].charAt(0) == '$';
                    var12_12 = -1;
                    var13_13 = -1;
                    if (var6_6) {
                        if (var8_8) {
                            var5_5[0] = var5_5[0].substring(1);
                            if (var5_5.length > 1 && var5_5[1].length() > 1 && var5_5[1].charAt(0) == '0') {
                                var5_5[1] = var5_5[1].substring(1);
                            }
                        }
                        if (var7_7) {
                            var5_5[0] = var5_5[0].replaceAll("p", "");
                            if (var5_5.length > 1) {
                                var5_5[1] = var5_5[1].replaceAll("p", "");
                            }
                        }
                        if (var9_9) {
                            var5_5[0] = var5_5[0].replaceAll("v", "");
                            if (var5_5.length > 1) {
                                var5_5[1] = var5_5[1].replaceAll("v", "");
                            }
                        }
                        if (var10_10) {
                            var5_5[0] = var5_5[0].replaceAll("s", "");
                            if (var5_5.length > 1) {
                                var5_5[1] = var5_5[1].replaceAll("s", "");
                            }
                        }
                        if (var11_11) {
                            var5_5[0] = var5_5[0].replaceAll("\\$", "");
                            if (var5_5.length > 1) {
                                var5_5[1] = var5_5[1].replaceAll("\\$", "");
                            }
                        }
                    }
                    try {
                        var14_14 = Long.parseLong(var5_5[0], 16);
                        var12_12 = var14_14 < 0L || var14_14 > 0x7FFFFFFFL ? 0x7FFFFFFF : (int)var14_14;
                    }
                    catch (NumberFormatException v1) {
                        var14_15 = var5_5[0].split(":");
                        if (var14_15.length != 2) ** GOTO lbl67
                        try {
                            var15_23 = Long.parseLong(var14_15[0].trim(), 16);
                            var17_25 = Long.parseLong(var14_15[1].trim(), 16);
                            var19_26 = var15_23 < 0L || var15_23 > 0x7FFFFFFFL ? 0x7FFFFFFF : (int)var15_23;
                            var20_27 = var17_25 < 0L || var17_25 > 0x7FFFFFFFL ? 0x7FFFFFFF : (int)var17_25;
                            var5_5[0] = "$" + Integer.toHexString(var19_26).toUpperCase() + ":$" + Integer.toHexString(var20_27).toUpperCase();
                        }
                        catch (NumberFormatException v2) {}
                    }
lbl67:
                    // 4 sources

                    if (var5_5.length > 1) {
                        var14_16 = this.debugger.getSymbols().get(var5_5[1]);
                        v3 = var15_24 = var14_16 != null ? var14_16.get(0) : null;
                        if (var15_24 == null) {
                            try {
                                var13_13 = (int)(Long.parseLong(var5_5[1], 16) & 0x7FFFFFFFL);
                            }
                            catch (NumberFormatException v4) {}
                        } else {
                            var13_13 = this.debugger.getSymbolAddress(var15_24);
                        }
                    }
                    if (var12_12 >= 0) {
                        if (var4_4 != null && !(var4_4 instanceof InvalidBreakpoint)) {
                            if ((!this.debugger.isMemoryLocationBreakpoint(var4_4) || var7_7 || var9_9 || var10_10 || var8_8) && (var7_7 ^ this.debugger.isPortBreakpoint(var4_4) || var9_9 ^ this.debugger.isVRAMbreakpoint(var4_4) || var10_10 ^ this.debugger.isSRAMbreakpoint(var4_4) || var8_8 ^ this.debugger.isROMbreakpoint(var4_4))) {
                                if (var2_2 < this.errors.length) {
                                    this.errors[var2_2] = null;
                                }
                                var14_17 = this.debugger.removeBreakpoint(var4_4);
                                if (var7_7) {
                                    var4_4 = this.debugger.addPortBreakpoint(var14_17, var12_12, var13_13);
                                    break;
                                }
                                if (var9_9) {
                                    var4_4 = this.debugger.addVRAMbreakpoint(var14_17, var12_12, var13_13);
                                    break;
                                }
                                if (var10_10) {
                                    var4_4 = this.debugger.addSRAMbreakpoint(var14_17, var12_12, var13_13);
                                    break;
                                }
                                if (var8_8) {
                                    var4_4 = this.debugger.addROMbreakpoint(var14_17, var12_12, var13_13);
                                    break;
                                }
                                var4_4 = this.debugger.addBreakpoint(var14_17, var12_12, var13_13);
                                break;
                            }
                            var4_4 = this.debugger.setBreakpointAddress(var4_4, var5_5[0], var5_5.length > 1 ? var5_5[1] : "-1");
                            break;
                        }
                        if (var7_7) {
                            var4_4 = this.debugger.addPortBreakpoint(var12_12, var13_13);
                            break;
                        }
                        if (var9_9) {
                            var4_4 = this.debugger.addVRAMbreakpoint(var12_12, var13_13);
                            break;
                        }
                        if (var10_10) {
                            var4_4 = this.debugger.addSRAMbreakpoint(var12_12, var13_13);
                            break;
                        }
                        if (var8_8) {
                            var4_4 = this.debugger.addROMbreakpoint(var12_12, var13_13);
                            break;
                        }
                        if (var4_4 instanceof InvalidBreakpoint) {
                            var4_4 = this.debugger.recreateInvalidBreakpoint((InvalidBreakpoint)var4_4, var12_12, var13_13);
                            break;
                        }
                        var4_4 = this.debugger.addBreakpoint(var12_12, var13_13);
                        break;
                    }
                    if (var4_4 instanceof InvalidBreakpoint) {
                        var4_4 = this.debugger.recreateInvalidBreakpoint((InvalidBreakpoint)var4_4, var5_5[0], var5_5.length > 1 ? var5_5[1] : "-1");
                        break;
                    }
                    if (var4_4 != null) {
                        var4_4 = this.debugger.setBreakpointAddress(var4_4, var5_5[0], var5_5.length > 1 ? var5_5[1] : "-1");
                        break;
                    }
                    var4_4 = this.debugger.addBreakpoint(var5_5[0], var5_5.length > 1 ? var5_5[1] : "-1");
                    break;
                }
                case 3: {
                    if (var2_2 < this.errors.length) {
                        this.errors[var2_2] = null;
                        this.fireTableRowsUpdated(var2_2, var2_2);
                    }
                    if (var4_4 == null) break;
                    try {
                        this.debugger.setBreakpointCondition(var4_4, var1_1.toString());
                    }
                    catch (ParseException var14_18) {
                        if (this.errors.length <= var2_2) {
                            this.errors = Arrays.copyOf(this.errors, var2_2 + 1);
                        }
                        this.errors[var2_2] = var14_18.getMessage();
                        this.fireTableRowsUpdated(var2_2, var2_2);
                    }
                    catch (UnknownVariableException var14_19) {
                        if (this.errors.length <= var2_2) {
                            this.errors = Arrays.copyOf(this.errors, var2_2 + 1);
                        }
                        this.errors[var2_2] = var14_19.getMessage();
                        this.fireTableRowsUpdated(var2_2, var2_2);
                    }
                    catch (IsConstantException var14_20) {
                        if (this.errors.length <= var2_2) {
                            this.errors = Arrays.copyOf(this.errors, var2_2 + 1);
                        }
                        this.errors[var2_2] = var14_20.getMessage();
                        this.fireTableRowsUpdated(var2_2, var2_2);
                    }
                    break;
                }
                case 4: {
                    if (var2_2 < this.errors.length) {
                        this.errors[var2_2] = null;
                        this.fireTableRowsUpdated(var2_2, var2_2);
                    }
                    if (var4_4 == null) break;
                    try {
                        this.debugger.setBreakpointMessage(var4_4, var1_1.toString());
                        break;
                    }
                    catch (ParseException var14_21) {
                        if (this.errors.length <= var2_2) {
                            this.errors = Arrays.copyOf(this.errors, var2_2 + 1);
                        }
                        this.errors[var2_2] = var14_21.getMessage();
                        this.fireTableRowsUpdated(var2_2, var2_2);
                        break;
                    }
                    catch (UnknownVariableException var14_22) {
                        if (this.errors.length <= var2_2) {
                            this.errors = Arrays.copyOf(this.errors, var2_2 + 1);
                        }
                        this.errors[var2_2] = var14_22.getMessage();
                        this.fireTableRowsUpdated(var2_2, var2_2);
                    }
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Breakpoint breakpoint;
            if (n < this.getRowCount() - 1 && (breakpoint = BreakpointWindow.getBreakpointAt(this.debugger, n)) != null) {
                switch (n2) {
                    case 0: {
                        return breakpoint.isEnabled();
                    }
                    case 1: {
                        return breakpoint.isSuspend();
                    }
                    case 2: {
                        if (breakpoint.getEnd() > breakpoint.getAddress()) {
                            try {
                                Long.parseLong(breakpoint.getAddressString(), 16);
                                Long.parseLong(breakpoint.getEndString(), 16);
                                if (this.debugger.isPortBreakpoint(breakpoint)) {
                                    return String.format("p%s..p%s", breakpoint.getAddressString(), breakpoint.getEndString());
                                }
                                if (this.debugger.isROMbreakpoint(breakpoint)) {
                                    return String.format("0%s..0%s", breakpoint.getAddressString(), breakpoint.getEndString());
                                }
                                if (this.debugger.isVRAMbreakpoint(breakpoint)) {
                                    return String.format("v%s..v%s", breakpoint.getAddressString(), breakpoint.getEndString());
                                }
                                if (this.debugger.isSRAMbreakpoint(breakpoint)) {
                                    return String.format("s%s..s%s", breakpoint.getAddressString(), breakpoint.getEndString());
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                            return String.format("%s..%s", breakpoint.getAddressString(), breakpoint.getEndString());
                        }
                        try {
                            Long.parseLong(breakpoint.getAddressString(), 16);
                            if (this.debugger.isPortBreakpoint(breakpoint)) {
                                return String.format("p%s", breakpoint.getAddressString());
                            }
                            if (this.debugger.isROMbreakpoint(breakpoint)) {
                                return String.format("0%s", breakpoint.getAddressString());
                            }
                            if (this.debugger.isVRAMbreakpoint(breakpoint)) {
                                return String.format("v%s", breakpoint.getAddressString());
                            }
                            if (this.debugger.isSRAMbreakpoint(breakpoint)) {
                                return String.format("s%s", breakpoint.getAddressString());
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                        return breakpoint.getAddressString();
                    }
                    case 3: {
                        return breakpoint.getCondition();
                    }
                    case 4: {
                        return breakpoint.getMessage();
                    }
                    case 5: {
                        String string;
                        String string2 = string = breakpoint.isEnabled() ? "" : "Disabled ";
                        if (n < this.errors.length && this.errors[n] != null) {
                            return this.errors[n];
                        }
                        if (breakpoint instanceof InvalidBreakpoint) {
                            return ((InvalidBreakpoint)breakpoint).getCause().getMessage();
                        }
                        if (breakpoint instanceof Watchpoint) {
                            Watchpoint watchpoint = (Watchpoint)breakpoint;
                            return String.valueOf(string) + this.debugger.locationToString(breakpoint).toUpperCase() + " Watchpoint:" + (watchpoint.isRead() ? " Read" : "") + (watchpoint.isRead() && watchpoint.isWrite() ? " and" : "") + (watchpoint.isWrite() ? " Write" : "");
                        }
                        return String.valueOf(string) + "Line Breakpoint: " + this.debugger.getLine(breakpoint.getAddress());
                    }
                }
            }
            return n2 <= 1 ? Boolean.FALSE : "";
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n <= 1) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public int getRowCount() {
            return this.debugger != null ? this.debugger.getNumberOfBreakpoints() + 1 : 0;
        }

        public boolean hasError(int n) {
            return n < this.errors.length && this.errors[n] != null || BreakpointWindow.getBreakpointAt(this.debugger, n) instanceof InvalidBreakpoint;
        }

        @Override
        public void breakpointHit(Breakpoint breakpoint, int n, int n2, String string) {
        }

        @Override
        public void breakpointHitCleared() {
        }

        @Override
        public void breakpointsCleared() {
            this.fireTableDataChanged();
        }

        @Override
        public void breakpointAdded(Breakpoint breakpoint) {
            int n = this.indexOf(breakpoint);
            if (n >= 0) {
                if (n == this.removedIndex) {
                    this.fireTableRowsUpdated(n, n);
                } else {
                    this.fireTableRowsInserted(n, n);
                }
            }
            this.removedIndex = -1;
        }

        @Override
        public void breakpointChanged(Breakpoint breakpoint) {
            int n = this.indexOf(breakpoint);
            if (n >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
        }

        @Override
        public void breakpointRemoved(Breakpoint breakpoint, int n, boolean bl) {
            if (bl) {
                this.removedIndex = n;
            } else {
                this.removedIndex = -1;
                this.fireTableRowsDeleted(n, n);
            }
            if (n < this.errors.length) {
                this.errors[n] = null;
            }
        }

        private int indexOf(Breakpoint breakpoint) {
            return this.debugger.getBreakpoints().indexOf(breakpoint);
        }
    }

    static class ExceptionsTableModel
    extends DefaultTableModel {
        private final Debugger debugger;
        private int[] errorBreakpoints = new int[0];

        ExceptionsTableModel(Debugger debugger) {
            super(new Object[]{"", "Suspend", "Description", "Condition", "Message"}, 0);
            this.debugger = debugger;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    this.setEnabled(n, (Boolean)object);
                    break;
                }
                case 1: {
                    this.setSuspend(n, (Boolean)object);
                    break;
                }
                case 3: {
                    this.setCondition(n, object.toString());
                    break;
                }
                case 4: {
                    this.setMessage(n, object.toString());
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.isEnabled(n);
                }
                case 1: {
                    return this.isSuspend(n);
                }
                case 2: {
                    return this.getDescription(n);
                }
                case 3: {
                    return this.getCondition(n);
                }
                case 4: {
                    return this.getMessage(n);
                }
            }
            return null;
        }

        protected boolean isEnabled(int n) {
            switch (n) {
                case 0: {
                    return this.debugger.isInterruptBreakpointEnabled();
                }
                case 1: {
                    return this.debugger.isUninitializedMemoryBreakpointEnabled();
                }
                case 2: {
                    return this.debugger.isDataExecutionBreakpointEnabled();
                }
                case 3: {
                    return this.debugger.isBankSwapAtPCBreakpointEnabled();
                }
                case 4: {
                    return this.debugger.isStackRomWriteBreakpointEnabled();
                }
            }
            return this.debugger.isErrorBreakpointEnabled(this.errorBreakpoints[n - EXCEPTION_DESCRIPTIONS.length]);
        }

        protected void setEnabled(int n, boolean bl) {
            switch (n) {
                case 0: {
                    this.debugger.setInterruptBreakpointEnabled(bl);
                    break;
                }
                case 1: {
                    this.debugger.setUninitializedMemoryBreakpointEnabled(bl);
                    break;
                }
                case 2: {
                    this.debugger.setDataExecutionBreakpointEnabled(bl);
                    break;
                }
                case 3: {
                    this.debugger.setBankSwapAtPCBreakpointEnabled(bl);
                    break;
                }
                case 4: {
                    this.debugger.setStackRomWriteBreakpointEnabled(bl);
                    break;
                }
                default: {
                    this.debugger.setErrorBreakpointEnabled(this.errorBreakpoints[n - EXCEPTION_DESCRIPTIONS.length], bl);
                }
            }
            this.fireTableRowsUpdated(n, n);
        }

        private boolean isSuspend(int n) {
            switch (n) {
                case 0: {
                    return this.debugger.isInterruptBreakpointSuspend();
                }
                case 1: {
                    return this.debugger.isUninitializedMemoryBreakpointSuspend();
                }
                case 2: {
                    return this.debugger.isDataExecutionBreakpointSuspend();
                }
                case 3: {
                    return this.debugger.isBankSwapAtPCBreakpointSuspend();
                }
                case 4: {
                    return this.debugger.isStackRomWriteBreakpointSuspend();
                }
            }
            return this.debugger.isErrorBreakpointSuspend(this.errorBreakpoints[n - EXCEPTION_DESCRIPTIONS.length]);
        }

        protected void setSuspend(int n, boolean bl) {
            switch (n) {
                case 0: {
                    this.debugger.setInterruptBreakpointSuspend(bl);
                    break;
                }
                case 1: {
                    this.debugger.setUninitializedMemoryBreakpointSuspend(bl);
                    break;
                }
                case 2: {
                    this.debugger.setDataExecutionBreakpointSuspend(bl);
                    break;
                }
                case 3: {
                    this.debugger.setBankSwapAtPCBreakpointSuspend(bl);
                    break;
                }
                case 4: {
                    this.debugger.setStackRomWriteBreakpointSuspend(bl);
                    break;
                }
                default: {
                    this.debugger.setErrorBreakpointSuspend(this.errorBreakpoints[n - EXCEPTION_DESCRIPTIONS.length], bl);
                }
            }
        }

        private String getDescription(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return EXCEPTION_DESCRIPTIONS[n];
                }
            }
            return this.debugger.getErrorBreakpointLabel(this.errorBreakpoints[n - EXCEPTION_DESCRIPTIONS.length]);
        }

        private String getCondition(int n) {
            switch (n) {
                case 0: {
                    return this.debugger.getInterruptBreakpointCondition();
                }
                case 1: {
                    return this.debugger.getUninitializedMemoryBreakpointCondition();
                }
                case 2: {
                    return this.debugger.getDataExecutionBreakpointCondition();
                }
                case 3: {
                    return this.debugger.getBankSwapAtPCBreakpointCondition();
                }
                case 4: {
                    return this.debugger.getStackRomWriteBreakpointCondition();
                }
            }
            return this.debugger.getErrorBreakpointCondition(this.errorBreakpoints[n - EXCEPTION_DESCRIPTIONS.length]);
        }

        private void setCondition(int n, String string) {
            switch (n) {
                case 0: {
                    this.debugger.setInterruptBreakpointCondition(string);
                    break;
                }
                case 1: {
                    this.debugger.setUninitializedMemoryBreakpointCondition(string);
                    break;
                }
                case 2: {
                    this.debugger.setDataExecutionBreakpointCondition(string);
                    break;
                }
                case 3: {
                    this.debugger.setBankSwapAtPCBreakpointCondition(string);
                    break;
                }
                case 4: {
                    this.debugger.setStackRomWriteBreakpointCondition(string);
                    break;
                }
                default: {
                    this.debugger.setErrorBreakpointCondition(this.errorBreakpoints[n - EXCEPTION_DESCRIPTIONS.length], string);
                }
            }
        }

        private String getMessage(int n) {
            switch (n) {
                case 0: {
                    return this.debugger.getInterruptBreakpointMessage();
                }
                case 1: {
                    return this.debugger.getUninitializedMemoryBreakpointMessage();
                }
                case 2: {
                    return this.debugger.getDataExecutionBreakpointMessage();
                }
                case 3: {
                    return this.debugger.getBankSwapAtPCBreakpointMessage();
                }
                case 4: {
                    return this.debugger.getStackRomWriteBreakpointMessage();
                }
            }
            return this.debugger.getErrorBreakpointMessage(this.errorBreakpoints[n - EXCEPTION_DESCRIPTIONS.length]);
        }

        private void setMessage(int n, String string) {
            switch (n) {
                case 0: {
                    this.debugger.setInterruptBreakpointMessage(string);
                    break;
                }
                case 1: {
                    this.debugger.setUninitializedMemoryBreakpointMessage(string);
                    break;
                }
                case 2: {
                    this.debugger.setDataExecutionBreakpointMessage(string);
                    break;
                }
                case 3: {
                    this.debugger.setBankSwapAtPCBreakpointMessage(string);
                    break;
                }
                case 4: {
                    this.debugger.setStackRomWriteBreakpointMessage(string);
                    break;
                }
                default: {
                    this.debugger.setErrorBreakpointMessage(this.errorBreakpoints[n - EXCEPTION_DESCRIPTIONS.length], string);
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n <= 1) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public int getRowCount() {
            return this.debugger != null ? EXCEPTION_DESCRIPTIONS.length + this.errorBreakpoints.length : 0;
        }

        public void setErrorBreakpointMapping(int[] nArray) {
            this.errorBreakpoints = nArray;
            this.fireTableStructureChanged();
        }

        public int[] getErrorBreakpointMapping() {
            return this.errorBreakpoints;
        }
    }
}

