/*
 * Decompiled with CFR 0.152.
 */
package platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import output.SoundAmplitudeListener;

public abstract class SoundOutput {
    protected boolean soundEnabled;
    private static SourceDataLine line;
    protected final int sampleRate;
    private String deviceName;
    private int bufferSizeMillis;
    private final int channels;
    private int volume;
    private boolean audioSync;
    protected byte[] buffer;
    protected int length;
    private List<SoundAmplitudeListener> amplitudeListenerList = new LinkedList<SoundAmplitudeListener>();
    protected SoundAmplitudeListener[] amplitudeListeners = new SoundAmplitudeListener[0];

    public SoundOutput(String string, int n, int n2, int n3) {
        AudioFormat audioFormat = new AudioFormat(n, 16, n3, true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            line = SoundOutput.openLine(SoundOutput.getMixer(string), audioFormat, info, n2);
        }
        catch (LineUnavailableException lineUnavailableException) {}
        this.deviceName = string;
        this.bufferSizeMillis = n2;
        this.channels = n3;
        this.sampleRate = n;
    }

    private static SourceDataLine openLine(Mixer mixer, AudioFormat audioFormat, Line.Info info, int n) throws LineUnavailableException {
        if (line != null) {
            line.close();
        }
        if (mixer != null && mixer.isLineSupported(info) || AudioSystem.isLineSupported(info)) {
            SourceDataLine sourceDataLine = (SourceDataLine)(mixer != null && mixer.isLineSupported(info) ? mixer.getLine(info) : AudioSystem.getLine(info));
            sourceDataLine.open(audioFormat, n * audioFormat.getChannels() * (audioFormat.getSampleSizeInBits() / 8) * (int)audioFormat.getSampleRate() / 1000);
            sourceDataLine.start();
            return sourceDataLine;
        }
        return null;
    }

    public void setSoundEnabled(boolean bl) {
        boolean bl2 = this.soundEnabled = line != null && bl;
        if (line != null) {
            if (bl) {
                line.start();
            } else {
                line.stop();
                line.flush();
            }
        }
    }

    public boolean setDevice(String string) {
        try {
            if (line != null) {
                line = SoundOutput.openLine(SoundOutput.getMixer(string), line.getFormat(), line.getLineInfo(), this.bufferSizeMillis);
                return true;
            }
        }
        catch (LineUnavailableException lineUnavailableException) {}
        return false;
    }

    public boolean setBufferSizeMillis(int n) {
        try {
            if (line != null) {
                line = SoundOutput.openLine(SoundOutput.getMixer(this.deviceName), line.getFormat(), line.getLineInfo(), n);
                return true;
            }
        }
        catch (LineUnavailableException lineUnavailableException) {}
        return false;
    }

    protected int getBufferSize() {
        return line != null ? line.getBufferSize() : 0;
    }

    private static Mixer getMixer(String string) {
        if (string == null) {
            return null;
        }
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = infoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mixer.Info info = infoArray[n2];
            if (string.equals(info.getName())) {
                return AudioSystem.getMixer(info);
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getDeviceNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = infoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mixer.Info info = infoArray[n2];
            Mixer mixer = AudioSystem.getMixer(info);
            Line.Info[] infoArray2 = mixer.getSourceLineInfo();
            int n3 = infoArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Line.Info info2 = infoArray2[n4];
                try {
                    Line line = mixer.getLine(info2);
                    if (line instanceof SourceDataLine) {
                        arrayList.add(info.getName());
                    }
                }
                catch (LineUnavailableException lineUnavailableException) {}
                ++n4;
            }
            ++n2;
        }
        return arrayList;
    }

    public abstract String[] getChannelNames();

    public abstract int[] getChannelMinValues();

    public abstract int[] getChannelMaxValues();

    public abstract void setChannelMuted(int var1, boolean var2);

    public void setVolume(int n) {
        this.volume = n;
    }

    public void setAudioSync(boolean bl) {
        this.audioSync = bl;
        if (bl) {
            this.updateCyclesPerSample(100);
        }
    }

    public void setThrottle(int n) {
        this.updateCyclesPerSample(!this.audioSync ? n : 100);
    }

    protected abstract void updateCyclesPerSample(int var1);

    public synchronized void stop() {
        if (line != null) {
            line.stop();
            line.flush();
        }
    }

    public synchronized void start() {
        if (line != null) {
            line.start();
        }
    }

    private void fillBuffer() {
        if (this.soundEnabled) {
            byte[] byArray = new byte[line.available()];
            line.write(byArray, 0, byArray.length);
        }
    }

    protected void writeSample16bit(int n) {
        if ((n = n * this.volume / 100) > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        } else if (n < Short.MIN_VALUE) {
            n = Short.MIN_VALUE;
        }
        if (this.length < this.buffer.length) {
            this.buffer[this.length++] = (byte)(n & 0xFF);
            this.buffer[this.length++] = (byte)(n >> 8);
        }
    }

    public void writeWav(File file, File file2) throws IOException {
        this.writeFile(file, file2, AudioFileFormat.Type.WAVE);
    }

    public void writeAiff(File file, File file2) throws IOException {
        this.writeFile(file, file2, AudioFileFormat.Type.AIFF);
    }

    private void writeFile(File file, File file2, AudioFileFormat.Type type) throws IOException {
        AudioInputStream audioInputStream = new AudioInputStream(new FileInputStream(file), new AudioFormat(this.sampleRate, 16, this.channels, true, false), file.length());
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        AudioSystem.write(audioInputStream, type, fileOutputStream);
        audioInputStream.close();
        fileOutputStream.close();
    }

    protected synchronized void play() {
        if (!this.soundEnabled) {
            return;
        }
        int n = line.available();
        line.write(this.buffer, 0, this.audioSync ? this.length : Math.min(this.length, n));
        if (n == line.getBufferSize()) {
            this.fillBuffer();
        }
        this.length = 0;
    }

    public void addAmplitudeListener(SoundAmplitudeListener soundAmplitudeListener) {
        if (!this.amplitudeListenerList.contains(soundAmplitudeListener)) {
            this.amplitudeListenerList.add(soundAmplitudeListener);
            this.amplitudeListeners = this.amplitudeListenerList.toArray(new SoundAmplitudeListener[this.amplitudeListenerList.size()]);
        }
    }

    public void removeAmplitudeListener(SoundAmplitudeListener soundAmplitudeListener) {
        if (this.amplitudeListenerList.remove(soundAmplitudeListener)) {
            this.amplitudeListeners = this.amplitudeListenerList.toArray(new SoundAmplitudeListener[this.amplitudeListenerList.size()]);
        }
    }

    protected final void fireBoundsChanged() {
        SoundAmplitudeListener[] soundAmplitudeListenerArray = this.amplitudeListeners;
        int n = this.amplitudeListeners.length;
        int n2 = 0;
        while (n2 < n) {
            SoundAmplitudeListener soundAmplitudeListener = soundAmplitudeListenerArray[n2];
            soundAmplitudeListener.boundsChanged();
            ++n2;
        }
    }

    protected final void fireAmplitude(int n, boolean bl, int n2) {
        SoundAmplitudeListener[] soundAmplitudeListenerArray = this.amplitudeListeners;
        int n3 = this.amplitudeListeners.length;
        int n4 = 0;
        while (n4 < n3) {
            SoundAmplitudeListener soundAmplitudeListener = soundAmplitudeListenerArray[n4];
            soundAmplitudeListener.amplitude(n, bl, n2);
            ++n4;
        }
    }
}

