/*
 * Decompiled with CFR 0.152.
 */
package platform;

import common.UpdatableApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import platform.Emulicious;

public class CheckUpdatesDialog
extends JDialog {
    public static final int UPDATE_NEVERCHECK = 0;
    public static final int UPDATE_AUTOCHECK = 1;
    public static final int UPDATE_AUTOINSTALL = 2;
    private int result;
    private final JRadioButton autoInstall = new JRadioButton("Install updates automatically");
    private final JRadioButton autoCheck = new JRadioButton("Check for updates but let me decide whether to install them");
    private final JRadioButton neverCheck = new JRadioButton("Never check for updates");
    private final JLabel updateStatus = new JLabel("Update Status: Unknown");
    private final JButton checkForUpdates = new JButton("Check for updates");
    private final JButton updateNow = new JButton("Update now");
    private final JPanel northNorth = new JPanel();

    public CheckUpdatesDialog(UpdatableApplication updatableApplication, JFrame jFrame) {
        this(updatableApplication, jFrame, -1);
    }

    public CheckUpdatesDialog(final UpdatableApplication updatableApplication, JFrame jFrame, int n) {
        super(jFrame, String.valueOf(updatableApplication.getApplicationTitle()) + " - Update Behaviour", true);
        final JRadioButton jRadioButton = this.autoInstall;
        final JRadioButton jRadioButton2 = this.autoCheck;
        final JLabel jLabel = this.updateStatus;
        final JButton jButton = this.checkForUpdates;
        final JButton jButton2 = this.updateNow;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)jPanel, "North");
        jPanel.add((Component)this.northNorth, "North");
        this.northNorth.add(jButton);
        this.northNorth.add(jButton2);
        jButton2.setVisible(false);
        jPanel.add((Component)jLabel, "Center");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (updatableApplication.isUpdateAvailable()) {
                        jLabel.setText("Update Status: An update is available");
                        if (Emulicious.canUpdate()) {
                            jButton.setVisible(false);
                            jButton2.setVisible(true);
                        }
                    } else {
                        jLabel.setText("Update Status: " + updatableApplication.getApplicationTitle() + " is up to date.");
                    }
                }
                catch (Exception exception) {
                    jLabel.setText("Couldn't check for updates:\n" + exception.getMessage());
                }
                CheckUpdatesDialog.this.pack();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                updatableApplication.checkUpdates(true, false);
            }
        });
        JButton jButton3 = new JButton("OK");
        JButton jButton4 = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckUpdatesDialog.this.dispose();
            }
        });
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", jButton4.getAction());
        this.setDefaultCloseOperation(2);
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(this.neverCheck);
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        jPanel2.add(this.neverCheck);
        if (Emulicious.canUpdate()) {
            this.add((Component)jPanel2, "Center");
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton3);
        jPanel3.add(jButton4);
        this.add((Component)jPanel3, "South");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButton.isSelected()) {
                    CheckUpdatesDialog.this.result = 2;
                } else if (jRadioButton2.isSelected()) {
                    CheckUpdatesDialog.this.result = 1;
                } else {
                    CheckUpdatesDialog.this.result = 0;
                }
                CheckUpdatesDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(jButton3);
        this.result = n;
        jRadioButton.setSelected(false);
        jRadioButton2.setSelected(false);
        this.neverCheck.setSelected(false);
        switch (n) {
            case 2: {
                jRadioButton.setSelected(true);
                break;
            }
            case 1: {
                jRadioButton2.setSelected(true);
                break;
            }
            case 0: {
                this.neverCheck.setSelected(true);
                break;
            }
            default: {
                jRadioButton.setSelected(true);
            }
        }
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setVisible(true);
    }

    public int getResult() {
        return this.result;
    }
}

