/*
 * Decompiled with CFR 0.152.
 */
package platform;

import cheats.Cheat;
import cheats.CheatModel;
import cheats.CheatModelListener;
import common.FontUtilities;
import common.ScreenUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import platform.Emulicious;

public class CheatsWindow {
    private static CheatsWindow cheatsWindow;
    final Window window;
    private final CheatsTableModel model = new CheatsTableModel();

    private CheatsWindow(JFrame jFrame, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Cheats");
        this.window.setIconImages(jFrame.getIconImages());
        final JTable jTable = new JTable(this.model){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                MouseEvent mouseEvent;
                if (eventObject instanceof MouseEvent && ((mouseEvent = (MouseEvent)eventObject).getModifiers() & (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 2 | 1)) != 0) {
                    return false;
                }
                return super.editCellAt(n, n2, eventObject);
            }

            @Override
            public void setFont(Font font) {
                super.setFont(FontUtilities.ensureMonospaceFont(font));
                Component component = this.getEditorComponent();
                if (component == null) {
                    component = this.getDefaultEditor(Object.class).getTableCellEditorComponent(this, null, false, 0, 0);
                }
                component.setFont(font);
            }

            @Override
            public void updateUI() {
                super.updateUI();
                int n = 0;
                int n2 = 0;
                while (n2 < this.getColumnCount()) {
                    TableColumn tableColumn = this.getColumnModel().getColumn(n2);
                    TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                    if (tableCellRenderer == null) {
                        tableCellRenderer = this.getTableHeader().getDefaultRenderer();
                    }
                    int n3 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)n2).getPreferredSize().width;
                    Dimension dimension = this.getCellRenderer(0, n2).getTableCellRendererComponent(this, n2 == 2 ? "00C000FF " : this.getValueAt(0, n2), false, false, 0, n2).getPreferredSize();
                    n = Math.max(n, dimension.height);
                    n3 = Math.max(n3, dimension.width) + this.getIntercellSpacing().width;
                    if (n2 != 1) {
                        tableColumn.setMaxWidth(Integer.MAX_VALUE);
                        tableColumn.setMinWidth(n3);
                        tableColumn.setMaxWidth(n3);
                    }
                    ++n2;
                }
                this.setRowHeight(n);
            }
        };
        ((DefaultCellEditor)jTable.getDefaultEditor(Object.class)).setClickCountToStart(1);
        jTable.setSurrendersFocusOnKeystroke(true);
        jTable.setAutoResizeMode(3);
        jTable.setFillsViewportHeight(true);
        jTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n == jTable.getRowCount() - 1 && n2 == 1 && component instanceof JLabel) {
                    ((JLabel)component).setText("Add Cheat");
                }
                return component;
            }
        });
        jTable.setDefaultEditor(Cheat.Comparator.class, new DefaultCellEditor(new JComboBox<Cheat.Comparator>(Cheat.Comparator.values())));
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 1) {
                    jTable.getSelectionModel().removeSelectionInterval(tableModelEvent.getFirstRow(), tableModelEvent.getFirstRow());
                }
            }
        });
        jTable.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        jTable.getInputMap().put(KeyStroke.getKeyStroke("BACK_SPACE"), "delete");
        jTable.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheatsWindow.this.model.removeCheats(jTable.getSelectedRows());
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createLoweredBevelBorder()));
        this.window.add(jScrollPane);
        if (cheatsWindow == null || !cheatsWindow.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(jFrame);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(jFrame);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    public static void open(JFrame jFrame, boolean bl) {
        if (cheatsWindow == null) {
            cheatsWindow = new CheatsWindow(jFrame, Emulicious.isUseFrames());
            cheatsWindow.setVisible(true);
        } else if (!bl) {
            cheatsWindow.setVisible(true);
        }
    }

    static void modelChanged() {
        if (cheatsWindow != null) {
            CheatsWindow.cheatsWindow.model.fireTableDataChanged();
            Emulicious.getCheatModel().addCheatModelListener(CheatsWindow.cheatsWindow.model);
        }
    }

    public static void close() {
        if (cheatsWindow != null) {
            Emulicious.getProperties().setProperty("Window" + cheatsWindow.getClass().getSimpleName() + "Open", "" + cheatsWindow.isVisible());
            Emulicious.getProperties().setProperty("Window" + cheatsWindow.getClass().getSimpleName() + "X", "" + cheatsWindow.getX());
            Emulicious.getProperties().setProperty("Window" + cheatsWindow.getClass().getSimpleName() + "Y", "" + cheatsWindow.getY());
            Emulicious.getProperties().setProperty("Window" + cheatsWindow.getClass().getSimpleName() + "Width", "" + cheatsWindow.getWidth());
            Emulicious.getProperties().setProperty("Window" + cheatsWindow.getClass().getSimpleName() + "Height", "" + cheatsWindow.getHeight());
            cheatsWindow.dispose();
            cheatsWindow = null;
        }
    }

    private class CheatsTableModel
    extends AbstractTableModel
    implements CheatModelListener {
        private final String[] COLUMNS = new String[]{"", "Name", "PAR Code", "Address", "Value", "Compare", "Comparator"};

        public CheatsTableModel() {
            this.getCheatModel().addCheatModelListener(this);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n < this.getCheatModel().getCheatCount() || n2 == 1 || n2 == 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CheatModel cheatModel = this.getCheatModel();
            if (n >= cheatModel.getCheatCount()) {
                return n2 == 1 ? "" : null;
            }
            Cheat cheat = cheatModel.getCheat(n);
            switch (n2) {
                case 0: {
                    return cheatModel.isActive(cheat);
                }
                case 1: {
                    return cheat.getName();
                }
                case 2: {
                    return this.toPAR(cheat);
                }
                case 3: {
                    return String.format("%04X", cheat.getAddress());
                }
                case 4: {
                    return String.format("%02X", cheat.getValue());
                }
                case 5: {
                    return cheat.getCompare() >= 0 ? String.format("%02X", cheat.getCompare()) : "";
                }
                case 6: {
                    return cheat.getComparator();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            CheatModel cheatModel = this.getCheatModel();
            if (n >= cheatModel.getCheatCount()) {
                if (n2 == 1 || n2 == 2) {
                    int n3 = n2 == 2 ? Integer.parseInt(object.toString().replaceAll("[^a-fA-F0-9]", ""), 16) : -1;
                    final int n4 = n3 >= 0 ? n3 >> 8 & 0xFFFF : 0;
                    final int n5 = n3 >= 0 ? n3 & 0xFF : 0;
                    final String string = n2 == 1 ? object.toString() : "Keep " + Integer.toHexString(n4).toUpperCase() + " at " + Integer.toHexString(n5).toUpperCase();
                    if (!string.isEmpty()) {
                        cheatModel.addCheat(new Cheat(){

                            @Override
                            public boolean isBigEndian() {
                                return false;
                            }

                            @Override
                            public int getValue() {
                                return n5;
                            }

                            @Override
                            public int getSize() {
                                return 1;
                            }

                            @Override
                            public String getName() {
                                return string;
                            }

                            @Override
                            public String getDomain() {
                                return "System Bus";
                            }

                            @Override
                            public String getDisplayType() {
                                return "h";
                            }

                            @Override
                            public int getCompare() {
                                return -1;
                            }

                            @Override
                            public Cheat.Comparator getComparator() {
                                return Cheat.Comparator.NONE;
                            }

                            @Override
                            public int getAddress() {
                                return n4;
                            }
                        });
                    }
                }
            } else {
                switch (n2) {
                    case 0: {
                        cheatModel.setActive(cheatModel.getCheat(n), (Boolean)object);
                        break;
                    }
                    case 1: {
                        if (object.toString().isEmpty()) {
                            cheatModel.removeCheat(n);
                            break;
                        }
                        cheatModel.setName(cheatModel.getCheat(n), object.toString());
                        break;
                    }
                    case 2: {
                        if (object.toString().isEmpty()) {
                            cheatModel.removeCheat(n);
                            break;
                        }
                        int n6 = Integer.parseInt(object.toString().replaceAll("[^a-fA-F0-9]", ""), 16);
                        cheatModel.setAddress(cheatModel.getCheat(n), n6 >> 8 & 0xFFFF);
                        cheatModel.setValue(cheatModel.getCheat(n), n6 & 0xFF);
                        break;
                    }
                    case 3: {
                        if (object.toString().isEmpty()) {
                            cheatModel.removeCheat(n);
                            break;
                        }
                        cheatModel.setAddress(cheatModel.getCheat(n), Integer.parseInt(object.toString().replaceAll("[^a-fA-F0-9]", ""), 16));
                        break;
                    }
                    case 4: {
                        cheatModel.setValue(cheatModel.getCheat(n), Integer.parseInt(object.toString().replaceAll("[^a-fA-F0-9]", ""), 16));
                        break;
                    }
                    case 5: {
                        if (object.toString().isEmpty()) {
                            cheatModel.setCompare(cheatModel.getCheat(n), -1);
                            break;
                        }
                        cheatModel.setCompare(cheatModel.getCheat(n), Integer.parseInt(object.toString().replaceAll("[^a-fA-F0-9]", ""), 16));
                        break;
                    }
                    case 6: {
                        cheatModel.setComparator(cheatModel.getCheat(n), (Cheat.Comparator)((Object)object));
                    }
                }
            }
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMNS[n];
        }

        @Override
        public int getColumnCount() {
            return this.COLUMNS.length;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            if (n == 6) {
                return Cheat.Comparator.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.getCheatModel().getCheatCount() + 1;
        }

        private String toPAR(Cheat cheat) {
            return String.format("00%02X %02X%02X", cheat.getAddress() >> 8, cheat.getAddress() & 0xFF, cheat.getValue());
        }

        private CheatModel getCheatModel() {
            return Emulicious.getCheatModel();
        }

        public void removeCheats(int[] nArray) {
            if (nArray != null) {
                CheatModel cheatModel = this.getCheatModel();
                int n = nArray.length - 1;
                while (n >= 0) {
                    cheatModel.removeCheat(nArray[n]);
                    --n;
                }
            }
        }

        @Override
        public void cheatAdded(Cheat cheat) {
            this.fireTableRowsInserted(this.getRowCount() - 2, this.getRowCount() - 2);
        }

        @Override
        public void cheatRemoved(int n) {
            this.fireTableRowsDeleted(n, n);
        }

        @Override
        public void cheatChanged(int n) {
            this.fireTableRowsUpdated(n, n);
        }
    }
}

