/*
 * Decompiled with CFR 0.152.
 */
package midi;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import midi.MidiCommandListener;

public final class MidiUtilities {
    private static final String[] NOTE_NAMES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private final Receiver RECEIVER = new Receiver(){

        @Override
        public void send(MidiMessage midiMessage, long l) {
            if (midiMessage instanceof ShortMessage) {
                ShortMessage shortMessage = (ShortMessage)midiMessage;
                switch (shortMessage.getCommand()) {
                    case 144: {
                        if (shortMessage.getData2() == 0) {
                            MidiUtilities.this.fireNoteOff(shortMessage.getChannel(), shortMessage.getData1());
                            break;
                        }
                        MidiUtilities.this.fireNoteOn(shortMessage.getChannel(), shortMessage.getData1(), shortMessage.getData2());
                        break;
                    }
                    case 128: {
                        MidiUtilities.this.fireNoteOff(shortMessage.getChannel(), shortMessage.getData1());
                        break;
                    }
                    case 192: {
                        MidiUtilities.this.fireProgramChange(shortMessage.getChannel(), shortMessage.getData1());
                        break;
                    }
                    case 176: {
                        MidiUtilities.this.fireControlChange(shortMessage.getChannel(), shortMessage.getData1(), shortMessage.getData2());
                        break;
                    }
                    case 240: {
                        break;
                    }
                    default: {
                        System.err.println("Unknown command " + shortMessage.getCommand());
                    }
                }
            }
        }

        @Override
        public void close() {
        }
    };
    private static MidiUtilities instance;
    private final List<MidiDevice> openDevices = new ArrayList<MidiDevice>();
    private final List<MidiCommandListener> listeners = new ArrayList<MidiCommandListener>();

    private MidiUtilities() {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        int n = infoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MidiDevice.Info info = infoArray[n2];
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
                if (midiDevice.getMaxTransmitters() != 0) {
                    midiDevice.open();
                    this.openDevices.add(midiDevice);
                    Transmitter transmitter = midiDevice.getTransmitter();
                    transmitter.setReceiver(this.RECEIVER);
                }
            }
            catch (MidiUnavailableException midiUnavailableException) {}
            ++n2;
        }
    }

    private static MidiUtilities getInstance() {
        if (instance == null) {
            instance = new MidiUtilities();
        }
        return instance;
    }

    protected void fireNoteOn(int n, int n2, int n3) {
        for (MidiCommandListener midiCommandListener : this.listeners) {
            midiCommandListener.noteOn(n, n2, n3);
        }
    }

    protected void fireNoteOff(int n, int n2) {
        for (MidiCommandListener midiCommandListener : this.listeners) {
            midiCommandListener.noteOff(n, n2);
        }
    }

    protected void fireControlChange(int n, int n2, int n3) {
        for (MidiCommandListener midiCommandListener : this.listeners) {
            midiCommandListener.controlChange(n, n2, n3);
        }
    }

    protected void fireProgramChange(int n, int n2) {
        for (MidiCommandListener midiCommandListener : this.listeners) {
            midiCommandListener.programChange(n, n2);
        }
    }

    private void _addListener(MidiCommandListener midiCommandListener) {
        if (!this.listeners.contains(midiCommandListener)) {
            this.listeners.add(midiCommandListener);
        }
    }

    private void _removeListener(MidiCommandListener midiCommandListener) {
        this.listeners.remove(midiCommandListener);
    }

    private void _close() {
        for (MidiDevice midiDevice : this.openDevices) {
            midiDevice.close();
        }
        this.openDevices.clear();
    }

    public static void addListener(MidiCommandListener midiCommandListener) {
        MidiUtilities.getInstance()._addListener(midiCommandListener);
    }

    public static void removeListener(MidiCommandListener midiCommandListener) {
        if (instance != null) {
            instance._removeListener(midiCommandListener);
        }
    }

    public static void close() {
        if (instance != null) {
            instance._close();
        }
    }

    public static String noteToString(int n) {
        return String.valueOf(NOTE_NAMES[n % NOTE_NAMES.length]) + (n / NOTE_NAMES.length - 1);
    }
}

