/*
 * Decompiled with CFR 0.152.
 */
package hexeditor;

import hexeditor.HexEditorSelectionEvent;
import hexeditor.HexEditorSelectionListener;
import hexeditor.HexEditorSelectionModel;
import javax.swing.event.EventListenerList;

public class DefaultHexEditorSelectionModel
implements HexEditorSelectionModel {
    protected EventListenerList listenerList = new EventListenerList();
    protected int firstRow = -1;
    protected int firstColumn = -1;
    protected int lastRow = -1;
    protected int lastColumn = -1;

    @Override
    public void clearSelection() {
        this.setSelection(-1, -1);
    }

    @Override
    public int getFirstSelectedRow() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        return this.firstRow;
    }

    @Override
    public int getFirstSelectedColumn() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        return this.firstColumn;
    }

    @Override
    public int getLastSelectedRow() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        return this.lastRow;
    }

    @Override
    public int getLastSelectedColumn() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        return this.lastColumn;
    }

    @Override
    public boolean isSelected(int n, int n2) {
        if (n < this.firstRow || n > this.lastRow) {
            return false;
        }
        if (n == this.firstRow && n2 < this.firstColumn) {
            return false;
        }
        return n != this.lastRow || n2 <= this.lastColumn;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.firstRow < 0 || this.firstColumn < 0 || this.lastRow < 0 || this.lastColumn < 0;
    }

    @Override
    public void setSelection(int n, int n2) {
        if (this.firstRow != n || this.firstColumn != n2 || this.lastRow != n || this.lastColumn != n2) {
            this.firstRow = n;
            this.firstColumn = n2;
            this.lastRow = n;
            this.lastColumn = n2;
            this.fireValueChanged(n, n2);
        }
    }

    @Override
    public void setSelection(int n, int n2, int n3, int n4) {
        if (this.firstRow != n || this.firstColumn != n2 || this.lastRow != n3 || this.lastColumn != n4) {
            this.firstRow = n;
            this.firstColumn = n2;
            this.lastRow = n3;
            this.lastColumn = n4;
            this.fireValueChanged(n, n2, n3, n4);
        }
    }

    @Override
    public void addHexEditorSelectionListener(HexEditorSelectionListener hexEditorSelectionListener) {
        this.listenerList.add(HexEditorSelectionListener.class, hexEditorSelectionListener);
    }

    @Override
    public void removeHexEditorSelectionListener(HexEditorSelectionListener hexEditorSelectionListener) {
        this.listenerList.remove(HexEditorSelectionListener.class, hexEditorSelectionListener);
    }

    public HexEditorSelectionListener[] getHexEditorSelectionListeners() {
        return (HexEditorSelectionListener[])this.listenerList.getListeners(HexEditorSelectionListener.class);
    }

    public void fireValueChanged(int n, int n2) {
        this.fireValueChanged(new HexEditorSelectionEvent(this, n, n2));
    }

    public void fireValueChanged(int n, int n2, int n3, int n4) {
        this.fireValueChanged(new HexEditorSelectionEvent(this, n, n2, n3, n4));
    }

    public void fireValueChanged(HexEditorSelectionEvent hexEditorSelectionEvent) {
        HexEditorSelectionListener[] hexEditorSelectionListenerArray = this.getHexEditorSelectionListeners();
        int n = hexEditorSelectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            HexEditorSelectionListener hexEditorSelectionListener = hexEditorSelectionListenerArray[n2];
            hexEditorSelectionListener.valueChanged(hexEditorSelectionEvent);
            ++n2;
        }
    }
}

