/*
 * Decompiled with CFR 0.152.
 */
package disassembler;

import assembler.rgbds.RGBDSMapFile;
import components.cartridge.Cartridge;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sdcc.CDBParser;
import sdcc.cdb.LinkerSymbolRecord;
import sdcc.cdb.Record;
import system.EmulatableSystem;
import util.map.HashMap;
import util.map.Map;

public class Symbols {
    private static final java.util.Map<File, Boolean> rgbdsMapFiles = new java.util.HashMap<File, Boolean>();

    public static List<Symbol> getRAMsymbols(Map<List<Symbol>> map) {
        if (map == null) {
            return null;
        }
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        int n = 49152;
        while (n < 65536) {
            List<Symbol> list = map.get(n);
            if (list != null) {
                for (Symbol symbol : list) {
                    if (symbol.getAddress() != n) continue;
                    arrayList.add(symbol);
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static Symbol findSymbol(int n, Map<List<Symbol>> map) {
        if (map == null) {
            return null;
        }
        List<Symbol> list = map.get(n);
        if (list == null) {
            return null;
        }
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            Symbol symbol = list.get(n2);
            if (symbol.getAddress() < 49152 && !symbol.getLabel().isEmpty()) {
                return symbol;
            }
            --n2;
        }
        return null;
    }

    public static BitSet getRomSymbolKeys(Map<List<Symbol>> map) {
        BitSet bitSet = new BitSet();
        if (map != null) {
            block0: for (Map.Entry<List<Symbol>> entry : map.entrySet()) {
                for (Symbol symbol : entry.getValue()) {
                    if (symbol.getAddress() >= 49152 || symbol.getLabel().isEmpty()) continue;
                    bitSet.set(entry.getKey());
                    continue block0;
                }
            }
        }
        return bitSet;
    }

    public static BitSet getRamSymbolKeys(Map<List<Symbol>> map) {
        BitSet bitSet = new BitSet();
        if (map != null) {
            block0: for (Map.Entry<List<Symbol>> entry : map.entrySet()) {
                for (Symbol symbol : entry.getValue()) {
                    if (symbol.getAddress() < 49152 || symbol.getAddress() >= 65536) continue;
                    bitSet.set(symbol.getAddress());
                    continue block0;
                }
            }
        }
        return bitSet;
    }

    public static List<String> findComment(int n, Map<List<Symbol>> map) {
        if (map == null) {
            return Collections.emptyList();
        }
        List<Symbol> list = map.get(n);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Symbol symbol : list) {
            if (symbol.getComment() == null || symbol.getAddress() >= 49152 || !symbol.getLabel().isEmpty()) continue;
            arrayList.add(symbol.getComment());
        }
        return arrayList;
    }

    public static List<Symbol> findSymbols(int n, Map<List<Symbol>> map) {
        if (map == null) {
            return Collections.emptyList();
        }
        List<Symbol> list = map.get(n);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        for (Symbol symbol : list) {
            if (symbol.getAddress() >= 49152 || symbol.getLabel().isEmpty()) continue;
            arrayList.add(symbol);
        }
        return arrayList;
    }

    public static List<Symbol> findRamSymbols(int n, Map<List<Symbol>> map) {
        if (map == null) {
            return Collections.emptyList();
        }
        List<Symbol> list = map.get(n);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        for (Symbol symbol : list) {
            if (symbol.getAddress() < 49152 || symbol.getLabel().isEmpty()) continue;
            arrayList.add(symbol);
        }
        return arrayList;
    }

    public static Symbol findRAMSymbol(int n, Map<List<Symbol>> map) {
        if (map == null) {
            return null;
        }
        List<Symbol> list = map.get(n);
        if (list == null) {
            return null;
        }
        for (Symbol symbol : list) {
            if (n != symbol.getAddress()) continue;
            return symbol;
        }
        return null;
    }

    public static Symbol findSymbol(int n, int n2, Cartridge cartridge, Map<List<Symbol>> map) {
        if (map == null) {
            return null;
        }
        List<Symbol> list = map.get(n >= 49152 ? n : cartridge.mapAddress(n, n2));
        if (list == null) {
            return null;
        }
        if (n >= 49152) {
            int n3 = list.size() - 1;
            while (n3 >= 0) {
                Symbol symbol = list.get(n3);
                if (n == symbol.getAddress()) {
                    return symbol;
                }
                --n3;
            }
        } else {
            int n4 = list.size() - 1;
            while (n4 >= 0) {
                Symbol symbol = list.get(n4);
                if (symbol.getAddress() < 49152 && !symbol.getLabel().isEmpty()) {
                    return symbol;
                }
                --n4;
            }
        }
        return null;
    }

    public static java.util.Map<String, List<Symbol>> getSymbolsByName(Map<List<Symbol>> map) {
        return Symbols.getSymbolsByName(map, new java.util.HashMap<String, List<Symbol>>());
    }

    public static java.util.Map<String, List<Symbol>> getSymbolsByName(Map<List<Symbol>> map, java.util.Map<String, List<Symbol>> map2) {
        if (map == null) {
            return Collections.emptyMap();
        }
        for (List<Symbol> list : map.values()) {
            for (Symbol symbol : list) {
                if (symbol.getLabel().isEmpty()) continue;
                List<Symbol> list2 = map2.get(symbol.getLabel());
                if (list2 == null) {
                    list2 = new ArrayList<Symbol>();
                    map2.put(symbol.getLabel(), list2);
                }
                list2.add(symbol);
            }
        }
        return map2;
    }

    public static Map<List<Symbol>> getSymbolsByAddress(List<Symbol> list, EmulatableSystem emulatableSystem) {
        return Symbols.getSymbolsByAddress(list, null, emulatableSystem);
    }

    public static Map<List<Symbol>> getSymbolsByAddress(List<Symbol> list, Map<List<Symbol>> map, EmulatableSystem emulatableSystem) {
        HashMap<List<Symbol>> hashMap = new HashMap<List<Symbol>>();
        for (Symbol symbol : list) {
            if (emulatableSystem.isROMaddress(symbol.getAddress(), true)) {
                int n = emulatableSystem.mapAddress(symbol.getAddress(), symbol.getBank(), true);
                ArrayList<Symbol> arrayList = (ArrayList<Symbol>)hashMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<Symbol>();
                    hashMap.put(n, arrayList);
                }
                arrayList.add(new Symbol(symbol.getBank(), symbol.getAddress() & 0xFFFF, symbol.getLabel(), symbol.getComment()));
            }
            if (!emulatableSystem.isRAMaddress(symbol.getAddress(), true)) continue;
            List<Object> list2 = (ArrayList<Symbol>)hashMap.get(symbol.getAddress());
            if (list2 == null) {
                list2 = new ArrayList<Symbol>();
                hashMap.put(symbol.getAddress(), list2);
            }
            list2.add(new Symbol(symbol.getBank(), symbol.getAddress() & 0xFFFF, symbol.getLabel(), symbol.getComment()));
            if (map == null || emulatableSystem.getAdditionalMemoryLocationAt(symbol.getAddress()) != null) continue;
            int n = emulatableSystem.mapAddress(symbol.getAddress(), symbol.getBank());
            list2 = map.get(n);
            if (list2 == null) {
                list2 = new ArrayList();
                map.put(n, list2);
            }
            list2.add(new Symbol(symbol.getBank(), symbol.getAddress() & 0xFFFF, symbol.getLabel(), symbol.getComment()));
        }
        return hashMap;
    }

    public static List<Symbol> loadSymbols(File file) {
        if (file == null || !file.exists()) {
            return Collections.emptyList();
        }
        if (file.getName().toLowerCase().endsWith(".cdb")) {
            return Symbols.loadCdbSymbols(file);
        }
        if (file.getName().toLowerCase().endsWith(".map")) {
            return Symbols.loadMapSymbols(file);
        }
        if (file.getName().toLowerCase().endsWith(".lst")) {
            return Symbols.loadLSTSymbols(file);
        }
        return Symbols.loadSymSymbols(file);
    }

    public static List<Symbol> loadSymSymbols(File file) {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String string = null;
            boolean bl = false;
            boolean bl2 = false;
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                try {
                    if (!bl && string2.contains(": equ ")) {
                        Symbols.loadTniAsmSymbols(bufferedReader, arrayList);
                    } else {
                        int n;
                        bl = true;
                        if (!bl2 && string2.contains("ASxxxx Assembler")) break;
                        bl2 = true;
                        if (string2.trim().isEmpty()) {
                            string = null;
                        }
                        if ((n = string2.indexOf(59)) >= 0) {
                            string = string2.substring(n);
                            string2 = string2.substring(0, n);
                            if (string.startsWith("; no$gmb")) {
                                string = null;
                            }
                        }
                        if (!(string2 = string2.trim()).isEmpty() && string2.charAt(0) != '[') {
                            int n2 = 0;
                            int n3 = string2.indexOf(58);
                            if (n3 >= 0) {
                                n2 = Integer.parseInt(string2.substring(0, n3), 16);
                                string2 = string2.substring(n3 + 1);
                            }
                            String string3 = string2.substring(0, Math.min(string2.length(), string2.indexOf(32) & 0xFFFF));
                            int n4 = Integer.parseInt(string3, 16);
                            if (!((string2 = string2.substring(Math.min(string2.length(), string3.length() + 1))).isEmpty() && n < 0 || string2.startsWith("_sizeof_"))) {
                                arrayList.add(new Symbol(n2, n4, string2, string));
                                string = null;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    private static List<Symbol> loadTniAsmSymbols(BufferedReader bufferedReader, List<Symbol> list) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null) {
            String string2 = string.substring(0, string.indexOf(": equ "));
            int n = (int)Long.parseLong((string = string.substring(string2.length() + ": equ ".length())).substring(0, string.indexOf(104)), 16);
            int n2 = n < 49152 ? n & 0x3FFF : n;
            list.add(new Symbol(0, n2, string2, null));
            string = bufferedReader.readLine();
        }
        return list;
    }

    public static Map<List<Symbol>> loadLSTSymbols(File file, Map<List<Symbol>> map) {
        for (Symbol symbol : Symbols.loadLSTSymbols(file)) {
            int n = symbol.getAddress() >= 49152 ? symbol.getAddress() : symbol.getBank() * 16384 | symbol.getAddress() & 0x3FFF;
            List<Symbol> list = map.get(n);
            if (list == null) {
                list = new ArrayList<Symbol>();
                map.put(n, list);
            }
            list.add(new Symbol(symbol.getBank(), symbol.getAddress() & 0xFFFF, symbol.getLabel(), symbol.getComment()));
        }
        return map;
    }

    public static List<Symbol> loadLSTSymbols(File file) {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            boolean bl = false;
            String string = bufferedReader.readLine();
            while (string != null) {
                try {
                    string = string.trim();
                    if (bl) {
                        if (string.startsWith("Output:")) break;
                        int n = 0;
                        String[] stringArray = string.split(" ");
                        int n2 = stringArray[0].indexOf(58);
                        if (stringArray.length > 1 && n2 >= 0) {
                            n = Integer.parseInt(stringArray[0].substring(0, n2), 16);
                            int n3 = (int)Long.parseLong(stringArray[0].substring(n2 + 1), 16);
                            string = string.substring(string.lastIndexOf(32) + 1);
                            arrayList.add(new Symbol(n, n3, string, null));
                        }
                    } else if ("LABELS".equals(string)) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public static boolean isRGBDSMapSymbols(File file) {
        if (file == null || !file.exists() || !file.getName().toLowerCase().endsWith(".map")) {
            return false;
        }
        Boolean bl = rgbdsMapFiles.get(file);
        if (bl == null) {
            Symbols.loadMapSymbols(file);
            bl = rgbdsMapFiles.get(file);
        }
        return bl != null && bl != false;
    }

    public static List<Symbol> loadMapSymbols(File file) {
        boolean bl = false;
        List<Symbol> list = Symbols.loadSDCCMapSymbols(file);
        if (list.isEmpty()) {
            String string = file.getAbsolutePath();
            File file2 = new File(String.valueOf(string.substring(0, string.lastIndexOf(46))) + ".cdb");
            if (file2.exists()) {
                list = Symbols.loadCdbSymbols(file2);
            }
            if (list.isEmpty()) {
                try {
                    File file3;
                    RGBDSMapFile rGBDSMapFile = RGBDSMapFile.parse(file);
                    list = Symbols.loadRgbdsMapSymbols(rGBDSMapFile);
                    boolean bl2 = bl = !rGBDSMapFile.getBanks().isEmpty();
                    if (list.isEmpty() && (file3 = new File(String.valueOf(string.substring(0, string.lastIndexOf(46))) + ".sym")).exists()) {
                        list = Symbols.loadSymSymbols(file3);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (!bl && list.isEmpty()) {
            list = Symbols.loadZ88dkMapSymbols(file);
        }
        rgbdsMapFiles.put(file, bl);
        return list;
    }

    public static List<Symbol> loadRgbdsMapSymbols(RGBDSMapFile rGBDSMapFile) {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        for (RGBDSMapFile.Bank bank : rGBDSMapFile.getBanks()) {
            for (RGBDSMapFile.Section section : bank.getSections()) {
                for (RGBDSMapFile.Symbol symbol : section.getSymbols()) {
                    int n = symbol.getOffset();
                    arrayList.add(new Symbol(bank.getBankNumber(), n, symbol.getName(), null));
                }
            }
        }
        return arrayList;
    }

    public static List<Symbol> loadSDCCMapSymbols(File file) {
        ArrayList<Symbol> arrayList;
        block50: {
            Object object;
            int n;
            Object object2;
            Object object3;
            Object object4;
            int n2;
            block52: {
                int n3;
                List<Integer> list;
                int n4;
                block51: {
                    int n5;
                    Object object5;
                    arrayList = new ArrayList<Symbol>();
                    try {
                        object5 = new BufferedReader(new FileReader(file));
                        boolean bl = false;
                        n5 = 0;
                        n4 = 0;
                        n2 = 16;
                        object4 = null;
                        list = ((BufferedReader)object5).readLine();
                        while (list != null) {
                            block48: {
                                try {
                                    list = ((String)((Object)list)).trim();
                                    if (((String)((Object)list)).isEmpty()) break block48;
                                    if (n5 == 4 && ((String[])(object3 = ((String)((Object)list)).split("="))).length > 1 && object3[1].startsWith("0x")) {
                                        try {
                                            n3 = Integer.parseInt(object3[1].substring(2), 16);
                                            arrayList.add(new Symbol(n4, n3 & 0xFFFF, object3[0], null));
                                            break block48;
                                        }
                                        catch (Exception exception) {}
                                    }
                                    if (((String)((Object)list)).startsWith("User Global Definitions")) {
                                        n5 = 4;
                                        break block48;
                                    }
                                    if (((String)((Object)list)).charAt(0) == '_') {
                                        if (((String)((Object)list)).startsWith("_CODE")) {
                                            n5 = 1;
                                            n4 = 0;
                                        } else if (((String)((Object)list)).startsWith("_DATA") || ((String)((Object)list)).startsWith("_INITIALIZED") || ((String)((Object)list)).startsWith("_BSS")) {
                                            n5 = 2;
                                            n4 = 0;
                                        } else {
                                            object3 = ((String)((Object)list)).split("\\s+");
                                            if (((String[])object3).length <= 1) {
                                                n5 = 1;
                                            } else if (!object3[0].equals(object4)) {
                                                n3 = Integer.parseInt(object3[1], n2) / 16384;
                                                if (n3 == 2) {
                                                    n5 = 3;
                                                    n4 = n4 == 0 ? 2 : ++n4;
                                                } else {
                                                    n5 = 1;
                                                }
                                            }
                                            if (((String[])object3).length >= 1) {
                                                object4 = object3[0];
                                            }
                                        }
                                        break block48;
                                    }
                                    if (((String)((Object)list)).startsWith("Octal  [")) {
                                        n2 = 8;
                                        break block48;
                                    }
                                    if (((String)((Object)list)).startsWith("Decimal  [")) {
                                        n2 = 10;
                                        break block48;
                                    }
                                    if (((String)((Object)list)).startsWith("Hexadecimal  [")) {
                                        n2 = 16;
                                        break block48;
                                    }
                                    if (n5 > 0) {
                                        object2 = ((String)((Object)list)).split("\\|");
                                        n = ((String[])object2).length;
                                        n3 = 0;
                                        while (n3 < n) {
                                            object3 = object2[n3];
                                            object = ((String)(object3 = ((String)object3).trim())).split("\\s+");
                                            if (((String[])object).length > 1) {
                                                try {
                                                    int n6 = Integer.parseInt(object[0], n2);
                                                    if (n5 == 1) {
                                                        int n7 = n6 >= 65536 ? n6 >> 16 : (n4 = bl || n6 < 16384 ? n6 / 16384 : (n6 - 16384) / 8192);
                                                    }
                                                    if (n4 == 0 && n6 < 16384) {
                                                        bl = true;
                                                    }
                                                    arrayList.add(new Symbol(n4, n6 & 0xFFFF, object[1], null));
                                                }
                                                catch (NumberFormatException numberFormatException) {}
                                            }
                                            ++n3;
                                        }
                                        break block48;
                                    }
                                    if (((String)((Object)list)).startsWith("ROM0")) {
                                        break;
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            list = ((BufferedReader)object5).readLine();
                        }
                        ((BufferedReader)object5).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (arrayList.isEmpty()) break block50;
                    object5 = new File(file.getParentFile(), String.valueOf(file.getName().substring(0, file.getName().length() - 4)) + ".noi");
                    if (!((File)object5).exists()) break block51;
                    HashMap<ArrayList<Integer>> hashMap = new HashMap<ArrayList<Integer>>();
                    n5 = 0;
                    while (n5 < arrayList.size()) {
                        Symbol symbol = (Symbol)arrayList.get(n5);
                        n2 = symbol.getBank() << 16 | symbol.getAddress();
                        object4 = (ArrayList<Integer>)hashMap.get(n2);
                        if (object4 == null) {
                            object4 = new ArrayList<Integer>();
                            hashMap.put(n2, (ArrayList<Integer>)object4);
                        }
                        object4.add(n5);
                        ++n5;
                    }
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader((File)object5));
                        String string = bufferedReader.readLine();
                        while (string != null) {
                            block49: {
                                try {
                                    String[] stringArray;
                                    if (!string.startsWith("DEF") || (stringArray = string.split(" ")).length != 3 || !stringArray[2].startsWith("0x")) break block49;
                                    int n8 = Integer.parseInt(stringArray[2].substring(2), 16);
                                    list = stringArray[1];
                                    object3 = (List)hashMap.get(n8);
                                    if (object3 == null) break block49;
                                    Iterator iterator = object3.iterator();
                                    while (iterator.hasNext()) {
                                        n3 = (Integer)iterator.next();
                                        object2 = (Symbol)arrayList.get(n3);
                                        if (!((String)((Object)list)).startsWith(((Symbol)object2).getLabel())) continue;
                                        if (((String)((Object)list)).length() > ((Symbol)object2).getLabel().length()) {
                                            arrayList.set(n3, new Symbol(((Symbol)object2).getBank(), ((Symbol)object2).getAddress(), (String)((Object)list), ((Symbol)object2).getComment()));
                                        }
                                        break;
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            string = bufferedReader.readLine();
                        }
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break block50;
                }
                File file2 = new File(file.getParentFile(), String.valueOf(file.getName().substring(0, file.getName().length() - 4)) + ".sym");
                if (!file2.exists()) break block52;
                HashMap<ArrayList<Integer>> hashMap = new HashMap<ArrayList<Integer>>();
                n4 = 0;
                while (n4 < arrayList.size()) {
                    Symbol symbol = (Symbol)arrayList.get(n4);
                    int n9 = symbol.getBank() << 16 | symbol.getAddress();
                    list = (List)hashMap.get(n9);
                    if (list == null) {
                        list = new ArrayList<Integer>();
                        hashMap.put(n9, (ArrayList<Integer>)list);
                    }
                    list.add(n4);
                    ++n4;
                }
                block18: for (Symbol symbol : Symbols.loadSymSymbols(file2)) {
                    int n10 = symbol.getBank() << 16 | symbol.getAddress();
                    list = symbol.getLabel();
                    object3 = (List)hashMap.get(n10);
                    if (object3 == null) continue;
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        n3 = (Integer)iterator.next();
                        object2 = (Symbol)arrayList.get(n3);
                        if (!((String)((Object)list)).startsWith(((Symbol)object2).getLabel())) continue;
                        if (((String)((Object)list)).length() <= ((Symbol)object2).getLabel().length()) continue block18;
                        arrayList.set(n3, new Symbol(((Symbol)object2).getBank(), ((Symbol)object2).getAddress(), (String)((Object)list), ((Symbol)object2).getComment()));
                        continue block18;
                    }
                }
                break block50;
            }
            File file3 = new File(file.getParentFile(), String.valueOf(file.getName().substring(0, file.getName().length() - 4)) + ".cdb");
            if (!file3.exists()) break block50;
            HashMap<Object> hashMap = new HashMap<Object>();
            n2 = 0;
            while (n2 < arrayList.size()) {
                object4 = (Symbol)arrayList.get(n2);
                int n11 = ((Symbol)object4).getBank() << 16 | ((Symbol)object4).getAddress();
                object3 = (List)hashMap.get(n11);
                if (object3 == null) {
                    object3 = new ArrayList();
                    hashMap.put(n11, object3);
                }
                object3.add(n2);
                ++n2;
            }
            block21: for (Symbol symbol : Symbols.loadCdbSymbols(file3)) {
                int n12 = symbol.getBank() << 16 | symbol.getAddress();
                object3 = symbol.getLabel();
                List list = (List)hashMap.get(n12);
                if (list == null) continue;
                object2 = list.iterator();
                while (object2.hasNext()) {
                    n = (Integer)object2.next();
                    object = (Symbol)arrayList.get(n);
                    if (!((String)object3).startsWith(((Symbol)object).getLabel())) continue;
                    if (((String)object3).length() <= ((Symbol)object).getLabel().length()) continue block21;
                    arrayList.set(n, new Symbol(((Symbol)object).getBank(), ((Symbol)object).getAddress(), (String)object3, ((Symbol)object).getComment()));
                    continue block21;
                }
            }
        }
        return arrayList;
    }

    public static List<Symbol> loadCdbSymbols(File file) {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        try {
            for (Record record : CDBParser.parse(file)) {
                LinkerSymbolRecord linkerSymbolRecord;
                String string;
                if (!(record instanceof LinkerSymbolRecord) || (string = (linkerSymbolRecord = (LinkerSymbolRecord)record).getScope()).charAt(0) != 'G') continue;
                String string2 = "_" + linkerSymbolRecord.getName();
                int n = linkerSymbolRecord.getAddress();
                int n2 = n >= 65536 ? n >> 16 : (n < 49152 ? n / 16384 : 0);
                arrayList.add(new Symbol(n2, n & 0xFFFF, string2, null));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public static List<Symbol> loadZ88dkMapSymbols(File file) {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            while (string != null) {
                try {
                    int n;
                    String[] stringArray = string.split("\\s+");
                    if (stringArray.length >= 3 && !stringArray[0].isEmpty() && (n = (int)Long.parseLong(stringArray[2].charAt(0) == '$' ? stringArray[2].substring(1) : stringArray[2].substring(0, stringArray[2].length() - 1), 16)) >= 0) {
                        arrayList.add(new Symbol(n / 16384, n, stringArray[0], null));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public static class Symbol {
        private final int bank;
        private final int address;
        private final String label;
        private final String comment;

        protected Symbol(int n, int n2, String string, String string2) {
            if (string == null) {
                throw new IllegalArgumentException("Label must not be null");
            }
            if (string.isEmpty() && string2 == null) {
                throw new IllegalArgumentException("A symbol without label and without comment makes no sense.");
            }
            this.bank = n;
            this.address = n2;
            this.label = string;
            this.comment = string2;
        }

        public int getBank() {
            return this.bank;
        }

        public int getAddress() {
            return this.address;
        }

        public String getLabel() {
            return this.label;
        }

        public String getComment() {
            return this.comment;
        }

        public String toString() {
            return String.valueOf(String.format("%04x", this.bank)) + ":" + Integer.toHexString(this.address) + " " + this.label;
        }
    }
}

