/*
 * Decompiled with CFR 0.152.
 */
package components.cpu;

import components.cpu.Z80Info;

public class LR35902Info
extends Z80Info {
    private static LR35902Info instance;

    public static LR35902Info getInstance() {
        if (instance == null) {
            instance = new LR35902Info();
        }
        return instance;
    }

    private LR35902Info() {
    }

    @Override
    public int getMinCycles(int n, int n2) {
        if (n2 != 0) {
            int n3 = super.getMinCycles(n, n2);
            if (n3 % 4 != 0) {
                return n3 + 4 - n3 % 4;
            }
            return n3;
        }
        switch (n) {
            case 195: 
            case 197: 
            case 199: 
            case 201: 
            case 207: 
            case 213: 
            case 215: 
            case 223: 
            case 229: 
            case 231: 
            case 239: 
            case 245: 
            case 247: 
            case 255: {
                return 16;
            }
            case 205: {
                return 24;
            }
            case 8: {
                return 20;
            }
            case 16: {
                return 4;
            }
            case 34: 
            case 42: 
            case 50: 
            case 58: {
                return 8;
            }
            case 217: {
                return 16;
            }
            case 224: {
                return 12;
            }
            case 226: {
                return 8;
            }
            case 232: 
            case 234: {
                return 16;
            }
            case 240: 
            case 248: {
                return 12;
            }
            case 242: {
                return 8;
            }
            case 250: {
                return 16;
            }
        }
        if ((n & 0xCF) == 9) {
            return 8;
        }
        int n4 = super.getMinCycles(n, n2);
        if (n4 % 4 != 0) {
            return n4 + 4 - n4 % 4;
        }
        return n4;
    }

    @Override
    public int getMaxCycles(int n, int n2) {
        if (n2 == 0) {
            switch (n) {
                case 32: 
                case 40: 
                case 48: 
                case 56: {
                    return super.getMaxCycles(n, n2) - 1;
                }
                case 192: 
                case 200: 
                case 208: 
                case 216: {
                    return super.getMaxCycles(n, n2) + 6;
                }
                case 194: 
                case 202: 
                case 210: 
                case 218: {
                    return super.getMaxCycles(n, n2) + 4;
                }
                case 196: 
                case 204: 
                case 212: 
                case 220: {
                    return super.getMaxCycles(n, n2) + 5;
                }
                case 8: 
                case 16: 
                case 34: 
                case 42: 
                case 50: 
                case 58: 
                case 217: 
                case 224: 
                case 226: 
                case 232: 
                case 234: 
                case 240: 
                case 242: 
                case 248: 
                case 250: {
                    return this.getMinCycles(n, n2);
                }
            }
        }
        return super.getMaxCycles(n, n2);
    }

    public static /* bridge */ /* synthetic */ Z80Info getInstance() {
        return LR35902Info.getInstance();
    }
}

