/*
 * Decompiled with CFR 0.152.
 */
package assembler;

public class Section {
    private final CharSequence name;
    private final Mode mode;
    private final int size;
    private final int org;
    private final int bank;
    private final int begin;
    private final int end;

    public Section(CharSequence charSequence, Mode mode, int n, int n2, int n3, int n4, int n5) {
        if (charSequence == null || charSequence.length() <= 0) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("size of section must be positive but was " + n + " for section " + charSequence);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("begin must be greater or equal 0");
        }
        if (n5 < n4) {
            throw new IllegalArgumentException("end must be greater or equal begin");
        }
        this.name = charSequence;
        this.mode = mode;
        this.size = n;
        this.org = n2;
        this.bank = n3;
        this.begin = n4;
        this.end = n5;
    }

    public CharSequence getName() {
        return this.name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getSize() {
        return this.size;
    }

    public int getOrg() {
        return this.org;
    }

    public int getBank() {
        return this.bank;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public String toString() {
        return "Section \"" + this.name + "\" " + (Object)((Object)this.mode);
    }

    public static enum Mode {
        FORCE,
        SEMISUBFREE,
        SEMIFREE,
        FREE,
        SUPERFREE,
        OVERWRITE;

    }
}

