/*
 * Decompiled with CFR 0.152.
 */
package assembler;

import assembler.LR35902Instruction;
import assembler.Z80Assembler;
import assembler.Z80Instruction;
import assembler.parsers.ExpressionEvaluator;
import assembler.parsers.LR35902Parser;
import assembler.parsers.Z80Parser;
import assembler.parsers.tokens.ConstantToken;
import assembler.parsers.tokens.IndirectConstantToken;
import assembler.parsers.tokens.IndirectRegisterPair;
import assembler.parsers.tokens.Token;

public class LR35902Assembler
extends Z80Assembler {
    public LR35902Assembler(ExpressionEvaluator expressionEvaluator) {
        super(new LR35902Parser(), expressionEvaluator);
    }

    @Override
    protected Z80Instruction createInstruction(int n) {
        return LR35902Instruction.getInstance(n);
    }

    @Override
    protected Z80Instruction createInstruction(int n, int n2) {
        return LR35902Instruction.getInstance(n, n2);
    }

    @Override
    protected Z80Instruction createInstruction(int n, int n2, int n3) {
        return LR35902Instruction.getInstance(n, n2);
    }

    @Override
    protected Z80Instruction createInstruction(int n, int n2, int n3, int n4, int n5) {
        return LR35902Instruction.getInstance(n, n4, n5);
    }

    @Override
    protected Z80Instruction assemble(Token[] tokenArray) {
        Object object;
        if (tokenArray[0] instanceof LR35902Parser.OpCode) {
            switch ((LR35902Parser.OpCode)tokenArray[0]) {
                case STOP: {
                    return this.createInstruction(16);
                }
                case LDI: {
                    if (tokenArray[1] == Z80Parser.Register.A) {
                        return this.createInstruction(42);
                    }
                    return this.createInstruction(34);
                }
                case LDD: {
                    if (tokenArray[1] == Z80Parser.Register.A) {
                        return this.createInstruction(58);
                    }
                    return this.createInstruction(50);
                }
                case LDH: {
                    if (tokenArray[1] == Z80Parser.Register.A) {
                        if (tokenArray[2] == Z80Parser.Register.C) {
                            return this.createInstruction(242);
                        }
                        return this.createInstruction(240, 0, 256, this.evaluate((ConstantToken)tokenArray[2]), 1);
                    }
                    if (tokenArray[1] == Z80Parser.Register.C) {
                        return this.createInstruction(226);
                    }
                    return this.createInstruction(224, 0, 256, this.evaluate((ConstantToken)tokenArray[1]), 1);
                }
                case SWAP: {
                    return this.createInstruction(0x30 | LR35902Assembler.registerIndex(tokenArray[1]), 203);
                }
                case RETI: {
                    return this.createInstruction(217);
                }
            }
        }
        switch ((Z80Parser.OpCode)tokenArray[0]) {
            case LD: {
                if (tokenArray[1] instanceof IndirectRegisterPair) {
                    object = ((IndirectRegisterPair)tokenArray[1]).getRegisterPair();
                    if (object == LR35902Parser.LR35902RegisterPair.HLI) {
                        return this.createInstruction(34);
                    }
                    if (object == LR35902Parser.LR35902RegisterPair.HLD) {
                        return this.createInstruction(50);
                    }
                }
                if (tokenArray.length == 3 && tokenArray[2] instanceof IndirectRegisterPair) {
                    object = ((IndirectRegisterPair)tokenArray[2]).getRegisterPair();
                    if (object == LR35902Parser.LR35902RegisterPair.HLI) {
                        return this.createInstruction(42);
                    }
                    if (object == LR35902Parser.LR35902RegisterPair.HLD) {
                        return this.createInstruction(58);
                    }
                }
                if (tokenArray[1] instanceof IndirectConstantToken && tokenArray[2] == Z80Parser.RegisterPair.SP) {
                    return this.createInstruction(8, 0, 256, this.evaluate((IndirectConstantToken)tokenArray[1]), 2);
                }
                if (tokenArray.length != 4 || tokenArray[1] != Z80Parser.RegisterPair.HL) break;
                return this.createInstruction(248, 0, 256, this.evaluate((ConstantToken)tokenArray[3]), 1);
            }
            case ADD: {
                if (tokenArray.length == 2) {
                    if (tokenArray[1] instanceof ConstantToken) {
                        return this.createInstruction(198, 0, 256, this.evaluate((ConstantToken)tokenArray[1]), 1);
                    }
                    return this.createInstruction(0x80 | LR35902Assembler.registerIndex(tokenArray[1]));
                }
                if (tokenArray[1] != Z80Parser.RegisterPair.SP) break;
                return this.createInstruction(232, 0, 256, this.evaluate((ConstantToken)tokenArray[2]), 1);
            }
            case ADC: {
                if (tokenArray[1] instanceof ConstantToken) {
                    return this.createInstruction(206, 0, 256, this.evaluate((ConstantToken)tokenArray[1]), 1);
                }
                return this.createInstruction(0x88 | LR35902Assembler.registerIndex(tokenArray[1]));
            }
            case SBC: {
                if (tokenArray[1] instanceof ConstantToken) {
                    return this.createInstruction(222, 0, 256, this.evaluate((ConstantToken)tokenArray[1]), 1);
                }
                return this.createInstruction(0x98 | LR35902Assembler.registerIndex(tokenArray[1]));
            }
        }
        object = super.assemble(tokenArray);
        if (((Z80Instruction)object).getOpCode() == 50) {
            return this.createInstruction(234, 0, 256, ((Z80Instruction)object).getArg(), 2);
        }
        if (((Z80Instruction)object).getOpCode() == 58) {
            return this.createInstruction(250, 0, 256, ((Z80Instruction)object).getArg(), 2);
        }
        return object;
    }
}

