/*
 * Decompiled with CFR 0.152.
 */
package variables;

import assembler.HexStrings;
import components.cartridge.MSXCartridge;
import components.sound.YM2413;
import components.video.TMS9918A;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import system.MSX;
import variables.AbstractVariable;
import variables.AbstractVariables;
import variables.Variable;

public final class MSXVariables
extends AbstractVariables {
    private static final int NUM_MSX1_REGISTERS = 8;
    private static final String[] VDP_REGISTER_NAMES;

    static {
        String[] stringArray = new String[47];
        stringArray[0] = "Mode register 0";
        stringArray[1] = "Mode register 1";
        stringArray[2] = "Name Table Base Address";
        stringArray[3] = "Color Table Base Address";
        stringArray[4] = "Pattern Generator Table Base Address";
        stringArray[5] = "Sprite Attribute Table Base Address";
        stringArray[6] = "Sprite Pattern Generator Table Base Address";
        stringArray[7] = "Color Register";
        stringArray[8] = "Mode register 2";
        stringArray[9] = "Mode register 3";
        stringArray[10] = "Color Table Base Address High";
        stringArray[11] = "Sprite Attribute Base Address High";
        stringArray[12] = "Inverse/Blink Text Color";
        stringArray[13] = "Blinking Period";
        stringArray[14] = "VRAM Address High";
        stringArray[15] = "Status Register Index";
        stringArray[16] = "Palette Index";
        stringArray[17] = "Register Pointer";
        stringArray[18] = "Display Adjust";
        stringArray[19] = "Interrupt Line";
        stringArray[20] = "Color Burst Register 1";
        stringArray[21] = "Color Burst Register 2";
        stringArray[22] = "Color Burst Register 3";
        stringArray[23] = "Display Offset";
        stringArray[32] = "Source X Low";
        stringArray[33] = "Source X High";
        stringArray[34] = "Source Y Low";
        stringArray[35] = "Source Y High";
        stringArray[36] = "Destination X Low";
        stringArray[37] = "Destination X High";
        stringArray[38] = "Destination Y Low";
        stringArray[39] = "Destination Y High";
        stringArray[40] = "Number of X Dots Low";
        stringArray[41] = "Number of X Dots High";
        stringArray[42] = "Number of Y Dots Low";
        stringArray[43] = "Number of Y Dots High";
        stringArray[44] = "Data";
        stringArray[45] = "Argument Register";
        stringArray[46] = "Command Register";
        VDP_REGISTER_NAMES = stringArray;
    }

    protected MSXVariables(MSX mSX) {
        super(MSXVariables.createVariables(mSX));
    }

    private static Map<String, Variable[]> createVariables(MSX mSX) {
        LinkedHashMap<String, Variable[]> linkedHashMap = new LinkedHashMap<String, Variable[]>();
        linkedHashMap.put("MSX", MSXVariables.createSystemVariables(mSX));
        linkedHashMap.put("VDP", MSXVariables.createVDPVariables(mSX));
        if (!mSX.isDisk()) {
            linkedHashMap.put("Cartridge", MSXVariables.createCartridgeVariables(mSX));
        }
        linkedHashMap.put("YM2413", MSXVariables.createFMVariables(mSX));
        return linkedHashMap;
    }

    private static Variable[] createVDPVariables(MSX mSX) {
        final TMS9918A.State state = mSX.getState().getVDPstate();
        final Variable[] variableArray = MSXVariables.createVDPRegisterVariables(state, mSX);
        final String string = "[" + variableArray.length + "]";
        return new Variable[]{new AbstractVariable("Scanline"){

            @Override
            public String getValue() {
                return Integer.toString(state.getLine());
            }
        }, new AbstractVariable("VDP Address"){

            @Override
            public String getValue() {
                return String.format("$%04X", state.getRegAddress());
            }
        }, new AbstractVariable("VDP Registers"){

            @Override
            public String getValue() {
                return string;
            }

            @Override
            public Variable[] getVariables() {
                return variableArray;
            }
        }};
    }

    private static Variable[] createVDPRegisterVariables(TMS9918A.State state, MSX mSX) {
        Variable[] variableArray = new Variable[mSX.getNumberOfVdpRegisters()];
        int n = 0;
        while (n < variableArray.length) {
            variableArray[n] = MSXVariables.createVDPRegisterVariable(state, n, mSX);
            ++n;
        }
        return variableArray;
    }

    private static Variable createVDPRegisterVariable(final TMS9918A.State state, final int n, final MSX mSX) {
        Variable[] variableArray;
        String[][] stringArrayArray = new String[][]{{"External video input", "Mode M3", "Mode M4", "Mode M5", "H-Blank Interrupt Enable", "Light pen/mouse on", "DiGitize mode"}, {"Sprite zoom", "Sprite size", "Unused", "Mode M2", "Mode M1", "V-Blank Interrupt Enable", "Screen output control", "VRAM size control"}};
        String[][] stringArrayArray2 = new String[][]{{"BW", "Disable OBJ Sprites", "VRAM Size and Speed", "Color Bus Direction", "Transparent From Palette", "Lightpen Select", "Mouse Select"}, {"Dot Clock Direction", "NTSC", "Even Odd Display", "Interlace", "Simultaneous Mode", "Unused", "Overscan"}};
        if (!mSX.isMSX2()) {
            stringArrayArray[0] = Arrays.copyOf(stringArrayArray[0], 2);
            stringArrayArray[1] = Arrays.copyOf(stringArrayArray[1], 7);
        }
        if (n < stringArrayArray.length || n >= 8 && n - 8 < stringArrayArray2.length) {
            String[][] stringArrayArray3;
            int n2 = n < stringArrayArray.length ? n : n - 8;
            String[][] stringArrayArray4 = stringArrayArray3 = n < stringArrayArray.length ? stringArrayArray : stringArrayArray2;
            final int n3 = n < stringArrayArray.length ? Integer.MIN_VALUE : (n == 8 ? 2 : 4);
            variableArray = new Variable[stringArrayArray3[n2].length];
            int n4 = 0;
            while (n4 < variableArray.length) {
                final int n5 = variableArray.length - 1 - n4;
                variableArray[n4] = new AbstractVariable("Bit " + (n5 > n3 ? n5 + 1 : n5) + " - " + stringArrayArray3[n2][n5]){

                    @Override
                    public String getValue() {
                        return Integer.toString(state.getReg(n) >> (n5 > n3 ? n5 + 1 : n5) & (n5 == n3 ? 3 : 1));
                    }
                };
                ++n4;
            }
        } else {
            if (n == 18) {
                final Variable[] variableArray2 = new Variable[]{new AbstractVariable("Horizontal"){

                    @Override
                    public String getValue() {
                        int n2 = state.getReg(n);
                        return Integer.toString(-(n2 & 8) | n2 & 7);
                    }
                }, new AbstractVariable("Vertical"){

                    @Override
                    public String getValue() {
                        int n2 = state.getReg(n);
                        return Integer.toString(-(n2 >> 4 & 8) | n2 >> 4 & 7);
                    }
                }};
                return new AbstractVariable(VDP_REGISTER_NAMES[n] != null ? "[" + n + "] - " + VDP_REGISTER_NAMES[n] : "[" + n + "]"){

                    @Override
                    public String getValue() {
                        return String.format("$%02X", state.getReg(n));
                    }

                    @Override
                    public String getDisplayValue() {
                        int n2 = state.getReg(n);
                        return String.format("$%02X (%d, %d)", n2, -(n2 & 8) | n2 & 7, -(n2 >> 4 & 8) | n2 >> 4 & 7);
                    }

                    @Override
                    public boolean isEditable() {
                        return true;
                    }

                    @Override
                    public void setValue(String string) {
                        try {
                            int n2 = Integer.parseInt(string.replaceAll("[^0-9A-Fa-f]", ""), 16);
                            mSX.setVdpReg(n, n2);
                        }
                        catch (Exception exception) {}
                    }

                    @Override
                    public Variable[] getVariables() {
                        return variableArray2;
                    }
                };
            }
            variableArray = Variable.NO_VARIABLES;
        }
        return new AbstractVariable(VDP_REGISTER_NAMES[n] != null ? "[" + n + "] - " + VDP_REGISTER_NAMES[n] : "[" + n + "]"){

            @Override
            public String getValue() {
                return String.format("$%02X", state.getReg(n));
            }

            @Override
            public String getDisplayValue() {
                int n2 = MSXVariables.toVDPaddress(mSX, n);
                return n2 >= 0 ? String.format("$%02X ($%04X)", state.getReg(n), n2) : String.format("$%02X", state.getReg(n));
            }

            @Override
            public boolean isEditable() {
                return true;
            }

            @Override
            public void setValue(String string) {
                try {
                    int n2 = Integer.parseInt(string.replaceAll("[^0-9A-Fa-f]", ""), 16);
                    mSX.setVdpReg(n, n2);
                }
                catch (Exception exception) {}
            }

            @Override
            public Variable[] getVariables() {
                return variableArray;
            }
        };
    }

    static int toVDPaddress(MSX mSX, int n) {
        switch (n) {
            case 2: {
                return mSX.getScreenMapBaseAddress();
            }
            case 3: 
            case 10: {
                return mSX.getColorTableAddress();
            }
            case 4: {
                return mSX.getPatternGeneratorTableAddress();
            }
            case 5: 
            case 11: {
                return mSX.getSpriteAttributeTableAddress();
            }
            case 6: {
                return mSX.getSpritePatternAddress();
            }
            case 14: {
                return mSX.getVRAMaddress();
            }
        }
        return -1;
    }

    private static Variable[] createCartridgeVariables(final MSX mSX) {
        final MSXCartridge.State state = mSX.getState().getCartridgeState();
        Variable[] variableArray = new Variable[mSX.hasSRAM() ? 7 : 5];
        variableArray[0] = new AbstractVariable("Mapper"){

            @Override
            public String getValue() {
                return mSX.getMapperName();
            }
        };
        variableArray[1] = new AbstractVariable("ROM Bank 0"){

            @Override
            public String getValue() {
                return HexStrings.PREFIXED_HEX_STRINGS[state.getFrame0ROMPageNumber() & 0xFF].substring(1);
            }
        };
        variableArray[2] = new AbstractVariable("ROM Bank 1"){

            @Override
            public String getValue() {
                return HexStrings.PREFIXED_HEX_STRINGS[state.getFrame1ROMPageNumber() & 0xFF].substring(1);
            }
        };
        variableArray[3] = new AbstractVariable("ROM Bank 2"){

            @Override
            public String getValue() {
                return HexStrings.PREFIXED_HEX_STRINGS[state.getFrame2ROMPageNumber() & 0xFF].substring(1);
            }
        };
        variableArray[4] = new AbstractVariable("ROM Bank 3"){

            @Override
            public String getValue() {
                return HexStrings.PREFIXED_HEX_STRINGS[state.getFrame3ROMPageNumber() & 0xFF].substring(1);
            }
        };
        if (mSX.hasSRAM()) {
            variableArray[5] = new AbstractVariable("SRAM"){

                @Override
                public String getValue() {
                    return 14.toEnabledString(mSX.isSRAMenabled());
                }
            };
            variableArray[6] = new AbstractVariable("SRAM Bank"){

                @Override
                public String getValue() {
                    return HexStrings.PREFIXED_HEX_STRINGS[state.getRamPageNumber() & 0xFF];
                }
            };
        }
        return variableArray;
    }

    private static Variable[] createFMVariables(final MSX mSX) {
        final YM2413.State state = mSX.getState().getFMstate();
        Variable[] variableArray = new Variable[64];
        int n = 0;
        while (n < variableArray.length) {
            final int n2 = n;
            variableArray[n] = new AbstractVariable("[" + n2 + "]"){

                @Override
                public String getValue() {
                    return String.format("$%02X", state.getReg(n2));
                }

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setValue(String string) {
                    try {
                        int n = Integer.parseInt(string.replaceAll("[^0-9A-Fa-f]", ""), 16);
                        mSX.setFmReg(n2, n);
                    }
                    catch (Exception exception) {}
                }
            };
            ++n;
        }
        return variableArray;
    }

    private static Variable[] createSystemVariables(final MSX mSX) {
        Variable[] variableArray = new Variable[4];
        int n = 0;
        while (n < variableArray.length) {
            final int n2 = n;
            variableArray[n] = new AbstractVariable("Page " + n2){

                @Override
                public String getValue() {
                    return mSX.getDeviceName(n2);
                }
            };
            ++n;
        }
        return variableArray;
    }
}

