/*
 * Decompiled with CFR 0.152.
 */
package util.queue;

import java.util.Arrays;

public class CyclicIntBuffer {
    private final int[] elements;
    private final int MASK;
    private int head;
    private int tail;

    public CyclicIntBuffer(int n) {
        --n;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        if (++n < 0) {
            n >>>= 1;
        }
        this.elements = new int[n];
        this.MASK = this.elements.length - 1;
    }

    public void fill(int n) {
        Arrays.fill(this.elements, n);
        this.head = 0;
        this.tail = this.elements.length - 1;
    }

    public void add(int n) {
        this.tail = this.tail + 1 & this.MASK;
        this.elements[this.tail] = n;
        if (this.tail == this.head) {
            this.head = this.head + 1 & this.MASK;
        }
    }

    public int indexOf(int n, int n2) {
        int n3 = this.head + n2 & this.MASK;
        do {
            if (this.elements[n3] != n) continue;
            return n3 - this.head & this.MASK;
        } while ((n3 = n3 + 1 & this.MASK) != this.tail);
        return -1;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int get(int n) {
        return this.elements[this.head + n & this.MASK];
    }

    public boolean isFull() {
        return (this.head - this.tail & this.MASK) == 1;
    }

    public int size() {
        return this.isFull() ? this.elements.length : this.tail - this.head & this.MASK;
    }

    public int capacity() {
        return this.elements.length;
    }
}

