/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class IOUtilities {
    private IOUtilities() {
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        int n = inputStream.read(byArray);
        while (n > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static int getResourceSize(String string) throws IOException {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(string).available();
    }

    public static void extractResource(String string, File file) throws IOException {
        byte[] byArray = IOUtilities.toByteArray(Thread.currentThread().getContextClassLoader().getResourceAsStream(string));
        if (byArray.length <= 0) {
            return;
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.close();
    }
}

