/*
 * Decompiled with CFR 0.152.
 */
package plotting;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import plotting.DefaultPlotColorModel;
import plotting.PlotColorModel;
import plotting.PlotModel;
import plotting.PlotModelEvent;
import plotting.PlotModelListener;

public class Plot
extends JComponent
implements PlotModelListener {
    private static final int HIGHLIGHT_DISTANCE = 9;
    private static final JLabel LABEL = new JLabel();
    protected PlotModel model;
    protected PlotColorModel colorModel;
    private double pixelsPerX;
    private double pixelsPerY;
    private double xPerPixel;
    private double yPerPixel;
    double minX = -10.0;
    double maxX = 10.0;
    double minY = -10.0;
    double maxY = 10.0;
    double dragXoffset;
    double dragYoffset;
    boolean dragging;
    int dataToHightlight = -1;
    int valueToHighlight = -1;
    private int offsetX;
    private int offsetTop;
    private int offsetBottom;
    private int width;
    private int height;
    private boolean zoomEnabled = true;
    private boolean panEnabled = true;
    private boolean fillMode = false;
    private int[] xPoints = new int[0];
    private int[] yPoints = new int[0];

    public Plot(PlotModel plotModel) {
        this(plotModel, null);
    }

    public Plot(PlotModel plotModel, PlotColorModel plotColorModel) {
        if (plotColorModel == null) {
            plotColorModel = new DefaultPlotColorModel();
        }
        this.setColorModel(plotColorModel);
        this.setModel(plotModel);
        this.setOpaque(true);
        this.setFocusable(true);
        this.installListeners();
    }

    private void installListeners() {
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (mouseEvent.getX() < Plot.this.getPlotOffsetX() || mouseEvent.getX() >= Plot.this.getPlotOffsetX() + Plot.this.getPlotWidth() || mouseEvent.getY() < Plot.this.getPlotOffsetTop() || mouseEvent.getY() >= Plot.this.getPlotOffsetBottom()) {
                    Plot.this.dataToHightlight = -1;
                    Plot.this.valueToHighlight = -1;
                    Plot.this.repaint();
                    Plot.this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MAX_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = Plot.this.model.getDataCount() - 1;
                while (n4 >= 0) {
                    int n5 = 0;
                    while (n5 < Plot.this.model.getValueCount(n4)) {
                        int n6 = Plot.this.toPlotX(Plot.this.model.getX(n4, n5));
                        int n7 = Plot.this.toPlotY(Plot.this.model.getY(n4, n5));
                        int n8 = Math.abs(mouseEvent.getX() - n6) + Math.abs(mouseEvent.getY() - n7);
                        if (n8 < n) {
                            n = n8;
                            n2 = n4;
                            n3 = n5;
                            if (n8 <= 0) break;
                        }
                        ++n5;
                    }
                    --n4;
                }
                if (n < 9) {
                    Plot.this.dataToHightlight = n2;
                    Plot.this.valueToHighlight = n3;
                    Plot.this.repaint();
                } else {
                    Plot.this.dataToHightlight = -1;
                    Plot.this.valueToHighlight = -1;
                    Plot.this.repaint();
                    if (Plot.this.isPanEnabled()) {
                        Plot.this.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!Plot.this.dragging) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    double d = Plot.this.toDataX(mouseEvent.getX());
                    double d2 = Plot.this.toDataY(mouseEvent.getY());
                    Plot.this.minX -= d - Plot.this.dragXoffset;
                    Plot.this.maxX -= d - Plot.this.dragXoffset;
                    Plot.this.minY -= d2 - Plot.this.dragYoffset;
                    Plot.this.maxY -= d2 - Plot.this.dragYoffset;
                    Plot.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!Plot.this.isPanEnabled()) {
                    return;
                }
                if (mouseEvent.getX() < Plot.this.getPlotOffsetX() || mouseEvent.getX() >= Plot.this.getPlotOffsetX() + Plot.this.getPlotWidth() || mouseEvent.getY() < Plot.this.getPlotOffsetTop() || mouseEvent.getY() >= Plot.this.getPlotOffsetBottom()) {
                    Plot.this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Plot.this.dragXoffset = Plot.this.toDataX(mouseEvent.getX());
                    Plot.this.dragYoffset = Plot.this.toDataY(mouseEvent.getY());
                    Plot.this.dragging = true;
                    Plot.this.setCursor(Cursor.getPredefinedCursor(13));
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Plot.this.dragging = false;
                if (mouseEvent.getX() < Plot.this.getPlotOffsetX() || mouseEvent.getX() >= Plot.this.getPlotOffsetX() + Plot.this.getPlotWidth() || mouseEvent.getY() < Plot.this.getPlotOffsetTop() || mouseEvent.getY() >= Plot.this.getPlotOffsetBottom()) {
                    Plot.this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                if (Plot.this.isPanEnabled()) {
                    Plot.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Plot.this.dataToHightlight = -1;
                Plot.this.valueToHighlight = -1;
                Plot.this.setCursor(Cursor.getDefaultCursor());
                Plot.this.repaint();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (!Plot.this.isZoomEnabled()) {
                    return;
                }
                if (mouseWheelEvent.getWheelRotation() < 0) {
                    Plot.this.zoomIn(mouseWheelEvent.getX(), mouseWheelEvent.getY());
                } else if (mouseWheelEvent.getWheelRotation() > 0) {
                    Plot.this.zoomOut(mouseWheelEvent.getX(), mouseWheelEvent.getY());
                }
            }
        });
    }

    public void setModel(PlotModel plotModel) {
        if (plotModel == null) {
            throw new IllegalArgumentException("Cannot set a null PlotModel");
        }
        if (this.model != plotModel) {
            if (this.model != null) {
                this.model.removePlotModelListener(this);
            }
            this.model = plotModel;
            plotModel.addPlotModelListener(this);
            this.plotChanged(null);
        }
    }

    public void setColorModel(PlotColorModel plotColorModel) {
        if (plotColorModel == null) {
            throw new IllegalArgumentException("Cannot set a null PlotColorModel");
        }
        if (this.colorModel != plotColorModel) {
            this.colorModel = plotColorModel;
            this.repaint();
        }
    }

    public PlotModel getModel() {
        return this.model;
    }

    private void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    protected int getPlotOffsetX() {
        return this.offsetX;
    }

    protected int getPlotOffsetTop() {
        return this.offsetTop;
    }

    protected int getPlotOffsetBottom() {
        return this.offsetBottom;
    }

    protected int getPlotWidth() {
        return this.width;
    }

    protected int getPlotHeight() {
        return this.height;
    }

    protected int toPlotX(double d) {
        return this.getPlotOffsetX() + (int)((d - this.minX) * this.pixelsPerX + 0.5);
    }

    protected int toPlotY(double d) {
        return this.getPlotOffsetBottom() - (int)((d - this.minY) * this.pixelsPerY + 0.5);
    }

    protected double toDataX(int n) {
        return this.toDataX(n, this.xPerPixel);
    }

    protected double toDataX(int n, double d) {
        double d2 = this.minX + (double)(n - this.getPlotOffsetX()) * d;
        double d3 = Math.min(d2 + d, this.maxX);
        double d4 = Math.ceil(d2);
        if (d4 < d3) {
            return d4;
        }
        double d5 = d2 + (d3 - d2) / 2.0;
        double d6 = Math.round(d5);
        if (d6 >= d2 && d6 < d3) {
            return d6;
        }
        d6 = (double)Math.round(d5 * 2.0) / 2.0;
        if (d6 >= d2 && d6 < d3) {
            return d6;
        }
        return d5;
    }

    protected double toDataY(int n) {
        return this.toDataY(n, this.yPerPixel);
    }

    protected double toDataY(int n, double d) {
        double d2 = this.minY + (double)(this.getPlotOffsetBottom() - n) * d;
        double d3 = Math.min(d2 + d, this.maxY);
        double d4 = Math.ceil(d2);
        if (d4 < d3) {
            return d4;
        }
        double d5 = d2 + (d3 - d2) / 2.0;
        double d6 = Math.round(d5);
        if (d6 >= d2 && d6 < d3) {
            return d6;
        }
        d6 = (double)Math.round(d5 * 2.0) / 2.0;
        if (d6 >= d2 && d6 < d3) {
            return d6;
        }
        return d5;
    }

    public void zoomFit() {
        this.minX = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < this.model.getDataCount()) {
            int n2 = 0;
            while (n2 < this.model.getValueCount(n)) {
                double d = this.model.getX(n, n2);
                double d2 = this.model.getY(n, n2);
                if (d < this.minX) {
                    this.minX = d;
                }
                if (d > this.maxX) {
                    this.maxX = d;
                }
                if (d2 < this.minY) {
                    this.minY = d2;
                }
                if (d2 > this.maxY) {
                    this.maxY = d2;
                }
                ++n2;
            }
            ++n;
        }
        this.repaint();
    }

    public void setZoomEnabled(boolean bl) {
        this.zoomEnabled = bl;
    }

    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    public void setPanEnabled(boolean bl) {
        this.panEnabled = bl;
        this.dragging = false;
        this.setCursor(Cursor.getDefaultCursor());
    }

    public boolean isPanEnabled() {
        return this.panEnabled;
    }

    public void setFillMode(boolean bl) {
        this.fillMode = bl;
        this.repaint();
    }

    public boolean isFillMode() {
        return this.fillMode;
    }

    public void zoomIn(int n, int n2) {
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        double d3 = d / 1.3;
        double d4 = d2 / 1.3;
        double d5 = this.toDataX(n);
        double d6 = this.toDataY(n2);
        this.maxX = this.minX + d3;
        this.maxY = this.minY + d4;
        double d7 = this.toDataX(n, (this.maxX - this.minX) / (double)this.getPlotWidth());
        double d8 = this.toDataY(n2, (this.maxY - this.minY) / (double)this.getPlotHeight());
        this.minX -= d7 - d5;
        this.minY -= d8 - d6;
        this.maxX = this.minX + d3;
        this.maxY = this.minY + d4;
        this.repaint();
    }

    public void zoomOut(int n, int n2) {
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        double d3 = d * 1.3;
        double d4 = d2 * 1.3;
        double d5 = this.toDataX(n);
        double d6 = this.toDataY(n2);
        this.maxX = this.minX + d3;
        this.maxY = this.minY + d4;
        double d7 = this.toDataX(n, (this.maxX - this.minX) / (double)this.getPlotWidth());
        double d8 = this.toDataY(n2, (this.maxY - this.minY) / (double)this.getPlotHeight());
        this.minX -= d7 - d5;
        this.minY -= d8 - d6;
        this.maxX = this.minX + d3;
        this.maxY = this.minY + d4;
        this.repaint();
    }

    public void scrollDataPointToVisible(double d, double d2) {
        double d3;
        if (d < this.minX || d >= this.maxX) {
            d3 = this.maxX - this.minX;
            this.minX = d;
            this.maxX = this.minX + d3;
            this.repaint();
        }
        if (d2 < this.minY || d2 >= this.maxY) {
            d3 = this.maxY - this.minY;
            this.minY = d2;
            this.maxY = this.minY + d3;
            this.repaint();
        }
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double d) {
        this.minX = d;
        this.repaint();
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double d) {
        this.maxX = d;
        this.repaint();
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double d) {
        this.minY = d;
        this.repaint();
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double d) {
        this.maxY = d;
        this.repaint();
    }

    @Override
    public void plotChanged(PlotModelEvent plotModelEvent) {
        if (plotModelEvent == null) {
            this.resizeAndRepaint();
            return;
        }
        this.repaint(this.getPlotOffsetX(), this.getPlotOffsetTop(), this.getPlotWidth(), this.getPlotHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(360, 300);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle2D rectangle2D;
        String string;
        int n;
        int n2;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        Insets insets = this.getInsets();
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D.getFont());
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fill(shape);
        }
        String string2 = Plot.makeLabel(this.minY);
        String string3 = Plot.makeLabel(this.maxY);
        String string4 = Plot.makeLabel(this.minX);
        String string5 = Plot.makeLabel(this.maxX);
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(string4.length() > string5.length() ? string4 : string5, graphics);
        Rectangle2D rectangle2D3 = fontMetrics.getStringBounds(string2.length() > string3.length() ? string2 : string3, graphics);
        this.offsetX = insets.left + 3 + (int)rectangle2D2.getWidth();
        this.offsetTop = insets.top + (int)(rectangle2D3.getHeight() / 2.0);
        this.width = this.getWidth() - insets.right - (int)(rectangle2D2.getWidth() / 2.0) - this.offsetX;
        this.height = this.getHeight() - insets.left - (int)rectangle2D3.getHeight() - this.offsetTop;
        this.offsetBottom = this.offsetTop + this.getPlotHeight();
        graphics2D.setColor(this.colorModel.getBackground());
        graphics2D.fillRect(this.getPlotOffsetX(), this.getPlotOffsetTop(), this.getPlotWidth(), this.getPlotHeight());
        graphics2D.setColor(this.getForeground());
        graphics2D.drawRect(this.getPlotOffsetX(), this.getPlotOffsetTop(), this.getPlotWidth(), this.getPlotHeight());
        if (this.model.getDataCount() <= 0 || this.getPlotWidth() <= 0 || this.getPlotHeight() <= 0) {
            return;
        }
        if (this.minX >= Double.POSITIVE_INFINITY && this.maxX <= Double.NEGATIVE_INFINITY && this.minY >= Double.POSITIVE_INFINITY && this.maxY <= Double.NEGATIVE_INFINITY) {
            return;
        }
        this.pixelsPerX = (double)this.getPlotWidth() / (this.maxX - this.minX);
        this.pixelsPerY = (double)this.getPlotHeight() / (this.maxY - this.minY);
        this.xPerPixel = (this.maxX - this.minX) / (double)this.getPlotWidth();
        this.yPerPixel = (this.maxY - this.minY) / (double)this.getPlotHeight();
        graphics2D.clipRect(this.getPlotOffsetX() + 1, this.getPlotOffsetTop() + 1, this.getPlotWidth() - 1, this.getPlotHeight() - 1);
        this.paintData(graphics2D);
        graphics2D.setClip(shape);
        this.paintDataHighlight(graphics2D, fontMetrics);
        boolean bl = shape.intersects(0.0, this.getPlotOffsetBottom() + 2, this.getWidth(), fontMetrics.getHeight());
        boolean bl2 = shape.intersects((double)this.getPlotOffsetX() - rectangle2D2.getWidth() - 3.0, 0.0, rectangle2D2.getWidth(), this.getHeight());
        int n3 = (this.getPlotWidth() - 1) / 100 + 1;
        double d = (double)this.getPlotWidth() / (double)n3;
        while (n3 / 2 >= 1 && Math.abs(this.toDataX(this.getPlotOffsetX()) - this.toDataX((int)((double)this.getPlotOffsetX() + d))) < 0.1) {
            n3 /= 2;
            d *= 2.0;
        }
        LABEL.setForeground(this.getForeground());
        graphics2D.setColor(this.getForeground());
        int n4 = 0;
        while (n4 <= n3) {
            n2 = (int)((double)this.getPlotOffsetX() + (double)n4 * d);
            n = this.getPlotOffsetBottom();
            if (bl) {
                string = Plot.makeLabel(this.toDataX(n2));
                rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                Plot.paintText(string, graphics2D, (int)((double)n2 - rectangle2D.getWidth() / 2.0), n + 2, rectangle2D);
            }
            graphics2D.drawLine(n2, n - 5, n2, n);
            ++n4;
        }
        n3 = (this.getPlotHeight() - 1) / 60 + 1;
        d = (double)this.getPlotHeight() / (double)n3;
        while (n3 / 2 >= 1 && Math.abs(this.toDataY(this.getPlotOffsetTop()) - this.toDataY((int)((double)this.getPlotOffsetTop() + d))) < 0.1) {
            n3 /= 2;
            d *= 2.0;
        }
        n4 = 0;
        while (n4 <= n3) {
            n2 = this.getPlotOffsetX();
            n = (int)Math.ceil((double)this.getPlotOffsetBottom() - (double)n4 * d);
            if (bl2) {
                string = Plot.makeLabel(this.toDataY(n));
                rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                Plot.paintText(string, graphics2D, (int)((double)n2 - rectangle2D.getWidth() - 3.0), (int)((double)n + rectangle2D.getY() / 2.0), rectangle2D);
            }
            graphics2D.drawLine(n2, n, n2 + 5, n);
            ++n4;
        }
    }

    private void paintData(Graphics2D graphics2D) {
        boolean bl = this.fillMode;
        int n = 0;
        while (n < this.model.getDataCount()) {
            int n2 = this.model.getValueCount(n);
            if (n2 > 0) {
                int n3;
                int n4 = n3 = bl ? n2 + 2 : n2;
                if (this.xPoints.length != n3) {
                    this.xPoints = new int[n3];
                }
                if (this.yPoints.length != n3) {
                    this.yPoints = new int[n3];
                }
                int n5 = 0;
                while (n5 < n2) {
                    this.xPoints[n5] = this.toPlotX(this.model.getX(n, n5));
                    this.yPoints[n5] = this.toPlotY(this.model.getY(n, n5));
                    ++n5;
                }
                graphics2D.setColor(this.colorModel.getColor(n));
                if (bl) {
                    this.xPoints[this.xPoints.length - 1] = this.xPoints[0];
                    this.xPoints[this.xPoints.length - 2] = this.xPoints[this.xPoints.length - 3];
                    this.yPoints[this.xPoints.length - 1] = this.toPlotY(0.0);
                    this.yPoints[this.yPoints.length - 2] = this.yPoints[this.xPoints.length - 1];
                    graphics2D.fillPolygon(this.xPoints, this.yPoints, this.xPoints.length);
                    graphics2D.drawPolyline(this.xPoints, this.yPoints, this.xPoints.length - 2);
                } else if (this.xPoints.length == 1) {
                    graphics2D.fillRect(this.xPoints[0], this.yPoints[0], 1, 1);
                } else {
                    graphics2D.drawPolyline(this.xPoints, this.yPoints, this.xPoints.length);
                }
            }
            ++n;
        }
    }

    private void paintDataHighlight(Graphics2D graphics2D, FontMetrics fontMetrics) {
        if (this.dataToHightlight >= 0 && this.valueToHighlight >= 0) {
            graphics2D.setColor(this.colorModel.getColor(this.dataToHightlight));
            int n = this.toPlotX(this.model.getX(this.dataToHightlight, this.valueToHighlight));
            int n2 = this.toPlotY(this.model.getY(this.dataToHightlight, this.valueToHighlight));
            graphics2D.drawRect(n - 4, n2 - 4, 9, 9);
            String string = "(" + Plot.makeLabel(this.model.getX(this.dataToHightlight, this.valueToHighlight)) + ", " + Plot.makeLabel(this.model.getY(this.dataToHightlight, this.valueToHighlight)) + ")";
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
            graphics2D.setColor(this.colorModel.getBackground());
            n2 = (double)(n2 - this.getPlotOffsetTop()) > 5.0 + rectangle2D.getHeight() ? (int)((double)n2 - (5.0 + rectangle2D.getHeight())) : (n2 += 5);
            int n3 = (int)rectangle2D.getWidth();
            int n4 = Math.min(this.getPlotOffsetX() + this.getPlotWidth() - n3, Math.max(this.getPlotOffsetX(), n - n3 / 2));
            graphics2D.fillRect(n4, n2, n3, (int)rectangle2D.getHeight());
            LABEL.setForeground(this.colorModel.getColor(this.dataToHightlight));
            Plot.paintText(string, graphics2D, n4, n2, rectangle2D);
        }
    }

    private static void paintText(String string, Graphics2D graphics2D, int n, int n2, Rectangle2D rectangle2D) {
        Plot.paintText(string, graphics2D, n, n2, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    private static void paintText(String string, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        LABEL.setText(string);
        LABEL.setBounds(n, n2, n3, n4);
        graphics2D.translate(n, n2);
        LABEL.getUI().update(graphics2D, LABEL);
        graphics2D.translate(-n, -n2);
    }

    private static String makeLabel(double d) {
        if ((d = (double)Math.round(d * 10.0) / 10.0) == (double)((int)d)) {
            return Integer.toString((int)d);
        }
        return String.valueOf(Integer.toString((int)d)) + "." + Integer.toString((int)(Math.abs(d) * 10.0) % 10);
    }
}

