/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.Icon;
import platform.debugger.Debugger;

final class DebuggerIcons {
    static final Color LIGHTER_GRAY = new Color(224, 224, 224);
    static final Color DARKER_GRAY = new Color(96, 96, 96);
    static final Color DARK_GREEN = new Color(0, 128, 0);
    static final Color DARK_ORANGE = Color.ORANGE.darker();
    static final Color DARKER_GREEN = new Color(0, 192, 0);
    static final Color DARK_YELLOW = new Color(128, 128, 0);
    static final Color BROWN = new Color(152, 75, 20);
    static final Color DARKER_RED = Color.RED.darker();
    public static final Icon RESUME_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            boolean bl = component == null || component.isEnabled();
            Color color2 = DebuggerIcons.getTraceBackground();
            graphics.setColor(bl ? color2 : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n, n2, 5, 15);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n, n2, 4, 14);
            int[] nArray = new int[]{n + 7, n + 7, n + 16};
            int[] nArray2 = new int[]{n2, n2 + 14, n2 + 7};
            graphics.setColor(bl ? (color2.getRed() > 128 ? Color.ORANGE : Color.GREEN) : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? (color2.getRed() > 128 ? DARK_ORANGE : DARK_GREEN) : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon SUSPEND_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            boolean bl = component == null || component.isEnabled();
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n += 2, n2, 5, 15);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n, n2, 4, 14);
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 7, n2, 5, 15);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n + 7, n2, 4, 14);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon STEP_INTO_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            boolean bl = component == null || component.isEnabled();
            graphics.setColor(Color.GRAY);
            graphics.fillRect(n + 2, n2 + 13, 5, 2);
            graphics.fillRect(n + 16 - 5, n2 + 13, 5, 2);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n, n2 + 1, 10, 3);
            graphics.drawRect(n + 7, n2 + 1, 3, 6);
            int[] nArray = new int[]{n + 5, n + 12, n + 9};
            int[] nArray2 = new int[]{n2 + 7, n2 + 7, n2 + 13};
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 1, n2 + 2, 9, 2);
            graphics.fillRect(n + 8, n2 + 2, 2, 6);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon STEP_OVER_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            boolean bl = component == null || component.isEnabled();
            graphics.setColor(Color.GRAY);
            graphics.fillRect(n + 6, n2 + 13, 5, 2);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n + 1, n2 + 1, 3, 8);
            graphics.drawRect(n + 1, n2 + 1, 13, 3);
            graphics.drawRect(n + 11, n2 + 1, 3, 6);
            int[] nArray = new int[]{n + 9, n + 16, n + 13};
            int[] nArray2 = new int[]{n2 + 7, n2 + 7, n2 + 13};
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 2, n2 + 2, 2, 7);
            graphics.fillRect(n + 2, n2 + 2, 12, 2);
            graphics.fillRect(n + 12, n2 + 2, 2, 6);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon STEP_RETURN_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            boolean bl = component == null || component.isEnabled();
            graphics.setColor(Color.GRAY);
            graphics.fillRect(n, n2 + 13, 5, 2);
            graphics.fillRect(n + 16 - 5 - 2, n2 + 13, 5, 2);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n + 5, n2 + 1, 3, 11);
            graphics.drawRect(n + 5, n2 + 1, 8, 3);
            int[] nArray = new int[]{n + 10, n + 10, n + 16};
            int[] nArray2 = new int[]{n2, n2 + 6, n2 + 3};
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 6, n2 + 2, 2, 10);
            graphics.fillRect(n + 6, n2 + 2, 7, 2);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon ADVANCE_FRAME_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            boolean bl = component == null || component.isEnabled();
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawRect(n, (n2 += 6) - 5, 10, 14);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n + 1, n2 - 4, 9, 13);
            graphics.setColor(bl ? BROWN : Color.GRAY);
            graphics.fillRect(n + 4, n2 + 4, 3, 5);
            graphics.setColor(bl ? DARKER_GREEN : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillOval(n + 1, n2 - 3, 8, 8);
            graphics.setColor(bl ? Color.RED : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.fillRect(n + 5, n2 + 2, 2, 1);
            graphics.fillRect(n + 3, n2 + 0, 2, 1);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n + 10, n2 + 1, 5, 3);
            int[] nArray = new int[]{n + 12, n + 12, n + 18};
            int[] nArray2 = new int[]{n2, n2 + 6, n2 + 3};
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 11, n2 + 2, 4, 2);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon STEP_BACK_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            boolean bl = component == null || component.isEnabled();
            graphics.setColor(Color.GRAY);
            graphics.fillRect(n + 2, n2 + 13, 5, 2);
            graphics.fillRect(n + 16 - 5, n2 + 13, 5, 2);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n + 7, n2 + 1, 10, 3);
            graphics.drawRect(n + 7, n2 + 1, 3, 6);
            int[] nArray = new int[]{n + 5, n + 12, n + 9};
            int[] nArray2 = new int[]{n2 + 7, n2 + 7, n2 + 13};
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 8, n2 + 2, 9, 2);
            graphics.fillRect(n + 8, n2 + 2, 2, 6);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon STEP_BACK_OVER_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            boolean bl = component == null || component.isEnabled();
            graphics.setColor(Color.GRAY);
            graphics.fillRect(n + 7, n2 + 13, 5, 2);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n + 2, n2 + 1, 3, 8);
            graphics.drawRect(n + 2, n2 + 1, 13, 3);
            graphics.drawRect(n + 12, n2 + 1, 3, 6);
            int[] nArray = new int[]{n + 1, n + 7, n + 4};
            int[] nArray2 = new int[]{n2 + 7, n2 + 7, n2 + 13};
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 3, n2 + 2, 2, 7);
            graphics.fillRect(n + 3, n2 + 2, 12, 2);
            graphics.fillRect(n + 13, n2 + 2, 2, 6);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon STEP_BACK_RETURN_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            boolean bl = component == null || component.isEnabled();
            graphics.setColor(Color.GRAY);
            graphics.fillRect(n + 2, n2 + 13, 5, 2);
            graphics.fillRect(n + 16 - 5, n2 + 13, 5, 2);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n + 7, n2 + 1, 3, 11);
            graphics.drawRect(n + 2, n2 + 1, 8, 3);
            int[] nArray = new int[]{n + 5, n + 5, n - 1};
            int[] nArray2 = new int[]{n2, n2 + 6, n2 + 3};
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getDarkerTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 8, n2 + 2, 2, 10);
            graphics.fillRect(n + 3, n2 + 2, 7, 2);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon SKIP_EXCEPTIONS_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            int[] nArray = new int[]{n + 4, n + 6, n + 9, n + 11};
            int[] nArray2 = new int[]{n2 + 0, n2 + 8, n2 + 8, n2 + 0};
            graphics.setColor(Color.YELLOW);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(DARK_YELLOW);
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(Color.YELLOW);
            graphics.fillOval(n + 5, n2 + 10, 5, 5);
            graphics.setColor(DARK_YELLOW);
            graphics.drawOval(n + 5, n2 + 10, 5, 5);
            ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
            graphics.setColor(DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : Color.DARK_GRAY);
            graphics.drawLine(n + 2, n2 + 1, n + 13, n2 + 13);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon BREAKPOINTS_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(Color.RED);
            graphics.fillOval(n += 3, n2 += 3, 10, 10);
            graphics.setColor(DARKER_RED);
            graphics.drawOval(n, n2, 10, 10);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon TRACE_LOGGER_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : Color.DARK_GRAY);
            graphics.fillOval(n, n2, 6, 10);
            graphics.fillOval(n + 1, n2 + 10, 4, 4);
            graphics.fillOval(n + 8, n2 + 4, 6, 10);
            graphics.fillOval(n + 9, n2 + 14, 4, 4);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon PROFILER_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3;
            Color color = graphics.getColor();
            graphics.setColor(DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : Color.DARK_GRAY);
            graphics.fillOval(n + 2, n2 + 2, 16, 16);
            graphics.fillRect(n + 9, n2, 3, 3);
            graphics.fillRect(n + 4, n2 + 1, 3, 3);
            graphics.fillRect(n + 14, n2 + 1, 3, 3);
            graphics.setColor(Color.WHITE);
            graphics.fillOval(n + 4, n2 + 4, 12, 12);
            graphics.setColor(Color.RED);
            graphics.fillArc(n + 4, n2 + 4, 12, 12, 30, 60);
            graphics.setColor(Color.BLACK);
            int n4 = 0;
            while (n4 < 12) {
                n3 = n + 10 + (int)Math.round(Math.cos((double)n4 * Math.PI * 2.0 / 12.0) * 6.0);
                int n5 = n + 10 + (int)Math.round(Math.cos((double)n4 * Math.PI * 2.0 / 12.0) * 5.0);
                int n6 = n2 + 10 + (int)Math.round(Math.sin((double)n4 * Math.PI * 2.0 / 12.0) * 6.0);
                int n7 = n2 + 10 + (int)Math.round(Math.sin((double)n4 * Math.PI * 2.0 / 12.0) * 5.0);
                graphics.drawLine(n3, n6, n5, n7);
                ++n4;
            }
            n4 = n + 10 + (int)Math.round(Math.cos(-0.5235987755982989) * 6.0);
            n3 = n2 + 10 + (int)Math.round(Math.sin(-0.5235987755982989) * 6.0);
            graphics.drawLine(n + 10, n2 + 10, n4, n3);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon HEATMAP_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(Color.RED);
            graphics.fillOval(n + 4, n2 + 8, 8, 8);
            graphics.setColor(Color.GRAY);
            graphics.drawOval(n + 4, n2 + 8, 8, 8);
            graphics.setColor(Color.WHITE);
            graphics.fillOval(n + 6, n2, 4, 4);
            graphics.setColor(Color.GRAY);
            graphics.drawOval(n + 6, n2, 4, 4);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n + 7, n2 + 3, 3, 7);
            graphics.setColor(Color.GRAY);
            graphics.drawLine(n + 6, n2 + 3, n + 6, n2 + 8);
            graphics.drawLine(n + 10, n2 + 3, n + 10, n2 + 8);
            graphics.setColor(Color.RED);
            graphics.drawLine(n + 8, n2 + 4, n + 8, n2 + 9);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon PLOTTER_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
            graphics.setColor(Color.BLUE);
            int n3 = n;
            int n4 = n2 + 16;
            graphics.drawLine(n3, n4, n3 += 4, n4 -= 3);
            graphics.drawLine(n3, n4, n3 += 4, n4 -= 6);
            graphics.drawLine(n3, n4, n3 += 4, n4 -= 2);
            graphics.drawLine(n3, n4--, n3 += 4, n4);
            graphics.setColor(Color.RED);
            n3 = n;
            n4 = n2 + 12;
            graphics.drawLine(n3, n4--, n3 += 4, n4);
            graphics.drawLine(n3, n4, n3 += 4, n4 += 2);
            graphics.drawLine(n3, n4, n3 += 4, n4 -= 6);
            graphics.drawLine(n3, n4, n3 += 4, n4 -= 7);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon RAM_WATCH_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
            graphics.setColor(DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : Color.DARK_GRAY);
            graphics.fillOval(n, (n2 += 2) + 5, 7, 7);
            graphics.fillOval(n + 9, n2 + 5, 7, 7);
            graphics.drawLine(n + 5, n2 + 8, n + 9, n2 + 8);
            graphics.drawLine(n + 2, n2 + 7, n + 6, n2 + 2);
            graphics.drawLine(n + 14, n2 + 7, n + 18, n2 + 2);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon RAM_SEARCH_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
            graphics.setColor(DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : Color.DARK_GRAY);
            graphics.drawOval(n, n2, 11, 11);
            graphics.drawLine(n + 10, n2 + 10, n + 16, n2 + 16);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon ASSEMBLER_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            Font font = graphics.getFont();
            graphics.setFont(new Font("Arial", 0, 9));
            graphics.setColor(component != null ? component.getForeground() : Color.DARK_GRAY);
            graphics.drawString("ASM", n, n2 + 11);
            graphics.setFont(font);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon GO_TO_CURRENT_INSTRUCTION_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(DebuggerIcons.getCodeBackground());
            graphics.fillRect(n + 10, n2, 7, 16);
            graphics.setColor(DebuggerIcons.getTraceBackground());
            graphics.fillRect(n + 10, n2 + 6, 7, 3);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n + 11, n2 + 3, n + 16, n2 + 3);
            graphics.drawLine(n + 11, n2 + 11, n + 16, n2 + 11);
            int[] nArray = new int[]{n + 3, n + 3, n + 10};
            int[] nArray2 = new int[]{n2 + 3, n2 + 12, n2 + 7};
            graphics.setColor(Color.YELLOW);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(DARK_YELLOW);
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(DARK_YELLOW);
            graphics.drawRect(n, n2 + 5, 3, 5);
            graphics.setColor(Color.YELLOW);
            graphics.fillRect(n + 1, n2 + 6, 4, 3);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon GO_TO_DESTINATION_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(DebuggerIcons.getCodeBackground());
            graphics.fillRect(n + 10, n2, 7, 16);
            graphics.setColor(DARKER_RED);
            Stroke stroke = ((Graphics2D)graphics).getStroke();
            ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
            graphics.drawLine(n + 11, n2 + 5, n + 16, n2 + 10);
            graphics.drawLine(n + 11, n2 + 10, n + 16, n2 + 5);
            ((Graphics2D)graphics).setStroke(stroke);
            int[] nArray = new int[]{n + 3, n + 3, n + 10};
            int[] nArray2 = new int[]{n2 + 3, n2 + 12, n2 + 7};
            graphics.setColor(Color.YELLOW);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(DARK_YELLOW);
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(DARK_YELLOW);
            graphics.drawRect(n, n2 + 5, 3, 5);
            graphics.setColor(Color.YELLOW);
            graphics.fillRect(n + 1, n2 + 6, 4, 3);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon PREVIOUS_IN_TRACE_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            boolean bl;
            Color color = graphics.getColor();
            boolean bl2 = bl = component == null || component.isEnabled();
            if (bl) {
                graphics.setColor(DebuggerIcons.getCodeBackground());
                graphics.fillRect(n + 10, n2, 7, 16);
            }
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 10, n2 + 1, 7, 3);
            graphics.fillRect(n + 10, n2 + 6, 7, 3);
            graphics.fillRect(n + 10, n2 + 11, 7, 3);
            graphics.setColor(bl ? DARK_YELLOW : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n + 1, n2, 4, 3);
            graphics.drawRect(n + 1, n2, 3, 8);
            graphics.drawRect(n + 1, n2 + 5, 7, 3);
            int[] nArray = new int[]{n + 4, n + 4, n + 9};
            int[] nArray2 = new int[]{n2 - 1, n2 + 5, n2 + 2};
            graphics.setColor(bl ? Color.YELLOW : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DARK_YELLOW : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? Color.YELLOW : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 2, n2 + 1, 3, 2);
            graphics.fillRect(n + 2, n2 + 1, 2, 7);
            graphics.fillRect(n + 2, n2 + 6, 6, 2);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon NEXT_IN_TRACE_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            boolean bl;
            Color color = graphics.getColor();
            boolean bl2 = bl = component == null || component.isEnabled();
            if (bl) {
                graphics.setColor(DebuggerIcons.getCodeBackground());
                graphics.fillRect(n + 10, n2, 7, 16);
            }
            graphics.setColor(bl ? DebuggerIcons.getTraceBackground() : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 10, n2 + 1, 7, 3);
            graphics.fillRect(n + 10, n2 + 6, 7, 3);
            graphics.fillRect(n + 10, n2 + 11, 7, 3);
            graphics.setColor(bl ? DARK_YELLOW : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n + 1, n2 + 5, 7, 3);
            graphics.drawRect(n + 1, n2 + 5, 3, 8);
            graphics.drawRect(n + 1, n2 + 10, 4, 3);
            int[] nArray = new int[]{n + 4, n + 4, n + 9};
            int[] nArray2 = new int[]{n2 + 9, n2 + 15, n2 + 12};
            graphics.setColor(bl ? Color.YELLOW : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DARK_YELLOW : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? Color.YELLOW : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 2, n2 + 6, 6, 2);
            graphics.fillRect(n + 2, n2 + 6, 2, 7);
            graphics.fillRect(n + 2, n2 + 11, 3, 2);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon NAVIGATE_BACK_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            boolean bl = component == null || component.isEnabled();
            int[] nArray = new int[]{n + 7, n + 7, n};
            int[] nArray2 = new int[]{n2 + 3, n2 + 12, n2 + 7};
            graphics.setColor(bl ? Color.YELLOW : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DARK_YELLOW : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DARK_YELLOW : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n + 7, n2 + 5, 8, 5);
            graphics.setColor(bl ? Color.YELLOW : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 6, n2 + 6, 9, 3);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon NAVIGATE_FORWARD_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            boolean bl = component == null || component.isEnabled();
            int[] nArray = new int[]{n + 8, n + 8, n + 15};
            int[] nArray2 = new int[]{n2 + 3, n2 + 12, n2 + 7};
            graphics.setColor(bl ? Color.YELLOW : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DARK_YELLOW : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawPolygon(nArray, nArray2, nArray.length);
            graphics.setColor(bl ? DARK_YELLOW : (DebuggerIcons.isDarkTheme(component) ? Color.DARK_GRAY : Color.LIGHT_GRAY));
            graphics.drawRect(n, n2 + 5, 8, 5);
            graphics.setColor(bl ? Color.YELLOW : (DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : LIGHTER_GRAY));
            graphics.fillRect(n + 1, n2 + 6, 9, 3);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };
    public static final Icon EXPRESSIONS_HELP_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Font font = graphics.getFont();
            Color color = graphics.getColor();
            graphics.setFont(new Font("Arial", 1, 16));
            graphics.setColor(component != null ? component.getForeground() : Color.DARK_GRAY);
            graphics.drawString("?", n + 3, n2 + 13);
            graphics.setFont(font);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 14;
        }

        @Override
        public int getIconHeight() {
            return this.getIconWidth();
        }
    };
    public static final Icon ADD_WATCHPOINT_ICON = new Icon(){
        private final Color DARKER_GREEN = Color.GREEN.darker();

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            graphics2D.setColor(this.DARKER_GREEN);
            graphics2D.setStroke(new BasicStroke(5.0f));
            graphics2D.drawLine(n + n3 / 2, n2, n + n3 / 2, n2 + n4);
            graphics2D.drawLine(n, n2 + n4 / 2, n + n3, n2 + n4 / 2);
            graphics2D.setColor(Color.GREEN);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.drawLine(n + n3 / 2, n2, n + n3 / 2, n2 + n4);
            graphics2D.drawLine(n, n2 + n4 / 2, n + n3, n2 + n4 / 2);
        }

        @Override
        public int getIconWidth() {
            return 14;
        }

        @Override
        public int getIconHeight() {
            return this.getIconWidth();
        }
    };

    static boolean isDarkTheme(Component component) {
        return component != null && component.getForeground() != null && component.getForeground().getRed() > Color.DARK_GRAY.getRed();
    }

    static Color getTraceBackground() {
        Color color = Debugger.getTraceBackground();
        return color != null ? color : Color.CYAN;
    }

    static Color getDarkerTraceBackground() {
        Color color = Debugger.getDarkerTraceBackground();
        return color != null ? color : Color.CYAN;
    }

    static Color getCodeBackground() {
        Color color = Debugger.getCodeBackground();
        return color != null ? color : Color.WHITE;
    }

    private DebuggerIcons() {
    }

    public static enum SkipBreakpointsIcon implements Icon
    {
        SELECTED(true),
        UNSELECTED(false);

        private final boolean selected;

        private SkipBreakpointsIcon(boolean bl) {
            this.selected = bl;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            n += 3;
            n2 += 3;
            graphics.setColor(Color.RED);
            if (this.selected) {
                graphics.drawOval(n, n2, 10, 10);
            } else {
                graphics.fillOval(n, n2, 10, 10);
                graphics.setColor(DARKER_RED);
                graphics.drawOval(n, n2, 10, 10);
            }
            ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
            graphics.setColor(DebuggerIcons.isDarkTheme(component) ? DARKER_GRAY : Color.DARK_GRAY);
            graphics.drawLine(n + 1, n2, n + 10, n2 + 10);
            graphics.setColor(color);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }
}

