/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;

public class Console
extends JTextArea {
    private final StringBuilder buffer;
    private final int maxLines;
    private final Timer throttleTimer = new Timer(16, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Console.this.flush();
        }
    });

    public Console(int n, int n2, int n3, int n4) {
        super(n, n2);
        this.throttleTimer.setRepeats(false);
        this.buffer = new StringBuilder(n3);
        this.maxLines = n4;
    }

    @Override
    public synchronized void append(String string) {
        if (this.buffer.length() + string.length() >= this.buffer.capacity()) {
            this.flush();
        }
        this.buffer.append(string);
        this.throttleTimer.restart();
    }

    public synchronized void flush() {
        super.append(this.buffer.toString());
        this.buffer.setLength(0);
        int n = this.getLineCount();
        if (n > this.maxLines) {
            try {
                this.replaceRange("", 0, this.getLineStartOffset(n - this.maxLines - 1 + this.maxLines / 10));
            }
            catch (BadLocationException badLocationException) {}
        }
        this.setCaretPosition(this.getDocument().getLength());
    }
}

