/*
 * Decompiled with CFR 0.152.
 */
package platform;

import components.input.AbstractSMSInputDevice;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class StdioSMSInputDevice
extends AbstractSMSInputDevice {
    private static final String[] HEX_STRINGS = new String[65536];
    private static final String[] HEX_STRINGS2 = new String[256];
    private final int port;
    private final Process process;
    private final PrintStream out;
    private final InputStream in;
    private int cycleCount;

    static {
        int n = 0;
        while (n < HEX_STRINGS.length) {
            StdioSMSInputDevice.HEX_STRINGS[n] = String.format("%04X", n);
            ++n;
        }
        n = 0;
        while (n < HEX_STRINGS2.length) {
            StdioSMSInputDevice.HEX_STRINGS2[n] = HEX_STRINGS[n].substring(2);
            ++n;
        }
    }

    public StdioSMSInputDevice(int n, final Process process) {
        this.port = n;
        this.process = process;
        this.out = new PrintStream(process.getOutputStream(), true);
        this.in = process.getInputStream();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        System.err.println(string);
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }, "SMSInputDeviceProcess stderr reader").start();
    }

    @Override
    public int readData(int n) {
        this.out.print("r" + this.port + HEX_STRINGS[(n += this.cycleCount) >>> 16] + HEX_STRINGS[n & 0xFFFF] + "\n");
        try {
            return this.readByte();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 255;
        }
    }

    @Override
    public void setPins(boolean bl, boolean bl2, int n) {
        int n2 = (bl2 ? 2 : 0) | (bl ? 1 : 0);
        this.out.print("w" + this.port + n2 + HEX_STRINGS[(n += this.cycleCount) >>> 16] + HEX_STRINGS[n & 0xFFFF] + "\n");
        try {
            this.readAck();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void update(int n) {
        this.cycleCount += n;
    }

    private void readAck() throws IOException {
        this.in.read();
    }

    private int readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            return 255;
        }
        int n2 = this.read();
        if (n2 < 0) {
            return 255;
        }
        return Integer.parseInt(String.valueOf(Character.toString((char)n)) + (char)n2, 16);
    }

    private int read() throws IOException {
        int n = this.in.read();
        while (n >= 0) {
            if (n > 32) break;
            n = this.in.read();
        }
        return n;
    }

    public void shutdown() {
        this.out.print("x ");
        this.process.destroy();
    }
}

