/*
 * Decompiled with CFR 0.152.
 */
package platform;

import components.input.AbstractButtonInputProvider;
import components.input.KeyInputProvider;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.BitSet;

public class KeyboardInput
extends AbstractButtonInputProvider
implements KeyInputProvider {
    private static final int MODIFIERS = 9088;
    private final BitSet keysWithoutModifiers = new BitSet();
    private final BitSet keys = new BitSet();
    private final BitSet mappedButtons = new BitSet();
    private final int[][] buttonMap = new int[2][38];
    private boolean requireWindowFocus;

    public KeyboardInput(Component component) {
        final KeyAdapter keyAdapter = new KeyAdapter(){
            private boolean wasShiftDown;
            private boolean wasAltGraphDown;
            private int keyCodeReplaced = -1;
            private int keyCodeReplacement = -1;

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = this.getKeyCodeHandleNumpadEnter(keyEvent);
                if (n == 17 && (KeyboardInput.this.keys.get(18) || KeyboardInput.this.keys.get(65406)) || n == 18 && (KeyboardInput.this.keys.get(17) || KeyboardInput.this.keys.get(65406))) {
                    KeyboardInput.this.keys.clear(17);
                    KeyboardInput.this.keys.clear(18);
                    KeyboardInput.this.keys.set(65406);
                } else if (!(this.replaceKey(keyEvent, ':', 59, true) || this.replaceKey(keyEvent, '>', 160, true) || this.replaceKey(keyEvent, ';', 59, false) || this.replaceKey(keyEvent, '\\', 92, false) || this.replaceKey(keyEvent, '#', 51, true) || this.replaceKey(keyEvent, '\'', 222, false) || this.replaceKey(keyEvent, '`', 192, false) || this.replaceKey(keyEvent, '\"', 222, true) || this.replaceKey(keyEvent, '@', 50, true) || this.replaceKey(keyEvent, '&', 55, true) || this.replaceKey(keyEvent, '/', 47, false) || this.replaceKey(keyEvent, '*', 56, true) || this.replaceKey(keyEvent, '(', 57, true) || this.replaceKey(keyEvent, ')', 48, true) || this.replaceKey(keyEvent, '^', 54, true) || this.replaceKey(keyEvent, '=', 61, false) || this.replaceKey(keyEvent, '?', 47, true))) {
                    KeyboardInput.this.keys.set(n);
                }
                if (n < 48 || (keyEvent.getModifiersEx() & 0x2380) == 0) {
                    KeyboardInput.this.keysWithoutModifiers.set(n);
                    if (KeyboardInput.this.mappedButtons.get(n)) {
                        KeyboardInput.this.fireButtonPressed();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = this.getKeyCodeHandleNumpadEnter(keyEvent);
                KeyboardInput.this.keysWithoutModifiers.clear(n);
                KeyboardInput.this.keys.clear(n);
                if (n == 17 || n == 18 || n == 16) {
                    if (n == 17 || n == 18) {
                        KeyboardInput.this.keys.clear(65406);
                    }
                    if (this.keyCodeReplaced >= 0) {
                        KeyboardInput.this.keys.clear(this.keyCodeReplacement);
                        if (n != 16) {
                            KeyboardInput.this.keys.set(16, this.wasShiftDown);
                        }
                        if (n != 17 && n != 18) {
                            KeyboardInput.this.keys.set(65406, this.wasAltGraphDown);
                        }
                        this.keyCodeReplaced = -1;
                    }
                }
                if (n == this.keyCodeReplaced) {
                    KeyboardInput.this.keys.clear(this.keyCodeReplacement);
                    KeyboardInput.this.keys.set(16, this.wasShiftDown);
                    KeyboardInput.this.keys.set(65406, this.wasAltGraphDown);
                    this.keyCodeReplaced = -1;
                }
            }

            private int getKeyCodeHandleNumpadEnter(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && keyEvent.getKeyLocation() == 4 && this.getLockingKeyState(144)) {
                    return 266;
                }
                return keyEvent.getKeyCode();
            }

            private boolean getLockingKeyState(int n) {
                try {
                    return Toolkit.getDefaultToolkit().getLockingKeyState(n);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    return false;
                }
            }

            private boolean replaceKey(KeyEvent keyEvent, char c, int n, boolean bl) {
                if (keyEvent.getKeyChar() == c || keyEvent.getKeyCode() == 130 && c == '^' || keyEvent.getKeyCode() == 129 && keyEvent.isShiftDown() && c == '`') {
                    KeyboardInput.this.keys.set(n);
                    if (this.keyCodeReplaced < 0) {
                        this.wasShiftDown = KeyboardInput.this.keys.get(16);
                        this.wasAltGraphDown = KeyboardInput.this.keys.get(65406);
                    }
                    KeyboardInput.this.keys.set(16, bl);
                    KeyboardInput.this.keys.clear(65406);
                    this.keyCodeReplacement = n;
                    this.keyCodeReplaced = keyEvent.getKeyCode();
                    return true;
                }
                return false;
            }
        };
        Component component2 = component;
        while (component != null) {
            component2 = component;
            component.addKeyListener(keyAdapter);
            component = component.getParent();
        }
        final Component component3 = component2;
        component3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (KeyboardInput.this.requireWindowFocus) {
                    KeyboardInput.this.keysWithoutModifiers.clear();
                    KeyboardInput.this.keys.clear();
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getID() == 401 && (!KeyboardInput.this.requireWindowFocus || component3.isFocusOwner())) {
                    keyAdapter.keyPressed(keyEvent);
                } else if (keyEvent.getID() == 402) {
                    keyAdapter.keyReleased(keyEvent);
                }
                return false;
            }
        });
    }

    @Override
    public int[] getButtonMap(int n) {
        return (int[])this.buttonMap[n].clone();
    }

    @Override
    public void setButtonMap(int[][] nArray) {
        this.mappedButtons.clear();
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length && n < this.buttonMap.length) {
                if (nArray[n] != null) {
                    this.buttonMap[n] = (int[])nArray[n].clone();
                    int n2 = 0;
                    while (n2 < nArray[n].length) {
                        int n3 = nArray[n][n2];
                        if (n3 >= 0) {
                            this.mappedButtons.set(n3);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public boolean isRequireWindowFocus() {
        return this.requireWindowFocus;
    }

    @Override
    public void setRequireWindowFocus(boolean bl) {
        this.requireWindowFocus = bl;
    }

    private boolean isButtonDown(int n, int n2) {
        if (n2 < this.buttonMap[n].length && this.buttonMap[n][n2] >= 0) {
            return this.keysWithoutModifiers.get(this.buttonMap[n][n2]);
        }
        return false;
    }

    @Override
    public boolean isButtonDown(int n) {
        return this.isButtonDown(0, n) || this.isButtonDown(1, n);
    }

    @Override
    public boolean isKeyDown(int n) {
        return n >= 0 && this.keys.get(n);
    }
}

