/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.DummyWindow;
import net.java.games.input.WinTabContext;
import net.java.games.input.WinTabDevice;
import net.java.games.util.plugins.Plugin;

public class WinTabEnvironmentPlugin
extends ControllerEnvironment
implements Plugin {
    private static boolean supported = false;
    private final Controller[] controllers;
    private final List<WinTabDevice> active_devices = new ArrayList<WinTabDevice>();
    private final WinTabContext winTabContext;

    static {
        String string = WinTabEnvironmentPlugin.getPrivilegedProperty("os.name", "").trim();
        if (string.startsWith("Windows")) {
            supported = true;
            WinTabEnvironmentPlugin.loadLibrary("jinput-wintab");
        }
    }

    static void loadLibrary(final String string) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    String string2 = System.getProperty("net.java.games.input.librarypath");
                    if (string2 != null) {
                        System.load(String.valueOf(string2) + File.separator + System.mapLibraryName(string));
                    } else {
                        System.loadLibrary(string);
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    unsatisfiedLinkError.printStackTrace();
                    supported = false;
                }
                return null;
            }
        });
    }

    static String getPrivilegedProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
    }

    static String getPrivilegedProperty(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string, string2);
            }
        });
    }

    public WinTabEnvironmentPlugin() {
        if (this.isSupported()) {
            WinTabContext winTabContext = null;
            Controller[] controllerArray = new Controller[]{};
            try {
                DummyWindow dummyWindow = new DummyWindow();
                winTabContext = new WinTabContext(dummyWindow);
                try {
                    winTabContext.open();
                    controllerArray = winTabContext.getControllers();
                }
                catch (Exception exception) {
                    dummyWindow.destroy();
                    throw exception;
                }
            }
            catch (Exception exception) {
                WinTabEnvironmentPlugin.log("Failed to enumerate devices: " + exception.getMessage());
                exception.printStackTrace();
            }
            this.controllers = controllerArray;
            this.winTabContext = winTabContext;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Runtime.getRuntime().addShutdownHook(new ShutdownHook());
                    return null;
                }
            });
        } else {
            this.winTabContext = null;
            this.controllers = new Controller[0];
        }
    }

    @Override
    public boolean isSupported() {
        return supported;
    }

    @Override
    public Controller[] getControllers() {
        return this.controllers;
    }

    private final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public final void run() {
            int n = 0;
            while (n < WinTabEnvironmentPlugin.this.active_devices.size()) {
                ++n;
            }
            WinTabEnvironmentPlugin.this.winTabContext.close();
        }
    }
}

