/*
 * Decompiled with CFR 0.152.
 */
package msx;

import components.cartridge.MSXCartridge;
import filesystem.FAT;
import filesystem.FATUtilities;
import filesystem.MemoryFAT;
import filesystem.MountFAT;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import patching.IPS;
import system.MSX;

public class MSXDisk
extends MSXCartridge {
    private final FAT filesystem;
    private final File filesystemFile;
    private final File msx2parent;
    private boolean filesystemModified;

    public MSXDisk(String string, IPS iPS) throws IOException {
        super(string, iPS);
        this.filesystem = new MemoryFAT(12, this.getRom());
        this.filesystemFile = new File(string);
        boolean bl = new File(this.filesystemFile.getParentFile(), "MSX2.rom").exists() && new File(this.filesystemFile.getParentFile(), "MSX2EXT.rom").exists();
        this.msx2parent = bl ? this.filesystemFile.getParentFile() : null;
    }

    public MSXDisk(File file) throws IOException {
        super(new int[0]);
        this.msx2parent = null;
        this.filesystem = new MountFAT(12, file);
        this.filesystemFile = null;
    }

    public MSXDisk(int[] nArray) {
        super(nArray);
        this.msx2parent = null;
        this.filesystem = null;
        this.filesystemFile = null;
    }

    public File getMSX2parent() {
        return this.msx2parent;
    }

    @Override
    public void processWrite(int n, int n2, int n3) {
    }

    @Override
    public String getID() {
        return "";
    }

    @Override
    public int getInitAddress() {
        return 0;
    }

    @Override
    public int getStatementAddress() {
        return 0;
    }

    @Override
    public int getDeviceAddress() {
        return 0;
    }

    @Override
    public int getTextAddress() {
        return 0;
    }

    public int getBytesPerLogicalSector() {
        try {
            return this.filesystem.getBytesPerLogicalSector();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 512;
        }
    }

    public int handleDSKCHG(int n, int n2, int n3, int n4, int n5) {
        MountFAT mountFAT;
        if (this.filesystem instanceof MountFAT && (mountFAT = (MountFAT)this.filesystem).updateFiles()) {
            return -1;
        }
        return 1;
    }

    public void handleGETDBP(MSX mSX, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6 = this.filesystem.getMediaDescriptor();
        int n7 = this.filesystem.getBytesPerLogicalSector();
        int n8 = this.filesystem.getTotalLogicalSectors();
        int n9 = this.filesystem.getLogicalSectorsPerFileAllocationTable();
        int n10 = this.filesystem.getNumberOfReservedLogicalSectors();
        int n11 = this.filesystem.getLogicalSectorsPerCluster();
        int n12 = this.filesystem.getNumberOfFileAllocationTables();
        int n13 = this.filesystem.getMaxNumberOfRootDirectories();
        int n14 = FATUtilities.getLogicalSectorOfRootDirectory(this.filesystem);
        int n15 = FATUtilities.getLogicalSectorOfDataArea(this.filesystem);
        int n16 = (n8 - n15) / n11;
        int n17 = n16 + 1;
        int n18 = n7 / 32 - 1;
        int n19 = 0;
        while ((n18 & 1 << n19) != 0) {
            ++n19;
        }
        int n20 = n19;
        int n21 = n11 - 1;
        n19 = 0;
        while ((n21 & 1 << n19) != 0) {
            ++n19;
        }
        int n22 = n19 + 1;
        int n23 = n4 + 1;
        mSX.writeByte(n23++, n6, n5);
        mSX.writeByte(n23++, n7 & 0xFF, n5);
        mSX.writeByte(n23++, n7 >> 8, n5);
        mSX.writeByte(n23++, n18, n5);
        mSX.writeByte(n23++, n20, n5);
        mSX.writeByte(n23++, n21, n5);
        mSX.writeByte(n23++, n22, n5);
        mSX.writeByte(n23++, n10 & 0xFF, n5);
        mSX.writeByte(n23++, n10 >> 8, n5);
        mSX.writeByte(n23++, n12, n5);
        mSX.writeByte(n23++, n13, n5);
        mSX.writeByte(n23++, n15 & 0xFF, n5);
        mSX.writeByte(n23++, n15 >> 8, n5);
        mSX.writeByte(n23++, n17 & 0xFF, n5);
        mSX.writeByte(n23++, n17 >> 8, n5);
        mSX.writeByte(n23++, n9, n5);
        mSX.writeByte(n23++, n14 & 0xFF, n5);
        mSX.writeByte(n23++, n14 >> 8, n5);
    }

    public void writeFilesystem(int n, int n2) throws IOException {
        this.filesystem.writeByte(n, n2);
        if (!this.filesystemModified) {
            this.enableShutdownHook();
            this.filesystemModified = true;
        }
    }

    public int readFilesystem(int n) throws IOException {
        return this.filesystem.readByte(n);
    }

    @Override
    public int readByte(int n, int n2) {
        try {
            return this.readFilesystem(n);
        }
        catch (IOException iOException) {
            return 255;
        }
    }

    @Override
    public void writeByte(int n, int n2, int n3) {
        try {
            this.writeFilesystem(n, n2);
        }
        catch (IOException iOException) {}
    }

    @Override
    public void shutdown() {
        if (this.filesystem instanceof MountFAT) {
            MountFAT mountFAT = (MountFAT)this.filesystem;
            mountFAT.finalizePendingWrites();
            mountFAT.finalizePendingDeletions();
        }
        if (this.filesystemModified && this.filesystemFile != null) {
            try {
                this.filesystem.writeToStream(new BufferedOutputStream(new FileOutputStream(this.filesystemFile)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

