/*
 * Decompiled with CFR 0.152.
 */
package json;

import java.util.HashMap;
import java.util.Map;
import json.JSONArray;
import json.JSONParser;

public class JSONObject
extends HashMap<String, String> {
    private static final int MAX_LEN_NUMBER_LITERAL = Integer.toString(Integer.MIN_VALUE).length();

    public String getString(String string) {
        Object v = this.get(string);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public String getString(String string, String string2) {
        String string3 = (String)this.get(string);
        return string3 != null ? string3 : string2;
    }

    public int getInt(String string) {
        return Integer.parseInt((String)this.get(string));
    }

    public int getInt(String string, int n) {
        try {
            return Integer.parseInt((String)this.get(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    public int[] getIntsOptional(String string) {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            return null;
        }
        JSONArray jSONArray = JSONParser.parseArray(string2);
        int[] nArray = new int[jSONArray.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = Integer.parseInt(jSONArray.get(n).toString());
            ++n;
        }
        return nArray;
    }

    public boolean getBoolean(String string) {
        return Boolean.parseBoolean((String)this.get(string));
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = (String)this.get(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public JSONObject getObject(String string) {
        return JSONParser.parse((CharSequence)this.get(string));
    }

    public JSONObject getObjectOptional(String string) {
        String string2 = (String)this.get(string);
        return string2 != null ? JSONParser.parse(string2) : null;
    }

    public JSONArray getArray(String string) {
        return JSONParser.parseArray((CharSequence)this.get(string));
    }

    @Override
    public String put(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.isEmpty()) {
            return super.put(string, string2);
        }
        char c = string2.charAt(0);
        if ("true".equals(string2) || "false".equals(string2) || c == '{' || c == '[' || JSONObject.isNumber(string2)) {
            return super.put(string, " " + string2);
        }
        return super.put(string, string2);
    }

    public String putSuper(String string, String string2) {
        return super.put(string, string2);
    }

    @Override
    public Object put(String string, Object object) {
        if (object == null) {
            return null;
        }
        return super.put(string, object.toString());
    }

    @Override
    public String put(String string, int n) {
        return super.put(string, Integer.toString(n));
    }

    @Override
    public String put(String string, boolean bl) {
        return super.put(string, Boolean.toString(bl));
    }

    @Override
    public String put(String string, JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        return super.put(string, jSONObject.toString());
    }

    @Override
    public String put(String string, JSONArray jSONArray) {
        if (jSONArray == null) {
            return null;
        }
        return super.put(string, jSONArray.toString());
    }

    private static boolean isNumber(String string) {
        if (string.isEmpty() || string.length() > MAX_LEN_NUMBER_LITERAL) {
            return false;
        }
        if (string.charAt(0) != '-' && !Character.isDigit(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isDigit(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"').append((String)entry.getKey()).append('\"').append(':');
            String string = (String)entry.getValue();
            if (string.isEmpty()) {
                stringBuilder.append("\"\"");
                continue;
            }
            char c = string.charAt(0);
            if ("true".equals(string) || "false".equals(string) || c == '{' || c == '[' || JSONObject.isNumber(string)) {
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append('\"').append((c == ' ' ? string.substring(1) : string).replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "\\t").replace("\n", "\\n")).append('\"');
        }
        return "{" + stringBuilder.toString() + "}";
    }
}

