/*
 * Decompiled with CFR 0.152.
 */
package components.video;

import components.video.TMS9918A;

public class V9938
extends TMS9918A {
    private static final boolean DEBUG_COMMANDS = false;
    public static final int DISPLAY_ADJUST_UPDATED = 0x110008;
    private int addressLatch;
    private int addressUpperBits;
    private int paletteIndex;
    private int registerPointer;
    private int displayAdjustH;
    private int displayAdjustV;
    private boolean paletteHiByteNext;
    private boolean pal;
    private int commandSourceY;
    private int commandDestinationY;
    private int commandNumDotsY;
    private boolean commandSourceXset;
    private boolean commandSourceYset;
    private boolean commandDestinationXset;
    private boolean commandDestinationYset;
    private boolean commandNumDotsXset;
    private boolean commandNumDotsYset;
    private int pixelsToPutX;
    private int pixelsToPutReloadX;
    private int pixelsToPutY;
    private int putPixelsX;
    private int putPixelsIncrementX;
    private int putPixelsIncrementY;
    private boolean putPixelsHighSpeed;
    private int pixelsToGetX;
    private int pixelsToGetReloadX;
    private int pixelsToGetY;
    private int getPixelsX;
    private int getPixelsIncrementX;
    private int getPixelsIncrementY;
    private int pixelFoundX;
    private int commandColorCode;
    private int cyclesForCommand;
    protected boolean lineInterruptPending;
    private boolean v9938mode;

    public V9938(boolean bl) {
        super(bl ? 313 : 262, new int[131072], new int[16], new int[47]);
        this.pal = bl;
    }

    public void setV9938mode(boolean bl) {
        this.v9938mode = bl;
    }

    public boolean isV9938mode() {
        return this.v9938mode;
    }

    @Override
    protected boolean isEmulateVdpConstraints() {
        return !this.isV9938mode();
    }

    @Override
    protected int makeModeBits() {
        if (!this.isV9938mode()) {
            return super.makeModeBits();
        }
        return (this.regs[0] & 0xC) << 1 | super.makeModeBits();
    }

    @Override
    public String getModeName(int n) {
        if (n >= 8) {
            n = n & 0xFFFFFFF9 | (n & 2) << 1 | (n & 4) >> 1;
            switch (n) {
                case 8: {
                    return "SCREEN 4";
                }
                case 9: {
                    return "M1-80";
                }
                case 12: {
                    return "SCREEN 5";
                }
                case 16: {
                    return "SCREEN 6";
                }
                case 20: {
                    return "SCREEN 7";
                }
                case 28: {
                    return "SCREEN 8";
                }
            }
            return "Unsupported Mode: " + n;
        }
        return super.getModeName(n);
    }

    @Override
    protected int makeSATaddress() {
        if (this.getModeBits() >= 8) {
            return ((this.regs[11] & 3) << 8 | this.regs[5]) << 7 & 0xFFFFFE00;
        }
        return ((this.regs[11] & 3) << 8 | this.regs[5]) << 7;
    }

    public int getSpriteAttributeIndexMask() {
        if (this.getModeBits() >= 8) {
            return (this.regs[5] & 3) << 3 | 7;
        }
        return -1;
    }

    @Override
    protected int readVRAM(int n) {
        return super.readVRAM(this.addressUpperBits << 14 | n);
    }

    @Override
    protected void writeVRAM(int n, int n2) {
        super.writeVRAM(this.addressUpperBits << 14 | n, n2);
    }

    @Override
    protected void cramWrite(int n, int n2) {
        super.cramWrite(n & 0xF, n2);
    }

    @Override
    public int getAddress() {
        return this.addressUpperBits << 14 | super.getAddress();
    }

    @Override
    protected void renderLine() {
        if (this.getLine() < this.getScreenHeight()) {
            if ((this.getLine() + this.getDisplayOffset() & 0xFF) == this.getInterruptLine()) {
                this.lineInterruptPending = true;
                if (this.isLineInterruptEnabled()) {
                    this.fireOutputAvailable(1114303, 2);
                }
            } else if (!this.isLineInterruptEnabled()) {
                this.lineInterruptPending = false;
            }
            int n = this.regs[18];
            int n2 = this.getLine() == 0 ? -(n >> 4 & 8) | n >> 4 & 7 : this.displayAdjustV;
            int n3 = -(n & 8) | n & 7;
            boolean bl = n2 != this.displayAdjustV || n3 != this.displayAdjustH;
            this.displayAdjustV = n2;
            this.displayAdjustH = n3;
            if (bl) {
                this.fireOutputAvailable(0x110008, n);
            }
        }
        super.renderLine();
    }

    @Override
    protected boolean isLineInterruptEnabled() {
        return (this.regs[0] & 0x10) != 0;
    }

    @Override
    protected void handleIncreaseAddress() {
        if (this.getModeBits() < 8) {
            super.handleIncreaseAddress();
            return;
        }
        int n = this.getAddress();
        super.handleIncreaseAddress();
        if (this.getAddress() < n) {
            this.addressUpperBits = this.addressUpperBits + 1 & 7;
        }
    }

    @Override
    public int getTextColor(int n, int n2) {
        if (this.getModeBits() == 9) {
            int n3 = this.getLine();
            if (n3 >= this.getScreenHeight()) {
                return super.getTextColor(n, n2);
            }
            if (!this.isBlinkOn()) {
                return super.getTextColor(n, n2);
            }
            int n4 = n3 / 8;
            int n5 = n2 + 10 * n4 + n / 8;
            int n6 = n & 7 ^ 7;
            if ((this.vram[n5] & 1 << n6) != 0) {
                return this.getBlinkColor() >> 4;
            }
        }
        return super.getTextColor(n, n2);
    }

    @Override
    public int getBackDropColor(int n, int n2) {
        if (this.getModeBits() == 9) {
            int n3;
            if (n == 0) {
                return super.getBackDropColor(0, n2);
            }
            int n4 = n / 6;
            if (n4 >= 80) {
                return super.getBackDropColor(0, n2);
            }
            if (!this.isBlinkOn()) {
                return super.getBackDropColor(0, n2);
            }
            int n5 = this.getLine() / 8;
            int n6 = n2 + 10 * n5 + n4 / 8;
            if ((this.vram[n6] & 1 << (n3 = n4 & 7 ^ 7)) != 0) {
                return this.getBlinkColor() & 0xF;
            }
            return super.getBackDropColor(0, n2);
        }
        return super.getBackDropColor(n, n2);
    }

    private boolean isBlinkOn() {
        return this.getBlinkPeriod() >> 4 > 0;
    }

    @Override
    public int getColorTableAddress() {
        if (this.getModeBits() == 8) {
            return (this.regs[10] & 7) << 14 | super.getColorTableAddress() & 0xFFFFE000;
        }
        if (this.getModeBits() == 9) {
            return (this.regs[10] & 7) << 14 | super.getColorTableAddress() & 0xFFFFFE00;
        }
        return super.getColorTableAddress();
    }

    @Override
    public int getColorTableMask() {
        if (this.getModeBits() == 8) {
            return this.regs[3] << 6 | 0xFFC07F;
        }
        return super.getColorTableMask();
    }

    @Override
    public int getPatternGeneratorTableAddress() {
        if (this.getModeBits() == 8) {
            return (this.regs[4] & 0x3F) << 11 & 0xFFFFE000;
        }
        if (this.getModeBits() == 9) {
            return (this.regs[4] & 0x3F) << 11;
        }
        return super.getPatternGeneratorTableAddress();
    }

    @Override
    public int getPatternGeneratorTableMask() {
        if (this.getModeBits() == 8) {
            return (this.regs[4] & 7) << 11 | 0xFFC7FF;
        }
        return super.getPatternGeneratorTableMask();
    }

    @Override
    public int getScreenMapBaseAddress() {
        if (this.getModeBits() >= 10) {
            return (this.regs[2] & 0x60) << 10;
        }
        return (this.regs[2] & 0x7F) << 10;
    }

    @Override
    public int getScreenMapBaseAddress(int n) {
        if (this.getModeBits() == 9) {
            return super.getScreenMapBaseAddress(n) & 0xFFFFF000;
        }
        return super.getScreenMapBaseAddress(n);
    }

    @Override
    public int getSpritePatternAddress() {
        return (this.regs[6] & 0x3F) << 11;
    }

    @Override
    public int getScreenHeight() {
        if (this.isOverscan()) {
            return 212;
        }
        return super.getScreenHeight();
    }

    private boolean isOverscan() {
        return (this.regs[9] & 0x80) != 0;
    }

    @Override
    public int getLinesBottomBorder() {
        return super.getLinesBottomBorder() + this.getDisplayAdjustVertical();
    }

    @Override
    public int getDisplayAdjustHorizontal() {
        return this.displayAdjustH;
    }

    @Override
    public int getDisplayAdjustVertical() {
        return this.displayAdjustV;
    }

    @Override
    public int getDisplayOffset() {
        return this.regs[23];
    }

    private int getInterruptLine() {
        return this.regs[19];
    }

    private int getBlinkColor() {
        return this.regs[12];
    }

    private int getBlinkPeriod() {
        return this.regs[13];
    }

    private int getStatusRegisterIndex() {
        return this.regs[15] & 0xF;
    }

    private boolean isAutoIncrementRegisterPointer() {
        return (this.regs[17] & 0x80) == 0;
    }

    @Override
    public boolean hasTransparency() {
        return (this.regs[8] & 0x20) == 0;
    }

    @Override
    public boolean isSpritesDisabled() {
        return (this.regs[8] & 2) != 0;
    }

    @Override
    public int getScanlines() {
        return this.pal ? 313 : 262;
    }

    @Override
    public void processInput(int n, int n2, int n3) {
        if (!this.v9938mode) {
            n &= 1;
        }
        if (n >= 2) {
            this.update(n3);
            switch (n) {
                case 2: {
                    this.processInputPort2(n2);
                    break;
                }
                case 3: {
                    if (this.registerPointer != 17) {
                        this.regWrite(this.registerPointer, n2);
                    }
                    if (!this.isAutoIncrementRegisterPointer()) break;
                    this.registerPointer = this.registerPointer + 1 & 0x3F;
                }
            }
            this.timer += n3;
        } else {
            super.processInput(n, n2, n3);
        }
        this.cyclesForCommand += n3;
    }

    @Override
    protected void processInputPort1(int n) {
        if (!this.v9938mode) {
            super.processInputPort1(n);
        } else if (!this.hiByteNext) {
            this.addressLatch = n;
            this.hiByteNext = !this.hiByteNext;
        } else {
            this.hiByteNext = false;
            int n2 = this.regAddress;
            super.processInputPort1(this.addressLatch);
            super.processInputPort1(n);
            if ((n & 0x80) != 0) {
                this.regAddress = n2;
            }
        }
    }

    private void processInputPort2(int n) {
        int n2 = this.paletteHiByteNext ? n << 8 | this.cram[this.paletteIndex] & 0xFF : this.cram[this.paletteIndex] & 0xFF00 | n;
        boolean bl = this.cram[this.paletteIndex] != n2;
        this.fireOutputAvailable(0x110002, n << 8 | (this.paletteHiByteNext ? this.paletteIndex << 1 | 1 : this.paletteIndex << 1));
        this.cram[this.paletteIndex] = n2;
        this.fireOutputAvailable(0x110003, bl ? 0x10 | this.paletteIndex : this.paletteIndex);
        boolean bl2 = this.paletteHiByteNext = !this.paletteHiByteNext;
        if (!this.paletteHiByteNext) {
            this.paletteIndex = this.paletteIndex + 1 & 0xF;
        }
    }

    private boolean isBusy() {
        return this.pixelsToPutX + this.pixelsToPutY + this.pixelsToGetX + this.pixelsToGetY > 0 || this.cyclesForCommand > 0;
    }

    private boolean isDataReady() {
        return this.pixelsToPutX + this.pixelsToPutY + this.pixelsToGetX + this.pixelsToGetY > 0;
    }

    private boolean isSearchFound() {
        return this.pixelFoundX >= 0;
    }

    @Override
    public int getSpritesDoneY() {
        if (!this.v9938mode || this.getModeBits() < 8) {
            return super.getSpritesDoneY();
        }
        return 216;
    }

    @Override
    public void update(int n) {
        super.update(n);
        if (this.cyclesForCommand - n < this.cyclesForCommand) {
            this.cyclesForCommand -= n;
        }
    }

    @Override
    public int readByte(int n, int n2) {
        this.update(n2);
        boolean bl = this.lineInterruptPending;
        if (n == 0 || this.getStatusRegisterIndex() == 0) {
            this.timer += n2;
            this.cyclesForCommand += n2;
            int n3 = super.readByte(n, n2);
            this.lineInterruptPending = bl;
            return n3;
        }
        if (this.hiByteNext) {
            this.fireOutputAvailable(0x110013, this.getAddress());
        }
        this.hiByteNext = false;
        this.fireOutputAvailable(0x110006, this.getStatusRegisterIndex());
        int n4 = -1;
        switch (this.getStatusRegisterIndex()) {
            case 1: {
                this.lineInterruptPending = false;
                if ((this.regStatus & 0x80) == 0 || !this.isFrameInterruptEnabled()) {
                    this.fireOutputAvailable(1114303, -1);
                }
                n4 = bl ? 1 : 0;
                break;
            }
            case 2: {
                n4 = (this.isDataReady() ? 128 : 0) | (this.getLine() >= this.getScreenHeight() ? 64 : 0) | (this.timer >= 20 && this.timer <= 212 ? 32 : 0) | (this.isSearchFound() ? 16 : 0) | 0xC | (this.isBusy() ? 1 : 0);
                break;
            }
            case 7: {
                n4 = this.commandColorCode;
                this.fetchNextPixel();
                break;
            }
            case 8: {
                n4 = this.pixelFoundX & 0xFF;
                break;
            }
            case 9: {
                n4 = 0xFE | this.pixelFoundX >> 8 & 1;
                break;
            }
            default: {
                System.err.println("Reading unsupported VDP status register " + this.getStatusRegisterIndex());
            }
        }
        this.cyclesForCommand += n2;
        this.timer += n2;
        if (n4 >= 0) {
            return n4;
        }
        n4 = super.readByte(n, n2);
        this.cyclesForCommand += n2;
        return n4;
    }

    @Override
    protected void regWrite(int n, int n2, boolean bl) {
        if ((n &= this.v9938mode ? 63 : 7) >= this.regs.length) {
            return;
        }
        if (!this.v9938mode || n < 8) {
            super.regWrite(n, n2, bl);
            return;
        }
        int n3 = this.regs[n] ^ n2;
        if (!bl) {
            this.fireOutputAvailable(0x110011, n2 << 8 | n);
        }
        this.regs[n] = n2;
        this.fireOutputAvailable(0x110012, n2 << 16 | (n2 ^ n3) << 8 | n);
        switch (n) {
            case 8: {
                if ((n2 & 0xFFFFFFD5) == 0) break;
                System.err.println("Unhandled write of value " + Integer.toHexString(n2) + " to VDP register " + Integer.toHexString(n));
                break;
            }
            case 9: {
                boolean bl2 = this.pal;
                boolean bl3 = this.pal = (n2 & 2) != 0;
                if ((n3 & 0x80) != 0 || this.pal ^ bl2) {
                    this.fireOutputAvailable(0x110001, this.getModeBits());
                }
                if ((n2 & 0xFFFFFF7D) == 0) break;
                System.err.println("Unhandled write of value " + Integer.toHexString(n2) + " to VDP register " + Integer.toHexString(n));
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                this.addressUpperBits = n2 & 7;
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                this.paletteIndex = n2 & 0xF;
                break;
            }
            case 17: {
                this.registerPointer = n2 & 0x3F;
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                break;
            }
            case 32: 
            case 33: {
                this.commandSourceXset = true;
                break;
            }
            case 34: {
                this.commandSourceY = this.commandSourceY & 0x300 | n2;
                this.commandSourceYset = true;
                break;
            }
            case 35: {
                this.commandSourceY = (n2 & 3) << 8 | this.commandSourceY & 0xFF;
                this.commandSourceYset = true;
                break;
            }
            case 36: 
            case 37: {
                this.commandDestinationXset = true;
                break;
            }
            case 38: {
                this.commandDestinationY = this.commandDestinationY & 0x300 | n2;
                this.commandDestinationYset = true;
                break;
            }
            case 39: {
                this.commandDestinationY = (n2 & 3) << 8 | this.commandDestinationY & 0xFF;
                this.commandDestinationYset = true;
                break;
            }
            case 40: 
            case 41: {
                this.commandNumDotsXset = true;
                break;
            }
            case 42: {
                this.commandNumDotsY = this.commandNumDotsY & 0x300 | n2;
                this.commandNumDotsYset = true;
                break;
            }
            case 43: {
                this.commandNumDotsY = (n2 & 3) << 8 | this.commandNumDotsY & 0xFF;
                this.commandNumDotsYset = true;
                break;
            }
            case 44: {
                this.putNextPixel();
                break;
            }
            case 45: {
                break;
            }
            case 46: {
                this.executeCommand(n2 >> 4);
                break;
            }
            default: {
                System.err.println("Unhandled write of value " + Integer.toHexString(n2) + " to VDP register " + Integer.toHexString(n));
            }
        }
    }

    private int getCommandSourceX() {
        return (this.regs[33] & 1) << 8 | this.regs[32];
    }

    private int getCommandDestinationX() {
        return (this.regs[37] & 1) << 8 | this.regs[36];
    }

    private int getCommandNumDotsX() {
        return (this.regs[41] & 1) << 8 | this.regs[40];
    }

    private int getCommandData() {
        return this.regs[44];
    }

    private int getCommandArgument() {
        return this.regs[45];
    }

    private int getCommandFlags() {
        return this.regs[46] & 0xF;
    }

    private void executeCommand(int n) {
        switch (n) {
            case 0: {
                this.pixelsToGetX = 0;
                this.pixelsToGetY = 0;
                this.pixelsToPutX = 0;
                this.pixelsToPutY = 0;
                break;
            }
            case 4: {
                if ((this.getCommandArgument() & 0x20) != 0) {
                    System.err.println("External VRAM not supported");
                    return;
                }
                this.commandColorCode = this.getPixel(this.getCommandSourceX(), this.commandSourceY, false);
                break;
            }
            case 5: {
                this.putPixel(this.getCommandDestinationX(), this.commandDestinationY, this.getCommandData(), (this.getCommandArgument() & 0x20) != 0);
                break;
            }
            case 6: {
                this.searchPixel(this.getCommandSourceX(), this.commandSourceY, -((this.getCommandArgument() & 4) >> 2) | 1, this.getCommandData(), (this.getCommandArgument() & 2) != 0, (this.getCommandArgument() & 0x20) != 0);
                break;
            }
            case 7: {
                this.drawLine(this.getCommandDestinationX(), this.commandDestinationY, -((this.getCommandArgument() & 4) >> 2) | 1, -((this.getCommandArgument() & 8) >> 3) | 1, this.getCommandNumDotsX(), this.commandNumDotsY, this.getCommandData(), (this.getCommandArgument() & 1) != 0, (this.getCommandArgument() & 0x20) != 0);
                break;
            }
            case 8: {
                this.fillRectangle(this.getCommandDestinationX(), this.commandDestinationY, -((this.getCommandArgument() & 4) >> 2) | 1, -((this.getCommandArgument() & 8) >> 3) | 1, this.getCommandNumDotsX(), this.commandNumDotsY, this.getCommandData(), (this.getCommandArgument() & 0x20) != 0, false);
                break;
            }
            case 9: {
                this.copyRectangle(this.getCommandSourceX(), this.commandSourceY, this.getCommandDestinationX(), this.commandDestinationY, -((this.getCommandArgument() & 4) >> 2) | 1, -((this.getCommandArgument() & 8) >> 3) | 1, this.getCommandNumDotsX(), this.commandNumDotsY, (this.getCommandArgument() & 0x10) != 0, (this.getCommandArgument() & 0x20) != 0, false);
                break;
            }
            case 10: {
                this.getPixels(this.getCommandSourceX(), this.commandSourceY, -((this.getCommandArgument() & 4) >> 2) | 1, -((this.getCommandArgument() & 8) >> 3) | 1, this.getCommandNumDotsX(), this.commandNumDotsY, (this.getCommandArgument() & 0x20) != 0);
                break;
            }
            case 11: {
                this.putPixels(this.getCommandDestinationX(), this.commandDestinationY, -((this.getCommandArgument() & 4) >> 2) | 1, -((this.getCommandArgument() & 8) >> 3) | 1, this.getCommandNumDotsX(), this.commandNumDotsY, (this.getCommandArgument() & 0x20) != 0, false);
                break;
            }
            case 12: {
                this.fillRectangle(this.getCommandDestinationX(), this.commandDestinationY, -((this.getCommandArgument() & 4) >> 2) | 1, -((this.getCommandArgument() & 8) >> 3) | 1, this.getCommandNumDotsX(), this.commandNumDotsY, this.getCommandData(), (this.getCommandArgument() & 0x20) != 0, true);
                break;
            }
            case 13: {
                this.copyRectangle(this.getCommandSourceX(), this.commandSourceY, this.getCommandDestinationX(), this.commandDestinationY, -((this.getCommandArgument() & 4) >> 2) | 1, -((this.getCommandArgument() & 8) >> 3) | 1, this.getCommandNumDotsX(), this.commandNumDotsY, (this.getCommandArgument() & 0x10) != 0, (this.getCommandArgument() & 0x20) != 0, true);
                break;
            }
            case 14: {
                this.copyVertically(this.commandSourceY, this.getCommandDestinationX(), this.commandDestinationY, -((this.getCommandArgument() & 4) >> 2) | 1, -((this.getCommandArgument() & 8) >> 3) | 1, this.commandNumDotsY, (this.getCommandArgument() & 0x20) != 0);
                break;
            }
            case 15: {
                this.putPixels(this.getCommandDestinationX(), this.commandDestinationY, -((this.getCommandArgument() & 4) >> 2) | 1, -((this.getCommandArgument() & 8) >> 3) | 1, this.getCommandNumDotsX(), this.commandNumDotsY, (this.getCommandArgument() & 0x20) != 0, true);
                break;
            }
            default: {
                System.err.println("Unhandled command " + Integer.toHexString(n));
            }
        }
        if (n != 5) {
            this.commandSourceXset = false;
            this.commandSourceYset = false;
            this.commandDestinationXset = false;
            this.commandDestinationYset = false;
            if (n != 7) {
                this.commandNumDotsXset = false;
                this.commandNumDotsYset = false;
            }
        }
    }

    private void searchPixel(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (bl2) {
            System.err.println("External VRAM not supported");
            return;
        }
        this.pixelFoundX = -1;
        int n5 = this.getModeBits();
        if (n5 >= 8) {
            int n6;
            n5 = n5 & 0xFFFFFFF9 | (n5 & 2) << 1 | (n5 & 4) >> 1;
            switch (n5) {
                default: {
                    n6 = 256;
                    break;
                }
                case 16: {
                    n6 = 512;
                    break;
                }
                case 20: {
                    n6 = 512;
                    break;
                }
                case 28: {
                    n6 = 256;
                }
            }
            int n7 = n3 > 0 ? n6 - n : n + 1;
            int n8 = 0;
            while (n8 < n7) {
                if (this.getPixel(n + n8 * n3, n2, false) == n4 == bl) {
                    this.pixelFoundX = n + n8 * n3;
                    break;
                }
                ++n8;
            }
        }
    }

    private void drawLine(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        if (bl2) {
            System.err.println("External VRAM not supported");
            return;
        }
        int n8 = n3;
        int n9 = n4;
        int n10 = bl ? n6 : n5;
        int n11 = bl ? n5 : n6;
        int n12 = n10;
        int n13 = -n11;
        int n14 = n + n10 * n3;
        int n15 = n2 + n11 * n4;
        int n16 = n12 + n13;
        while (true) {
            this.setPixel(n, n2, n7, false);
            if (n == n14 && n2 == n15) break;
            int n17 = 2 * n16;
            if (n17 > n13) {
                n16 += n13;
                n += n8;
            }
            if (n17 >= n12) continue;
            n16 += n12;
            n2 += n9;
        }
    }

    private void putPixel(int n, int n2, int n3, boolean bl) {
        if (bl) {
            System.err.println("External VRAM not supported");
            return;
        }
        this.setPixel(n, n2, n3, false);
    }

    private void putPixels(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        if (bl) {
            System.err.println("External VRAM not supported");
            return;
        }
        int n7 = this.getModeBits();
        if (n7 >= 8) {
            int n8;
            int n9;
            n7 = n7 & 0xFFFFFFF9 | (n7 & 2) << 1 | (n7 & 4) >> 1;
            switch (n7) {
                default: {
                    n9 = 256;
                    n8 = 4;
                    break;
                }
                case 16: {
                    n9 = 512;
                    n8 = 2;
                    break;
                }
                case 20: {
                    n9 = 512;
                    n8 = 4;
                    break;
                }
                case 28: {
                    n9 = 256;
                    n8 = 8;
                }
            }
            if (n5 == 0) {
                n5 = n9;
            }
            int n10 = 8 / n8;
            this.putPixelsIncrementX = (bl2 ? n10 : 1) * n3;
            this.putPixelsIncrementY = n4;
            if (bl2) {
                n &= ~(n10 - 1);
                n5 &= ~(n10 - 1);
            }
            this.pixelsToPutReloadX = n5;
            if (n + n5 * n3 > n9) {
                this.pixelsToPutReloadX = n9 - n;
            } else if (n + n5 * n3 < 0) {
                this.pixelsToPutReloadX = n + 1;
            }
            this.pixelsToPutX = this.pixelsToPutReloadX;
            this.pixelsToPutY = n6;
            this.putPixelsX = n;
            this.commandDestinationY = n2;
            this.putPixelsHighSpeed = bl2;
            this.putNextPixel();
        }
    }

    private void putNextPixel() {
        if (this.pixelsToPutX + this.pixelsToPutY > 0) {
            this.setPixel(this.putPixelsX, this.commandDestinationY, this.getCommandData(), this.putPixelsHighSpeed);
            this.putPixelsX += this.putPixelsIncrementX;
            if ((this.pixelsToPutX -= Math.abs(this.putPixelsIncrementX)) <= 0 && --this.pixelsToPutY > 0) {
                this.putPixelsX = this.getCommandDestinationX();
                this.pixelsToPutX = this.pixelsToPutReloadX;
                this.commandDestinationY += this.putPixelsIncrementY;
                if (this.commandDestinationY < 0 || this.commandDestinationY >= 1024) {
                    this.pixelsToPutX = 0;
                    this.commandNumDotsY = this.pixelsToPutY;
                    this.pixelsToPutY = 0;
                }
            }
        }
    }

    private void getPixels(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (bl) {
            System.err.println("External VRAM not supported");
            return;
        }
        int n7 = this.getModeBits();
        if (n7 >= 8) {
            int n8;
            n7 = n7 & 0xFFFFFFF9 | (n7 & 2) << 1 | (n7 & 4) >> 1;
            switch (n7) {
                default: {
                    n8 = 256;
                    break;
                }
                case 16: {
                    n8 = 512;
                    break;
                }
                case 20: {
                    n8 = 512;
                    break;
                }
                case 28: {
                    n8 = 256;
                }
            }
            if (n5 == 0) {
                n5 = n8;
            }
            this.getPixelsIncrementX = n3;
            this.getPixelsIncrementY = n4;
            this.pixelsToGetReloadX = n5;
            if (n + n5 * n3 > n8) {
                this.pixelsToGetReloadX = n8 - n;
            } else if (n + n5 * n3 < 0) {
                this.pixelsToGetReloadX = n + 1;
            }
            this.pixelsToGetX = this.pixelsToGetReloadX;
            this.pixelsToGetY = n6;
            this.getPixelsX = n;
            this.commandSourceY = n2;
            this.fetchNextPixel();
        }
    }

    private void fetchNextPixel() {
        if (this.pixelsToGetX + this.pixelsToGetY > 0) {
            this.commandColorCode = this.getPixel(this.getPixelsX, this.commandSourceY, false);
            this.getPixelsX += this.getPixelsIncrementX;
            if ((this.pixelsToGetX -= Math.abs(this.getPixelsIncrementX)) <= 0 && --this.pixelsToGetY > 0) {
                this.getPixelsX = this.getCommandSourceX();
                this.pixelsToGetX = this.pixelsToGetReloadX;
                this.commandSourceY += this.getPixelsIncrementY;
                if (this.commandSourceY < 0 || this.commandSourceY >= 1024) {
                    this.pixelsToGetX = 0;
                    this.commandNumDotsY = this.pixelsToGetY;
                    this.pixelsToGetY = 0;
                }
            }
        }
    }

    private void copyVertically(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = this.getModeBits();
        if (n7 >= 8) {
            int n8;
            n7 = n7 & 0xFFFFFFF9 | (n7 & 2) << 1 | (n7 & 4) >> 1;
            switch (n7) {
                default: {
                    n8 = 256;
                    break;
                }
                case 16: {
                    n8 = 512;
                    break;
                }
                case 20: {
                    n8 = 512;
                    break;
                }
                case 28: {
                    n8 = 256;
                }
            }
            int n9 = n2;
            int n10 = n4 > 0 ? n8 - n2 : n2;
            this.copyRectangle(n9, n, n2, n3, n4, n5, n10, n6, bl, bl, true);
        }
    }

    private void copyRectangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, boolean bl3) {
        if (bl || bl2) {
            System.err.println("External VRAM not supported");
            return;
        }
        int n9 = this.getModeBits();
        if (n9 >= 8) {
            int n10;
            int n11;
            int n12;
            n9 = n9 & 0xFFFFFFF9 | (n9 & 2) << 1 | (n9 & 4) >> 1;
            switch (n9) {
                default: {
                    n12 = 256;
                    n11 = 4;
                    break;
                }
                case 16: {
                    n12 = 512;
                    n11 = 2;
                    break;
                }
                case 20: {
                    n12 = 512;
                    n11 = 4;
                    break;
                }
                case 28: {
                    n12 = 256;
                    n11 = 8;
                }
            }
            if (n7 == 0) {
                n7 = n12;
            }
            int n13 = 8 / n11;
            int n14 = n10 = bl3 ? n13 : 1;
            if (bl3) {
                n &= ~(n13 - 1);
                n3 &= ~(n13 - 1);
                n7 &= ~(n13 - 1);
            }
            int n15 = 0;
            while (n15 < n8) {
                int n16 = 0;
                while (n16 < n7) {
                    this.setPixel(n3 + n16 * n5, n4 + n15 * n6, this.getPixel(n + n16 * n5, n2 + n15 * n6, bl3), bl3);
                    n16 += n10;
                }
                ++n15;
            }
            this.cyclesForCommand = (n8 - 1) * n7 * 5 + 3 * n7;
        }
    }

    private void fillRectangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        if (bl) {
            System.err.println("External VRAM not supported");
            return;
        }
        int n8 = this.getModeBits();
        if (n8 >= 8) {
            int n9;
            int n10;
            int n11;
            n8 = n8 & 0xFFFFFFF9 | (n8 & 2) << 1 | (n8 & 4) >> 1;
            switch (n8) {
                default: {
                    n11 = 256;
                    n10 = 4;
                    break;
                }
                case 16: {
                    n11 = 512;
                    n10 = 2;
                    break;
                }
                case 20: {
                    n11 = 512;
                    n10 = 4;
                    break;
                }
                case 28: {
                    n11 = 256;
                    n10 = 8;
                }
            }
            if (n5 == 0) {
                n5 = n11;
            }
            if (n6 == 0) {
                n6 = this.getScreenHeight();
            }
            int n12 = 8 / n10;
            int n13 = n9 = bl2 ? n12 : 1;
            if (bl2) {
                n &= ~(n12 - 1);
                n5 &= ~(n12 - 1);
            }
            int n14 = 0;
            while (n14 < n6) {
                int n15 = 0;
                while (n15 < n5) {
                    this.setPixel(n + n15 * n3, n2 + n14 * n4, n7, bl2);
                    n15 += n9;
                }
                ++n14;
            }
            this.cyclesForCommand = (n6 - 1) * n5 * 5 + 3 * n5;
        }
    }

    private void setPixel(int n, int n2, int n3, boolean bl) {
        int n4 = this.getModeBits();
        if (n4 >= 8) {
            int n5;
            int n6;
            n4 = n4 & 0xFFFFFFF9 | (n4 & 2) << 1 | (n4 & 4) >> 1;
            switch (n4) {
                default: {
                    n6 = 256;
                    n5 = 4;
                    break;
                }
                case 16: {
                    n6 = 512;
                    n5 = 2;
                    break;
                }
                case 20: {
                    n6 = 512;
                    n5 = 4;
                    break;
                }
                case 28: {
                    n6 = 256;
                    n5 = 8;
                }
            }
            if (n < 0 || n >= n6) {
                return;
            }
            int n7 = 8 / n5;
            int n8 = n2 * n6 * n5 / 8 + n / n7 & this.vram.length - 1;
            if (bl) {
                this.vram[n8] = n3;
                return;
            }
            int n9 = (1 << n5) - 1;
            if ((this.getCommandFlags() & 8) != 0 && (n3 &= n9) == 0) {
                return;
            }
            block5 : switch (this.getCommandFlags() & 7) {
                case 4: {
                    n3 = ~n3 & n9;
                }
                case 0: {
                    if (n5 == 8) {
                        this.vram[n8] = n3;
                        break;
                    }
                    if (n5 == 4) {
                        this.vram[n8] = n % n7 == 0 ? n3 << 4 | this.vram[n8] & 0xF : this.vram[n8] & 0xF0 | n3;
                        break;
                    }
                    if (n5 != 2) break;
                    switch (n % n7) {
                        case 0: {
                            this.vram[n8] = n3 << 6 | this.vram[n8] & 0x3F;
                            break;
                        }
                        case 1: {
                            this.vram[n8] = n3 << 4 | this.vram[n8] & 0xCF;
                            break;
                        }
                        case 2: {
                            this.vram[n8] = n3 << 2 | this.vram[n8] & 0xF3;
                            break;
                        }
                        case 3: {
                            this.vram[n8] = this.vram[n8] & 0xFC | n3;
                        }
                    }
                    break;
                }
                case 1: {
                    if (n5 == 8) {
                        int n10 = n8;
                        this.vram[n10] = this.vram[n10] & n3;
                        break;
                    }
                    if (n5 == 4) {
                        int n11 = n8;
                        this.vram[n11] = this.vram[n11] & (n % n7 == 0 ? n3 << 4 | 0xF : 0xF0 | n3);
                        break;
                    }
                    if (n5 != 2) break;
                    switch (n % n7) {
                        case 0: {
                            int n12 = n8;
                            this.vram[n12] = this.vram[n12] & (n3 << 6 | 0x3F);
                            break;
                        }
                        case 1: {
                            int n13 = n8;
                            this.vram[n13] = this.vram[n13] & (n3 << 4 | 0xCF);
                            break;
                        }
                        case 2: {
                            int n14 = n8;
                            this.vram[n14] = this.vram[n14] & (n3 << 2 | 0xF3);
                            break;
                        }
                        case 3: {
                            int n15 = n8;
                            this.vram[n15] = this.vram[n15] & (0xFC | n3);
                        }
                    }
                    break;
                }
                case 2: {
                    if (n5 == 8) {
                        int n16 = n8;
                        this.vram[n16] = this.vram[n16] | n3;
                        break;
                    }
                    if (n5 == 4) {
                        int n17 = n8;
                        this.vram[n17] = this.vram[n17] | (n % n7 == 0 ? n3 << 4 : n3);
                        break;
                    }
                    if (n5 != 2) break;
                    switch (n % n7) {
                        case 0: {
                            int n18 = n8;
                            this.vram[n18] = this.vram[n18] | n3 << 6;
                            break;
                        }
                        case 1: {
                            int n19 = n8;
                            this.vram[n19] = this.vram[n19] | n3 << 4;
                            break;
                        }
                        case 2: {
                            int n20 = n8;
                            this.vram[n20] = this.vram[n20] | n3 << 2;
                            break;
                        }
                        case 3: {
                            int n21 = n8;
                            this.vram[n21] = this.vram[n21] | n3;
                        }
                    }
                    break;
                }
                case 3: {
                    if (n5 == 8) {
                        int n22 = n8;
                        this.vram[n22] = this.vram[n22] ^ n3;
                        break;
                    }
                    if (n5 == 4) {
                        int n23 = n8;
                        this.vram[n23] = this.vram[n23] ^ (n % n7 == 0 ? n3 << 4 : n3);
                        break;
                    }
                    if (n5 != 2) break;
                    switch (n % n7) {
                        case 0: {
                            int n24 = n8;
                            this.vram[n24] = this.vram[n24] ^ n3 << 6;
                            break block5;
                        }
                        case 1: {
                            int n25 = n8;
                            this.vram[n25] = this.vram[n25] ^ n3 << 4;
                            break block5;
                        }
                        case 2: {
                            int n26 = n8;
                            this.vram[n26] = this.vram[n26] ^ n3 << 2;
                            break block5;
                        }
                        case 3: {
                            int n27 = n8;
                            this.vram[n27] = this.vram[n27] ^ n3;
                        }
                    }
                }
            }
        }
    }

    private int getPixel(int n, int n2, boolean bl) {
        int n3 = this.getModeBits();
        if (n3 >= 8) {
            int n4;
            int n5;
            n3 = n3 & 0xFFFFFFF9 | (n3 & 2) << 1 | (n3 & 4) >> 1;
            switch (n3) {
                default: {
                    n5 = 256;
                    n4 = 4;
                    break;
                }
                case 16: {
                    n5 = 512;
                    n4 = 2;
                    break;
                }
                case 20: {
                    n5 = 512;
                    n4 = 4;
                    break;
                }
                case 28: {
                    n5 = 256;
                    n4 = 8;
                }
            }
            if (n < 0 || n >= n5) {
                return 0;
            }
            int n6 = 8 / n4;
            int n7 = n2 * n5 * n4 / 8 + n / n6 & this.vram.length - 1;
            if (bl || n4 == 8) {
                return this.vram[n7];
            }
            if (n4 == 4) {
                return n % n6 == 0 ? this.vram[n7] >> 4 : this.vram[n7] & 0xF;
            }
            if (n4 == 2) {
                switch (n % n6) {
                    case 0: {
                        return this.vram[n7] >> 6;
                    }
                    case 1: {
                        return this.vram[n7] >> 4 & 3;
                    }
                    case 2: {
                        return this.vram[n7] >> 2 & 3;
                    }
                    case 3: {
                        return this.vram[n7] & 3;
                    }
                }
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void reset() {
        this.addressUpperBits = 0;
        this.paletteIndex = 0;
        this.registerPointer = 0;
        this.paletteHiByteNext = false;
        this.pixelsToPutX = 0;
        this.pixelsToPutY = 0;
        this.pixelsToGetX = 0;
        this.pixelsToGetY = 0;
        this.pixelFoundX = -1;
        this.cyclesForCommand = 0;
        super.reset();
    }

    @Override
    public int getColorGreen(int n) {
        return (this.cram[n] & 0x700) >> 8;
    }

    @Override
    public int getColorRed(int n) {
        return (this.cram[n] & 0x70) >> 4;
    }

    @Override
    public int getColorBlue(int n) {
        return this.cram[n] & 7;
    }

    @Override
    public int getColorMaxIntensity() {
        return 7;
    }
}

