/*
 * Decompiled with CFR 0.152.
 */
package components.input;

import components.input.ButtonInputProvider;
import components.input.SMSJoypad;

public class MDJoypad3
extends SMSJoypad {
    private static final int[][] BUTTON_IDENTIFIERS = new int[][]{{8, 9, -1, -1, 25, 24}, {14, 15, -1, -1, 27, 26}};
    private static final int[] BUTTON_INDICES;
    private final int[] buttonIdentifiers;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = 6;
        nArray[5] = 7;
        BUTTON_INDICES = nArray;
    }

    public MDJoypad3(int n, ButtonInputProvider buttonInputProvider) {
        this(n, buttonInputProvider, 0);
    }

    protected MDJoypad3(int n, ButtonInputProvider buttonInputProvider, int n2) {
        super(n, buttonInputProvider, 2 + n2);
        this.buttonIdentifiers = BUTTON_IDENTIFIERS[n & 1];
    }

    @Override
    public int readData(int n) {
        if (this.isTHhigh()) {
            return super.readData(n);
        }
        int n2 = 192;
        int n3 = 0;
        while (n3 < this.buttonIdentifiers.length) {
            if (BUTTON_INDICES[n3] >= 0 && !this.isButtonDown(BUTTON_INDICES[n3])) {
                n2 |= 1 << n3;
            }
            ++n3;
        }
        return n2;
    }

    @Override
    protected int getButtonCount() {
        return super.getButtonCount() + 2;
    }

    @Override
    protected boolean isButtonPressed(int n) {
        int n2 = super.getButtonCount();
        if (n < n2) {
            return super.isButtonPressed(n);
        }
        n -= n2;
        return this.buttonInputProvider.isButtonDown(this.buttonIdentifiers[n += 4]);
    }
}

