/*
 * Decompiled with CFR 0.152.
 */
package assembler.wladx;

import assembler.AbortException;
import assembler.AbstractZ80ParseResult;
import assembler.Macro;
import assembler.MemoryMap;
import assembler.ROMBankMap;
import assembler.Section;
import assembler.Struct;
import assembler.Z80Assembler;
import assembler.Z80Instruction;
import assembler.Z80SourceLine;
import assembler.parsers.ExpressionEvaluator;
import assembler.parsers.ParseException;
import assembler.parsers.UnknownIdentifierException;
import assembler.wladx.WLAMemoryMap;
import assembler.wladx.WLAROMBankMap;
import assembler.wladx.WLASourceLine;
import disassembler.dialects.AssemblerDialect;
import disassembler.dialects.WlaSmsDialect;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import platform.debugger.EvaluateException;
import util.string.StringUtilities;
import util.string.SubCharSequence;

public final class WLAParser {
    private static final SubCharSequence NARGS = SubCharSequence.from("NARGS");
    private static final SubCharSequence NARGS_LOWER_CASE = SubCharSequence.from("nargs");
    private static final String OPERATORS = "|&^<>+-!=#~*/";
    private static final String OPERATORS_AND_IDENTIFIER_SYMBOLS = "|&^<>+-!=#~*/:?%.@";
    private static final int EVALUATION_FAILED = -1073741824;

    private WLAParser() {
    }

    public static ParseResult readLines(File file, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator) throws IOException {
        return WLAParser.readLines(file, new ParsingState(file, z80Assembler, expressionEvaluator, 4), 1);
    }

    public static ParseResult readLines(String string, int n, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator) throws IOException {
        return WLAParser.readLines(new StringReader(string), null, n, z80Assembler, expressionEvaluator);
    }

    public static ParseResult readLines(Reader reader, File file, int n, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator) throws IOException {
        return WLAParser.readLines(reader, file, new ParsingState(file, z80Assembler, expressionEvaluator, n), 1);
    }

    private static ParseResult readLines(File file, ParsingState parsingState, int n) throws IOException {
        return WLAParser.readLines(new FileInputStream(file), file, parsingState, n);
    }

    private static ParseResult readLines(InputStream inputStream, File file, ParsingState parsingState, int n) throws IOException {
        return WLAParser.readLines(new InputStreamReader(inputStream, "UTF-8"), file, parsingState, n);
    }

    private static ParseResult readLines(Reader reader, File file, ParsingState parsingState, int n) throws IOException {
        ArrayList<Z80SourceLine> arrayList = new ArrayList<Z80SourceLine>();
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        int n2 = 0;
        String string = bufferedReader.readLine();
        while (string != null) {
            WLAParser.readLine(parsingState, n2++, file, string, arrayList, null, n + 1);
            string = bufferedReader.readLine();
        }
        reader.close();
        if (parsingState.blockComment) {
            System.err.println("Block comment was still open at the end of a file");
        }
        parsingState.blockComment = false;
        return new ParseResult(parsingState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void readLine(ParsingState parsingState, int n, File file, CharSequence charSequence, List<Z80SourceLine> list, Map<SubCharSequence, CharSequence> map, int n2) throws IOException {
        if (n2 >= 32) {
            return;
        }
        List<Z80SourceLine> list2 = parsingState.lines;
        List<Section> list3 = parsingState.sections;
        Map<SubCharSequence, Macro> map2 = parsingState.macros;
        Map<SubCharSequence, Integer> map3 = parsingState.macroCalls;
        Map<SubCharSequence, CharSequence> map4 = parsingState.definitions;
        WLAROMBankMap wLAROMBankMap = (WLAROMBankMap)parsingState.romBankMap;
        WLAMemoryMap wLAMemoryMap = (WLAMemoryMap)parsingState.memoryMap;
        Z80Assembler z80Assembler = parsingState.assembler;
        ExpressionEvaluator expressionEvaluator = parsingState.expressionEvaluator;
        try {
            int n3;
            if (list.isEmpty()) {
                charSequence = WLAParser.inlineDefinitions(charSequence, map);
            }
            CharSequence charSequence2 = !list.isEmpty() ? WLAParser.inlineDefinitions(charSequence, map) : charSequence;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = charSequence2.length();
            int n8 = 0;
            while (n8 < n7) {
                switch (charSequence2.charAt(n8)) {
                    case '\"': {
                        ++n8;
                        while (n8 < n7 && (charSequence.charAt(n8) != '\"' || charSequence.charAt(n8 - 1) == '\\' && (n8 < 2 || charSequence.charAt(n8 - 2) != '\\'))) {
                            ++n8;
                        }
                        break;
                    }
                    case ';': {
                        n4 = n8;
                        if (parsingState.blockComment || n6 >= 0) break;
                        n8 = n7;
                        break;
                    }
                    case '*': {
                        if (n8 > 0 && charSequence2.charAt(n8 - 1) == '/') {
                            n6 = n8 - 1;
                            break;
                        }
                        if (n8 + 1 >= n7 || charSequence2.charAt(n8 + 1) != '/') break;
                        n5 = n8;
                    }
                }
                ++n8;
            }
            if (parsingState.blockComment && n5 >= 0) {
                charSequence2 = StringUtilities.subSequence(charSequence, n5 + "*/".length());
                n4 -= n5 + "*/".length();
                parsingState.blockComment = false;
                if (StringUtilities.isEmpty(charSequence2)) {
                    list2.add(new WLASourceLine(-1, n, file, "; " + charSequence));
                    return;
                }
            } else {
                charSequence2 = charSequence;
            }
            if (parsingState.blockComment) {
                list2.add(new WLASourceLine(-1, n, file, "; " + charSequence));
                return;
            }
            if (n6 >= 0) {
                boolean bl = parsingState.blockComment = n5 < 0;
                if (n5 >= 0) {
                    charSequence2 = StringUtilities.trim(StringUtilities.concat(StringUtilities.subSequence(charSequence, 0, n6), StringUtilities.subSequence(charSequence, n5 + 2)));
                } else {
                    if (n4 < 0 || n6 < n4) {
                        n4 = n6;
                    }
                    charSequence2 = StringUtilities.trim(n4 >= 0 ? StringUtilities.subSequence(charSequence, 0, n4) : charSequence);
                }
            } else {
                charSequence2 = StringUtilities.trim(n4 >= 0 ? StringUtilities.subSequence(charSequence, 0, n4) : charSequence2);
            }
            if (StringUtilities.isEmpty(charSequence2)) {
                if (!list.isEmpty()) {
                    list.add(new WLASourceLine(charSequence));
                    return;
                } else {
                    list2.add(new WLASourceLine(charSequence));
                }
                return;
            }
            if (StringUtilities.isEmpty(charSequence2)) {
                list2.add(new WLASourceLine(-1, n, file, charSequence));
                return;
            }
            if (charSequence2.charAt(charSequence2.length() - 1) == '.' && charSequence2.length() > 3 && (charSequence2.charAt(charSequence2.length() - 2) == '=' || charSequence2.charAt(charSequence2.length() - 2) == ' ' && charSequence2.charAt(charSequence2.length() - 3) == '=')) {
                list2.add(new WLASourceLine(charSequence));
                return;
            }
            int n9 = n4 = charSequence2.charAt(0) == '.' ? 1 : 0;
            if (n4 != 0 && charSequence2.length() > 1 && Character.toUpperCase(charSequence2.charAt(1)) != 'D') {
                if (StringUtilities.startsWithIgnoreCase(charSequence2, ".WORD")) {
                    charSequence2 = StringUtilities.concat(".dw", charSequence2.subSequence(".WORD".length(), charSequence2.length()));
                } else if (StringUtilities.startsWithIgnoreCase(charSequence2, ".BYTE")) {
                    charSequence2 = StringUtilities.concat(".db", charSequence2.subSequence(".BYTE".length(), charSequence2.length()));
                }
            }
            int n10 = n5 = n4 != 0 && (charSequence2.length() <= 1 || Character.toUpperCase(charSequence2.charAt(1)) != 'D') ? 1 : 0;
            if (n5 != 0) {
                if (StringUtilities.startsWithIgnoreCase(charSequence2, ".ENDASM")) {
                    parsingState.asmDisabled = true;
                } else if (StringUtilities.equalsIgnoreCase(charSequence2, ".ASM")) {
                    parsingState.asmDisabled = false;
                }
            }
            if (parsingState.asmDisabled) {
                list2.add(new WLASourceLine(-1, n, file, charSequence));
                return;
            }
            if (!parsingState.skipToNextIfPart) {
                if (parsingState.memoryMapDefinition) {
                    CharSequence[] charSequenceArray;
                    boolean bl = parsingState.memoryMapDefinition = !StringUtilities.equalsIgnoreCase(charSequence2 = WLAParser.inlineDefinitions(charSequence2, map4), ".ENDME");
                    if (StringUtilities.startsWithIgnoreCase(charSequence2, "DEFAULTSLOT")) {
                        wLAMemoryMap.setDefaultSlot(WLAParser.evaluateExpression(expressionEvaluator, StringUtilities.subSequence(charSequence2, "DEFAULTSLOT".length())));
                    } else if (StringUtilities.startsWithIgnoreCase(charSequence2, "SLOTSIZE")) {
                        parsingState.slotSize = WLAParser.evaluateExpression(expressionEvaluator, StringUtilities.subSequence(charSequence2, "SLOTSIZE".length()));
                    } else if (StringUtilities.startsWithIgnoreCase(charSequence2, "SLOT") && (charSequenceArray = WLAParser.splitOperands(charSequence2)).length > 2) {
                        n7 = 2;
                        while (n7 < charSequenceArray.length) {
                            n8 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[n7]);
                            if (n8 != -1073741824) {
                                wLAMemoryMap.addSlot(n8, parsingState.slotSize);
                                break;
                            }
                            if (!StringUtilities.equalsIgnoreCase(charSequenceArray[n7], "START")) {
                                ++n7;
                            }
                            ++n7;
                        }
                    }
                    list2.add(new WLASourceLine(-1, n, file, charSequence));
                    return;
                }
                if (n5 != 0 && StringUtilities.equalsIgnoreCase(charSequence2, ".MEMORYMAP")) {
                    parsingState.memoryMapDefinition = true;
                    parsingState.memoryMap = new WLAMemoryMap();
                    list2.add(new WLASourceLine(-1, n, file, charSequence));
                    return;
                }
                if (parsingState.romBankMapDefinition) {
                    boolean bl = parsingState.romBankMapDefinition = !StringUtilities.equalsIgnoreCase(charSequence2 = WLAParser.inlineDefinitions(charSequence2, map4), ".ENDRO");
                    if (StringUtilities.startsWithIgnoreCase(charSequence2, "BANKSTOTAL")) {
                        parsingState.romBankMap = new WLAROMBankMap(WLAParser.evaluateExpression(expressionEvaluator, StringUtilities.subSequence(charSequence2, "BANKSTOTAL".length())));
                    } else if (StringUtilities.startsWithIgnoreCase(charSequence2, "BANKSIZE")) {
                        parsingState.bankSize = WLAParser.evaluateExpression(expressionEvaluator, StringUtilities.subSequence(charSequence2, "BANKSIZE".length()));
                    } else if (StringUtilities.startsWithIgnoreCase(charSequence2, "BANKS")) {
                        n6 = WLAParser.evaluateExpression(expressionEvaluator, StringUtilities.subSequence(charSequence2, "BANKS".length()));
                        while (n6 > 0) {
                            wLAROMBankMap.addBank(parsingState.bankSize);
                            --n6;
                        }
                    }
                    list2.add(new WLASourceLine(-1, n, file, charSequence));
                    return;
                }
                if (n5 != 0) {
                    if (StringUtilities.equalsIgnoreCase(charSequence2, ".ROMBANKMAP")) {
                        parsingState.romBankMapDefinition = true;
                        list2.add(new WLASourceLine(-1, n, file, charSequence));
                        return;
                    }
                    if (StringUtilities.startsWithIgnoreCase(charSequence2, ".ROMBANKSIZE")) {
                        parsingState.bankSize = WLAParser.evaluateExpression(expressionEvaluator, WLAParser.inlineDefinitions(StringUtilities.subSequence(charSequence2, ".ROMBANKSIZE".length()), map4));
                        list2.add(new WLASourceLine(-1, n, file, charSequence));
                        return;
                    }
                    if (StringUtilities.startsWithIgnoreCase(charSequence2, ".ROMBANKS")) {
                        n6 = WLAParser.evaluateExpression(expressionEvaluator, WLAParser.inlineDefinitions(StringUtilities.subSequence(charSequence2, ".ROMBANKS".length()), map4));
                        WLAROMBankMap wLAROMBankMap2 = new WLAROMBankMap(n6);
                        n8 = 0;
                        while (n8 < n6) {
                            wLAROMBankMap2.addBank(parsingState.bankSize);
                            ++n8;
                        }
                        parsingState.romBankMap = wLAROMBankMap2;
                        list2.add(new WLASourceLine(-1, n, file, charSequence));
                        return;
                    }
                    if (StringUtilities.equalsIgnoreCase(charSequence2, ".ENDM")) {
                        map2.put(SubCharSequence.from(parsingState.currentMacro.getName()), parsingState.currentMacro);
                        parsingState.currentMacro = null;
                        list2.add(new WLASourceLine(-1, n, file, charSequence));
                        return;
                    }
                    if (StringUtilities.startsWithIgnoreCase(charSequence2, ".MACRO")) {
                        n6 = StringUtilities.indexOfIgnoreCase(charSequence2, "ARGS");
                        CharSequence charSequence3 = StringUtilities.subSequence(charSequence2, ".MACRO".length(), Math.min(n6 & Integer.MAX_VALUE, charSequence2.length()));
                        String string = n6 >= 0 ? StringUtilities.subSequence(charSequence2, n6 + " ARGS".length()) : "";
                        parsingState.currentMacro = new Macro(charSequence3, WLAParser.splitOperands(string));
                        list2.add(new WLASourceLine(-1, n, file, charSequence));
                        return;
                    }
                }
                if (parsingState.currentMacro != null) {
                    WLASourceLine wLASourceLine = new WLASourceLine(-1, n, file, charSequence);
                    list2.add(wLASourceLine);
                    parsingState.currentMacro.addLine(wLASourceLine);
                    return;
                }
                if (!list.isEmpty()) {
                    if (n5 != 0 && StringUtilities.equalsIgnoreCase(charSequence2, ".ENDR")) {
                        n6 = -1;
                        for (Z80SourceLine z80SourceLine : list) {
                            CharSequence charSequence4 = StringUtilities.trim(z80SourceLine.toString());
                            if (StringUtilities.isEmpty(charSequence4) || charSequence4.charAt(0) != '.') continue;
                            if (StringUtilities.equalsIgnoreCase(charSequence4, ".ENDR")) {
                                --n6;
                                continue;
                            }
                            if (!StringUtilities.startsWithIgnoreCase(charSequence4, ".REP")) continue;
                            ++n6;
                        }
                        if (n6 <= 0) {
                            String string = list.remove(0).toString();
                            CharSequence[] charSequenceArray = WLAParser.splitOperands(StringUtilities.subSequence(string, StringUtilities.indexOf((CharSequence)string, '.')));
                            int n11 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]);
                            CharSequence charSequence5 = charSequenceArray.length >= 4 && StringUtilities.equalsIgnoreCase(charSequenceArray[2], "INDEX") ? charSequenceArray[3] : null;
                            if (n11 < 0) {
                                list2.add(new WLASourceLine(string));
                            } else {
                                list2.add(new WLASourceLine("; " + string));
                            }
                            ArrayList<Z80SourceLine> arrayList = new ArrayList<Z80SourceLine>();
                            if (list.size() == 1) {
                                Z80SourceLine z80SourceLine = list.remove(0);
                                if (n11 != 0) {
                                    WLAParser.readLine(parsingState, z80SourceLine.getLineNumber(), z80SourceLine.getFile(), z80SourceLine.toString(), arrayList, map, n2 + 1);
                                }
                                WLASourceLine wLASourceLine = (WLASourceLine)list2.get(list2.size() - 1);
                                if (n11 > 1000) {
                                    list2.set(list2.size() - 2, new WLASourceLine(string));
                                    list2.set(list2.size() - 1, wLASourceLine.repeatLine(n11));
                                    parsingState.sectionSize += wLASourceLine.getSize() * (n11 - 1);
                                    list2.add(new WLASourceLine(charSequence));
                                    return;
                                } else {
                                    int n12 = 1;
                                    while (n12 < n11) {
                                        WLAParser.readLine(parsingState, z80SourceLine.getLineNumber(), z80SourceLine.getFile(), z80SourceLine.toString(), arrayList, map, n2 + 1);
                                        ++n12;
                                    }
                                    if (n11 < 0) {
                                        list2.add(new WLASourceLine(charSequence));
                                        return;
                                    } else {
                                        list2.add(new WLASourceLine("; " + charSequence));
                                    }
                                }
                                return;
                            }
                            int n13 = 0;
                            while (n13 < n11) {
                                if (charSequence5 != null) {
                                    parsingState.definitions.put(SubCharSequence.from(charSequence5), Integer.toString(n13));
                                }
                                for (Z80SourceLine z80SourceLine : list) {
                                    WLAParser.readLine(parsingState, z80SourceLine.getLineNumber(), z80SourceLine.getFile(), z80SourceLine.toString(), arrayList, map, n2 + 1);
                                }
                                ++n13;
                            }
                            list.clear();
                            list2.add(new WLASourceLine("; " + charSequence));
                            return;
                        }
                    }
                    list.add(new WLASourceLine(n, file, charSequence));
                    return;
                }
            }
            if (n5 != 0) {
                if (StringUtilities.equalsIgnoreCase(charSequence2, ".ENDIF")) {
                    if (parsingState.nestedIfs == 0 || parsingState.nestedIfs-- == 0) {
                        parsingState.skipToNextIfPart = false;
                        parsingState.skipToEndIfPart = false;
                    }
                    list2.add(new WLASourceLine(-1, n, file, charSequence));
                    return;
                }
                if (StringUtilities.equalsIgnoreCase(charSequence2, ".ELSE")) {
                    if (!parsingState.skipToEndIfPart && parsingState.nestedIfs == 0) {
                        parsingState.skipToNextIfPart = !parsingState.skipToNextIfPart;
                    }
                    list2.add(new WLASourceLine(-1, n, file, charSequence));
                    return;
                }
                n6 = StringUtilities.startsWithIgnoreCase(charSequence2, ".ELIF") ? 1 : 0;
                if (n6 != 0) {
                    if (!parsingState.skipToNextIfPart || parsingState.skipToEndIfPart || parsingState.nestedIfs > 0) {
                        list2.add(new WLASourceLine(-1, n, file, charSequence));
                        parsingState.skipToNextIfPart = true;
                        parsingState.skipToEndIfPart = true;
                        return;
                    }
                    parsingState.skipToNextIfPart = false;
                }
                if (n6 != 0 || StringUtilities.startsWithIgnoreCase(charSequence2, ".IF")) {
                    if (parsingState.skipToNextIfPart) {
                        ++parsingState.nestedIfs;
                    } else {
                        if (StringUtilities.startsWithIgnoreCase(charSequence2, ".IFDEF") || StringUtilities.startsWithIgnoreCase(charSequence2, ".IFNDEF")) {
                            CharSequence[] charSequenceArray = WLAParser.splitOperands(charSequence2);
                            if (charSequenceArray.length >= 2) {
                                parsingState.skipToNextIfPart = map4.containsKey(SubCharSequence.from(charSequenceArray[1])) ^ StringUtilities.startsWithIgnoreCase(charSequence2, ".IFDEF");
                            }
                            list2.add(new WLASourceLine(-1, n, file, charSequence));
                            return;
                        }
                        charSequence2 = WLAParser.inlineDefinitions(charSequence2, map4);
                        CharSequence[] charSequenceArray = WLAParser.splitOperands(charSequence2);
                        if (n6 != 0 || StringUtilities.equalsIgnoreCase(charSequenceArray[0], ".IF")) {
                            int n14 = StringUtilities.indexOfIgnoreCase(charSequenceArray[1], "DEFINED");
                            if (n14 >= 0) {
                                int n15 = StringUtilities.indexOf(charSequenceArray[1], '(', n14 + "DEFINED".length()) + 1;
                                if (n15 > 0) {
                                    int n16 = StringUtilities.indexOf(charSequenceArray[1], ')', n15);
                                    n8 = map4.containsKey(StringUtilities.trim(charSequenceArray[1].subSequence(n15, n16))) ? 1 : 0;
                                } else {
                                    n8 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]) != 0 ? 1 : 0;
                                }
                            } else {
                                n8 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]) != 0 ? 1 : 0;
                            }
                        } else if (StringUtilities.equalsIgnoreCase(charSequenceArray[0], ".IFGR")) {
                            n8 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]) > WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]) ? 1 : 0;
                        } else if (StringUtilities.equalsIgnoreCase(charSequenceArray[0], ".IFEQ")) {
                            n8 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]) == WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]) ? 1 : 0;
                        } else if (StringUtilities.equalsIgnoreCase(charSequenceArray[0], ".IFLEEQ")) {
                            n8 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]) <= WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]) ? 1 : 0;
                        } else {
                            if (!StringUtilities.equalsIgnoreCase(charSequenceArray[0], ".IFGREQ")) throw new IllegalArgumentException("Unknown IF directive " + charSequenceArray[0] + " in " + charSequence);
                            n8 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]) >= WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]) ? 1 : 0;
                        }
                        parsingState.skipToNextIfPart = n8 == 0;
                    }
                    list2.add(new WLASourceLine(-1, n, file, charSequence));
                    return;
                }
            }
            if (parsingState.skipToNextIfPart) {
                list2.add(new WLASourceLine(-1, n, file, charSequence));
                return;
            }
            if (parsingState.asciiTableDefinition) {
                if (StringUtilities.equalsIgnoreCase(charSequence2, ".ENDA")) {
                    parsingState.asciiTableDefinition = false;
                }
                list2.add(new WLASourceLine(-1, n, file, charSequence));
                return;
            }
            if (n5 != 0) {
                CharSequence[] charSequenceArray;
                if (StringUtilities.equalsIgnoreCase(charSequence2, ".ENDS")) {
                    if (parsingState.currentSection != null) {
                        char c;
                        Section section = parsingState.currentSection;
                        CharSequence charSequence6 = section.getName();
                        parsingState.currentSection = null;
                        n8 = StringUtilities.lastIndexOf(charSequence6, '_');
                        if (n8 >= 0 && n8 + 1 < charSequence6.length() && (c = charSequence6.charAt(n8 + 1)) >= '1' && c <= '9') {
                            try {
                                int n17 = Math.max(parsingState.sectionSize, Integer.parseInt(charSequence6.toString().substring(n8 + 1)));
                                int n18 = n17 - parsingState.sectionSize;
                                if (n18 > 0) {
                                    list3.add(new Section(charSequence6, section.getMode(), n17, section.getOrg(), section.getBank(), section.getBegin(), list2.size()));
                                    list2.add(new WLASourceLine(n18, n, file, charSequence));
                                    return;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        list3.add(new Section(charSequence6, section.getMode(), parsingState.sectionSize, section.getOrg(), section.getBank(), section.getBegin(), list2.size()));
                        list2.add(new WLASourceLine(charSequence));
                        return;
                    }
                    parsingState.ramSectionDefinition = false;
                }
                if (StringUtilities.equalsIgnoreCase(charSequence2, ".ENDST") && parsingState.structName != null) {
                    parsingState.structs.add(new Struct(parsingState.structName.toString(), parsingState.structFields.toArray(new Struct.Field[parsingState.structFields.size()])));
                    parsingState.structName = null;
                    parsingState.structFields.clear();
                    parsingState.structFields = null;
                }
                if (StringUtilities.startsWithIgnoreCase(charSequence2, ".STRUCT") && (charSequenceArray = WLAParser.splitOperands(charSequence2)).length >= 2) {
                    parsingState.structName = charSequenceArray[1];
                    parsingState.structFields = new ArrayList<Struct.Field>();
                    list2.add(new WLASourceLine(-1, n, file, charSequence));
                    return;
                }
                if (StringUtilities.startsWithIgnoreCase(charSequence2, ".RAMSECTION")) {
                    parsingState.ramSectionDefinition = true;
                    list2.add(new WLASourceLine(-1, n, file, charSequence));
                    return;
                }
                if (StringUtilities.startsWithIgnoreCase(charSequence2, ".SECTION")) {
                    CharSequence[] charSequenceArray2 = WLAParser.splitOperands(charSequence2);
                    CharSequence charSequence7 = charSequenceArray2[1].charAt(0) == '\"' ? charSequenceArray2[1].subSequence(1, charSequenceArray2[1].length() - 1) : charSequenceArray2[1];
                    Section.Mode mode = null;
                    int n19 = 2;
                    while (n19 < charSequenceArray2.length) {
                        try {
                            mode = Section.Mode.valueOf(charSequenceArray2[n19].toString().toUpperCase());
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            ++n19;
                        }
                    }
                    if (mode == null) {
                        mode = Section.Mode.FREE;
                    }
                    parsingState.currentSection = new Section(charSequence7, mode, 0, parsingState.org, parsingState.bank, list2.size(), list2.size());
                    parsingState.sectionSize = 0;
                    list2.add(new WLASourceLine(charSequence));
                    return;
                }
            }
            if (parsingState.ramSectionDefinition) {
                list2.add(new WLASourceLine(-1, n, file, charSequence));
                return;
            }
            if (parsingState.structName != null) {
                CharSequence[] charSequenceArray = WLAParser.splitOperands(charSequence2);
                if (charSequenceArray.length >= 2 && !StringUtilities.isEmpty(charSequenceArray[1]) && charSequenceArray[1].charAt(0) != '.') {
                    if (StringUtilities.equalsIgnoreCase(charSequenceArray[1], "DB")) {
                        n7 = 1;
                    } else if (StringUtilities.equalsIgnoreCase(charSequenceArray[1], "DW")) {
                        n7 = 2;
                    } else {
                        if (charSequenceArray.length < 3) throw new NumberFormatException(charSequence2.toString());
                        if (StringUtilities.equalsIgnoreCase(charSequenceArray[1], "DSB") || StringUtilities.equalsIgnoreCase(charSequenceArray[1], "DS")) {
                            n7 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]);
                        } else if (StringUtilities.equalsIgnoreCase(charSequenceArray[1], "DSW")) {
                            n7 = 2 * WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]);
                        } else {
                            if (!StringUtilities.equalsIgnoreCase(charSequenceArray[1], "INSTANCEOF")) throw new NumberFormatException(charSequence2.toString());
                            n7 = 0;
                        }
                    }
                    parsingState.structFields.add(new Struct.Field(charSequenceArray[0].toString(), n7));
                }
                list2.add(new WLASourceLine(-1, n, file, charSequence));
                return;
            }
            if (n4 != 0) {
                boolean bl;
                boolean bl2 = bl = charSequence2.length() > 4 && Character.toUpperCase(charSequence2.charAt(2)) == 'E' && Character.toUpperCase(charSequence2.charAt(3)) == 'F';
                if (bl || n5 != 0 && (StringUtilities.startsWithIgnoreCase(charSequence2, ".EQU") || StringUtilities.startsWithIgnoreCase(charSequence2, ".REDEF"))) {
                    WLAParser.parseDefinition(charSequence2, map4, expressionEvaluator);
                    list2.add(new WLASourceLine(-1, n, file, charSequence));
                    return;
                }
                if (n5 != 0) {
                    if (StringUtilities.equalsIgnoreCase(charSequence2, ".SHIFT")) {
                        if (map != null && (n7 = Integer.parseInt(map.get(NARGS).toString())) > 0) {
                            n8 = 0;
                            while (n8 < n7 - 1) {
                                map.put(SubCharSequence.from("\\" + (n8 + 1)), map.get(SubCharSequence.from("\\" + (n8 + 2))));
                                ++n8;
                            }
                            map.remove(SubCharSequence.from("\\" + n7));
                            map.put(NARGS, Integer.toString(n7 - 1));
                            map.put(NARGS_LOWER_CASE, Integer.toString(n7 - 1));
                        }
                        list2.add(new WLASourceLine(-1, n, file, charSequence));
                        return;
                    }
                    if (StringUtilities.startsWithIgnoreCase(charSequence2, ".BANK") || StringUtilities.startsWithIgnoreCase(charSequence2, ".ORG") || StringUtilities.startsWithIgnoreCase(charSequence2, ".SLOT")) {
                        CharSequence[] charSequenceArray = WLAParser.splitOperands(WLAParser.inlineDefinitions(charSequence2, map4));
                        if (StringUtilities.startsWithIgnoreCase(charSequence2, ".SLOT")) {
                            try {
                                parsingState.slot = expressionEvaluator.evaluate(charSequenceArray[1]);
                            }
                            catch (UnknownIdentifierException unknownIdentifierException) {
                                parsingState.slot = -1;
                            }
                            list2.add(new WLASourceLine(charSequence, new int[]{parsingState.slot}));
                            return;
                        }
                        if (StringUtilities.startsWithIgnoreCase(charSequence2, ".BANK")) {
                            try {
                                parsingState.bank = expressionEvaluator.evaluate(charSequenceArray[1]);
                            }
                            catch (UnknownIdentifierException unknownIdentifierException) {
                                parsingState.bank = -1;
                            }
                            if (charSequenceArray.length > 3 && StringUtilities.equalsIgnoreCase(charSequenceArray[2], "SLOT")) {
                                try {
                                    parsingState.slot = expressionEvaluator.evaluate(charSequenceArray[3]);
                                }
                                catch (UnknownIdentifierException unknownIdentifierException) {
                                    parsingState.slot = wLAMemoryMap.getDefaultSlot();
                                }
                            } else {
                                parsingState.slot = wLAMemoryMap.getDefaultSlot();
                            }
                            list2.add(new WLASourceLine(charSequence, new int[]{parsingState.bank, parsingState.slot}));
                            return;
                        }
                        if (!StringUtilities.startsWithIgnoreCase(charSequence2, ".ORG")) return;
                        try {
                            parsingState.org = expressionEvaluator.evaluate(charSequenceArray[1]);
                            int n20 = n8 = charSequence2.length() > 4 && Character.toUpperCase(charSequence2.charAt(4)) == 'A' ? 1 : 0;
                            if (wLAMemoryMap != null && n8 != 0) {
                                parsingState.org = wLAMemoryMap.resolveAddress(parsingState.slot, parsingState.org);
                            }
                        }
                        catch (UnknownIdentifierException unknownIdentifierException) {
                            parsingState.org = -1;
                        }
                        list2.add(new WLASourceLine(charSequence, new int[]{parsingState.org}));
                        return;
                    }
                    if (StringUtilities.startsWithIgnoreCase(charSequence2, ".ENUM")) {
                        CharSequence[] charSequenceArray = WLAParser.splitOperands(WLAParser.inlineDefinitions(charSequence2, map4));
                        parsingState.enumCounter = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]);
                        list2.add(new WLASourceLine(-1, n, file, charSequence));
                        return;
                    }
                    if (StringUtilities.equalsIgnoreCase(charSequence2, ".ENDE")) {
                        parsingState.enumCounter = -1;
                        list2.add(new WLASourceLine(-1, n, file, charSequence));
                        return;
                    }
                }
            } else if (parsingState.enumCounter < 0) {
                do {
                    String string;
                    CharSequence charSequence8 = WLAParser.parseLabel(charSequence2);
                    n7 = charSequence2.length() > charSequence8.length() && (charSequence2.charAt(charSequence8.length()) == ':' || charSequence2.charAt(charSequence2.length() - 1) == ':') ? charSequence8.length() : -1;
                    CharSequence charSequence9 = string = n7 > 0 && Character.isJavaIdentifierPart(charSequence2.charAt(n7 - 1)) || charSequence8.length() > 0 && "+-".indexOf(charSequence8.charAt(0)) >= 0 ? charSequence8 : "";
                    if (string.length() == 0 || n7 < 0 && map2.containsKey(SubCharSequence.from(charSequence2))) break;
                    n3 = Math.max(n7, string.length());
                    while (n3 < charSequence2.length() && ": \t".indexOf(charSequence2.charAt(n3)) >= 0) {
                        ++n3;
                    }
                } while (StringUtilities.indexOf(charSequence2 = StringUtilities.subSequence(charSequence2, n3), ':') >= 0 && (Character.isJavaIdentifierPart(charSequence2.charAt(StringUtilities.indexOf(charSequence2, ':') - 1)) || "+-".indexOf(charSequence2.charAt(StringUtilities.indexOf(charSequence2, ':') - 1)) >= 0));
                if (StringUtilities.isEmpty(charSequence2)) {
                    list2.add(new WLASourceLine(charSequence));
                    return;
                }
            }
            if (charSequence2.charAt(0) == '.') {
                if (charSequence2.length() <= 2) {
                    list2.add(new WLASourceLine(charSequence));
                    return;
                }
                char c = Character.toUpperCase(charSequence2.charAt(1));
                if (c != 'D' && (c != 'A' || StringUtilities.startsWithIgnoreCase(charSequence2, ".ASCIITABLE"))) {
                    if (StringUtilities.startsWithIgnoreCase(charSequence2, ".REP") && (StringUtilities.startsWithIgnoreCase(charSequence2, ".REPT") || StringUtilities.startsWithIgnoreCase(charSequence2, ".REPEAT"))) {
                        list.add(new WLASourceLine(WLAParser.inlineDefinitions(charSequence, map4)));
                        return;
                    }
                    if (StringUtilities.startsWithIgnoreCase(charSequence2, ".INC")) {
                        WLAParser.parseIncludeDirective(charSequence2, n, file, charSequence, parsingState, expressionEvaluator, n2);
                        return;
                    }
                    if (StringUtilities.startsWithIgnoreCase(charSequence2, ".ASCIITABLE")) {
                        parsingState.asciiTableDefinition = true;
                    }
                    list2.add(new WLASourceLine(charSequence));
                    return;
                }
                if (c == 'A' && !StringUtilities.startsWithIgnoreCase(charSequence2, ".ASC")) {
                    list2.add(new WLASourceLine(charSequence));
                    return;
                }
                n7 = Character.toUpperCase(charSequence2.charAt(2));
                if (n7 != 66 && n7 != 87 && n7 != 83) {
                    list2.add(new WLASourceLine(charSequence));
                    return;
                }
            }
            charSequence2 = WLAParser.inlineDefinitions(charSequence2, map4);
            if (parsingState.enumCounter >= 0) {
                try {
                    CharSequence[] charSequenceArray = WLAParser.splitOperands(charSequence2);
                    if (charSequenceArray.length >= 2) {
                        WLAParser.addDefinition(charSequenceArray[0], Integer.toString(parsingState.enumCounter), map4);
                        if (!StringUtilities.isEmpty(charSequenceArray[1]) && charSequenceArray[1].charAt(0) != '.') {
                            if (StringUtilities.equalsIgnoreCase(charSequenceArray[1], "DB")) {
                                ++parsingState.enumCounter;
                            } else if (StringUtilities.equalsIgnoreCase(charSequenceArray[1], "DW")) {
                                parsingState.enumCounter += 2;
                            } else {
                                if (charSequenceArray.length < 3) throw new NumberFormatException(charSequence2.toString());
                                if (StringUtilities.equalsIgnoreCase(charSequenceArray[1], "DSB") || StringUtilities.equalsIgnoreCase(charSequenceArray[1], "DS")) {
                                    parsingState.enumCounter += WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]);
                                } else if (StringUtilities.equalsIgnoreCase(charSequenceArray[1], "DSW")) {
                                    parsingState.enumCounter += 2 * WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]);
                                } else if (!StringUtilities.equalsIgnoreCase(charSequenceArray[1], "INSTANCEOF")) {
                                    throw new NumberFormatException(charSequence2.toString());
                                }
                            }
                        }
                    }
                    list2.add(new WLASourceLine(-1, n, file, charSequence));
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    parsingState.enumCounter = -1;
                }
            }
            if (charSequence2.charAt(0) == '.') {
                WLAParser.parseDataDirective(charSequence2, n, file, charSequence, parsingState);
                return;
            }
            int n21 = StringUtilities.indexOf(charSequence2, ' ');
            Macro macro = map2.get(SubCharSequence.from(charSequence2, 0, Math.min(n21 & Integer.MAX_VALUE, charSequence2.length())));
            if (macro != null) {
                int n22;
                Integer n23 = map3.get(SubCharSequence.from(macro.getName()));
                n23 = n23 == null ? Integer.valueOf(0) : Integer.valueOf(n23 + 1);
                map3.put(SubCharSequence.from(macro.getName()), n23);
                n3 = 0;
                while (n3 < charSequence.length() && charSequence.charAt(n3) > ' ' && charSequence.charAt(n3) != ':') {
                    ++n3;
                }
                if (n3 >= charSequence.length() || charSequence.charAt(n3) != ':') {
                    n3 = -1;
                }
                CharSequence charSequence10 = StringUtilities.subSequence(charSequence, n3 + 1, charSequence.length());
                int n24 = 0;
                while (n24 < charSequence10.length() && charSequence10.charAt(n24) <= ' ') {
                    ++n24;
                }
                StringBuilder stringBuilder = new StringBuilder(StringUtilities.subSequence(charSequence10, 0, n24));
                while (stringBuilder.length() < n24 + n3 + 1) {
                    stringBuilder.append(' ');
                }
                String string = stringBuilder.toString();
                list2.add(new WLASourceLine(StringUtilities.concat(n3 >= 0 ? StringUtilities.concat(StringUtilities.subSequence(charSequence, 0, n3 + 1), ";") : ";", n24 > 0 ? StringUtilities.subSequence(charSequence10, 1) : charSequence10)));
                HashMap<SubCharSequence, CharSequence> hashMap = new HashMap<SubCharSequence, CharSequence>();
                CharSequence[] charSequenceArray = WLAParser.splitOperands(StringUtilities.subSequence(charSequence2, Math.min(n21 & Integer.MAX_VALUE, charSequence2.length())));
                int n25 = 0;
                while (n25 < charSequenceArray.length) {
                    try {
                        n22 = expressionEvaluator.evaluate(charSequenceArray[n25]);
                        charSequenceArray[n25] = SubCharSequence.from(Integer.toString(n22));
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    catch (UnknownIdentifierException unknownIdentifierException) {}
                    hashMap.put(SubCharSequence.from("\\" + (n25 + 1)), charSequenceArray[n25]);
                    ++n25;
                }
                hashMap.put(SubCharSequence.from("\\@"), Integer.toString(n23));
                CharSequence[] charSequenceArray3 = macro.getParams();
                n22 = 0;
                while (n22 < charSequenceArray3.length && n22 < charSequenceArray.length) {
                    WLAParser.addDefinition(charSequenceArray3[n22], charSequenceArray[n22], hashMap);
                    ++n22;
                }
                hashMap.put(NARGS, Integer.toString(charSequenceArray.length));
                hashMap.put(NARGS_LOWER_CASE, Integer.toString(charSequenceArray.length));
                for (Z80SourceLine z80SourceLine : macro.getLines()) {
                    WLAParser.readLine(parsingState, z80SourceLine.getLineNumber(), z80SourceLine.getFile(), StringUtilities.concat(string, z80SourceLine.toString()), list, hashMap, n2 + 1);
                }
                list2.add(new WLASourceLine(";" + (!StringUtilities.isEmpty(string) ? string.substring(1) : string) + "END OF " + macro.getName()));
                return;
            }
            try {
                Z80Instruction z80Instruction = z80Assembler.assemble(charSequence2.toString());
                list2.add(new WLASourceLine(n, file, charSequence, z80Instruction));
                parsingState.sectionSize += z80Instruction.getSize();
                return;
            }
            catch (ParseException parseException) {
                try {
                    CharSequence[] charSequenceArray = WLAParser.splitOperands(charSequence2);
                    if (charSequenceArray.length > 1) {
                        charSequence2 = StringUtilities.trim(StringUtilities.subSequence(charSequence2, charSequenceArray[0].length()));
                        Z80Instruction z80Instruction = z80Assembler.assemble(charSequence2.toString());
                        list2.add(new WLASourceLine(n, file, charSequence, z80Instruction));
                        parsingState.sectionSize += z80Instruction.getSize();
                        return;
                    }
                }
                catch (ParseException parseException2) {
                    if (!StringUtilities.isEmpty(charSequence2) && charSequence2.charAt(0) == '.') {
                        if (StringUtilities.startsWithIgnoreCase(charSequence2, ".INC")) {
                            WLAParser.parseIncludeDirective(charSequence2, n, file, charSequence, parsingState, expressionEvaluator, n2);
                            return;
                        } else {
                            WLAParser.parseDataDirective(charSequence2, n, file, charSequence, parsingState);
                        }
                        return;
                    }
                }
                catch (Exception exception) {}
                parsingState.addException(parseException);
            }
            catch (Exception exception) {
                parsingState.addException(exception);
            }
        }
        catch (AbortException abortException) {
            throw abortException;
        }
        catch (RuntimeException runtimeException) {
            parsingState.addException(runtimeException);
            list.clear();
        }
        list2.add(new WLASourceLine(charSequence));
    }

    public static CharSequence parseLabel(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n && charSequence.charAt(n2) <= ' ') {
            ++n2;
        }
        int n3 = n2;
        if (n2 < n) {
            char c;
            if ((c = charSequence.charAt(n2++)) == '+') {
                while (n2 < n && charSequence.charAt(n2) == '+') {
                    ++n2;
                }
            } else if (c == '-') {
                while (n2 < n && charSequence.charAt(n2) == '-') {
                    ++n2;
                }
            } else if (WLAParser.isLabelStart(c)) {
                while (n2 < n && WLAParser.isLabelPart(charSequence.charAt(n2))) {
                    ++n2;
                }
            } else {
                --n2;
            }
        }
        if (n2 <= n3) {
            return "";
        }
        return SubCharSequence.from(charSequence, n3, n2);
    }

    private static boolean isLabelStart(char c) {
        return Character.isJavaIdentifierStart(c) || c == '@' || c == '0';
    }

    private static boolean isLabelPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.' || c == '@';
    }

    private static CharSequence[] splitOperands(CharSequence charSequence) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            char c = charSequence.charAt(n2);
            if (c == ';') {
                WLAParser.addOperandToList(charSequence, n, n2, bl, arrayList);
                n = n2 = charSequence.length();
            } else if (c == '\'') {
                WLAParser.addOperandToList(charSequence, n, n2, bl, arrayList);
                n = n2++;
                if (n2 < charSequence.length() && charSequence.charAt(n2) == '\\') {
                    ++n2;
                }
                if (++n2 < charSequence.length() && charSequence.charAt(n2) == '\'') {
                    WLAParser.addOperandToList(charSequence, n, n2 + 1, false, arrayList);
                }
                n = n2 + 1;
                bl = false;
            } else if (c == '\"' && (n2 <= 0 || charSequence.charAt(n2 - 1) != '\\')) {
                WLAParser.addOperandToList(charSequence, n, n2, bl, arrayList);
                n = n2++;
                while (n2 < charSequence.length() && (charSequence.charAt(n2) != '\"' || charSequence.charAt(n2 - 1) == '\\')) {
                    ++n2;
                }
                if (n2 >= charSequence.length()) {
                    throw new IllegalArgumentException("Missing closing quotation mark in " + charSequence);
                }
                WLAParser.addOperandToList(charSequence, n, n2 + 1, false, arrayList);
                n = n2 + 1;
            } else if (c == '(') {
                if (n2 < 1 || !Character.isJavaIdentifierPart(charSequence.charAt(n2 - 1))) {
                    WLAParser.addOperandToList(charSequence, n, n2, bl, arrayList);
                    n = n2;
                }
                int n3 = 0;
                while (n2 < charSequence.length()) {
                    char c2 = charSequence.charAt(n2);
                    if (c2 == '\"') {
                        ++n2;
                        while (n2 < charSequence.length() && (charSequence.charAt(n2) != '\"' || charSequence.charAt(n2 - 1) == '\\')) {
                            ++n2;
                        }
                    } else if (c2 == '(') {
                        ++n3;
                    } else if (c2 == ')' && --n3 == 0) break;
                    ++n2;
                }
                bl = false;
                WLAParser.addOperandToList(charSequence, n, Math.min(charSequence.length(), n2 + 1), bl, arrayList);
                n = n2 + 1;
            } else if (!Character.isJavaIdentifierPart(c) && OPERATORS_AND_IDENTIFIER_SYMBOLS.indexOf(c) < 0 || c == '$' && n != n2) {
                if (WLAParser.addOperandToList(charSequence, n, n2, bl, arrayList)) {
                    bl = false;
                }
                if (c > ' ') {
                    boolean bl2 = bl = c == ',';
                }
                if (charSequence.charAt(n) == '.') {
                    bl = true;
                }
                n = c == '$' ? n2 : n2 + 1;
            }
            ++n2;
        }
        WLAParser.addOperandToList(charSequence, n, charSequence.length(), bl, arrayList);
        return arrayList.toArray(new CharSequence[arrayList.size()]);
    }

    private static boolean addOperandToList(CharSequence charSequence, int n, int n2, boolean bl, List<CharSequence> list) {
        if (n2 > n) {
            CharSequence charSequence2;
            CharSequence charSequence3 = StringUtilities.subSequence(charSequence, n, n2);
            CharSequence charSequence4 = charSequence2 = list.isEmpty() ? null : list.get(list.size() - 1);
            if (!list.isEmpty() && !bl && (OPERATORS.indexOf(charSequence.charAt(n)) >= 0 || charSequence2 != null && OPERATORS.indexOf(charSequence2.charAt(charSequence2.length() - 1)) >= 0)) {
                list.set(list.size() - 1, StringUtilities.concat(list.get(list.size() - 1), charSequence3));
            } else {
                list.add(charSequence3);
            }
            return true;
        }
        return false;
    }

    private static void addDefinition(CharSequence charSequence, CharSequence charSequence2, Map<SubCharSequence, CharSequence> map) {
        map.put(SubCharSequence.from(charSequence), charSequence2);
    }

    private static CharSequence inlineDefinitions(CharSequence charSequence, Map<SubCharSequence, CharSequence> map) {
        if (map == null || map.isEmpty()) {
            return charSequence;
        }
        int n = 0;
        List<SubCharSequence> list = WLAParser.splitTokens(charSequence);
        for (SubCharSequence subCharSequence : list) {
            CharSequence charSequence2 = map.get(subCharSequence);
            if (charSequence2 == null || charSequence2.length() <= 0) continue;
            if (charSequence.charAt(0) == '.' && Character.isDigit(charSequence2.charAt(0))) {
                charSequence2 = StringUtilities.concat(StringUtilities.concat("(", charSequence2), ")");
            }
            if (charSequence2 == null) continue;
            CharSequence charSequence3 = charSequence.subSequence(0, n + subCharSequence.getBeginIndex());
            CharSequence charSequence4 = charSequence.subSequence(n + subCharSequence.getEndIndex(), charSequence.length());
            charSequence = StringUtilities.concat(StringUtilities.concat(charSequence3, charSequence2), charSequence4);
            n += charSequence2.length() - (subCharSequence.getEndIndex() - subCharSequence.getBeginIndex());
        }
        return charSequence;
    }

    /*
     * Unable to fully structure code
     */
    private static List<SubCharSequence> splitTokens(CharSequence var0) {
        var1_1 = new ArrayList<SubCharSequence>();
        var2_2 = 0;
        var3_3 = 0;
        while (var3_3 < var0.length()) {
            block10: {
                block12: {
                    block13: {
                        block11: {
                            block9: {
                                var4_4 = var0.charAt(var3_3);
                                if (var4_4 != ';') break block9;
                                if (var3_3 > var2_2 && var0.charAt(var2_2) != '$') {
                                    var1_1.add(SubCharSequence.from(var0, var2_2, var3_3));
                                }
                                var2_2 = var3_3 = var0.length();
                                break block10;
                            }
                            if (var4_4 != '\"') break block11;
                            ++var3_3;
                            while (var3_3 < var0.length() && (var0.charAt(var3_3) != '\"' || var0.charAt(var3_3 - 1) == '\\')) {
                                ++var3_3;
                            }
                            var2_2 = var3_3 + 1;
                            break block10;
                        }
                        if (var4_4 != '\\') break block12;
                        if (var3_3 > var2_2 && var0.charAt(var2_2) != '$') {
                            var1_1.add(SubCharSequence.from(var0, var2_2, var3_3));
                        }
                        var2_2 = var3_3++;
                        if (var0.charAt(var3_3) != '@') ** GOTO lbl30
                        ++var3_3;
                        break block13;
lbl-1000:
                        // 1 sources

                        {
                            ++var3_3;
lbl30:
                            // 2 sources

                            ** while (var3_3 < var0.length() && Character.isDigit((char)var0.charAt((int)var3_3)))
                        }
                    }
                    if (var3_3 > var2_2 + 1 && var0.charAt(var2_2) != '$') {
                        var1_1.add(SubCharSequence.from(var0, var2_2, var3_3));
                    }
                    var2_2 = var3_3 + 1;
                    break block10;
                }
                if ((var3_3 == var2_2 ? Character.isLetter(var4_4) == false : Character.isLetterOrDigit(var4_4) == false) && var4_4 != '?' && var4_4 != '.' && var4_4 != '_' && var4_4 != '$') {
                    if (var3_3 > var2_2 && var0.charAt(var2_2) != '$') {
                        var1_1.add(SubCharSequence.from(var0, var2_2, var3_3));
                    }
                    var2_2 = var3_3 + 1;
                }
            }
            ++var3_3;
        }
        if (var0.length() > var2_2 && var0.charAt(var2_2) != '$') {
            var1_1.add(SubCharSequence.from(var0, var2_2, var0.length()));
        }
        return var1_1;
    }

    private static void parseDefinition(CharSequence charSequence, Map<SubCharSequence, CharSequence> map, ExpressionEvaluator expressionEvaluator) {
        CharSequence[] charSequenceArray = WLAParser.splitOperands(charSequence);
        if (charSequenceArray.length >= 3) {
            if (!StringUtilities.isEmpty(charSequenceArray[1]) && Character.isJavaIdentifierStart(charSequenceArray[1].charAt(0))) {
                charSequenceArray[2] = WLAParser.inlineDefinitions(charSequenceArray[2], map);
                try {
                    int n = expressionEvaluator.evaluate(charSequenceArray[2]);
                    WLAParser.addDefinition(charSequenceArray[1], Integer.toString(n), map);
                }
                catch (EvaluateException evaluateException) {
                }
                catch (UnknownIdentifierException unknownIdentifierException) {
                    WLAParser.addDefinition(charSequenceArray[1], "-1", map);
                }
            } else {
                System.err.println("A definition must be a valid identifier: " + charSequenceArray[1]);
            }
        } else if (charSequenceArray.length >= 2) {
            if (!StringUtilities.isEmpty(charSequenceArray[1]) && Character.isJavaIdentifierStart(charSequenceArray[1].charAt(0))) {
                WLAParser.addDefinition(charSequenceArray[1], "", map);
            } else {
                System.err.println("A definition must be a valid identifier: " + charSequenceArray[1]);
            }
        }
    }

    private static void parseIncludeDirective(CharSequence charSequence, int n, File file, CharSequence charSequence2, ParsingState parsingState, ExpressionEvaluator expressionEvaluator, int n2) {
        List<Z80SourceLine> list = parsingState.lines;
        CharSequence[] charSequenceArray = WLAParser.splitOperands(charSequence);
        if (StringUtilities.startsWithIgnoreCase(charSequenceArray[0], ".INCLUDE")) {
            if (charSequenceArray.length > 1) {
                CharSequence charSequence3 = charSequenceArray[1].charAt(0) == '\"' ? charSequenceArray[1].subSequence(1, charSequenceArray[1].length() - 1) : charSequenceArray[1];
                File file2 = WLAParser.getFile(charSequence3.toString(), parsingState);
                try {
                    list.add(new WLASourceLine(";* " + charSequence2));
                    WLAParser.readLines(file2, parsingState, n2 + 1);
                    list.add(new WLASourceLine(";* END OF " + charSequence2));
                }
                catch (IOException iOException) {
                    list.add(new WLASourceLine(";* END OF " + charSequence2 + ": Failed to read include file: " + iOException.getMessage()));
                }
            }
        } else if (StringUtilities.startsWithIgnoreCase(charSequenceArray[0], ".INCBIN")) {
            if (charSequenceArray.length > 1) {
                int n3;
                int n4 = 0;
                int n5 = -1;
                int n6 = 2;
                while (n6 + 1 < charSequenceArray.length) {
                    if (StringUtilities.equalsIgnoreCase(charSequenceArray[n6], "READ")) {
                        n5 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[n6 + 1]);
                    } else if (StringUtilities.equalsIgnoreCase(charSequenceArray[n6], "SKIP")) {
                        n4 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[n6 + 1]);
                    }
                    ++n6;
                }
                CharSequence charSequence4 = charSequenceArray[1].charAt(0) == '\"' ? charSequenceArray[1].subSequence(1, charSequenceArray[1].length() - 1) : charSequenceArray[1];
                File file3 = WLAParser.getFile(charSequence4.toString(), parsingState);
                if (!file3.exists() && parsingState.rootFile.getParentFile() != null) {
                    file3 = new File(parsingState.rootFile.getParentFile().getParentFile(), charSequence4.toString());
                }
                if (n5 < 0 && !file3.exists()) {
                    list.add(new WLASourceLine(charSequence2 + " ; File does not exist: " + file3.getAbsolutePath()));
                    return;
                }
                int n7 = n3 = n5 >= 0 ? n5 : (int)file3.length() - n4;
                if (n3 < 0 || n4 < 0 || n5 == -1073741824) {
                    list.add(new WLASourceLine(charSequence2 + " ; Failed to determine size"));
                    return;
                }
                try {
                    FileInputStream fileInputStream = new FileInputStream(file3);
                    fileInputStream.skip(n4);
                    int[] nArray = new int[Math.min(33, n3)];
                    byte[] byArray = new byte[nArray.length];
                    fileInputStream.read(byArray);
                    int n8 = 0;
                    while (n8 < nArray.length) {
                        nArray[n8] = byArray[n8] & 0xFF;
                        ++n8;
                    }
                    list.add(new WLASourceLine(n3, n, file, charSequence2, nArray));
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    list.add(new WLASourceLine(n3, n, file, charSequence2));
                }
                parsingState.sectionSize += n3;
            }
        } else if (StringUtilities.startsWithIgnoreCase(charSequenceArray[0], ".INCDIR")) {
            parsingState.incDir = (charSequenceArray[1].charAt(0) == '\"' ? charSequenceArray[1].subSequence(1, charSequenceArray[1].length() - 1) : charSequenceArray[1]).toString();
            list.add(new WLASourceLine(charSequence2));
        }
    }

    private static File getFile(String string, ParsingState parsingState) {
        File file;
        File file2;
        if (new File(string).isAbsolute()) {
            return new File(string);
        }
        File file3 = parsingState.rootFile;
        File file4 = file2 = parsingState.incDir.isEmpty() ? null : new File(file3.getParentFile(), parsingState.incDir);
        if (file2 != null && (file = new File(file2, string)).exists()) {
            return file;
        }
        return new File(file3.getParentFile(), string);
    }

    private static void parseDataDirective(CharSequence charSequence, int n, File file, CharSequence charSequence2, ParsingState parsingState) {
        ExpressionEvaluator expressionEvaluator = parsingState.expressionEvaluator;
        List<Z80SourceLine> list = parsingState.lines;
        int n2 = parsingState.maxBytePrefixLength;
        CharSequence[] charSequenceArray = WLAParser.splitOperands(charSequence);
        if (charSequenceArray[0].length() > 2 && Character.toUpperCase(charSequenceArray[0].charAt(1)) == 'D') {
            int n3;
            char c = Character.toUpperCase(charSequenceArray[0].charAt(2));
            int n4 = c == 'W' ? 2 : (c == 'B' ? 1 : (c == 'S' ? (charSequenceArray[0].length() > 3 && Character.toUpperCase(charSequenceArray[0].charAt(3)) == 'W' ? 2 : 1) : 0));
            int n5 = 0;
            int[] nArray = null;
            if (c == 'S') {
                n5 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]);
                if (charSequenceArray.length > 2 && (n3 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[2])) != -1073741824) {
                    if (n4 == 1 && n5 > 0) {
                        nArray = new int[]{n3};
                    } else {
                        nArray = new int[Math.min(n2, n5)];
                        int n6 = 0;
                        while (n6 < nArray.length) {
                            nArray[n6] = n3 >> 8 * (n6 & n4 - 1) & 0xFF;
                            ++n6;
                        }
                    }
                }
            } else if (charSequenceArray[0].length() > 3) {
                if (StringUtilities.startsWithIgnoreCase(charSequenceArray[0], "RND", 3)) {
                    n5 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]);
                } else if (StringUtilities.startsWithIgnoreCase(charSequenceArray[0], "SIN", 3) || StringUtilities.startsWithIgnoreCase(charSequenceArray[0], "COS", 3)) {
                    n5 = WLAParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]);
                }
            } else {
                n3 = 1;
                while (n3 < charSequenceArray.length) {
                    n5 = charSequenceArray[n3].charAt(0) == '\"' ? (n5 += charSequenceArray[n3].length() - StringUtilities.count(charSequenceArray[n3], "\\\"") - 2) : ++n5;
                    ++n3;
                }
                nArray = new int[Math.min(n2, n5 * n4)];
                n3 = 0;
                int n7 = 0;
                while (n7 < nArray.length) {
                    try {
                        int n8;
                        CharSequence charSequence3 = charSequenceArray[1 + n3 / n4];
                        if (charSequence3.charAt(0) == '\"') {
                            n8 = 1;
                            while (n8 < charSequence3.length() - 1 && n7 < nArray.length) {
                                if (charSequence3.charAt(n8) == '\\') {
                                    switch (charSequence3.charAt(++n8)) {
                                        case '\"': 
                                        case '\'': 
                                        case '\\': {
                                            nArray[n7++] = charSequence3.charAt(n8);
                                            break;
                                        }
                                        case 'r': {
                                            nArray[n7++] = 13;
                                            break;
                                        }
                                        case 'n': {
                                            nArray[n7++] = 10;
                                            break;
                                        }
                                        case 't': {
                                            nArray[n7++] = 9;
                                            break;
                                        }
                                        case '0': {
                                            nArray[n7++] = 0;
                                        }
                                    }
                                } else {
                                    nArray[n7++] = charSequence3.charAt(n8) < '\u0100' ? (int)charSequence3.charAt(n8) : -1;
                                }
                                ++n8;
                            }
                            --n7;
                        } else {
                            n8 = WLAParser.evaluateExpression(expressionEvaluator, charSequence3);
                            nArray[n7] = n8 != -1073741824 ? n8 >> 8 * (n3 & n4 - 1) & 0xFF : -1;
                        }
                    }
                    catch (AbortException abortException) {
                        throw abortException;
                    }
                    catch (RuntimeException runtimeException) {
                        nArray[n7] = -1;
                    }
                    ++n7;
                    ++n3;
                }
            }
            int n9 = n3 = n5 < 0 ? 0 : n5 * n4;
            if (n3 > 0) {
                list.add(new WLASourceLine(n3, n, file, charSequence2, nArray));
            } else {
                list.add(new WLASourceLine(charSequence2));
            }
            parsingState.sectionSize += n3;
        } else if (StringUtilities.startsWithIgnoreCase(charSequenceArray[0], ".ASC")) {
            int n10 = charSequenceArray[1].length() - StringUtilities.countEscapedChars(charSequenceArray[1]) - 2;
            list.add(new WLASourceLine(n10, n, file, charSequence2, null));
            parsingState.sectionSize += n10;
        } else {
            list.add(new WLASourceLine(charSequence2));
        }
    }

    private static int evaluateExpression(ExpressionEvaluator expressionEvaluator, CharSequence charSequence) {
        try {
            return expressionEvaluator.evaluate(charSequence);
        }
        catch (UnknownIdentifierException unknownIdentifierException) {
            return -1073741824;
        }
    }

    public static class ParseResult
    extends AbstractZ80ParseResult {
        private final List<Z80SourceLine> lines;
        private final List<Section> sections;
        private final List<Struct> structs;
        private final List<Exception> exceptions;
        private final ROMBankMap romBankMap;
        private final MemoryMap memoryMap;

        public ParseResult(ParsingState parsingState) {
            this.lines = parsingState.lines;
            this.sections = parsingState.sections;
            this.structs = parsingState.structs;
            this.exceptions = parsingState.exceptions;
            this.romBankMap = parsingState.romBankMap;
            this.memoryMap = parsingState.memoryMap;
        }

        @Override
        public List<Z80SourceLine> getLines() {
            return this.lines;
        }

        @Override
        public List<Section> getSections() {
            return this.sections;
        }

        public List<Struct> getStructs() {
            return this.structs;
        }

        @Override
        public List<Exception> getExceptions() {
            return this.exceptions;
        }

        @Override
        public ROMBankMap getROMBankMap() {
            return this.romBankMap;
        }

        @Override
        public MemoryMap getMemoryMap() {
            return this.memoryMap;
        }

        @Override
        public AssemblerDialect getDialect() {
            return WlaSmsDialect.getInstance();
        }
    }

    private static class ParsingState {
        Macro currentMacro;
        int enumCounter = -1;
        boolean asmDisabled;
        boolean blockComment;
        boolean skipToNextIfPart;
        boolean skipToEndIfPart;
        boolean romBankMapDefinition;
        boolean memoryMapDefinition;
        boolean ramSectionDefinition;
        boolean asciiTableDefinition;
        CharSequence structName;
        List<Struct.Field> structFields;
        ROMBankMap romBankMap;
        MemoryMap memoryMap;
        Section currentSection;
        int sectionSize;
        int org;
        int bank;
        int bankSize;
        int slot;
        int slotSize;
        int nestedIfs;
        String incDir = "";
        final List<Z80SourceLine> lines = new ArrayList<Z80SourceLine>();
        final List<Section> sections = new ArrayList<Section>();
        final List<Struct> structs = new ArrayList<Struct>();
        final List<Exception> exceptions = new ArrayList<Exception>();
        final File rootFile;
        final int maxBytePrefixLength;
        final Map<SubCharSequence, CharSequence> definitions = new HashMap<SubCharSequence, CharSequence>();
        final Map<SubCharSequence, Macro> macros = new HashMap<SubCharSequence, Macro>();
        final Map<SubCharSequence, Integer> macroCalls = new HashMap<SubCharSequence, Integer>();
        final Z80Assembler assembler;
        final ExpressionEvaluator expressionEvaluator;

        public ParsingState(File file, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator, int n) {
            this.rootFile = file;
            this.assembler = z80Assembler;
            this.expressionEvaluator = expressionEvaluator;
            this.maxBytePrefixLength = n;
        }

        public void addException(Exception exception) {
            this.exceptions.add(exception);
        }
    }
}

