/*
 * Decompiled with CFR 0.152.
 */
package util.string;

public class SubCharSequence
implements CharSequence {
    private final CharSequence value;
    private final int beginIndex;
    private final int endIndex;
    private final int length;
    protected String string;
    private int hash;

    private SubCharSequence(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
        this.string = charSequence.toString();
    }

    protected SubCharSequence(int n, int n2) {
        this.value = "";
        this.beginIndex = n;
        this.endIndex = n2;
        this.length = n2 - n;
    }

    protected SubCharSequence(CharSequence charSequence, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > charSequence.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        this.value = charSequence;
        this.beginIndex = n;
        this.endIndex = n2;
        this.length = n2 - n;
    }

    public static SubCharSequence from(CharSequence charSequence) {
        if (charSequence instanceof SubCharSequence) {
            return (SubCharSequence)charSequence;
        }
        if (charSequence == null) {
            return null;
        }
        return new SubCharSequence(charSequence);
    }

    public static SubCharSequence from(CharSequence charSequence, int n, int n2) {
        if (charSequence instanceof SubCharSequence) {
            SubCharSequence subCharSequence = (SubCharSequence)charSequence;
            if (subCharSequence.beginIndex == 0 && n == 0 && n2 == charSequence.length()) {
                return subCharSequence;
            }
        }
        return new SubCharSequence(charSequence, n, n2);
    }

    public CharSequence append(CharSequence charSequence) {
        if (charSequence.length() <= 0) {
            return this;
        }
        if (this.length() == 0) {
            return SubCharSequence.from(charSequence);
        }
        if (charSequence instanceof SubCharSequence) {
            SubCharSequence subCharSequence = (SubCharSequence)charSequence;
            if (subCharSequence.value == this.value && subCharSequence.beginIndex == this.endIndex) {
                return new SubCharSequence(this.value, this.beginIndex, subCharSequence.endIndex);
            }
        }
        return String.valueOf(this.toString()) + charSequence;
    }

    public SubCharSequence substring(int n) {
        return this.substring(n, this.length());
    }

    public SubCharSequence substring(int n, int n2) {
        return (SubCharSequence)this.subSequence(n, n2);
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int n) {
        if (n < 0 || this.beginIndex + n >= this.endIndex) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.value.charAt(this.beginIndex + n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        int n3 = this.beginIndex + n;
        int n4 = this.beginIndex + n2;
        if (n3 == this.beginIndex && n4 == this.endIndex) {
            return this;
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n4 > this.endIndex) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        int n5 = n4 - n3;
        if (n5 < 0) {
            throw new StringIndexOutOfBoundsException(n5);
        }
        return new SubCharSequence(this.value, n3, n4);
    }

    @Override
    public String toString() {
        if (this.string == null) {
            this.string = this.value.subSequence(this.beginIndex, this.endIndex).toString();
        }
        return this.string;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        if (this.string != null) {
            this.hash = this.string.hashCode();
            return this.hash;
        }
        int n = 0;
        int n2 = this.beginIndex;
        while (n2 < this.endIndex) {
            n = 31 * n + this.value.charAt(n2);
            ++n2;
        }
        this.hash = n;
        return this.hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            int n = this.length();
            if (n != charSequence.length()) {
                return false;
            }
            int n2 = this.endIndex;
            int n3 = n - 1;
            while (n3 >= 0) {
                if (this.value.charAt(--n2) != charSequence.charAt(n3)) {
                    return false;
                }
                --n3;
            }
            return true;
        }
        return false;
    }
}

