/*
 * Decompiled with CFR 0.152.
 */
package system;

import components.OutputListener;
import events.EventModel;
import system.EmulatableSystem;
import system.RamRomMap;

public interface DebuggableSystem
extends EmulatableSystem {
    public static final int ERROR_READ_UNINITIALIZED_MEMORY = -1;

    public void setAddress(int var1, int var2);

    public int getPrevPC();

    public int getPC();

    public int getSP();

    public int getStackPointer();

    public int getVirtualAddress();

    public int getROMsize();

    public int toVirtualAddress(int var1);

    public void setMemoryAt(int var1, int[] var2);

    public void setRegValue(int var1, int var2);

    public void setAdditionalRegValue(int var1, int var2);

    public String getAdditionalRegisterDescription(int var1);

    public boolean isFlagSet(int var1);

    public void setFlagSet(int var1, boolean var2);

    public void setInterruptsEnabled(boolean var1);

    public void setInputState(long var1);

    public void syncLazyState();

    public int getNumberOfPorts();

    public int getPortExtension();

    public int getStackStart();

    public int getStackLength();

    public int getRAMvalue(int var1);

    public int getBank0();

    public int getBank1();

    public int getBank2();

    public int getBank3();

    public int getRomBankSize();

    public int getBank(int var1);

    public void setBank(int var1, int var2);

    public boolean isSRAMenabled();

    public void setSRAMenabled(boolean var1);

    public int getSRAMbank();

    public int getScanline();

    public boolean isHalted();

    public boolean isVBlank();

    public boolean isInterruptsEnabled();

    public boolean isInterruptAddress(int var1);

    public boolean isConditionMet(int var1);

    public boolean canStepOver();

    public boolean isCartridgeEnabled();

    public boolean isBiosEnabled();

    public RamRomMap getRamRomMap();

    public EventModel createEventModel();

    public void addDebugEvent(DebugEvent var1, String var2);

    public void setDebugger(DebuggableSystem var1);

    public void addPortListener(OutputListener var1);

    public void removePortListener(OutputListener var1);

    public static enum DebugEvent {
        BREAKPOINT,
        EXCEPTION;

    }
}

