/*
 * Decompiled with CFR 0.152.
 */
package replay;

import components.input.FrameInputDevice;
import components.input.KeyInputProvider;
import msx.MSXKeyboard;
import replay.MSXInputLog;
import replay.ParseException;
import replay.ParseExceptionHandler;

public class MSXReplayKeyboard
extends MSXKeyboard
implements FrameInputDevice {
    private final int[] matrix = new int[11];
    private final MSXInputLog inputLog;
    private final ParseExceptionHandler parseExceptionHandler;
    private boolean done;

    public MSXReplayKeyboard(MSXInputLog mSXInputLog, KeyInputProvider keyInputProvider, ParseExceptionHandler parseExceptionHandler) {
        super(keyInputProvider);
        this.inputLog = mSXInputLog;
        this.parseExceptionHandler = parseExceptionHandler;
    }

    @Override
    public int readData(int n) {
        if (this.done) {
            return super.readData(n);
        }
        int n2 = this.getSelectedLine();
        if (n2 >= this.matrix.length) {
            return 255;
        }
        return (this.matrix[n2] ^ 0xFF) & 0xFF;
    }

    @Override
    public void frameFinished() {
        if (!this.done) {
            if (this.inputLog.hasNext()) {
                try {
                    this.inputLog.getNextInput(this.matrix);
                }
                catch (ParseException parseException) {
                    this.parseExceptionHandler.handleParseException(parseException);
                    this.done = true;
                }
            } else {
                this.done = true;
            }
        }
    }
}

