/*
 * Decompiled with CFR 0.152.
 */
package platform.viewers;

import common.ScreenUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import output.SoundAmplitudeListener;
import platform.Emulicious;
import platform.SoundOutput;
import platform.plotting.DynamicPlotModel;
import plotting.Plot;
import util.queue.CyclicIntBuffer;

public class SoundViewer {
    static SoundOutput soundOutput;
    private static String[] channelNames;
    private static int[] channelMin;
    private static int[] channelMax;
    private CyclicIntBuffer[] amplitudes = new CyclicIntBuffer[0];
    private DynamicPlotModel[] models = new DynamicPlotModel[0];
    private Plot[] plots = new Plot[0];
    final Window window;
    private static SoundViewer viewer;
    final Timer refreshTimer = new Timer(Emulicious.getProperties().getInt("SoundViewerUpdateMillis", 33), new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SoundViewer.refresh();
        }
    });
    private static final SoundAmplitudeListener AMPLITUDE_LISTENER;

    static {
        channelNames = new String[0];
        AMPLITUDE_LISTENER = new SoundAmplitudeListener(){

            @Override
            public void amplitude(int n, boolean bl, int n2) {
                SoundViewer.handleAmplitude(n, bl, n2);
            }

            @Override
            public void boundsChanged() {
                if (viewer != null) {
                    viewer.handleBoundsChanged();
                }
            }
        };
    }

    private SoundViewer(JFrame jFrame, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Sound Viewer");
        this.window.setIconImages(jFrame.getIconImages());
        this.layoutPlots();
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SoundViewer.this.refreshTimer.stop();
            }
        });
        this.setVisible(true);
        if (viewer == null || !viewer.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(jFrame);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(jFrame);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private Container getContentPane() {
        return this.window instanceof RootPaneContainer ? ((RootPaneContainer)((Object)this.window)).getContentPane() : null;
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    private void layoutPlots() {
        this.getContentPane().removeAll();
        Plot[] plotArray = new Plot[channelNames.length];
        CyclicIntBuffer[] cyclicIntBufferArray = new CyclicIntBuffer[plotArray.length];
        DynamicPlotModel[] dynamicPlotModelArray = new DynamicPlotModel[plotArray.length];
        int n = (plotArray.length - 1) / 3 + 1;
        int n2 = (plotArray.length - 1) / n + 1;
        this.window.setLayout(new GridLayout(n, n2));
        int n3 = 0;
        while (n3 < plotArray.length) {
            final int n4 = n3;
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(channelNames[n3]));
            cyclicIntBufferArray[n3] = new CyclicIntBuffer(Emulicious.getProperties().getInt("SoundViewerNumSamples", 4096));
            dynamicPlotModelArray[n3] = new DynamicPlotModel(cyclicIntBufferArray[n3], 130);
            plotArray[n3] = new Plot(dynamicPlotModelArray[n3]);
            plotArray[n3].setMinX(0.0);
            plotArray[n3].setMaxX(cyclicIntBufferArray[n3].capacity() - 1);
            plotArray[n3].setMinY(channelMin[n3]);
            plotArray[n3].setMaxY(channelMax[n3]);
            plotArray[n3].setZoomEnabled(false);
            plotArray[n3].setPanEnabled(false);
            jPanel.add((Component)plotArray[n3], "Center");
            final JCheckBox jCheckBox = new JCheckBox("Muted");
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    soundOutput.setChannelMuted(n4, jCheckBox.isSelected());
                }
            });
            jPanel.add((Component)jCheckBox, "South");
            this.window.add(jPanel);
            ++n3;
        }
        this.amplitudes = cyclicIntBufferArray;
        this.plots = plotArray;
        this.models = dynamicPlotModelArray;
        this.window.validate();
        this.window.repaint();
        this.updatePlots();
    }

    private void updatePlots() {
        if (!this.isShowing()) {
            return;
        }
        DynamicPlotModel[] dynamicPlotModelArray = this.models;
        int n = this.models.length;
        int n2 = 0;
        while (n2 < n) {
            DynamicPlotModel dynamicPlotModel = dynamicPlotModelArray[n2];
            dynamicPlotModel.firePlotModelChanged();
            ++n2;
        }
    }

    static void handleAmplitude(int n, boolean bl, int n2) {
        if (viewer != null && viewer.isVisible()) {
            String[] stringArray;
            if (soundOutput != null && (stringArray = soundOutput.getChannelNames()).length != channelNames.length) {
                channelNames = soundOutput.getChannelNames();
                channelMin = soundOutput.getChannelMinValues();
                channelMax = soundOutput.getChannelMaxValues();
                viewer.layoutPlots();
            }
            viewer.addAmplitude(n, bl, n2);
        }
    }

    void handleBoundsChanged() {
        int n = 0;
        while (n < this.plots.length) {
            this.plots[n].setMinX(0.0);
            this.plots[n].setMaxX(this.amplitudes[n].capacity() - 1);
            this.plots[n].setMinY(channelMin[n]);
            this.plots[n].setMaxY(channelMax[n]);
            ++n;
        }
    }

    private void addAmplitude(int n, boolean bl, int n2) {
        if (!bl && n < this.amplitudes.length) {
            this.amplitudes[n].add(n2);
        }
    }

    public static void setSoundOutput(SoundOutput soundOutput) {
        if (SoundViewer.soundOutput != null) {
            SoundViewer.soundOutput.removeAmplitudeListener(AMPLITUDE_LISTENER);
        }
        SoundViewer.soundOutput = soundOutput;
        if (soundOutput != null) {
            channelNames = soundOutput.getChannelNames();
            channelMin = soundOutput.getChannelMinValues();
            channelMax = soundOutput.getChannelMaxValues();
            if (viewer != null) {
                soundOutput.addAmplitudeListener(AMPLITUDE_LISTENER);
                viewer.layoutPlots();
            }
        }
    }

    public static void open(JFrame jFrame, boolean bl) {
        if (viewer == null) {
            viewer = new SoundViewer(jFrame, Emulicious.isUseFrames());
            if (soundOutput != null) {
                soundOutput.addAmplitudeListener(AMPLITUDE_LISTENER);
            }
            viewer.setVisible(true);
        } else if (!bl) {
            viewer.setVisible(true);
        }
        if (viewer.isShowing()) {
            SoundViewer.viewer.refreshTimer.restart();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SoundViewer.refresh();
            }
        });
    }

    public static void close() {
        if (viewer != null) {
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Open", "" + viewer.isVisible());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "X", "" + viewer.getX());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Y", "" + viewer.getY());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Width", "" + viewer.getWidth());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Height", "" + viewer.getHeight());
            SoundViewer.viewer.refreshTimer.stop();
            viewer.dispose();
            viewer = null;
            if (soundOutput != null) {
                soundOutput.removeAmplitudeListener(AMPLITUDE_LISTENER);
            }
        }
    }

    static void refresh() {
        if (viewer != null) {
            viewer.updatePlots();
        }
    }
}

