/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import assembler.AbortException;
import assembler.HexStrings;
import assembler.SourceMap;
import assembler.Z80Instruction;
import assembler.parsers.ExpressionEvaluator;
import assembler.parsers.UnknownIdentifierException;
import assembler.rgbds.RGBDSMapFile;
import common.ComponentTraversalGroup;
import common.FileChangeWatcher;
import common.FileChooser;
import common.FontUtilities;
import common.HistoryBox;
import common.KeySettings;
import common.MenuItem;
import common.Properties;
import common.PropertyBasedKeySettings;
import common.ScreenUtilities;
import components.OutputListener;
import debugfiles.WarningHandler;
import disassembler.CSourceMap;
import disassembler.LR35902Disassembler;
import disassembler.RGBDSSectionProvider;
import disassembler.SectionProvider;
import disassembler.Symbols;
import disassembler.Z80Disassembler;
import disassembler.dialects.AssemblerDialect;
import events.DefaultEventFilterModel;
import events.EventFilterModel;
import events.EventViewerTable;
import evscript.EvscriptDebugInfo;
import evscript.EvscriptSourceMap;
import expressions.ConcatenatedExpression;
import expressions.ParseException;
import expressions.UnknownVariableException;
import expressions.VariableProvider;
import highlighting.ConTEXTHighlighter;
import highlighting.Highlighter;
import highlighting.NotepadPlusPlusHighlighter;
import java.awt.AWTKeyStroke;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.EventObject;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import patching.IPS;
import platform.AnonymousLabelRejector;
import platform.Emulicious;
import platform.EmuliciousIcons;
import platform.GoToDialog;
import platform.LabelProvider;
import platform.LabelProviderUtilities;
import platform.MemoryEditor;
import platform.TabbedPane;
import platform.debugger.AddBreakpointDialog;
import platform.debugger.AssemblerWindow;
import platform.debugger.Breakpoint;
import platform.debugger.BreakpointSelectionWindow;
import platform.debugger.BreakpointWindow;
import platform.debugger.CallStackList;
import platform.debugger.Console;
import platform.debugger.CoverageWindow;
import platform.debugger.DAPDebugger;
import platform.debugger.DebuggerIcons;
import platform.debugger.DebuggerOverlayTable;
import platform.debugger.DebuggerTestCaseExecutor;
import platform.debugger.DisassemblerSettingsDialog;
import platform.debugger.EvaluateException;
import platform.debugger.ExpressionsHelpDialog;
import platform.debugger.FlowArrowModel;
import platform.debugger.InvalidBreakpoint;
import platform.debugger.IsConstantException;
import platform.debugger.OutlineElement;
import platform.debugger.OutlineTree;
import platform.debugger.PlotterWindow;
import platform.debugger.ProfilerWindow;
import platform.debugger.RAMSearchWindow;
import platform.debugger.RAMWatchWindow;
import platform.debugger.ReferenceHierarchyWindow;
import platform.debugger.RegisterTableModel;
import platform.debugger.SystemDebugger;
import platform.debugger.TracerWindow;
import platform.debugger.VariablesTree;
import platform.debugger.Watchpoint;
import platform.plotting.DynamicPlotModel;
import plotting.Plot;
import plotting.PlotColorModel;
import system.DebuggableSystem;
import system.GameBoy;
import system.MSX;
import system.RamRomMap;
import util.IntIterator;
import util.deque.ArrayIntDeque;
import util.map.HashIntBiMap;
import util.map.HashIntMap;
import util.map.HashMap;
import util.map.IntBiMap;
import util.map.IntMap;
import util.map.Map;
import util.queue.CyclicIntBuffer;
import util.queue.CyclicIntStack;
import util.string.StringUtilities;

public class Debugger
implements SystemDebugger.SystemListener,
SystemDebugger.BreakpointListener,
SystemDebugger.MessageReceiver {
    public static final String PREFIX_KEYS = "DebuggerKeys";
    private static final List<Z80Disassembler.SourceLine> DISASSEMBLING = Arrays.asList(Z80Disassembler.SourceLine.DISASSEMBLING);
    private static final Set<String> TOOLBAR_MENUS = new HashSet<String>(Arrays.asList("Navigate", "Run", "Tools"));
    private final Map<JMenuItem, AbstractButton> TOOL_BAR_MENU_MAP = new IdentityHashMap<JMenuItem, AbstractButton>();
    private static final List<String> NO_LABELS = Collections.emptyList();
    private static final Color CONDITION_MET_COLOR = new Color(0, 128, 0);
    private static final Color CODE_COLOR = new Color(2514815);
    private static final Color DATA_COLOR = Color.RED;
    private static final Color ASM_COLOR = new Color(0x4040FF);
    private static final Color INCLUDE_COLOR = new Color(0x4040FF);
    private static final Color SECTION_COLOR = new Color(0x4040FF);
    private static final Color WINDOW_BACKGROUND_DARK_MODE = new Color(0x33393B);
    private static final Color WINDOW_FOREGROUND_DARK_MODE = new Color(0xE0E0E0);
    private static final Color LIGHT_HIGHLIGHT_DARK_MODE = new Color(4213582);
    private static final Color SHADOW_DARK_MODE = new Color(2369320);
    private static final Color DARK_SHADOW_DARK_MODE = Color.BLACK;
    private static final Color LINE_BORDER_COLOR_DARK_MODE = new Color(1777440);
    private static final Border LINE_BORDER_DARK_MODE = BorderFactory.createLineBorder(LINE_BORDER_COLOR_DARK_MODE);
    static final String[] HEX_STRINGS_WORD = new String[65536];
    static final Color[] COLORS_TRACE = new Color[98];
    static final Color COLOR_HIGHLIGHT = new Color(-2139078656, true);
    private static final int MAX_CONSOLE_LINES = 10000;
    private static final int CONSOLE_BUFFER_SIZE = 65536;
    private static final int SIZE_NAVIGATION_STACK = 32;
    private static final String CONDITION_MET_HIGHLIGHTED = "condition <font color=\"green\">met</font>";
    private static final String CONDITION_MET_HIGHLIGHTED_COMMENT = "\t; condition <font color=\"green\">met</font>";
    private static final String CONDITION_MET = "condition met";
    private static final String CONDITION_MET_COMMENT = "\t; condition met";
    private static final String CONDITION_UNMET_HIGHLIGHTED = "condition <font color=\"red\">unmet</font>";
    private static final String CONDITION_UNMET_HIGHLIGHTED_COMMENT = "\t; condition <font color=\"red\">unmet</font>";
    private static final String CONDITION_UNMET = "condition unmet";
    private static final String CONDITION_UNMET_COMMENT = "\t; condition unmet";
    private final JTable table;
    private JTable registers;
    private JTable expressions;
    private DebuggerOverlayTable overlays;
    private JTable breakpoints;
    private MemoryEditor memoryEditor;
    private EventViewerTable eventViewer;
    private final FlowArrowModel flowArrowModel = new DebuggerFlowArrowModel();
    private final Console console = new Console(4, 60, 65536, 10000){

        @Override
        public Color getForeground() {
            return Debugger.this.table != null ? Debugger.this.table.getForeground() : super.getForeground();
        }

        @Override
        public Color getSelectedTextColor() {
            return Debugger.this.table != null ? Debugger.this.table.getSelectionForeground() : super.getSelectedTextColor();
        }

        @Override
        public Color getBackground() {
            return Debugger.this.table != null ? Debugger.this.table.getBackground() : super.getBackground();
        }

        @Override
        public Color getSelectionColor() {
            return Debugger.this.table != null ? Debugger.this.table.getSelectionBackground() : super.getSelectionColor();
        }

        @Override
        public Font getFont() {
            return Debugger.this.table != null ? Debugger.this.table.getFont() : super.getFont();
        }
    };
    private final TabbedPane westTabbedPane = new DebuggerTabbedPane();
    private final TabbedPane southTabbedPane;
    private final OutlineTree outline;
    private final VariablesTree variablesTree;
    private final JList<Object> stack;
    private final DebuggerCallStackModel callStackModel;
    private final CallStackList callStack;
    private JCheckBox[] flags;
    private final JPanel flagsPanel = new JPanel(){
        {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        }

        @Override
        public Color getBackground() {
            return this.shouldUseDarkMode() ? WINDOW_BACKGROUND_DARK_MODE : super.getBackground();
        }

        @Override
        public Color getForeground() {
            return this.shouldUseDarkMode() ? WINDOW_FOREGROUND_DARK_MODE : super.getForeground();
        }

        private boolean shouldUseDarkMode() {
            return Debugger.this.table != null && super.getBackground() != null && Debugger.this.table.getBackground().getRed() < super.getBackground().getRed();
        }
    };
    private final JLabel interrupts;
    private final JSplitPane horizontalSplitPaneEast;
    private final JSplitPane horizontalSplitPaneWest;
    private final JSplitPane eastCenterSplitPane;
    private final JSplitPane verticalSplitPane;
    private final JPanel statusBar = new JPanel(new BorderLayout(5, 5)){

        @Override
        public Color getBackground() {
            return this.shouldUseDarkMode() ? WINDOW_BACKGROUND_DARK_MODE : super.getBackground();
        }

        @Override
        public Color getForeground() {
            return this.shouldUseDarkMode() ? WINDOW_FOREGROUND_DARK_MODE : super.getForeground();
        }

        private boolean shouldUseDarkMode() {
            return Debugger.this.table != null && super.getBackground() != null && Debugger.this.table.getBackground().getRed() < super.getBackground().getRed();
        }
    };
    private final JLabel status = new JLabel(" "){

        @Override
        public Color getForeground() {
            return Debugger.this.statusBar.getForeground();
        }
    };
    int breakpointsTabIndex = Integer.MIN_VALUE;
    int expressionsTabIndex = Integer.MIN_VALUE;
    int overlaysTabIndex = Integer.MIN_VALUE;
    int memoryEditorTabIndex = Integer.MIN_VALUE;
    int eventsTabIndex = Integer.MIN_VALUE;
    int consoleTabIndex = Integer.MIN_VALUE;
    private final JToggleButton logBreakpoints = new JToggleButton();
    private final ButtonModel skipBreakpoints = new JToggleButton.ToggleButtonModel(){

        @Override
        public boolean isSelected() {
            return Debugger.this.systemDebugger != null && Debugger.this.systemDebugger.isSkipBreakpoints();
        }

        @Override
        public void setSelected(boolean bl) {
            Debugger.this.systemDebugger.setSkipBreakpoints(bl);
        }
    };
    private final ButtonModel skipExceptions = new JToggleButton.ToggleButtonModel(){

        @Override
        public boolean isSelected() {
            return Debugger.this.systemDebugger != null && Debugger.this.systemDebugger.isSkipExceptions();
        }

        @Override
        public void setSelected(boolean bl) {
            Debugger.this.systemDebugger.setSkipExceptions(bl);
        }
    };
    SystemDebugger systemDebugger;
    private final MenuItem menuItemSaveAs = new MenuItem("Save As...", 115);
    private final MenuItem menuItemLoadSymbols = new MenuItem("Load Symbols...", 108);
    private final MenuItem menuItemReloadSymbols = new MenuItem("Reload Symbols", 114);
    private final MenuItem menuItemGoTo = new MenuItem("Go To", 103);
    private final MenuItem menuItemGotoCurrentInstruction = new MenuItem("Go To Current Instruction", 99);
    private final MenuItem menuItemGoToDestination = new MenuItem("Go To Destination", 100);
    private final MenuItem menuItemReferenceHierarchy = new MenuItem("Open Reference Hierarchy", 104);
    private final MenuItem menuItemOpenInMemoryEditor = new MenuItem("Open in Memory Editor", 109);
    private final MenuItem menuItemSelectReferencedMemory = new MenuItem("Select Referenced Memory", 101);
    private final MenuItem menuItemWatch = new MenuItem("Watch", 119);
    private final MenuItem menuItemFind = new MenuItem("Find...", 102);
    private final MenuItem menuItemPrevAddress = new MenuItem("Previous Address in Trace", 112);
    private final MenuItem menuItemNextAddress = new MenuItem("Next Address in Trace", 110);
    private final MenuItem menuItemBack = new MenuItem("Back", 107);
    private final MenuItem menuItemForward = new MenuItem("Forward", 111);
    private final JMenu menuRun;
    private final MenuItem menuItemResume = new MenuItem("Resume", 101);
    private final MenuItem menuItemSuspend = new MenuItem("Suspend", 115);
    private final MenuItem menuItemStepInto = new MenuItem("Step Into", 105);
    private final MenuItem menuItemStepReturn = new MenuItem("Step Return", 114);
    private final MenuItem menuItemStepOver = new MenuItem("Step Over", 111);
    private final MenuItem menuItemStepBack = new MenuItem("Step Back", 97);
    private final MenuItem menuItemStepBackOver = new MenuItem("Step Back Over", 118);
    private final MenuItem menuItemStepBackReturn = new MenuItem("Step Back Return", 110);
    private final MenuItem menuItemAdvanceFrame = new MenuItem("Advance Frame", 102);
    private final MenuItem menuItemRunToLine = new MenuItem("Run To Line", 108);
    private final MenuItem menuItemRunBackwardsToLine = new MenuItem("Run Backwards To Line", 119);
    private final JCheckBoxMenuItem menuItemSuspendOnOpen = new JCheckBoxMenuItem("Suspend On Open");
    private final JCheckBoxMenuItem menuItemBringToTopUponSuspend = new JCheckBoxMenuItem("Bring To Top Upon Suspend");
    private final MenuItem menuItemUndo = new MenuItem("Undo");
    private final MenuItem menuItemRedo = new MenuItem("Redo");
    private final MenuItem menuItemJumpToLine = new MenuItem("Jump To Line", 106);
    private final MenuItem menuItemToggleBreakpoint = new MenuItem("Toggle Breakpoint", 98);
    private final MenuItem menuItemBreakpoints = new MenuItem("Breakpoints", 98);
    private final MenuItem menuItemTracer = new MenuItem("Trace Logger", 116);
    private final MenuItem menuItemProfiler = new MenuItem("Profiler", 112);
    private final MenuItem menuItemCoverage = new MenuItem("Coverage", 103);
    private final MenuItem menuItemPlotter = new MenuItem("Plotter", 111);
    private final MenuItem menuItemRamWatch = new MenuItem("RAM Watch", 119);
    private final MenuItem menuItemRamSearch = new MenuItem("RAM Search", 101);
    private final MenuItem menuItemExpressionsHelp = new MenuItem("Expressions", 101);
    private final JToolBar toolBar;
    private final DefaultTableModel expressionsTableModel;
    private DebuggerTestCaseExecutor testCaseExecutor;
    private int[] tableRows;
    private int[] tableCpuRows;
    private int[] oldCpuRows;
    private IntBiMap tableRAMrows = new HashIntBiMap();
    private IntBiMap tableSRAMrows = new HashIntBiMap();
    private IntBiMap tablePortRows = new HashIntBiMap();
    private boolean determineSections = true;
    private String currentLabel;
    private String[] stackLabels;
    private boolean interruptJustTaken;
    private List<String> poppedStackLabels = new ArrayList<String>();
    private List<Integer> poppedReturnPCs = new ArrayList<Integer>();
    private List<String> exPoppedStackLabels = new ArrayList<String>();
    private List<Integer> exPoppedReturnAddresses = new ArrayList<Integer>();
    private int prevAddress;
    private boolean dataExecution;
    private final JLabel ruler;
    private final JLabel overviewRuler;
    private static final int NUM_CPU_USAGE_VALUES = 256;
    private final CyclicIntBuffer cpuUsage = new CyclicIntBuffer(256);
    private final DynamicPlotModel cpuUsageModel = new DynamicPlotModel(this.cpuUsage, 1);
    private final Plot cpuUsagePlot = new Plot(this.cpuUsageModel){
        private Border defaultBorder;
        private Border defaultTitleBorderBorder;

        @Override
        public Color getBackground() {
            return this.shouldUseDarkMode() ? WINDOW_BACKGROUND_DARK_MODE : super.getBackground();
        }

        @Override
        public Color getForeground() {
            return this.shouldUseDarkMode() ? WINDOW_FOREGROUND_DARK_MODE : super.getForeground();
        }

        private boolean shouldUseDarkMode() {
            return Debugger.this.table != null && super.getBackground() != null && Debugger.this.table.getBackground().getRed() < super.getBackground().getRed();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(Debugger.this.registers.getWidth(), 128);
        }

        @Override
        protected void paintBorder(Graphics graphics) {
            Border border = this.getBorder();
            if (this.defaultBorder == null) {
                this.defaultBorder = border;
                if (this.defaultBorder instanceof TitledBorder) {
                    this.defaultTitleBorderBorder = ((TitledBorder)this.defaultBorder).getBorder();
                }
            }
            if (border instanceof TitledBorder) {
                TitledBorder titledBorder = (TitledBorder)border;
                Border border2 = titledBorder.getBorder();
                titledBorder.setTitleColor(this.getForeground());
                titledBorder.setBorder(this.shouldUseDarkMode() ? LINE_BORDER_DARK_MODE : this.defaultTitleBorderBorder);
                if (titledBorder.getBorder() != border2) {
                    this.revalidate();
                    this.repaint();
                }
            } else {
                this.setBorder(this.shouldUseDarkMode() ? LINE_BORDER_DARK_MODE : this.defaultBorder);
            }
            super.paintBorder(graphics);
        }
    };
    private int[] memory;
    private List<Z80Disassembler.SourceLine> lines = DISASSEMBLING;
    private Z80Disassembler.CpuLines cpuLines = new Z80Disassembler.CpuLines(64);
    private Z80Disassembler.CpuLines scratchCpuLines = new Z80Disassembler.CpuLines(this.cpuLines.getNumberOfBlocks());
    private HashMap<Z80Disassembler.CpuLines> bankedCpuLines = new HashMap();
    private boolean shouldUpdateCpuLines;
    private long cpuLinesRangeRequiresUpdate;
    private BitSet romSymbolKeys;
    private BitSet ramSymbolKeys;
    private Map<String, List<Symbols.Symbol>> symbols = new java.util.HashMap<String, List<Symbols.Symbol>>();
    private SectionProvider sectionProvider;
    private util.map.Map<String> portNames;
    private Map<String, Integer> portAddresses = new java.util.HashMap<String, Integer>();
    private List<Symbols.Symbol> ramSymbols = Collections.emptyList();
    private HashMap<List<String>> labels = new HashMap();
    private boolean highlighting;
    private boolean highlightWhileRunning;
    private File highlighterFile;
    private Highlighter highlighter;
    private Color currentLineForeground = Color.BLACK;
    private Color currentLineBackground = Color.CYAN;
    private Color darkerCurrentLineBackground = this.currentLineBackground.darker();
    private Color brighterCurrentLineBackground = this.currentLineBackground.brighter();
    private boolean disableBringToTopUponSuspend = false;
    private File romFile;
    private File sourceFile;
    private File symbolFile;
    private File debugfileFile;
    private File expFile;
    private File ovrFile;
    private File bpsFile;
    private File cvgFile;
    private File prfFile;
    private String eventFiltersProperty;
    private FileChangeWatcher symbolFileChangeWatcher;
    private final List<FileChangeWatcher> debugfileFileChangeWatchers = new ArrayList<FileChangeWatcher>();
    private final Properties properties;
    private final KeySettings keySettings;
    private boolean wasSuspended;
    int address = Integer.MIN_VALUE;
    int pc = -1;
    private int prevExecutedInstructions;
    private int addressToHighlightDestinationRow;
    private int addressToHighlightSourceRow;
    private int[] branchArrowSources = new int[4];
    private int[] branchArrowSourceRows = new int[4];
    private int[] branchArrowDestinationRows = new int[4];
    private Boolean[] branchArrowConditionsMet = new Boolean[4];
    private int selectedWordStart = -1;
    private int selectedWordEnd = -1;
    private LinkedList<Integer> backwardStack = new LinkedList();
    private LinkedList<Integer> forwardStack = new LinkedList();
    private int lastTraceIndex;
    private boolean outlineDirty;
    private volatile boolean updatingDisassembly = true;
    volatile boolean loadingSources;
    volatile boolean cancelLoadingSources;
    final Window window;
    private static Debugger debugger;
    private static boolean forceLoadSources;
    private static boolean forceSuspendOnOpen;
    private static boolean dapDebugging;
    private int lastMappedAddress;
    private EvscriptDebugInfo evscriptDebugInfo;
    private final ArrayIntDeque updatedMemory = new ArrayIntDeque();
    private final Timer updateMemoryTimer = new Timer(50, new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ArrayIntDeque arrayIntDeque = Debugger.this.updatedMemory;
            synchronized (arrayIntDeque) {
                if (!Debugger.this.updatedMemory.isEmpty()) {
                    int[] nArray = new int[Debugger.this.updatedMemory.size()];
                    int n = 0;
                    IntIterator intIterator = Debugger.this.updatedMemory.intIterator();
                    while (intIterator.hasNext()) {
                        nArray[n++] = intIterator.next();
                    }
                    Debugger.this.updatedMemory.clear();
                    Debugger.this.memoryUpdated(nArray);
                    Debugger.this.southTabbedPane.setBold(Debugger.this.memoryEditorTabIndex, Debugger.this.southTabbedPane.getSelectedIndex() != Debugger.this.memoryEditorTabIndex);
                }
            }
        }
    }){
        {
            this.setRepeats(false);
        }
    };
    private final Timer updateReadAssemblyTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Debugger.this.sourceFile != null && Debugger.this.sourceFile.exists()) {
                try {
                    if (!Debugger.this.reloadSymbols()) {
                        Debugger.this.loadingSources = true;
                        Debugger.this.readAssemblyLines(Debugger.this.sourceFile);
                        Debugger.this.loadingSources = false;
                        int n = Debugger.this.getVisibleAddress();
                        int n2 = Debugger.this.getSelectedAddress();
                        Debugger.this.updateRows(Debugger.this.lines);
                        Debugger.this.systemDebugger.requestGUIupdate();
                        Debugger.this.setSelectedAddress(n2, false, false);
                        Debugger.this.scrollToVisible(n);
                        Debugger.this.window.repaint();
                        PlotterWindow.update();
                    }
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }){
        {
            this.setRepeats(false);
        }
    };
    private final KeyListener assemblerKeyListener = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            int n = Debugger.this.getSelectedAddress();
            int n2 = n >= 0 ? n : Debugger.this.systemDebugger.convertAddress(n);
            int n3 = n < 0 && Debugger.this.systemDebugger.isROMaddress(n2) ? Debugger.this.systemDebugger.mapAddress(n2) : n2;
            char c = keyEvent.getKeyChar();
            if ((keyEvent.getModifiersEx() & 0x2380) == 0 && n3 >= 0) {
                AssemblerWindow.open(Debugger.this.window, debugger, c, n3, Debugger.this.symbols, Debugger.this.portAddresses);
            }
        }
    };
    private final OutputListener memoryEditorListener = new OutputListener(){

        @Override
        public void outputAvailable(int n, int n2, int n3) {
            if (n != 0) {
                Debugger.this.window.repaint();
                return;
            }
            Debugger.this.memoryChanged(n2);
        }
    };
    private final TableModelListener repaintTableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            Debugger.this.window.repaint();
        }
    };
    private static final LabelProvider labelProvider;
    private static final LabelProvider labelProviderRAM;
    private static final LabelProvider labelProviderSRAM;
    private final LabelProvider labelProviderPorts = new LabelProvider(){

        @Override
        public boolean hasLabel(int n) {
            return Debugger.this.portNames.containsKey(n);
        }

        @Override
        public List<String> getLabels(int n) {
            return Arrays.asList((String)Debugger.this.portNames.get(n));
        }
    };
    private final KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (!Debugger.this.window.isActive() || keyEvent.getID() != 401) {
                return false;
            }
            if (keyEvent.getKeyCode() == 9 && ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0 || keyEvent.isControlDown())) {
                Emulicious.toTop();
            }
            if (keyEvent.getKeyCode() == 84 && keyEvent.isControlDown() && keyEvent.isAltDown()) {
                if (Debugger.this.testCaseExecutor == null) {
                    Debugger.this.testCaseExecutor = new DebuggerTestCaseExecutor(Debugger.this.window, debugger);
                }
                if (keyEvent.isShiftDown()) {
                    Debugger.this.testCaseExecutor.showMultiTestCaseFileChooser();
                } else {
                    Debugger.this.testCaseExecutor.showTestCaseFileChooser();
                }
            }
            return false;
        }
    };
    private static FindDialog findDialog;
    private final Runnable UPDATE_RUNNABLE = new Runnable(){

        @Override
        public void run() {
            JScrollPane jScrollPane;
            Component component;
            Debugger.this.updateToolBarButtons();
            if (Debugger.this.address >= 0 && Debugger.this.address < Debugger.this.tableRows.length) {
                Debugger.this.repaintRow(Debugger.this.tableRows[Debugger.this.address]);
            } else if (Debugger.this.address < 0 && Debugger.this.pc >= 0) {
                Debugger.this.repaintRow(Debugger.this.getCpuRow(Debugger.this.pc));
            }
            Debugger.this.address = Debugger.this.systemDebugger.getAddress();
            boolean bl = Debugger.this.pc != Debugger.this.systemDebugger.getPrevPC();
            Debugger.this.pc = Debugger.this.systemDebugger.getPrevPC();
            if (Debugger.this.address >= 0 && Debugger.this.address < Debugger.this.tableRows.length) {
                Debugger.this.repaintRow(Debugger.this.tableRows[Debugger.this.address]);
            } else if (Debugger.this.address < 0) {
                Debugger.this.repaintRow(Debugger.this.getCpuRow(Debugger.this.pc));
            }
            int n = Debugger.this.systemDebugger.getExecutedInstructions();
            boolean bl2 = !(!bl && n == Debugger.this.prevExecutedInstructions || !Boolean.parseBoolean(Debugger.this.properties.getProperty("FollowCurrentInstruction")) && !Debugger.this.systemDebugger.isSuspended());
            Debugger.this.prevExecutedInstructions = n;
            boolean bl3 = Debugger.this.updateFlags();
            if ((!bl2 || !Debugger.this.scrollCurrentInstructionToVisible()) && bl3 || Debugger.this.systemDebugger.isSuspended()) {
                Debugger.this.table.repaint();
                Debugger.this.ruler.repaint();
                Debugger.this.overviewRuler.repaint();
            }
            Debugger.this.registers.repaint();
            if (Debugger.this.southTabbedPane.getSelectedIndex() == Debugger.this.expressionsTabIndex) {
                Debugger.this.expressions.repaint();
            }
            if (Debugger.this.southTabbedPane.getSelectedIndex() == Debugger.this.memoryEditorTabIndex) {
                Debugger.this.memoryEditor.update();
            }
            if (Debugger.this.southTabbedPane.getSelectedIndex() == Debugger.this.eventsTabIndex) {
                Debugger.this.eventViewer.updateTable();
            }
            if ((component = Debugger.this.westTabbedPane.getSelectedComponent()) instanceof JScrollPane && (jScrollPane = (JScrollPane)component).getViewport().getView() == Debugger.this.variablesTree) {
                Debugger.this.variablesTree.repaint();
            }
            if (Debugger.this.outlineDirty) {
                try {
                    Debugger.this.outlineDirty = !Debugger.this.outline.update();
                }
                catch (Exception exception) {}
            }
            Debugger.this.interrupts.setText(Debugger.this.systemDebugger.isInterruptsEnabled() ? "EI" : "DI");
            int n2 = (Debugger.this.systemDebugger.getStackLength() - 1 - (Debugger.this.systemDebugger.getStackPointer() - 1 - Debugger.this.systemDebugger.getStackStart()) & Debugger.this.systemDebugger.getStackLength() - 1) / 2;
            if (n2 >= 0) {
                Rectangle rectangle = Debugger.this.stack.getCellBounds(n2, n2);
                if (rectangle != null) {
                    Rectangle rectangle2 = Debugger.this.stack.getVisibleRect();
                    rectangle.height = rectangle2.height / 2;
                    rectangle.y -= rectangle.height / 2;
                    Debugger.this.stack.scrollRectToVisible(rectangle);
                    if (((Debugger)Debugger.this).stack.getVisibleRect().y == rectangle2.y || Debugger.this.systemDebugger.isSuspended()) {
                        Debugger.this.stack.repaint();
                    }
                } else {
                    Debugger.this.stack.repaint();
                }
            }
            Debugger.this.callStackModel.update();
            Debugger.this.callStack.update();
            if (Debugger.this.systemDebugger.isSuspended()) {
                TracerWindow.update();
                Emulicious.updateTitle();
            }
            if (Debugger.this.systemDebugger.isRecordCoverage()) {
                CoverageWindow.update(Debugger.this.systemDebugger.isSuspended());
            }
        }
    };

    static {
        labelProvider = new LabelProvider(){
            private final List<String> emptyLabel = Arrays.asList("");

            @Override
            public boolean hasLabel(int n) {
                return Z80Disassembler.hasLabel(n) || Z80Disassembler.hasDataLabel(n) || debugger != null && debugger.getLoadedSymbols().containsKey(n);
            }

            @Override
            public List<String> getLabels(int n) {
                if (debugger == null) {
                    if (this.hasLabel(n)) {
                        return this.emptyLabel;
                    }
                    return NO_LABELS;
                }
                return debugger.getLabels(n);
            }
        };
        labelProviderRAM = new LabelProvider(){
            private final List<String> emptyLabel = Arrays.asList("");

            @Override
            public boolean hasLabel(int n) {
                return Z80Disassembler.hasRAMlabel(n) && (debugger == null || !debugger.getLoadedRamSymbols().containsKey(n - 1)) || debugger != null && debugger.getLoadedRamSymbols().containsKey(n);
            }

            @Override
            public List<String> getLabels(int n) {
                if (debugger == null) {
                    if (this.hasLabel(n)) {
                        return this.emptyLabel;
                    }
                    return NO_LABELS;
                }
                if (Z80Disassembler.hasRAMlabel(n) || debugger.getLoadedRamSymbols().containsKey(n) || debugger.getLoadedRamSymbols().containsKey(n - 1)) {
                    return debugger.getRamLabels(n);
                }
                return NO_LABELS;
            }
        };
        labelProviderSRAM = new LabelProvider(){

            @Override
            public boolean hasLabel(int n) {
                return Z80Disassembler.hasSRAMlabel(n);
            }

            @Override
            public List<String> getLabels(int n) {
                String string = Debugger.getSramLabel(n);
                return string != null ? Arrays.asList(Debugger.getSramLabel(n)) : NO_LABELS;
            }
        };
    }

    private Debugger(JFrame jFrame, SystemDebugger systemDebugger, int[] nArray, boolean bl) {
        Object object;
        Object object2;
        JLabel jLabel;
        JTable jTable;
        Properties properties;
        this.window = bl ? new JFrame() : new JDialog();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Debugger");
        this.window.setIconImages(jFrame.getIconImages());
        this.properties = properties = Emulicious.getProperties();
        this.keySettings = new PropertyBasedKeySettings(properties, PREFIX_KEYS);
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Debugger.this.window.setVisible(false);
                if (!dapDebugging) {
                    Debugger.close();
                }
            }
        });
        this.table = jTable = this.createDisassemblerTable();
        DebuggerScrollPane debuggerScrollPane = new DebuggerScrollPane(this, jTable){

            @Override
            protected JViewport createViewport() {
                return new JViewport(jTable){
                    private final Timer throttleSetViewSize = new Timer(1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            this.doSetViewSize();
                        }
                    });
                    private Dimension preferredViewSize = new Dimension();
                    private int maxViewSizeHeight;
                    private long lastThrottleTimerRestart;
                    {
                        this.addChangeListener(new ChangeListener(){

                            @Override
                            public void stateChanged(ChangeEvent changeEvent) {
                                if (this.getView() != jTable) {
                                    this.removeChangeListener(this);
                                    return;
                                }
                                this.clearAddressToHighlight();
                                jTable.setToolTipText("");
                            }
                        });
                        this.addComponentListener(new ComponentAdapter(){

                            @Override
                            public void componentResized(ComponentEvent componentEvent) {
                                if (jTable.getPreferredSize().width <= this.getExtentSize().width) {
                                    jTable.setAutoResizeMode(3);
                                } else {
                                    jTable.setAutoResizeMode(0);
                                }
                            }
                        });
                        this.throttleSetViewSize.setRepeats(false);
                    }

                    @Override
                    public Color getBackground() {
                        return this.getView() != null ? this.getView().getBackground() : super.getBackground();
                    }

                    protected void doSetViewSize() {
                        super.setViewSize(this.preferredViewSize);
                        this.maxViewSizeHeight = this.preferredViewSize.height;
                    }

                    @Override
                    public void setViewSize(Dimension dimension) {
                        this.preferredViewSize.width = dimension.width;
                        this.preferredViewSize.height = dimension.height;
                        if (!this.throttleSetViewSize.isRunning()) {
                            long l = System.currentTimeMillis();
                            if (l - this.lastThrottleTimerRestart >= (long)(this.throttleSetViewSize.getDelay() * 2)) {
                                this.doSetViewSize();
                            }
                            this.lastThrottleTimerRestart = l;
                            this.throttleSetViewSize.restart();
                        }
                        dimension.height = this.maxViewSizeHeight = Math.max(this.maxViewSizeHeight, dimension.height);
                        super.setViewSize(dimension);
                    }
                };
            }
        };
        this.ruler = jLabel = this.createRuler(jTable);
        debuggerScrollPane.setRowHeaderView(jLabel);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)debuggerScrollPane, "Center");
        this.overviewRuler = this.createOverviewRuler(debuggerScrollPane.getVerticalScrollBar(), jTable, jLabel);
        jPanel.add((Component)this.overviewRuler, "East");
        this.expressionsTableModel = this.createExpressionsTableModel();
        this.southTabbedPane = this.createSouthTabbedPane(systemDebugger, this.expressionsTableModel);
        this.verticalSplitPane = new DebuggerSplitPane(0, true, jPanel, this.southTabbedPane);
        Object object3 = this.verticalSplitPane.getActionMap().getParent().keys();
        int n = ((Object[])object3).length;
        int n2 = 0;
        while (n2 < n) {
            object2 = object3[n2];
            object = this.verticalSplitPane.getActionMap().getParent().get(object2);
            if (object.equals(this.verticalSplitPane.getActionForKeyStroke(KeyStroke.getKeyStroke(117, 0))) || object.equals(this.verticalSplitPane.getActionForKeyStroke(KeyStroke.getKeyStroke(119, 0)))) {
                this.verticalSplitPane.getActionMap().getParent().remove(object2);
            }
            ++n2;
        }
        this.verticalSplitPane.setResizeWeight(1.0);
        this.outline = new OutlineTree(this){

            @Override
            public Color getBackground() {
                return this.shouldUseDarkMode() ? WINDOW_BACKGROUND_DARK_MODE : super.getBackground();
            }

            @Override
            public Color getForeground() {
                return jTable.getForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return jTable.getSelectionForeground();
            }

            @Override
            public Color getTreeBackground() {
                return jTable.getBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return jTable.getSelectionBackground();
            }

            @Override
            public Font getFont() {
                return jTable.getFont();
            }

            private boolean shouldUseDarkMode() {
                return jTable != null && super.getBackground() != null && jTable.getBackground().getRed() < super.getBackground().getRed();
            }
        };
        this.westTabbedPane.addTab("Outline", this.outline);
        this.variablesTree = new VariablesTree(systemDebugger.getSystemVariables()){

            @Override
            public Color getForeground() {
                return jTable.getForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return jTable.getSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return jTable.getBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return jTable.getSelectionBackground();
            }

            @Override
            public Font getFont() {
                return jTable.getFont();
            }

            @Override
            public Highlighter getHighlighter() {
                boolean bl = Debugger.this.highlighting && (Debugger.this.highlightWhileRunning || Debugger.isSuspended() || Debugger.this.systemDebugger.isStepping());
                return bl ? Debugger.this.highlighter : null;
            }
        };
        this.variablesTree.getModel().addTableModelListener(this.repaintTableModelListener);
        object2 = new DebuggerScrollPane(this.variablesTree);
        this.westTabbedPane.addTab("Variables", (Component)object2);
        this.westTabbedPane.setSelectedIndex(Math.min(this.westTabbedPane.getTabCount(), properties.getInt("DebuggerWestPanelSelectedTab", 0)));
        DebuggerSplitPane debuggerSplitPane = new DebuggerSplitPane(1, true, this.westTabbedPane, this.verticalSplitPane);
        this.horizontalSplitPaneWest = debuggerSplitPane;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        object3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)object3, "Center");
        this.cpuUsagePlot.setFocusable(false);
        this.cpuUsagePlot.setMinX(0.0);
        this.cpuUsagePlot.setMaxX(this.cpuUsage.capacity() - 1);
        this.cpuUsagePlot.setMinY(0.0);
        this.cpuUsagePlot.setMaxY(100.0);
        this.cpuUsagePlot.setBorder(BorderFactory.createTitledBorder("CPU Usage (% per Frame)"));
        this.cpuUsagePlot.setPanEnabled(false);
        this.cpuUsagePlot.setZoomEnabled(false);
        this.cpuUsagePlot.setFillMode(Boolean.parseBoolean(properties.getProperty("DebuggerCpuUsageFilled")));
        this.cpuUsagePlot.setColorModel(new PlotColorModel(){
            private Color color;
            private Color prevTableForeground;

            @Override
            public Color getColor(int n) {
                Color color = jTable.getForeground();
                if (jTable.getForeground() != this.prevTableForeground) {
                    this.color = new Color(color.getRed(), color.getGreen(), color.getBlue() ^ 0xFF);
                    this.prevTableForeground = jTable.getForeground();
                }
                return this.color;
            }

            @Override
            public Color getBackground() {
                return jTable.getBackground();
            }
        });
        ((Container)object3).add((Component)this.cpuUsagePlot, "North");
        if (Boolean.parseBoolean(properties.getProperty("DebuggerHideCpuUsageGraph"))) {
            this.cpuUsagePlot.setVisible(false);
        }
        this.stack = this.createStackList(jTable);
        object = new DebuggerScrollPane(this.stack);
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder("Stack"));
        this.callStackModel = new DebuggerCallStackModel();
        this.callStack = this.createCallStack(this.callStackModel);
        DebuggerScrollPane debuggerScrollPane2 = new DebuggerScrollPane(this.callStack);
        debuggerScrollPane2.setBorder(BorderFactory.createTitledBorder("Call Stack"));
        this.eastCenterSplitPane = new DebuggerSplitPane(0, true, (Component)object, debuggerScrollPane2);
        this.eastCenterSplitPane.setResizeWeight(0.5);
        ((Container)object3).add((Component)this.eastCenterSplitPane, "Center");
        if (properties.containsKey("StackSplitLocation")) {
            this.eastCenterSplitPane.setDividerLocation(properties.getInt("StackSplitLocation"));
        }
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel3, "North");
        jPanel3.add((Component)this.createRegistersTable(), "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.flagsPanel, "Center");
        this.interrupts = new JLabel(systemDebugger.isInterruptsEnabled() ? "EI" : "DI"){

            @Override
            public Font getFont() {
                return Debugger.this.registers.getFont();
            }

            @Override
            public Color getBackground() {
                return this.shouldUseDarkMode() ? WINDOW_BACKGROUND_DARK_MODE : super.getBackground();
            }

            @Override
            public Color getForeground() {
                return this.shouldUseDarkMode() ? WINDOW_FOREGROUND_DARK_MODE : super.getForeground();
            }

            private boolean shouldUseDarkMode() {
                return jTable != null && super.getBackground() != null && jTable.getBackground().getRed() < super.getBackground().getRed();
            }
        };
        this.interrupts.setOpaque(true);
        jPanel4.add((Component)this.interrupts, "South");
        jPanel3.add((Component)jPanel4, "East");
        DebuggerSplitPane debuggerSplitPane2 = new DebuggerSplitPane(this, 1, true, debuggerSplitPane, jPanel2){

            @Override
            public void doLayout() {
                int n = this.getMaximumDividerLocation();
                if (this.getDividerLocation() > n) {
                    this.setDividerLocation(n);
                }
                super.doLayout();
            }
        };
        this.horizontalSplitPaneEast = debuggerSplitPane2;
        debuggerSplitPane2.setResizeWeight(1.0);
        this.window.add((Component)debuggerSplitPane2, "Center");
        this.statusBar.add((Component)this.status, "West");
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.window.add((Component)this.statusBar, "South");
        MemoryEditor.addOutputListener(this.memoryEditorListener);
        try {
            this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
        }
        catch (NumberFormatException numberFormatException) {
            this.window.pack();
        }
        try {
            this.window.setLocation(properties.getInt("Window" + this.getClass().getSimpleName() + "X"), properties.getInt("Window" + this.getClass().getSimpleName() + "Y"));
        }
        catch (NumberFormatException numberFormatException) {
            this.window.setLocationRelativeTo(jFrame);
        }
        if (ScreenUtilities.getScreen(this.window) == null) {
            this.window.setLocationRelativeTo(jFrame);
        }
        JMenuBar jMenuBar = new JMenuBar(){
            private Border defaultBorder;

            @Override
            public Color getBackground() {
                return this.shouldUseDarkMode() ? WINDOW_BACKGROUND_DARK_MODE : super.getBackground();
            }

            @Override
            public Color getForeground() {
                return this.shouldUseDarkMode() ? WINDOW_FOREGROUND_DARK_MODE : super.getForeground();
            }

            private boolean shouldUseDarkMode() {
                return jTable != null && super.getBackground() != null && jTable.getBackground().getRed() < super.getBackground().getRed();
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                boolean bl;
                if (this.defaultBorder == null) {
                    this.defaultBorder = this.getBorder();
                }
                this.setBorder((bl = this.shouldUseDarkMode()) ? LINE_BORDER_DARK_MODE : this.defaultBorder);
                super.paintComponent(graphics);
                if (bl) {
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }
        };
        this.setJMenuBar(jMenuBar);
        jMenuBar.getInputMap(2).put(KeyStroke.getKeyStroke("F10"), "dummyAction");
        jMenuBar.add(this.makeMenuFile());
        jMenuBar.add(this.makeMenuNavigate());
        this.menuRun = this.makeMenuRun();
        jMenuBar.add(this.menuRun);
        jMenuBar.add(this.makeMenuView());
        jMenuBar.add(this.makeMenuExpressions());
        jMenuBar.add(this.makeMenuTools());
        jMenuBar.add(this.makeMenuHelp());
        this.toolBar = this.makeToolBar(jMenuBar);
        if (!Boolean.parseBoolean(properties.getProperty("DebuggerHideToolbar"))) {
            this.window.add((Component)this.toolBar, "First");
        }
        if (Boolean.parseBoolean(Emulicious.getProperties().getProperty("EnableAssembler"))) {
            jTable.addKeyListener(this.assemblerKeyListener);
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
        this.highlighting = Boolean.parseBoolean(properties.getProperty("Highlighting"));
        this.highlightWhileRunning = Boolean.parseBoolean(properties.getProperty("HighlightWhileRunning"));
        this.doUpdateDebugger(systemDebugger, nArray);
        debuggerSplitPane.setDividerLocation(properties.getInt("OutlineWidth", jPanel2.getPreferredSize().width));
        debuggerSplitPane2.setDividerLocation(properties.getInt("StackWidth", debuggerSplitPane2.getWidth() - jPanel2.getPreferredSize().width));
        this.verticalSplitPane.setDividerLocation(properties.getInt("SouthPanelHeight", this.verticalSplitPane.getHeight() - 287));
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private void setJMenuBar(JMenuBar jMenuBar) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setJMenuBar(jMenuBar);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setJMenuBar(jMenuBar);
        }
    }

    private JMenuBar getJMenuBar() {
        return this.window instanceof JFrame ? ((JFrame)this.window).getJMenuBar() : ((JDialog)this.window).getJMenuBar();
    }

    private static JRootPane getRootPane() {
        Window window;
        Window window2 = window = debugger != null ? Debugger.debugger.window : null;
        if (window instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)window)).getRootPane();
        }
        return null;
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    void showMessageDialog(Object object, String string, int n) {
        JOptionPane.showMessageDialog(this.window, object, string, n);
    }

    public Color getTableForeground() {
        return this.table.getForeground();
    }

    public Color getTableSelectionForeground() {
        return this.table.getSelectionForeground();
    }

    public Color getTableBackground() {
        return this.table.getBackground();
    }

    public Color getTableSelectionBackground() {
        return this.table.getSelectionBackground();
    }

    public Color getCurrentLineForeground() {
        return this.currentLineForeground;
    }

    public Color getCurrentLineBackground() {
        return this.currentLineBackground;
    }

    private void updateCurrentLineBackground() {
        this.currentLineForeground = this.highlighter != null ? this.highlighter.getCurrentLineForeground() : (this.table != null ? this.table.getForeground() : Color.BLACK);
        this.currentLineBackground = this.highlighter != null ? this.highlighter.getCurrentLineBackground() : Color.CYAN;
        this.darkerCurrentLineBackground = this.currentLineBackground.darker();
        this.brighterCurrentLineBackground = this.currentLineBackground.brighter();
        Arrays.fill(COLORS_TRACE, null);
    }

    public Font getFont() {
        return this.table.getFont();
    }

    public void doUpdateDebugger(final SystemDebugger systemDebugger, int[] nArray) {
        boolean bl;
        File file = Emulicious.getROMfile();
        boolean bl2 = !file.equals(this.romFile);
        this.romFile = file;
        boolean bl3 = this.systemDebugger != null && this.systemDebugger.isSkipBreakpoints();
        boolean bl4 = this.systemDebugger != null && this.systemDebugger.isSkipExceptions();
        boolean bl5 = bl = this.systemDebugger != null && this.systemDebugger.isRecordCoverage();
        if (this.systemDebugger != null) {
            this.systemDebugger.setSkipBreakpoints(false);
            this.systemDebugger.setSkipExceptions(false);
            this.systemDebugger.setRecordCoverage(false);
            this.properties.setProperty("InterruptBreakpointEnabled", "" + this.systemDebugger.isInterruptBreakpointEnabled());
            this.properties.setProperty("InterruptBreakpointSuspend", "" + this.systemDebugger.isInterruptBreakpointSuspend());
            this.properties.setProperty("InterruptBreakpointCondition", this.systemDebugger.getInterruptBreakpointCondition());
            this.properties.setProperty("UninitializedMemoryBreakpointEnabled", "" + this.systemDebugger.isUninitializedMemoryBreakpointEnabled());
            this.properties.setProperty("UninitializedMemoryBreakpointSuspend", "" + this.systemDebugger.isUninitializedMemoryBreakpointSuspend());
            this.properties.setProperty("UninitializedMemoryBreakpointCondition", this.systemDebugger.getUninitializedMemoryBreakpointCondition());
            this.properties.setProperty("DataExecutionBreakpointEnabled", "" + this.systemDebugger.isDataExecutionBreakpointEnabled());
            this.properties.setProperty("DataExecutionBreakpointSuspend", "" + this.systemDebugger.isDataExecutionBreakpointSuspend());
            this.properties.setProperty("DataExecutionBreakpointCondition", this.systemDebugger.getDataExecutionBreakpointCondition());
            this.properties.setProperty("StackRomWriteBreakpointEnabled", "" + this.systemDebugger.isStackRomWriteBreakpointEnabled());
            this.properties.setProperty("StackRomWriteBreakpointSuspend", "" + this.systemDebugger.isStackRomWriteBreakpointSuspend());
            this.properties.setProperty("StackRomWriteBreakpointCondition", this.systemDebugger.getStackRomWriteBreakpointCondition());
            this.properties.setProperty("BankSwapAtPCBreakpointEnabled", "" + this.systemDebugger.isBankSwapAtPCBreakpointEnabled());
            this.properties.setProperty("BankSwapAtPCBreakpointSuspend", "" + this.systemDebugger.isBankSwapAtPCBreakpointSuspend());
            this.properties.setProperty("BankSwapAtPCBreakpointCondition", this.systemDebugger.getBankSwapAtPCBreakpointCondition());
            this.systemDebugger.saveBreakpoints(this.bpsFile);
            this.systemDebugger.saveCoverage(this.cvgFile);
            ProfilerWindow.saveProfilers(this.prfFile);
            this.saveExpressions(this.expFile);
            this.overlays.save(this.ovrFile);
            this.systemDebugger.removeSystemListener(this);
            this.systemDebugger.removeBreakpointListener(this);
            this.systemDebugger.removeMessageReceiver(this);
            BreakpointWindow.unregisterBreakpointListener(this.systemDebugger);
            this.cleanUp();
            System.gc();
            this.tableRAMrows = new HashIntBiMap();
            this.tableSRAMrows = new HashIntBiMap();
            this.tablePortRows = new HashIntBiMap();
            this.backwardStack = new LinkedList();
            this.forwardStack = new LinkedList();
            this.labels = new HashMap();
            this.properties.setProperty("DebuggerMemorySelectedTab", this.memoryEditor.getNameOfSelectedTab());
            this.properties.setProperty("DebuggerMemoryTabVisibleRect", this.memoryEditor.getTabVisibleRect());
            this.properties.setProperty("DebuggerMemorySelectedAddress", "" + this.memoryEditor.getFirstSelectedAddress());
            this.memoryEditor.updateModel();
            this.memoryEditor.selectTabByName(this.properties.getProperty("DebuggerMemorySelectedTab"), this.properties.getProperty("DebuggerMemoryTabVisibleRect"), this.properties.getInt("DebuggerMemorySelectedAddress", -1));
            this.variablesTree.setVariables(systemDebugger.getSystemVariables());
            this.saveEventFilters();
            this.eventViewer.setModel(systemDebugger.createEventModel());
            this.loadEventFilters();
        }
        this.memory = nArray;
        this.updateMSXmemory(systemDebugger.getDecoratedSystem());
        this.sourceFile = null;
        this.tableRows = new int[systemDebugger.getROMsize()];
        this.tableCpuRows = new int[systemDebugger.getMemoryLength()];
        this.oldCpuRows = new int[this.tableCpuRows.length];
        this.stackLabels = new String[systemDebugger.getStackLength()];
        systemDebugger.setSkipBreakpoints(bl3);
        systemDebugger.setSkipExceptions(bl4);
        systemDebugger.setRecordCoverage(bl);
        systemDebugger.setInterruptBreakpointEnabled(Boolean.parseBoolean(this.properties.getProperty("InterruptBreakpointEnabled")));
        systemDebugger.setInterruptBreakpointSuspend(Boolean.parseBoolean(this.properties.getProperty("InterruptBreakpointSuspend", "true")));
        systemDebugger.setInterruptBreakpointCondition(this.properties.getProperty("InterruptBreakpointCondition"));
        systemDebugger.setUninitializedMemoryBreakpointEnabled(Boolean.parseBoolean(this.properties.getProperty("UninitializedMemoryBreakpointEnabled")));
        systemDebugger.setUninitializedMemoryBreakpointSuspend(Boolean.parseBoolean(this.properties.getProperty("UninitializedMemoryBreakpointSuspend", "true")));
        systemDebugger.setUninitializedMemoryBreakpointCondition(this.properties.getProperty("UninitializedMemoryBreakpointCondition"));
        systemDebugger.setDataExecutionBreakpointEnabled(Boolean.parseBoolean(this.properties.getProperty("DataExecutionBreakpointEnabled")));
        systemDebugger.setDataExecutionBreakpointSuspend(Boolean.parseBoolean(this.properties.getProperty("DataExecutionBreakpointSuspend", "true")));
        systemDebugger.setDataExecutionBreakpointCondition(this.properties.getProperty("DataExecutionBreakpointCondition"));
        systemDebugger.setStackRomWriteBreakpointEnabled(Boolean.parseBoolean(this.properties.getProperty("StackRomWriteBreakpointEnabled")));
        systemDebugger.setStackRomWriteBreakpointSuspend(Boolean.parseBoolean(this.properties.getProperty("StackRomWriteBreakpointSuspend", "true")));
        systemDebugger.setStackRomWriteBreakpointCondition(this.properties.getProperty("StackRomWriteBreakpointCondition"));
        systemDebugger.setBankSwapAtPCBreakpointEnabled(Boolean.parseBoolean(this.properties.getProperty("BankSwapAtPCBreakpointEnabled")));
        systemDebugger.setBankSwapAtPCBreakpointSuspend(Boolean.parseBoolean(this.properties.getProperty("BankSwapAtPCBreakpointSuspend", "true")));
        systemDebugger.setBankSwapAtPCBreakpointCondition(this.properties.getProperty("BankSwapAtPCBreakpointCondition"));
        systemDebugger.setLabelProvider(Debugger.getLabelProvider());
        systemDebugger.setLabelProviderRAM(Debugger.getLabelProviderRAM());
        systemDebugger.setLabelProviderSRAM(Debugger.getLabelProviderSRAM());
        systemDebugger.setLabelProviderPorts(this.getLabelProviderPorts());
        systemDebugger.setAdditionalVariables(new VariableProvider(){

            @Override
            public long getValue(String string, boolean bl) throws UnknownVariableException {
                List list;
                boolean bl2;
                boolean bl3 = bl2 = !string.isEmpty() && string.charAt(0) == ':';
                if (bl2) {
                    string = string.substring(1);
                }
                if ((list = (List)Debugger.this.symbols.get(string)) == null) {
                    Integer n = (Integer)Debugger.this.portAddresses.get(string);
                    if (n != null) {
                        return systemDebugger.getPortExtension() | n;
                    }
                    int n2 = Debugger.this.getLabelAddress(string);
                    if (n2 >= 0) {
                        return bl2 ? n2 / systemDebugger.getMemoryLength() : n2;
                    }
                    throw new UnknownVariableException(string);
                }
                Symbols.Symbol symbol = (Symbols.Symbol)list.get(0);
                if (bl2) {
                    return symbol.getBank();
                }
                return this.mapBank(symbol.getAddress(), symbol.getBank());
            }

            @Override
            public int readValue(int n, boolean bl, boolean bl2) {
                int n2 = n / systemDebugger.getMemoryLength();
                int n3 = bl2 || n2 > 0 ? systemDebugger.getByte(n & systemDebugger.getMemoryLength() - 1, n2 > 0 ? n2 : -1) : systemDebugger.peekByte(n);
                return bl ? (int)n3 : n3;
            }

            @Override
            public int readLocation(String string, int n, boolean bl) throws UnknownVariableException {
                if ("^".equals(string)) {
                    return this.readValue(n, bl, true);
                }
                if (string.isEmpty()) {
                    return this.readValue(n, bl, false);
                }
                if ("rom".equalsIgnoreCase(string)) {
                    return systemDebugger.getByte(0x4000 | n & 0x3FFF, n / 16384);
                }
                if ("ram".equalsIgnoreCase(string)) {
                    return systemDebugger.getRAMvalue(n & systemDebugger.getRAMlength() - 1);
                }
                if ("vram".equalsIgnoreCase(string)) {
                    return systemDebugger.getVRAM()[n];
                }
                if ("sram".equalsIgnoreCase(string)) {
                    return systemDebugger.getSRAM()[n];
                }
                if (string.toLowerCase().startsWith("word")) {
                    if ((string = string.substring("word".length())).length() > 1 && string.charAt(0) == '.') {
                        string = string.substring(1);
                    }
                    int n2 = this.readLocation(string, n + 1, false) << 8 | this.readLocation(string, n, false);
                    return bl ? (int)n2 : n2;
                }
                if (string.toLowerCase().startsWith("dword")) {
                    if ((string = string.substring("dword".length())).length() > 1 && string.charAt(0) == '.') {
                        string = string.substring(1);
                    }
                    return this.readLocation(string, n + 3, false) << 24 | this.readLocation(string, n + 2, false) << 16 | this.readLocation(string, n + 1, false) << 8 | this.readLocation(string, n, false);
                }
                if (string.toLowerCase().startsWith("beword")) {
                    if ((string = string.substring("beword".length())).length() > 1 && string.charAt(0) == '.') {
                        string = string.substring(1);
                    }
                    int n3 = this.readLocation(string, n, false) << 8 | this.readLocation(string, n + 1, false);
                    return bl ? (int)n3 : n3;
                }
                if (string.toLowerCase().startsWith("bedword")) {
                    if ((string = string.substring("bedword".length())).length() > 1 && string.charAt(0) == '.') {
                        string = string.substring(1);
                    }
                    return this.readLocation(string, n, false) << 24 | this.readLocation(string, n + 1, false) << 16 | this.readLocation(string, n + 2, false) << 8 | this.readLocation(string, n + 3, false);
                }
                throw new UnknownVariableException(string);
            }

            @Override
            public int getBankAt(int n) {
                return systemDebugger.getBank(n);
            }

            @Override
            public long mapBank(int n, int n2) {
                return n2 * systemDebugger.getMemoryLength() | n;
            }

            @Override
            public boolean isConstant(String string) throws UnknownVariableException {
                if (!string.isEmpty() && string.charAt(0) == ':') {
                    string = string.substring(1);
                }
                if (!Debugger.this.symbols.containsKey(string) && !Debugger.this.portAddresses.containsKey(string)) {
                    throw new UnknownVariableException(string);
                }
                return true;
            }

            @Override
            public boolean isConstantRead(int n) {
                return true;
            }
        });
        this.updateProjectFilenames();
        this.loadSymbols(systemDebugger, Debugger.findSymbolsFile());
        File file2 = new File(String.valueOf(systemDebugger.getDecoratedSystem().getClass().getSimpleName()) + ".ports");
        if (!file2.exists()) {
            file2 = new File(Emulicious.getHomeDirectory(), String.valueOf(systemDebugger.getDecoratedSystem().getClass().getSimpleName()) + ".ports");
        }
        this.portNames = Debugger.loadPortNames(file2);
        for (Map.Entry<String> entry : this.portNames.entrySet()) {
            this.portAddresses.put(entry.getValue(), Math.abs(entry.getKey()));
        }
        this.table.setDefaultRenderer(Object.class, new DisassemblerCellRenderer());
        this.stack.setModel(new StackListModel(systemDebugger));
        this.updateRegistersTable(systemDebugger);
        this.updateFlagsPanel(systemDebugger);
        systemDebugger.addBreakpointListener(this);
        BreakpointWindow.registerBreakpointListener(systemDebugger);
        systemDebugger.addSystemListener(this);
        systemDebugger.addMessageReceiver(this);
        this.systemDebugger = systemDebugger;
        if (forceSuspendOnOpen || Boolean.parseBoolean(this.properties.getProperty("DebuggerSuspendOnOpen"))) {
            this.suspend();
            this.suspended();
            this.wasSuspended = true;
        }
        systemDebugger.loadBreakpoints(this.bpsFile);
        if (!this.loadExpressions(this.expFile) && Boolean.parseBoolean(this.properties.getProperty("AutoImportSymbolExpressions"))) {
            this.importSymbolExpressions();
        }
        this.overlays.load(this.ovrFile);
        systemDebugger.loadCoverage(this.cvgFile);
        ProfilerWindow.loadProfilers(this.prfFile);
        if (Boolean.parseBoolean(this.properties.getProperty("LoadDebugfilesAutomatically"))) {
            this.loadDebugFile(!bl2 && this.debugfileFile != null && this.debugfileFile.exists() ? this.debugfileFile : Debugger.findDebugFile());
        }
        if (systemDebugger.getDecoratedSystem() instanceof GameBoy) {
            LR35902Disassembler.createInstance();
        } else {
            Z80Disassembler.createInstance(this.isMSX());
        }
        BreakpointWindow.updateModel(this);
        RAMSearchWindow.updateModel(systemDebugger);
        CoverageWindow.update();
        TracerWindow.updateModel(systemDebugger);
        DAPDebugger.setDebugger(this, systemDebugger);
        if (Boolean.parseBoolean(this.properties.getProperty("LoadSourcesAutomatically"))) {
            this.sourceFile = Debugger.findSourceFile();
        }
        this.updateDisassembly();
        this.updateHighlighter();
        this.updateStatusBar();
        this.doUpdateKeys();
        this.reset();
    }

    private boolean isMSX() {
        return this.systemDebugger.getDecoratedSystem() instanceof MSX;
    }

    private void updateMSXmemory(DebuggableSystem debuggableSystem) {
        if (!(debuggableSystem instanceof MSX)) {
            return;
        }
        MSX mSX = (MSX)debuggableSystem;
        int[] nArray = mSX.getDiskMemory();
        if (nArray != null) {
            this.memory = nArray;
        }
    }

    public static void updateDebugger(SystemDebugger systemDebugger, int[] nArray) {
        if (debugger != null) {
            if (dapDebugging && !DAPDebugger.isLaunching()) {
                Debugger.close();
            } else {
                debugger.doUpdateDebugger(systemDebugger, nArray);
            }
        }
    }

    void setMemoryBytes(int n, int[] nArray) {
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            this.memory[n] = n4 & 0xFF;
            this.memoryChanged(n++);
            ++n3;
        }
        this.memoryEditor.romChanged();
    }

    private void updateStatusBar() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = this.table.getSelectedRows();
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray[n5];
            Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n6, 1);
            Z80Instruction z80Instruction = sourceLine.getInstruction();
            if (z80Instruction != null) {
                n += Z80Disassembler.getMinCycles(z80Instruction);
                n2 += Z80Disassembler.getMaxCycles(z80Instruction);
            }
            n3 += sourceLine.getSize();
            ++n5;
        }
        this.status.setText(String.valueOf(n3) + " bytes selected. Cycles: " + n + " / " + n2);
    }

    private void updateProjectFilenames() {
        File file = Emulicious.getProjectsDirectory();
        file.mkdirs();
        this.expFile = new File(file, String.valueOf(Debugger.getRomFileNameWithoutExtension()) + ".exp");
        this.ovrFile = new File(file, String.valueOf(Debugger.getRomFileNameWithoutExtension()) + ".ovr");
        this.bpsFile = new File(file, String.valueOf(Debugger.getRomFileNameWithoutExtension()) + ".bps");
        this.cvgFile = new File(file, String.valueOf(Debugger.getRomFileNameWithoutExtension()) + ".cvg");
        this.prfFile = new File(file, String.valueOf(Debugger.getRomFileNameWithoutExtension()) + ".prf");
    }

    private void loadSymbols(SystemDebugger systemDebugger, File file) {
        this.loadSymbols(systemDebugger, file, Boolean.parseBoolean(this.properties.getProperty("ReloadSymbolFileOnChange")));
    }

    private void loadSymbols(SystemDebugger systemDebugger, File file, boolean bl) {
        systemDebugger.loadSymbols(file);
        if (Symbols.isRGBDSMapSymbols(file)) {
            try {
                this.sectionProvider = new RGBDSSectionProvider(RGBDSMapFile.parse(file));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.symbols = Symbols.getSymbolsByName(systemDebugger.getSymbols());
        this.ramSymbols = Symbols.getRAMsymbols(systemDebugger.getSymbols());
        this.romSymbolKeys = null;
        this.ramSymbolKeys = null;
        if (!bl || this.symbolFileChangeWatcher != null && file != this.symbolFileChangeWatcher.getFile()) {
            this.removeSymbolFileChangeWatcher();
        }
        this.symbolFile = file;
        if (bl) {
            this.createSymbolFileChangeWatcher();
        }
    }

    private void loadDebugFile(File file) {
        this.loadDebugFile(file, Boolean.parseBoolean(this.properties.getProperty("ReloadDebugfileOnChange")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDebugFile(File file, boolean bl) {
        List<FileChangeWatcher> list = this.debugfileFileChangeWatchers;
        synchronized (list) {
            if (file != null && file.exists()) {
                try {
                    this.systemDebugger.loadDebugFile(file, Emulicious.parseEmuliciousVersion(), new WarningHandler(){

                        @Override
                        public void handleWarning(String string) {
                            Debugger.this.appendToConsole("DebugFile Warning: " + string + "\n");
                        }
                    });
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.window, "Failed to load Debugfile due to the following error:\n" + iOException.getMessage(), "Failed to load Debugfile", 0);
                }
                catch (RuntimeException runtimeException) {
                    JOptionPane.showMessageDialog(this.window, "Failed to load Debugfile due to the following error:\n" + runtimeException.getMessage(), "Failed to load Debugfile", 0);
                }
            }
            if (!bl || !this.debugfileFileChangeWatchers.isEmpty() && this.debugfileFile != this.debugfileFileChangeWatchers.get(0).getFile()) {
                this.removeDebugfileFileChangeWatchers();
            }
            this.debugfileFile = file;
            if (bl) {
                this.createDebugfileFileChangeWatchers();
            }
            this.variablesTree.setVariables(this.systemDebugger.getSystemVariables());
        }
    }

    util.map.Map<List<Symbols.Symbol>> getLoadedSymbols() {
        return this.systemDebugger.getSymbols();
    }

    util.map.Map<List<Symbols.Symbol>> getLoadedRamSymbols() {
        return this.systemDebugger.getRamSymbols();
    }

    private void createSymbolFileChangeWatcher() {
        if (this.symbolFileChangeWatcher == null) {
            this.symbolFileChangeWatcher = new FileChangeWatcher(this.symbolFile);
            this.symbolFileChangeWatcher.startWatching(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.this.reloadSymbols();
                }
            });
        }
    }

    private void removeSymbolFileChangeWatcher() {
        if (this.symbolFileChangeWatcher != null) {
            this.symbolFileChangeWatcher.stopWatching();
            this.symbolFileChangeWatcher = null;
        }
    }

    private void createDebugfileFileChangeWatchers() {
        if (!this.debugfileFileChangeWatchers.isEmpty()) {
            this.removeDebugfileFileChangeWatchers();
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.reloadDebugfile();
            }
        };
        FileChangeWatcher fileChangeWatcher = new FileChangeWatcher(this.debugfileFile);
        fileChangeWatcher.startWatching(1000, actionListener);
        this.debugfileFileChangeWatchers.add(fileChangeWatcher);
        for (File file : this.systemDebugger.getDebugfileIncludedFiles()) {
            FileChangeWatcher fileChangeWatcher2 = new FileChangeWatcher(file);
            fileChangeWatcher2.startWatching(1000, actionListener);
            this.debugfileFileChangeWatchers.add(fileChangeWatcher2);
        }
    }

    private void removeDebugfileFileChangeWatchers() {
        for (FileChangeWatcher fileChangeWatcher : this.debugfileFileChangeWatchers) {
            fileChangeWatcher.stopWatching();
        }
        this.debugfileFileChangeWatchers.clear();
    }

    public static util.map.Map<String> loadPortNames(File file) {
        HashMap<String> hashMap = new HashMap<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String string = bufferedReader.readLine();
            while (string != null) {
                try {
                    String[] stringArray = string.split(" ");
                    if (stringArray.length >= 2) {
                        int n = Integer.parseInt(stringArray[0], 16);
                        if (stringArray.length > 2 && "in".equals(stringArray[2])) {
                            hashMap.put(-n, stringArray[1]);
                        } else if (stringArray.length > 2 && "out".equals(stringArray[2])) {
                            hashMap.put(n, stringArray[1]);
                        } else {
                            hashMap.put(n, stringArray[1]);
                            hashMap.put(-n, stringArray[1]);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    private static String getRomFileNameWithoutExtension() {
        File file = Emulicious.getROMfile();
        int n = file.getName().lastIndexOf(46);
        if (n > 0) {
            return file.getName().substring(0, n);
        }
        return file.getName();
    }

    static File findSourceFile() {
        File file;
        File file2 = Debugger.findSourceFile(false);
        if (!file2.exists() && (file = Debugger.searchSourceFile()) != null) {
            return file;
        }
        return file2;
    }

    static File findSourceFile(boolean bl) {
        File file;
        File file2 = Debugger.findSourceFile(null, bl, true);
        if (file2.exists()) {
            return file2;
        }
        String string = Emulicious.getProperties().getProperty("SrcDir");
        if (string != null && new File(string).isDirectory() && (file = Debugger.findSourceFile(new File(string), true, false)).exists()) {
            return file;
        }
        return file2;
    }

    private static File searchSourceFile() {
        File file = Emulicious.getROMfile();
        Object object = file.getParentFile();
        while (object != null) {
            File file2 = Debugger.searchAnySourceFile(new File((File)object, "src"));
            if (file2 != null) {
                return file2;
            }
            file2 = Debugger.searchAnySourceFile(new File((File)object, "srcs"));
            if (file2 != null) {
                return file2;
            }
            file2 = Debugger.searchAnySourceFile(new File((File)object, "source"));
            if (file2 != null) {
                return file2;
            }
            file2 = Debugger.searchAnySourceFile(new File((File)object, "code"));
            if (file2 != null) {
                return file2;
            }
            object = ((File)object).getParentFile();
        }
        object = Emulicious.getProperties().getProperty("SrcDir");
        if (object != null) {
            return Debugger.searchAnySourceFile(new File((String)object));
        }
        return null;
    }

    private static File searchAnySourceFile(File file) {
        if (file == null || !file.isDirectory()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            String string = file2.getName().toLowerCase();
            if (string.endsWith(".asm") || string.endsWith(".s")) {
                return file2;
            }
            ++n2;
        }
        return null;
    }

    private static File findSourceFile(File file, boolean bl, boolean bl2) {
        File file2;
        boolean bl3;
        File file3;
        String string;
        File file4;
        File file5 = Emulicious.getROMfile();
        if (file == null) {
            file = file5.getParentFile();
        }
        if ((file4 = new File(file, String.valueOf(string = Debugger.getRomFileNameWithoutExtension()) + ".map")).exists() && !Symbols.isRGBDSMapSymbols(file4)) {
            return file4;
        }
        file4 = new File(file, String.valueOf(file5.getName()) + ".map");
        if (file4.exists() && !Symbols.isRGBDSMapSymbols(file4)) {
            return file4;
        }
        if (!bl && (file4 = new File(file, "main.map")).exists() && !Symbols.isRGBDSMapSymbols(file4)) {
            return file4;
        }
        file4 = new File(file, String.valueOf(string) + ".lst");
        if (file4.exists()) {
            return file4;
        }
        file4 = new File(file, String.valueOf(file5.getName()) + ".asm");
        if (file4.exists()) {
            return file4;
        }
        file4 = new File(file, String.valueOf(string) + ".asm");
        if (file4.exists()) {
            return file4;
        }
        if (new File(file, String.valueOf(string) + ".s").exists()) {
            return new File(file, String.valueOf(string) + ".s");
        }
        if (!bl) {
            if (new File(file, "main.asm").exists()) {
                file4 = new File(file, "main.asm");
            } else if (new File(file, "main.s").exists()) {
                file4 = new File(file, "main.s");
            } else if (new File(file, "header.asm").exists()) {
                file4 = new File(file, "header.asm");
            }
        }
        if (file4.exists()) {
            return file4;
        }
        if (new File(file, "src").isDirectory() && (file3 = Debugger.findSourceFile(new File(file, "src"), false, false)).exists()) {
            return file3;
        }
        if (new File(file, "srcs").isDirectory() && (file3 = Debugger.findSourceFile(new File(file, "srcs"), false, false)).exists()) {
            return file3;
        }
        if (new File(file, "source").isDirectory() && (file3 = Debugger.findSourceFile(new File(file, "source"), false, false)).exists()) {
            return file3;
        }
        if (new File(file, "code").isDirectory() && (file3 = Debugger.findSourceFile(new File(file, "code"), false, false)).exists()) {
            return file3;
        }
        if (bl2 && file != null && file.equals(file5.getParentFile()) && (file3 = Debugger.findSourceFile(file.getParentFile(), true, false)).exists()) {
            return file3;
        }
        boolean bl4 = bl3 = new File(file, ".vscode").isDirectory() && !new File(new File(file, ".vscode"), "extensions").isDirectory();
        if (bl3 && (file2 = Debugger.searchSourceFile(file)) != null) {
            return file2;
        }
        return file4;
    }

    private static File searchSourceFile(File file) {
        if (file == null || !file.isDirectory()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (file2.isDirectory()) {
                File file3 = Debugger.findSourceFile(file2, false, false);
                if (file3.exists()) {
                    return file3;
                }
                file3 = Debugger.searchSourceFile(file2);
                if (file3 != null) {
                    return file3;
                }
            }
            ++n2;
        }
        return null;
    }

    private static File findDebugFile() {
        File file = Emulicious.getROMfile();
        File file2 = file.getParentFile();
        File file3 = new File(file2, String.valueOf(file.getName()) + ".dbg");
        if (file3.exists()) {
            return file3;
        }
        file3 = new File(file2, String.valueOf(Debugger.getRomFileNameWithoutExtension()) + ".dbg");
        return file3;
    }

    private static File findSymbolsFile() {
        File file;
        File file2 = Debugger.findSymbolsFile(null);
        if (file2.exists()) {
            return file2;
        }
        String string = Emulicious.getProperties().getProperty("SymDir");
        if (string != null && new File(string).isDirectory() && (file = Debugger.findSymbolsFile(new File(string))).exists()) {
            return file;
        }
        return file2;
    }

    private static File findSymbolsFile(File file) {
        String string;
        File file2;
        File file3 = Emulicious.getROMfile();
        if (file == null) {
            file = file3.getParentFile();
        }
        if ((file2 = new File(file, String.valueOf(string = Debugger.getRomFileNameWithoutExtension()) + ".map")).exists()) {
            return file2;
        }
        file2 = new File(file, String.valueOf(file3.getName()) + ".map");
        if (file2.exists()) {
            return file2;
        }
        file2 = new File(file, "main.map");
        if (file2.exists()) {
            return file2;
        }
        file2 = new File(file, String.valueOf(string) + ".cdb");
        if (file2.exists()) {
            return file2;
        }
        file2 = new File(file, String.valueOf(file3.getName()) + ".sym");
        if (file2.exists()) {
            return file2;
        }
        file2 = new File(file, String.valueOf(string) + ".sym");
        if (file2.exists()) {
            return file2;
        }
        file2 = new File(file, "tniasm.sym");
        if (file2.exists()) {
            return file2;
        }
        file2 = new File(file, String.valueOf(file3.getName()) + ".lst");
        if (file2.exists()) {
            return file2;
        }
        file2 = new File(file, String.valueOf(string) + ".lst");
        if (file2.exists()) {
            return file2;
        }
        file2 = new File(file, String.valueOf(string) + ".sym");
        if (file2.exists()) {
            return file2;
        }
        if (new File(file, "src").exists() && new File(file, "src").isDirectory()) {
            return Debugger.findSymbolsFile(new File(file, "src"));
        }
        if (new File(file, "srcs").exists() && new File(file, "srcs").isDirectory()) {
            return Debugger.findSymbolsFile(new File(file, "srcs"));
        }
        if (new File(file, "source").exists() && new File(file, "source").isDirectory()) {
            return Debugger.findSymbolsFile(new File(file, "source"));
        }
        if (file.getParentFile() != null) {
            if (new File(file.getParentFile(), String.valueOf(string) + ".cdb").exists()) {
                return new File(file.getParentFile(), String.valueOf(string) + ".cdb");
            }
            if (new File(file.getParentFile(), String.valueOf(string) + ".map").exists()) {
                return new File(file.getParentFile(), String.valueOf(string) + ".map");
            }
        }
        if (new File(file, "build").exists() && new File(file, "build").isDirectory() && (file2 = new File(new File(file, "build"), String.valueOf(string) + ".cdb")).exists()) {
            return file2;
        }
        return file2;
    }

    static File getConfigFile() {
        File file = Emulicious.getROMfile();
        File file2 = file.getParentFile();
        String string = Debugger.getRomFileNameWithoutExtension();
        File file3 = new File(file2, String.valueOf(file.getName()) + ".cfg");
        if (file3.exists()) {
            return file3;
        }
        return new File(file2, String.valueOf(string) + ".cfg");
    }

    private JMenu makeMenuFile() {
        MenuItem menuItem;
        final Properties properties = this.properties;
        DebuggerMenu debuggerMenu = new DebuggerMenu("File");
        debuggerMenu.setMnemonic('f');
        debuggerMenu.add(this.menuItemSaveAs);
        this.menuItemSaveAs.setAction(new AbstractAction(this.menuItemSaveAs.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.showSaveDisassemblyFileChooser(Debugger.this.window);
            }
        });
        debuggerMenu.addSeparator();
        debuggerMenu.add(this.menuItemLoadSymbols);
        this.menuItemLoadSymbols.setAction(new AbstractAction(this.menuItemLoadSymbols.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.showSymbolFileChooser(Debugger.this.window);
            }
        });
        debuggerMenu.add(this.menuItemReloadSymbols);
        this.menuItemReloadSymbols.setAction(new AbstractAction(this.menuItemReloadSymbols.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.reloadSymbols();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Reload Symbols On File Change", Boolean.parseBoolean(properties.getProperty("ReloadSymbolFileOnChange")));
        jCheckBoxMenuItem.setMnemonic('c');
        debuggerMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.setAction(new AbstractAction(jCheckBoxMenuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                properties.setProperty("ReloadSymbolFileOnChange", Boolean.toString(jCheckBoxMenuItem.isSelected()));
                if (jCheckBoxMenuItem.isSelected()) {
                    Debugger.this.createSymbolFileChangeWatcher();
                } else {
                    Debugger.this.removeSymbolFileChangeWatcher();
                }
            }
        });
        debuggerMenu.addSeparator();
        MenuItem menuItem2 = new MenuItem("Load Debugfile...", 100);
        debuggerMenu.add(menuItem2);
        menuItem2.setAction(new AbstractAction(menuItem2.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.showDebugfileFileChooser(Debugger.this.window);
            }
        });
        final MenuItem menuItem3 = new MenuItem("Reload Debugfile");
        debuggerMenu.add(menuItem3);
        menuItem3.setAction(new AbstractAction(menuItem3.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.reloadDebugfile();
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Reload Debugfile On Change", Boolean.parseBoolean(properties.getProperty("ReloadDebugfileOnChange")));
        debuggerMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2.setAction(new AbstractAction(jCheckBoxMenuItem2.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                properties.setProperty("ReloadDebugfileOnChange", Boolean.toString(jCheckBoxMenuItem.isSelected()));
                if (jCheckBoxMenuItem.isSelected()) {
                    Debugger.this.createDebugfileFileChangeWatchers();
                } else {
                    Debugger.this.removeDebugfileFileChangeWatchers();
                }
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Load Debugfiles Automatically", Boolean.parseBoolean(properties.getProperty("LoadDebugfilesAutomatically")));
        jCheckBoxMenuItem3.setMnemonic('a');
        debuggerMenu.add(jCheckBoxMenuItem3);
        jCheckBoxMenuItem3.setAction(new AbstractAction(jCheckBoxMenuItem3.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                properties.setProperty("LoadDebugfilesAutomatically", Boolean.toString(jCheckBoxMenuItem3.isSelected()));
            }
        });
        final Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.BROWSE)) {
            menuItem = new MenuItem("Open Debugfile Specification...");
            debuggerMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        desktop.browse(new URL("https://github.com/aaaaaa123456789/gb-debugfiles/blob/master/debugfile.md").toURI());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        debuggerMenu.addSeparator();
        menuItem = new MenuItem("Load Sources...", 99);
        debuggerMenu.add(menuItem);
        menuItem.setAction(new AbstractAction(menuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Debugger.this.loadingSources) {
                    Debugger.this.cancelLoadingSources = true;
                } else {
                    Debugger.this.showSourceFileChooser(Debugger.this.window);
                }
            }
        });
        final MenuItem menuItem4 = new MenuItem("Unload Sources", 117);
        debuggerMenu.add(menuItem4);
        menuItem4.setAction(new AbstractAction(menuItem4.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Debugger.this.sourceFile != null && Debugger.this.sourceFile.exists()) {
                    Debugger.this.sourceFile = null;
                    Debugger.this.updateDisassemblyLines();
                }
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem("Load Sources Automatically", Boolean.parseBoolean(properties.getProperty("LoadSourcesAutomatically")));
        jCheckBoxMenuItem4.setMnemonic('c');
        debuggerMenu.add(jCheckBoxMenuItem4);
        jCheckBoxMenuItem4.setAction(new AbstractAction(jCheckBoxMenuItem4.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                properties.setProperty("LoadSourcesAutomatically", Boolean.toString(jCheckBoxMenuItem4.isSelected()));
            }
        });
        debuggerMenu.addSeparator();
        MenuItem menuItem5 = new MenuItem("Close", 108);
        debuggerMenu.add(menuItem5);
        menuItem5.setAction(new AbstractAction(menuItem5.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.setVisible(false);
                if (!dapDebugging) {
                    Debugger.close();
                }
            }
        });
        debuggerMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                Debugger.this.menuItemReloadSymbols.setEnabled(Debugger.this.canReloadSymbols());
                jCheckBoxMenuItem.setSelected(Boolean.parseBoolean(properties.getProperty("ReloadSymbolFileOnChange")));
                menuItem.setText(!Debugger.this.loadingSources ? "Load Sources..." : "Cancel Load Sources");
                menuItem4.setEnabled(!forceLoadSources && !Debugger.this.loadingSources && Debugger.this.sourceFile != null && Debugger.this.sourceFile.exists());
                jCheckBoxMenuItem4.setSelected(Boolean.parseBoolean(properties.getProperty("LoadSourcesAutomatically")));
                menuItem3.setEnabled(Debugger.this.debugfileFile != null && Debugger.this.debugfileFile.exists());
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                Debugger.this.menuItemReloadSymbols.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return debuggerMenu;
    }

    private void showSaveDisassemblyFileChooser(Component component) {
        FileChooser fileChooser = new FileChooser(this.properties.getProperty("AsmDir"));
        fileChooser.setDialogTitle("Save As...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Assembler File (*.asm)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".asm") || file.isDirectory();
            }
        });
        String string = Emulicious.getROMfile().getName();
        string = string.substring(0, string.lastIndexOf(46));
        fileChooser.setSelectedFile(new File(String.valueOf(string) + ".asm"));
        if (fileChooser.showSaveDialog(component) == 0) {
            try {
                this.updateDisassemblyLines(this.properties.getInt("MaxDataBlockSize"));
                Z80Disassembler.writeToFile(this.memory, this.lines, fileChooser.getSelectedFile().getPath(), this.getLoadedSymbols());
                this.properties.setProperty("AsmDir", fileChooser.getSelectedFile().getParent());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(component, "An error occurred while trying to create the disassembly!", "Error saving disassembly", 0);
            }
        }
    }

    private void showSymbolFileChooser(Component component) {
        FileChooser fileChooser = new FileChooser(Emulicious.getROMfile().getParentFile());
        fileChooser.setDialogTitle("Load Symbols...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "WLA DX Symbols (*.sym)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".sym") || file.isDirectory();
            }
        });
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "SDCC Symbols (*.map)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".map") || file.isDirectory();
            }
        });
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Z88dk Symbols (*.map)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".map") || file.isDirectory();
            }
        });
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Sjasm Symbols (*.lst)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".lst") || file.isDirectory();
            }
        });
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "All supported Symbols (*.sym;*.map;*.lst)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".sym") || file.getName().toLowerCase().endsWith(".map") || file.getName().toLowerCase().endsWith(".lst") || file.isDirectory();
            }
        });
        fileChooser.setSelectedFile(Debugger.findSymbolsFile());
        if (fileChooser.showOpenDialog(component) == 0) {
            this.loadSymbols(this.systemDebugger, fileChooser.getSelectedFile());
            this.properties.setProperty("SymDir", fileChooser.getSelectedFile().getParent());
            this.updateDisassemblyLines();
        }
    }

    private void showDebugfileFileChooser(Component component) {
        FileChooser fileChooser = new FileChooser(Emulicious.getROMfile().getParentFile());
        fileChooser.setDialogTitle("Load Debugfile...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Debugfiles (*.dbg)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".dbg") || file.isDirectory();
            }
        });
        fileChooser.setSelectedFile(Debugger.findDebugFile());
        if (fileChooser.showOpenDialog(component) == 0) {
            if (fileChooser.getSelectedFile().exists()) {
                this.loadDebugFile(fileChooser.getSelectedFile());
            } else {
                JOptionPane.showMessageDialog(this.window, "Failed to load Debugfile due to the following error:\n" + fileChooser.getSelectedFile().getAbsolutePath() + " does not exist.", "Failed to load Debugfile", 0);
            }
        }
    }

    void showSourceFileChooser(Component component) {
        final FileChooser fileChooser = new FileChooser(Emulicious.getROMfile().getParentFile());
        fileChooser.setDialogTitle("Load Sources...");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Assembler File (*.asm;*.s)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".asm") || file.getName().toLowerCase().endsWith(".s") || file.isDirectory();
            }
        });
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "SDCC Map (*.map)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".map") || file.isDirectory();
            }
        });
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Sjasm Listing (*.lst)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".lst") || file.isDirectory();
            }
        });
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "All supported source files (*.asm;*.s;*.map;*.lst)";
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".asm") || file.getName().toLowerCase().endsWith(".s") || file.getName().toLowerCase().endsWith(".map") || file.getName().toLowerCase().endsWith(".lst") || file.isDirectory();
            }
        });
        fileChooser.setSelectedFile(Debugger.findSourceFile());
        if (fileChooser.showOpenDialog(component) == 0) {
            try {
                final int n = this.getVisibleAddress();
                final int n2 = this.getSelectedAddress();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Debugger.this.loadingSources = true;
                        try {
                            Debugger.this.readAssemblyLines(fileChooser.getSelectedFile(), 1);
                        }
                        catch (IOException iOException) {
                        }
                        catch (AbortException abortException) {}
                        if (fileChooser.getSelectedFile().exists() && Debugger.this.sourceFile == null) {
                            JOptionPane.showMessageDialog(Debugger.this.window, "Failed to load Sources because the selected sources do not appear to match the loaded ROM at all.", "Failed to load Sources", 0);
                        }
                        Debugger.this.loadingSources = false;
                        Debugger.this.setSelectedAddress(n2, false, false);
                        if (Debugger.isSuspended() && Debugger.this.getVisibleAddress() != Debugger.this.address) {
                            if (n >= 0 || Debugger.this.systemDebugger.convertAddress(n) >= 0) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (Debugger.this.getVisibleAddress() != (this).Debugger.this.address) {
                                            Debugger.this.scrollToVisible(n);
                                        }
                                    }
                                });
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (Debugger.this.getVisibleAddress() != (this).Debugger.this.address) {
                                            Debugger.this.scrollCurrentInstructionToVisible();
                                        }
                                    }
                                });
                            }
                        }
                    }
                }, "Sources Loader").start();
                this.properties.setProperty("SrcDir", fileChooser.getSelectedFile().getParent());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean canReloadSymbols() {
        return this.symbolFile != null;
    }

    boolean reloadSymbols() {
        if (this.canReloadSymbols()) {
            this.loadSymbols(this.systemDebugger, this.symbolFile);
            this.updateDisassemblyLines();
            return true;
        }
        return false;
    }

    void reloadDebugfile() {
        if (this.debugfileFile != null) {
            this.loadDebugFile(this.debugfileFile);
        }
    }

    private JMenu makeMenuRun() {
        final Properties properties = this.properties;
        final JTable jTable = this.table;
        DebuggerMenu debuggerMenu = new DebuggerMenu("Run");
        debuggerMenu.setMnemonic('r');
        debuggerMenu.add(this.menuItemResume);
        this.menuItemResume.setAction(new AbstractAction(this.menuItemResume.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.systemDebugger.resume("Resume");
            }
        });
        this.menuItemResume.setIcon(DebuggerIcons.RESUME_ICON);
        this.menuItemResume.setDisabledIcon(DebuggerIcons.RESUME_ICON);
        debuggerMenu.add(this.menuItemSuspend);
        this.menuItemSuspend.setAction(new AbstractAction(this.menuItemSuspend.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.suspend();
            }
        });
        this.menuItemSuspend.setIcon(DebuggerIcons.SUSPEND_ICON);
        this.menuItemSuspend.setDisabledIcon(DebuggerIcons.SUSPEND_ICON);
        debuggerMenu.add(this.menuItemStepInto);
        this.menuItemStepInto.setAction(new AbstractAction(this.menuItemStepInto.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.systemDebugger.stepInto();
            }
        });
        this.menuItemStepInto.setIcon(DebuggerIcons.STEP_INTO_ICON);
        this.menuItemStepInto.setDisabledIcon(DebuggerIcons.STEP_INTO_ICON);
        debuggerMenu.add(this.menuItemStepOver);
        this.menuItemStepOver.setAction(new AbstractAction(this.menuItemStepOver.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.systemDebugger.stepOver();
            }
        });
        this.menuItemStepOver.setIcon(DebuggerIcons.STEP_OVER_ICON);
        this.menuItemStepOver.setDisabledIcon(DebuggerIcons.STEP_OVER_ICON);
        debuggerMenu.add(this.menuItemStepReturn);
        this.menuItemStepReturn.setAction(new AbstractAction(this.menuItemStepReturn.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.systemDebugger.stepReturn();
            }
        });
        this.menuItemStepReturn.setIcon(DebuggerIcons.STEP_RETURN_ICON);
        this.menuItemStepReturn.setDisabledIcon(DebuggerIcons.STEP_RETURN_ICON);
        debuggerMenu.add(this.menuItemAdvanceFrame);
        this.menuItemAdvanceFrame.setAction(new AbstractAction(this.menuItemAdvanceFrame.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.systemDebugger.advanceFrame();
            }
        });
        this.menuItemAdvanceFrame.setIcon(DebuggerIcons.ADVANCE_FRAME_ICON);
        this.menuItemAdvanceFrame.setDisabledIcon(DebuggerIcons.ADVANCE_FRAME_ICON);
        debuggerMenu.add(this.menuItemStepBack);
        this.menuItemStepBack.setAction(new AbstractAction(this.menuItemStepBack.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.systemDebugger.stepBack();
            }
        });
        this.menuItemStepBack.setIcon(DebuggerIcons.STEP_BACK_ICON);
        this.menuItemStepBack.setDisabledIcon(DebuggerIcons.STEP_BACK_ICON);
        debuggerMenu.add(this.menuItemStepBackOver);
        this.menuItemStepBackOver.setAction(new AbstractAction(this.menuItemStepBackOver.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.systemDebugger.stepBackOver();
            }
        });
        this.menuItemStepBackOver.setIcon(DebuggerIcons.STEP_BACK_OVER_ICON);
        this.menuItemStepBackOver.setDisabledIcon(DebuggerIcons.STEP_BACK_OVER_ICON);
        debuggerMenu.add(this.menuItemStepBackReturn);
        this.menuItemStepBackReturn.setAction(new AbstractAction(this.menuItemStepBackReturn.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.systemDebugger.stepBackReturn();
            }
        });
        this.menuItemStepBackReturn.setIcon(DebuggerIcons.STEP_BACK_RETURN_ICON);
        this.menuItemStepBackReturn.setDisabledIcon(DebuggerIcons.STEP_BACK_RETURN_ICON);
        debuggerMenu.add(this.menuItemRunToLine);
        this.menuItemRunToLine.setAction(new AbstractAction(this.menuItemRunToLine.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                boolean bl = Debugger.this.isRomRow(jTable.getSelectedRow());
                int n2 = n = bl ? Debugger.this.getSelectedAddress() : Debugger.this.systemDebugger.convertAddress(Debugger.this.getSelectedAddress());
                if (n >= 0) {
                    Debugger.this.systemDebugger.runToAddress(n, bl);
                }
            }
        });
        debuggerMenu.add(this.menuItemRunBackwardsToLine);
        this.menuItemRunBackwardsToLine.setAction(new AbstractAction(this.menuItemRunBackwardsToLine.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                boolean bl = Debugger.this.isRomRow(jTable.getSelectedRow());
                int n2 = n = bl ? Debugger.this.getSelectedAddress() : Debugger.this.systemDebugger.convertAddress(Debugger.this.getSelectedAddress());
                if (n >= 0) {
                    Debugger.this.systemDebugger.runBackToAddress(n, bl);
                }
            }
        });
        debuggerMenu.add(this.menuItemSuspendOnOpen);
        this.menuItemSuspendOnOpen.setAction(new AbstractAction(this.menuItemSuspendOnOpen.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Debugger.this.menuItemSuspendOnOpen.isSelected()) {
                    properties.setProperty("DebuggerSuspendOnOpen", "" + Debugger.this.menuItemSuspendOnOpen.isSelected());
                } else {
                    properties.remove("DebuggerSuspendOnOpen");
                }
            }
        });
        debuggerMenu.add(this.menuItemBringToTopUponSuspend);
        this.menuItemBringToTopUponSuspend.setAction(new AbstractAction(this.menuItemBringToTopUponSuspend.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Debugger.this.menuItemBringToTopUponSuspend.isSelected()) {
                    properties.setProperty("DebuggerBringToTopUponSuspend", "" + Debugger.this.menuItemBringToTopUponSuspend.isSelected());
                } else {
                    properties.remove("DebuggerBringToTopUponSuspend");
                }
            }
        });
        debuggerMenu.addSeparator();
        debuggerMenu.add(this.menuItemUndo);
        this.menuItemUndo.setAction(new AbstractAction(this.menuItemUndo.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.systemDebugger.undo();
            }
        });
        debuggerMenu.add(this.menuItemRedo);
        this.menuItemRedo.setAction(new AbstractAction(this.menuItemRedo.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.systemDebugger.redo();
            }
        });
        debuggerMenu.addSeparator();
        debuggerMenu.add(this.menuItemJumpToLine);
        this.menuItemJumpToLine.setAction(new AbstractAction(this.menuItemJumpToLine.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                boolean bl = Debugger.this.isRomRow(jTable.getSelectedRow());
                int n2 = n = bl ? Debugger.this.getSelectedAddress() : Debugger.this.systemDebugger.convertAddress(Debugger.this.getSelectedAddress());
                if (n >= 0) {
                    if (bl) {
                        Debugger.this.systemDebugger.setAddress(n, Z80Disassembler.getSlot(n / 16384));
                    } else {
                        Debugger.this.systemDebugger.setPC(n);
                    }
                }
            }
        });
        debuggerMenu.addSeparator();
        debuggerMenu.add(this.menuItemToggleBreakpoint);
        this.menuItemToggleBreakpoint.setAction(new AbstractAction(this.menuItemToggleBreakpoint.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.toggleBreakpoint(jTable.getSelectedRow());
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Skip Breakpoints");
        debuggerMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.setModel(this.skipBreakpoints);
        jCheckBoxMenuItem.setIcon(DebuggerIcons.SkipBreakpointsIcon.UNSELECTED);
        jCheckBoxMenuItem.setSelectedIcon(DebuggerIcons.SkipBreakpointsIcon.SELECTED);
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Skip Exceptions");
        debuggerMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2.setModel(this.skipExceptions);
        jCheckBoxMenuItem2.setIcon(DebuggerIcons.SKIP_EXCEPTIONS_ICON);
        jCheckBoxMenuItem2.setSelectedIcon(DebuggerIcons.SKIP_EXCEPTIONS_ICON);
        debuggerMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                boolean bl = Debugger.this.isRomRow(jTable.getSelectedRow());
                int n = bl ? Debugger.this.getSelectedAddress() : Debugger.this.systemDebugger.convertAddress(Debugger.this.getSelectedAddress());
                Debugger.this.menuItemResume.setEnabled(Debugger.this.systemDebugger.isSuspended());
                Debugger.this.menuItemSuspend.setEnabled(Emulicious.isRunning() && !Debugger.this.systemDebugger.isSuspended());
                Debugger.this.menuItemStepInto.setEnabled(Debugger.this.systemDebugger.isSuspended());
                Debugger.this.menuItemStepOver.setEnabled(Debugger.this.systemDebugger.isSuspended());
                Debugger.this.menuItemStepReturn.setEnabled(Debugger.this.systemDebugger.canStepReturn());
                Debugger.this.menuItemAdvanceFrame.setEnabled(Debugger.this.systemDebugger.isSuspended());
                Debugger.this.menuItemStepBack.setEnabled(Debugger.this.systemDebugger.canStepBack());
                Debugger.this.menuItemStepBackOver.setEnabled(Debugger.this.systemDebugger.canStepBackOver());
                Debugger.this.menuItemStepBackReturn.setEnabled(Debugger.this.systemDebugger.canStepBackReturn());
                Debugger.this.menuItemRunToLine.setEnabled(Debugger.this.systemDebugger.isSuspended() && n >= 0);
                Debugger.this.menuItemRunBackwardsToLine.setEnabled(Debugger.this.systemDebugger.isSuspended() && n >= 0);
                Debugger.this.menuItemSuspendOnOpen.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerSuspendOnOpen")));
                Debugger.this.menuItemBringToTopUponSuspend.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerBringToTopUponSuspend")));
                Debugger.this.menuItemUndo.setEnabled(Debugger.this.systemDebugger.canUndo());
                Debugger.this.menuItemUndo.setText(Debugger.this.systemDebugger.getUndoText());
                Debugger.this.menuItemRedo.setEnabled(Debugger.this.systemDebugger.canRedo());
                Debugger.this.menuItemRedo.setText(Debugger.this.systemDebugger.getRedoText());
                Debugger.this.menuItemJumpToLine.setEnabled(Debugger.this.systemDebugger.isSuspended() && n >= 0);
                Debugger.this.menuItemToggleBreakpoint.setEnabled(Debugger.this.canToggleBreakpoint(jTable.getSelectedRow()));
                if (jTable.getSelectedRow() >= 0) {
                    Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)jTable.getValueAt(jTable.getSelectedRow(), 1);
                    if (sourceLine.getAddress() >= 0 && sourceLine.getInstruction() != null) {
                        Debugger.this.menuItemToggleBreakpoint.setText("Toggle Breakpoint");
                    } else {
                        Debugger.this.menuItemToggleBreakpoint.setText("Toggle Watchpoint");
                    }
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                Debugger.this.menuItemRunToLine.setEnabled(true);
                Debugger.this.menuItemRunBackwardsToLine.setEnabled(true);
                Debugger.this.menuItemUndo.setEnabled(true);
                Debugger.this.menuItemRedo.setEnabled(true);
                Debugger.this.menuItemJumpToLine.setEnabled(true);
                Debugger.this.menuItemToggleBreakpoint.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return debuggerMenu;
    }

    private JMenu makeMenuNavigate() {
        final JTable jTable = this.table;
        final Properties properties = this.properties;
        final util.map.Map<String> map = this.portNames;
        DebuggerMenu debuggerMenu = new DebuggerMenu("Navigate");
        debuggerMenu.setMnemonic('n');
        debuggerMenu.add(this.menuItemGoTo);
        this.menuItemGoTo.setAction(new AbstractAction(this.menuItemGoTo.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.createNavigationAnchor();
                String string = GoToDialog.open(Debugger.this.window, "Enter ROM Address (HEX) or label:", Debugger.this.getAllLabels(), new DocumentListener(){
                    private String prevText;

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                    }

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        Document document = documentEvent.getDocument();
                        try {
                            String string = document.getText(0, document.getLength());
                            if (!string.equals(this.prevText)) {
                                try {
                                    String[] stringArray = string.split(":");
                                    if (stringArray.length > 2) {
                                        throw new NumberFormatException();
                                    }
                                    int n = stringArray.length == 2 ? Integer.parseInt(stringArray[0], 16) : -1;
                                    int n2 = Integer.parseInt(stringArray.length == 2 ? stringArray[1] : string, 16);
                                    Debugger.this.goTo(n2, n);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    Debugger.this.setSelectedAddress(string, false);
                                }
                            }
                            this.prevText = string;
                        }
                        catch (BadLocationException badLocationException) {}
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                    }
                });
                if (string == null && !Debugger.this.backwardStack.isEmpty()) {
                    int n = (Integer)Debugger.this.backwardStack.pop();
                    Debugger.this.scrollRowToVisible(n);
                    jTable.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        });
        debuggerMenu.add(this.menuItemGotoCurrentInstruction);
        this.menuItemGotoCurrentInstruction.setAction(new AbstractAction(this.menuItemGotoCurrentInstruction.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Debugger.this.address >= 0 ? Debugger.this.tableRows[Debugger.this.address] : Debugger.this.getCpuRow(Debugger.this.systemDebugger.getPC());
                Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)jTable.getValueAt(n, 1);
                if (sourceLine.getInstruction() == null || !Debugger.this.isMatchingInstruction(sourceLine)) {
                    n = Debugger.this.getCpuRow(Debugger.this.systemDebugger.getPC());
                }
                Debugger.this.createNavigationAnchor();
                jTable.getSelectionModel().setSelectionInterval(n, n);
                Debugger.this.scrollCurrentInstructionToVisible();
            }
        });
        this.menuItemGotoCurrentInstruction.setIcon(DebuggerIcons.GO_TO_CURRENT_INSTRUCTION_ICON);
        debuggerMenu.add(this.menuItemGoToDestination);
        this.menuItemGoToDestination.setAction(new AbstractAction(this.menuItemGoToDestination.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.getSelectedRow();
                jTable.getSelectionModel().setSelectionInterval(n, n);
                Debugger.this.goToDestination(n);
            }
        });
        this.menuItemGoToDestination.setIcon(DebuggerIcons.GO_TO_DESTINATION_ICON);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Follow Current Instruction", Boolean.parseBoolean(properties.getProperty("FollowCurrentInstruction")));
        debuggerMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.setAction(new AbstractAction(jCheckBoxMenuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBoxMenuItem.isSelected()) {
                    properties.remove("FollowCurrentInstruction");
                } else {
                    properties.setProperty("FollowCurrentInstruction", "false");
                }
            }
        });
        debuggerMenu.addSeparator();
        debuggerMenu.add(this.menuItemReferenceHierarchy);
        this.menuItemReferenceHierarchy.setAction(new AbstractAction(this.menuItemReferenceHierarchy.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Debugger.this.canOpenReferenceHierarchy()) {
                    Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)jTable.getValueAt(jTable.getSelectedRow(), 1);
                    if (sourceLine.getAddress() >= 0) {
                        int n;
                        RamRomMap ramRomMap = Debugger.this.systemDebugger.getRamRomMap();
                        if (Debugger.this.rowHasLabel(jTable.getSelectedRow()) && !Debugger.this.isWordSelected()) {
                            if (Debugger.this.isRomRow(jTable.getSelectedRow()) || Debugger.this.systemDebugger.isROMaddress(sourceLine.getAddress())) {
                                ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getReferenceHierarchy(sourceLine.getAddress()));
                            } else if (Debugger.this.systemDebugger.isRAMaddress(sourceLine.getAddress())) {
                                ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getRamReferenceHierarchy(Debugger.this.systemDebugger.mapAddress(sourceLine.getAddress())));
                            } else if (Debugger.this.systemDebugger.isSRAMaddress(sourceLine.getAddress())) {
                                ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getSramReferenceHierarchy(sourceLine.getAddress(), sourceLine.getAddress()));
                            }
                        } else if (sourceLine.getInstruction() != null) {
                            Z80Disassembler.Reference reference = Z80Disassembler.getPortReferenceHierarchy(sourceLine, map);
                            if (reference != null) {
                                ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, reference, sourceLine.getAddress());
                            } else if (Debugger.this.systemDebugger.isRAMaddress(sourceLine.getInstruction().getArg())) {
                                ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getRamReferenceHierarchy(Debugger.this.systemDebugger.mapAddress(sourceLine.getInstruction().getArg())), sourceLine.getAddress());
                            } else if (Debugger.this.systemDebugger.isSRAMaddress(sourceLine.getInstruction().getArg())) {
                                ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getSramReferenceHierarchy(sourceLine.getInstruction().getArg(), sourceLine.getAddress()), sourceLine.getAddress());
                            } else {
                                ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getReferenceHierarchy(Debugger.this.getDestination(jTable.getSelectedRow())), sourceLine.getAddress());
                            }
                        } else if (Debugger.getDataSize(sourceLine) == 2 && (n = Debugger.this.getSelectedAddress()) >= 0) {
                            int n2 = Debugger.this.READ_WORD(n);
                            if (Debugger.this.systemDebugger.isRAMaddress(n2)) {
                                ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getRamReferenceHierarchy(Debugger.this.systemDebugger.mapAddress(n2)), n);
                            } else if (Debugger.this.systemDebugger.isSRAMaddress(n2)) {
                                ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getSramReferenceHierarchy(n2, n), n);
                            } else {
                                ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getReferenceHierarchy(Z80Disassembler.getDestination(n, ramRomMap, n2)), n);
                            }
                        }
                    } else {
                        Z80Disassembler.SourceLine sourceLine2 = (Z80Disassembler.SourceLine)jTable.getValueAt(jTable.getSelectedRow() + 1, 1);
                        if (Debugger.this.isRomRow(jTable.getSelectedRow() + 1) || Debugger.this.systemDebugger.isROMaddress(sourceLine2.getAddress())) {
                            ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getReferenceHierarchy(sourceLine2.getAddress()));
                        } else if (Debugger.this.systemDebugger.isRAMaddress(sourceLine2.getAddress())) {
                            ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getRamReferenceHierarchy(Debugger.this.systemDebugger.mapAddress(sourceLine2.getAddress())));
                        } else if (Debugger.this.systemDebugger.isSRAMaddress(sourceLine2.getAddress())) {
                            ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getSramReferenceHierarchy(sourceLine2.getAddress(), sourceLine2.getAddress()));
                        }
                    }
                }
            }
        });
        debuggerMenu.add(this.menuItemOpenInMemoryEditor);
        this.menuItemOpenInMemoryEditor.setAction(new AbstractAction(this.menuItemOpenInMemoryEditor.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Debugger.this.getSelectedAddress();
                if (n >= 0) {
                    int[] nArray;
                    Z80Disassembler.SourceLine sourceLine;
                    int n2;
                    Z80Disassembler.SourceLine sourceLine2 = Debugger.this.getSourceLine(n);
                    if (Debugger.this.isWordSelected() && sourceLine2.getInstruction() != null) {
                        if (sourceLine2.getInstruction().getPrefix() > 0) {
                            ++n;
                            if (sourceLine2.getInstruction().hasDisplacement()) {
                                ++n;
                            }
                        }
                        ++n;
                    }
                    if ((n2 = (sourceLine = (Z80Disassembler.SourceLine)jTable.getValueAt((nArray = jTable.getSelectedRows())[nArray.length - 1], 1)).getAddress() + (nArray.length > 1 ? sourceLine.getSize() - 1 : 0)) < n) {
                        n2 = n;
                    }
                    Debugger.this.openROMaddressInMemoryEditor(n, n2);
                } else {
                    n = Debugger.this.getSelectedRamAddress();
                    if (n >= 0) {
                        int[] nArray = jTable.getSelectedRows();
                        int n3 = Debugger.this.getRamAddressAtRow(nArray[nArray.length - 1]);
                        if (n3 < n) {
                            n3 = n;
                        }
                        Debugger.this.openRAMaddressInMemoryEditor(n, n3);
                    } else {
                        n = Debugger.this.getSelectedSRamAddress();
                        if (n >= 0) {
                            int[] nArray = jTable.getSelectedRows();
                            int n4 = Debugger.this.getSRamAddressAtRow(nArray[nArray.length - 1]);
                            if (n4 < n) {
                                n4 = n;
                            }
                            Debugger.this.openSRAMaddressInMemoryEditor(n, n4);
                        }
                    }
                }
            }
        });
        debuggerMenu.add(this.menuItemSelectReferencedMemory);
        this.menuItemSelectReferencedMemory.setAction(new AbstractAction(this.menuItemSelectReferencedMemory.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Debugger.this.canSelectReferencedMemory()) {
                    Debugger.this.selectMemory(Debugger.this.getMemoryAccessAddress(Debugger.this.getCurrentInstruction()));
                }
            }
        });
        debuggerMenu.add(this.menuItemWatch);
        this.menuItemWatch.setAction(new AbstractAction(this.menuItemWatch.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Debugger.this.getSelectedRamAddress();
                if (n >= 0) {
                    RAMWatchWindow.open(Debugger.this.window, Debugger.this, Debugger.this.asExpression(0xC000 | n).wrapInRead(), false);
                }
            }
        });
        debuggerMenu.addSeparator();
        debuggerMenu.add(this.menuItemFind);
        this.menuItemFind.setAction(new AbstractAction(this.menuItemFind.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindDialog.open(Debugger.this.window);
            }
        });
        debuggerMenu.addSeparator();
        debuggerMenu.add(this.menuItemPrevAddress);
        this.menuItemPrevAddress.setAction(new AbstractAction(this.menuItemPrevAddress.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.prevAddress();
            }
        });
        this.menuItemPrevAddress.setIcon(DebuggerIcons.PREVIOUS_IN_TRACE_ICON);
        this.menuItemPrevAddress.setDisabledIcon(DebuggerIcons.PREVIOUS_IN_TRACE_ICON);
        debuggerMenu.add(this.menuItemNextAddress);
        this.menuItemNextAddress.setAction(new AbstractAction(this.menuItemNextAddress.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.nextAddress();
            }
        });
        this.menuItemNextAddress.setIcon(DebuggerIcons.NEXT_IN_TRACE_ICON);
        this.menuItemNextAddress.setDisabledIcon(DebuggerIcons.NEXT_IN_TRACE_ICON);
        debuggerMenu.addSeparator();
        debuggerMenu.add(this.menuItemBack);
        this.menuItemBack.setAction(new AbstractAction(this.menuItemBack.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.navigateBack();
            }
        });
        this.menuItemBack.setIcon(DebuggerIcons.NAVIGATE_BACK_ICON);
        this.menuItemBack.setDisabledIcon(DebuggerIcons.NAVIGATE_BACK_ICON);
        debuggerMenu.add(this.menuItemForward);
        this.menuItemForward.setAction(new AbstractAction(this.menuItemForward.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.navigateForward();
            }
        });
        this.menuItemForward.setIcon(DebuggerIcons.NAVIGATE_FORWARD_ICON);
        this.menuItemForward.setDisabledIcon(DebuggerIcons.NAVIGATE_FORWARD_ICON);
        debuggerMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                Debugger.this.menuItemPrevAddress.setEnabled(Debugger.this.hasPrevAddress());
                Debugger.this.menuItemNextAddress.setEnabled(Debugger.this.hasNextAddress());
                Debugger.this.menuItemBack.setEnabled(Debugger.this.canNavigateBack());
                Debugger.this.menuItemForward.setEnabled(Debugger.this.canNavigateForward());
                jCheckBoxMenuItem.setSelected(Boolean.parseBoolean(properties.getProperty("FollowCurrentInstruction")));
                Debugger.this.menuItemReferenceHierarchy.setEnabled(Debugger.this.canOpenReferenceHierarchy());
                Debugger.this.menuItemOpenInMemoryEditor.setEnabled(Debugger.this.getSelectedAddress() >= 0 || Debugger.this.getSelectedRamAddress() >= 0 || Debugger.this.getSelectedSRamAddress() >= 0);
                Debugger.this.menuItemSelectReferencedMemory.setEnabled(Debugger.this.canSelectReferencedMemory());
                Debugger.this.menuItemWatch.setEnabled(Debugger.this.systemDebugger.isRAMaddress(Debugger.this.getSelectedRamAddress()));
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                Debugger.this.menuItemReferenceHierarchy.setEnabled(true);
                Debugger.this.menuItemOpenInMemoryEditor.setEnabled(true);
                Debugger.this.menuItemSelectReferencedMemory.setEnabled(true);
                Debugger.this.menuItemWatch.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return debuggerMenu;
    }

    private JMenu makeMenuView() {
        final JTable jTable = this.table;
        final Properties properties = this.properties;
        DebuggerMenu debuggerMenu = new DebuggerMenu("View");
        debuggerMenu.setMnemonic('v');
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Hide Toolbar");
        debuggerMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBoxMenuItem.isSelected()) {
                    Debugger.this.window.remove(Debugger.this.toolBar);
                } else {
                    Debugger.this.window.add((Component)Debugger.this.toolBar, "First");
                }
                Debugger.this.window.validate();
                Debugger.this.window.repaint();
            }
        });
        debuggerMenu.add(this.makeMenuCpuGraph());
        debuggerMenu.addSeparator();
        Emulicious.addFontMenus(debuggerMenu);
        debuggerMenu.addSeparator();
        Debugger.addDebuggerThemeOptions(debuggerMenu);
        debuggerMenu.addSeparator();
        debuggerMenu.add(this.makeMenuSyntaxHighlighting());
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Show Addresses");
        debuggerMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2.setAction(new AbstractAction(jCheckBoxMenuItem2.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBoxMenuItem2.isSelected()) {
                    properties.setProperty("DebuggerShowAddresses", "true");
                } else {
                    properties.remove("DebuggerShowAddresses");
                }
                Debugger.this.packDisassemblerTable();
                jTable.repaint();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Show Byte Code");
        debuggerMenu.add(jCheckBoxMenuItem3);
        jCheckBoxMenuItem3.setAction(new AbstractAction(jCheckBoxMenuItem3.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBoxMenuItem3.isSelected()) {
                    properties.setProperty("DebuggerShowByteCode", "true");
                } else {
                    properties.remove("DebuggerShowByteCode");
                }
                Debugger.this.packDisassemblerTable();
                jTable.repaint();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem("Display Memory Values");
        debuggerMenu.add(jCheckBoxMenuItem4);
        jCheckBoxMenuItem4.setAction(new AbstractAction(jCheckBoxMenuItem4.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jCheckBoxMenuItem4.isSelected()) {
                    properties.setProperty("DebuggerDisplayMemoryValues", "false");
                } else {
                    properties.remove("DebuggerDisplayMemoryValues");
                }
                jTable.repaint();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem5 = new JCheckBoxMenuItem("Use Gray for Address and Byte Code");
        debuggerMenu.add(jCheckBoxMenuItem5);
        jCheckBoxMenuItem5.setAction(new AbstractAction(jCheckBoxMenuItem5.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                properties.setProperty("DebuggerGrayAddressAndByteCode", "" + jCheckBoxMenuItem5.isSelected());
                jTable.repaint();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem6 = new JCheckBoxMenuItem("Use Bold Font for Address and Byte Code");
        debuggerMenu.add(jCheckBoxMenuItem6);
        jCheckBoxMenuItem6.setAction(new AbstractAction(jCheckBoxMenuItem6.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                properties.setProperty("DebuggerBoldAddressAndByteCode", "" + jCheckBoxMenuItem6.isSelected());
                jTable.repaint();
            }
        });
        debuggerMenu.addSeparator();
        final JCheckBoxMenuItem jCheckBoxMenuItem7 = new JCheckBoxMenuItem("Show Coverage");
        debuggerMenu.add(jCheckBoxMenuItem7);
        jCheckBoxMenuItem7.setAction(new AbstractAction(jCheckBoxMenuItem7.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jCheckBoxMenuItem7.isSelected()) {
                    properties.setProperty("DebuggerShowCoverage", "false");
                } else {
                    properties.remove("DebuggerShowCoverage");
                }
                jTable.repaint();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem8 = new JCheckBoxMenuItem("Show Coverage Only in Ruler");
        debuggerMenu.add(jCheckBoxMenuItem8);
        jCheckBoxMenuItem8.setAction(new AbstractAction(jCheckBoxMenuItem8.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jCheckBoxMenuItem8.isSelected()) {
                    properties.setProperty("DebuggerShowCoverageInRulerOnly", "false");
                } else {
                    properties.remove("DebuggerShowCoverageInRulerOnly");
                }
                jTable.repaint();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem9 = new JCheckBoxMenuItem("Highlight Trace");
        debuggerMenu.add(jCheckBoxMenuItem9);
        jCheckBoxMenuItem9.setAction(new AbstractAction(jCheckBoxMenuItem9.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jCheckBoxMenuItem9.isSelected()) {
                    properties.setProperty("DebuggerHighlightTrace", "false");
                } else {
                    properties.remove("DebuggerHighlightTrace");
                }
                jTable.repaint();
            }
        });
        debuggerMenu.addSeparator();
        final JCheckBoxMenuItem jCheckBoxMenuItem10 = new JCheckBoxMenuItem("Display Addresses as File Offsets");
        debuggerMenu.add(jCheckBoxMenuItem10);
        jCheckBoxMenuItem10.setAction(new AbstractAction(jCheckBoxMenuItem10.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBoxMenuItem10.isSelected()) {
                    properties.setProperty("DebuggerDisplayOffsets", "true");
                } else {
                    properties.remove("DebuggerDisplayOffsets");
                }
                CoverageWindow.update();
                Debugger.this.packDisassemblerTable();
                jTable.repaint();
            }
        });
        debuggerMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                jCheckBoxMenuItem.setSelected(Debugger.this.toolBar.getParent() == null);
                jCheckBoxMenuItem2.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerShowAddresses")));
                jCheckBoxMenuItem3.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerShowByteCode")));
                jCheckBoxMenuItem4.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerDisplayMemoryValues")));
                jCheckBoxMenuItem9.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerHighlightTrace")));
                jCheckBoxMenuItem7.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerShowCoverage")));
                jCheckBoxMenuItem8.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerShowCoverageInRulerOnly")));
                jCheckBoxMenuItem10.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerDisplayOffsets")));
                jCheckBoxMenuItem5.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerGrayAddressAndByteCode")));
                jCheckBoxMenuItem6.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerBoldAddressAndByteCode")));
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return debuggerMenu;
    }

    public static void addDebuggerThemeOptions(JMenu jMenu) {
        int n = Emulicious.getProperties().getInt("HighlightingPreference");
        final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Prefer System Theme", n == 0);
        if (!"Mac OS X".equals(System.getProperty("os.name"))) {
            jMenu.add(jRadioButtonMenuItem);
        } else if (n == 0) {
            n = 1;
        }
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Emulicious.getProperties().setProperty("HighlightingPreference", "0");
                if (debugger != null) {
                    debugger.updateHighlighter();
                }
            }
        });
        final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Prefer Light Theme", n == 1);
        jMenu.add(jRadioButtonMenuItem2);
        jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Emulicious.getProperties().setProperty("HighlightingPreference", "1");
                if (debugger != null) {
                    debugger.updateHighlighter();
                }
            }
        });
        final JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Prefer Dark Theme", n == -1);
        jMenu.add(jRadioButtonMenuItem3);
        jRadioButtonMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Emulicious.getProperties().setProperty("HighlightingPreference", "-1");
                if (debugger != null) {
                    debugger.updateHighlighter();
                }
            }
        });
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                int n = Emulicious.getProperties().getInt("HighlightingPreference");
                if ("Mac OS X".equals(System.getProperty("os.name")) && n == 0) {
                    n = 1;
                }
                jRadioButtonMenuItem.setSelected(n == 0);
                jRadioButtonMenuItem2.setSelected(n == 1);
                jRadioButtonMenuItem3.setSelected(n == -1);
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }

    private JMenu makeMenuCpuGraph() {
        JMenu jMenu = new JMenu("CPU Graph");
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Hide CPU Usage Graph");
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.cpuUsagePlot.setVisible(!jCheckBoxMenuItem.isSelected());
            }
        });
        jMenu.addSeparator();
        final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Filled Style");
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.cpuUsagePlot.setFillMode(true);
                Debugger.this.properties.setProperty("DebuggerCpuUsageFilled", "true");
            }
        });
        final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Line Style");
        jMenu.add(jRadioButtonMenuItem2);
        jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.cpuUsagePlot.setFillMode(false);
                Debugger.this.properties.setProperty("DebuggerCpuUsageFilled", "false");
            }
        });
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                jCheckBoxMenuItem.setSelected(!Debugger.this.cpuUsagePlot.isVisible());
                jRadioButtonMenuItem.setSelected(Debugger.this.cpuUsagePlot.isFillMode());
                jRadioButtonMenuItem2.setSelected(!Debugger.this.cpuUsagePlot.isFillMode());
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private JMenu makeMenuSyntaxHighlighting() {
        final Properties properties = this.properties;
        final JMenu jMenu = new JMenu("Syntax Highlighting");
        jMenu.setMnemonic('h');
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                jMenu.removeAll();
                final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Enabled", Boolean.parseBoolean(properties.getProperty("Highlighting")));
                jMenu.add(jCheckBoxMenuItem);
                jCheckBoxMenuItem.setAction(new AbstractAction(jCheckBoxMenuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Debugger.this.highlighting = jCheckBoxMenuItem.isSelected();
                        if (Debugger.this.highlighting) {
                            properties.remove("Highlighting");
                        } else {
                            properties.setProperty("Highlighting", "" + Debugger.this.highlighting);
                        }
                        Debugger.this.updateHighlighter();
                    }
                });
                final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Disable While Running", !Debugger.this.highlightWhileRunning);
                jMenu.add(jCheckBoxMenuItem2);
                jCheckBoxMenuItem2.setAction(new AbstractAction(jCheckBoxMenuItem2.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Debugger.this.highlightWhileRunning = !jCheckBoxMenuItem2.isSelected();
                        if (Debugger.this.highlightWhileRunning) {
                            properties.setProperty("HighlightWhileRunning", "" + Debugger.this.highlightWhileRunning);
                        } else {
                            properties.remove("HighlightWhileRunning");
                        }
                    }
                });
                jMenu.addSeparator();
                HashSet<String> hashSet = new HashSet<String>();
                File[] fileArray = Emulicious.getHighlightersDir().listFiles();
                if (fileArray != null) {
                    File[] fileArray2 = fileArray;
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray2[n2];
                        String string = file.getName().toLowerCase();
                        if (string.endsWith(".chl") || string.endsWith(".xml")) {
                            String string2 = file.getName().substring(0, file.getName().lastIndexOf(46));
                            if (string2.endsWith("-dark")) {
                                string2 = string2.substring(0, string2.length() - "-dark".length());
                            } else if (string2.endsWith("-light")) {
                                string2 = string2.substring(0, string2.length() - "-light".length());
                            }
                            if (hashSet.add(string2)) {
                                final String string3 = string2;
                                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2, Debugger.this.highlighterFile != null && Debugger.this.highlighterFile.getName().startsWith(string3));
                                jMenu.add(jRadioButtonMenuItem);
                                jRadioButtonMenuItem.setAction(new AbstractAction(jRadioButtonMenuItem.getText()){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        Emulicious.setHighlighter(string3);
                                        Debugger.this.updateHighlighter();
                                    }
                                });
                            }
                        }
                        ++n2;
                    }
                }
                if (hashSet.isEmpty()) {
                    jMenu.add(new MenuItem("No highlighters found!"));
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private JMenu makeMenuExpressions() {
        final Properties properties = this.properties;
        final DefaultTableModel defaultTableModel = this.expressionsTableModel;
        DebuggerMenu debuggerMenu = new DebuggerMenu("Expressions");
        debuggerMenu.setMnemonic('e');
        MenuItem menuItem = new MenuItem("Clear Expressions", 99);
        debuggerMenu.add(menuItem);
        menuItem.setAction(new AbstractAction(menuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                defaultTableModel.setRowCount(0);
            }
        });
        debuggerMenu.addSeparator();
        menuItem = new MenuItem("Import from Symbol File", 105);
        debuggerMenu.add(menuItem);
        menuItem.setAction(new AbstractAction(menuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.importSymbolExpressions();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Automatically import from Symbol File", Boolean.parseBoolean(properties.getProperty("AutoImportSymbolExpressions")));
        debuggerMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.setAction(new AbstractAction(jCheckBoxMenuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBoxMenuItem.isSelected()) {
                    properties.setProperty("AutoImportSymbolExpressions", "true");
                } else {
                    properties.remove("AutoImportSymbolExpressions");
                }
            }
        });
        debuggerMenu.addSeparator();
        menuItem = new MenuItem("Infer sizes from address distances", 110);
        debuggerMenu.add(menuItem);
        menuItem.setAction(new AbstractAction(menuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.inferExpressionSizes();
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Automatically infer sizes from address distances", Boolean.parseBoolean(properties.getProperty("AutoInferExpressionSizes")));
        debuggerMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2.setAction(new AbstractAction(jCheckBoxMenuItem2.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBoxMenuItem2.isSelected()) {
                    properties.setProperty("AutoInferExpressionSizes", "true");
                } else {
                    properties.remove("AutoInferExpressionSizes");
                }
            }
        });
        return debuggerMenu;
    }

    private JMenu makeMenuTools() {
        final Properties properties = this.properties;
        DebuggerMenu debuggerMenu = new DebuggerMenu("Tools");
        debuggerMenu.setMnemonic('t');
        debuggerMenu.add(this.menuItemBreakpoints);
        this.menuItemBreakpoints.setAction(new AbstractAction(this.menuItemBreakpoints.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.openBreakpointWindow();
            }
        });
        this.menuItemBreakpoints.setIcon(DebuggerIcons.BREAKPOINTS_ICON);
        debuggerMenu.add(this.menuItemTracer);
        this.menuItemTracer.setAction(new AbstractAction(this.menuItemTracer.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TracerWindow.open(Debugger.this.window, Debugger.this, Debugger.this.systemDebugger, false);
            }
        });
        this.menuItemTracer.setIcon(DebuggerIcons.TRACE_LOGGER_ICON);
        debuggerMenu.add(this.menuItemProfiler);
        this.menuItemProfiler.setAction(new AbstractAction(this.menuItemProfiler.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerWindow.open(Debugger.this.window, Debugger.this, Debugger.this.prfFile, false);
            }
        });
        this.menuItemProfiler.setIcon(DebuggerIcons.PROFILER_ICON);
        debuggerMenu.add(this.menuItemCoverage);
        this.menuItemCoverage.setAction(new AbstractAction(this.menuItemCoverage.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoverageWindow.open(Debugger.this.window, Debugger.this, false);
            }
        });
        this.menuItemCoverage.setIcon(DebuggerIcons.HEATMAP_ICON);
        debuggerMenu.add(this.menuItemPlotter);
        this.menuItemPlotter.setAction(new AbstractAction(this.menuItemPlotter.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotterWindow.open(Debugger.this.window, Debugger.this.memory, false);
            }
        });
        this.menuItemPlotter.setIcon(DebuggerIcons.PLOTTER_ICON);
        debuggerMenu.add(this.menuItemRamWatch);
        this.menuItemRamWatch.setAction(new AbstractAction(this.menuItemRamWatch.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RAMWatchWindow.open(Debugger.this.window, debugger, false);
            }
        });
        this.menuItemRamWatch.setIcon(DebuggerIcons.RAM_WATCH_ICON);
        debuggerMenu.add(this.menuItemRamSearch);
        this.menuItemRamSearch.setAction(new AbstractAction(this.menuItemRamSearch.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RAMSearchWindow.open(Debugger.this.window, Debugger.this.systemDebugger, false);
            }
        });
        this.menuItemRamSearch.setIcon(DebuggerIcons.RAM_SEARCH_ICON);
        debuggerMenu.addSeparator();
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Open Assembler When Typing");
        debuggerMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.setAction(new AbstractAction(jCheckBoxMenuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                properties.setProperty("EnableAssembler", "" + abstractButton.isSelected());
                if (abstractButton.isSelected()) {
                    Debugger.this.table.addKeyListener(Debugger.this.assemblerKeyListener);
                } else {
                    Debugger.this.table.removeKeyListener(Debugger.this.assemblerKeyListener);
                }
            }
        });
        jCheckBoxMenuItem.setIcon(DebuggerIcons.ASSEMBLER_ICON);
        debuggerMenu.addSeparator();
        Emulicious.installToolsMenu(debuggerMenu);
        int n = debuggerMenu.getItemCount() - 1;
        while (n >= 0) {
            JMenuItem jMenuItem = debuggerMenu.getItem(n);
            if ("Debugger".equals(jMenuItem.getText())) {
                debuggerMenu.remove(n);
                break;
            }
            --n;
        }
        debuggerMenu.addSeparator();
        MenuItem menuItem = new MenuItem("Disassembler Settings...", 115);
        debuggerMenu.add(menuItem);
        menuItem.setAction(new AbstractAction(menuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = Boolean.parseBoolean(properties.getProperty("DisassemblerAllowCallsToUnknownRAM"));
                DisassemblerSettingsDialog disassemblerSettingsDialog = new DisassemblerSettingsDialog(Debugger.this.window);
                if (disassemblerSettingsDialog.getResult()) {
                    if (Boolean.parseBoolean(properties.getProperty("DisassemblerAllowCallsToUnknownRAM")) != bl) {
                        Debugger.this.updateDisassembly();
                    } else {
                        Debugger.this.updateDisassemblyLines();
                    }
                    Debugger.this.updateHighlighter();
                }
            }
        });
        debuggerMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                jCheckBoxMenuItem.setSelected(Boolean.parseBoolean(properties.getProperty("EnableAssembler")));
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return debuggerMenu;
    }

    private JMenu makeMenuHelp() {
        DebuggerMenu debuggerMenu = new DebuggerMenu("Help");
        debuggerMenu.setMnemonic('h');
        debuggerMenu.add(this.menuItemExpressionsHelp);
        this.menuItemExpressionsHelp.setAction(new AbstractAction(this.menuItemExpressionsHelp.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionsHelpDialog.open(Debugger.this.window, false);
            }
        });
        this.menuItemExpressionsHelp.setIcon(DebuggerIcons.EXPRESSIONS_HELP_ICON);
        return debuggerMenu;
    }

    private JToolBar makeToolBar(JMenuBar jMenuBar) {
        final JToolBar jToolBar = new JToolBar(){

            @Override
            public Color getBackground() {
                return this.shouldUseDarkMode() ? WINDOW_BACKGROUND_DARK_MODE : super.getBackground();
            }

            @Override
            public Color getForeground() {
                return this.shouldUseDarkMode() ? WINDOW_FOREGROUND_DARK_MODE : null;
            }

            private boolean shouldUseDarkMode() {
                return Debugger.this.table != null && super.getBackground() != null && Debugger.this.table.getBackground().getRed() < super.getBackground().getRed();
            }

            @Override
            protected void paintBorder(Graphics graphics) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintBorder(graphics);
            }
        };
        jToolBar.setOpaque(false);
        jToolBar.setFloatable(false);
        JButton jButton = new JButton();
        jButton.setFocusable(false);
        jButton.setOpaque(false);
        jButton.setBackground(null);
        jButton.setIcon(new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.GRAY);
                graphics2D.setStroke(new BasicStroke(5.0f));
                graphics2D.drawLine(n + 2, n2 + 2, n + 10, n2 + 10);
                graphics2D.drawLine(n + 10, n2 + 2, n + 2, n2 + 10);
                graphics2D.setColor(Color.WHITE);
                graphics2D.setStroke(new BasicStroke(4.0f));
                graphics2D.drawLine(n + 2, n2 + 2, n + 10, n2 + 10);
                graphics2D.drawLine(n + 10, n2 + 2, n + 2, n2 + 10);
            }

            @Override
            public int getIconWidth() {
                return 12;
            }

            @Override
            public int getIconHeight() {
                return 12;
            }
        });
        jButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jButton.setBorderPainted(false);
        jButton.setToolTipText("Hide Toolbar");
        jToolBar.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.window.remove(jToolBar);
                Debugger.this.window.validate();
                Debugger.this.window.repaint();
            }
        });
        int n = 0;
        while (n < jMenuBar.getMenuCount()) {
            JMenu jMenu = jMenuBar.getMenu(n);
            if (TOOLBAR_MENUS.contains(jMenu.getText())) {
                final JToolBar jToolBar2 = new JToolBar(jMenu.getText()){

                    @Override
                    public Color getBackground() {
                        return jToolBar.getBackground();
                    }

                    @Override
                    public Color getForeground() {
                        return jToolBar.getForeground();
                    }

                    @Override
                    protected void paintBorder(Graphics graphics) {
                        graphics.setColor(this.getBackground());
                        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                        super.paintBorder(graphics);
                    }
                };
                jToolBar2.setOpaque(false);
                jToolBar.add(jToolBar2);
                boolean bl = false;
                int n2 = 0;
                while (n2 < jMenu.getItemCount()) {
                    JMenuItem jMenuItem = jMenu.getItem(n2);
                    if (jMenuItem == null) {
                        bl = true;
                    } else if ((jMenuItem instanceof JCheckBoxMenuItem || jMenuItem.getAction() != null) && jMenuItem.getIcon() != null) {
                        if (bl) {
                            jToolBar2.addSeparator();
                        }
                        Icon icon = jMenuItem.getIcon();
                        AbstractButton abstractButton = jMenuItem instanceof JCheckBoxMenuItem ? new JToggleButton(){

                            @Override
                            public Color getForeground() {
                                Color color = jToolBar2.getForeground();
                                return color != null ? color : super.getForeground();
                            }
                        } : new JButton(){

                            @Override
                            public Color getForeground() {
                                Color color = jToolBar2.getForeground();
                                return color != null ? color : super.getForeground();
                            }
                        };
                        abstractButton.setModel(jMenuItem.getModel());
                        abstractButton.setOpaque(false);
                        abstractButton.setBackground(null);
                        abstractButton.setFocusable(false);
                        if (!(abstractButton instanceof JToggleButton)) {
                            abstractButton.setBorderPainted(false);
                        }
                        abstractButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                        if (icon != null) {
                            abstractButton.setIcon(icon);
                            abstractButton.setDisabledIcon(jMenuItem.getDisabledIcon());
                            abstractButton.setSelectedIcon(jMenuItem.getSelectedIcon());
                            abstractButton.setDisabledSelectedIcon(jMenuItem.getDisabledSelectedIcon());
                            abstractButton.setToolTipText(jMenuItem.getText());
                            abstractButton.setText(null);
                        } else {
                            abstractButton.setText(jMenuItem.getText());
                        }
                        jToolBar2.add(abstractButton);
                        this.TOOL_BAR_MENU_MAP.put(jMenuItem, abstractButton);
                        bl = false;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return jToolBar;
    }

    void updateToolBarButtons() {
        JMenuBar jMenuBar = this.getJMenuBar();
        int n = 0;
        while (n < jMenuBar.getMenuCount()) {
            JMenu jMenu = jMenuBar.getMenu(n);
            if (TOOLBAR_MENUS.contains(jMenu.getText())) {
                MenuListener[] menuListenerArray = jMenu.getMenuListeners();
                menuListenerArray[menuListenerArray.length - 1].menuSelected(null);
                int n2 = 0;
                while (n2 < jMenu.getItemCount()) {
                    JMenuItem jMenuItem = jMenu.getItem(n2);
                    if (jMenuItem != null && jMenuItem.getAction() != null && jMenuItem.getIcon() != null) {
                        AbstractButton abstractButton = this.TOOL_BAR_MENU_MAP.get(jMenuItem);
                        KeyStroke keyStroke = jMenuItem.getAccelerator();
                        String string = "";
                        if (keyStroke != null) {
                            int n3;
                            int n4 = keyStroke.getModifiers();
                            if (n4 > 0) {
                                string = String.valueOf(KeyEvent.getKeyModifiersText(n4)) + "+";
                            }
                            if (!(string = (n3 = keyStroke.getKeyCode()) != 0 ? String.valueOf(string) + KeyEvent.getKeyText(n3) : String.valueOf(string) + keyStroke.getKeyChar()).isEmpty()) {
                                string = "   " + string;
                            }
                        }
                        abstractButton.setToolTipText(String.valueOf(jMenuItem.getText()) + string);
                    }
                    ++n2;
                }
                if (!jMenu.isPopupMenuVisible()) {
                    menuListenerArray[menuListenerArray.length - 1].menuDeselected(null);
                }
            }
            ++n;
        }
    }

    int getDestination(int n) {
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n, 1);
        if (sourceLine.getInstruction() != null) {
            Z80Instruction z80Instruction = sourceLine.getInstruction();
            if (z80Instruction.isRet()) {
                return this.systemDebugger.mapToRomAddress(this.systemDebugger.getReturnAddress());
            }
            if (z80Instruction.getOpCode() == 233) {
                return this.systemDebugger.mapToRomAddress(this.systemDebugger.getRegisterValue(2));
            }
        }
        if (this.isRomRow(n)) {
            int n2 = Z80Disassembler.getDestination(sourceLine.getAddress(), this.systemDebugger.getRamRomMap());
            if (n2 < 0 && sourceLine.getInstruction() != null) {
                return this.systemDebugger.convertAddress(sourceLine.getInstruction().getDestination(sourceLine.getAddress(), sourceLine.getAddress() / 16384));
            }
            return n2;
        }
        if (sourceLine.getInstruction() != null) {
            return this.systemDebugger.mapToRomAddress(sourceLine.getInstruction().getDestination(sourceLine.getAddress(), sourceLine.getAddress() / 16384));
        }
        return -1;
    }

    boolean canOpenReferenceHierarchy() {
        if (this.table.getSelectedRow() >= 0) {
            Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(this.table.getSelectedRow(), 1);
            if (sourceLine.getAddress() >= 0) {
                return this.rowHasLabel(this.table.getSelectedRow()) || Debugger.getDataSize(sourceLine) == 2 || sourceLine.getInstruction() != null && (sourceLine.getInstruction().hasDestination() && (this.hasLabel(this.getDestination(this.table.getSelectedRow())) || this.systemDebugger.isRAMaddress(sourceLine.getInstruction().getArg())) || Z80Disassembler.getPortReferenceHierarchy(sourceLine, this.portNames) != null);
            }
            if (this.table.getSelectedRow() + 1 < this.table.getRowCount()) {
                Z80Disassembler.SourceLine sourceLine2 = (Z80Disassembler.SourceLine)this.table.getValueAt(this.table.getSelectedRow() + 1, 1);
                return sourceLine2.getInstruction() != null || this.rowHasLabel(this.table.getSelectedRow() + 1);
            }
        }
        return false;
    }

    boolean canSelectReferencedMemory() {
        return this.getMemoryAccessAddress(this.getCurrentInstruction()) >= 0;
    }

    void installRunActions(JComponent jComponent) {
        if (jComponent.getActionMap() == null || jComponent.getInputMap() == null) {
            return;
        }
        Component[] componentArray = this.menuRun.getMenuComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component != this.menuItemUndo && component != this.menuItemRedo && component instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)component;
                jComponent.getInputMap(1).put(menuItem.getAccelerator(), menuItem.getAccelerator());
                jComponent.getActionMap().put(menuItem.getAccelerator(), menuItem.getAction());
            }
            ++n2;
        }
    }

    public static void removeAction(KeyStroke keyStroke) {
        JRootPane jRootPane = Debugger.getRootPane();
        if (jRootPane != null && keyStroke != null) {
            InputMap inputMap = jRootPane.getInputMap(2);
            Object object = inputMap.get(keyStroke);
            jRootPane.getActionMap().remove(object);
            inputMap.remove(keyStroke);
        }
    }

    public static void addAction(String string, KeyStroke keyStroke, Action action) {
        JRootPane jRootPane = Debugger.getRootPane();
        if (jRootPane != null && string != null && keyStroke != null && action != null) {
            jRootPane.getInputMap(2).put(keyStroke, string);
            jRootPane.getActionMap().put(string, action);
        }
    }

    void openCPUaddressInMemoryEditor(int n, int n2) {
        MemoryEditor.openCPUaddress(this.window, Emulicious.memoryEditorModel, n, n2);
    }

    void openROMaddressInMemoryEditor(int n, int n2) {
        MemoryEditor.openROMaddress(this.window, Emulicious.memoryEditorModel, n, n2);
    }

    void openRAMaddressInMemoryEditor(int n, int n2) {
        String string = this.systemDebugger.getAdditionalMemoryLocationAt(n);
        if (string != null) {
            MemoryEditor.openAddressAdditionalMemory(this.window, Emulicious.memoryEditorModel, string, this.systemDebugger.mapAddress(n), this.systemDebugger.mapAddress(n2));
        } else {
            MemoryEditor.openRAMaddress(this.window, Emulicious.memoryEditorModel, this.systemDebugger.mapAddress(n), this.systemDebugger.mapAddress(n2));
        }
    }

    void openSRAMaddressInMemoryEditor(int n, int n2) {
        MemoryEditor.openSRAMaddress(this.window, Emulicious.memoryEditorModel, this.systemDebugger.mapAddress(n), this.systemDebugger.mapAddress(n2));
    }

    static int openBreakpointSelectionWindow() {
        if (debugger == null) {
            return -1;
        }
        return BreakpointSelectionWindow.open(Debugger.debugger.window, debugger);
    }

    private static void openBreakpointWindow() {
        Debugger.openBreakpointWindow(null);
    }

    private static void openBreakpointWindow(Breakpoint breakpoint) {
        Debugger.openBreakpointWindow(breakpoint, false);
    }

    private static void openBreakpointWindow(boolean bl) {
        Debugger.openBreakpointWindow(null, bl);
    }

    private static void openBreakpointWindow(Breakpoint breakpoint, boolean bl) {
        if (debugger != null) {
            BreakpointWindow.open(Debugger.debugger.window, debugger, breakpoint, bl);
            BreakpointWindow.registerBreakpointListener(Debugger.debugger.systemDebugger);
        }
    }

    Breakpoint getBreakpointAt(Point point) {
        int n;
        int n2 = point.y / this.table.getRowHeight();
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(n2, 1);
        int n3 = sourceLine.getAddress() < 0 ? this.getRamAddressAtRow(n2) : -1;
        int n4 = sourceLine.getAddress() < 0 && n3 < 0 ? this.getSRamAddressAtRow(n2) : -1;
        int n5 = n = sourceLine.getAddress() < 0 && n3 < 0 && n4 < 0 ? this.getPortAtRow(n2) : -1;
        if (sourceLine.getAddress() < 0 && n3 < 0 && n4 < 0 && n < 0) {
            return null;
        }
        if (sourceLine.getAddress() >= 0) {
            return this.getBreakpoint(n2);
        }
        if (n3 >= 0) {
            return this.getRAMbreakpoint(n3);
        }
        if (n4 >= 0) {
            return this.getSRAMbreakpoint(n4);
        }
        if (n >= 0) {
            return this.getPortBreakpoint(n);
        }
        return null;
    }

    void showBreakpointPopupMenu(Component component, Point point) {
        int n;
        JPopupMenu jPopupMenu = new JPopupMenu();
        final int n2 = point.y / this.table.getRowHeight();
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(n2, 1);
        String string = sourceLine.getAddress() < 0 || sourceLine.getInstruction() == null ? "Watchpoint" : "Breakpoint";
        int n3 = sourceLine.getAddress() < 0 ? this.getRamAddressAtRow(n2) : -1;
        int n4 = sourceLine.getAddress() < 0 && n3 < 0 ? this.getSRamAddressAtRow(n2) : -1;
        int n5 = n = sourceLine.getAddress() < 0 && n3 < 0 && n4 < 0 ? this.getPortAtRow(n2) : -1;
        if (sourceLine.getAddress() < 0 && n3 < 0 && n4 < 0 && n < 0) {
            return;
        }
        MenuItem menuItem = new MenuItem("Toggle " + string);
        jPopupMenu.add(menuItem);
        menuItem.setAction(new AbstractAction(menuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.toggleBreakpoint(n2);
            }
        });
        menuItem.setAccelerator(this.keySettings.getKeyStroke("ToggleBreakpoint"));
        final Breakpoint breakpoint = sourceLine.getAddress() >= 0 ? this.getBreakpoint(n2) : (n3 >= 0 ? this.getRAMbreakpoint(n3) : (n4 >= 0 ? this.getSRAMbreakpoint(n4) : (n >= 0 ? this.getPortBreakpoint(n) : null)));
        menuItem = new MenuItem(String.valueOf(breakpoint == null || breakpoint.isEnabled() ? "Disable " : "Enable ") + string);
        jPopupMenu.add(menuItem);
        menuItem.setAction(new AbstractAction(menuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (breakpoint == null) {
                    return;
                }
                Debugger.this.setBreakpointEnabled(breakpoint, !breakpoint.isEnabled());
            }
        });
        menuItem.setEnabled(breakpoint != null);
        menuItem = new MenuItem(String.valueOf(string) + " Properties...");
        jPopupMenu.add(menuItem);
        menuItem.setAction(new AbstractAction(menuItem.getText()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.openBreakpointWindow(breakpoint);
            }
        });
        menuItem.setEnabled(breakpoint != null);
        jPopupMenu.show(component, point.x, point.y);
    }

    void showPopupMenu(Component component, Point point) {
        final SystemDebugger systemDebugger = this.systemDebugger;
        final RamRomMap ramRomMap = systemDebugger.getRamRomMap();
        final JTable jTable = this.table;
        final int[] nArray = this.memory;
        final util.map.Map<String> map = this.portNames;
        final List<Z80Disassembler.SourceLine> list = this.lines;
        final File file = this.prfFile;
        JPopupMenu jPopupMenu = new JPopupMenu();
        final Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)jTable.getValueAt(jTable.getSelectedRow(), 1);
        final boolean bl = this.isRomRow(jTable.getSelectedRow());
        if (sourceLine.getAddress() >= 0) {
            MenuItem menuItem;
            if (sourceLine.getInstruction() == null) {
                if (bl && jTable.getSelectedRow() >= Z80Disassembler.findBeginningOfDisassembly(list)) {
                    menuItem = new MenuItem("Set Code");
                    jPopupMenu.add(menuItem);
                    menuItem.setAction(new AbstractAction(menuItem.getText()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = Debugger.this.getSelectedAddress();
                            int[] nArray2 = jTable.getSelectedRows();
                            Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)jTable.getValueAt(nArray2[nArray2.length - 1], 1);
                            int n2 = sourceLine.getAddress() + sourceLine.getSize();
                            boolean bl = false;
                            int n3 = n;
                            while (n3 < n2) {
                                if (!Z80Disassembler.isCode(n3) && Z80Disassembler.setCode(list, nArray, ramRomMap, n3, Debugger.this.getLoadedSymbols(), map, Debugger.this.sectionProvider)) {
                                    bl = true;
                                }
                                ++n3;
                            }
                            if (bl) {
                                Debugger.this.updateRows(list);
                                systemDebugger.requestGUIupdate();
                                systemDebugger.recreateInvalidBreakpoints();
                                Debugger.this.setSelectedAddress(n, false);
                                Debugger.this.window.repaint();
                            }
                        }
                    });
                    jPopupMenu.addSeparator();
                }
                if (bl) {
                    menuItem = new MenuItem("Plot Selected Data");
                    jPopupMenu.add(menuItem);
                    menuItem.setAction(new AbstractAction(menuItem.getText()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int[] nArray2 = jTable.getSelectedRows();
                            Z80Disassembler.SourceLine sourceLine2 = (Z80Disassembler.SourceLine)jTable.getValueAt(nArray2[nArray2.length - 1], 1);
                            PlotterWindow.open(Debugger.this.window, nArray, sourceLine.getAddress(), sourceLine2.getAddress() + sourceLine2.getSize() - 1, false);
                        }
                    });
                    jPopupMenu.addSeparator();
                }
                menuItem = new MenuItem("Toggle Watchpoint");
                menuItem.setEnabled(bl);
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = Debugger.this.getSelectedAddress();
                        if (Debugger.this.isWordSelected() && sourceLine.getInstruction() != null) {
                            if (sourceLine.getInstruction().getPrefix() > 0) {
                                ++n;
                                if (sourceLine.getInstruction().hasDisplacement()) {
                                    ++n;
                                }
                            }
                            ++n;
                        }
                        if (n >= 0) {
                            int[] nArray = jTable.getSelectedRows();
                            Z80Disassembler.SourceLine sourceLine2 = (Z80Disassembler.SourceLine)jTable.getValueAt(nArray[nArray.length - 1], 1);
                            int n2 = sourceLine2.getAddress() + (nArray.length > 1 ? sourceLine2.getSize() - 1 : 0);
                            if (n2 < n) {
                                n2 = n;
                            }
                            Debugger.this.toggleROMbreakpoint(n, n2 - n + 1);
                        }
                    }
                });
                menuItem.setAccelerator(this.keySettings.getKeyStroke("ToggleBreakpoint"));
                if (this.isWordSelected() && Debugger.getDataSize(sourceLine) == 2 && this.getSelectedAddress() >= 0) {
                    jPopupMenu.addSeparator();
                    final int n = this.getSelectedAddress();
                    final int n2 = this.READ_WORD(n);
                    menuItem = new MenuItem("Go To Destination");
                    jPopupMenu.add(menuItem);
                    menuItem.setAction(new AbstractAction(menuItem.getText()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Debugger.this.goToDestination(jTable.getSelectedRow());
                        }
                    });
                    menuItem.setAccelerator(this.keySettings.getKeyStroke("GoToDestination"));
                    if (this.isWordSelected() && (this.hasLabel(Z80Disassembler.getDestination(n, ramRomMap, n2)) || systemDebugger.isRAMaddress(n2))) {
                        menuItem = new MenuItem("Open Reference Hierarchy");
                        jPopupMenu.add(menuItem);
                        menuItem.setAction(new AbstractAction(menuItem.getText()){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (systemDebugger.isRAMaddress(n2)) {
                                    ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getRamReferenceHierarchy(systemDebugger.mapAddress(n2)), n);
                                } else if (systemDebugger.isSRAMaddress(n2)) {
                                    ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getSramReferenceHierarchy(n2, n), n);
                                } else {
                                    ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getReferenceHierarchy(Z80Disassembler.getDestination(n, ramRomMap, n2)), n);
                                }
                            }
                        });
                        menuItem.setAccelerator(this.keySettings.getKeyStroke("OpenReferenceHierarchy"));
                    }
                }
            } else {
                Object object;
                int n;
                int n3;
                String string;
                menuItem = new MenuItem("Toggle Breakpoint");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (bl) {
                            int n = Debugger.this.getSelectedAddress();
                            if (Debugger.this.isWordSelected() && sourceLine.getInstruction() != null) {
                                if (sourceLine.getInstruction().getPrefix() > 0) {
                                    ++n;
                                    if (sourceLine.getInstruction().hasDisplacement()) {
                                        ++n;
                                    }
                                }
                                ++n;
                            }
                            if (n >= 0) {
                                int[] nArray = jTable.getSelectedRows();
                                Z80Disassembler.SourceLine sourceLine2 = (Z80Disassembler.SourceLine)jTable.getValueAt(nArray[nArray.length - 1], 1);
                                int n2 = sourceLine2.getAddress() + (nArray.length > 1 ? sourceLine2.getSize() - 1 : 0);
                                if (n2 < n) {
                                    n2 = n;
                                }
                                Debugger.this.toggleROMbreakpoint(n, n2 - n + 1);
                            }
                        } else {
                            Debugger.this.toggleBreakpoint(jTable.getSelectedRow());
                        }
                    }
                });
                menuItem.setAccelerator(this.keySettings.getKeyStroke("ToggleBreakpoint"));
                final Breakpoint breakpoint = this.getBreakpoint(jTable.getSelectedRow());
                menuItem.setEnabled(this.canToggleBreakpoint(jTable.getSelectedRow()));
                menuItem = new MenuItem(String.valueOf(breakpoint == null || breakpoint.isEnabled() ? "Disable" : "Enable") + " Breakpoint");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (breakpoint == null) {
                            return;
                        }
                        Debugger.this.setBreakpointEnabled(breakpoint, !breakpoint.isEnabled());
                    }
                });
                menuItem.setEnabled(breakpoint != null);
                menuItem = new MenuItem("Breakpoint Properties...");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Debugger.openBreakpointWindow(breakpoint);
                    }
                });
                menuItem.setEnabled(breakpoint != null);
                jPopupMenu.addSeparator();
                if (sourceLine.getInstruction().hasArg()) {
                    string = this.isWordSelected() ? this.getSelectedWord() : null;
                    menuItem = new MenuItem(string != null ? "Toggle Watchpoint on \"" + string + "\"" : "Toggle Watchpoint");
                    if (systemDebugger.isRAMaddress(sourceLine.getInstruction().getArg())) {
                        jPopupMenu.add(menuItem);
                        menuItem.setAction(new AbstractAction(menuItem.getText()){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                Debugger.this.toggleRAMbreakpoint(systemDebugger.mapAddress(sourceLine.getInstruction().getArg()), 1);
                            }
                        });
                        jPopupMenu.addSeparator();
                    } else if (sourceLine.getInstruction().isPortAccess()) {
                        jPopupMenu.add(menuItem);
                        menuItem.setAction(new AbstractAction(menuItem.getText()){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                Debugger.this.togglePortBreakpoint(sourceLine.getInstruction().getArg());
                            }
                        });
                        jPopupMenu.addSeparator();
                    }
                }
                menuItem = new MenuItem("Run To Line");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        systemDebugger.runToAddress(sourceLine.getAddress(), bl);
                    }
                });
                menuItem.setAccelerator(this.keySettings.getKeyStroke("RunToLine"));
                menuItem = new MenuItem("Run Backwards To Line");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        systemDebugger.runBackToAddress(sourceLine.getAddress(), bl);
                    }
                });
                menuItem.setAccelerator(this.keySettings.getKeyStroke("RunBackwardsToLine"));
                menuItem = new MenuItem("Jump To Line");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (bl) {
                            systemDebugger.setAddress(sourceLine.getAddress(), Z80Disassembler.getSlot(sourceLine.getAddress() / 16384));
                        } else {
                            systemDebugger.setPC(sourceLine.getAddress());
                        }
                    }
                });
                menuItem.setAccelerator(this.keySettings.getKeyStroke("JumpToLine"));
                if (this.isWordSelected()) {
                    jPopupMenu.addSeparator();
                    string = this.getSelectedWord();
                    menuItem = new MenuItem("Watch \"" + string + "\"");
                    jPopupMenu.add(menuItem);
                    menuItem.setAction(new AbstractAction(menuItem.getText()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Debugger.this.expressionsTableModel.addRow(new Object[]{string, "1", "Hexadecimal", ""});
                            Debugger.this.selectExpressionsTab();
                        }
                    });
                }
                boolean bl2 = (n3 = this.getDestination(jTable.getSelectedRow())) >= 0;
                int n4 = n = bl2 ? n3 : systemDebugger.convertAddress(n3);
                if (n >= 0 || sourceLine.getInstruction().hasArg()) {
                    int n5;
                    boolean bl3 = this.isWordSelected();
                    if (bl2 && this.hasLabel(n) || !bl2 && (systemDebugger.isRAMaddress(n) || systemDebugger.isSRAMaddress(n)) || sourceLine.getInstruction().isPortAccess()) {
                        if (!this.isWordSelected()) {
                            jPopupMenu.addSeparator();
                        }
                        bl3 = true;
                        menuItem = new MenuItem("Go To Destination");
                        jPopupMenu.add(menuItem);
                        menuItem.setAction(new AbstractAction(menuItem.getText()){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                Debugger.this.goToDestination(jTable.getSelectedRow());
                            }
                        });
                        menuItem.setAccelerator(this.keySettings.getKeyStroke("GoToDestination"));
                    }
                    object = Z80Disassembler.getPortReferenceHierarchy(sourceLine, map);
                    if (this.isWordSelected() && (object != null || !bl2 && (systemDebugger.isSRAMaddress(n) || systemDebugger.isRAMaddress(n)) || bl2 && this.hasLabel(n))) {
                        if (!bl3) {
                            jPopupMenu.addSeparator();
                        }
                        menuItem = new MenuItem("Open Reference Hierarchy");
                        jPopupMenu.add(menuItem);
                        menuItem.setAction(new AbstractAction(menuItem.getText(), (Z80Disassembler.Reference)object, bl2, systemDebugger, n, sourceLine){
                            private final /* synthetic */ Z80Disassembler.Reference val$portReference;
                            private final /* synthetic */ boolean val$romDestination;
                            private final /* synthetic */ SystemDebugger val$systemDebugger;
                            private final /* synthetic */ int val$destination;
                            private final /* synthetic */ Z80Disassembler.SourceLine val$line;
                            {
                                this.val$portReference = reference;
                                this.val$romDestination = bl;
                                this.val$systemDebugger = systemDebugger;
                                this.val$destination = n;
                                this.val$line = sourceLine;
                                super(string);
                            }

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (this.val$portReference != null) {
                                    ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, this.val$portReference);
                                } else if (!this.val$romDestination && this.val$systemDebugger.isRAMaddress(this.val$destination)) {
                                    ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getRamReferenceHierarchy(this.val$line.getInstruction().getArgSize() == 2 ? this.val$systemDebugger.mapAddress(this.val$destination) : this.val$destination), this.val$line.getAddress());
                                } else if (!this.val$romDestination && this.val$systemDebugger.isSRAMaddress(this.val$destination)) {
                                    ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getSramReferenceHierarchy(this.val$destination, this.val$line.getAddress()), this.val$line.getAddress());
                                } else {
                                    ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getReferenceHierarchy(this.val$destination), this.val$line.getAddress());
                                }
                            }
                        });
                        menuItem.setAccelerator(this.keySettings.getKeyStroke("OpenReferenceHierarchy"));
                    }
                    if ((n5 = this.getMemoryAccessAddress(sourceLine)) >= 0) {
                        if (!bl3) {
                            jPopupMenu.addSeparator();
                        }
                        menuItem = new MenuItem("Select Referenced Memory");
                        jPopupMenu.add(menuItem);
                        menuItem.setAction(new AbstractAction(menuItem.getText()){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                Debugger.this.selectMemory(n5);
                            }
                        });
                    }
                }
                if (bl) {
                    jPopupMenu.addSeparator();
                    if (jTable.getSelectedRow() >= Z80Disassembler.findBeginningOfDisassembly(list)) {
                        menuItem = new MenuItem("Set Data");
                        jPopupMenu.add(menuItem);
                        menuItem.setAction(new AbstractAction(menuItem.getText()){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                int n = Debugger.this.getSelectedAddress();
                                int[] nArray2 = jTable.getSelectedRows();
                                Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)jTable.getValueAt(nArray2[nArray2.length - 1], 1);
                                int n2 = sourceLine.getAddress() + sourceLine.getSize();
                                boolean bl = false;
                                int n3 = n;
                                while (n3 < n2) {
                                    if (Z80Disassembler.isCode(n3) && Z80Disassembler.setData(list, nArray, ramRomMap, n3, Debugger.this.getLoadedSymbols())) {
                                        bl = true;
                                    }
                                    ++n3;
                                }
                                if (bl) {
                                    Debugger.this.updateRows(list);
                                    Debugger.this.setSelectedAddress(n, false);
                                    Debugger.this.window.repaint();
                                }
                            }
                        });
                        jPopupMenu.addSeparator();
                    }
                    menuItem = new MenuItem("Profile From Line");
                    jPopupMenu.add(menuItem);
                    menuItem.setAction(new AbstractAction(menuItem.getText()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Symbols.Symbol symbol = Symbols.findSymbol(Debugger.this.getSelectedAddress(), Debugger.this.getLoadedSymbols());
                            if (symbol != null) {
                                ProfilerWindow.addProfiler(Debugger.this.window, Debugger.this, file, symbol.getLabel());
                            } else {
                                ProfilerWindow.addProfiler(Debugger.this.window, Debugger.this, file, Integer.toHexString(Debugger.this.getSelectedAddress()));
                            }
                        }
                    });
                    menuItem.setAccelerator(this.keySettings.getKeyStroke("ProfileFromLine"));
                    menuItem = new MenuItem("Profile To Next Line");
                    jPopupMenu.add(menuItem);
                    menuItem.setAction(new AbstractAction(menuItem.getText()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = sourceLine.getAddress();
                            Symbols.Symbol symbol = Symbols.findSymbol(n, Debugger.this.getLoadedSymbols());
                            if (symbol != null) {
                                try {
                                    Debugger.this.parseExpression(symbol.getLabel());
                                }
                                catch (Exception exception) {
                                    symbol = null;
                                }
                            }
                            if (symbol != null) {
                                ProfilerWindow.addProfiler(Debugger.this.window, Debugger.this, file, symbol.getLabel(), Integer.toHexString(n + sourceLine.getSize()));
                            } else {
                                ProfilerWindow.addProfiler(Debugger.this.window, Debugger.this, file, Integer.toHexString(n), Integer.toHexString(n + sourceLine.getSize()));
                            }
                        }
                    });
                    menuItem.setAccelerator(this.keySettings.getKeyStroke("ProfileToNextLine"));
                    if (jTable.getSelectedRowCount() > 1) {
                        int[] nArray2 = jTable.getSelectedRows();
                        object = (Z80Disassembler.SourceLine)jTable.getValueAt(nArray2[0], 1);
                        Z80Disassembler.SourceLine sourceLine2 = (Z80Disassembler.SourceLine)jTable.getValueAt(nArray2[nArray2.length - 1], 1);
                        if (((Z80Disassembler.SourceLine)object).getInstruction() != null && sourceLine2.getInstruction() != null) {
                            menuItem = new MenuItem("Profile Selected Block");
                            menuItem.setAction(new AbstractAction(menuItem.getText(), (Z80Disassembler.SourceLine)object, file, sourceLine2){
                                private final /* synthetic */ Z80Disassembler.SourceLine val$firstLine;
                                private final /* synthetic */ File val$prfFile;
                                private final /* synthetic */ Z80Disassembler.SourceLine val$lastLine;
                                {
                                    this.val$firstLine = sourceLine;
                                    this.val$prfFile = file;
                                    this.val$lastLine = sourceLine2;
                                    super(string);
                                }

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    Symbols.Symbol symbol = Symbols.findSymbol(this.val$firstLine.getAddress(), Debugger.this.getLoadedSymbols());
                                    if (symbol != null) {
                                        try {
                                            Debugger.this.parseExpression(symbol.getLabel());
                                        }
                                        catch (Exception exception) {
                                            symbol = null;
                                        }
                                    }
                                    if (symbol != null) {
                                        ProfilerWindow.addProfiler(Debugger.this.window, Debugger.this, this.val$prfFile, symbol.getLabel(), Integer.toHexString(this.val$lastLine.getAddress() + this.val$lastLine.getSize()));
                                    } else {
                                        ProfilerWindow.addProfiler(Debugger.this.window, Debugger.this, this.val$prfFile, Integer.toHexString(this.val$firstLine.getAddress()), Integer.toHexString(this.val$lastLine.getAddress() + this.val$lastLine.getSize()));
                                    }
                                }
                            });
                            jPopupMenu.add(menuItem);
                        }
                    }
                    menuItem = new MenuItem("Trace From Line");
                    jPopupMenu.add(menuItem);
                    menuItem.setAction(new AbstractAction(menuItem.getText()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Symbols.Symbol symbol = Symbols.findSymbol(Debugger.this.getSelectedAddress(), Debugger.this.getLoadedSymbols());
                            if (symbol != null) {
                                TracerWindow.startTracing(Debugger.this.window, Debugger.this, systemDebugger, symbol.getLabel());
                            } else {
                                TracerWindow.startTracing(Debugger.this.window, Debugger.this, systemDebugger, "$" + Integer.toHexString(Debugger.this.getSelectedAddress()));
                            }
                        }
                    });
                    menuItem.setAccelerator(this.keySettings.getKeyStroke("TraceFromLine"));
                }
            }
            if (this.rowHasLabel(jTable.getSelectedRow()) && !this.isWordSelected()) {
                jPopupMenu.addSeparator();
                menuItem = new MenuItem("Open Reference Hierarchy");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (bl || systemDebugger.isROMaddress(sourceLine.getAddress())) {
                            ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getReferenceHierarchy(sourceLine.getAddress()));
                        } else if (systemDebugger.isRAMaddress(sourceLine.getAddress())) {
                            ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getRamReferenceHierarchy(systemDebugger.mapAddress(sourceLine.getAddress())));
                        } else if (systemDebugger.isSRAMaddress(sourceLine.getAddress())) {
                            ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getSramReferenceHierarchy(sourceLine.getAddress(), sourceLine.getAddress()));
                        }
                    }
                });
                menuItem.setAccelerator(this.keySettings.getKeyStroke("OpenReferenceHierarchy"));
            }
            jPopupMenu.addSeparator();
            menuItem = new MenuItem("Open in Memory Editor");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int n2 = n = bl ? Debugger.this.getSelectedAddress() : systemDebugger.convertAddress(Debugger.this.getSelectedAddress());
                    if (Debugger.this.isWordSelected() && sourceLine.getInstruction() != null) {
                        if (sourceLine.getInstruction().getPrefix() > 0) {
                            ++n;
                            if (sourceLine.getInstruction().hasDisplacement()) {
                                ++n;
                            }
                        }
                        ++n;
                    }
                    if (n >= 0) {
                        int[] nArray = jTable.getSelectedRows();
                        Z80Disassembler.SourceLine sourceLine2 = (Z80Disassembler.SourceLine)jTable.getValueAt(nArray[nArray.length - 1], 1);
                        int n3 = sourceLine2.getAddress() + (nArray.length > 1 ? sourceLine2.getSize() - 1 : 0);
                        if (n3 < n) {
                            n3 = n;
                        }
                        if (bl) {
                            Debugger.this.openROMaddressInMemoryEditor(n, n3);
                        } else {
                            Debugger.this.openCPUaddressInMemoryEditor(n, n3);
                        }
                    }
                }
            });
            menuItem.setAccelerator(this.keySettings.getKeyStroke("OpenInMemoryEditor"));
            jPopupMenu.show(component, point.x, point.y);
        } else if (jTable.getSelectedRow() + 1 < jTable.getRowCount()) {
            Object object;
            int n;
            Object object2;
            final int n6 = this.getRamAddressAtRow(jTable.getSelectedRow());
            final int n7 = this.getSRamAddressAtRow(jTable.getSelectedRow());
            if (n6 >= 0 || n7 >= 0) {
                MenuItem menuItem = new MenuItem("Toggle Watchpoint");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (n6 >= 0) {
                            Debugger.this.toggleRAMbreakpoint(n6, 1);
                        } else {
                            Debugger.this.toggleSRAMbreakpoint(n7, 1);
                        }
                    }
                });
                menuItem.setAccelerator(this.keySettings.getKeyStroke("ToggleBreakpoint"));
                object2 = n6 >= 0 ? this.getRAMbreakpoint(n6) : this.getSRAMbreakpoint(n7);
                menuItem = new MenuItem(String.valueOf(object2 == null || ((Breakpoint)object2).isEnabled() ? "Disable" : "Enable") + " Watchpoint");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText(), (Breakpoint)object2){
                    private final /* synthetic */ Breakpoint val$breakpoint;
                    {
                        this.val$breakpoint = breakpoint;
                        super(string);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.val$breakpoint == null) {
                            return;
                        }
                        Debugger.this.setBreakpointEnabled(this.val$breakpoint, !this.val$breakpoint.isEnabled());
                    }
                });
                menuItem.setEnabled(object2 != null);
                menuItem = new MenuItem("Watchpoint Properties...");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText(), (Breakpoint)object2){
                    private final /* synthetic */ Breakpoint val$breakpoint;
                    {
                        this.val$breakpoint = breakpoint;
                        super(string);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Debugger.openBreakpointWindow(this.val$breakpoint);
                    }
                });
                menuItem.setEnabled(object2 != null);
                jPopupMenu.addSeparator();
                menuItem = new MenuItem("Open Reference Hierarchy");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (n6 >= 0) {
                            ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getRamReferenceHierarchy(n6));
                        } else {
                            ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getSramReferenceHierarchy(n7, 0));
                        }
                    }
                });
                menuItem.setAccelerator(this.keySettings.getKeyStroke("OpenReferenceHierarchy"));
                jPopupMenu.addSeparator();
                menuItem = new MenuItem("Open in Memory Editor");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = Debugger.this.getSelectedRamAddress();
                        if (n >= 0) {
                            int[] nArray = jTable.getSelectedRows();
                            int n2 = Debugger.this.getRamAddressAtRow(nArray[nArray.length - 1]);
                            if (n2 < n) {
                                n2 = n;
                            }
                            Debugger.this.openRAMaddressInMemoryEditor(n, n2);
                        } else {
                            n = Debugger.this.getSelectedSRamAddress();
                            int[] nArray = jTable.getSelectedRows();
                            int n3 = Debugger.this.getSRamAddressAtRow(nArray[nArray.length - 1]);
                            if (n3 < n) {
                                n3 = n;
                            }
                            Debugger.this.openSRAMaddressInMemoryEditor(n, n3);
                        }
                    }
                });
                menuItem.setAccelerator(this.keySettings.getKeyStroke("OpenInMemoryEditor"));
                if (n6 >= 0) {
                    menuItem = new MenuItem("Watch");
                    jPopupMenu.add(menuItem);
                    menuItem.setAction(new AbstractAction(menuItem.getText()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            RAMWatchWindow.open(Debugger.this.window, Debugger.this, Debugger.this.asExpression(0xC000 | n6).wrapInRead(), false);
                        }
                    });
                    menuItem.setAccelerator(this.keySettings.getKeyStroke("Watch"));
                }
                jPopupMenu.show(component, point.x, point.y);
            }
            if ((n = this.getPortAtRow(jTable.getSelectedRow())) >= 0) {
                object2 = new MenuItem("Toggle Watchpoint");
                jPopupMenu.add((JMenuItem)object2);
                ((MenuItem)object2).setAction(new AbstractAction(((AbstractButton)object2).getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Debugger.this.togglePortBreakpoint(n);
                    }
                });
                ((JMenuItem)object2).setAccelerator(this.keySettings.getKeyStroke("ToggleBreakpoint"));
                object = this.getPortBreakpoint(n);
                object2 = new MenuItem(String.valueOf(object == null || ((Breakpoint)object).isEnabled() ? "Disable" : "Enable") + " Watchpoint");
                jPopupMenu.add((JMenuItem)object2);
                ((MenuItem)object2).setAction(new AbstractAction(((AbstractButton)object2).getText(), (Breakpoint)object){
                    private final /* synthetic */ Breakpoint val$breakpoint;
                    {
                        this.val$breakpoint = breakpoint;
                        super(string);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.val$breakpoint == null) {
                            return;
                        }
                        Debugger.this.setBreakpointEnabled(this.val$breakpoint, !this.val$breakpoint.isEnabled());
                    }
                });
                ((JMenuItem)object2).setEnabled(object != null);
                object2 = new MenuItem("Watchpoint Properties...");
                jPopupMenu.add((JMenuItem)object2);
                ((MenuItem)object2).setAction(new AbstractAction(((AbstractButton)object2).getText(), (Breakpoint)object){
                    private final /* synthetic */ Breakpoint val$breakpoint;
                    {
                        this.val$breakpoint = breakpoint;
                        super(string);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Debugger.openBreakpointWindow(this.val$breakpoint);
                    }
                });
                ((JMenuItem)object2).setEnabled(object != null);
                jPopupMenu.addSeparator();
                object2 = new MenuItem("Open Reference Hierarchy");
                jPopupMenu.add((JMenuItem)object2);
                ((MenuItem)object2).setAction(new AbstractAction(((AbstractButton)object2).getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = Debugger.this.isInputPortAtRow(jTable.getSelectedRow());
                        boolean bl2 = map.get(n) == map.get(-n);
                        ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getPortReferenceHierarchy(n, bl || bl2, !bl || bl2));
                    }
                });
                ((JMenuItem)object2).setAccelerator(this.keySettings.getKeyStroke("OpenReferenceHierarchy"));
                jPopupMenu.show(component, point.x, point.y);
            }
            if (this.rowHasLabel(jTable.getSelectedRow() + 1)) {
                object2 = (Z80Disassembler.SourceLine)jTable.getValueAt(jTable.getSelectedRow() + 1, 1);
                object = new MenuItem("Open Reference Hierarchy");
                jPopupMenu.add((JMenuItem)object);
                ((MenuItem)object).setAction(new AbstractAction(((AbstractButton)object).getText(), (Z80Disassembler.SourceLine)object2){
                    private final /* synthetic */ Z80Disassembler.SourceLine val$followingLine;
                    {
                        this.val$followingLine = sourceLine;
                        super(string);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (bl || systemDebugger.isROMaddress(this.val$followingLine.getAddress())) {
                            ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getReferenceHierarchy(this.val$followingLine.getAddress()));
                        } else if (systemDebugger.isRAMaddress(this.val$followingLine.getAddress())) {
                            ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getRamReferenceHierarchy(systemDebugger.mapAddress(this.val$followingLine.getAddress())));
                        } else if (systemDebugger.isSRAMaddress(this.val$followingLine.getAddress())) {
                            ReferenceHierarchyWindow.open(Debugger.this.window, Debugger.this, Z80Disassembler.getSramReferenceHierarchy(this.val$followingLine.getAddress(), this.val$followingLine.getAddress()));
                        }
                    }
                });
                ((JMenuItem)object).setAccelerator(this.keySettings.getKeyStroke("OpenReferenceHierarchy"));
                jPopupMenu.show(component, point.x, point.y);
            }
        }
    }

    private void showExpressionsPopupMenu(Point point) {
        try {
            MenuItem menuItem;
            int n = this.expressions.rowAtPoint(point);
            if (!this.expressions.isRowSelected(n)) {
                this.expressions.getSelectionModel().setSelectionInterval(n, n);
            }
            final Expression expression = (Expression)this.expressions.getValueAt(this.expressions.getSelectedRow(), 0);
            final int n2 = expression.getValue();
            final int n3 = Integer.parseInt((String)this.expressions.getValueAt(this.expressions.getSelectedRow(), 1));
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (n3 > 0 && this.expressions.getSelectedRowCount() == 1) {
                menuItem = new MenuItem("Toggle Watchpoint");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Debugger.this.toggleMemoryLocationBreakpoint("CPU", n2, n3);
                    }
                });
                if (this.systemDebugger.isRAMaddress(n2)) {
                    menuItem = new MenuItem("Open in Memory Editor");
                    jPopupMenu.add(menuItem);
                    menuItem.setAction(new AbstractAction(menuItem.getText()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Debugger.this.openRAMaddressInMemoryEditor(n2, n2);
                        }
                    });
                    menuItem = new MenuItem("Watch");
                    jPopupMenu.add(menuItem);
                    menuItem.setAction(new AbstractAction(menuItem.getText()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            RAMWatchWindow.open(Debugger.this.window, Debugger.this, expression.wrapInRead(), false);
                        }
                    });
                }
            }
            menuItem = new MenuItem("Remove");
            jPopupMenu.add(menuItem);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCellEditor tableCellEditor = Debugger.this.expressions.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.cancelCellEditing();
                    }
                    int[] nArray = Debugger.this.expressions.getSelectedRows();
                    int n = nArray.length - 1;
                    while (n >= 0) {
                        if (nArray[n] < Debugger.this.expressions.getRowCount() - 1) {
                            Debugger.this.expressionsTableModel.removeRow(nArray[n]);
                        }
                        --n;
                    }
                }
            });
            jPopupMenu.show(this.expressions, point.x, point.y);
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - void declaration
     */
    private boolean loadExpressions(File file) {
        this.expressionsTableModel.setRowCount(0);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            void var4_6;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String objectArray2 = bufferedReader.readLine();
            while (var4_6 != null) {
                try {
                    String[] stringArray = var4_6.split(" ");
                    if (stringArray.length >= 3) {
                        String[] stringArray2 = stringArray;
                        stringArray = new String[4];
                        stringArray[0] = stringArray2[0].replace("%20", " ").replace("%3d", "=");
                        int n = 1;
                        while (n < 3) {
                            stringArray[n] = stringArray2[n];
                            ++n;
                        }
                        stringArray[3] = "";
                        arrayList.add(stringArray);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string = bufferedReader.readLine();
            }
            bufferedReader.close();
            for (Object[] objectArray : arrayList) {
                this.expressionsTableModel.addRow(objectArray);
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private void saveExpressions(File file) {
        if (this.expressions == null) {
            return;
        }
        if (this.expressions.getRowCount() > 1) {
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                int n = 0;
                while (n < this.expressions.getRowCount() - 1) {
                    printWriter.print(this.expressions.getValueAt(n, 0).toString().replace(" ", "%20").replace("=", "%3d"));
                    int n2 = 1;
                    while (n2 < this.expressions.getColumnCount() - 1) {
                        printWriter.print(" " + this.expressions.getValueAt(n, n2));
                        ++n2;
                    }
                    printWriter.println();
                    ++n;
                }
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            file.delete();
        }
    }

    private void importSymbolExpressions() {
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = 0;
        while (n < this.expressions.getRowCount()) {
            hashSet.add(this.expressions.getValueAt(n, 0));
            ++n;
        }
        for (Symbols.Symbol symbol : this.ramSymbols) {
            if (hashSet.contains(symbol.getLabel())) continue;
            this.expressionsTableModel.addRow(new Object[]{symbol.getLabel(), "1", "Hexadecimal", ""});
        }
        if (Boolean.parseBoolean(this.properties.getProperty("AutoInferExpressionSizes"))) {
            this.inferExpressionSizes();
        }
    }

    private void inferExpressionSizes() {
        Object object;
        java.util.HashMap<String, Integer> hashMap = new java.util.HashMap<String, Integer>();
        int n = 0;
        while (n < this.ramSymbols.size()) {
            object = this.ramSymbols.get(n);
            Symbols.Symbol symbol = null;
            if (n + 1 < this.ramSymbols.size()) {
                symbol = this.ramSymbols.get(n + 1);
            }
            if (symbol != null && symbol.getAddress() - ((Symbols.Symbol)object).getAddress() < this.systemDebugger.getRAMlength()) {
                hashMap.put(((Symbols.Symbol)object).getLabel(), Math.max(1, symbol.getAddress() - ((Symbols.Symbol)object).getAddress()));
            }
            ++n;
        }
        n = 0;
        while (n < this.expressions.getRowCount()) {
            object = (Integer)hashMap.get(this.expressions.getValueAt(n, 0).toString());
            if (object != null) {
                if ((Integer)object > 4) {
                    this.expressions.setValueAt("Array", n, 2);
                }
                this.expressions.setValueAt(((Integer)object).toString(), n, 1);
            }
            ++n;
        }
    }

    Z80Disassembler.SourceLine getSelectedLine() {
        if (this.table.getSelectedRow() < 0) {
            return null;
        }
        return (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(this.table.getSelectedRow(), 1);
    }

    int getSelectedAddress() {
        if (this.table.getSelectedRow() < 0) {
            return -1;
        }
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(this.table.getSelectedRow(), 1);
        if (sourceLine == null) {
            return -1;
        }
        if (this.isWordSelected() && sourceLine.getInstruction() == null) {
            int n = this.selectedWordStart;
            String string = sourceLine.toString().trim().replace('\t', ' ');
            if (n >= string.length()) {
                this.selectedWordStart = -1;
                this.selectedWordEnd = -1;
            } else {
                int n2 = Debugger.getDataSize(sourceLine);
                string = string.substring(0, n);
                int n3 = string.length() - string.replace(" ", "").length() - 1;
                int n4 = sourceLine.getAddress() + n3 * n2;
                return this.isRomRow(this.table.getSelectedRow()) ? n4 : this.systemDebugger.convertAddress(n4);
            }
        }
        return this.isRomRow(this.table.getSelectedRow()) ? sourceLine.getAddress() : this.systemDebugger.convertAddress(sourceLine.getAddress());
    }

    String getSelectedWord() {
        if (this.table.getSelectedRow() < 0 || !this.isWordSelected()) {
            return null;
        }
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(this.table.getSelectedRow(), 1);
        if (sourceLine == null) {
            return null;
        }
        String string = sourceLine.toString().replace("\t", "    ");
        return string.substring(this.selectedWordStart, this.selectedWordEnd);
    }

    static int getDataSize(Z80Disassembler.SourceLine sourceLine) {
        if (sourceLine == null) {
            return 0;
        }
        String string = sourceLine.toString().trim().replace('\t', ' ');
        int n = string.length() - string.replace(" ", "").length();
        if (n == 0) {
            return 0;
        }
        return sourceLine.getSize() / n;
    }

    void setSelectedRow(int n) {
        if (n >= 0 && n < this.table.getRowCount()) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
            Rectangle rectangle = this.table.getCellRect(n, 1, true);
            Rectangle rectangle2 = this.table.getVisibleRect();
            rectangle.width = rectangle2.width;
            rectangle.x = rectangle2.x;
            rectangle.height = rectangle2.height / 2;
            rectangle.y -= rectangle.height / 2;
            this.table.scrollRectToVisible(rectangle);
        }
    }

    void setSelectedAddress(String string) {
        this.setSelectedAddress(string, true);
    }

    private void setSelectedAddress(String string, boolean bl) {
        int n = this.getLabelAddress(string);
        this.setSelectedAddress(this.systemDebugger.mapAddress(n & this.systemDebugger.getMemoryLength() - 1, n / this.systemDebugger.getMemoryLength()), bl);
    }

    void setSelectedAddress(int n) {
        this.setSelectedAddress(n, true);
    }

    void setSelectedAddress(int n, boolean bl) {
        this.setSelectedAddress(n, bl, true);
    }

    void goTo(int n, int n2) {
        this.setSelectedAddress(n2 >= 0 ? this.systemDebugger.mapAddress(n, n2, true) : n, false);
    }

    void goToDestination(int n) {
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n, 1);
        if (sourceLine.getInstruction() != null) {
            int n2 = this.getDestination(n);
            if (n2 >= 0 || this.systemDebugger.convertAddress(n2) >= 0) {
                this.setSelectedAddress(n2);
            } else if (sourceLine.getInstruction().hasArg()) {
                if (this.systemDebugger.isRAMaddress(sourceLine.getInstruction().getArg())) {
                    this.setSelectedRAMaddress(this.systemDebugger.mapAddress(sourceLine.getInstruction().getArg()));
                } else if (this.systemDebugger.isSRAMaddress(sourceLine.getInstruction().getArg())) {
                    this.setSelectedSRAMaddress(this.systemDebugger.mapAddress(sourceLine.getInstruction().getArg()));
                } else {
                    this.setSelectedPort(sourceLine.getInstruction().getArg() & 0xFF);
                }
            }
        } else if (Debugger.getDataSize(sourceLine) == 2 && this.getSelectedAddress() >= 0) {
            int n3;
            RamRomMap ramRomMap = this.systemDebugger.getRamRomMap();
            int n4 = this.getSelectedAddress();
            if (this.hasLabel(Z80Disassembler.getDestination(n4, ramRomMap, n3 = this.READ_WORD(n4)))) {
                this.setSelectedAddress(Z80Disassembler.getDestination(n4, ramRomMap, n3));
            } else if (this.systemDebugger.isRAMaddress(n3)) {
                this.setSelectedRAMaddress(this.systemDebugger.mapAddress(n3));
            } else if (this.systemDebugger.isSRAMaddress(n3)) {
                this.setSelectedSRAMaddress(this.systemDebugger.mapAddress(n3));
            }
        }
    }

    void setSelectedAddress(int n, boolean bl, boolean bl2) {
        boolean bl3;
        if (!SwingUtilities.isEventDispatchThread()) {
            bl2 = false;
        }
        boolean bl4 = bl3 = n >= 0;
        if (!bl3) {
            n = this.systemDebugger.convertAddress(n);
        }
        if (!(n < 0 || bl3 && n >= this.tableRows.length)) {
            int n2;
            int n3 = n2 = bl3 ? this.tableRows[n] : this.getCpuRow(n);
            if (bl) {
                this.createNavigationAnchor();
            }
            this.table.getSelectionModel().setSelectionInterval(n2, n2);
            this.selectedWordStart = -1;
            this.selectedWordEnd = -1;
            Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(n2, 1);
            if (sourceLine != null) {
                if (sourceLine.getInstruction() != null) {
                    int n4 = 1;
                    if (sourceLine.getInstruction().getPrefix() > 0) {
                        ++n4;
                        if (sourceLine.getInstruction().hasDisplacement()) {
                            ++n4;
                        }
                    }
                    if (n - sourceLine.getAddress() >= n4) {
                        String string = sourceLine.toString().replace("\t", "    ");
                        int n5 = Math.min(string.indexOf(44) & 0xFFFF, string.indexOf(" (") & 0xFFFF);
                        while (n5 < string.length() && "()[], +-<>".indexOf(string.charAt(n5)) >= 0) {
                            ++n5;
                        }
                        int n6 = n5;
                        while (n6 < string.length() && "()[], +-<>".indexOf(string.charAt(n6)) < 0) {
                            ++n6;
                        }
                        if (n6 - n5 >= 3 && '.' != string.charAt(n5)) {
                            this.selectedWordStart = n5;
                            this.selectedWordEnd = n6;
                            if (this.selectedWordStart < 0) {
                                throw new IllegalStateException();
                            }
                        }
                    }
                } else {
                    String string = sourceLine.toString().replace('\t', ' ');
                    String string2 = string.trim();
                    if (string2.isEmpty()) {
                        return;
                    }
                    int n7 = string.indexOf(string2.charAt(0));
                    int n8 = Debugger.getDataSize(sourceLine);
                    int n9 = string2.indexOf(32) + 1;
                    if (n8 <= 4) {
                        int n10;
                        if (n8 > 0) {
                            n10 = (n - sourceLine.getAddress()) / n8;
                            while (n10 > 0 && n9 >= 0) {
                                n9 = string2.indexOf(32, n9) + 1;
                                --n10;
                            }
                        }
                        n10 = n9;
                        while (n10 < string2.length() && "()[], -".indexOf(string2.charAt(n10)) < 0) {
                            ++n10;
                        }
                        if (n10 - n9 >= 3 && '.' != string.charAt(n9)) {
                            this.selectedWordStart = n9 + n7;
                            this.selectedWordEnd = n10 + n7;
                            if (this.selectedWordStart < 0) {
                                throw new IllegalStateException();
                            }
                        }
                    }
                }
                this.repaintRow(n2);
            }
            if (bl2) {
                this.scrollRowToVisible(n2);
            }
        }
    }

    void setSelectedRAMaddress(int n) {
        int n2 = this.getRamRows().get(n);
        if (n2 == Integer.MIN_VALUE) {
            return;
        }
        this.createNavigationAnchor();
        this.table.getSelectionModel().setSelectionInterval(n2, n2);
        this.repaintRow(n2);
        this.scrollRowToVisible(n2);
    }

    void setSelectedSRAMaddress(int n) {
        int n2 = this.getSramRows().get(n);
        if (n2 == Integer.MIN_VALUE) {
            return;
        }
        this.createNavigationAnchor();
        this.table.getSelectionModel().setSelectionInterval(n2, n2);
        this.repaintRow(n2);
        this.scrollRowToVisible(n2);
    }

    void setSelectedPort(int n) {
        int n2 = this.getPortRows().get(n);
        if (n2 == Integer.MIN_VALUE) {
            return;
        }
        this.createNavigationAnchor();
        this.table.getSelectionModel().setSelectionInterval(n2, n2);
        this.repaintRow(n2);
        this.scrollRowToVisible(n2);
    }

    void setSelectedStackAddress(int n) {
        int n2 = this.stack.getModel().getSize() - (n - this.systemDebugger.getStackStart() - (this.systemDebugger.getStackPointer() & 1)) / 2;
        this.stack.setSelectedIndex(n2);
        Rectangle rectangle = this.stack.getCellBounds(n2, n2);
        if (rectangle != null) {
            this.stack.scrollRectToVisible(rectangle);
        }
    }

    void setSelection(Breakpoint breakpoint) {
        if (breakpoint != null && this.systemDebugger.getAdditionalMemoryLocationAt(breakpoint.getAddress()) == null) {
            if (this.isCpuBreakpoint(breakpoint)) {
                if (this.systemDebugger.getAdditionalMemoryLocationAt(breakpoint.getAddress()) == null) {
                    if (this.systemDebugger.isROMaddress(breakpoint.getAddress())) {
                        this.setSelectedAddress(this.systemDebugger.mapAddress(breakpoint.getAddress()));
                    } else if (this.systemDebugger.isRAMaddress(breakpoint.getAddress())) {
                        this.setSelectedRAMaddress(this.systemDebugger.mapAddress(breakpoint.getAddress()));
                    } else if (this.systemDebugger.isSRAMaddress(breakpoint.getAddress())) {
                        this.setSelectedSRAMaddress(this.systemDebugger.mapAddress(breakpoint.getAddress()));
                    }
                }
            } else if (this.isROMbreakpoint(breakpoint)) {
                this.setSelectedAddress(breakpoint.getAddress());
            } else if (this.isRAMbreakpoint(breakpoint)) {
                this.setSelectedRAMaddress(breakpoint.getAddress());
            } else if (this.isSRAMbreakpoint(breakpoint)) {
                this.setSelectedSRAMaddress(breakpoint.getAddress());
            } else if (this.isPortBreakpoint(breakpoint)) {
                this.setSelectedPort(breakpoint.getAddress());
            }
        }
    }

    void resume() {
        this.systemDebugger.resume();
    }

    void suspend() {
        this.systemDebugger.suspend();
    }

    String linesToString() {
        int n = 0;
        while (n < 900 && (this.updatingDisassembly || this.lines == DISASSEMBLING)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            ++n;
        }
        while (n < 1000) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                for (Z80Disassembler.SourceLine sourceLine : this.lines) {
                    stringBuilder.append(sourceLine).append('\n');
                }
                return stringBuilder.toString();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                ++n;
            }
        }
        throw new IllegalStateException("Disassembler timed out. Check if Emulicious crashed. If it did, please report.");
    }

    boolean isExecutingInterrupt() {
        return this.systemDebugger.isExecutingInterrupt();
    }

    boolean isROMbreakpoint(Breakpoint breakpoint) {
        return this.systemDebugger.isROMbreakpoint(breakpoint);
    }

    boolean isRAMbreakpoint(Breakpoint breakpoint) {
        return this.systemDebugger.isRAMbreakpoint(breakpoint);
    }

    boolean isVRAMbreakpoint(Breakpoint breakpoint) {
        return this.systemDebugger.isVRAMbreakpoint(breakpoint);
    }

    boolean isSRAMbreakpoint(Breakpoint breakpoint) {
        return this.systemDebugger.isSRAMbreakpoint(breakpoint);
    }

    boolean isCpuBreakpoint(Breakpoint breakpoint) {
        return this.systemDebugger.isCpuBreakpoint(breakpoint);
    }

    boolean isPortBreakpoint(Breakpoint breakpoint) {
        return this.systemDebugger.isPortBreakpoint(breakpoint);
    }

    boolean isMemoryLocationBreakpoint(Breakpoint breakpoint) {
        return this.systemDebugger.isMemoryLocationBreakpoint(breakpoint);
    }

    int mapLineNumberToRow(File file, int n) {
        if (file == null) {
            return n;
        }
        SourceMap sourceMap = Z80Disassembler.getSourceMap();
        if (sourceMap == null) {
            return -1;
        }
        int n2 = sourceMap.getAddressROM(file, n);
        if (n2 < 0 || n2 >= this.tableRows.length) {
            return -1;
        }
        return this.tableRows[n2];
    }

    String addBreakpoint(File file, int n) {
        return this.addBreakpoint(file, n, null, null, true);
    }

    String addBreakpoint(File file, int n, String string, String string2, boolean bl) {
        if (this.evscriptDebugInfo != null) {
            for (EvscriptDebugInfo.DebugLine debugLine : this.evscriptDebugInfo.getDebugLines()) {
                if (n != debugLine.getLineNumber() - 1 || !file.getName().equals(new File(debugLine.getFilename()).getName())) continue;
                string = String.valueOf(string != null ? "(" + string + ") && " : "") + "hl = " + this.symbols.get(debugLine.getLabel()).get(0).getAddress();
                break;
            }
        }
        return this.addBreakpoint(this.mapLineNumberToRow(file, n), string, string2, bl);
    }

    private String addBreakpoint(int n, String string, String string2, boolean bl) {
        if (n < 0 || n >= this.lines.size()) {
            return "The selected line does not appear to map to any bytes of the program being debugged.\nMake sure that your debug symbols are up-to-date.";
        }
        Breakpoint breakpoint = this.addBreakpoint(n);
        if (breakpoint == null) {
            return "Failed to add a breakpoint on this line.";
        }
        if (breakpoint instanceof InvalidBreakpoint) {
            return "Failed to add a breakpoint on this line:\n" + ((InvalidBreakpoint)breakpoint).getCause().getMessage();
        }
        breakpoint.setSuspend(bl);
        breakpoint.setCondition(string);
        breakpoint.setMessage(string2);
        return null;
    }

    Breakpoint addBreakpoint(String string, String string2) {
        return this.addBreakpoint(-1, string, string2);
    }

    Breakpoint addBreakpoint(int n, String string, String string2) {
        Breakpoint breakpoint;
        Symbols.Symbol symbol;
        List<Symbols.Symbol> list = this.symbols.get(string.trim());
        Symbols.Symbol symbol2 = symbol = list != null ? list.get(0) : null;
        if (symbol != null) {
            breakpoint = symbol.getBank() < 0 || this.systemDebugger.isROMaddress(symbol.getAddress()) ? this.systemDebugger.addROMbreakpoint(n, string, string2) : this.systemDebugger.addWatchpoint(n, string, string2);
        } else {
            try {
                Expression expression = new Expression(this.systemDebugger, string);
                if (string.contains(":")) {
                    return this.systemDebugger.addWatchpoint(this.systemDebugger.indexOfBreakpointLocationAt(expression.getValue() & 0xFFFF), n, string, string2, null, null, true, true);
                }
                int n2 = -1;
                for (String string3 : expression.getVariableNames()) {
                    for (Map.Entry<String> entry : this.portNames.entrySet()) {
                        if (!string3.equals(entry.getValue())) continue;
                        n2 = Math.abs(entry.getKey());
                        break;
                    }
                    if (n2 >= 0) break;
                }
                if ((breakpoint = n2 >= 0 ? this.systemDebugger.addPortBreakpoint(n, n2, 1) : this.systemDebugger.addROMbreakpoint(n, string, string2)) instanceof InvalidBreakpoint) {
                    this.systemDebugger.removeBreakpoint(breakpoint, true);
                    breakpoint = this.systemDebugger.addWatchpoint(n, string, string2);
                }
            }
            catch (Exception exception) {
                breakpoint = this.systemDebugger.addWatchpoint(n, string, string2);
            }
        }
        return breakpoint;
    }

    int removeBreakpoint(Breakpoint breakpoint) {
        return this.systemDebugger.removeBreakpoint(breakpoint, false);
    }

    Breakpoint setBreakpointAddress(Breakpoint breakpoint, String string, String string2) {
        return this.systemDebugger.setBreakpointAddress(breakpoint, string, string2);
    }

    void setBreakpointEnabled(Breakpoint breakpoint, boolean bl) {
        this.systemDebugger.setBreakpointEnabled(breakpoint, bl);
    }

    void setBreakpointSuspend(Breakpoint breakpoint, boolean bl) {
        this.systemDebugger.setBreakpointSuspend(breakpoint, bl);
    }

    void setBreakpointCondition(Breakpoint breakpoint, String string) throws ParseException, UnknownVariableException, IsConstantException {
        this.systemDebugger.setBreakpointCondition(breakpoint, string);
    }

    void setBreakpointMessage(Breakpoint breakpoint, String string) throws ParseException, UnknownVariableException {
        this.systemDebugger.setBreakpointMessage(breakpoint, string);
    }

    void setWatchpointRead(Watchpoint watchpoint, boolean bl) {
        this.systemDebugger.setWatchpointRead(watchpoint, bl);
    }

    void setWatchpointWrite(Watchpoint watchpoint, boolean bl) {
        this.systemDebugger.setWatchpointWrite(watchpoint, bl);
    }

    Breakpoint addBreakpoint(int n) {
        Z80Disassembler.SourceLine sourceLine;
        if (n < 0 || n >= this.lines.size()) {
            return null;
        }
        Z80Disassembler.SourceLine sourceLine2 = this.lines.get(n);
        if (sourceLine2 != null && sourceLine2.getAddress() >= 0) {
            if (sourceLine2.getInstruction() == null) {
                int n2 = this.getSelectedAddress();
                if (this.isWordSelected() && n2 >= sourceLine2.getAddress() && n2 < sourceLine2.getAddress() + sourceLine2.getSize()) {
                    return this.addROMbreakpoint(n2, n2 + Debugger.getDataSize(sourceLine2) - 1);
                }
                return this.addROMbreakpoint(sourceLine2.getAddress(), sourceLine2.getAddress() + sourceLine2.getSize() - 1);
            }
            return this.addROMbreakpoint(sourceLine2.getAddress(), sourceLine2.getAddress() + sourceLine2.getSize() - 1);
        }
        if (n + 1 < this.lines.size() && (sourceLine = this.lines.get(n + 1)) != null && sourceLine.getAddress() >= 0 && this.getLabel(sourceLine.getAddress()) != null) {
            return this.addBreakpoint(n + 1);
        }
        return null;
    }

    boolean canToggleBreakpoint(int n) {
        Z80Disassembler.SourceLine sourceLine;
        if (n < 0 || n >= this.table.getRowCount()) {
            return false;
        }
        Z80Disassembler.SourceLine sourceLine2 = (Z80Disassembler.SourceLine)this.table.getValueAt(n, 1);
        if (sourceLine2 != null && sourceLine2.getAddress() >= 0) {
            return true;
        }
        if (n + 1 < this.table.getRowCount() && (sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n + 1, 1)) != null && sourceLine.getAddress() >= 0 && this.getLabel(sourceLine.getAddress()) != null) {
            return true;
        }
        if (this.getRamAddressAtRow(n) >= 0 || this.getSRamAddressAtRow(n) >= 0) {
            return true;
        }
        int n2 = this.getPortAtRow(n);
        return n2 >= 0;
    }

    void toggleBreakpoint(int n) {
        if (n < 0 || n >= this.table.getRowCount()) {
            return;
        }
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n, 1);
        if (sourceLine != null && sourceLine.getAddress() >= 0) {
            if (this.isRomRow(n)) {
                if (sourceLine.getInstruction() == null) {
                    int n2 = this.getSelectedAddress();
                    if (this.isWordSelected() && n2 >= sourceLine.getAddress() && n2 < sourceLine.getAddress() + sourceLine.getSize()) {
                        this.toggleROMbreakpoint(n2, Debugger.getDataSize(sourceLine));
                    } else {
                        this.toggleROMbreakpoint(sourceLine.getAddress(), sourceLine.getSize());
                    }
                } else {
                    this.toggleROMbreakpoint(sourceLine.getAddress(), sourceLine.getSize());
                }
            } else {
                Breakpoint breakpoint = this.toggleMemoryLocationBreakpoint("cpu", sourceLine.getAddress(), sourceLine.getSize());
                if (breakpoint instanceof Watchpoint) {
                    Watchpoint watchpoint = (Watchpoint)breakpoint;
                    watchpoint.setWrite(false);
                    watchpoint.setCondition("op = 2 && &pc = " + this.systemDebugger.getBank(sourceLine.getAddress()));
                }
            }
        } else {
            Z80Disassembler.SourceLine sourceLine2;
            if (n + 1 < this.table.getRowCount() && (sourceLine2 = (Z80Disassembler.SourceLine)this.table.getValueAt(n + 1, 1)) != null && sourceLine2.getAddress() >= 0 && this.getLabel(sourceLine2.getAddress()) != null) {
                this.toggleBreakpoint(n + 1);
                return;
            }
            int n3 = this.getRamAddressAtRow(n);
            if (n3 >= 0) {
                this.toggleRAMbreakpoint(n3, 1);
            } else {
                int n4;
                int n5 = this.getSRamAddressAtRow(n);
                if (n5 >= 0) {
                    this.toggleSRAMbreakpoint(n5, 1);
                }
                if ((n4 = this.getPortAtRow(n)) >= 0) {
                    this.togglePortBreakpoint(n4);
                }
            }
        }
    }

    void togglePortBreakpoint(int n) {
        this.systemDebugger.togglePortBreakpoint(n, 1);
    }

    Breakpoint addROMbreakpoint(int n, int n2) {
        return this.addROMbreakpoint(-1, n, n2);
    }

    Breakpoint addROMbreakpoint(int n, int n2, int n3) {
        Z80Disassembler.SourceLine sourceLine = this.getSourceLine(n2);
        if (sourceLine == null) {
            return null;
        }
        Breakpoint breakpoint = n3 >= 0 ? this.systemDebugger.addROMbreakpoint(n, n2, n3 - n2 + 1) : (sourceLine.getInstruction() == null ? this.systemDebugger.addROMbreakpoint(n, n2, sourceLine.getSize() - (n2 - sourceLine.getAddress())) : this.systemDebugger.addROMbreakpoint(n, sourceLine.getAddress(), sourceLine.getSize()));
        return breakpoint;
    }

    Breakpoint addVRAMbreakpoint(int n, int n2) {
        return this.systemDebugger.addVRAMbreakpoint(n, n2 - n + 1);
    }

    Breakpoint addVRAMbreakpoint(int n, int n2, int n3) {
        return this.systemDebugger.addVRAMbreakpoint(n, n2, n3 - n2 + 1);
    }

    Breakpoint addSRAMbreakpoint(int n, int n2) {
        return this.systemDebugger.addSRAMbreakpoint(n, n2 - n + 1);
    }

    Breakpoint addSRAMbreakpoint(int n, int n2, int n3) {
        return this.systemDebugger.addSRAMbreakpoint(n, n2, n3 - n2 + 1);
    }

    Breakpoint addPortBreakpoint(int n, int n2) {
        return this.systemDebugger.addPortBreakpoint(n, n2 - n + 1);
    }

    Breakpoint addPortBreakpoint(int n, int n2, int n3) {
        return this.systemDebugger.addPortBreakpoint(n, n2, n3 - n2 + 1);
    }

    Breakpoint addMemoryLocationBreakpoint(String string, int n, int n2) {
        return this.systemDebugger.addMemoryLocationBreakpoint(string, n, n2 - n + 1);
    }

    Breakpoint addWatchpoint(int n, int n2, String string, String string2, String string3, String string4, boolean bl, boolean bl2) throws ParseException, UnknownVariableException {
        return this.systemDebugger.addWatchpoint(n, n2, string, string2, string3, string4, bl, bl2);
    }

    void toggleROMbreakpoint(int n, int n2) {
        this.systemDebugger.toggleROMbreakpoint(n, n2);
    }

    void toggleRAMbreakpoint(int n, int n2) {
        String string = this.systemDebugger.getAdditionalMemoryLocationAt(n);
        if (string != null) {
            this.systemDebugger.toggleMemoryLocationBreakpoint(string, this.systemDebugger.mapAddress(n), n2);
        } else {
            this.systemDebugger.toggleRAMbreakpoint(n, n2);
        }
    }

    void toggleVRAMbreakpoint(int n, int n2) {
        this.systemDebugger.toggleVRAMbreakpoint(n, n2);
    }

    void toggleSRAMbreakpoint(int n, int n2) {
        this.systemDebugger.toggleSRAMbreakpoint(n, n2);
    }

    Breakpoint toggleMemoryLocationBreakpoint(String string, int n, int n2) {
        return this.systemDebugger.toggleMemoryLocationBreakpoint(string, n, n2);
    }

    Breakpoint addBreakpoint(int n, int n2) {
        return this.systemDebugger.addMemoryLocationBreakpoint("cpu", n, n2 - n + 1);
    }

    Breakpoint addBreakpoint(int n, int n2, int n3) {
        return this.systemDebugger.addMemoryLocationBreakpoint("cpu", n, n2, n3 - n2 + 1);
    }

    Breakpoint recreateInvalidBreakpoint(InvalidBreakpoint invalidBreakpoint, int n, int n2) {
        return this.systemDebugger.addMemoryLocationBreakpoint("cpu", this.systemDebugger.removeBreakpoint(invalidBreakpoint, true), n, n2);
    }

    Breakpoint recreateInvalidBreakpoint(InvalidBreakpoint invalidBreakpoint, String string, String string2) {
        return this.addBreakpoint(this.systemDebugger.removeBreakpoint(invalidBreakpoint, true), string, string2);
    }

    Breakpoint getBreakpointHit() {
        return this.systemDebugger.getBreakpointHit();
    }

    int getNumberOfBreakpoints() {
        return this.systemDebugger != null ? this.systemDebugger.getNumberOfBreakpoints() : 0;
    }

    String[] getBreakpointLocationNames() {
        return this.systemDebugger.getBreakpointLocationNames();
    }

    List<Breakpoint> getBreakpoints() {
        return this.systemDebugger.getBreakpoints();
    }

    ButtonModel getSkipBreakpointsModel() {
        return this.skipBreakpoints;
    }

    ButtonModel getSkipExceptionsModel() {
        return this.skipExceptions;
    }

    public void setDisableBringToTopUponSuspend(boolean bl) {
        this.disableBringToTopUponSuspend = bl;
    }

    public static void setForceLoadSources(boolean bl) {
        forceLoadSources = bl;
    }

    public static void setForceSuspendOnOpen(boolean bl) {
        forceSuspendOnOpen = bl;
    }

    public static void setDAPdebugging(boolean bl) {
        dapDebugging = bl;
        if (!bl && debugger != null && !debugger.isVisible()) {
            Debugger.close();
        }
    }

    public static boolean isDAPdebugging() {
        return dapDebugging;
    }

    Breakpoint getBreakpoint(int n) {
        Breakpoint[] breakpointArray = this.getBreakpoints(n);
        if (breakpointArray.length > 0) {
            return breakpointArray[0];
        }
        return null;
    }

    Breakpoint[] getBreakpoints(int n) {
        if (n < 0 || n >= this.table.getRowCount()) {
            return new Breakpoint[0];
        }
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n, 1);
        if (!this.isRomRow(n)) {
            return this.systemDebugger.getCpuBreakpoints(sourceLine.getAddress());
        }
        if (sourceLine.getAddress() < 0) {
            int n2 = this.getRamAddressAtRow(n);
            if (n2 >= 0) {
                return this.systemDebugger.getRAMbreakpoints(n2);
            }
            int n3 = this.getSRamAddressAtRow(n);
            if (n3 >= 0) {
                return this.systemDebugger.getSRAMbreakpoints(n3);
            }
            int n4 = this.getPortAtRow(n);
            if (n4 >= 0) {
                return this.systemDebugger.getPortBreakpoints(n4);
            }
        }
        return this.systemDebugger.getROMbreakpoints(sourceLine.getAddress());
    }

    Breakpoint getRAMbreakpoint(int n) {
        Breakpoint[] breakpointArray = this.systemDebugger.getRAMbreakpoints(n);
        if (breakpointArray.length > 0) {
            return breakpointArray[0];
        }
        return null;
    }

    Breakpoint getVRAMbreakpoint(int n) {
        Breakpoint[] breakpointArray = this.systemDebugger.getVRAMbreakpoints(n);
        if (breakpointArray.length > 0) {
            return breakpointArray[0];
        }
        return null;
    }

    Breakpoint getSRAMbreakpoint(int n) {
        Breakpoint[] breakpointArray = this.systemDebugger.getSRAMbreakpoints(n);
        if (breakpointArray.length > 0) {
            return breakpointArray[0];
        }
        return null;
    }

    Breakpoint getPortBreakpoint(int n) {
        Breakpoint[] breakpointArray = this.systemDebugger.getPortBreakpoints(n);
        if (breakpointArray.length > 0) {
            return breakpointArray[0];
        }
        return null;
    }

    Breakpoint getMemoryLocationBreakpoint(String string, int n) {
        Breakpoint[] breakpointArray = this.systemDebugger.getMemoryLocationBreakpoints(string, n);
        if (breakpointArray.length > 0) {
            return breakpointArray[0];
        }
        return null;
    }

    String locationToString(Breakpoint breakpoint) {
        return this.systemDebugger.locationToString(breakpoint);
    }

    Breakpoint getROMbreakpoint(int n) {
        Breakpoint[] breakpointArray = this.systemDebugger.getROMbreakpoints(n);
        if (breakpointArray.length > 0) {
            return breakpointArray[0];
        }
        return null;
    }

    boolean isInterruptBreakpointEnabled() {
        return this.systemDebugger != null && this.systemDebugger.isInterruptBreakpointEnabled();
    }

    void setInterruptBreakpointEnabled(boolean bl) {
        this.systemDebugger.setInterruptBreakpointEnabled(bl);
    }

    boolean isInterruptBreakpointSuspend() {
        return this.systemDebugger != null && this.systemDebugger.isInterruptBreakpointSuspend();
    }

    void setInterruptBreakpointSuspend(boolean bl) {
        this.systemDebugger.setInterruptBreakpointSuspend(bl);
    }

    String getInterruptBreakpointCondition() {
        return this.systemDebugger.getInterruptBreakpointCondition();
    }

    void setInterruptBreakpointCondition(String string) {
        this.systemDebugger.setInterruptBreakpointCondition(string);
    }

    String getInterruptBreakpointMessage() {
        return this.systemDebugger.getInterruptBreakpointMessage();
    }

    void setInterruptBreakpointMessage(String string) {
        this.systemDebugger.setInterruptBreakpointMessage(string);
    }

    boolean isBankSwapAtPCBreakpointEnabled() {
        return this.systemDebugger != null && this.systemDebugger.isBankSwapAtPCBreakpointEnabled();
    }

    void setBankSwapAtPCBreakpointEnabled(boolean bl) {
        this.systemDebugger.setBankSwapAtPCBreakpointEnabled(bl);
    }

    boolean isBankSwapAtPCBreakpointSuspend() {
        return this.systemDebugger != null && this.systemDebugger.isBankSwapAtPCBreakpointSuspend();
    }

    void setBankSwapAtPCBreakpointSuspend(boolean bl) {
        this.systemDebugger.setBankSwapAtPCBreakpointSuspend(bl);
    }

    String getBankSwapAtPCBreakpointCondition() {
        return this.systemDebugger.getBankSwapAtPCBreakpointCondition();
    }

    void setBankSwapAtPCBreakpointCondition(String string) {
        this.systemDebugger.setBankSwapAtPCBreakpointCondition(string);
    }

    String getBankSwapAtPCBreakpointMessage() {
        return this.systemDebugger.getBankSwapAtPCBreakpointMessage();
    }

    void setBankSwapAtPCBreakpointMessage(String string) {
        this.systemDebugger.setBankSwapAtPCBreakpointMessage(string);
    }

    boolean isUninitializedMemoryBreakpointEnabled() {
        return this.systemDebugger != null && this.systemDebugger.isUninitializedMemoryBreakpointEnabled();
    }

    void setUninitializedMemoryBreakpointEnabled(boolean bl) {
        this.systemDebugger.setUninitializedMemoryBreakpointEnabled(bl);
    }

    boolean isUninitializedMemoryBreakpointSuspend() {
        return this.systemDebugger != null && this.systemDebugger.isUninitializedMemoryBreakpointSuspend();
    }

    void setUninitializedMemoryBreakpointSuspend(boolean bl) {
        this.systemDebugger.setUninitializedMemoryBreakpointSuspend(bl);
    }

    String getUninitializedMemoryBreakpointCondition() {
        return this.systemDebugger.getUninitializedMemoryBreakpointCondition();
    }

    void setUninitializedMemoryBreakpointCondition(String string) {
        this.systemDebugger.setUninitializedMemoryBreakpointCondition(string);
    }

    String getUninitializedMemoryBreakpointMessage() {
        return this.systemDebugger.getUninitializedMemoryBreakpointMessage();
    }

    void setUninitializedMemoryBreakpointMessage(String string) {
        this.systemDebugger.setUninitializedMemoryBreakpointMessage(string);
    }

    boolean isDataExecutionBreakpointEnabled() {
        return this.systemDebugger != null && this.systemDebugger.isDataExecutionBreakpointEnabled();
    }

    void setDataExecutionBreakpointEnabled(boolean bl) {
        this.systemDebugger.setDataExecutionBreakpointEnabled(bl);
    }

    boolean isDataExecutionBreakpointSuspend() {
        return this.systemDebugger != null && this.systemDebugger.isDataExecutionBreakpointSuspend();
    }

    void setDataExecutionBreakpointSuspend(boolean bl) {
        this.systemDebugger.setDataExecutionBreakpointSuspend(bl);
    }

    String getDataExecutionBreakpointCondition() {
        return this.systemDebugger.getDataExecutionBreakpointCondition();
    }

    void setDataExecutionBreakpointCondition(String string) {
        this.systemDebugger.setDataExecutionBreakpointCondition(string);
    }

    String getDataExecutionBreakpointMessage() {
        return this.systemDebugger.getDataExecutionBreakpointMessage();
    }

    void setDataExecutionBreakpointMessage(String string) {
        this.systemDebugger.setDataExecutionBreakpointMessage(string);
    }

    boolean isStackRomWriteBreakpointEnabled() {
        return this.systemDebugger != null && this.systemDebugger.isStackRomWriteBreakpointEnabled();
    }

    void setStackRomWriteBreakpointEnabled(boolean bl) {
        this.systemDebugger.setStackRomWriteBreakpointEnabled(bl);
    }

    boolean isStackRomWriteBreakpointSuspend() {
        return this.systemDebugger != null && this.systemDebugger.isStackRomWriteBreakpointSuspend();
    }

    void setStackRomWriteBreakpointSuspend(boolean bl) {
        this.systemDebugger.setStackRomWriteBreakpointSuspend(bl);
    }

    String getStackRomWriteBreakpointCondition() {
        return this.systemDebugger.getStackRomWriteBreakpointCondition();
    }

    void setStackRomWriteBreakpointCondition(String string) {
        this.systemDebugger.setStackRomWriteBreakpointCondition(string);
    }

    String getStackRomWriteBreakpointMessage() {
        return this.systemDebugger.getStackRomWriteBreakpointMessage();
    }

    void setStackRomWriteBreakpointMessage(String string) {
        this.systemDebugger.setStackRomWriteBreakpointMessage(string);
    }

    String[] getAllExceptionBreakpointDescriptions() {
        return BreakpointWindow.getAllExceptionBreakpointDescriptions();
    }

    int[] getErrorBreakpointMapping() {
        return BreakpointWindow.getErrorBreakpointMapping();
    }

    boolean isExceptionBreakpointEnabled(int n) {
        return BreakpointWindow.isExceptionBreakpointEnabled(n);
    }

    void setExceptionBreakpointsSuspend(boolean[] blArray) {
        int n = 0;
        while (n < blArray.length) {
            BreakpointWindow.setExceptionBreakpointSuspend(n, blArray[n]);
            ++n;
        }
    }

    int getNumberOfErrorCodes() {
        return this.systemDebugger != null ? this.systemDebugger.getErrorCodes().length : 0;
    }

    String getErrorBreakpointLabel(int n) {
        return Emulicious.getErrorBreakpointLabel(this.systemDebugger.getDecoratedSystem(), n);
    }

    boolean isErrorBreakpointEnabled(int n) {
        return this.systemDebugger.isErrorBreakpointEnabled(n);
    }

    void setErrorBreakpointEnabled(int n, boolean bl) {
        this.systemDebugger.setErrorBreakpointEnabled(n, bl);
    }

    boolean isErrorBreakpointSuspend(int n) {
        return this.systemDebugger.isErrorBreakpointSuspend(n);
    }

    void setErrorBreakpointSuspend(int n, boolean bl) {
        this.systemDebugger.setErrorBreakpointSuspend(n, bl);
    }

    String getErrorBreakpointCondition(int n) {
        return this.systemDebugger.getErrorBreakpointCondition(n);
    }

    void setErrorBreakpointCondition(int n, String string) {
        this.systemDebugger.setErrorBreakpointCondition(n, string);
    }

    String getErrorBreakpointMessage(int n) {
        return this.systemDebugger.getErrorBreakpointMessage(n);
    }

    void setErrorBreakpointMessage(int n, String string) {
        this.systemDebugger.setErrorBreakpointMessage(n, string);
    }

    VariableProvider getVariables() {
        return this.systemDebugger.getVariables();
    }

    java.util.HashMap<String, Integer> getVariableValues(Set<String> set) throws UnknownVariableException {
        if (set == null) {
            return null;
        }
        java.util.HashMap<String, Integer> hashMap = new java.util.HashMap<String, Integer>(set.size());
        for (String string : set) {
            hashMap.put(string, (int)this.systemDebugger.getVariables().getValue(string, true));
        }
        return hashMap;
    }

    IntMap readValues(Set<Expression> set) throws UnknownVariableException {
        if (set == null) {
            return null;
        }
        HashIntMap hashIntMap = new HashIntMap(set.size());
        for (Expression expression : set) {
            int n = expression.getValue();
            hashIntMap.put(n, this.systemDebugger.getVariables().readValue(n, false, false));
        }
        return hashIntMap;
    }

    Expression parseExpression(String string) throws ParseException {
        Expression expression = new Expression(this.systemDebugger, string);
        try {
            return expression.optimize();
        }
        catch (Exception exception) {
            return expression;
        }
    }

    Expression parseConcatenatedExpression(String string) throws ParseException {
        Expression expression = new Expression(this.systemDebugger, string, new ConcatenatedExpression(string, SystemDebugger.getTokenizer()));
        try {
            return expression.optimize();
        }
        catch (UnknownVariableException unknownVariableException) {
            return expression;
        }
    }

    Expression asExpression(int n) {
        try {
            return this.parseExpression("$" + Integer.toHexString(n));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private void repaintRuler() {
        this.ruler.repaint();
    }

    Object getLine(int n) {
        if (n >= 0 && n < this.tableRows.length) {
            return this.table.getValueAt(this.tableRows[n], 1);
        }
        return null;
    }

    Z80Disassembler.SourceLine getSourceLine(int n) {
        boolean bl;
        boolean bl2 = bl = n >= 0;
        if (!bl) {
            n = this.systemDebugger.convertAddress(n);
        }
        if (n < 0 || bl && (n >= this.tableRows.length || this.tableRows[n] == 0 || this.tableRows[n] >= this.lines.size())) {
            return null;
        }
        int n2 = bl ? this.tableRows[n] : this.getCpuRow(n);
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n2, 1);
        if (sourceLine == null) {
            return null;
        }
        if (n < sourceLine.getAddress() || n >= sourceLine.getAddress() + sourceLine.getSize()) {
            return null;
        }
        return sourceLine;
    }

    Z80Disassembler.SourceLine getRAMsourceLine(int n) {
        int n2 = this.getRamRows().get(n);
        if (n2 == Integer.MIN_VALUE) {
            return null;
        }
        return this.lines.get(n2);
    }

    Z80Disassembler.SourceLine getSRAMsourceLine(int n) {
        int n2 = this.getSramRows().get(n);
        if (n2 == Integer.MIN_VALUE) {
            return null;
        }
        return this.lines.get(n2);
    }

    int getMemoryAccessAddress(Z80Disassembler.SourceLine sourceLine) {
        if (sourceLine == null) {
            return -1;
        }
        return this.getMemoryAccessAddress(sourceLine.getInstruction());
    }

    int getMemoryAccessAddress(Z80Instruction z80Instruction) {
        if (z80Instruction == null || !z80Instruction.isMemoryAccess()) {
            return -1;
        }
        int n = z80Instruction.getMemoryAccessRegister();
        if (n < 0) {
            return z80Instruction.getArgSize() == 2 ? z80Instruction.getArg() : 0xFF00 | (z80Instruction.getArgSize() == 1 ? z80Instruction.getArg() : this.systemDebugger.getRegisterValue(0) & 0xFF);
        }
        int n2 = this.systemDebugger.getRegisterValue(n);
        if (z80Instruction.hasDisplacement()) {
            return n2 + z80Instruction.getDisplacement() & 0xFFFF;
        }
        return n2;
    }

    Z80Instruction getInstruction(int n) {
        Z80Disassembler.SourceLine sourceLine = this.getSourceLine(n);
        if (sourceLine == null) {
            return null;
        }
        return sourceLine.getInstruction();
    }

    Z80Instruction getCurrentInstruction() {
        return this.getInstruction(this.systemDebugger.getAddress());
    }

    int getCyclesPerSecond() {
        return this.systemDebugger.getCyclesPerSecond();
    }

    long getExecutedCycles() {
        return this.systemDebugger.getExecutedCycles();
    }

    int getExecutedInstructions() {
        return this.systemDebugger.getExecutedInstructions();
    }

    int getExecutedScanlines() {
        return this.systemDebugger.getExecutedScanlines();
    }

    Color getCoverageColor(int n) {
        if (!this.systemDebugger.hasCoverageData()) {
            return null;
        }
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n, 1);
        if (sourceLine.getAddress() >= 0) {
            return this.getCoverageColor(sourceLine.getAddress(), false);
        }
        return this.getCoverageColor(this.getRamAddressAtRow(n), true);
    }

    Color getCoverageColor(int n, boolean bl) {
        long l;
        long l2 = bl ? this.systemDebugger.getRamCoverage(n) : this.systemDebugger.getCoverage(n);
        long l3 = bl ? this.systemDebugger.getAverageRamCoverage() : this.systemDebugger.getAverageCoverage();
        long l4 = l = bl ? this.systemDebugger.getMaxCoverage() : this.systemDebugger.getMaxRamCoverage();
        if (l2 <= 0L) {
            return null;
        }
        float f = (float)l2 / (float)l3;
        if (f > 4.0f) {
            f = (float)l2 / ((float)l / (float)l3);
        }
        f = f * 0.3f / 3.0f + 0.4f;
        if (l2 <= 1L && f >= 0.5f) {
            f = 0.0f;
        } else if (l2 <= 2L && f >= 0.8f) {
            f = 0.5f;
        }
        if (f < 0.5f) {
            return new Color(0.0f, Math.min(0.75f + f / 0.5f * 0.25f, 1.0f), 0.0f);
        }
        if (f < 0.8f) {
            return new Color(Math.min(0.75f + (f - 0.5f) / 0.3f * 0.25f, 1.0f), Math.min(0.75f + (f - 0.5f) / 0.3f * 0.25f, 1.0f), 0.0f);
        }
        return new Color(Math.min(0.75f + (f - 0.8f) / 0.2f * 0.25f, 1.0f), 0.0f, 0.0f);
    }

    String getAddressFormat() {
        int n = this.systemDebugger.getROMsize() - 1;
        int n2 = 0;
        while (n > 0) {
            n /= 16;
            ++n2;
        }
        return "%0" + Math.max(1, n2) + "X";
    }

    Map<String, List<Symbols.Symbol>> getSymbols() {
        return this.symbols;
    }

    String getRamOrPortLabel(int n) {
        if (this.systemDebugger.isRAMaddress(n)) {
            return this.getRamLabel(this.systemDebugger.getAdditionalMemoryLocationAt(n) == null ? this.systemDebugger.mapAddress(n) : n);
        }
        if (this.systemDebugger.isVRAMaddress(n) || this.systemDebugger.isROMaddress(n) || this.systemDebugger.isSRAMaddress(n)) {
            return null;
        }
        return this.getPortLabel(n & 0xFF);
    }

    String getRamLabel(int n) {
        List<String> list = this.getRamLabels(n);
        return !list.isEmpty() ? list.get(0) : null;
    }

    List<String> getRamLabels(int n) {
        List<Symbols.Symbol> list = Symbols.findRamSymbols(n, this.getLoadedRamSymbols());
        if (!list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (Symbols.Symbol symbol : list) {
                arrayList.add(symbol.getLabel());
            }
            return arrayList;
        }
        List<Symbols.Symbol> list2 = Symbols.findRamSymbols(n - 1, this.getLoadedRamSymbols());
        if (!list2.isEmpty()) {
            return Arrays.asList(String.valueOf(list2.get(0).getLabel()) + " + 1");
        }
        return Arrays.asList(Z80Disassembler.getFormattedRAMlabel(0xC000 | n));
    }

    static String getSramLabel(int n) {
        if (!Z80Disassembler.hasSRAMlabel(n)) {
            return null;
        }
        return Z80Disassembler.getFormattedSRAMlabel(n);
    }

    String getPortLabel(int n) {
        String string = this.portNames.get(n);
        if (string != null) {
            return string;
        }
        return Z80Disassembler.getFormattedPortLabel(n);
    }

    private boolean rowHasLabel(int n) {
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n, 1);
        return this.hasLabel(this.isRomRow(n) ? sourceLine.getAddress() : this.systemDebugger.convertAddress(sourceLine.getAddress()));
    }

    boolean hasLabel(int n) {
        return !this.getLabels(n).isEmpty();
    }

    String getLabel(int n) {
        List<String> list = this.getLabels(n);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    List<String> getLabels(int n) {
        int n2;
        List<Object> list;
        boolean bl;
        boolean bl2 = bl = n >= 0;
        if (bl) {
            if (n >= this.tableRows.length) {
                return NO_LABELS;
            }
            list = this.labels.get(n);
            if (list != null) {
                return list;
            }
        } else {
            n = this.systemDebugger.convertAddress(n);
        }
        list = new LinkedList();
        boolean bl3 = false;
        int n3 = n2 = bl ? this.tableRows[n] : this.getCpuRow(n);
        if (n2 < this.table.getRowCount()) {
            while (n2 > 0) {
                Z80Disassembler.SourceLine sourceLine;
                Z80Disassembler.SourceLine sourceLine2 = sourceLine = this.isRomRow(n2) ? this.lines.get(n2) : this.cpuLines.get(n2 - this.lines.size());
                if (sourceLine == null || sourceLine.getAddress() >= 0 && sourceLine.getAddress() < n || Debugger.isBeginningOfDisassembly(sourceLine)) break;
                String string = Debugger.parseLabel(sourceLine);
                if (string != null) {
                    if (string.isEmpty()) {
                        if (n < sourceLine.getAddress() || n >= sourceLine.getAddress() + sourceLine.getSize()) break;
                    } else {
                        String string2 = sourceLine.toString();
                        if (string2.length() > string.length()) {
                            if (string2.indexOf(58, string.length()) >= 0) {
                                bl3 = true;
                            } else if (bl3) {
                                break;
                            }
                        } else if (bl3) break;
                        String string3 = this.resolveChildLabel(n2);
                        list.addFirst(string3 != null && !string3.isEmpty() ? string3 : string);
                    }
                }
                --n2;
            }
        }
        if (bl) {
            this.labels.put(n, !list.isEmpty() ? list : NO_LABELS);
        }
        return list;
    }

    private static String parseLabel(Z80Disassembler.SourceLine sourceLine) {
        if (sourceLine == null) {
            return "";
        }
        if (sourceLine.getAddress() >= 0) {
            String string = sourceLine.toString();
            int n = 0;
            while (n < string.length() && string.charAt(n) <= ' ') {
                ++n;
            }
            int n2 = n;
            int n3 = -1;
            while (n < string.length()) {
                char c;
                if ((c = string.charAt(n++)) <= ' ' && string.charAt(n2) == Z80Disassembler.getDialect().getChildLabelChar()) {
                    n3 = n - 1;
                    break;
                }
                if (c <= '\"' || c == ';') {
                    return "";
                }
                if (c != ':') continue;
                n3 = n - 1;
                break;
            }
            if (n3 > 0 && (Character.isJavaIdentifierPart(string.charAt(n3 - 1)) || "+-".indexOf(string.charAt(n3 - 1)) >= 0)) {
                if (string.charAt(n2) == '.' && n3 - n2 == 3 && Character.toUpperCase(string.charAt(n2 + 1)) == 'D' && "BWS".indexOf(Character.toUpperCase(string.charAt(n2 + 2))) >= 0) {
                    return "";
                }
                return string.substring(n2, n3);
            }
            return "";
        }
        String string = sourceLine.toString();
        if (string.isEmpty()) {
            return null;
        }
        if (string.charAt(0) != ';' && !string.endsWith("*/")) {
            if (string.length() <= 1 || Z80Disassembler.getDialect().getChildLabelChar() == '.' || string.charAt(string.length() - 1) == ':' || string.charAt(0) != '.' || "SOD".indexOf(Character.toUpperCase(string.charAt(1))) >= 0) {
                if (Z80Disassembler.getDialect().getChildLabelChar() != '.' && string.charAt(0) == '.' && Character.toUpperCase(string.charAt(1)) == 'D') {
                    if (string.toUpperCase().startsWith(".DSTRUCT")) {
                        return string.split("\\s+")[1];
                    }
                    return "";
                }
                int n = 0;
                while (n < string.length() && string.charAt(n) <= ' ') {
                    ++n;
                }
                int n4 = n;
                while (n4 < string.length()) {
                    char c = string.charAt(n4);
                    if (c == ';' || string.startsWith("/*", n4)) break;
                    if (c == ':') {
                        return string.substring(0, n4).trim();
                    }
                    if (c == '.' && n4 + 1 < string.length() && Character.toUpperCase(string.charAt(n4 + 1)) == 'A' && string.substring(n).toUpperCase().startsWith(".AREA")) {
                        return "";
                    }
                    if (c <= ' ') {
                        if (Character.toUpperCase(string.charAt(n)) == 'S' && string.toUpperCase().startsWith("SECTION", n)) {
                            return "";
                        }
                        if (Character.toLowerCase(string.charAt(n)) == 'c' && string.toLowerCase().startsWith("code page", n)) {
                            return "";
                        }
                        return null;
                    }
                    ++n4;
                }
                if (n > 0 && n < string.length() && string.charAt(n) != Z80Disassembler.getDialect().getChildLabelChar()) {
                    return null;
                }
                return !"POPS".equals(string) && !"ENDC".equals(string) && !"ELSE".equals(string) ? string.substring(n) : "";
            }
            if (string.charAt(0) == '.') {
                return null;
            }
        }
        return null;
    }

    private String parseLabel(int n) {
        return Debugger.parseLabel(this.isRomRow(n) ? this.lines.get(n) : this.cpuLines.get(n - this.lines.size()));
    }

    /*
     * Unable to fully structure code
     */
    private String resolveChildLabel(int var1_1) {
        var2_2 = Z80Disassembler.getDialect().getChildLabelChar();
        var3_3 = this.parseLabel(var1_1);
        if (var3_3 != null && !var3_3.isEmpty() && var3_3.charAt(0) == var2_2) ** GOTO lbl19
        return var3_3;
lbl-1000:
        // 1 sources

        {
            var4_4 = 0;
            while (var4_4 + 1 < var3_3.length() && var3_3.charAt(var4_4 + 1) == var2_2) {
                ++var4_4;
            }
            while (--var1_1 >= 0) {
                var5_5 = this.parseLabel(var1_1);
                if (var5_5 == null || var5_5.isEmpty() || "+-.".indexOf(var5_5.charAt(0)) >= 0) continue;
                var6_6 = -1;
                while (var6_6 + 1 < var5_5.length() && var5_5.charAt(var6_6 + 1) == var2_2) {
                    ++var6_6;
                }
                if (var6_6 >= var4_4) continue;
                var3_3 = String.valueOf(var5_5) + var3_3.substring(var4_4);
                continue block0;
            }
lbl19:
            // 3 sources

            ** while (var3_3.charAt((int)0) == var2_2 && var1_1 >= 0)
        }
lbl20:
        // 1 sources

        return var3_3;
    }

    int findLabelAddress(int n) {
        while (n >= 0) {
            Z80Disassembler.SourceLine sourceLine = this.getSourceLine(n);
            if (sourceLine == null) {
                return -1;
            }
            n = sourceLine.getAddress();
            if (this.hasLabel(n)) {
                return n;
            }
            --n;
        }
        return -1;
    }

    int getSelectedRamAddress() {
        return this.getRamAddressAtRow(this.table.getSelectedRow());
    }

    int getSelectedSRamAddress() {
        return this.getSRamAddressAtRow(this.table.getSelectedRow());
    }

    int getROMsize() {
        return this.systemDebugger.getROMsize();
    }

    int getRAMlength() {
        return this.systemDebugger.getRAMlength();
    }

    long getCoverage(int n) {
        return this.systemDebugger.getCoverage(n);
    }

    long getRamCoverage(int n) {
        return this.systemDebugger.getRamCoverage(n);
    }

    void setRecordCoverage(boolean bl) {
        this.systemDebugger.setRecordCoverage(bl);
        this.updateAnnotations();
    }

    void clearCoverageData() {
        this.systemDebugger.clearCoverageData();
        this.updateAnnotations();
    }

    void resetROMcoverage(int n) {
        this.systemDebugger.resetROMcoverage(n);
        this.updateAnnotations();
    }

    void resetRAMcoverage(int n) {
        this.systemDebugger.resetRAMcoverage(n);
        this.updateAnnotations();
    }

    void setExcludedFromROMcoverage(int n, boolean bl) {
        this.systemDebugger.setExcludedFromROMcoverage(n, bl);
    }

    boolean isROMcoverageExcluded(int n) {
        return this.systemDebugger.isROMcoverageExcluded(n);
    }

    void setExcludedFromRAMcoverage(int n, boolean bl) {
        this.systemDebugger.setExcludedFromRAMcoverage(n, bl);
    }

    boolean isRAMcoverageExcluded(int n) {
        return this.systemDebugger.isRAMcoverageExcluded(n);
    }

    int mapAddress(int n, int n2) {
        return this.systemDebugger.mapAddress(n, n2);
    }

    void updateAnnotations() {
        this.table.repaint();
        this.overviewRuler.repaint();
        if (this.southTabbedPane.getSelectedIndex() == this.memoryEditorTabIndex) {
            this.memoryEditor.update();
        }
    }

    boolean isRecordCoverage() {
        return this.systemDebugger.isRecordCoverage();
    }

    int getRamAddressAtRow(int n) {
        if (n < 0 || n >= this.table.getRowCount() || this.updatingDisassembly) {
            return -1;
        }
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(n, 0);
        if (sourceLine.getAddress() >= 0) {
            return -1;
        }
        int n2 = this.getRamRows().getKey(n);
        if (n2 >= 0) {
            return n2;
        }
        return -1;
    }

    int getSRamAddressAtRow(int n) {
        if (n < 0 || n >= this.table.getRowCount() || this.updatingDisassembly) {
            return -1;
        }
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(n, 0);
        if (sourceLine.getAddress() >= 0) {
            return -1;
        }
        int n2 = this.getSramRows().getKey(n);
        if (n2 >= 0) {
            return n2;
        }
        return -1;
    }

    boolean isInputPortAtRow(int n) {
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(--n, 0);
        while (n >= 0 && sourceLine.getAddress() < 0) {
            String string = sourceLine.toString().trim();
            if ("; Input Ports".equals(string)) {
                return true;
            }
            if (!string.isEmpty() && string.charAt(0) == ';') {
                return false;
            }
            sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(--n, 0);
        }
        return false;
    }

    int getPortAtRow(int n) {
        if (n < 0 || n >= this.table.getRowCount()) {
            return -1;
        }
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(n, 0);
        if (sourceLine.getAddress() >= 0) {
            return -1;
        }
        int n2 = this.getPortRows().getKey(n);
        if (n2 >= 0) {
            return n2;
        }
        return -1;
    }

    OutlineElement generateOutline(boolean bl, boolean bl2) {
        Z80Disassembler.IntegerTreeMap integerTreeMap = this.determineSections ? this.determineSections(bl, bl2) : null;
        OutlineElement outlineElement = new OutlineElement();
        Stack<Object> stack = new Stack<Object>();
        Stack<OutlineElement> stack2 = new Stack<OutlineElement>();
        Stack<OutlineElement> stack3 = new Stack<OutlineElement>();
        Z80Instruction z80Instruction = null;
        stack.push(outlineElement);
        boolean bl3 = false;
        int n = 0;
        while (n < this.lines.size()) {
            block57: {
                String string;
                Object object2;
                block61: {
                    block60: {
                        Z80Disassembler.SourceLine sourceLine;
                        block58: {
                            String string2;
                            Object object;
                            block59: {
                                block56: {
                                    char c;
                                    sourceLine = this.lines.get(n);
                                    int n2 = sourceLine.getAddress();
                                    if (n2 < 0) break block56;
                                    boolean bl4 = Debugger.isCode(n2);
                                    object2 = Z80Disassembler.getDialect();
                                    char c2 = c = object2 != null ? object2.getChildLabelChar() : (char)'\u0000';
                                    if (bl && bl4 || bl2 && !bl4) {
                                        for (String string3 : this.getLabels(n2)) {
                                            String string4;
                                            int n3;
                                            Map.Entry entry;
                                            boolean bl5 = !Character.isJavaIdentifierStart(string3.charAt(0));
                                            String string5 = string3;
                                            int n4 = 0;
                                            while (string5.indexOf(c) >= 0) {
                                                int n5 = string5.indexOf(c);
                                                if (n5 == string5.length() - 1) break;
                                                ++n4;
                                                string5 = string5.substring(n5 + 1);
                                            }
                                            while (!bl5 && !stack2.isEmpty() && n4 <= stack2.size()) {
                                                stack2.pop();
                                            }
                                            OutlineElement outlineElement2 = new OutlineElement(string5, n, n2, bl4 ? (char)'C' : 'D');
                                            boolean bl6 = n4 == 0 && z80Instruction != null && z80Instruction.getOpCode() != 24 && z80Instruction.getOpCode() != 195 && z80Instruction.getOpCode() != 233 && (!z80Instruction.isRet() || z80Instruction.isConditional());
                                            boolean bl7 = bl5 || bl6 || n4 == 1;
                                            Object object3 = !stack2.isEmpty() ? (OutlineElement)stack2.peek() : (OutlineElement)stack.peek();
                                            List<OutlineElement> list = ((OutlineElement)object3).getChildren();
                                            if (integerTreeMap != null && !bl7 && n2 >= 0 && !list.isEmpty()) {
                                                entry = integerTreeMap.lowerEntry(n2);
                                                if (entry != null && ((Z80Disassembler.IntegerTreeMap)entry.getValue()).containsKey(n2)) {
                                                    n3 = (Integer)entry.getKey();
                                                    bl7 = true;
                                                } else {
                                                    n3 = -1;
                                                }
                                            } else {
                                                n3 = -1;
                                            }
                                            if (!(!bl7 || list.isEmpty() || n3 >= 0 && ((OutlineElement)object3).getAddress() == n3 || ((OutlineElement)((Object)(entry = list.get(list.size() - 1)))).getIconChar() != 'C' && ((OutlineElement)((Object)entry)).getIconChar() != 'D' || !Character.isJavaIdentifierStart((string4 = ((OutlineElement)((Object)entry)).toString()).charAt(0)))) {
                                                object3 = entry;
                                                list = ((OutlineElement)object3).getChildren();
                                                if (n4 > 0) {
                                                    // empty if block
                                                }
                                            }
                                            if (n4 == 0 && n3 >= 0 && ((OutlineElement)object3).getAddress() != n3) {
                                                object3 = (OutlineElement)stack.peek();
                                            }
                                            ((OutlineElement)object3).addChild(outlineElement2);
                                            if (bl5 || n4 <= stack2.size()) continue;
                                            stack2.push(outlineElement2);
                                        }
                                    }
                                    if (sourceLine.getSize() > 0) {
                                        z80Instruction = sourceLine.getInstruction();
                                    }
                                    break block57;
                                }
                                string = sourceLine.toString();
                                if (!string.startsWith(";* ")) break block58;
                                object2 = string.toUpperCase();
                                if (!((String)object2).contains("INCLUDE")) break block59;
                                if (((String)object2).contains("END OF")) {
                                    while (stack.peek() != outlineElement && ((OutlineElement)stack.peek()).getIconChar() != 'I') {
                                        OutlineElement outlineElement3 = (OutlineElement)stack.pop();
                                        if (outlineElement3 == outlineElement) {
                                            throw new IllegalStateException("root must not be popped");
                                        }
                                        if (outlineElement3.getIconChar() != 'S' && outlineElement3.getIconChar() != 'R' || outlineElement3.getChildren().isEmpty() && outlineElement3.getIconChar() != 'R') continue;
                                        ((OutlineElement)stack.peek()).addChild(outlineElement3);
                                    }
                                    if (!string.contains(((OutlineElement)stack.peek()).toString())) {
                                        throw new IllegalStateException("Closing include " + string + " while " + stack.peek() + " is top most include");
                                    }
                                    if (stack.pop() == outlineElement) {
                                        throw new IllegalStateException("root must not be popped");
                                    }
                                } else {
                                    int n6 = string.indexOf(34);
                                    String string6 = n6 >= 0 ? string.substring(n6 + 1, string.lastIndexOf(34)) : string.substring(string.indexOf(32));
                                    object = new OutlineElement(string6, n, 'I');
                                    ((OutlineElement)stack.peek()).addChild((OutlineElement)object);
                                    stack.push(object);
                                }
                                break block57;
                            }
                            if (!((String)object2).contains("BEGINNING OF ")) break block58;
                            int n7 = string.indexOf(" OF ") + " OF ".length();
                            String string7 = string2 = n7 >= 0 ? string.substring(n7) : null;
                            if (string2 == null) break block58;
                            while (stack.peek() != outlineElement && ((OutlineElement)stack.peek()).getIconChar() != 'A') {
                                object = (OutlineElement)stack.pop();
                                if (object == outlineElement) {
                                    throw new IllegalStateException("root must not be popped");
                                }
                                if (((OutlineElement)object).getIconChar() != 'S' && ((OutlineElement)object).getIconChar() != 'R' || ((OutlineElement)object).getChildren().isEmpty() && ((OutlineElement)object).getIconChar() != 'R') continue;
                                ((OutlineElement)stack.peek()).addChild((OutlineElement)object);
                            }
                            if (stack.peek() != outlineElement) {
                                stack.pop();
                            }
                            object = new OutlineElement(string2, n, 'A');
                            ((OutlineElement)stack.peek()).addChild((OutlineElement)object);
                            stack.push(object);
                            break block57;
                        }
                        if (!Debugger.isBeginningOfDisassembly(sourceLine)) break block60;
                        while (stack.peek() != outlineElement) {
                            object2 = (OutlineElement)stack.pop();
                            if (object2 == outlineElement) {
                                throw new IllegalStateException("root must not be popped");
                            }
                            if (((OutlineElement)object2).getIconChar() != 'S' && ((OutlineElement)object2).getIconChar() != 'R' && ((OutlineElement)object2).getIconChar() != ' ' || ((OutlineElement)object2).getChildren().isEmpty() && ((OutlineElement)object2).getIconChar() != 'R') continue;
                            ((OutlineElement)stack.peek()).addChild((OutlineElement)object2);
                        }
                        break block57;
                    }
                    object2 = StringUtilities.trim(string);
                    if (StringUtilities.startsWith((CharSequence)object2, "/*")) {
                        bl3 = true;
                    }
                    if (!bl3) break block61;
                    int n8 = StringUtilities.lastIndexOf((CharSequence)object2, "*/");
                    if (n8 < 0) break block57;
                    bl3 = false;
                    if (StringUtilities.isEmpty((CharSequence)(object2 = object2.subSequence(n8 + 2, object2.length())))) break block57;
                }
                if (!StringUtilities.isEmpty((CharSequence)object2) && object2.charAt(0) != ';') {
                    if (object2.charAt(0) == '.' && StringUtilities.startsWithIgnoreCase((CharSequence)object2, ".MODULE")) {
                        if (stack.peek() != outlineElement) {
                            OutlineElement outlineElement4 = (OutlineElement)stack.pop();
                            if (outlineElement4 == outlineElement) {
                                throw new IllegalStateException("root must not be popped");
                            }
                            if (!outlineElement4.getChildren().isEmpty()) {
                                ((OutlineElement)stack.peek()).addChild(outlineElement4);
                            }
                        }
                        String string4 = StringUtilities.subSequence((CharSequence)object2, ".MODULE ".length()).toString();
                        OutlineElement outlineElement3 = new OutlineElement(string4, n, ' ');
                        stack.push(outlineElement3);
                    } else if (Debugger.isSectionStart((CharSequence)object2) || Debugger.isSectionEnd((CharSequence)object2)) {
                        OutlineElement outlineElement5;
                        if (Debugger.isSectionEnd((CharSequence)object2) && ((outlineElement5 = (OutlineElement)stack.peek()).getIconChar() == 'S' || outlineElement5.getIconChar() == 'R')) {
                            if (stack.pop() == outlineElement) {
                                throw new IllegalStateException("root must not be popped");
                            }
                            if (!outlineElement5.getChildren().isEmpty() || outlineElement5.getIconChar() == 'R') {
                                ((OutlineElement)stack.peek()).addChild(outlineElement5);
                            }
                        }
                        if (Debugger.isSectionStart((CharSequence)object2)) {
                            String string5 = string.substring(string.indexOf(34) + 1, string.lastIndexOf(34));
                            OutlineElement outlineElement4 = new OutlineElement(string5.charAt(0) == '!' ? string5.substring(1) : string5, n, 'S');
                            stack.push(outlineElement4);
                        } else if (Debugger.isRamSectionStart((CharSequence)object2)) {
                            String string6 = string.substring(string.indexOf(34) + 1, string.lastIndexOf(34));
                            OutlineElement outlineElement6 = new OutlineElement(string6, n, 'R');
                            stack.push(outlineElement6);
                        }
                    } else if (StringUtilities.equalsIgnoreCase((CharSequence)object2, "PUSHS")) {
                        if (!stack.isEmpty() && stack.peek() != outlineElement) {
                            stack3.push((OutlineElement)stack.pop());
                        }
                    } else if (StringUtilities.equalsIgnoreCase((CharSequence)object2, "POPS")) {
                        if (!stack3.isEmpty()) {
                            OutlineElement outlineElement6;
                            if (!(stack.isEmpty() || (outlineElement6 = (OutlineElement)stack.peek()).getIconChar() != 'S' && outlineElement6.getIconChar() != 'R')) {
                                if (stack.pop() == outlineElement) {
                                    throw new IllegalStateException("root must not be popped");
                                }
                                if (!outlineElement6.getChildren().isEmpty() || outlineElement6.getIconChar() == 'R') {
                                    ((OutlineElement)stack.peek()).addChild(outlineElement6);
                                }
                            }
                            stack.push((OutlineElement)stack3.pop());
                        }
                    } else {
                        StringUtilities.startsWithIgnoreCase((CharSequence)object2, ".ENDST");
                    }
                }
            }
            ++n;
        }
        if (stack.peek() != outlineElement) {
            if (((OutlineElement)stack.peek()).getIconChar() == 'S' || ((OutlineElement)stack.peek()).getIconChar() == 'R') {
                OutlineElement outlineElement7 = (OutlineElement)stack.pop();
                if (!outlineElement7.getChildren().isEmpty()) {
                    ((OutlineElement)stack.peek()).addChild(outlineElement7);
                }
            } else {
                OutlineElement outlineElement8 = (OutlineElement)stack.pop();
                if (!outlineElement8.getChildren().isEmpty()) {
                    ((OutlineElement)stack.peek()).addChild(outlineElement8);
                }
            }
        }
        return outlineElement;
    }

    Z80Disassembler.IntegerTreeMap determineSections(boolean bl, boolean bl2) {
        final int[] nArray = this.tableRows;
        if (this.lines.size() <= 1) {
            return new Z80Disassembler.IntegerTreeMap();
        }
        return new Z80Disassembler.IntegerTreeMap(Z80Disassembler.findSections(this.memory, this.systemDebugger.getRamRomMap(), this.getLoadedSymbols().values(), bl, bl2), new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                if (n >= nArray.length || n2 >= nArray.length) {
                    return n - n2;
                }
                return nArray[n] - nArray[n2];
            }
        });
    }

    static boolean isCode(int n) {
        return Z80Disassembler.isCode(n);
    }

    private static boolean isSectionStart(CharSequence charSequence) {
        return charSequence.charAt(0) == '.' && StringUtilities.startsWithIgnoreCase(charSequence, ".SECTION") || StringUtilities.startsWithIgnoreCase(charSequence, "SECTION") && StringUtilities.indexOfIgnoreCase(charSequence, "ROM") >= 0;
    }

    private static boolean isSectionEnd(CharSequence charSequence) {
        return charSequence.charAt(0) == '.' && StringUtilities.startsWithIgnoreCase(charSequence, ".ENDS") && (charSequence.length() <= ".ENDS".length() || charSequence.charAt(".ENDS".length()) <= ' ') || StringUtilities.startsWithIgnoreCase(charSequence, "SECTION");
    }

    private static boolean isRamSectionStart(CharSequence charSequence) {
        return StringUtilities.startsWithIgnoreCase(charSequence, ".RAMSECTION") || StringUtilities.startsWithIgnoreCase(charSequence, "SECTION") && StringUtilities.indexOfIgnoreCase(charSequence, "RAM") >= 0;
    }

    private static boolean isBeginningOfDisassembly(Z80Disassembler.SourceLine sourceLine) {
        return sourceLine == Z80Disassembler.SourceLine.DISASSEMBLY_HEAD_COMMENT;
    }

    Icon getDefaultIcon(Icon icon, boolean bl, char c) {
        int n;
        int n2;
        if (icon != null) {
            n2 = icon.getIconWidth();
            n = icon.getIconHeight();
        } else {
            n2 = n = this.table.getRowHeight();
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (!bl && icon != null) {
            icon.paintIcon(this.window, graphics2D, 0, 0);
        }
        Font font = new Font("SansSerif", 1, this.table.getFont().getSize() - 1);
        graphics2D.setFont(font);
        int n3 = bufferedImage.getHeight() - this.window.getFontMetrics(font).getDescent() + (bl ? 1 : 0);
        if (c == 'C') {
            graphics2D.setColor(CODE_COLOR);
            graphics2D.drawString("C", bufferedImage.getWidth() / 2 - 3, n3);
        } else if (c == 'D') {
            graphics2D.setColor(DATA_COLOR);
            graphics2D.drawString("D", bufferedImage.getWidth() / 2 - 3, n3);
        } else if (c == 'I') {
            graphics2D.setColor(INCLUDE_COLOR);
            graphics2D.drawString("I", bufferedImage.getWidth() / 2 - 1, n3);
        } else if (c == 'A') {
            graphics2D.setColor(ASM_COLOR);
            graphics2D.drawString("A", bufferedImage.getWidth() / 2 - 3, n3);
        } else if (c == 'S' || c == 'R') {
            graphics2D.setColor(SECTION_COLOR);
            graphics2D.drawString(Character.toString(c), bufferedImage.getWidth() / 2 - 3, n3);
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private void updateDisassembly() {
        int n;
        final int[] nArray = this.memory;
        final Properties properties = this.properties;
        final util.map.Map<String> map = this.portNames;
        final SystemDebugger systemDebugger = this.systemDebugger;
        if (this.tableRows.length > 0 && this.tableRows[0] != 0) {
            n = this.getVisibleAddress();
            Arrays.fill(this.tableRows, 0);
            this.table.scrollRectToVisible(new Rectangle());
        } else {
            n = -1;
        }
        this.updatingDisassembly = true;
        this.lines = DISASSEMBLING;
        this.cancelLoadingSources = true;
        final AssemblerDialect assemblerDialect = Emulicious.getSelectedAssemblerDialect();
        new Thread(new Runnable(){

            @Override
            public void run() {
                List<Z80Disassembler.SourceLine> list = Z80Disassembler.analyze(nArray, null, Debugger.getConfigFile(), Boolean.parseBoolean(properties.getProperty("DisassemblerAllowCallsToUnknownRAM")), Debugger.this.getLoadedSymbols(), map, assemblerDialect, Debugger.this.sectionProvider, properties.getInt("MaxDataBlockSize"), Emulicious.getProperties().getInt("DisassemblerDsbBlockSize"), Boolean.parseBoolean(properties.getProperty("DisassemblerCreateLinkFile")), properties.getProperty("DisassemblerFormatCodeLabel"), properties.getProperty("DisassemblerFormatDataLabel"), properties.getProperty("DisassemblerFormatRAMlabel"), properties.getProperty("DisassemblerFormatSRAMlabel"), properties.getProperty("DisassemblerFormatPortLabel"), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerUseAnonymousLabels")), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerUseUpperCaseMnemonics")), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerPadMnemonics")), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerVerbose")));
                if (Z80Disassembler.loadCDBfileIfAvailable(Debugger.findSourceFile(true), Emulicious.getROMfile(), Debugger.this.symbols, nArray)) {
                    list = Z80Disassembler.generateLines(nArray, systemDebugger.getRamRomMap(), Debugger.this.getLoadedSymbols(), map, assemblerDialect, Debugger.this.sectionProvider, Integer.MAX_VALUE, properties.getInt("DisassemblerDsbBlockSize"), Boolean.parseBoolean(properties.getProperty("DisassemblerCreateLinkFile")), properties.getProperty("DisassemblerFormatCodeLabel"), properties.getProperty("DisassemblerFormatDataLabel"), properties.getProperty("DisassemblerFormatRAMlabel"), properties.getProperty("DisassemblerFormatSRAMlabel"), properties.getProperty("DisassemblerFormatPortLabel"), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerUseAnonymousLabels")), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerUseUpperCaseMnemonics")), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerPadMnemonics")));
                }
                Debugger.this.updateRows(list);
                Debugger.this.packDisassemblerTable();
                if (forceLoadSources || Debugger.this.sourceFile != null && Debugger.this.sourceFile.exists()) {
                    while (Debugger.this.loadingSources) {
                        try {
                            Debugger.this.cancelLoadingSources = true;
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    Debugger.this.loadingSources = true;
                    try {
                        Debugger.this.readAssemblyLines(Debugger.findSourceFile());
                    }
                    catch (IOException iOException) {
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Debugger.this.loadingSources = false;
                }
                Debugger.this.updatingDisassembly = false;
                try {
                    SourceMap sourceMap;
                    String string;
                    Debugger.this.evscriptDebugInfo = Z80Disassembler.loadEvscriptDebugInfo(new File(Emulicious.getROMfile().getParentFile(), String.valueOf(Debugger.getRomFileNameWithoutExtension()) + ".evd"), Debugger.this.symbols, systemDebugger, Emulicious.getROMfile().getParentFile());
                    if (Debugger.this.evscriptDebugInfo != null && (string = ((EvscriptSourceMap)(sourceMap = Z80Disassembler.getSourceMap())).getErrors()) != null) {
                        systemDebugger.fireMessageReceived(string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    systemDebugger.fireMessageReceived(illegalArgumentException.getMessage());
                }
                systemDebugger.recreateInvalidBreakpoints();
                if (Debugger.isSuspended() && systemDebugger.isBiosSkipped() && Debugger.this.getVisibleAddress() != Debugger.this.address) {
                    if (n >= 0 || systemDebugger.convertAddress(n) >= 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (Debugger.this.getVisibleAddress() != (this).Debugger.this.address) {
                                    Debugger.this.scrollToVisible(n);
                                }
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (Debugger.this.getVisibleAddress() != (this).Debugger.this.address) {
                                    Debugger.this.scrollCurrentInstructionToVisible();
                                }
                            }
                        });
                    }
                }
            }
        }, "Disassembly Updater").start();
    }

    private ExpressionEvaluator createExpressionEvaluator() {
        return new ExpressionEvaluator(){

            /*
             * Unable to fully structure code
             */
            @Override
            public int evaluate(CharSequence var1_1) throws UnknownIdentifierException {
                try {
                    var2_2 = Debugger.this.systemDebugger;
                    if (Debugger.this.cancelLoadingSources || var2_2 == null) {
                        throw new AbortException();
                    }
                    return new expressions.Expression(var1_1, SystemDebugger.getTokenizer()).getValue(VariableProvider.NO_VARIABLES, var2_2.getFunctions());
                }
                catch (UnknownVariableException var2_3) {
                    throw new UnknownIdentifierException(var2_3.getMessage());
                }
                catch (ParseException var2_4) {
                    var3_5 = var1_1.length();
                    if (var3_5 == 0) {
                        throw new EvaluateException(var2_4);
                    }
                    var4_6 = var1_1.charAt(0);
                    if (var4_6 == '.') {
                        throw new UnknownIdentifierException(var2_4.getMessage());
                    }
                    if (var4_6 == '#') {
                        return 0;
                    }
                    var5_7 = var1_1.charAt(var3_5 - 1);
                    if ((var4_6 == '-' || var4_6 == '+') && var5_7 == var4_6) {
                        throw new UnknownIdentifierException(var2_4.getMessage());
                    }
                    var6_8 = Character.toLowerCase(var5_7);
                    if (var6_8 == 'h') {
                        try {
                            return Integer.parseInt(var1_1.subSequence(0, var1_1.length() - 1).toString(), 16);
                        }
                        catch (NumberFormatException v0) {}
                    }
                    if (var6_8 == 'b') {
                        try {
                            return Integer.parseInt(var1_1.subSequence(0, var1_1.length() - 1).toString(), 2);
                        }
                        catch (NumberFormatException v1) {}
                    }
                    if (var6_8 == 'f' || var6_8 == 'b') {
                        throw new UnknownIdentifierException(var2_4.getMessage());
                    }
                    if (var6_8 == '@') {
                        return 0;
                    }
                    if (var3_5 < 2) {
                        throw new EvaluateException(var2_4);
                    }
                    var7_9 = var1_1.charAt(1);
                    if (var4_6 == ':' && (var7_9 == '+' || var7_9 == '-')) {
                        throw new UnknownIdentifierException(var2_4.getMessage());
                    }
                    if (var4_6 == '@' && var7_9 == '@') {
                        throw new UnknownIdentifierException(var2_4.getMessage());
                    }
                    if (var4_6 == '\"' && var5_7 == '\"' && (var8_10 = var1_1.toString().split("==")).length == 2) {
                        return var8_10[0].equals(var8_10[1]) != false ? -1 : 0;
                    }
                    if (var3_5 > 4 && Character.toUpperCase(var4_6) == 'B' && Character.toUpperCase(var7_9) == 'A' && Character.toUpperCase(var1_1.charAt(2)) == 'N' && Character.toUpperCase(var1_1.charAt(3)) == 'K') {
                        throw new UnknownIdentifierException(var2_4.getMessage());
                    }
                    var8_11 = 0;
                    ** while (var8_11 < var3_5 - 1)
                }
lbl-1000:
                // 1 sources

                {
                    var9_12 = var1_1.charAt(var8_11);
                    if (var9_12 == '.') {
                        if (!Character.isDigit(var1_1.charAt(var8_11 + 1))) break;
                        return (int)(Double.parseDouble(var1_1.toString()) * 65536.0);
                    }
                    if (var9_12 != '-' && !Character.isDigit(var9_12)) break;
                    ++var8_11;
                    continue;
                }
lbl53:
                // 3 sources

                throw new EvaluateException(var2_4);
            }
        };
    }

    void readAssemblyLines(File file) throws IOException {
        this.readAssemblyLines(file, this.properties.getInt("DebuggerLoadSourcesAutomaticallyThreshold", 20));
    }

    /*
     * WARNING - void declaration
     */
    void readAssemblyLines(File file, int n) throws IOException {
        Z80Disassembler.SourceLine sourceLine;
        Object object;
        int n2;
        int sourceLine5;
        int n3;
        this.cancelLoadingSources = false;
        this.sourceFile = file;
        if (file == null || !file.exists()) {
            return;
        }
        List<Z80Disassembler.SourceLine> list = Z80Disassembler.readLines(file, this.memory, this.symbols, this.getLoadedSymbols(), this.sectionProvider, this.createExpressionEvaluator());
        if (list.isEmpty()) {
            this.sourceFile = null;
            return;
        }
        BitSet bitSet = new BitSet();
        for (Z80Disassembler.SourceLine object22 : list) {
            if (object22.getAddress() < 0) continue;
            bitSet.set(object22.getAddress(), object22.getAddress() + object22.getSize());
        }
        if (file.getName().endsWith(".map")) {
            n /= 4;
        }
        if (bitSet.cardinality() * 100 / this.memory.length < n) {
            void var5_9;
            boolean n5 = false;
            if (this.memory[this.memory.length - 1] == this.memory[this.memory.length - 2] && this.memory[this.memory.length - 2] == this.memory[this.memory.length - 3]) {
                int n6 = this.memory.length / 8192 - 1;
                while (n6 >= 0) {
                    n3 = n6 * 8192;
                    int n10 = n3 + 8191;
                    int n11 = this.memory[n10];
                    int sourceLine3 = n6 * 8192;
                    sourceLine5 = 4096;
                    while (sourceLine5 > 0) {
                        if (this.memory[sourceLine3] == n11 && this.memory[sourceLine3 + 1] == n11 && this.memory[sourceLine3 + 2] == n11 && this.memory[sourceLine3 + sourceLine5] == n11) {
                            while (sourceLine3 - 1 >= n3 && this.memory[sourceLine3 - 1] == n11) {
                                --sourceLine3;
                            }
                            var5_9 += n10 - sourceLine3;
                            break;
                        }
                        sourceLine3 += sourceLine5;
                        sourceLine5 >>= 1;
                    }
                    --n6;
                }
            }
            if (bitSet.cardinality() * 100 / (this.memory.length - var5_9) < n) {
                this.sourceFile = null;
                return;
            }
        }
        if (this.symbols.isEmpty()) {
            Debugger.logMessage("WARNING: Loaded sources without debug symbols.\n         The source code mapping might be inaccurate.\n         For the best experience, make sure to make your tool generate debug symbols.\n");
        }
        RamRomMap ramRomMap = this.systemDebugger.getRamRomMap();
        List<Z80Disassembler.SourceLine> list2 = Z80Disassembler.generateLines(this.memory, ramRomMap, this.getLoadedSymbols(), this.portNames, Emulicious.getSelectedAssemblerDialect(), this.sectionProvider, Integer.MAX_VALUE, Emulicious.getProperties().getInt("DisassemblerDsbBlockSize"), Boolean.parseBoolean(this.properties.getProperty("DisassemblerCreateLinkFile")), this.properties.getProperty("DisassemblerFormatCodeLabel"), this.properties.getProperty("DisassemblerFormatDataLabel"), this.properties.getProperty("DisassemblerFormatRAMlabel"), this.properties.getProperty("DisassemblerFormatSRAMlabel"), this.properties.getProperty("DisassemblerFormatPortLabel"), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerUseAnonymousLabels")), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerUseUpperCaseMnemonics")), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerPadMnemonics")));
        n3 = 0;
        while (n3 + 1 < list2.size() && ((Z80Disassembler.SourceLine)list2.get(n3 + 1)).getAddress() < 0) {
            ++n3;
        }
        while (n3 > 0) {
            Z80Disassembler.SourceLine sourceLine2;
            String arrayList;
            if ((arrayList = Debugger.parseLabel(sourceLine2 = (Z80Disassembler.SourceLine)list2.get(n3--))) != null && arrayList.isEmpty()) break;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < list.size()) {
            Z80Disassembler.SourceLine sourceLine3 = list.get(n5);
            if (sourceLine3.getAddress() >= 0 && !bitSet.get(sourceLine5 = sourceLine3.getAddress() + sourceLine3.getSize()) && (n2 = Math.min(this.tableRows.length, bitSet.nextSetBit(sourceLine5) & Integer.MAX_VALUE)) > sourceLine5) {
                object = new Z80Disassembler.SourceLine("; Loaded sources do not match the ROM from " + Integer.toHexString(sourceLine5).toUpperCase() + " to " + Integer.toHexString(n2 - 1).toUpperCase());
                list.add(++n5, (Z80Disassembler.SourceLine)object);
                if (n4 >= list2.size() || sourceLine5 < ((Z80Disassembler.SourceLine)list2.get(n4)).getAddress()) {
                    n4 = 0;
                }
                while (!this.cancelLoadingSources && n4 < list2.size() && ((Z80Disassembler.SourceLine)list2.get(n4)).getAddress() + ((Z80Disassembler.SourceLine)list2.get(n4)).getSize() <= sourceLine5) {
                    ++n4;
                }
                while (!this.cancelLoadingSources && n4 < list2.size() && ((Z80Disassembler.SourceLine)list2.get(n4)).getAddress() < n2) {
                    sourceLine = (Z80Disassembler.SourceLine)list2.get(n4);
                    if (sourceLine.getAddress() >= 0) {
                        int n6;
                        AbstractCollection string;
                        if (sourceLine.getAddress() < sourceLine5 || sourceLine.getAddress() + sourceLine.getSize() > n2) {
                            string = new ArrayList();
                            n6 = Math.max(sourceLine5, sourceLine.getAddress());
                            int n7 = Math.min(n2, sourceLine.getAddress() + sourceLine.getSize());
                            Z80Disassembler.writeSubDataBlockLine((List<Z80Disassembler.SourceLine>)((Object)string), this.memory, ramRomMap, n6, n7, this.getLoadedSymbols());
                            list.addAll(++n5, string);
                            bitSet.set(n6, n7);
                            n5 += string.size() - 1;
                        } else {
                            string = new ArrayDeque();
                            n6 = n4 - 1;
                            while (!this.cancelLoadingSources && n6 > n3) {
                                String string2;
                                Z80Disassembler.SourceLine sourceLine4 = (Z80Disassembler.SourceLine)list2.get(n6);
                                if (sourceLine4.getAddress() >= 0 || (string2 = Debugger.parseLabel(sourceLine4)) != null && string2.isEmpty()) break;
                                string.addFirst(sourceLine4);
                                --n6;
                            }
                            string.addLast((Z80Disassembler.SourceLine)sourceLine);
                            list.addAll(++n5, string);
                            bitSet.set(sourceLine.getAddress(), sourceLine.getAddress() + sourceLine.getSize());
                            n5 += string.size() - 1;
                        }
                    }
                    ++n4;
                }
            }
            if (this.cancelLoadingSources) {
                return;
            }
            ++n5;
        }
        ArrayList<Z80Disassembler.SourceLine> arrayList = new ArrayList<Z80Disassembler.SourceLine>();
        int n8 = 0;
        while (n8 < list2.size()) {
            Z80Disassembler.SourceLine sourceLine6 = (Z80Disassembler.SourceLine)list2.get(n8);
            if (sourceLine6.getAddress() >= 0) {
                n2 = bitSet.get(sourceLine6.getAddress(), sourceLine6.getAddress() + sourceLine6.getSize()).cardinality();
                if (n2 == 0) {
                    object = new ArrayDeque<Z80Disassembler.SourceLine>();
                    n4 = n8 - 1;
                    while (n4 > n3) {
                        sourceLine = (Z80Disassembler.SourceLine)list2.get(n4);
                        if (sourceLine.getAddress() >= 0) break;
                        object.addFirst(sourceLine);
                        String string = Debugger.parseLabel(sourceLine);
                        if (string != null && string.isEmpty()) break;
                        --n4;
                    }
                    object.addLast(sourceLine6);
                    arrayList.addAll((Collection<Z80Disassembler.SourceLine>)object);
                } else if (n2 < sourceLine6.getSize()) {
                    int n9 = sourceLine6.getAddress() + sourceLine6.getSize();
                    int n10 = sourceLine6.getAddress();
                    while (n10 < n9) {
                        if (!bitSet.get(n10)) {
                            int n11 = n10;
                            while (n11 < n9 && !bitSet.get(n11)) {
                                ++n11;
                            }
                            Z80Disassembler.writeSubDataBlockLine(arrayList, this.memory, ramRomMap, n10, n11, this.getLoadedSymbols());
                            n10 = n11 - 1;
                        }
                        ++n10;
                    }
                }
            }
            ++n8;
        }
        list.add(Z80Disassembler.SourceLine.EMPTY_LINE);
        if (n3 < list2.size()) {
            list.addAll(list2.subList(0, n3));
        }
        if (!arrayList.isEmpty()) {
            list.add(Z80Disassembler.SourceLine.EMPTY_LINE);
            list.addAll(arrayList);
        }
        this.updateRows(list);
        this.determineSections = false;
        this.systemDebugger.requestGUIupdate();
        this.systemDebugger.recreateInvalidBreakpoints();
        this.window.repaint();
    }

    private void updateDisassemblyLines() {
        this.updateDisassemblyLines(Integer.MAX_VALUE);
    }

    private void updateDisassemblyLines(int n) {
        int n2 = this.getVisibleAddress();
        int n3 = this.getSelectedAddress();
        AssemblerDialect assemblerDialect = Emulicious.getSelectedAssemblerDialect();
        this.updatingDisassembly = true;
        Z80Disassembler.loadCDBfileIfAvailable(Debugger.findSourceFile(true), Emulicious.getROMfile(), this.symbols, this.memory);
        this.updateRows(Z80Disassembler.generateLines(this.memory, this.systemDebugger.getRamRomMap(), this.getLoadedSymbols(), this.portNames, assemblerDialect, this.sectionProvider, n, this.properties.getInt("DisassemblerDsbBlockSize"), Boolean.parseBoolean(this.properties.getProperty("DisassemblerCreateLinkFile")), this.properties.getProperty("DisassemblerFormatCodeLabel"), this.properties.getProperty("DisassemblerFormatDataLabel"), this.properties.getProperty("DisassemblerFormatRAMlabel"), this.properties.getProperty("DisassemblerFormatSRAMlabel"), this.properties.getProperty("DisassemblerFormatPortLabel"), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerUseAnonymousLabels")), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerUseUpperCaseMnemonics")), Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerPadMnemonics"))));
        this.selectedWordStart = -1;
        this.selectedWordEnd = -1;
        if (forceLoadSources || this.sourceFile != null && this.sourceFile.exists()) {
            this.loadingSources = true;
            try {
                this.readAssemblyLines(Debugger.findSourceFile());
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.loadingSources = false;
        }
        this.updatingDisassembly = false;
        this.determineSections = true;
        this.systemDebugger.requestGUIupdate();
        this.setSelectedAddress(n3, false, false);
        this.scrollToVisible(n2);
        this.window.repaint();
    }

    private JTable createDisassemblerTable() {
        Object object;
        final JTable jTable = new JTable(new DisassemblerTableModel()){
            private boolean painting;
            {
                this.setIntercellSpacing(new Dimension());
            }

            @Override
            public void setUI(TableUI tableUI) {
                super.setUI(new BasicTableUI(){

                    @Override
                    public void installUI(JComponent jComponent) {
                        super.installUI(jComponent);
                        this.table.remove(this.rendererPane);
                        this.rendererPane = new CellRendererPane(){

                            @Override
                            public void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4, boolean bl) {
                                Point point = new Point(n, n2);
                                int n5 = this.rowAtPoint(point);
                                if (this.getValueAt(n5, 1) == Z80Disassembler.SourceLine.EMPTY_LINE) {
                                    n3 = point.x >= this.getColumnModel().getColumn(0).getWidth() ? 0 : n3 + this.getColumnModel().getColumn(1).getWidth();
                                }
                                super.paintComponent(graphics, component, container, n, n2, n3, n4, bl);
                            }
                        };
                        this.table.add(this.rendererPane);
                    }
                });
                if (Debugger.this.table != null) {
                    Debugger.this.packDisassemblerTable();
                    Debugger.this.updateHighlighter();
                }
            }

            @Override
            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                if (bl) {
                    return;
                }
                super.changeSelection(n, n2, bl, bl2);
            }

            @Override
            public void setFont(Font font) {
                super.setFont(FontUtilities.ensureMonospaceFont(font));
            }

            @Override
            public Color getForeground() {
                return Debugger.this.highlighter != null && Debugger.this.highlighter.getForeground() != null ? Debugger.this.highlighter.getForeground() : super.getForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return Debugger.this.highlighter != null && Debugger.this.highlighter.getSelectionForeground() != null ? Debugger.this.highlighter.getSelectionForeground() : super.getSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return Debugger.this.highlighter != null && Debugger.this.highlighter.getBackground() != null ? Debugger.this.highlighter.getBackground() : super.getBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return Debugger.this.highlighter != null && Debugger.this.highlighter.getSelectionBackground() != null ? Debugger.this.highlighter.getSelectionBackground() : super.getSelectionBackground();
            }

            @Override
            public Rectangle getCellRect(int n, int n2, boolean bl) {
                if (this.getValueAt(n, 1) == Z80Disassembler.SourceLine.EMPTY_LINE) {
                    Rectangle rectangle = super.getCellRect(n, n2, bl);
                    int n3 = this.getColumnModel().getColumn(1).getWidth();
                    if (n2 == 1) {
                        rectangle.x += n3;
                        rectangle.width = 0;
                    } else {
                        rectangle.width += n3;
                    }
                    return rectangle;
                }
                return super.getCellRect(n, n2, bl);
            }

            @Override
            public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
                return super.getScrollableBlockIncrement(rectangle, 1, n2);
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
                return super.getScrollableUnitIncrement(rectangle, 1, n2);
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                if (this.getToolTipText().length() <= 0) {
                    return null;
                }
                return super.getToolTipText(mouseEvent);
            }

            @Override
            public int rowAtPoint(Point point) {
                if (this.painting) {
                    int n = super.rowAtPoint(point);
                    if (n < 0 && point.y / this.getRowHeight() >= this.getRowCount()) {
                        return this.getRowCount() - 1;
                    }
                    return n;
                }
                return super.rowAtPoint(point);
            }

            @Override
            public int columnAtPoint(Point point) {
                if (this.painting) {
                    return -1;
                }
                return super.columnAtPoint(point);
            }

            @Override
            public void paint(Graphics graphics) {
                this.painting = true;
                super.paint(graphics);
                this.painting = false;
            }

            @Override
            public void scrollRectToVisible(final Rectangle rectangle) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.doScrollRectToVisible(rectangle);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            System.err.println("scrollRectToVisible called from the wrong thread");
                            this.doScrollRectToVisible(rectangle);
                        }
                    });
                }
            }

            private void doScrollRectToVisible(Rectangle rectangle) {
                if (!this.isValid()) {
                    this.getParent().validate();
                }
                super.scrollRectToVisible(rectangle);
            }
        };
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Debugger.this.updateToolBarButtons();
                Debugger.this.updateStatusBar();
            }
        });
        jTable.setAutoscrolls(false);
        jTable.setAutoResizeMode(3);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getButton();
                if (n >= 4) {
                    if ((n & 1) == 0) {
                        if ((mouseEvent.getModifiersEx() & 0x80) != 0) {
                            Debugger.this.prevAddress();
                        } else {
                            Debugger.this.navigateBack();
                        }
                        return;
                    }
                    if ((mouseEvent.getModifiersEx() & 0x80) != 0) {
                        Debugger.this.nextAddress();
                    } else {
                        Debugger.this.navigateForward();
                    }
                    return;
                }
                Debugger.this.selectWordAt(mouseEvent.getPoint());
                if (mouseEvent.isPopupTrigger()) {
                    Debugger.this.showPopupMenu(jTable, mouseEvent.getPoint());
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && (mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    int n2 = jTable.rowAtPoint(mouseEvent.getPoint());
                    jTable.getSelectionModel().setSelectionInterval(n2, n2);
                    Debugger.this.goToDestination(n2);
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0) {
                    Debugger.this.toggleBreakpoint(jTable.rowAtPoint(mouseEvent.getPoint()));
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    Debugger.this.selectWordAt(mouseEvent.getPoint());
                    Debugger.this.showPopupMenu(jTable, mouseEvent.getPoint());
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Debugger.this.clearAddressToHighlight();
                Debugger.this.window.setCursor(Cursor.getDefaultCursor());
            }
        });
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Debugger.this.selectedWordStart = -1;
                Debugger.this.selectedWordEnd = -1;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = Debugger.this.getSelectedAddress();
                if (n >= 0 && (n = Debugger.this.findLabelAddress(n)) >= 0) {
                    Debugger.this.outline.selectNodeByAddress(n);
                    return;
                }
                Debugger.this.outline.selectNodeByRow(jTable.getSelectedRow());
            }
        });
        jTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                String string;
                int n;
                int n2;
                if (Debugger.this.lines.size() <= 1) {
                    return;
                }
                RamRomMap ramRomMap = Debugger.this.systemDebugger.getRamRomMap();
                int n3 = jTable.rowAtPoint(mouseEvent.getPoint());
                int n4 = jTable.columnAtPoint(mouseEvent.getPoint());
                Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)jTable.getModel().getValueAt(n3, n4);
                int n5 = Debugger.this.getDestination(n3);
                jTable.setToolTipText("");
                if (sourceLine.getInstruction() != null) {
                    if (sourceLine.getInstruction().isBranch() && Debugger.this.hasLabel(n5) || sourceLine.getInstruction().isRet()) {
                        String string2 = Debugger.this.getLabel(n5);
                        if (string2 != null) {
                            jTable.setToolTipText(String.format("%s = $%04X", string2, n5 < 0 ? Debugger.this.systemDebugger.convertAddress(n5) : n5));
                        }
                    } else {
                        String string3 = Debugger.this.getOperandAt(mouseEvent.getPoint());
                        if (string3 != null && !string3.isEmpty() && string3.charAt(0) != '$' && !Character.isDigit(0)) {
                            if (string3.length() == 1) {
                                try {
                                    jTable.setToolTipText(String.format("%s = $%02X", string3, new Expression(Debugger.this.systemDebugger, string3).getValue()));
                                }
                                catch (UnknownVariableException unknownVariableException) {
                                }
                                catch (ParseException parseException) {}
                            } else if (string3.length() <= 3) {
                                try {
                                    jTable.setToolTipText(String.format("<html>%s = $%04X<br />@%s = $%02X</html>", string3, new Expression(Debugger.this.systemDebugger, string3).getValue(), string3, new Expression(Debugger.this.systemDebugger, "@" + string3).getValue()));
                                }
                                catch (UnknownVariableException unknownVariableException) {
                                }
                                catch (ParseException parseException) {}
                            }
                            if (jTable.getToolTipText() == "") {
                                if (sourceLine.getInstruction().hasArg() && Debugger.this.systemDebugger.isRAMaddress(sourceLine.getInstruction().getArg())) {
                                    jTable.setToolTipText(String.format("<html>%s = $%04X<br />@%s = $%02X</html>", string3, sourceLine.getInstruction().getArg(), string3, Debugger.this.systemDebugger.peekByte(sourceLine.getInstruction().getArg())));
                                } else if (sourceLine.getInstruction().hasDestination()) {
                                    jTable.setToolTipText(String.format("<html>%s = $%04X<br />@%s = $%02X</html>", string3, sourceLine.getInstruction().getDestination(sourceLine.getAddress(), sourceLine.getAddress() / 16384), string3, Debugger.this.systemDebugger.peekByte(sourceLine.getInstruction().getDestination(sourceLine.getAddress(), sourceLine.getAddress() / 16384))));
                                }
                            }
                        }
                    }
                } else if (Debugger.getDataSize(sourceLine) == 2 && Debugger.this.getAddressAt(mouseEvent.getPoint()) >= 0 && Debugger.this.hasLabel(n5 = Z80Disassembler.getDestination(n2 = Debugger.this.getAddressAt(mouseEvent.getPoint()), ramRomMap, n = Debugger.this.READ_WORD(n2)))) {
                    jTable.setToolTipText(String.format("%s = $%04X", Debugger.this.getLabel(n5), n5));
                }
                if ((string = Debugger.this.getWordAt(mouseEvent.getPoint())) != null && !string.isEmpty()) {
                    Debugger.this.window.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    Debugger.this.window.setCursor(Cursor.getDefaultCursor());
                }
                Debugger.this.setAddressToHighlight(n5, Debugger.this.isRomRow(n3) ? sourceLine.getAddress() : Debugger.this.systemDebugger.convertAddress(sourceLine.getAddress()));
            }
        });
        Object[] objectArray = jTable.getActionMap().getParent().keys();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            Action action = jTable.getActionMap().getParent().get(object);
            if (action.equals(jTable.getActionForKeyStroke(KeyStroke.getKeyStroke(119, 0))) || action.equals(jTable.getActionForKeyStroke(KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()))) || action.equals(jTable.getActionForKeyStroke(KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())))) {
                jTable.getActionMap().getParent().remove(object);
            }
            ++n2;
        }
        object = jTable.getInputMap(1);
        while (object != null) {
            ((InputMap)object).remove(KeyStroke.getKeyStroke(113, 0));
            object = ((InputMap)object).getParent();
        }
        Debugger.restoreTraversalKeys(jTable);
        jTable.getInputMap().put(KeyStroke.getKeyStroke("PAGE_UP"), "scrollPageUp");
        jTable.getActionMap().put("scrollPageUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = jTable.getVisibleRect();
                rectangle.y -= rectangle.height;
                jTable.scrollRectToVisible(rectangle);
            }
        });
        jTable.getInputMap().put(KeyStroke.getKeyStroke("PAGE_DOWN"), "scrollPageDown");
        jTable.getActionMap().put("scrollPageDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = jTable.getVisibleRect();
                rectangle.y += rectangle.height;
                jTable.scrollRectToVisible(rectangle);
            }
        });
        jTable.getInputMap().put(KeyStroke.getKeyStroke("UP"), "selectPreviousLine");
        jTable.getActionMap().put("selectPreviousLine", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.getSelectedRow();
                if (n < 0) {
                    Rectangle rectangle = jTable.getVisibleRect();
                    rectangle.y -= jTable.getCellRect((int)0, (int)0, (boolean)true).height;
                    jTable.scrollRectToVisible(rectangle);
                } else if (--n >= 0) {
                    jTable.getSelectionModel().setSelectionInterval(n, n);
                    jTable.scrollRectToVisible(jTable.getCellRect(n, 0, true));
                }
            }
        });
        jTable.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "selectNextLine");
        jTable.getActionMap().put("selectNextLine", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.getSelectedRow();
                if (n < 0) {
                    Rectangle rectangle = jTable.getVisibleRect();
                    rectangle.y += jTable.getCellRect((int)0, (int)0, (boolean)true).height;
                    jTable.scrollRectToVisible(rectangle);
                } else if (++n < jTable.getRowCount()) {
                    jTable.getSelectionModel().setSelectionInterval(n, n);
                    jTable.scrollRectToVisible(jTable.getCellRect(n, 0, true));
                }
            }
        });
        jTable.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "selectPreviousByte");
        jTable.getActionMap().put("selectPreviousByte", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Debugger.this.getSelectedAddress();
                if (n > 0) {
                    Debugger.this.setSelectedAddress(n - 1);
                }
            }
        });
        jTable.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "selectNextByte");
        jTable.getActionMap().put("selectNextByte", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Debugger.this.getSelectedAddress();
                if (n >= 0) {
                    Debugger.this.setSelectedAddress(n + 1);
                }
            }
        });
        jTable.getActionMap().put("profileFromLine", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Debugger.this.getSelectedAddress();
                if (n >= 0) {
                    Symbols.Symbol symbol = Symbols.findSymbol(n, Debugger.this.getLoadedSymbols());
                    if (symbol != null) {
                        ProfilerWindow.addProfiler(Debugger.this.window, Debugger.this, Debugger.this.prfFile, symbol.getLabel());
                    } else {
                        ProfilerWindow.addProfiler(Debugger.this.window, Debugger.this, Debugger.this.prfFile, Integer.toHexString(n));
                    }
                }
            }
        });
        jTable.getActionMap().put("profileToNextLine", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)jTable.getModel().getValueAt(jTable.getSelectedRow(), 1);
                if (sourceLine != null && (n = sourceLine.getAddress()) >= 0) {
                    Symbols.Symbol symbol = Symbols.findSymbol(n, Debugger.this.getLoadedSymbols());
                    if (symbol != null) {
                        try {
                            Debugger.this.parseExpression(symbol.getLabel());
                        }
                        catch (Exception exception) {
                            symbol = null;
                        }
                    }
                    if (symbol != null) {
                        ProfilerWindow.addProfiler(Debugger.this.window, Debugger.this, Debugger.this.prfFile, symbol.getLabel(), Integer.toHexString(n + sourceLine.getSize()));
                    } else {
                        ProfilerWindow.addProfiler(Debugger.this.window, Debugger.this, Debugger.this.prfFile, Integer.toHexString(n), Integer.toHexString(n + sourceLine.getSize()));
                    }
                }
            }
        });
        jTable.getActionMap().put("traceFromLine", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Debugger.this.getSelectedAddress();
                if (n >= 0) {
                    Symbols.Symbol symbol = Symbols.findSymbol(n, Debugger.this.getLoadedSymbols());
                    if (symbol != null) {
                        TracerWindow.startTracing(Debugger.this.window, Debugger.this, Debugger.this.systemDebugger, symbol.getLabel());
                    } else {
                        TracerWindow.startTracing(Debugger.this.window, Debugger.this, Debugger.this.systemDebugger, "$" + Integer.toHexString(n));
                    }
                }
            }
        });
        jTable.setTableHeader(null);
        jTable.setShowGrid(false);
        jTable.setFillsViewportHeight(true);
        return jTable;
    }

    private static void restoreTraversalKeys(JTable jTable) {
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(jTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke("TAB"));
        jTable.setFocusTraversalKeys(0, hashSet);
        HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>(jTable.getFocusTraversalKeys(1));
        hashSet2.add(KeyStroke.getKeyStroke("shift TAB"));
        jTable.setFocusTraversalKeys(1, hashSet2);
    }

    private JLabel createRuler(final JTable jTable) {
        return new JLabel(){
            private Color background;
            {
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0) {
                            Debugger.this.toggleBreakpoint(mouseEvent.getY() / jTable2.getRowHeight());
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        if (mouseEvent.isPopupTrigger()) {
                            Component component = (Component)mouseEvent.getSource();
                            Debugger.this.showBreakpointPopupMenu(component, mouseEvent.getPoint());
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        if (mouseEvent.isPopupTrigger()) {
                            Component component = (Component)mouseEvent.getSource();
                            Debugger.this.showBreakpointPopupMenu(component, mouseEvent.getPoint());
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                });
                this.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent mouseEvent) {
                        if (Debugger.this.getBreakpointAt(mouseEvent.getPoint()) != null) {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                        } else {
                            this.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                });
            }

            @Override
            public Color getBackground() {
                Color color = super.getBackground();
                Color color2 = jTable.getBackground();
                if (color != null && color.getRed() > color2.getRed()) {
                    if (this.background == null) {
                        this.background = new Color((int)((double)color2.getRed() * 0.85), (int)((double)color2.getGreen() * 0.85), (int)((double)color2.getBlue() * 0.85));
                    }
                    return this.background;
                }
                return color;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                int n;
                int n2;
                int n3;
                int n4;
                Object object;
                super.paintComponent(graphics);
                if (Debugger.this.lines == DISASSEMBLING) {
                    return;
                }
                if (Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerShowCoverage"))) {
                    int n5 = jTable.getRowHeight();
                    object = graphics.getClipBounds();
                    int n6 = ((Rectangle)object).y / n5;
                    int n7 = (((Rectangle)object).y + ((Rectangle)object).height - 1) / n5;
                    n4 = this.getWidth();
                    n3 = n4 / 2;
                    n2 = n4 - n3;
                    n = n6;
                    while (n <= n7) {
                        Color color = Debugger.this.getCoverageColor(n);
                        if (color != null) {
                            graphics.setColor(color);
                            graphics.fillRect(n2, n * n5, n3, n5);
                        }
                        ++n;
                    }
                }
                try {
                    for (Breakpoint breakpoint : Debugger.this.getBreakpoints()) {
                        if (Debugger.this.isROMbreakpoint(breakpoint)) {
                            if (breakpoint instanceof Watchpoint) {
                                graphics.setColor(Color.GREEN);
                            } else {
                                graphics.setColor(Color.RED);
                            }
                            try {
                                int n8 = Debugger.this.tableRows[breakpoint.getAddress()];
                                int n9 = breakpoint.getEnd() < Debugger.this.tableRows.length ? Debugger.this.tableRows[breakpoint.getEnd()] : n8;
                                this.paintBreakpoint(graphics, breakpoint.isEnabled(), n8, n9);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        graphics.setColor(Color.GREEN);
                        try {
                            String string;
                            if (Debugger.this.isRAMbreakpoint(breakpoint)) {
                                int n10 = Debugger.this.getRamRows().get(breakpoint.getAddress());
                                if (n10 == Integer.MIN_VALUE) {
                                    n10 = -1;
                                }
                                int n11 = n10;
                                if (breakpoint.getEnd() < Debugger.this.tableRows.length && (n4 = Debugger.this.getRamRows().get(breakpoint.getEnd())) != Integer.MIN_VALUE) {
                                    n11 = n4;
                                }
                                this.paintBreakpoint(graphics, breakpoint.isEnabled(), n10, n11);
                                continue;
                            }
                            if (Debugger.this.isSRAMbreakpoint(breakpoint)) {
                                int n12 = Debugger.this.getSramRows().get(breakpoint.getAddress());
                                if (n12 == Integer.MIN_VALUE) {
                                    n12 = -1;
                                }
                                int n13 = n12;
                                if (breakpoint.getEnd() < Debugger.this.tableRows.length && (n4 = Debugger.this.getSramRows().get(breakpoint.getEnd())) != Integer.MIN_VALUE) {
                                    n13 = n4;
                                }
                                this.paintBreakpoint(graphics, breakpoint.isEnabled(), n12, n13);
                                continue;
                            }
                            if (Debugger.this.isPortBreakpoint(breakpoint)) {
                                int n14 = Debugger.this.getPortRows().get(breakpoint.getAddress());
                                if (n14 == Integer.MIN_VALUE) {
                                    n14 = -1;
                                }
                                int n15 = n14;
                                if (breakpoint.getEnd() < Debugger.this.tableRows.length && (n4 = Debugger.this.getPortRows().get(breakpoint.getEnd())) != Integer.MIN_VALUE) {
                                    n15 = n4;
                                }
                                this.paintBreakpoint(graphics, breakpoint.isEnabled(), n14, n15);
                                continue;
                            }
                            if (!Debugger.this.isCpuBreakpoint(breakpoint)) continue;
                            IntBiMap intBiMap = Debugger.this.systemDebugger.isRAMaddress(breakpoint.getAddress()) ? Debugger.this.getRamRows() : (Debugger.this.systemDebugger.isSRAMaddress(breakpoint.getAddress()) ? Debugger.this.getSramRows() : Debugger.this.getPortRows());
                            n4 = intBiMap.get((string = Debugger.this.systemDebugger.getAdditionalMemoryLocationAt(breakpoint.getAddress())) == null ? Debugger.this.systemDebugger.mapAddress(breakpoint.getAddress()) : breakpoint.getAddress());
                            if (n4 == Integer.MIN_VALUE) {
                                n4 = -1;
                            }
                            n3 = n4;
                            n2 = intBiMap.get(string == null ? Debugger.this.systemDebugger.mapAddress(breakpoint.getEnd()) : breakpoint.getAddress());
                            if (n2 != Integer.MIN_VALUE) {
                                n3 = n2;
                            }
                            this.paintBreakpoint(graphics, breakpoint.isEnabled(), n4, n3);
                            n4 = Debugger.this.getCpuRow(breakpoint.getAddress());
                            if (((Z80Disassembler.SourceLine)debugger.table.getValueAt(n4, 1)).getInstruction() != null) {
                                graphics.setColor(Color.RED);
                            }
                            n3 = Debugger.this.getCpuRow(breakpoint.getEnd());
                            this.paintBreakpoint(graphics, breakpoint.isEnabled(), n4, n3);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    this.repaint();
                    return;
                }
                int n16 = jTable.getRowHeight();
                object = Debugger.this.getSourceLine(Debugger.this.address);
                if (object != null && Debugger.this.address >= ((Z80Disassembler.SourceLine)object).getAddress() && Debugger.this.address < ((Z80Disassembler.SourceLine)object).getAddress() + ((Z80Disassembler.SourceLine)object).getSize()) {
                    int n17 = (int)((float)Math.min(n16, this.getWidth()) * 0.6f);
                    Rectangle rectangle = graphics.getClipBounds();
                    n4 = Math.max(0, this.getWidth() / 2 - n17 / 2);
                    this.paintCurrentInstructionCursor(graphics, Debugger.this.tableRows[Debugger.this.address], n16, n17, n4, rectangle);
                }
                if ((object = (Z80Disassembler.SourceLine)jTable.getValueAt(Debugger.this.getCpuRow(Debugger.this.pc), 1)) != null && Debugger.this.pc >= ((Z80Disassembler.SourceLine)object).getAddress() && Debugger.this.pc < ((Z80Disassembler.SourceLine)object).getAddress() + ((Z80Disassembler.SourceLine)object).getSize()) {
                    int n18 = (int)((float)Math.min(n16, this.getWidth()) * 0.6f);
                    Rectangle rectangle = graphics.getClipBounds();
                    n4 = Math.max(0, this.getWidth() / 2 - n18 / 2);
                    this.paintCurrentInstructionCursor(graphics, Debugger.this.getCpuRow(Debugger.this.pc), n16, n18, n4, rectangle);
                }
                int n19 = Debugger.this.flowArrowModel.getArrowCount();
                int n20 = 0;
                while (n20 < n19) {
                    graphics.setColor(Debugger.this.flowArrowModel.getArrowColor(n20));
                    n4 = Debugger.this.flowArrowModel.getArrowSourceRow(n20);
                    n3 = Debugger.this.flowArrowModel.getArrowDestinationRow(n20);
                    n2 = n4 * n16 + n16 / 2 + n16 / 4;
                    n = n3 * n16 + n16 / 2 - n16 / 4;
                    int n21 = this.getWidth() / 2;
                    int n22 = n21 - n21 / 2 - n20;
                    int n23 = (int)((float)Math.min(n16, this.getWidth()) * 0.5f);
                    graphics.drawLine(n22, n2, this.getWidth(), n2);
                    graphics.drawLine(n22, n2, n22, n);
                    graphics.drawLine(n22, n, this.getWidth(), n);
                    graphics.fillPolygon(new int[]{this.getWidth() - n23, this.getWidth() - n23, this.getWidth()}, new int[]{n - n23 / 2, n + n23 / 2, n}, 3);
                    ++n20;
                }
            }

            private void paintCurrentInstructionCursor(Graphics graphics, int n, int n2, int n3, int n4, Rectangle rectangle) {
                if (Debugger.this.systemDebugger.isBreakpointHit()) {
                    graphics.setColor(Color.RED);
                } else {
                    graphics.setColor(Debugger.this.getCurrentLineBackground());
                }
                int n5 = (int)((float)n2 * ((float)n + 0.5f) + 0.5f) - 1;
                if (n5 + n3 / 2 >= rectangle.y && n5 - n3 / 2 < rectangle.y + rectangle.height) {
                    int[] nArray = new int[]{n4 + 4, n4 + 4, n4 + n3};
                    int[] nArray2 = new int[]{n5 - n3 / 2, n5 + n3 / 2, n5};
                    Color color = graphics.getColor();
                    Color color2 = color.darker();
                    graphics.fillPolygon(nArray, nArray2, nArray.length);
                    graphics.setColor(color2);
                    graphics.drawPolygon(nArray, nArray2, nArray.length);
                    graphics.setColor(color2);
                    graphics.drawRect(n4, n5 - 2, 4, 4);
                    graphics.setColor(color);
                    graphics.fillRect(n4 + 1, n5 - 2 + 1, 4, 3);
                }
            }

            private void paintBreakpoint(Graphics graphics, boolean bl, int n, int n2) {
                int n3 = (int)((float)Math.min(jTable.getRowHeight(), this.getWidth()) * 0.6f);
                Rectangle rectangle = graphics.getClipBounds();
                int n4 = Math.max(0, this.getWidth() / 2 - n3 / 2);
                int n5 = (int)((float)jTable.getRowHeight() * ((float)n + 0.5f) + 0.5f) - 1;
                if (n5 + n3 / 2 + jTable.getRowHeight() * (n2 - n) < rectangle.y || n5 - n3 / 2 >= rectangle.y + rectangle.height) {
                    return;
                }
                if (!Debugger.this.skipBreakpoints.isSelected() && bl) {
                    graphics.fillOval(n4, n5 - n3 / 2, n3, n3);
                    Color color = graphics.getColor();
                    graphics.setColor(color.darker());
                    graphics.drawOval(n4, n5 - n3 / 2, n3, n3);
                    graphics.setColor(color);
                    if (n2 != n) {
                        graphics.fillRect(n4 + n3 / 2, n5, 3, jTable.getRowHeight() * (n2 - n));
                    }
                } else {
                    graphics.drawOval(n4, n5 - n3 / 2, n3, n3);
                    if (n2 != n) {
                        graphics.drawRect(n4 + n3 / 2, n5, 3, jTable.getRowHeight() * (n2 - n));
                    }
                }
                if (Debugger.this.skipBreakpoints.isSelected()) {
                    graphics.setColor(Color.DARK_GRAY);
                    graphics.drawLine(n4, n5 - n3 / 2, n4 + n3, n5 + n3 / 2);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(jTable.getRowHeight(), jTable.getPreferredSize().height);
            }
        };
    }

    private JLabel createOverviewRuler(final JScrollBar jScrollBar, final JTable jTable, final JLabel jLabel) {
        final Properties properties = this.properties;
        return new JLabel(){
            private final HashIntMap traceCache = new HashIntMap();
            {
                MouseAdapter mouseAdapter = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                            int n = this.rowAt(mouseEvent.getY());
                            if (n < 0) {
                                return;
                            }
                            int n2 = this.findAnnotation(n);
                            if (n2 < 0) {
                                n2 = this.findAnnotation(n - 1);
                            }
                            if (n2 < 0) {
                                n2 = this.findAnnotation(n + 1);
                            }
                            if (n2 < 0) {
                                n2 = this.toTableRow(n);
                            }
                            if (n2 >= 0) {
                                jTable2.getSelectionModel().setSelectionInterval(n2, n2);
                                Debugger.this.scrollRowToVisible(n2);
                            }
                        }
                    }

                    @Override
                    public void mouseDragged(MouseEvent mouseEvent) {
                        this.mousePressed(mouseEvent);
                    }

                    @Override
                    public void mouseMoved(MouseEvent mouseEvent) {
                        int n = this.rowAt(mouseEvent.getY());
                        if (n < 0) {
                            this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                        int n2 = this.findAnnotation(n);
                        if (n2 < 0) {
                            n2 = this.findAnnotation(n - 1);
                        }
                        if (n2 < 0) {
                            n2 = this.findAnnotation(n + 1);
                        }
                        if (n2 >= 0) {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                        } else {
                            this.setCursor(Cursor.getDefaultCursor());
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                };
                this.addMouseListener(mouseAdapter);
                this.addMouseMotionListener(mouseAdapter);
                this.setOpaque(true);
            }

            private int getRowCount() {
                return jScrollBar.getHeight() - jScrollBar.getWidth() * 2;
            }

            private int rowAt(int n) {
                Rectangle rectangle = jScrollBar.getBounds();
                if (n < rectangle.y + rectangle.width || n >= rectangle.y + rectangle.height - rectangle.width) {
                    return -1;
                }
                return n -= rectangle.y + rectangle.width;
            }

            private int toTableRow(int n) {
                if (n < 0) {
                    return -1;
                }
                return (int)((float)n * ((float)jTable.getRowCount() / (float)this.getRowCount()));
            }

            private int toRulerRow(int n) {
                if (n < 0) {
                    return -1;
                }
                return (int)((float)n / ((float)jTable.getRowCount() / (float)this.getRowCount()));
            }

            private void paintRow(Graphics graphics, int n, Color color) {
                Rectangle rectangle = jScrollBar.getBounds();
                graphics.setColor(color);
                graphics.fillRect(1, n + rectangle.y + rectangle.width, this.getWidth() - 1, 1);
            }

            private void fillTraceCache() {
                CyclicIntStack cyclicIntStack = Debugger.this.getTrace();
                int n = cyclicIntStack.size();
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4;
                    int n5;
                    int n6 = cyclicIntStack.get(n2);
                    int n7 = n5 = n6 >= 0 ? n6 : Debugger.this.systemDebugger.convertAddress(n6);
                    if (n5 < 0) break;
                    if (n5 < Debugger.this.tableRows.length && !this.traceCache.containsKey(n4 = this.toRulerRow(n3 = n6 >= 0 ? Debugger.this.tableRows[n5] : Debugger.this.getCpuRow(n5)))) {
                        this.traceCache.put(n4, n3);
                    }
                    ++n2;
                }
            }

            private int findAnnotation(int n) {
                int n2;
                int n3;
                int n4 = this.toTableRow(n);
                int n5 = this.toTableRow(n + 1);
                boolean bl = Debugger.this.isRomRow(n4);
                int n6 = n3 = bl ? Debugger.this.address : Debugger.this.systemDebugger.convertAddress(Debugger.this.address);
                if (n3 >= 0) {
                    int n7 = n2 = bl ? Debugger.this.tableRows[n3] : Debugger.this.getCpuRow(n3);
                    if (n2 >= n4 && n2 < n5) {
                        return n2;
                    }
                }
                if (Debugger.this.systemDebugger.isSuspended() && Boolean.parseBoolean(properties.getProperty("DebuggerHighlightTrace"))) {
                    if (this.traceCache.isEmpty()) {
                        this.fillTraceCache();
                    }
                    if ((n2 = this.traceCache.get(n)) != Integer.MIN_VALUE) {
                        return n2;
                    }
                }
                if (Debugger.this.systemDebugger.hasCoverageData() && Boolean.parseBoolean(properties.getProperty("DebuggerShowCoverage"))) {
                    n2 = n4;
                    while (n2 < n5) {
                        Color color = Debugger.this.getCoverageColor(n2);
                        if (color != null) {
                            return n2;
                        }
                        ++n2;
                    }
                }
                return -1;
            }

            @Override
            public Color getBackground() {
                return jLabel.getBackground();
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                boolean bl = Debugger.this.systemDebugger.isSuspended() && Boolean.parseBoolean(properties.getProperty("DebuggerHighlightTrace"));
                boolean bl2 = Debugger.this.systemDebugger.hasCoverageData() && Boolean.parseBoolean(properties.getProperty("DebuggerShowCoverage"));
                this.traceCache.clear();
                int n = 0;
                while (n < this.getRowCount()) {
                    int n2 = this.findAnnotation(n);
                    if (n2 >= 0) {
                        Object object;
                        Z80Disassembler.SourceLine sourceLine;
                        boolean bl3 = Debugger.this.isRomRow(this.toTableRow(n));
                        int n3 = bl3 ? Debugger.this.address : Debugger.this.systemDebugger.convertAddress(Debugger.this.address);
                        if (n3 >= (sourceLine = (Z80Disassembler.SourceLine)jTable.getValueAt(n2, 1)).getAddress() && n3 < sourceLine.getAddress() + sourceLine.getSize()) {
                            this.paintRow(graphics, n, Debugger.this.getCurrentLineBackground());
                        } else if (bl) {
                            Color color;
                            object = Debugger.this.getTrace();
                            int n4 = ((CyclicIntStack)object).indexOf(bl3 ? sourceLine.getAddress() : Debugger.this.systemDebugger.convertAddress(sourceLine.getAddress()));
                            int n5 = ((CyclicIntStack)object).size();
                            if (n4 >= 0) {
                                this.paintRow(graphics, n, Debugger.this.getColorTrace(n4 * (COLORS_TRACE.length - 1) / (n5 - 1)));
                            } else if (bl2 && (color = Debugger.this.getCoverageColor(n2)) != null) {
                                this.paintRow(graphics, n, color);
                            }
                        } else if (bl2 && (object = Debugger.this.getCoverageColor(n2)) != null) {
                            this.paintRow(graphics, n, (Color)object);
                        }
                    }
                    ++n;
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(jLabel.getPreferredSize().width, jScrollBar.getHeight());
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
    }

    CyclicIntStack getTrace() {
        CyclicIntStack cyclicIntStack;
        if (TracerWindow.isTracing() && (cyclicIntStack = TracerWindow.getAddresses()).get(0) >= 0 && cyclicIntStack.get(1) >= 0 && cyclicIntStack.get(2) >= 0) {
            return cyclicIntStack;
        }
        return this.systemDebugger.getTrace();
    }

    void updateHighlighter() {
        File file = Emulicious.getSelectedHighlighter();
        if (file != null) {
            if (!file.equals(this.highlighterFile)) {
                this.highlighterFile = file;
                try {
                    String string = this.highlighterFile.getName().toLowerCase();
                    if (string.endsWith(".chl")) {
                        this.highlighter = ConTEXTHighlighter.loadFromFile(this.highlighterFile);
                    } else if (string.endsWith(".xml")) {
                        this.highlighter = NotepadPlusPlusHighlighter.loadFromFile(this.highlighterFile);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        } else {
            this.highlighter = null;
            this.highlighterFile = null;
        }
        this.updateMemoryEditorColors();
        this.updateCurrentLineBackground();
        this.window.repaint();
    }

    private void updateMemoryEditorColors() {
        if (this.memoryEditor != null && this.table != null) {
            Color color = this.table.getForeground();
            this.memoryEditor.setEditorForeground(color);
            Color color2 = this.table.getBackground();
            this.memoryEditor.setEditorBackground(color2);
            this.memoryEditor.setSelectionForeground(new Color(color.getRed() ^ 0xFF, color.getGreen() ^ 0xFF, color.getBlue() ^ 0xFF));
            this.memoryEditor.setSelectionBackground(new Color(color2.getRed() ^ 0xFF, color2.getGreen() ^ 0xFF, color2.getBlue() ^ 0xFF));
            this.memoryEditor.getStatusBarLabel().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, color), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
        }
    }

    void clearAddressToHighlight() {
        this.setAddressToHighlight(-1, -1);
    }

    void setAddressToHighlight(int n, int n2) {
        Rectangle rectangle;
        Rectangle rectangle2;
        Rectangle rectangle3;
        int n3;
        int n4;
        boolean bl;
        boolean bl2 = n2 >= 0;
        boolean bl3 = bl = n >= 0;
        if (!bl2 && this.systemDebugger != null) {
            n2 = this.systemDebugger.convertAddress(n2);
        }
        if (!bl && this.systemDebugger != null) {
            n = this.systemDebugger.convertAddress(n);
        }
        int n5 = bl2 ? (n2 < this.tableRows.length ? this.tableRows[n2] : -1) : (n4 = this.getCpuRow(n2));
        int n6 = bl ? (n < this.tableRows.length ? this.tableRows[n] : -1) : (n3 = this.getCpuRow(n));
        if (n3 == this.addressToHighlightDestinationRow && n4 == this.addressToHighlightSourceRow) {
            return;
        }
        if (this.addressToHighlightDestinationRow >= 0) {
            rectangle3 = this.table.getCellRect(this.addressToHighlightDestinationRow, 0, false);
            rectangle3.x = 0;
            rectangle3.width = this.table.getWidth();
            this.table.repaint(rectangle3);
            if (this.addressToHighlightSourceRow >= 0) {
                rectangle2 = this.table.getCellRect(this.addressToHighlightSourceRow, 0, true);
                rectangle = this.table.getCellRect(this.addressToHighlightDestinationRow, 0, true);
                rectangle.x = 0;
                rectangle.width = this.ruler.getWidth();
                rectangle.height += Math.abs(rectangle.y - rectangle2.y);
                rectangle.y = Math.min(rectangle2.y, rectangle.y);
                this.ruler.repaint(rectangle);
            }
        }
        this.addressToHighlightDestinationRow = n3;
        this.addressToHighlightSourceRow = n4;
        if (n3 >= 0) {
            rectangle3 = this.table.getCellRect(n3, 0, false);
            rectangle3.x = 0;
            rectangle3.width = this.table.getWidth();
            this.table.repaint(rectangle3);
            if (n4 >= 0) {
                rectangle2 = this.table.getCellRect(n4, 0, true);
                rectangle = this.table.getCellRect(n3, 0, true);
                rectangle.x = 0;
                rectangle.width = this.ruler.getWidth();
                rectangle.height += Math.abs(rectangle.y - rectangle2.y);
                rectangle.y = Math.min(rectangle2.y, rectangle.y);
                this.ruler.repaint(rectangle);
            }
        }
        this.repaintFlowArrows();
    }

    void repaintFlowArrows() {
        int n = this.flowArrowModel.getArrowCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle(this.ruler.getWidth(), 0);
        int n2 = this.table.getRowHeight();
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.flowArrowModel.getArrowSourceRow(n3);
            int n5 = this.flowArrowModel.getArrowDestinationRow(n3);
            int n6 = n4 * n2 + n2 / 2 + n2 / 4;
            int n7 = n5 * n2 + n2 / 2 - n2 / 4;
            int n8 = (int)((float)Math.min(n2, this.getWidth()) * 0.5f);
            int n9 = Math.min(n6, n7 - n8 / 2);
            int n10 = Math.max(n6, n7 + n8 / 2);
            rectangle.setBounds(0, n9, rectangle2.width, n10 - n9);
            Rectangle2D.union(rectangle2, rectangle, rectangle2);
            ++n3;
        }
        this.ruler.repaint(rectangle2);
    }

    private void packDisassemblerTable() {
        final JTable jTable = this.table;
        final JLabel jLabel = this.overviewRuler;
        final int n = this.getVisibleAddress();
        Dimension dimension = jTable.getCellRenderer(0, 0).getTableCellRendererComponent(jTable, jTable.getValueAt(0, 0), false, false, 0, 0).getPreferredSize();
        if (dimension.height > 0) {
            jTable.setRowHeight(dimension.height);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n7 = 0;
                int n2 = 1;
                int n3 = 1;
                Debugger.this.highlighting = false;
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(0, 0);
                int n4 = -1;
                int n5 = 0;
                while (n5 <= 512 && n5 < Debugger.this.tableRows.length) {
                    int n6 = Debugger.this.tableRows[n5];
                    if (n6 != 0 && n6 != n4) {
                        Dimension dimension = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(n6, 0), false, false, n6, 0).getPreferredSize();
                        n2 = Math.max(n2, (int)((float)dimension.width * 1.05f));
                        Dimension dimension2 = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(n6, 1), false, false, n6, 1).getPreferredSize();
                        n3 = Math.max(n3, dimension2.width);
                        n7 = Math.max(n7, dimension2.height);
                        n4 = n6;
                    }
                    ++n5;
                }
                n3 = Math.max(n3, jTable.getWidth() - n2);
                Debugger.this.highlighting = Boolean.parseBoolean(Debugger.this.properties.getProperty("Highlighting"));
                jTable.setAutoResizeMode(0);
                if (n7 <= 0) {
                    return;
                }
                TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
                TableColumn tableColumn2 = jTable.getColumnModel().getColumn(1);
                tableColumn.setMaxWidth(Integer.MAX_VALUE);
                tableColumn.setMinWidth(n2);
                tableColumn.setMaxWidth(n2);
                tableColumn.setPreferredWidth(n2);
                tableColumn2.setPreferredWidth(n3);
                jTable.setRowHeight(n7);
                if (jLabel != null) {
                    jLabel.revalidate();
                }
                if (Debugger.isSuspended() && Debugger.this.systemDebugger.isBiosSkipped() && Debugger.this.getVisibleAddress() != Debugger.this.address) {
                    if (n >= 0 || Debugger.this.systemDebugger.convertAddress(n) >= 0) {
                        Debugger.this.scrollToVisible(n);
                    } else {
                        Debugger.this.scrollCurrentInstructionToVisible();
                    }
                }
            }
        });
    }

    private void resizeColumn(int n, Dimension dimension) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        int n2 = dimension.width + this.table.getIntercellSpacing().width;
        if (n == 0) {
            tableColumn.setMaxWidth(Integer.MAX_VALUE);
            tableColumn.setMaxWidth(n2);
            tableColumn.setMinWidth(n2);
        }
        tableColumn.setPreferredWidth(n2);
    }

    private boolean isWordSelected() {
        return this.selectedWordEnd > this.selectedWordStart;
    }

    void selectWordAt(Point point) {
        int n = this.table.rowAtPoint(point);
        Rectangle rectangle = this.table.getCellRect(n, 1, true);
        int n2 = point.x - rectangle.x;
        FontMetrics fontMetrics = this.table.getFontMetrics(this.table.getFont());
        this.selectWordAt(n, n2 / fontMetrics.charWidth('A'));
    }

    private boolean isRowSelected(int n) {
        int[] nArray = this.table.getSelectedRows();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            if (n4 == n) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private String getOperandAt(Point point) {
        int n = this.table.rowAtPoint(point);
        Rectangle rectangle = this.table.getCellRect(n, 1, true);
        int n2 = point.x - rectangle.x;
        FontMetrics fontMetrics = this.table.getFontMetrics(this.table.getFont());
        return this.getOperandAt(n, n2 / fontMetrics.charWidth('A'));
    }

    private String getOperandAt(int n, int n2) {
        if (n < 0 || n >= this.table.getRowCount() || n2 < 0) {
            return null;
        }
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(n, 1);
        String string = sourceLine.toString().replace("\t", "    ");
        if (string.indexOf(59) >= 0) {
            string = string.substring(0, string.indexOf(59));
        }
        if (n2 >= string.length()) {
            return null;
        }
        int n3 = n2;
        while (n3 > 0 && string.charAt(n3 - 1) != ',') {
            --n3;
        }
        if (n3 <= 0) {
            while (string.charAt(n3) <= ' ') {
                ++n3;
            }
            while (n3 < string.length() && string.charAt(n3) > ' ') {
                ++n3;
            }
        }
        while (n3 < string.length() && string.charAt(n3) <= ' ') {
            ++n3;
        }
        if (n3 > n2) {
            return null;
        }
        int n4 = n2;
        while (n4 < string.length() && string.charAt(n4) != ',') {
            ++n4;
        }
        if (n4 - 1 < string.length()) {
            while (n4 - 1 >= 0 && string.charAt(n4 - 1) <= ' ') {
                --n4;
            }
        }
        if (n4 > n3) {
            if (string.charAt(n3) == '[' && string.charAt(n4 - 1) == ']' || string.charAt(n3) == '(' && string.charAt(n4 - 1) == ')') {
                ++n3;
                --n4;
            }
            return string.substring(n3, n4);
        }
        return null;
    }

    private void selectWordAt(int n, int n2) {
        int[] nArray;
        this.selectedWordStart = -1;
        this.selectedWordEnd = -1;
        if (!this.isRowSelected(n)) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        }
        if ((nArray = this.getWordBoundariesAt(n, n2)) == null) {
            this.repaintRow(n);
            return;
        }
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.selectedWordStart = nArray[0];
        this.selectedWordEnd = nArray[1];
        this.repaintRow(n);
    }

    private int[] getWordBoundariesAt(int n, int n2) {
        if (n < 0 || n >= this.table.getRowCount() || n2 < 0) {
            return null;
        }
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(n, 1);
        String string = sourceLine.toString().replace("\t", "    ");
        if (string.indexOf(59) >= 0) {
            string = string.substring(0, string.indexOf(59));
        }
        int n3 = 0;
        while (n3 < string.length() && string.charAt(n3) == ' ') {
            ++n3;
        }
        if (n2 < string.length() && "()[],. +-<>".indexOf(string.charAt(n2)) < 0) {
            while (n2 > n3 && "()[], +-<>".indexOf(string.charAt(n2 - 1)) < 0) {
                --n2;
            }
            if (n2 > n3) {
                int n4 = n2;
                while (n4 < string.length() && "()[], +-<>".indexOf(string.charAt(n4)) < 0) {
                    ++n4;
                }
                if (n4 - n2 >= 1) {
                    if (n2 < 0) {
                        throw new IllegalStateException();
                    }
                    return new int[]{n2, n4};
                }
            }
        }
        return null;
    }

    String getWordAt(Point point) {
        int n = this.table.rowAtPoint(point);
        Rectangle rectangle = this.table.getCellRect(n, 1, true);
        int n2 = point.x - rectangle.x;
        FontMetrics fontMetrics = this.table.getFontMetrics(this.table.getFont());
        return this.getWordAt(n, n2 / fontMetrics.charWidth('A'));
    }

    private String getWordAt(int n, int n2) {
        int[] nArray = this.getWordBoundariesAt(n, n2);
        if (nArray == null) {
            return null;
        }
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getModel().getValueAt(n, 1);
        String string = sourceLine.toString().replace("\t", "    ");
        if (string.indexOf(59) >= 0) {
            string = string.substring(0, string.indexOf(59));
        }
        return string.substring(nArray[0], nArray[1]);
    }

    private int getAddressAt(Point point) {
        int n = this.table.rowAtPoint(point);
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n, 1);
        Rectangle rectangle = this.table.getCellRect(n, 1, true);
        int n2 = point.x - rectangle.x;
        if (n2 >= 0) {
            String string = sourceLine.toString();
            if (string.indexOf(59) >= 0) {
                string = string.substring(0, string.indexOf(59));
            }
            string = string.trim();
            FontMetrics fontMetrics = this.table.getFontMetrics(this.table.getFont());
            int n3 = fontMetrics.charWidth('A');
            int n4 = n2 / n3;
            if (n4 < string.length()) {
                int n5 = Debugger.getDataSize(sourceLine);
                string = sourceLine.toString().trim().substring(0, n4);
                int n6 = string.length() - string.replace(" ", "").length() - 1;
                if (n6 < 0) {
                    return -1;
                }
                return sourceLine.getAddress() + n6 * n5;
            }
        }
        return -1;
    }

    private boolean scrollSelectedWordToVisible() {
        if (!this.isWordSelected()) {
            return this.scrollRowToVisible(this.table.getSelectedRow());
        }
        FontMetrics fontMetrics = this.table.getFontMetrics(this.table.getFont());
        int n = fontMetrics.charWidth('A');
        int n2 = this.selectedWordStart * n;
        Rectangle rectangle = this.table.getCellRect(this.table.getSelectedRow(), 1, true);
        rectangle.x += n2;
        Rectangle rectangle2 = this.table.getVisibleRect();
        rectangle.width = rectangle2.width / 2;
        rectangle.x -= rectangle.width / 2;
        rectangle.height = rectangle2.height / 2;
        rectangle.y -= rectangle.height / 2;
        this.table.scrollRectToVisible(rectangle);
        return this.table.getVisibleRect().x != rectangle2.x || this.table.getVisibleRect().y != rectangle2.y;
    }

    int getVisibleAddress() {
        Rectangle rectangle = this.table.getVisibleRect();
        int n = this.table.rowAtPoint(new Point(rectangle.x, rectangle.y));
        int n2 = this.table.rowAtPoint(new Point(rectangle.x, rectangle.y + rectangle.height));
        int n3 = this.table.rowAtPoint(new Point(rectangle.x, rectangle.y + rectangle.height / 2));
        boolean bl = this.isRomRow(n2);
        int n4 = bl ? (this.address >= 0 && this.address < this.tableRows.length ? this.tableRows[this.address] : -1) : this.getCpuRow(this.systemDebugger.convertAddress(this.address));
        if (n4 >= n && n4 < n2) {
            return this.address;
        }
        int n5 = 0;
        while (n5 < (n2 - n + 1) / 2) {
            Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n3 - n5, 1);
            if (sourceLine.getAddress() >= 0) {
                return bl ? sourceLine.getAddress() : this.systemDebugger.convertAddress(sourceLine.getAddress());
            }
            sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n3 + n5, 1);
            if (sourceLine.getAddress() >= 0) {
                return bl ? sourceLine.getAddress() : this.systemDebugger.convertAddress(sourceLine.getAddress());
            }
            ++n5;
        }
        return -1;
    }

    boolean scrollToVisible(int n) {
        int n2;
        if (n < 0 && (n2 = this.getCpuRow(this.systemDebugger.convertAddress(n))) >= 0) {
            return this.scrollRowToVisible(n2);
        }
        if (n < 0 || n >= this.tableRows.length) {
            return false;
        }
        return this.scrollRowToVisible(this.tableRows[n]);
    }

    boolean scrollCurrentInstructionToVisible() {
        if (!this.systemDebugger.isBiosSkipped()) {
            return false;
        }
        this.systemDebugger.requestGUIupdate();
        int n = this.address >= 0 ? this.tableRows[this.address] : this.getCpuRow(this.systemDebugger.getPC());
        Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n, 1);
        if (!this.dataExecution && sourceLine.getInstruction() == null) {
            return this.scrollRowToVisible(this.getCpuRow(this.systemDebugger.getPC()));
        }
        return this.scrollRowToVisible(n);
    }

    private boolean scrollRowToVisible(int n) {
        Rectangle rectangle = this.table.getCellRect(n, 0, true);
        Rectangle rectangle2 = this.table.getVisibleRect();
        rectangle.x = rectangle2.x;
        rectangle.width = rectangle2.width;
        rectangle.height = rectangle2.height / 2;
        rectangle.y -= rectangle.height / 2;
        this.table.scrollRectToVisible(rectangle);
        return this.table.getVisibleRect().y != rectangle2.y;
    }

    private boolean updateFlags() {
        boolean bl = false;
        int n = 0;
        while (n < this.flags.length) {
            if (this.flags[n].isSelected() != this.systemDebugger.isFlagSet(n)) {
                bl = true;
                this.flags[n].setSelected(this.systemDebugger.isFlagSet(n));
            }
            ++n;
        }
        return bl;
    }

    private void updateFlagsPanel(final SystemDebugger systemDebugger) {
        String[] stringArray = systemDebugger.getFlagNames();
        final JCheckBox[] jCheckBoxArray = new JCheckBox[stringArray.length];
        ComponentTraversalGroup componentTraversalGroup = new ComponentTraversalGroup();
        this.flags = jCheckBoxArray;
        this.flagsPanel.removeAll();
        this.flagsPanel.setLayout(new GridLayout(stringArray.length, 1));
        final Insets insets = new Insets(0, 0, 0, 0);
        int n = stringArray.length - 1;
        while (n >= 0) {
            jCheckBoxArray[n] = new JCheckBox(stringArray[n], systemDebugger.isFlagSet(n)){
                private Font prevRegistersFont;
                private Font font;

                @Override
                public Font getFont() {
                    Font font = Debugger.this.registers.getFont();
                    if (font != this.prevRegistersFont) {
                        this.font = font.deriveFont(font.getStyle());
                        this.prevRegistersFont = font;
                    }
                    return this.font;
                }

                @Override
                public Color getForeground() {
                    return Debugger.this.flagsPanel.getForeground();
                }

                @Override
                public Color getBackground() {
                    return Debugger.this.flagsPanel.getBackground();
                }

                @Override
                public Insets getMargin() {
                    return insets;
                }

                @Override
                public void updateUI() {
                    super.updateUI();
                    this.setBorder(null);
                }
            };
            componentTraversalGroup.add(jCheckBoxArray[n]);
            final int n2 = n;
            jCheckBoxArray[n].setAction(new AbstractAction(stringArray[n]){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    systemDebugger.setFlagSet(n2, jCheckBoxArray[n2].isSelected());
                }
            });
            this.flagsPanel.add(jCheckBoxArray[n]);
            --n;
        }
    }

    private JTable createRegistersTable() {
        this.registers = new JTable(){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                KeyEvent keyEvent;
                int n3;
                if (eventObject instanceof KeyEvent && (n3 = (keyEvent = (KeyEvent)eventObject).getKeyCode()) >= 116 && n3 <= 120) {
                    return false;
                }
                return super.editCellAt(n, n2, eventObject);
            }

            @Override
            public void updateUI() {
                super.updateUI();
                this.pack();
            }

            private void pack() {
                int n;
                int n2 = this.getIntercellSpacing().width;
                String string = "";
                int n3 = 0;
                if (Debugger.this.systemDebugger != null) {
                    String string2;
                    String[] stringArray = Debugger.this.systemDebugger.getRegisterNames();
                    n = stringArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        string2 = stringArray[n4];
                        if (string2.length() > string.length()) {
                            string = string2;
                        }
                        ++n4;
                    }
                    n3 = 0;
                    string2 = Debugger.this.systemDebugger.getAdditionalRegisterName(0);
                    while (string2 != null) {
                        if (string2.length() > string.length()) {
                            string = string2;
                        }
                        string2 = Debugger.this.systemDebugger.getAdditionalRegisterName(++n3);
                    }
                }
                if (this.getColumnCount() > 0) {
                    n3 = 0;
                    while (n3 < this.getColumnCount()) {
                        if (string != null || n3 % 2 != 0) {
                            int n5 = 0;
                            TableColumn tableColumn = this.getColumnModel().getColumn(n3);
                            n = 0;
                            while (n < this.getRowCount()) {
                                int n6 = this.getDefaultRenderer(Object.class).getTableCellRendererComponent((JTable)this, (Object)(n3 % 2 == 0 ? string : this.getValueAt((int)n, (int)n3)), (boolean)false, (boolean)false, (int)n, (int)n3).getPreferredSize().width + n2;
                                n5 = Math.max(n5, n6);
                                ++n;
                            }
                            tableColumn.setMaxWidth(Integer.MAX_VALUE);
                            tableColumn.setMinWidth(n5);
                            if (n3 % 2 == 1) {
                                tableColumn.setMaxWidth(n5 + 8);
                            }
                        }
                        ++n3;
                    }
                    Component component = this.getEditorComponent();
                    if (component == null) {
                        component = this.getDefaultEditor(Object.class).getTableCellEditorComponent(this, null, false, 0, 0);
                    }
                    if (component != null) {
                        component.setFont(this.getFont());
                    }
                    this.setRowHeight(this.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)0, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height);
                }
            }

            @Override
            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Component component = super.prepareEditor(tableCellEditor, n, n2);
                if (component instanceof JComboBox) {
                    JComboBox jComboBox = (JComboBox)component;
                    Component component2 = jComboBox.getEditor().getEditorComponent();
                    component2.setFont(this.getFont());
                    component2.setForeground(this.getSelectionForeground());
                    component2.setBackground(this.getSelectionBackground());
                } else {
                    component.setFont(this.getFont());
                    component.setForeground(this.getSelectionForeground());
                    component.setBackground(this.getSelectionBackground());
                    if (component instanceof JTextComponent) {
                        ((JTextComponent)component).setCaretColor(component.getForeground());
                    }
                }
                return component;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Serializable serializable;
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    serializable = (RegisterTableModel)this.getModel();
                    Object object = this.getValueAt(n, n2);
                    JComponent jComponent = (JComponent)component;
                    int n3 = ((RegisterTableModel)serializable).getRegisterIndex(n, n2) - ((RegisterTableModel)serializable).getNumberOfRegularRegisters();
                    if (n3 >= 0) {
                        String string = Debugger.this.systemDebugger.getAdditionalRegisterDescription(n3);
                        if (string != null) {
                            int n4 = string.indexOf(10);
                            if (n4 >= 0) {
                                string = "<b>" + string.substring(0, n4) + "</b>" + string.substring(n4);
                            }
                            jComponent.setToolTipText("<html>" + string.replace("\n", "<br />").replace(" ", "&nbsp;") + (n2 % 2 == 0 ? "<br /><br />Click to change</html>" : "<br /><br />Click to edit value</html>"));
                        } else if (n2 % 2 == 0) {
                            jComponent.setToolTipText("Click to change");
                        } else {
                            int n5 = Integer.parseInt(object.toString(), 16);
                            String string2 = this.getValueAt(n, n2 - 1).toString();
                            jComponent.setToolTipText("<html><b>" + string2 + "</b><br />" + "$" + object + "<br />" + "%" + String.format("%8s", Integer.toBinaryString(n5 >> 8)).replace(' ', '0') + " " + String.format("%8s", Integer.toBinaryString(n5 & 0xFF)).replace(' ', '0') + "<br />" + string2 + ": " + n5 + "<br />" + "<br />Click to edit value" + "</html>");
                        }
                    } else if (n2 % 2 == 0) {
                        jComponent.setToolTipText("Click to change");
                    } else {
                        int n6 = Integer.parseInt(object.toString(), 16);
                        String string = this.getValueAt(n, n2 - 1).toString();
                        jComponent.setToolTipText("<html><b>" + string + "</b><br />" + "$" + object + "<br />" + "%" + String.format("%8s", Integer.toBinaryString(n6 >> 8)).replace(' ', '0') + " " + String.format("%8s", Integer.toBinaryString(n6 & 0xFF)).replace(' ', '0') + "<br />" + string + ": " + n6 + "<br />" + string.substring(0, 1) + ": " + (n6 >> 8) + "<br />" + string.substring(1, 2) + ": " + (n6 & 0xFF) + "<br />" + "<br />Click to edit value" + "</html>");
                    }
                }
                serializable = this.getColumnModel().getColumn(n2);
                int n7 = component.getPreferredSize().width + ((Debugger)Debugger.this).table.getIntercellSpacing().width;
                if (((TableColumn)serializable).getWidth() < n7) {
                    ((TableColumn)serializable).setMaxWidth(Integer.MAX_VALUE);
                    ((TableColumn)serializable).setMinWidth(n7);
                    if (n2 % 2 == 1) {
                        ((TableColumn)serializable).setMaxWidth(n7 + 8);
                    }
                }
                return component;
            }

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                super.tableChanged(tableModelEvent);
                if (tableModelEvent.getColumn() == -1 && tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                    this.pack();
                }
            }

            @Override
            public Color getForeground() {
                return Debugger.this.table != null ? Debugger.this.table.getForeground() : super.getForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return this.getForeground();
            }

            @Override
            public Color getBackground() {
                return Debugger.this.table != null ? Debugger.this.table.getBackground() : super.getBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return this.getBackground();
            }

            @Override
            public Font getFont() {
                return Debugger.this.table != null ? Debugger.this.table.getFont() : super.getFont();
            }

            @Override
            protected void paintBorder(Graphics graphics) {
                if (Debugger.this.table.getParent() != null && Debugger.this.table.getParent().getParent() instanceof JScrollPane) {
                    this.setBorder(((JScrollPane)Debugger.this.table.getParent().getParent()).getBorder());
                }
                super.paintBorder(graphics);
            }
        };
        Debugger.restoreTraversalKeys(this.registers);
        this.registers.setShowGrid(false);
        this.registers.setFillsViewportHeight(true);
        this.registers.setTableHeader(null);
        this.registers.setRowSelectionAllowed(false);
        this.registers.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.registers.setCursor(Cursor.getPredefinedCursor(12));
        return this.registers;
    }

    private void updateRegistersTable(SystemDebugger systemDebugger) {
        Object object;
        RegisterTableModel registerTableModel = new RegisterTableModel(systemDebugger);
        this.registers.getModel().removeTableModelListener(this.repaintTableModelListener);
        this.registers.setModel(registerTableModel);
        this.registers.getModel().addTableModelListener(this.repaintTableModelListener);
        Vector<String> vector = new Vector<String>();
        int n = 0;
        String[] stringArray = systemDebugger.getRegisterNames();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = stringArray[n3];
            if (!systemDebugger.isAdditionalRegister(n++)) {
                vector.add((String)object);
            }
            ++n3;
        }
        n = 0;
        object = systemDebugger.getAdditionalRegisterName(0);
        while (object != null) {
            if (!((String)object).isEmpty()) {
                vector.add((String)object);
            }
            object = systemDebugger.getAdditionalRegisterName(++n);
        }
        object = new DefaultCellEditor(new JComboBox<Object>(vector){
            {
                this.setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                        Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                        component.setForeground(bl ? Debugger.this.getTableSelectionForeground() : Debugger.this.registers.getForeground());
                        component.setBackground(bl ? Debugger.this.getTableSelectionBackground() : Debugger.this.registers.getBackground());
                        return component;
                    }
                });
                this.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        Debugger.this.registers.getCellEditor().stopCellEditing();
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    }
                });
            }

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                if (!this.isPopupVisible()) {
                    this.requestFocusInWindow();
                    this.showPopup();
                }
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }

            @Override
            public Font getFont() {
                return Debugger.this.registers.getFont();
            }
        });
        TableColumn tableColumn = this.registers.getColumnModel().getColumn(0);
        tableColumn.setCellEditor((TableCellEditor)object);
        tableColumn = this.registers.getColumnModel().getColumn(2);
        tableColumn.setCellEditor((TableCellEditor)object);
        ((DefaultCellEditor)this.registers.getDefaultEditor(Object.class)).setClickCountToStart(1);
        this.registers.setSurrendersFocusOnKeystroke(true);
        this.registers.setRowSelectionInterval(0, 0);
        this.registers.setColumnSelectionInterval(0, 0);
        this.registers.updateUI();
    }

    private CallStackList createCallStack(DebuggerCallStackModel debuggerCallStackModel) {
        final CallStackList callStackList = new CallStackList(debuggerCallStackModel){

            @Override
            public Color getForeground() {
                return Debugger.this.table != null ? Debugger.this.table.getForeground() : super.getForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return Debugger.this.table.getSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return Debugger.this.table != null ? Debugger.this.table.getBackground() : super.getBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return Debugger.this.table.getSelectionBackground();
            }

            @Override
            public Font getFont() {
                return Debugger.this.table != null ? Debugger.this.table.getFont() : super.getFont();
            }
        };
        callStackList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Debugger.this.setSelectedAddress(Debugger.this.callStackModel.getAddress(callStackList.getSelectedIndex()));
                Debugger.this.setSelectedStackAddress(Debugger.this.callStackModel.getStackFrameStart(callStackList.getSelectedIndex()));
            }
        });
        return callStackList;
    }

    private JList<Object> createStackList(final JTable jTable) {
        final JList<Object> jList = new JList<Object>(){

            @Override
            public Color getForeground() {
                return jTable.getForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return jTable.getSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return jTable.getBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return jTable.getSelectionBackground();
            }

            @Override
            public Font getFont() {
                return jTable.getFont();
            }

            @Override
            public Object getPrototypeCellValue() {
                return this.getModel().getSize() > 0 ? this.getModel().getElementAt(0) : null;
            }

            @Override
            public int getFixedCellWidth() {
                return this.getPrototypeCellValue() != null ? this.getCellRenderer().getListCellRendererComponent(this, this.getPrototypeCellValue(), (int)0, (boolean)false, (boolean)false).getPreferredSize().width : super.getFixedCellWidth();
            }

            @Override
            public int getFixedCellHeight() {
                return this.getPrototypeCellValue() != null ? this.getCellRenderer().getListCellRendererComponent(this, this.getPrototypeCellValue(), (int)0, (boolean)false, (boolean)false).getPreferredSize().height : super.getFixedCellHeight();
            }
        };
        jList.setCellRenderer(new DefaultListCellRenderer(){
            private MatteBorder stackFrameBottomLine;
            private MatteBorder stackFrameTopLine;
            {
                this.stackFrameBottomLine = BorderFactory.createMatteBorder(0, 0, 1, 0, jList2.getForeground());
                this.stackFrameTopLine = BorderFactory.createMatteBorder(1, 0, 0, 0, jList2.getForeground());
            }

            @Override
            public Component getListCellRendererComponent(JList<?> jList2, Object object, int n, boolean bl, boolean bl2) {
                boolean bl3;
                if (!this.stackFrameBottomLine.getMatteColor().equals(jList.getForeground())) {
                    this.stackFrameBottomLine = BorderFactory.createMatteBorder(0, 0, 1, 0, jList.getForeground());
                }
                if (!this.stackFrameTopLine.getMatteColor().equals(jList.getForeground())) {
                    this.stackFrameTopLine = BorderFactory.createMatteBorder(0, 0, 1, 0, jList.getForeground());
                }
                Component component = super.getListCellRendererComponent(jList2, object, n, bl, bl2);
                int n2 = Debugger.this.systemDebugger.getStackPointer();
                boolean bl4 = n2 == (Debugger.this.systemDebugger.getStackStart() + Debugger.this.systemDebugger.getStackLength() & Debugger.this.systemDebugger.getMemoryLength() - 1);
                int n3 = Debugger.this.systemDebugger.getStackPointer() - Debugger.this.systemDebugger.getStackStart() & Debugger.this.systemDebugger.getMemoryLength() - 1;
                boolean bl5 = bl3 = n == (Debugger.this.systemDebugger.getStackLength() - 1 - n3) / 2;
                if (!bl4 && bl3) {
                    component.setForeground(bl ? Debugger.this.highlighter.getSelectionForeground() : (n2 == Debugger.this.systemDebugger.getSP() ? Debugger.this.getCurrentLineForeground() : jList.getForeground()));
                    component.setBackground(bl ? Debugger.this.highlighter.getSelectionBackground() : (n2 == Debugger.this.systemDebugger.getSP() ? Debugger.this.getCurrentLineBackground() : jList.getBackground()));
                    if (component instanceof JLabel) {
                        JLabel jLabel = (JLabel)component;
                        if (bl2) {
                            jLabel.setBorder(BorderFactory.createCompoundBorder(n2 == Debugger.this.systemDebugger.getSP() ? this.stackFrameBottomLine : BorderFactory.createMatteBorder(2, 2, 2, 2, Debugger.this.getCurrentLineBackground()), jLabel.getBorder()));
                        } else {
                            jLabel.setBorder(n2 == Debugger.this.systemDebugger.getSP() ? this.stackFrameBottomLine : BorderFactory.createMatteBorder(2, 2, 2, 2, Debugger.this.getCurrentLineBackground()));
                        }
                    }
                } else {
                    if (!bl) {
                        component.setForeground(jList.getForeground());
                        component.setBackground(jList.getBackground());
                    }
                    if (component instanceof JLabel) {
                        JLabel jLabel = (JLabel)component;
                        int n4 = Debugger.this.systemDebugger.getStackStart() + (jList.getModel().getSize() - n - 1) * 2 + (Debugger.this.systemDebugger.getStackPointer() & 1);
                        int n5 = Debugger.this.systemDebugger.getStackSource(n4);
                        if (n5 >= 0) {
                            String string = Debugger.this.getStackLabel(n4);
                            if (string != null) {
                                if (bl2) {
                                    jLabel.setBorder(BorderFactory.createCompoundBorder(this.stackFrameTopLine, jLabel.getBorder()));
                                } else {
                                    jLabel.setBorder(this.stackFrameTopLine);
                                }
                            } else if (!bl2) {
                                jLabel.setBorder(null);
                            }
                        } else if (bl4 && bl3) {
                            if (bl2) {
                                jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(3, 0, 0, 0, Debugger.this.getCurrentLineBackground()), jLabel.getBorder()));
                            } else {
                                jLabel.setBorder(BorderFactory.createMatteBorder(3, 0, 0, 0, Debugger.this.getCurrentLineBackground()));
                            }
                        } else if (!bl2) {
                            jLabel.setBorder(null);
                        }
                    }
                }
                if (component instanceof JComponent && component.getPreferredSize().width > jList.getWidth()) {
                    ((JComponent)component).setToolTipText(object.toString());
                } else {
                    ((JComponent)component).setToolTipText(null);
                }
                return component;
            }
        });
        jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                int n2;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 0 && (mouseEvent.getClickCount() & 1) == 0 && (n2 = Debugger.this.systemDebugger.getStackSource(n = Debugger.this.systemDebugger.getStackStart() + (jList.getModel().getSize() - jList.getSelectedIndex() - 1) * 2 + (Debugger.this.systemDebugger.getStackPointer() & 1))) >= 0) {
                    int n3 = Debugger.this.systemDebugger.getRegisterNames().length;
                    if (n2 > 0) {
                        Z80Instruction z80Instruction = Debugger.this.getInstruction(n2);
                        if (z80Instruction != null && (z80Instruction.getOpCode() & 0xCF) == 197) {
                            int n4 = z80Instruction.getPrefix() != 0 ? z80Instruction.getPrefix() >> 5 & 5 : 2;
                            n3 = z80Instruction.getOpCode() >> 4 & 3;
                            if (n3 == 2) {
                                n3 = n4;
                            }
                        } else if (z80Instruction != null && z80Instruction.getOpCode() == 227) {
                            n3 = 2;
                            if (z80Instruction.getPrefix() > 0) {
                                n3 = z80Instruction.getPrefix() >> 5 & 5;
                            }
                        } else if (z80Instruction != null && z80Instruction.isCall()) {
                            n3 = Debugger.this.systemDebugger.indexOfPC();
                        }
                    }
                    if (n3 == Debugger.this.systemDebugger.indexOfPC() || Debugger.this.getStackLabel(n) != null) {
                        int n5 = Debugger.this.systemDebugger.mapToRomAddress(Debugger.this.systemDebugger.peekByte(n + 1) << 8 | Debugger.this.systemDebugger.peekByte(n));
                        Debugger.this.setSelectedAddress(Debugger.this.getSourceLine(n5 - 1).getAddress());
                    }
                }
            }
        });
        Object[] objectArray = jList.getActionMap().getParent().keys();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Action action = jList.getActionMap().getParent().get(object);
            if (action.equals(jList.getActionForKeyStroke(KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()))) || action.equals(jList.getActionForKeyStroke(KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())))) {
                jList.getActionMap().getParent().remove(object);
            }
            ++n2;
        }
        return jList;
    }

    private TabbedPane createSouthTabbedPane(SystemDebugger systemDebugger, DefaultTableModel defaultTableModel) {
        final DebuggerTabbedPane debuggerTabbedPane = new DebuggerTabbedPane();
        this.createAndAddMemoryEditor(this, debuggerTabbedPane);
        this.createAndAddExpressionsTable(debuggerTabbedPane);
        this.createAndAddBreakpointsTable(debuggerTabbedPane);
        this.createAndAddExceptionsTable(debuggerTabbedPane);
        this.createAndAddEvents(systemDebugger, debuggerTabbedPane);
        this.createAndAddOverlaysTable(systemDebugger, debuggerTabbedPane);
        this.createAndAddConsole(debuggerTabbedPane);
        debuggerTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = debuggerTabbedPane.getSelectedIndex();
                if (n >= 0) {
                    debuggerTabbedPane.setBold(n, false);
                }
                if (n == Debugger.this.eventsTabIndex) {
                    Debugger.this.eventViewer.updateTable();
                }
                if (Debugger.this.memoryEditor != null) {
                    Debugger.this.memoryEditor.getStatusBarLabel().setVisible(n == Debugger.this.memoryEditorTabIndex);
                }
            }
        });
        debuggerTabbedPane.setSelectedIndex(Math.min(debuggerTabbedPane.getTabCount() - 1, this.properties.getInt("DebuggerSouthPanelSelectedTab", 0)));
        return debuggerTabbedPane;
    }

    private void createAndAddExpressionsTable(TabbedPane tabbedPane) {
        this.expressionsTabIndex = tabbedPane.getTabCount();
        tabbedPane.addTab("Expressions", this.createExpressionsTable(this.expressionsTableModel));
        tabbedPane.addToolBarComponent(this.expressionsTabIndex, this.createExpressionsHelpButton());
    }

    private void createAndAddOverlaysTable(SystemDebugger systemDebugger, TabbedPane tabbedPane) {
        this.overlaysTabIndex = tabbedPane.getTabCount();
        this.overlays = new DebuggerOverlayTable(this){
            {
                Debugger.restoreTraversalKeys(this);
            }

            @Override
            public Font getFont() {
                return Debugger.this.table != null ? Debugger.this.table.getFont() : super.getFont();
            }

            @Override
            public Color getForeground() {
                return Debugger.this.table != null ? Debugger.this.table.getForeground() : super.getForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return Debugger.this.table.getSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return Debugger.this.table != null ? Debugger.this.table.getBackground() : super.getBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return Debugger.this.table.getSelectionBackground();
            }
        };
        Emulicious.setOverlays(this.overlays.getOverlays());
        systemDebugger.addBreakpointListener(this.overlays);
        tabbedPane.addTab("Overlays", new DebuggerScrollPane(this.overlays));
        tabbedPane.addToolBarComponent(this.overlaysTabIndex, this.createExpressionsHelpButton());
    }

    private void createAndAddMemoryEditor(Debugger debugger, TabbedPane tabbedPane) {
        JMenuItem jMenuItem;
        this.memoryEditorTabIndex = tabbedPane.getTabCount();
        this.memoryEditor = MemoryEditor.create(Emulicious.memoryEditorModel, "Mac OS X".equals(System.getProperty("os.name")) ? 3 : 2, 1, false);
        tabbedPane.addTab("Memory", this.memoryEditor);
        this.memoryEditor.selectTabByName(this.properties.getProperty("DebuggerMemorySelectedTab"), this.properties.getProperty("DebuggerMemoryTabVisibleRect"), this.properties.getInt("DebuggerMemorySelectedAddress", -1));
        this.updateMemoryEditorColors();
        this.statusBar.add((Component)this.memoryEditor.getStatusBarLabel(), "Center");
        tabbedPane.addToolBarComponent(this.memoryEditorTabIndex, this.memoryEditor.createFollowRegisterButton());
        this.memoryEditor.setFollowRegisterContainerVisible(false);
        final JMenu jMenu = this.memoryEditor.makeMenuFile(this.window);
        final JMenu jMenu2 = this.memoryEditor.makeMenuEdit(this.window);
        final JMenu jMenu3 = this.memoryEditor.makeMenuView();
        final JMenu jMenu4 = this.memoryEditor.makeMenuNavigate(this.window);
        int n = 0;
        while (n < jMenu.getItemCount()) {
            jMenuItem = jMenu.getItem(n);
            if (jMenuItem != null) {
                this.memoryEditor.getInputMap(1).put(jMenuItem.getAccelerator(), jMenuItem.getAccelerator());
                this.memoryEditor.getActionMap().put(jMenuItem.getAccelerator(), jMenuItem.getAction());
            }
            ++n;
        }
        n = 0;
        while (n < jMenu2.getItemCount()) {
            jMenuItem = jMenu2.getItem(n);
            if (jMenuItem != null) {
                this.memoryEditor.getInputMap(1).put(jMenuItem.getAccelerator(), jMenuItem.getAccelerator());
                this.memoryEditor.getActionMap().put(jMenuItem.getAccelerator(), jMenuItem.getAction());
            }
            ++n;
        }
        n = 0;
        while (n < jMenu3.getItemCount()) {
            jMenuItem = jMenu3.getItem(n);
            if (jMenuItem != null) {
                this.memoryEditor.getInputMap(1).put(jMenuItem.getAccelerator(), jMenuItem.getAccelerator());
                this.memoryEditor.getActionMap().put(jMenuItem.getAccelerator(), jMenuItem.getAction());
            }
            ++n;
        }
        n = 0;
        while (n < jMenu4.getItemCount()) {
            jMenuItem = jMenu4.getItem(n);
            if (jMenuItem != null) {
                this.memoryEditor.getInputMap(1).put(jMenuItem.getAccelerator(), jMenuItem.getAccelerator());
                this.memoryEditor.getActionMap().put(jMenuItem.getAccelerator(), jMenuItem.getAction());
            }
            ++n;
        }
        final JButton jButton = new JButton();
        jButton.setIcon(new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                int[] nArray = new int[]{n + 2, n + 10, n + 6};
                int[] nArray2 = new int[]{n2 + 4, n2 + 4, n2 + 13};
                graphics.setColor(Color.WHITE);
                graphics.fillPolygon(nArray, nArray2, nArray.length);
                graphics.setColor(Color.GRAY);
                graphics.drawPolygon(nArray, nArray2, nArray.length);
            }

            @Override
            public int getIconWidth() {
                return 14;
            }

            @Override
            public int getIconHeight() {
                return this.getIconWidth();
            }
        });
        jButton.setToolTipText("Show Menu");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                if (!jMenu.getFont().equals(jPopupMenu.getFont())) {
                    jMenu.updateUI();
                    jMenu2.updateUI();
                    jMenu3.updateUI();
                    jMenu4.updateUI();
                }
                jPopupMenu.add(jMenu);
                jPopupMenu.add(jMenu2);
                jPopupMenu.add(jMenu3);
                jPopupMenu.add(jMenu4);
                jPopupMenu.show(jButton, jButton.getX() + jButton.getWidth() - jPopupMenu.getPreferredSize().width, jButton.getY() + jButton.getHeight());
            }
        });
        tabbedPane.addToolBarComponent(this.memoryEditorTabIndex, jButton);
    }

    private JButton createExpressionsHelpButton() {
        JButton jButton = new JButton(DebuggerIcons.EXPRESSIONS_HELP_ICON){

            @Override
            public Color getForeground() {
                return Debugger.this.table.getForeground();
            }
        };
        jButton.setToolTipText("Show Expressions Help");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionsHelpDialog.open(Debugger.this.window, false);
            }
        });
        return jButton;
    }

    private void createAndAddBreakpointsTable(TabbedPane tabbedPane) {
        JTable jTable;
        int n = tabbedPane.getTabCount();
        this.breakpointsTabIndex = tabbedPane.getTabCount();
        this.breakpoints = jTable = BreakpointWindow.createBreakpointsTable(this);
        tabbedPane.addTab("Breakpoints", BreakpointWindow.createBreakpointsPanel(jTable, this));
        tabbedPane.addToolBarComponent(n, this.createExpressionsHelpButton());
        final JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setIcon(DebuggerIcons.SkipBreakpointsIcon.UNSELECTED);
        jToggleButton.setSelectedIcon(DebuggerIcons.SkipBreakpointsIcon.SELECTED);
        jToggleButton.setToolTipText("Skip Breakpoints");
        jToggleButton.setModel(this.skipBreakpoints);
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTable.setEnabled(!jToggleButton.isSelected());
                Debugger.this.ruler.repaint();
            }
        });
        tabbedPane.addToolBarComponent(n, jToggleButton);
        JButton jButton = new JButton();
        jButton.setIcon(DebuggerIcons.ADD_WATCHPOINT_ICON);
        jButton.setToolTipText("Add Watchpoint");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableCellEditor tableCellEditor = jTable.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
                new AddBreakpointDialog(Debugger.this.window, debugger);
            }
        });
        tabbedPane.addToolBarComponent(n, jButton);
    }

    private void createAndAddExceptionsTable(TabbedPane tabbedPane) {
        int n = tabbedPane.getTabCount();
        final JTable jTable = BreakpointWindow.createExceptionsTable(this);
        tabbedPane.addTab("Exceptions", new DebuggerScrollPane(jTable));
        tabbedPane.addToolBarComponent(n, this.createExpressionsHelpButton());
        final JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setIcon(DebuggerIcons.SKIP_EXCEPTIONS_ICON);
        jToggleButton.setToolTipText("Skip Exceptions");
        jToggleButton.setModel(this.skipExceptions);
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTable.setEnabled(!jToggleButton.isSelected());
            }
        });
        tabbedPane.addToolBarComponent(n, jToggleButton);
    }

    private void createAndAddEvents(SystemDebugger systemDebugger, TabbedPane tabbedPane) {
        int n;
        this.eventsTabIndex = n = tabbedPane.getTabCount();
        this.eventViewer = new EventViewerTable(systemDebugger.createEventModel()){

            @Override
            public Color getForeground() {
                return this.shouldUseDarkMode() ? WINDOW_FOREGROUND_DARK_MODE : super.getForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return Debugger.this.table.getSelectionForeground();
            }

            @Override
            public Color getTableForeground() {
                return Debugger.this.table.getForeground();
            }

            @Override
            public Color getBackground() {
                return this.shouldUseDarkMode() ? WINDOW_BACKGROUND_DARK_MODE : super.getBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return Debugger.this.table.getSelectionBackground();
            }

            @Override
            public Color getTableBackground() {
                return Debugger.this.table.getBackground();
            }

            @Override
            public Font getFont() {
                return Debugger.this.table.getFont();
            }

            @Override
            protected Border getFilterBorder() {
                return this.shouldUseDarkMode() ? LINE_BORDER_DARK_MODE : super.getFilterBorder();
            }

            private boolean shouldUseDarkMode() {
                return Debugger.this.table != null && super.getBackground() != null && Debugger.this.table.getBackground().getRed() < super.getBackground().getRed();
            }

            @Override
            public int getFrame() {
                if (!Debugger.isSuspended()) {
                    return -1;
                }
                return super.getFrame();
            }
        };
        tabbedPane.addTab("Events", this.eventViewer);
        this.loadEventFilters();
        JButton jButton = new JButton(EmuliciousIcons.EVENTS_ICON);
        jButton.setToolTipText("Open Event Viewer");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Emulicious.openEventViewer();
            }
        });
        tabbedPane.addToolBarComponent(this.eventsTabIndex, jButton);
    }

    private void saveEventFilters() {
        EventFilterModel eventFilterModel = this.eventViewer.getFilterModel();
        if (eventFilterModel instanceof DefaultEventFilterModel) {
            Emulicious.getProperties().setProperty(this.eventFiltersProperty, ((DefaultEventFilterModel)eventFilterModel).toString(this.eventViewer.getModel()));
        }
    }

    private void loadEventFilters() {
        this.eventFiltersProperty = "Debugger" + Emulicious.getEventFiltersProperty();
        EventFilterModel eventFilterModel = this.eventViewer.getFilterModel();
        if (eventFilterModel instanceof DefaultEventFilterModel) {
            ((DefaultEventFilterModel)eventFilterModel).updateFromString(Emulicious.getProperties().getProperty(this.eventFiltersProperty), this.eventViewer.getModel());
        }
    }

    private void createAndAddConsole(TabbedPane tabbedPane) {
        this.consoleTabIndex = tabbedPane.getTabCount();
        tabbedPane.addTab("Console", new DebuggerScrollPane(this.console));
        this.console.setEditable(false);
        JButton jButton = new JButton("X");
        jButton.setFont(jButton.getFont().deriveFont(1));
        jButton.setToolTipText("Clear Console");
        jButton.setForeground(Color.GRAY);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Debugger.this.console.setText("");
            }
        });
        tabbedPane.addToolBarComponent(this.consoleTabIndex, jButton);
        this.logBreakpoints.setIcon(DebuggerIcons.BREAKPOINTS_ICON);
        this.logBreakpoints.setToolTipText("Log Breakpoints");
        this.logBreakpoints.setSelected(Boolean.parseBoolean(this.properties.getProperty("DebuggerConsoleLogBreakpoints")));
        tabbedPane.addToolBarComponent(this.consoleTabIndex, this.logBreakpoints);
    }

    void appendToConsole(String string) {
        this.southTabbedPane.setBold(this.consoleTabIndex, this.southTabbedPane.getSelectedIndex() != this.consoleTabIndex);
        this.console.append(string);
    }

    void selectMemory(int n) {
        if (n >= 0) {
            this.southTabbedPane.setSelectedIndex(this.memoryEditorTabIndex);
            this.memoryEditor.selectTabByName("CPU", null, n);
        }
    }

    void selectExpressionsTab() {
        this.southTabbedPane.setSelectedIndex(this.expressionsTabIndex);
    }

    public static void logMessage(String string) {
        if (debugger != null) {
            debugger.appendToConsole(string);
        }
    }

    private JScrollPane createExpressionsTable(final DefaultTableModel defaultTableModel) {
        final DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JComboBox<Object>(new Object[]{"Hexadecimal", "Decimal", "Unsigned", "Binary", "Array"}){
            {
                this.setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                        Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                        if (Debugger.this.expressions != null) {
                            component.setForeground(bl ? Debugger.this.getTableSelectionForeground() : Debugger.this.expressions.getForeground());
                            component.setBackground(bl ? Debugger.this.getTableSelectionBackground() : Debugger.this.expressions.getBackground());
                        }
                        return component;
                    }
                });
                this.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        Debugger.this.expressions.getCellEditor().stopCellEditing();
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    }
                });
            }

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                if (!this.isPopupVisible()) {
                    this.requestFocusInWindow();
                    this.showPopup();
                }
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }

            @Override
            public Font getFont() {
                return Debugger.this.table.getFont();
            }
        });
        this.expressions = new JTable(defaultTableModel){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                InputEvent inputEvent;
                int n3;
                if (eventObject instanceof KeyEvent && ((n3 = ((KeyEvent)(inputEvent = (KeyEvent)eventObject)).getKeyCode()) >= 116 && n3 <= 120 || n3 == 27)) {
                    return false;
                }
                if (eventObject instanceof MouseEvent && ((inputEvent = (MouseEvent)eventObject).getModifiers() & (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 2 | 1)) != 0) {
                    return false;
                }
                return super.editCellAt(n, n2, eventObject);
            }

            @Override
            public Color getForeground() {
                return Debugger.this.table != null ? Debugger.this.table.getForeground() : super.getForeground();
            }

            @Override
            public Color getSelectionForeground() {
                return Debugger.this.table.getSelectionForeground();
            }

            @Override
            public Color getBackground() {
                return Debugger.this.table != null ? Debugger.this.table.getBackground() : super.getBackground();
            }

            @Override
            public Color getSelectionBackground() {
                return Debugger.this.table.getSelectionBackground();
            }

            @Override
            public Color getGridColor() {
                Color color = super.getGridColor();
                if (color != null && color.equals(Color.WHITE)) {
                    return Color.GRAY;
                }
                return color;
            }

            @Override
            public Font getFont() {
                return Debugger.this.table != null ? Debugger.this.table.getFont() : super.getFont();
            }

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    if (n2 == 0) {
                        Expression expression;
                        Object object = this.getValueAt(n, n2);
                        if (n == this.getRowCount() - 1) {
                            jLabel.setText("Add new Expression");
                        } else if (object instanceof Expression && !(expression = (Expression)object).isString()) {
                            jLabel.setText(expression + " (=" + expression.getValueString() + ")");
                        }
                    }
                }
                return component;
            }

            @Override
            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Component component = super.prepareEditor(tableCellEditor, n, n2);
                if (component instanceof JComboBox) {
                    JComboBox jComboBox = (JComboBox)component;
                    Component component2 = jComboBox.getEditor().getEditorComponent();
                    component2.setFont(this.getFont());
                    component2.setForeground(this.getSelectionForeground());
                    component2.setBackground(this.getSelectionBackground());
                } else {
                    component.setFont(this.getFont());
                    component.setForeground(this.getSelectionForeground());
                    component.setBackground(this.getSelectionBackground());
                    if (component instanceof JTextComponent) {
                        ((JTextComponent)component).setCaretColor(component.getForeground());
                    }
                }
                return component;
            }

            @Override
            public void updateUI() {
                Object object;
                this.getColumnModel().getColumn(2).setCellEditor(defaultCellEditor);
                super.updateUI();
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.getRowCount()) {
                    object = this.getCellRenderer(n3, 0).getTableCellRendererComponent(this, this.getValueAt(n3, 0), false, false, n3, 0).getPreferredSize();
                    n2 = Math.max(n2, ((Dimension)object).width);
                    n = Math.max(n, ((Dimension)object).height);
                    ++n3;
                }
                n = Math.max(n, this.getCellRenderer((int)0, (int)2).getTableCellRendererComponent((JTable)this, (Object)"Hexadecimal", (boolean)false, (boolean)false, (int)0, (int)2).getPreferredSize().height);
                this.setRowHeight(n);
                TableColumn tableColumn = this.getColumnModel().getColumn(0);
                tableColumn.setPreferredWidth(n2 + this.getIntercellSpacing().width);
                tableColumn = this.getColumnModel().getColumn(1);
                object = tableColumn.getHeaderRenderer();
                if (object == null) {
                    object = this.getTableHeader().getDefaultRenderer();
                }
                n2 = object.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)1).getPreferredSize().width;
                tableColumn.setMaxWidth(Integer.MAX_VALUE);
                tableColumn.setMinWidth(n2 + this.getIntercellSpacing().width);
                tableColumn.setMaxWidth(n2 + this.getIntercellSpacing().width);
                tableColumn = this.getColumnModel().getColumn(2);
                n2 = defaultCellEditor.getTableCellEditorComponent((JTable)this, (Object)"Hexadecimal", (boolean)false, (int)0, (int)2).getPreferredSize().width;
                tableColumn.setMaxWidth(Integer.MAX_VALUE);
                tableColumn.setMinWidth(n2 + this.getIntercellSpacing().width);
                tableColumn.setMaxWidth(n2 + this.getIntercellSpacing().width);
            }
        };
        this.expressions.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.expressions.getTableHeader().setReorderingAllowed(false);
        this.expressions.setAutoResizeMode(3);
        this.expressions.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    Debugger.this.showExpressionsPopupMenu(mouseEvent.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    Debugger.this.showExpressionsPopupMenu(mouseEvent.getPoint());
                }
            }
        });
        this.expressions.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.expressions.getInputMap().put(KeyStroke.getKeyStroke(8, 0), "delete");
        this.expressions.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTable jTable = (JTable)actionEvent.getSource();
                while (jTable.getSelectedRow() >= 0 && jTable.getSelectedRow() < jTable.getRowCount() - 1) {
                    defaultTableModel.removeRow(jTable.getSelectedRow());
                }
            }
        });
        Debugger.restoreTraversalKeys(this.expressions);
        ((DefaultCellEditor)this.expressions.getDefaultEditor(Object.class)).setClickCountToStart(1);
        this.expressions.setSurrendersFocusOnKeystroke(true);
        this.expressions.updateUI();
        this.expressions.setFillsViewportHeight(true);
        return new DebuggerScrollPane(this.expressions);
    }

    private DefaultTableModel createExpressionsTableModel() {
        return new DefaultTableModel(new Object[]{"Address", "Size", "Format", "Value"}, 0){
            {
                super.addRow(new Object[]{"", "", "", ""});
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                Object object = this.getValueAt(n, 0);
                if (object instanceof Expression) {
                    Expression expression = (Expression)this.getValueAt(n, 0);
                    if (n < this.getRowCount() - 1) {
                        if (n2 == 3) {
                            try {
                                return !Debugger.this.systemDebugger.isROMaddress(expression.getValue());
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        if (n2 > 0) {
                            return !expression.isString();
                        }
                    }
                }
                return n < this.getRowCount() - 1 || n2 == 0;
            }

            @Override
            public void addRow(Object[] objectArray) {
                Object[] objectArray2 = objectArray;
                if (!"".equals(objectArray[0])) {
                    int n;
                    try {
                        objectArray = new Object[objectArray.length];
                        n = 0;
                        while (n < objectArray.length) {
                            objectArray[n] = objectArray2[n];
                            ++n;
                        }
                        objectArray[0] = Debugger.this.parseExpression(objectArray[0].toString());
                    }
                    catch (ParseException parseException) {
                        try {
                            objectArray[0] = Debugger.this.parseConcatenatedExpression(objectArray[0].toString());
                        }
                        catch (ParseException parseException2) {
                            objectArray[3] = objectArray[0].toString().length() > 0 && objectArray[0].toString().charAt(0) == '\"' ? parseException2.getMessage() : parseException.getMessage();
                        }
                    }
                    n = this.getRowCount() - 1;
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        super.setValueAt(objectArray[n2], n, n2);
                        ++n2;
                    }
                    super.addRow(new Object[]{"", "", "", ""});
                }
            }

            @Override
            public void removeRow(int n) {
                if (n < this.getRowCount() - 1) {
                    super.removeRow(n);
                }
            }

            @Override
            public void setRowCount(int n) {
                super.setRowCount(n);
                if (n <= 0) {
                    super.addRow(new Object[]{"", "", "", ""});
                }
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (n2 == 0) {
                    if ("".equals(object)) {
                        this.removeRow(n);
                    } else {
                        try {
                            super.setValueAt(Debugger.this.parseExpression(object.toString()), n, n2);
                        }
                        catch (ParseException parseException) {
                            try {
                                super.setValueAt(Debugger.this.parseConcatenatedExpression(object.toString()), n, n2);
                            }
                            catch (ParseException parseException2) {
                                super.setValueAt(object, n, n2);
                                super.setValueAt(object.toString().length() > 0 && object.toString().charAt(0) == '\"' ? parseException2.getMessage() : parseException.getMessage(), n, 3);
                            }
                        }
                    }
                } else {
                    super.setValueAt(object, n, n2);
                }
                if (n2 == 0 && n == this.getRowCount() - 1) {
                    if (!"".equals(object)) {
                        super.addRow(new Object[]{"", "", "", ""});
                        super.setValueAt("1", n, 1);
                        super.setValueAt("Hexadecimal", n, 2);
                    }
                } else if (n2 <= 2) {
                    Debugger.this.expressions.repaint(Debugger.this.expressions.getCellRect(n, 3, false));
                } else if (n2 == 3) {
                    try {
                        Expression expression = (Expression)this.getValueAt(n, 0);
                        int n3 = expression.getValue();
                        int n4 = Integer.parseInt((String)this.getValueAt(n, 1));
                        int[] nArray = new int[n4];
                        String string = (String)object;
                        if ("Array".equals(this.getValueAt(n, 2))) {
                            int n5 = string.length();
                            nArray[0] = Integer.parseInt(string.substring(0, 2 - n5 % 2), 16);
                            string = string.substring(2 - n5 % 2).trim();
                            int n6 = 1;
                            while (n6 < nArray.length && !string.isEmpty()) {
                                nArray[n6] = Integer.parseInt(string.substring(0, 2), 16);
                                string = string.substring(2).trim();
                                ++n6;
                            }
                        } else if ("Hexadecimal".equals(this.getValueAt(n, 2))) {
                            int n7 = string.length();
                            nArray[nArray.length - 1] = Integer.parseInt(string.substring(0, 2 - n7 % 2), 16);
                            string = string.substring(2 - n7 % 2);
                            int n8 = nArray.length - 2;
                            while (n8 >= 0 && !string.isEmpty()) {
                                nArray[n8] = Integer.parseInt(string.substring(0, 2), 16);
                                string = string.substring(2);
                                --n8;
                            }
                        } else if ("Binary".equals(this.getValueAt(n, 2))) {
                            int n9 = Integer.parseInt(string, 2);
                            int n10 = 0;
                            while (n10 < n4) {
                                nArray[n10] = n9 >> n10 * 8 & 0xFF;
                                ++n10;
                            }
                        } else if ("Unsigned".equals(this.getValueAt(n, 2))) {
                            int n11 = Integer.parseInt(string);
                            int n12 = 0;
                            while (n12 < n4) {
                                nArray[n12] = n11 >> n12 * 8 & 0xFF;
                                ++n12;
                            }
                        } else {
                            int n13 = Integer.parseInt(string);
                            int n14 = 0;
                            while (n14 < n4) {
                                nArray[n14] = n13 >> n14 * 8 & 0xFF;
                                ++n14;
                            }
                        }
                        Debugger.this.systemDebugger.setMemoryAt(n3, nArray);
                    }
                    catch (Exception exception) {}
                }
            }

            public String getValueAt(int n, int n2, int n3) {
                if (n2 < 0) {
                    return "Negative addresses are not allowed";
                }
                int n4 = n2 / Debugger.this.systemDebugger.getMemoryLength();
                n2 &= Debugger.this.systemDebugger.getMemoryLength() - 1;
                if (n3 >= 4) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!"Hexadecimal".equals(this.getValueAt(n, 2))) {
                        super.setValueAt("Array", n, 2);
                        int n5 = 0;
                        while (n5 < n3) {
                            if (n5 > 0) {
                                stringBuilder.append(' ');
                            }
                            stringBuilder.append(Debugger.getHexStringByte(Debugger.this.systemDebugger.getByte(n2 + n5, n4)));
                            ++n5;
                        }
                    } else {
                        int n6 = n3 - 1;
                        while (n6 >= 0) {
                            stringBuilder.append(Debugger.getHexStringByte(Debugger.this.systemDebugger.getByte(n2 + n6, n4)));
                            --n6;
                        }
                    }
                    return stringBuilder.toString();
                }
                int n7 = 0;
                int n8 = n3 - 1;
                while (n8 >= 0) {
                    n7 <<= 8;
                    n7 |= Debugger.this.systemDebugger.getByte(n2 + n8, n4);
                    --n8;
                }
                if ("Array".equals(this.getValueAt(n, 2))) {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n9 = 0;
                    while (n9 < n3) {
                        if (n9 > 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(Debugger.getHexStringByte(Debugger.this.systemDebugger.getByte(n2 + n9, n4)));
                        ++n9;
                    }
                    return stringBuilder.toString();
                }
                if ("Hexadecimal".equals(this.getValueAt(n, 2))) {
                    return String.format("%0" + 2 * n3 + "X", n7);
                }
                if ("Binary".equals(this.getValueAt(n, 2))) {
                    return String.format("%" + 8 * n3 + "s", Integer.toBinaryString(n7)).replace(' ', '0');
                }
                if ("Unsigned".equals(this.getValueAt(n, 2))) {
                    return Integer.toString(n7);
                }
                if ((n7 & 128 << (n3 - 1) * 8) != 0) {
                    n7 |= -1 >> n3 * 8 << n3 * 8;
                }
                return Integer.toString(n7);
            }

            @Override
            public Object getValueAt(int n, int n2) {
                Expression expression;
                if (n2 == 3 && n < this.getRowCount() - 1) {
                    int n3;
                    int n4;
                    if (!(super.getValueAt(n, 0) instanceof Expression)) {
                        Object object = super.getValueAt(n, n2);
                        if (object == null) {
                            return "Invalid expression!";
                        }
                        return object;
                    }
                    Expression expression2 = (Expression)this.getValueAt(n, 0);
                    if (expression2.isString()) {
                        return expression2.getValueString();
                    }
                    try {
                        n4 = expression2.getValue();
                    }
                    catch (UnknownVariableException unknownVariableException) {
                        super.setValueAt(expression2.toString(), n, 0);
                        super.setValueAt(unknownVariableException.getMessage(), n, 3);
                        return super.getValueAt(n, n2);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return String.valueOf(arrayIndexOutOfBoundsException.getMessage()) + " is outside the ROM.";
                    }
                    catch (Exception exception) {
                        return "Failed to evaluate expression" + (exception.getMessage() != null ? ": " + exception.getMessage() : "");
                    }
                    try {
                        n3 = Integer.parseInt((String)this.getValueAt(n, 1));
                        if (n3 <= 0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "Invalid size!";
                    }
                    return this.getValueAt(n, n4, n3);
                }
                if (n2 > 0 && n < this.getRowCount() - 1 && super.getValueAt(n, 0) instanceof Expression && (expression = (Expression)this.getValueAt(n, 0)).isString()) {
                    return null;
                }
                return super.getValueAt(n, n2);
            }
        };
    }

    protected boolean hasPrevAddress() {
        CyclicIntStack cyclicIntStack;
        if (this.lastTraceIndex < 0) {
            this.lastTraceIndex = 0;
        }
        return (cyclicIntStack = this.getTrace()).indexOf(this.getSelectedAddress(), this.lastTraceIndex) < cyclicIntStack.size() - 1;
    }

    private void prevAddress() {
        if (!this.hasPrevAddress()) {
            return;
        }
        CyclicIntStack cyclicIntStack = this.getTrace();
        this.lastTraceIndex = cyclicIntStack.indexOf(this.getSelectedAddress(), this.lastTraceIndex) + 1;
        this.setSelectedAddress(cyclicIntStack.get(this.lastTraceIndex));
        this.updateToolBarButtons();
    }

    protected boolean hasNextAddress() {
        CyclicIntStack cyclicIntStack = this.getTrace();
        if (this.lastTraceIndex == 0 && this.getSelectedAddress() != this.address || this.lastTraceIndex > 0 && cyclicIntStack.get(this.lastTraceIndex) == this.getSelectedAddress()) {
            return true;
        }
        return cyclicIntStack.indexOf(this.getSelectedAddress()) > 0;
    }

    private void nextAddress() {
        if (this.lastTraceIndex == 0) {
            if (this.getSelectedAddress() != this.address) {
                this.setSelectedAddress(this.address);
                this.updateToolBarButtons();
            }
            return;
        }
        CyclicIntStack cyclicIntStack = this.getTrace();
        if (this.lastTraceIndex > 0 && cyclicIntStack.get(this.lastTraceIndex) == this.getSelectedAddress()) {
            this.setSelectedAddress(cyclicIntStack.get(--this.lastTraceIndex));
        } else {
            this.lastTraceIndex = cyclicIntStack.indexOf(this.getSelectedAddress()) - 1;
            this.setSelectedAddress(cyclicIntStack.get(this.lastTraceIndex));
        }
        this.updateToolBarButtons();
    }

    private void createNavigationAnchor() {
        if (this.table.getSelectedRow() >= 0 && (this.backwardStack.isEmpty() || this.backwardStack.peek().intValue() != this.table.getSelectedRow())) {
            this.backwardStack.push(this.table.getSelectedRow());
            this.forwardStack.clear();
            if (this.backwardStack.size() > 32) {
                this.backwardStack.removeLast();
            }
            this.updateToolBarButtons();
        }
    }

    boolean canNavigateBack() {
        return !this.backwardStack.isEmpty();
    }

    private void navigateBack() {
        if (!this.canNavigateBack()) {
            return;
        }
        this.forwardStack.push(this.table.getSelectedRow());
        int n = this.backwardStack.pop();
        this.scrollRowToVisible(n);
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.updateToolBarButtons();
    }

    private boolean canNavigateForward() {
        return !this.forwardStack.isEmpty();
    }

    private void navigateForward() {
        if (!this.canNavigateForward()) {
            return;
        }
        this.backwardStack.push(this.table.getSelectedRow());
        int n = this.forwardStack.pop();
        this.scrollRowToVisible(n);
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.updateToolBarButtons();
    }

    private static int indexOfRegEx(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        string = string.replace("\t", "    ");
        if (!bl2 && !bl3) {
            return string.indexOf(string2);
        }
        Pattern pattern = !bl3 ? Pattern.compile("\\b" + Pattern.quote(string2) + "\\b") : (bl2 ? (bl ? Pattern.compile("\\b" + string2 + "\\b") : Pattern.compile("\\b" + string2 + "\\b", 2)) : (bl ? Pattern.compile(string2) : Pattern.compile(string2, 2)));
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return -1;
        }
        return matcher.start();
    }

    private static int lastIndexOfRegEx(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        string = string.replace("\t", "    ");
        if (!bl2 && !bl3) {
            return string.lastIndexOf(string2);
        }
        Pattern pattern = !bl3 ? Pattern.compile("\\b" + Pattern.quote(string2) + "\\b") : (bl2 ? (bl ? Pattern.compile("\\b" + string2 + "\\b") : Pattern.compile("\\b" + string2 + "\\b", 2)) : (bl ? Pattern.compile(string2) : Pattern.compile(string2, 2)));
        int n = -1;
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            n = matcher.start();
        }
        return n;
    }

    private String findPrev(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        block7: {
            block6: {
                try {
                    int n;
                    if (!this.isWordSelected()) break block6;
                    String string2 = this.table.getModel().getValueAt(this.table.getSelectedRow(), 1).toString().replace("\t", "    ").substring(0, this.selectedWordStart);
                    if (!bl && !bl4) {
                        string = string.toUpperCase();
                        string2 = string2.toUpperCase();
                    }
                    if ((n = Debugger.lastIndexOfRegEx(string2, string, bl, bl3, bl4)) < 0) break block6;
                    this.createNavigationAnchor();
                    this.selectWordAt(this.table.getSelectedRow(), n);
                    this.scrollSelectedWordToVisible();
                    return "";
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return patternSyntaxException.getMessage();
                }
            }
            if (!this.findPrev(string, bl, bl3, bl4, this.table.getSelectedRow())) break block7;
            return "";
        }
        if (bl2 && this.findPrev(string, bl, bl3, bl4, this.table.getRowCount() - 1)) {
            return "Wrapped search";
        }
        return "Not Found";
    }

    private boolean findPrev(String string, boolean bl, boolean bl2, boolean bl3, int n) {
        if (!bl && !bl3) {
            string = string.toUpperCase();
        }
        int n2 = this.table.getSelectedRow();
        int n3 = n;
        while (n3 >= 0) {
            String string2 = this.table.getModel().getValueAt(n3, 0).toString();
            String string3 = this.table.getModel().getValueAt(n3, 1).toString().replace("\t", "    ");
            if (n3 == n2 && this.isWordSelected()) {
                string3 = string3.substring(0, this.selectedWordStart);
            }
            if (!bl && !bl3) {
                string2 = string2.toUpperCase();
                string3 = string3.toUpperCase();
            }
            if (Debugger.indexOfRegEx(string2, string, bl, bl2, bl3) >= 0 || Debugger.indexOfRegEx(string3, string, bl, bl2, bl3) >= 0) {
                this.createNavigationAnchor();
                int n4 = Debugger.lastIndexOfRegEx(string3, string, bl, bl2, bl3);
                while (n4 >= 0) {
                    this.selectWordAt(n3, n4);
                    if (n3 != n2 || this.isWordSelected()) {
                        this.scrollSelectedWordToVisible();
                        return true;
                    }
                    string3 = string3.substring(0, n4);
                    n4 = Debugger.lastIndexOfRegEx(string3, string, bl, bl2, bl3);
                }
                if (n3 != n2) {
                    this.selectWordAt(n3, -1);
                    this.scrollSelectedWordToVisible();
                    return true;
                }
            }
            --n3;
        }
        return false;
    }

    String findNext(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        block8: {
            block7: {
                try {
                    int n;
                    if (!this.isWordSelected()) break block7;
                    String string2 = this.table.getModel().getValueAt(this.table.getSelectedRow(), 1).toString().replace("\t", "    ");
                    string2 = string2.substring(bl5 ? this.selectedWordStart : this.selectedWordEnd);
                    if (!bl && !bl4) {
                        string = string.toUpperCase();
                        string2 = string2.toUpperCase();
                    }
                    if ((n = Debugger.indexOfRegEx(string2, string, bl, bl3, bl4)) < 0) break block7;
                    if (!bl5) {
                        this.createNavigationAnchor();
                    }
                    this.selectWordAt(this.table.getSelectedRow(), (bl5 ? this.selectedWordStart : this.selectedWordEnd) + n);
                    this.scrollSelectedWordToVisible();
                    return "";
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return patternSyntaxException.getMessage();
                }
            }
            if (!this.findNext(string, bl, bl3, bl4, bl5, this.table.getSelectedRow() + (!bl5 ? 1 : 0))) break block8;
            return "";
        }
        if (bl2 && this.findNext(string, bl, bl3, bl4, bl5, 0)) {
            return "Wrapped search";
        }
        return "Not Found";
    }

    private boolean findNext(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        if (!bl && !bl3) {
            string = string.toUpperCase();
        }
        int n2 = n;
        while (n2 < this.table.getRowCount()) {
            String string2 = this.table.getModel().getValueAt(n2, 0).toString();
            String string3 = this.table.getModel().getValueAt(n2, 1).toString();
            if (!bl && !bl3) {
                string2 = string2.toUpperCase();
                string3 = string3.toUpperCase();
            }
            if (Debugger.indexOfRegEx(string2, string, bl, bl2, bl3) >= 0 || Debugger.indexOfRegEx(string3, string, bl, bl2, bl3) >= 0) {
                if (!bl4) {
                    this.createNavigationAnchor();
                }
                this.selectWordAt(n2, Debugger.indexOfRegEx(string3, string, bl, bl2, bl3));
                this.scrollSelectedWordToVisible();
                return true;
            }
            ++n2;
        }
        return false;
    }

    void updateRows(List<Z80Disassembler.SourceLine> list) {
        int n = 0;
        if (Boolean.parseBoolean(Emulicious.getProperties().getProperty("DisassemblerVerbose"))) {
            Arrays.fill(this.tableRows, 0);
            for (Z80Disassembler.SourceLine sourceLine : list) {
                if (sourceLine.getAddress() >= 0) {
                    if (sourceLine.getAddress() + sourceLine.getSize() <= this.tableRows.length) {
                        int n2 = 0;
                        while (n2 < sourceLine.getSize()) {
                            if (this.tableRows[sourceLine.getAddress() + n2] > 0) {
                                System.err.println("Already mapped: " + Integer.toHexString(sourceLine.getAddress() + n2));
                            }
                            ++n2;
                        }
                        Arrays.fill(this.tableRows, sourceLine.getAddress(), sourceLine.getAddress() + sourceLine.getSize(), n);
                    } else {
                        System.err.println("Line of address is out of range (" + Integer.toHexString(sourceLine.getAddress()) + "): " + sourceLine);
                    }
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < this.tableRows.length) {
                if (this.tableRows[n3] <= 0) {
                    System.err.println("Unmapped: " + Integer.toHexString(n3));
                }
                ++n3;
            }
        } else {
            for (Z80Disassembler.SourceLine sourceLine : list) {
                if (sourceLine.getAddress() >= 0 && sourceLine.getAddress() + sourceLine.getSize() <= this.tableRows.length) {
                    Arrays.fill(this.tableRows, sourceLine.getAddress(), sourceLine.getAddress() + sourceLine.getSize(), n);
                }
                ++n;
            }
        }
        int n4 = this.lines.size();
        this.lines = list;
        this.tablePortRows.clear();
        this.tableRAMrows.clear();
        this.tableSRAMrows.clear();
        if (list.size() != n4 && this.table.isValid()) {
            this.table.invalidate();
        }
        this.backwardStack.clear();
        this.forwardStack.clear();
        this.labels.clear();
        this.outlineDirty = true;
        if (this.currentLabel == null && Debugger.isSuspended()) {
            this.currentLabel = this.getLabel(this.systemDebugger.getAddress());
        }
    }

    void updateCpuLines() {
        if (!Emulicious.isRunnerThread() && Emulicious.isRunning()) {
            System.err.println("updateCpuLines called from the wrong thread");
            this.shouldUpdateCpuLines = true;
            this.systemDebugger.requestGUIupdate();
            return;
        }
        long l = this.cpuLinesRangeRequiresUpdate;
        this.cpuLinesRangeRequiresUpdate = 0L;
        this.shouldUpdateCpuLines = false;
        final int n = this.getVisibleAddress();
        int n2 = this.getSelectedAddress();
        util.map.Map<List<Symbols.Symbol>> map = this.getLoadedSymbols();
        if (this.ramSymbolKeys == null) {
            this.ramSymbolKeys = Symbols.getRamSymbolKeys(map);
        }
        if (this.romSymbolKeys == null) {
            this.romSymbolKeys = Symbols.getRomSymbolKeys(map);
        }
        this.setCpuLines(Z80Disassembler.generateCpuLines(this.systemDebugger, this.scratchCpuLines, this.cpuLines, this.oldCpuRows, l, this.lines, this.tableRows, map, this.romSymbolKeys, this.ramSymbolKeys, this.portNames));
        this.scratchCpuLines = this.bankedCpuLines.put(this.systemDebugger.getVirtualAddress() >> 16, this.cpuLines);
        if (this.scratchCpuLines == null) {
            this.scratchCpuLines = new Z80Disassembler.CpuLines(this.cpuLines.getNumberOfBlocks());
        }
        if (Debugger.isSuspended() && this.systemDebugger.isBiosSkipped() && this.getVisibleAddress() != this.address) {
            this.setSelectedAddress(n2, false, false);
            if (n >= 0 || this.systemDebugger.convertAddress(n) >= 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Debugger.this.getVisibleAddress() != Debugger.this.address) {
                            Debugger.this.scrollToVisible(n);
                        }
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Debugger.this.getVisibleAddress() != Debugger.this.address) {
                            Debugger.this.scrollCurrentInstructionToVisible();
                        }
                    }
                });
            }
        }
    }

    void setCpuLines(Z80Disassembler.CpuLines cpuLines) {
        if (cpuLines != null && cpuLines != this.cpuLines) {
            int n = this.table.getRowCount();
            this.cpuLines = cpuLines;
            if (this.table.getRowCount() != n && this.table.isValid()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Debugger.this.table.invalidate();
                    }
                });
            }
        }
    }

    boolean isRomRow(int n) {
        return n < this.lines.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    int getCpuRow(int n) {
        Z80Disassembler.CpuLines cpuLines;
        Z80Disassembler.CpuLines cpuLines2 = cpuLines = this.cpuLines;
        synchronized (cpuLines2) {
            int[] nArray = this.tableCpuRows;
            if (n < 0 || n >= nArray.length) {
                return -1;
            }
            int n2 = Math.min(nArray[n], cpuLines.size() - 1);
            Z80Disassembler.SourceLine sourceLine = n2 >= 0 ? cpuLines.get(n2) : Z80Disassembler.SourceLine.EMPTY_LINE;
            while (n2 > 0 && sourceLine == Z80Disassembler.SourceLine.EMPTY_LINE) {
                sourceLine = cpuLines.get(--n2);
            }
            if (n < sourceLine.getAddress() || n >= sourceLine.getAddress() + sourceLine.getSize()) {
                int n3;
                int n4;
                if (sourceLine.getAddress() < 0) {
                    n4 = 0;
                    n3 = cpuLines.size() - 1;
                } else if (sourceLine.getAddress() < n) {
                    n4 = n2 + 1;
                    n3 = cpuLines.size() - 1;
                } else {
                    n4 = 0;
                    n3 = n2 - 1;
                }
                while (n4 <= n3) {
                    n2 = n4 + (n3 - n4) / 2;
                    sourceLine = cpuLines.get(n2);
                    while (sourceLine.getAddress() < 0) {
                        sourceLine = cpuLines.get(n2 + 1);
                        if (sourceLine.getAddress() > n) {
                            while (n2 >= 1 && n2 >= n4 && (sourceLine.getAddress() < 0 || sourceLine.getAddress() > n)) {
                                sourceLine = cpuLines.get(n2 - 1);
                                --n2;
                            }
                            continue;
                        }
                        ++n2;
                    }
                    if (n >= sourceLine.getAddress() && n < sourceLine.getAddress() + sourceLine.getSize()) {
                        n4 = n3 + 1;
                        continue;
                    }
                    if (sourceLine.getAddress() < n) {
                        if (n4 == n2 + 1) {
                            System.err.println("CPU line missing");
                            return -1;
                        }
                        n4 = n2 + 1;
                        continue;
                    }
                    if (n3 == n2 - 1) {
                        System.err.println("CPU line missing");
                        return -1;
                    }
                    n3 = n2 - 1;
                }
                int n5 = Math.min(100, cpuLines.size() - 1 - n2);
                int n6 = 0;
                while (n6 < n5) {
                    sourceLine = cpuLines.get(n2 + n6);
                    if (sourceLine.getAddress() >= 0) {
                        Arrays.fill(nArray, sourceLine.getAddress(), Math.min(nArray.length, sourceLine.getAddress() + sourceLine.getSize()), n2 + n6);
                    }
                    ++n6;
                }
            }
            return n2 >= 0 ? this.lines.size() + n2 : n2;
        }
    }

    private void updateRamRows() {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = Z80Disassembler.findBeginningOfDisassembly(this.lines);
        while (n2 < this.lines.size()) {
            int n3;
            Z80Disassembler.SourceLine sourceLine = this.lines.get(n2);
            if (sourceLine.getAddress() >= 0) break;
            String string = sourceLine.toString();
            if (string.startsWith(".enum") || string.startsWith("\tmap") || string.startsWith("SECTION") && string.contains("RAM")) {
                boolean bl3 = string.contains("HRAM");
                String[] stringArray = string.split("\\s+");
                if (stringArray.length == 3) {
                    try {
                        if (string.charAt(0) != '.') {
                            if (string.charAt(0) == '\t') {
                                n = Integer.parseInt(stringArray[2].substring(2), 16);
                            } else {
                                n3 = stringArray[2].indexOf(91);
                                if (n3 > 0) {
                                    n = Integer.parseInt(stringArray[2].substring(n3 + 2, stringArray[2].length() - 1), 16);
                                }
                            }
                        } else {
                            n = Integer.parseInt(stringArray[1].substring(1), 16);
                        }
                        bl = bl3 || this.systemDebugger.getAdditionalMemoryLocationAt(n) == null;
                        boolean bl4 = bl2 = !this.systemDebugger.isRAMaddress(n);
                        if (!bl3 && this.systemDebugger.getAdditionalMemoryLocationAt(n) == null) {
                            n = this.systemDebugger.mapAddress(n, 0);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (".ende".equals(string)) {
                bl = false;
            } else if (!string.isEmpty() && string.charAt(0) == ';') {
                bl = false;
            } else if (bl) {
                try {
                    String[] stringArray = string.split("\\s+");
                    int n4 = 0;
                    if (stringArray.length >= 2) {
                        if ("db".equals(stringArray[1])) {
                            n4 = 1;
                        } else if ("dw".equals(stringArray[1])) {
                            n4 = 2;
                        } else if (stringArray.length >= 3 && stringArray[1].startsWith("ds")) {
                            n4 = stringArray[2].charAt(0) == '$' ? Integer.parseInt(stringArray[2].substring(1), 16) : Integer.parseInt(stringArray[2]);
                        } else if (stringArray[1].startsWith("#0x")) {
                            n4 = Integer.parseInt(stringArray[1].substring("#0x".length()), 16);
                        }
                    }
                    if (bl2) {
                        n3 = n4 - 1;
                        while (n3 >= 0) {
                            this.tableSRAMrows.put(n + n3, n2);
                            --n3;
                        }
                    } else {
                        n3 = n4 - 1;
                        while (n3 >= 0) {
                            this.tableRAMrows.put(n + n3, n2);
                            --n3;
                        }
                    }
                    n += n4;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            ++n2;
        }
        if (this.tableRAMrows.isEmpty()) {
            this.tableRAMrows.put(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        if (this.tableSRAMrows.isEmpty()) {
            this.tableSRAMrows.put(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
    }

    IntBiMap getRamRows() {
        if (this.tableRAMrows.isEmpty()) {
            this.updateRamRows();
        }
        return this.tableRAMrows;
    }

    IntBiMap getSramRows() {
        if (this.tableSRAMrows.isEmpty()) {
            this.updateRamRows();
        }
        return this.tableSRAMrows;
    }

    private void updatePortRows() {
        int n = Z80Disassembler.findBeginningOfDisassembly(this.lines);
        while (n < this.lines.size()) {
            String[] stringArray;
            Z80Disassembler.SourceLine sourceLine = this.lines.get(n);
            if (sourceLine.getAddress() >= 0) break;
            String string = sourceLine.toString();
            if ((string.startsWith(".define") || StringUtilities.containsIgnoreCase(string, "EQU")) && (stringArray = string.split("\\s+")).length == 3 && stringArray[2].length() > 1) {
                try {
                    this.tablePortRows.put(Integer.parseInt(stringArray[2].substring(1), 16), n);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n;
        }
        if (this.tablePortRows.isEmpty()) {
            this.tablePortRows.put(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
    }

    IntBiMap getPortRows() {
        if (this.tablePortRows.isEmpty()) {
            this.updatePortRows();
        }
        return this.tablePortRows;
    }

    private void repaintRow(int n) {
        Rectangle rectangle = this.table.getCellRect(n, 0, false);
        rectangle.width = this.table.getWidth();
        this.table.repaint(rectangle);
        this.ruler.repaint(rectangle);
    }

    void update() {
        boolean bl = this.systemDebugger.isSuspended();
        if (bl && !this.wasSuspended) {
            this.suspended();
        } else if (!bl && this.wasSuspended) {
            this.resumed();
        }
        this.wasSuspended = bl;
        this.ensureIsDisassembled(this.systemDebugger.getAddress());
        SwingUtilities.invokeLater(this.UPDATE_RUNNABLE);
    }

    @Override
    public void reset() {
        Arrays.fill(this.branchArrowSources, -1);
        this.pc = -1;
        this.prevExecutedInstructions = -1;
        this.address = Integer.MIN_VALUE;
        this.currentLabel = null;
        Arrays.fill(this.stackLabels, null);
        this.poppedStackLabels.clear();
        this.poppedReturnPCs.clear();
        this.cpuUsage.fill(this.systemDebugger.getCpuUsage());
        if (this.cpuUsagePlot.isVisible()) {
            this.cpuUsageModel.firePlotModelChanged();
        }
        ProfilerWindow.reset();
        this.wasSuspended = true;
    }

    private static boolean isTailCall(int n, int n2) {
        return DAPDebugger.isTailCall(n, n2);
    }

    @Override
    public void changeOccurred() {
        ProfilerWindow.update(this.systemDebugger.getAddress(), true);
        this.update();
    }

    @Override
    public void executingInstruction() {
        int n = this.systemDebugger.getAddress();
        if (TracerWindow.isTracing()) {
            this.updateTracerWindow();
        }
        ProfilerWindow.update(n, false);
    }

    @Override
    public void instructionExecuted() {
        int n;
        int n2 = this.systemDebugger.getAddress();
        this.ensureIsDisassembled(n2);
        if (this.currentLabel != null && this.prevAddress >= 0 && this.prevAddress < this.memory.length) {
            int n3 = n = this.prevAddress + 1 < this.memory.length && (this.memory[this.prevAddress] & 0xDF) == 221 ? this.memory[this.prevAddress + 1] : this.memory[this.prevAddress];
            if (n == 233 && !this.poppedReturnPCs.isEmpty() && this.poppedReturnPCs.get(this.poppedReturnPCs.size() - 1).intValue() == this.systemDebugger.getPC()) {
                Debugger.procedureExited(this.poppedStackLabels.get(this.poppedReturnPCs.size() - 1));
                this.poppedStackLabels.clear();
                this.poppedReturnPCs.clear();
            } else if (n == 233 && this.currentLabel.equals(this.getStackLabel(this.systemDebugger.getSP())) || n == 195 && Debugger.isTailCall(n2, this.prevAddress)) {
                ProfilerWindow.tailCall();
                this.currentLabel = null;
            }
        }
        if (this.currentLabel == null) {
            if (n2 < 0) {
                n = this.systemDebugger.convertAddress(n2);
                if (n >= 0) {
                    this.currentLabel = this.getLabel(n2);
                }
                if (this.currentLabel == null) {
                    int n4 = this.systemDebugger.getPC();
                    int n5 = this.systemDebugger.mapAddress(n4);
                    this.currentLabel = this.systemDebugger.isRAMaddress(n4) ? String.format(this.properties.getProperty("DisassemblerFormatRAMlabel"), n5) : (this.systemDebugger.isSRAMaddress(n4) ? String.format(this.properties.getProperty("DisassemblerFormatSRAMlabel"), n5) : String.format(this.systemDebugger.isInterruptAddress(n4) ? "_INTERRUPT_%04X_" : "_UNKNOWN_%04X_", n4));
                }
            } else {
                this.currentLabel = this.getLabel(n2);
            }
            if (this.interruptJustTaken && this.currentLabel == null) {
                this.currentLabel = String.format("_INTERRUPT_%04X_", this.systemDebugger.getPC());
            }
            if (this.currentLabel == null) {
                this.currentLabel = String.format(this.properties.getProperty("DisassemblerFormatCodeLabel"), n2);
            }
            if (this.currentLabel != null) {
                this.procedureEntered(this.currentLabel);
            }
            this.interruptJustTaken = false;
        }
        if (!this.systemDebugger.isROMaddress(this.systemDebugger.getSP()) && this.stackLabels.length != this.systemDebugger.getStackLength()) {
            this.stackLabels = new String[this.systemDebugger.getStackLength()];
            this.setStackLabel(this.systemDebugger.getSP(), this.currentLabel);
        }
        if (this.systemDebugger.isSuspendOnMappedLinesOnly() && Z80Disassembler.isSourceMapped(n = this.systemDebugger.mapToRomAddress(this.systemDebugger.getPC()))) {
            this.lastMappedAddress = n;
        }
        this.prevAddress = n2;
    }

    private void suspended() {
        if (!this.disableBringToTopUponSuspend && Boolean.parseBoolean(this.properties.getProperty("DebuggerBringToTopUponSuspend"))) {
            Debugger.toTop();
        }
    }

    private void resumed() {
        this.table.repaint();
    }

    int getCurrentLineNumber() {
        File file;
        int n = this.systemDebugger.getAddress();
        SourceMap sourceMap = Z80Disassembler.getSourceMap();
        if (sourceMap != null && (file = this.getCurrentFile()) != null) {
            return sourceMap.getLineNumberROM(n);
        }
        if (n < 0 || n >= this.tableRows.length) {
            return -1;
        }
        return this.tableRows[n];
    }

    File getCurrentFile() {
        SourceMap sourceMap = Z80Disassembler.getSourceMap();
        if (sourceMap != null) {
            return sourceMap.getFileROM(this.systemDebugger.getAddress());
        }
        return null;
    }

    void addSrcFolder(File file) {
        SourceMap sourceMap = Z80Disassembler.getSourceMap();
        if (sourceMap instanceof CSourceMap) {
            ((CSourceMap)sourceMap).addSrcFolder(file);
        }
    }

    final Deque<String> getCurrentStackLabels() {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        int n = this.systemDebugger.getStackStart() + this.systemDebugger.getStackLength();
        int n2 = this.systemDebugger.getStackPointer();
        while (n2 <= n) {
            String string = this.getStackLabel(n2);
            if (string != null) {
                arrayDeque.push(string);
            }
            ++n2;
        }
        if (arrayDeque.isEmpty() && this.currentLabel != null) {
            arrayDeque.push(this.currentLabel);
        }
        return arrayDeque;
    }

    final Deque<StackFrame> getCurrentStackFrames() {
        Object object;
        ArrayDeque<StackFrame> arrayDeque = new ArrayDeque<StackFrame>();
        int n = this.systemDebugger.getStackStart() + this.systemDebugger.getStackLength();
        int n2 = this.systemDebugger.getStackPointer();
        int n3 = -1;
        if (!this.poppedStackLabels.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>(this.poppedStackLabels);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.poppedReturnPCs);
            if (arrayList.size() == arrayList2.size()) {
                int n4 = arrayList.size() - 1;
                while (n4 >= 0) {
                    arrayDeque.push(new DebugStackFrame((String)arrayList.get(n4), n3, this.systemDebugger.getStackPointer(), n2));
                    n3 = this.systemDebugger.mapToRomAddress((Integer)arrayList2.get(n4)) - 1;
                    Z80Disassembler.SourceLine sourceLine = this.getSourceLine(n3);
                    if (sourceLine != null) {
                        n3 = sourceLine.getAddress();
                        if (this.systemDebugger.isSuspendOnMappedLinesOnly() && (object = Z80Disassembler.getSourceMap()) != null) {
                            while (n3 >= 0 && object.getFileROM(n3) == null) {
                                --n3;
                            }
                        }
                    }
                    --n4;
                }
            }
        }
        boolean bl = this.systemDebugger.isSuspendOnMappedLinesOnly() && !Z80Disassembler.isSourceMapped(this.systemDebugger.getAddress());
        int n5 = this.systemDebugger.getStackPointer();
        while (n5 <= n) {
            String string = this.getStackLabel(n5);
            if (string != null) {
                if (bl && n3 >= 0) {
                    int n6 = this.lastMappedAddress;
                    object = this.getSourceLine(n6);
                    if (object != null) {
                        n6 = ((Z80Disassembler.SourceLine)object).getAddress();
                    }
                    if (n3 != n6) {
                        arrayDeque.push(new DebugStackFrame(((StackFrame)arrayDeque.getLast()).getName(), n6, n5, n2));
                    }
                    bl = false;
                }
                arrayDeque.push(new DebugStackFrame(string, n3, n5, n2));
                int n7 = this.systemDebugger.getStackSource(n5);
                if (n7 >= 0) {
                    Object object2;
                    int n8 = this.systemDebugger.getRegisterNames().length;
                    if (n7 > 0) {
                        object2 = this.getInstruction(n7);
                        if (object2 != null && (((Z80Instruction)object2).getOpCode() & 0xCF) == 197) {
                            int n9 = ((Z80Instruction)object2).getPrefix() != 0 ? ((Z80Instruction)object2).getPrefix() >> 5 & 5 : 2;
                            n8 = ((Z80Instruction)object2).getOpCode() >> 4 & 3;
                            if (n8 == 2) {
                                n8 = n9;
                            }
                        } else if (object2 != null && ((Z80Instruction)object2).getOpCode() == 227) {
                            n8 = 2;
                            if (((Z80Instruction)object2).getPrefix() > 0) {
                                n8 = ((Z80Instruction)object2).getPrefix() >> 5 & 5;
                            }
                        } else if (object2 != null && ((Z80Instruction)object2).isCall()) {
                            n8 = this.systemDebugger.indexOfPC();
                        }
                    }
                    if ((n8 == this.systemDebugger.indexOfPC() || this.getStackLabel(n5) != null) && (object2 = this.getSourceLine(n3 = this.systemDebugger.mapToRomAddress(this.systemDebugger.peekByte(n5 + 1) << 8 | this.systemDebugger.peekByte(n5)) - 1)) != null) {
                        SourceMap sourceMap;
                        n3 = ((Z80Disassembler.SourceLine)object2).getAddress();
                        if (this.systemDebugger.isSuspendOnMappedLinesOnly() && (sourceMap = Z80Disassembler.getSourceMap()) != null) {
                            while (n3 >= 0 && sourceMap.getFileROM(n3) == null) {
                                --n3;
                            }
                        }
                    }
                }
                n2 = n5;
            }
            ++n5;
        }
        if (arrayDeque.isEmpty() && this.currentLabel != null) {
            arrayDeque.push(new DebugStackFrame(this.currentLabel, n3, n2, n2));
        }
        if (bl) {
            n5 = this.lastMappedAddress;
            Z80Disassembler.SourceLine sourceLine = this.getSourceLine(n5);
            if (sourceLine != null) {
                n5 = sourceLine.getAddress();
            }
            if (n3 != n5) {
                arrayDeque.push(new DebugStackFrame(((StackFrame)arrayDeque.getLast()).getName(), n5, n2, n2));
            }
        }
        return arrayDeque;
    }

    final boolean isSDCCsaveFramePointer(int n) {
        return n + 7 < this.memory.length && this.memory[n] == 221 && this.memory[n + 1] == 229 && this.memory[n + 2] == 221 && this.memory[n + 3] == 33 && this.memory[n + 4] == 0 && this.memory[n + 5] == 0 && this.memory[n + 6] == 221 && this.memory[n + 7] == 57;
    }

    private final void procedureEntered(String string) {
        this.setStackLabel(this.systemDebugger.getSP(), string);
        this.setStackLabel(this.systemDebugger.getSP() - 1, null);
        if (this.systemDebugger.isCartridgeEnabled()) {
            ProfilerWindow.procedureEntered(string);
        }
    }

    private static final void procedureExited(String string) {
        ProfilerWindow.procedureExited(string);
    }

    private final void setStackLabel(int n, String string) {
        if (n >= 0) {
            this.stackLabels[n % this.stackLabels.length] = string;
        }
    }

    private final void removeStackLabel(int n) {
        if (n >= 0) {
            this.stackLabels[n % this.stackLabels.length] = null;
        }
    }

    private final String getStackLabel(int n) {
        return this.systemDebugger.getStackSource(n %= this.stackLabels.length) >= 0 ? this.stackLabels[n] : null;
    }

    private final void ensureIsDisassembled(int n) {
        this.dataExecution = false;
        if (this.shouldUpdateCpuLines) {
            this.updateCpuLines();
        }
        if (!this.updatingDisassembly) {
            boolean bl = false;
            if (n >= 0 && !Z80Disassembler.isInstruction(n)) {
                this.updatingDisassembly = true;
                boolean bl2 = Z80Disassembler.isCode(n);
                int n2 = this.getSelectedAddress();
                int n3 = this.systemDebugger.getPrevPC();
                if (this.systemDebugger.mapToRomAddress(n3) >= 0 && Z80Disassembler.setCode(this.lines, this.memory, this.systemDebugger.getRamRomMap(), n3, this.systemDebugger.getBank0(), this.systemDebugger.getBank1(), this.systemDebugger.getBank2(), this.systemDebugger.getBank3(), n, this.systemDebugger.isSRAMenabled(), this.systemDebugger.getSRAMbank(), this.getLoadedSymbols(), this.portNames, this.sectionProvider)) {
                    this.updateRows(this.lines);
                    this.systemDebugger.recreateInvalidBreakpoints();
                    this.setSelectedAddress(n2, false, false);
                    if (!bl2 && Z80Disassembler.isSourceMapped(n)) {
                        bl = true;
                    }
                }
                this.updatingDisassembly = false;
            } else if (n < 0 && (this.systemDebugger.isSuspended() || TracerWindow.isTracing())) {
                int n4 = this.systemDebugger.getVirtualAddress() >> 16;
                this.setCpuLines(this.bankedCpuLines.get(n4));
                Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(this.getCpuRow(this.systemDebugger.getPrevPC()), 1);
                if (sourceLine == null || sourceLine.getAddress() != this.systemDebugger.getPrevPC() || sourceLine.getInstruction() == null || !this.isMatchingInstruction(sourceLine)) {
                    this.cpuLinesRangeRequiresUpdate |= 1L << this.systemDebugger.getPrevPC() / (this.systemDebugger.getMemoryLength() / this.cpuLines.getNumberOfBlocks());
                    this.updateCpuLines();
                }
            }
            if ((this.systemDebugger.isSuspended() || TracerWindow.isTracing()) && ((Z80Disassembler.SourceLine)this.table.getValueAt(this.getCpuRow(this.systemDebugger.getPrevPC()), 1)).getInstruction() == null) {
                this.cpuLinesRangeRequiresUpdate |= 1L << this.systemDebugger.getPrevPC() / (this.systemDebugger.getMemoryLength() / this.cpuLines.getNumberOfBlocks());
                this.updateCpuLines();
            }
            if (bl) {
                this.systemDebugger.handleDataExecution(this.systemDebugger.getPrevPC());
                if (Debugger.isSuspended()) {
                    this.dataExecution = bl;
                }
            }
        }
    }

    boolean isMatchingInstruction(Z80Disassembler.SourceLine sourceLine) {
        Z80Instruction z80Instruction = sourceLine.getInstruction();
        if (z80Instruction == null) {
            return true;
        }
        return Z80Disassembler.isMatchingInstruction(this.systemDebugger, sourceLine.getAddress(), sourceLine.getInstruction());
    }

    private final void updateTracerWindow() {
        int n = this.systemDebugger.getAddress();
        boolean bl = n >= 0;
        int n2 = bl ? n : this.systemDebugger.convertAddress(n);
        int n3 = this.systemDebugger.getVirtualAddress();
        if (n2 >= 0) {
            int n4 = bl ? this.tableRows[n2] : this.getCpuRow(n2);
            Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)this.table.getValueAt(n4, 1);
            if (sourceLine.getInstruction() != null) {
                String string = sourceLine.toString();
                if (string.indexOf(59) >= 1) {
                    string = string.substring(0, string.indexOf(59) - 1);
                }
                TracerWindow.append(n3, n, string, sourceLine.getInstruction().isBranch(), this.systemDebugger.getRegValues());
            } else {
                Z80Instruction z80Instruction = Z80Disassembler.disassemble(this.memory, n);
                if (z80Instruction != null) {
                    TracerWindow.append(n3, n, "\t" + z80Instruction.toString(), z80Instruction.isBranch(), this.systemDebugger.getRegValues());
                } else {
                    TracerWindow.append(n3, n, "Failed to disassemble code at " + Integer.toHexString(this.systemDebugger.getPrevPC()));
                }
            }
        } else if (this.systemDebugger.getAdditionalMemoryLocationAt(this.systemDebugger.getPC()) == null && this.systemDebugger.isRAMaddress(this.systemDebugger.getPC())) {
            Z80Instruction z80Instruction = Z80Disassembler.disassemble(this.systemDebugger.getRAM(), this.systemDebugger.mapAddress(this.systemDebugger.getPC()));
            if (z80Instruction != null) {
                TracerWindow.append(n3, n, "\t" + z80Instruction.toString(), z80Instruction.isBranch(), this.systemDebugger.getRegValues());
            } else {
                TracerWindow.append(n3, n, "Failed to disassemble code in RAM at " + Integer.toHexString(this.systemDebugger.getPC()));
            }
        } else if (this.systemDebugger.isSRAMaddress(this.systemDebugger.getPC())) {
            Z80Instruction z80Instruction = Z80Disassembler.disassemble(this.systemDebugger.getSRAM(), this.systemDebugger.getPC() & 0x1FFF);
            if (z80Instruction != null) {
                TracerWindow.append(n3, n, "\t" + z80Instruction.toString(), z80Instruction.isBranch(), this.systemDebugger.getRegValues());
            } else {
                TracerWindow.append(n3, n, "Failed to disassemble code in SRAM at " + Integer.toHexString(this.systemDebugger.getPC()));
            }
        } else {
            int n5 = this.systemDebugger.getPC();
            int[] nArray = new int[4];
            int n6 = 0;
            while (n6 < nArray.length) {
                nArray[n6] = this.systemDebugger.peekByte(n5 + n6);
                ++n6;
            }
            Z80Instruction z80Instruction = Z80Disassembler.disassemble(nArray, 0);
            TracerWindow.append(n5, n, "\t" + z80Instruction.toString(), z80Instruction.isBranch(), this.systemDebugger.getRegValues());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memoryChanged(int n) {
        ArrayIntDeque arrayIntDeque = this.updatedMemory;
        synchronized (arrayIntDeque) {
            this.updatedMemory.add(n);
        }
        this.updateMemoryTimer.restart();
    }

    @Override
    public void stackReadOccurred(int n) {
        String string = this.getStackLabel(n);
        if (string != null) {
            Z80Instruction z80Instruction = this.getInstruction(this.systemDebugger.mapAddress(this.systemDebugger.getPrevPC()));
            if (z80Instruction != null && !z80Instruction.isRet()) {
                Integer n2 = this.systemDebugger.peekByte(n + 1) << 8 | this.systemDebugger.peekByte(n);
                if (!this.poppedReturnPCs.contains(n2)) {
                    this.poppedStackLabels.add(string);
                    this.poppedReturnPCs.add(n2);
                }
            } else {
                for (String string2 : this.poppedStackLabels) {
                    Debugger.procedureExited(string2);
                }
                int n3 = 1;
                while (n3 < 8) {
                    String string3 = this.getStackLabel(n - n3 * 2);
                    if (string3 != null) {
                        Debugger.procedureExited(string3);
                        this.removeStackLabel(n - n3 * 2);
                    }
                    ++n3;
                }
                Debugger.procedureExited(string);
                this.poppedStackLabels.clear();
                this.poppedReturnPCs.clear();
            }
        }
        this.removeStackLabel(n);
    }

    @Override
    public void callExecuted(int n, int n2) {
        this.currentLabel = null;
    }

    @Override
    public void stackWriteOccurred(int n, int n2) {
        int n3;
        if (!this.poppedStackLabels.isEmpty() && (n3 = this.poppedReturnPCs.indexOf(n2)) >= 0) {
            this.setStackLabel(n, this.poppedStackLabels.get(n3));
            this.systemDebugger.setStackSource(n, 0);
            this.poppedStackLabels.remove(n3);
            this.poppedReturnPCs.remove(n3);
        }
    }

    @Override
    public void interruptTaken(int n, int n2) {
        this.interruptJustTaken = true;
        TracerWindow.append(false);
        if (n2 == 1) {
            this.swapPoppedValues();
        }
    }

    @Override
    public void interruptExited(int n) {
        TracerWindow.append(true);
        if (n == 0) {
            this.swapPoppedValues();
        }
    }

    private void swapPoppedValues() {
        List<String> list = this.exPoppedStackLabels;
        List<Integer> list2 = this.exPoppedReturnAddresses;
        this.exPoppedStackLabels = this.poppedStackLabels;
        this.exPoppedReturnAddresses = this.poppedReturnPCs;
        this.poppedStackLabels = list;
        this.poppedReturnPCs = list2;
    }

    @Override
    public void frameFinished() {
        this.cpuUsage.add(this.systemDebugger.getCpuUsage());
        if (this.cpuUsagePlot.isVisible()) {
            this.cpuUsageModel.firePlotModelChanged();
        }
        RAMWatchWindow.update();
        RAMSearchWindow.update();
        if (this.testCaseExecutor != null) {
            this.testCaseExecutor.frameFinished();
        }
    }

    @Override
    public void breakpointHit(Breakpoint breakpoint, int n, int n2, String string) {
        TracerWindow.appendBreakpointMessage(this.systemDebugger.getVirtualAddress(), this.systemDebugger.mapToRomAddress(n2), string);
        if (this.logBreakpoints.isSelected()) {
            this.appendToConsole(String.valueOf(this.cpuAddressToString(n2)) + ": " + string + "\n");
        }
        if (this.southTabbedPane.getSelectedIndex() == this.breakpointsTabIndex) {
            this.breakpoints.repaint();
        }
    }

    @Override
    public void breakpointHitCleared() {
        if (this.southTabbedPane.getSelectedIndex() == this.breakpointsTabIndex) {
            this.breakpoints.repaint();
        }
    }

    @Override
    public void breakpointsCleared() {
        this.handleBreakpointUpdateEvent();
    }

    @Override
    public void breakpointAdded(Breakpoint breakpoint) {
        this.handleBreakpointUpdateEvent();
    }

    @Override
    public void breakpointChanged(Breakpoint breakpoint) {
        this.handleBreakpointUpdateEvent();
    }

    @Override
    public void breakpointRemoved(Breakpoint breakpoint, int n, boolean bl) {
        this.handleBreakpointUpdateEvent();
    }

    private void handleBreakpointUpdateEvent() {
        this.repaintRuler();
        if (this.southTabbedPane.getSelectedIndex() == this.memoryEditorTabIndex) {
            this.memoryEditor.update();
        }
    }

    @Override
    public void messageReceived(String string) {
        this.appendToConsole(string);
    }

    @Override
    public void alert(final String string) {
        this.update();
        this.appendToConsole("Alert: " + string + "\n");
        if (Emulicious.isRunning()) {
            this.systemDebugger.suspend();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = JOptionPane.showConfirmDialog(Debugger.this.window, String.valueOf(string) + "\nDo you want to suspend the emulation?", "Alert", 0, 0);
                    if (n == 1) {
                        Debugger.this.systemDebugger.resume();
                    }
                }
            });
        }
    }

    public static boolean isSuspended() {
        return debugger != null && Debugger.debugger.systemDebugger.isSuspended();
    }

    public static void toTop() {
        if (debugger != null) {
            Debugger.debugger.window.toFront();
            Debugger.debugger.table.requestFocus();
        }
    }

    public static void runnerStateChanged() {
        if (debugger != null) {
            debugger.updateToolBarButtons();
        }
    }

    public static void patchApplied(IPS iPS) {
        if (debugger != null) {
            boolean bl = Debugger.debugger.systemDebugger.isSuspended();
            if (bl) {
                debugger.memoryUpdated(iPS.getAffectedLocations());
            } else {
                Debugger.debugger.systemDebugger.suspend();
                debugger.memoryUpdated(iPS.getAffectedLocations());
                Debugger.debugger.systemDebugger.resume(null);
            }
        }
    }

    void memoryUpdated(int[] nArray) {
        int n = this.getVisibleAddress();
        int n2 = this.getSelectedAddress();
        RamRomMap ramRomMap = this.systemDebugger.getRamRomMap();
        boolean bl = false;
        int[] nArray2 = nArray;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray2[n4];
            try {
                if (Z80Disassembler.updateLines(this.lines, this.memory, ramRomMap, n5, this.getLoadedSymbols(), this.portNames, this.sectionProvider)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = true;
            }
            ++n4;
        }
        if (bl) {
            this.updateRows(this.lines);
            this.systemDebugger.requestGUIupdate();
            this.setSelectedAddress(n2, false, false);
            this.scrollToVisible(n);
            this.window.repaint();
        }
        PlotterWindow.update();
        if (this.sourceFile != null && this.sourceFile.exists()) {
            this.updateReadAssemblyTimer.restart();
        }
    }

    private final int READ_WORD(int n) {
        return this.memory[n + 1] << 8 | this.memory[n];
    }

    public static LabelProvider getLabelProvider() {
        return labelProvider;
    }

    public static LabelProvider getLabelProviderRAM() {
        return labelProviderRAM;
    }

    public static LabelProvider getLabelProviderSRAM() {
        return labelProviderSRAM;
    }

    public LabelProvider getLabelProviderPorts() {
        return this.labelProviderPorts;
    }

    int getLabelAddress(String string) {
        List<String> list;
        Symbols.Symbol symbol;
        if (string == null || string.isEmpty()) {
            return -1;
        }
        List<Symbols.Symbol> list2 = this.getSymbols().get(string);
        Symbols.Symbol symbol2 = symbol = list2 != null ? list2.get(0) : null;
        if (symbol != null) {
            return this.getSymbolAddress(symbol);
        }
        int n = 0;
        while (n < this.memory.length) {
            if (labelProvider.hasLabel(n) && (list = labelProvider.getLabels(n)) != null) {
                for (String string2 : list) {
                    if (!string.equals(string2)) continue;
                    return n / this.systemDebugger.getRomBankSize() * this.systemDebugger.getMemoryLength() | Z80Disassembler.getSlot(n / this.systemDebugger.getRomBankSize()) * this.systemDebugger.getRomBankSize() | n & this.systemDebugger.getRomBankSize() - 1;
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.getRAMlength()) {
            if (labelProviderRAM.hasLabel(n) && (list = labelProviderRAM.getLabels(n)) != null) {
                for (String string2 : list) {
                    if (!string.equals(string2)) continue;
                    if (n >= 4096 && this.getRAMlength() > 8192) {
                        return n / 4096 * this.systemDebugger.getMemoryLength() | 0xD000 | n & this.systemDebugger.getMemoryLength() - 1;
                    }
                    return 0xC000 | n;
                }
            }
            ++n;
        }
        return -1;
    }

    int getSymbolAddress(Symbols.Symbol symbol) {
        List<String> list;
        if (this.systemDebugger.isRAMaddress(symbol.getAddress())) {
            return symbol.getAddress();
        }
        if (symbol.getBank() == 0 && (list = labelProvider.getLabels(symbol.getAddress())) != null) {
            for (String string : list) {
                if (!symbol.getLabel().equals(string)) continue;
                return symbol.getAddress();
            }
        }
        if (symbol.getBank() < 0) {
            return symbol.getAddress();
        }
        return symbol.getBank() * this.systemDebugger.getMemoryLength() | symbol.getAddress();
    }

    List<String> getAllLabels() {
        return LabelProviderUtilities.getAllLabels(labelProvider, this.memory.length, AnonymousLabelRejector.getInstance());
    }

    String cpuAddressToString(int n) {
        return this.systemDebugger.cpuAddressToString(n).trim();
    }

    String romAddressToString(int n) {
        if (Boolean.parseBoolean(this.properties.getProperty("DebuggerDisplayOffsets"))) {
            return String.format(this.getAddressFormat(), n);
        }
        return this.systemDebugger.romAddressToString(n);
    }

    String ramAddressToString(int n) {
        return this.systemDebugger.ramAddressToString(n);
    }

    String sramAddressToString(int n) {
        return this.systemDebugger.sramAddressToString(n);
    }

    String virtualAddressToString(int n) {
        return this.systemDebugger.virtualAddressToString(n);
    }

    private Color getHightlightingColor(int n, boolean bl) {
        Object object;
        if (bl && this.getRAMbreakpoint(n) != null) {
            return Color.GREEN;
        }
        if (!bl) {
            object = this.getROMbreakpoint(n);
            if (object instanceof Watchpoint) {
                return Color.GREEN;
            }
            if (object != null) {
                return Color.RED;
            }
        }
        if (!bl && n == this.address) {
            return this.getCurrentLineBackground();
        }
        if (!bl && this.systemDebugger.isSuspended() && Boolean.parseBoolean(this.properties.getProperty("DebuggerHighlightTrace"))) {
            object = this.getTrace();
            int n2 = ((CyclicIntStack)object).indexOf(n);
            int n3 = ((CyclicIntStack)object).size();
            if (n2 >= 0) {
                return this.getColorTrace(n2 * (COLORS_TRACE.length - 1) / (n3 - 1));
            }
        }
        if (Boolean.parseBoolean(this.properties.getProperty("DebuggerShowCoverage"))) {
            return this.getCoverageColor(n, bl);
        }
        return null;
    }

    Color getColorTrace(int n) {
        Color color = COLORS_TRACE[n];
        if (color != null) {
            return color;
        }
        Debugger.COLORS_TRACE[n] = new Color(this.currentLineBackground.getRed(), this.currentLineBackground.getGreen(), this.currentLineBackground.getBlue(), 128 - n);
        return COLORS_TRACE[n];
    }

    static String getHexStringWord(int n) {
        String string = HEX_STRINGS_WORD[n &= 0xFFFF];
        if (string != null) {
            return string;
        }
        Debugger.HEX_STRINGS_WORD[n] = String.valueOf(HexStrings.HEX_STRINGS[n >> 8]) + HexStrings.HEX_STRINGS[n & 0xFF];
        return Debugger.HEX_STRINGS_WORD[n];
    }

    static String getHexStringByte(int n) {
        return HexStrings.HEX_STRINGS[n & 0xFF];
    }

    static Color getCodeBackground() {
        if (debugger == null || Debugger.debugger.table == null) {
            return null;
        }
        return Debugger.debugger.table.getBackground();
    }

    static Color getTraceBackground() {
        if (debugger == null) {
            return null;
        }
        Color color = debugger.getCurrentLineBackground();
        return color.getGreen() > 128 ? color : Debugger.debugger.brighterCurrentLineBackground;
    }

    static Color getDarkerTraceBackground() {
        if (debugger == null) {
            return null;
        }
        Color color = debugger.getCurrentLineBackground();
        return color.getGreen() <= 128 ? color : Debugger.debugger.darkerCurrentLineBackground;
    }

    public static Color getBackgroundROM(int n) {
        if (debugger == null) {
            return null;
        }
        return debugger.getHightlightingColor(n, false);
    }

    public static Color getBackgroundRAM(int n) {
        if (debugger == null) {
            return null;
        }
        return debugger.getHightlightingColor(n, true);
    }

    public static Color getBackgroundVRAM(int n) {
        if (debugger == null) {
            return null;
        }
        return debugger.getVRAMbreakpoint(n) != null ? Color.GREEN : null;
    }

    public static Color getBackgroundSRAM(int n) {
        if (debugger == null) {
            return null;
        }
        return debugger.getSRAMbreakpoint(n) != null ? Color.GREEN : null;
    }

    public static Color getBackgroundAdditionalMemoryModel(String string, int n) {
        if (debugger == null) {
            return null;
        }
        return debugger.getMemoryLocationBreakpoint(string, n) != null ? Color.GREEN : null;
    }

    private JPopupMenu getPopupMenuROM(final int n, final int n2) {
        final int[] nArray = this.memory;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (n >= 0) {
            MenuItem menuItem;
            if (this.getInstruction(n) == null) {
                menuItem = new MenuItem("Plot Selected Data");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PlotterWindow.open(Debugger.this.window, nArray, n, n2, false);
                    }
                });
                jPopupMenu.addSeparator();
                menuItem = new MenuItem("Toggle Watchpoint");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Debugger.this.toggleROMbreakpoint(n, n2 - n + 1);
                    }
                });
            } else {
                menuItem = new MenuItem("Toggle Breakpoint");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Debugger.this.toggleROMbreakpoint(n, n2 - n + 1);
                    }
                });
                final Breakpoint breakpoint = this.getROMbreakpoint(n);
                menuItem = new MenuItem(String.valueOf(breakpoint != null && breakpoint.isEnabled() ? "Disable" : "Enable") + " Breakpoint");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (breakpoint == null) {
                            return;
                        }
                        Debugger.this.setBreakpointEnabled(breakpoint, !breakpoint.isEnabled());
                    }
                });
                menuItem.setEnabled(breakpoint != null);
                menuItem = new MenuItem("Breakpoint Properties...");
                jPopupMenu.add(menuItem);
                menuItem.setAction(new AbstractAction(menuItem.getText()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Debugger.openBreakpointWindow(breakpoint);
                    }
                });
                menuItem.setEnabled(breakpoint != null);
            }
            jPopupMenu.addSeparator();
            menuItem = new MenuItem("Select in Debugger");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.this.setSelectedAddress(n);
                }
            });
        }
        return jPopupMenu;
    }

    private JPopupMenu getPopupMenuRAM(JPopupMenu jPopupMenu, final int n, final int n2) {
        if (n >= 0) {
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.addSeparator();
            }
            MenuItem menuItem = new MenuItem("Toggle Watchpoint");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.this.toggleRAMbreakpoint(n, n2 - n + 1);
                }
            });
            final Breakpoint breakpoint = this.getRAMbreakpoint(n);
            menuItem = new MenuItem(String.valueOf(breakpoint != null && breakpoint.isEnabled() ? "Disable" : "Enable") + " Watchpoint");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (breakpoint == null) {
                        return;
                    }
                    Debugger.this.setBreakpointEnabled(breakpoint, !breakpoint.isEnabled());
                }
            });
            menuItem.setEnabled(breakpoint != null);
            menuItem = new MenuItem("Watchpoint Properties...");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.openBreakpointWindow(breakpoint);
                }
            });
            menuItem.setEnabled(breakpoint != null);
            jPopupMenu.addSeparator();
            menuItem = new MenuItem("Watch");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (n < 0) {
                        RAMWatchWindow.open(Debugger.this.window, Debugger.this, Debugger.this.asExpression(0xC000 | Debugger.this.getSelectedRamAddress()).wrapInRead(), false);
                    } else {
                        RAMWatchWindow.open(Debugger.this.window, Debugger.this, Debugger.this.asExpression(0xC000 | n).wrapInRead(), false);
                    }
                }
            });
            jPopupMenu.addSeparator();
            menuItem = new MenuItem("Select in Debugger");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.this.setSelectedRAMaddress(n);
                }
            });
            menuItem.setEnabled(labelProviderRAM.hasLabel(n) && this.getRamRows().containsKey(n));
        }
        return jPopupMenu;
    }

    private JPopupMenu getPopupMenuVRAM(JPopupMenu jPopupMenu, final int n, final int n2) {
        if (n >= 0) {
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.addSeparator();
            }
            MenuItem menuItem = new MenuItem("Toggle Watchpoint");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.this.toggleVRAMbreakpoint(n, n2 - n + 1);
                }
            });
            final Breakpoint breakpoint = this.getVRAMbreakpoint(n);
            menuItem = new MenuItem(String.valueOf(breakpoint != null && breakpoint.isEnabled() ? "Disable" : "Enable") + " Watchpoint");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (breakpoint == null) {
                        return;
                    }
                    Debugger.this.setBreakpointEnabled(breakpoint, !breakpoint.isEnabled());
                }
            });
            menuItem.setEnabled(breakpoint != null);
            menuItem = new MenuItem("Watchpoint Properties...");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.openBreakpointWindow(breakpoint);
                }
            });
            menuItem.setEnabled(breakpoint != null);
        }
        return jPopupMenu;
    }

    private JPopupMenu getPopupMenuSRAM(JPopupMenu jPopupMenu, final int n, final int n2) {
        if (n >= 0) {
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.addSeparator();
            }
            MenuItem menuItem = new MenuItem("Toggle Watchpoint");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.this.toggleSRAMbreakpoint(n, n2 - n + 1);
                }
            });
            final Breakpoint breakpoint = this.getSRAMbreakpoint(n);
            menuItem = new MenuItem(String.valueOf(breakpoint != null && breakpoint.isEnabled() ? "Disable" : "Enable") + " Watchpoint");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (breakpoint == null) {
                        return;
                    }
                    Debugger.this.setBreakpointEnabled(breakpoint, !breakpoint.isEnabled());
                }
            });
            menuItem.setEnabled(breakpoint != null);
            menuItem = new MenuItem("Watchpoint Properties...");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.openBreakpointWindow(breakpoint);
                }
            });
            menuItem.setEnabled(breakpoint != null);
            jPopupMenu.addSeparator();
            menuItem = new MenuItem("Select in Debugger");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.this.setSelectedSRAMaddress(n);
                }
            });
            menuItem.setEnabled(labelProviderSRAM.hasLabel(n) && this.getSramRows().containsKey(n));
        }
        return jPopupMenu;
    }

    private JPopupMenu getPopupMenuMemoryLocation(JPopupMenu jPopupMenu, final String string, final int n, final int n2) {
        if (n >= 0) {
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.addSeparator();
            }
            MenuItem menuItem = new MenuItem("Toggle Watchpoint");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.this.toggleMemoryLocationBreakpoint(string, n, n2 - n + 1);
                }
            });
            final Breakpoint breakpoint = this.getMemoryLocationBreakpoint(string, n);
            menuItem = new MenuItem(String.valueOf(breakpoint != null && breakpoint.isEnabled() ? "Disable" : "Enable") + " Watchpoint");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (breakpoint == null) {
                        return;
                    }
                    Debugger.this.setBreakpointEnabled(breakpoint, !breakpoint.isEnabled());
                }
            });
            menuItem.setEnabled(breakpoint != null);
            menuItem = new MenuItem("Watchpoint Properties...");
            jPopupMenu.add(menuItem);
            menuItem.setAction(new AbstractAction(menuItem.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Debugger.openBreakpointWindow(breakpoint);
                }
            });
            menuItem.setEnabled(breakpoint != null);
        }
        return jPopupMenu;
    }

    public static void updateKeys() {
        if (debugger != null) {
            debugger.doUpdateKeys();
        }
    }

    private void doUpdateKeys() {
        this.table.getInputMap().put(this.keySettings.getKeyStroke("ProfileFromLine"), "profileFromLine");
        this.table.getInputMap().put(this.keySettings.getKeyStroke("ProfileToNextLine"), "profileToNextLine");
        this.table.getInputMap().put(this.keySettings.getKeyStroke("TraceFromLine"), "traceFromLine");
        this.menuItemSaveAs.setAccelerator(this.keySettings.getKeyStroke("SaveAs"));
        this.menuItemLoadSymbols.setAccelerator(this.keySettings.getKeyStroke("LoadSymbols"));
        this.menuItemReloadSymbols.setAccelerator(this.keySettings.getKeyStroke("ReloadSymbols"));
        this.updateMenuKey(this.menuItemGoTo, "GoTo");
        this.updateMenuKey(this.menuItemGotoCurrentInstruction, "GoToCurrentInstruction");
        this.updateMenuKey(this.menuItemGoToDestination, "GoToDestination");
        this.updateMenuKey(this.menuItemReferenceHierarchy, "OpenReferenceHierarchy");
        this.updateMenuKey(this.menuItemOpenInMemoryEditor, "OpenInMemoryEditor");
        this.updateMenuKey(this.menuItemSelectReferencedMemory, "SelectReferencedMemory");
        this.updateMenuKey(this.menuItemWatch, "Watch");
        this.updateMenuKey(this.menuItemFind, "Find");
        this.updateMenuKey(this.menuItemPrevAddress, "GoToPrevAddress");
        this.updateMenuKey(this.menuItemNextAddress, "GoToNextAddress");
        this.updateMenuKey(this.menuItemBack, "NavigateBack");
        this.updateMenuKey(this.menuItemForward, "NavigateForward");
        this.updateMenuKey(this.menuItemResume, "Resume");
        this.updateMenuKey(this.menuItemSuspend, "Suspend");
        this.updateMenuKey(this.menuItemStepInto, "StepInto");
        this.updateMenuKey(this.menuItemStepOver, "StepOver");
        this.updateMenuKey(this.menuItemStepReturn, "StepReturn");
        this.updateMenuKey(this.menuItemAdvanceFrame, "AdvanceFrame");
        this.updateMenuKey(this.menuItemStepBack, "StepBack");
        this.updateMenuKey(this.menuItemStepBackOver, "StepBackOver");
        this.updateMenuKey(this.menuItemStepBackReturn, "StepBackReturn");
        this.updateMenuKey(this.menuItemRunToLine, "RunToLine");
        this.updateMenuKey(this.menuItemRunBackwardsToLine, "RunBackwardsToLine");
        this.updateMenuKey(this.menuItemUndo, "Undo");
        this.updateMenuKey(this.menuItemRedo, "Redo");
        this.updateMenuKey(this.menuItemJumpToLine, "JumpToLine");
        this.updateMenuKey(this.menuItemToggleBreakpoint, "ToggleBreakpoint");
        this.updateMenuKey(this.menuItemBreakpoints, "OpenBreakpointsWindow");
        this.updateMenuKey(this.menuItemTracer, "OpenTracerWindow");
        this.updateMenuKey(this.menuItemProfiler, "OpenProfilerWindow");
        this.updateMenuKey(this.menuItemCoverage, "OpenCoverageWindow");
        this.updateMenuKey(this.menuItemPlotter, "OpenPlotterWindow");
        this.updateMenuKey(this.menuItemRamWatch, "OpenRamWatchWindow");
        this.updateMenuKey(this.menuItemRamSearch, "OpenRamSearchWindow");
    }

    private final void updateMenuKey(MenuItem menuItem, String string) {
        Emulicious.removeAction(menuItem.getAccelerator());
        KeyStroke keyStroke = this.keySettings.getKeyStroke(string);
        string = PREFIX_KEYS + string;
        int n = Integer.parseInt(this.properties.getProperty(String.valueOf(string) + "When"));
        if (n == 0 || n == 2) {
            menuItem.setAccelerator(keyStroke);
        }
        if (n == 1 || n == 2) {
            Emulicious.addAction(string, keyStroke, menuItem.getAction());
        }
    }

    public static void loadDefaultKeySettings(Properties properties) {
        PropertyBasedKeySettings propertyBasedKeySettings = new PropertyBasedKeySettings(properties, PREFIX_KEYS);
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "SaveAs", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "LoadSymbols", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "ReloadSymbols", KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "Resume", KeyStroke.getKeyStroke(119, 0), 2);
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "Suspend", KeyStroke.getKeyStroke(120, 0), 2);
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "StepInto", KeyStroke.getKeyStroke(116, 0), 2);
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "StepOver", KeyStroke.getKeyStroke(117, 0), 2);
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "StepReturn", KeyStroke.getKeyStroke(118, 0), 2);
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "AdvanceFrame", KeyStroke.getKeyStroke(119, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 2);
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "StepBack", KeyStroke.getKeyStroke(116, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 2);
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "StepBackOver", KeyStroke.getKeyStroke(117, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 2);
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "StepBackReturn", KeyStroke.getKeyStroke(118, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 2);
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "RunToLine", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "RunBackwardsToLine", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "Undo", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "Redo", KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "JumpToLine", KeyStroke.getKeyStroke(74, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "ToggleBreakpoint", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "GoTo", KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "GoToCurrentInstruction", KeyStroke.getKeyStroke(32, 0));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "GoToDestination", KeyStroke.getKeyStroke(114, 0));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "OpenReferenceHierarchy", KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "OpenInMemoryEditor", KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "SelectReferencedMemory", KeyStroke.getKeyStroke(155, 0));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "Watch", KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "Find", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "GoToPrevAddress", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "GoToNextAddress", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "NavigateBack", KeyStroke.getKeyStroke(37, 512));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "NavigateForward", KeyStroke.getKeyStroke(39, 512));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "OpenBreakpointsWindow", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "OpenTracerWindow", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "OpenProfilerWindow", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "OpenCoverageWindow", KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "OpenPlotterWindow", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "OpenRamWatchWindow", KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "OpenRamSearchWindow", KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "ProfileFromLine", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "ProfileToNextLine", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200 | 0x40));
        Debugger.loadDefaultKeySetting(properties, propertyBasedKeySettings, "TraceFromLine", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
    }

    private static void loadDefaultKeySetting(Properties properties, KeySettings keySettings, String string, KeyStroke keyStroke) {
        Debugger.loadDefaultKeySetting(properties, keySettings, string, keyStroke, 0);
    }

    private static void loadDefaultKeySetting(Properties properties, KeySettings keySettings, String string, KeyStroke keyStroke, int n) {
        keySettings.setKeyStroke(string, keyStroke);
        properties.setProperty(PREFIX_KEYS + string + "When", Integer.toString(n));
    }

    public static Map<String, String> getKeyCategories() {
        java.util.HashMap<String, String> hashMap = new java.util.HashMap<String, String>();
        hashMap.put("SaveAs", "File");
        hashMap.put("LoadSymbols", "File");
        hashMap.put("ReloadSymbols", "File");
        hashMap.put("Resume", "Run");
        hashMap.put("Suspend", "Run");
        hashMap.put("StepInto", "Run");
        hashMap.put("StepOver", "Run");
        hashMap.put("StepReturn", "Run");
        hashMap.put("AdvanceFrame", "Run");
        hashMap.put("StepBack", "Run");
        hashMap.put("StepBackOver", "Run");
        hashMap.put("StepBackReturn", "Run");
        hashMap.put("RunToLine", "Run");
        hashMap.put("RunBackwardsToLine", "Run");
        hashMap.put("Undo", "Run");
        hashMap.put("Redo", "Run");
        hashMap.put("JumpToLine", "Run");
        hashMap.put("ToggleBreakpoint", "Run");
        hashMap.put("GoTo", "Navigate");
        hashMap.put("GoToCurrentInstruction", "Navigate");
        hashMap.put("GoToDestination", "Navigate");
        hashMap.put("OpenReferenceHierarchy", "Navigate");
        hashMap.put("OpenInMemoryEditor", "Navigate");
        hashMap.put("SelectReferencedMemory", "Navigate");
        hashMap.put("Watch", "Navigate");
        hashMap.put("Find", "Navigate");
        hashMap.put("GoToPrevAddress", "Navigate");
        hashMap.put("GoToNextAddress", "Navigate");
        hashMap.put("NavigateBack", "Navigate");
        hashMap.put("NavigateForward", "Navigate");
        hashMap.put("OpenBreakpointsWindow", "Debugger Tools");
        hashMap.put("OpenTracerWindow", "Debugger Tools");
        hashMap.put("OpenProfilerWindow", "Debugger Tools");
        hashMap.put("OpenCoverageWindow", "Debugger Tools");
        hashMap.put("OpenPlotterWindow", "Debugger Tools");
        hashMap.put("OpenRamWatchWindow", "Debugger Tools");
        hashMap.put("OpenRamSearchWindow", "Debugger Tools");
        hashMap.put("ProfileFromLine", "Debugger");
        hashMap.put("ProfileToNextLine", "Debugger");
        hashMap.put("TraceFromLine", "Debugger");
        return hashMap;
    }

    public static void showPopupMenuROM(int n, int n2, Component component, Point point) {
        if (debugger != null) {
            debugger.getPopupMenuROM(n, n2).show(component, point.x, point.y);
        }
    }

    public static void showPopupMenuRAM(JPopupMenu jPopupMenu, int n, int n2, Component component, Point point) {
        if (debugger != null) {
            debugger.getPopupMenuRAM(jPopupMenu, n, n2);
        }
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.show(component, point.x, point.y);
        }
    }

    public static void showPopupMenuVRAM(JPopupMenu jPopupMenu, int n, int n2, Component component, Point point) {
        if (debugger != null) {
            debugger.getPopupMenuVRAM(jPopupMenu, n, n2);
        }
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.show(component, point.x, point.y);
        }
    }

    public static void showPopupMenuSRAM(JPopupMenu jPopupMenu, int n, int n2, Component component, Point point) {
        if (debugger != null) {
            debugger.getPopupMenuSRAM(jPopupMenu, n, n2);
        }
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.show(component, point.x, point.y);
        }
    }

    public static void showPopupMenuMemoryLocation(JPopupMenu jPopupMenu, String string, int n, int n2, Component component, Point point) {
        if (debugger != null) {
            debugger.getPopupMenuMemoryLocation(jPopupMenu, string, n, n2);
        }
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.show(component, point.x, point.y);
        }
    }

    public static void open(JFrame jFrame, SystemDebugger systemDebugger, int[] nArray, boolean bl) {
        Debugger.open(jFrame, systemDebugger, nArray, -1, bl);
    }

    public static void open(JFrame jFrame, SystemDebugger systemDebugger, int[] nArray, int n) {
        Debugger.open(jFrame, systemDebugger, nArray, n, false);
    }

    private static void open(JFrame jFrame, SystemDebugger systemDebugger, int[] nArray, int n, boolean bl) {
        if (debugger == null) {
            debugger = new Debugger(jFrame, systemDebugger, nArray, Emulicious.isUseFrames());
            Emulicious.updateKeys();
            if (bl && !dapDebugging) {
                if (Boolean.parseBoolean(Emulicious.getProperties().getProperty("Window" + TracerWindow.class.getSimpleName() + "Open"))) {
                    TracerWindow.open(Debugger.debugger.window, debugger, systemDebugger, bl);
                }
                if (Boolean.parseBoolean(Emulicious.getProperties().getProperty("Window" + BreakpointWindow.class.getSimpleName() + "Open"))) {
                    Debugger.openBreakpointWindow(bl);
                }
                if (Boolean.parseBoolean(Emulicious.getProperties().getProperty("Window" + ProfilerWindow.class.getSimpleName() + "Open"))) {
                    ProfilerWindow.open(Debugger.debugger.window, debugger, Debugger.debugger.prfFile, bl);
                }
                if (Boolean.parseBoolean(Emulicious.getProperties().getProperty("Window" + CoverageWindow.class.getSimpleName() + "Open"))) {
                    CoverageWindow.open(Debugger.debugger.window, debugger, bl);
                }
                if (Boolean.parseBoolean(Emulicious.getProperties().getProperty("Window" + RAMSearchWindow.class.getSimpleName() + "Open"))) {
                    RAMSearchWindow.open(Debugger.debugger.window, Debugger.debugger.systemDebugger, bl);
                }
                if (Boolean.parseBoolean(Emulicious.getProperties().getProperty("Window" + PlotterWindow.class.getSimpleName() + "Open"))) {
                    PlotterWindow.open(Debugger.debugger.window, nArray, bl);
                }
                if (Boolean.parseBoolean(Emulicious.getProperties().getProperty("Window" + RAMWatchWindow.class.getSimpleName() + "Open"))) {
                    RAMWatchWindow.open(Debugger.debugger.window, debugger, bl);
                }
                if (Boolean.parseBoolean(Emulicious.getProperties().getProperty("Window" + ExpressionsHelpDialog.class.getSimpleName() + "Open"))) {
                    ExpressionsHelpDialog.open(Debugger.debugger.window, bl);
                }
                debugger.setVisible(true);
            }
        }
        if (!bl) {
            debugger.setVisible(true);
        }
        if (n >= 0) {
            debugger.setSelectedAddress(n);
        }
    }

    private void cleanUp() {
        this.removeSymbolFileChangeWatcher();
        this.removeDebugfileFileChangeWatchers();
        if (this.lines.size() > 1) {
            this.lines.clear();
        }
        this.lines = DISASSEMBLING;
        this.cpuLines.clear();
        this.scratchCpuLines.clear();
        this.bankedCpuLines.clear();
        this.shouldUpdateCpuLines = false;
        this.cpuLinesRangeRequiresUpdate = 0L;
        this.memory = null;
        this.tableRows = new int[0];
        this.tableCpuRows = new int[0];
        this.oldCpuRows = new int[0];
        this.tablePortRows = null;
        this.tableRAMrows = null;
        this.tableSRAMrows = null;
        this.backwardStack.clear();
        this.backwardStack = null;
        this.forwardStack.clear();
        this.forwardStack = null;
        this.labels.clear();
        this.labels = null;
        this.sectionProvider = null;
        this.symbols.clear();
        this.symbols = null;
        this.romSymbolKeys = null;
        this.ramSymbolKeys = null;
        this.ramSymbols.clear();
        this.ramSymbols = Collections.emptyList();
    }

    public static void close() {
        if (debugger != null) {
            Z80Disassembler.abort();
            Debugger.debugger.systemDebugger.saveBreakpoints(Debugger.debugger.bpsFile);
            Debugger.debugger.systemDebugger.saveCoverage(Debugger.debugger.cvgFile);
            ProfilerWindow.saveProfilers(Debugger.debugger.prfFile);
            debugger.saveExpressions(Debugger.debugger.expFile);
            Debugger.debugger.overlays.save(Debugger.debugger.ovrFile);
            Debugger.debugger.systemDebugger.removeSystemListener(debugger);
            Debugger.debugger.systemDebugger.removeBreakpointListener(debugger);
            Debugger.debugger.systemDebugger.removeMessageReceiver(debugger);
            Debugger.debugger.systemDebugger.setSkipBreakpoints(false);
            Debugger.debugger.systemDebugger.setSkipExceptions(false);
            Debugger.debugger.systemDebugger.setRecordCoverage(false);
            MemoryEditor.removeOutputListener(Debugger.debugger.memoryEditorListener);
            BreakpointWindow.unregisterBreakpointListener(Debugger.debugger.systemDebugger);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(Debugger.debugger.keyEventDispatcher);
            Emulicious.disableDebugger();
            Debugger.debugger.systemDebugger.removeBreakpointListener(Debugger.debugger.overlays);
            Emulicious.setOverlays(null);
            Emulicious.getProperties().setProperty("OutlineWidth", "" + Debugger.debugger.horizontalSplitPaneWest.getDividerLocation());
            Emulicious.getProperties().setProperty("StackWidth", "" + Debugger.debugger.horizontalSplitPaneEast.getDividerLocation());
            Emulicious.getProperties().setProperty("StackSplitLocation", "" + Debugger.debugger.eastCenterSplitPane.getDividerLocation());
            Emulicious.getProperties().setProperty("SouthPanelHeight", "" + Debugger.debugger.verticalSplitPane.getDividerLocation());
            Emulicious.getProperties().setProperty("Window" + debugger.getClass().getSimpleName() + "Open", "" + debugger.isVisible());
            Emulicious.getProperties().setProperty("Window" + debugger.getClass().getSimpleName() + "X", "" + debugger.getX());
            Emulicious.getProperties().setProperty("Window" + debugger.getClass().getSimpleName() + "Y", "" + debugger.getY());
            Emulicious.getProperties().setProperty("Window" + debugger.getClass().getSimpleName() + "Width", "" + debugger.getWidth());
            Emulicious.getProperties().setProperty("Window" + debugger.getClass().getSimpleName() + "Height", "" + debugger.getHeight());
            Emulicious.getProperties().setProperty("InterruptBreakpointEnabled", "" + Debugger.debugger.systemDebugger.isInterruptBreakpointEnabled());
            Emulicious.getProperties().setProperty("InterruptBreakpointSuspend", "" + Debugger.debugger.systemDebugger.isInterruptBreakpointSuspend());
            Emulicious.getProperties().setProperty("InterruptBreakpointCondition", Debugger.debugger.systemDebugger.getInterruptBreakpointCondition());
            Emulicious.getProperties().setProperty("UninitializedMemoryBreakpointEnabled", "" + Debugger.debugger.systemDebugger.isUninitializedMemoryBreakpointEnabled());
            Emulicious.getProperties().setProperty("UninitializedMemoryBreakpointSuspend", "" + Debugger.debugger.systemDebugger.isUninitializedMemoryBreakpointSuspend());
            Emulicious.getProperties().setProperty("UninitializedMemoryBreakpointCondition", Debugger.debugger.systemDebugger.getUninitializedMemoryBreakpointCondition());
            Emulicious.getProperties().setProperty("DataExecutionBreakpointEnabled", "" + Debugger.debugger.systemDebugger.isDataExecutionBreakpointEnabled());
            Emulicious.getProperties().setProperty("DataExecutionBreakpointSuspend", "" + Debugger.debugger.systemDebugger.isDataExecutionBreakpointSuspend());
            Emulicious.getProperties().setProperty("DataExecutionBreakpointCondition", Debugger.debugger.systemDebugger.getDataExecutionBreakpointCondition());
            Emulicious.getProperties().setProperty("StackRomWriteBreakpointEnabled", "" + Debugger.debugger.systemDebugger.isStackRomWriteBreakpointEnabled());
            Emulicious.getProperties().setProperty("StackRomWriteBreakpointSuspend", "" + Debugger.debugger.systemDebugger.isStackRomWriteBreakpointSuspend());
            Emulicious.getProperties().setProperty("StackRomWriteBreakpointCondition", Debugger.debugger.systemDebugger.getStackRomWriteBreakpointCondition());
            Emulicious.getProperties().setProperty("BankSwapAtPCBreakpointEnabled", "" + Debugger.debugger.systemDebugger.isBankSwapAtPCBreakpointEnabled());
            Emulicious.getProperties().setProperty("BankSwapAtPCBreakpointSuspend", "" + Debugger.debugger.systemDebugger.isBankSwapAtPCBreakpointSuspend());
            Emulicious.getProperties().setProperty("BankSwapAtPCBreakpointCondition", Debugger.debugger.systemDebugger.getBankSwapAtPCBreakpointCondition());
            Emulicious.getProperties().setProperty("DebuggerHideToolbar", "" + (Debugger.debugger.toolBar.getParent() == null));
            Emulicious.getProperties().setProperty("DebuggerHideCpuUsageGraph", "" + !Debugger.debugger.cpuUsagePlot.isVisible());
            Emulicious.getProperties().setProperty("DebuggerWestPanelSelectedTab", "" + Debugger.debugger.westTabbedPane.getSelectedIndex());
            Emulicious.getProperties().setProperty("DebuggerSouthPanelSelectedTab", "" + Debugger.debugger.southTabbedPane.getSelectedIndex());
            Emulicious.getProperties().setProperty("DebuggerConsoleLogBreakpoints", "" + Debugger.debugger.logBreakpoints.isSelected());
            if (Debugger.debugger.memoryEditor != null) {
                Emulicious.getProperties().setProperty("DebuggerMemorySelectedTab", Debugger.debugger.memoryEditor.getNameOfSelectedTab());
                Emulicious.getProperties().setProperty("DebuggerMemoryTabVisibleRect", Debugger.debugger.memoryEditor.getTabVisibleRect());
                Emulicious.getProperties().setProperty("DebuggerMemorySelectedAddress", "" + Debugger.debugger.memoryEditor.getFirstSelectedAddress());
            }
            if (findDialog != null) {
                findDialog.saveState(Emulicious.getProperties());
            }
            debugger.saveEventFilters();
            try {
                ExpressionsHelpDialog.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                TracerWindow.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                BreakpointWindow.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                ProfilerWindow.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                CoverageWindow.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                ReferenceHierarchyWindow.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                RAMSearchWindow.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                PlotterWindow.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                RAMWatchWindow.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            debugger.cleanUp();
            debugger.dispose();
            Emulicious.removeActionsWithPrefix(PREFIX_KEYS);
            if (Debugger.debugger.memoryEditor != null) {
                Debugger.debugger.memoryEditor.dispose();
            }
            Debugger.debugger.memoryEditor = null;
            Debugger.debugger.variablesTree.setVariables(null);
            Debugger.debugger.southTabbedPane.removeAllTabs();
            Debugger.debugger.systemDebugger = null;
            debugger = null;
            dapDebugging = false;
            DAPDebugger.setDebugger(null, null);
            if (findDialog != null) {
                findDialog.dispose();
            }
            findDialog = null;
        }
    }

    private class DebugStackFrame
    implements StackFrame {
        private final String name;
        private final int address;
        private final int begin;
        private final int end;

        DebugStackFrame(String string, int n, int n2, int n3) {
            this.name = string;
            this.begin = n2;
            this.end = n3;
            if (n < 0 && (n = Debugger.this.systemDebugger.getAddress()) < 0) {
                n = Debugger.this.systemDebugger.convertAddress(n);
            }
            this.address = n;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getBegin() {
            return this.begin;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public int getAddress(int n) {
            return this.getEnd() + n * 2;
        }

        @Override
        public int getValue(int n) {
            return Debugger.this.systemDebugger.peekByte(this.getEnd() + n * 2 + 1) << 8 | Debugger.this.systemDebugger.peekByte(this.getEnd() + n * 2);
        }

        @Override
        public int getSource(int n) {
            int n2 = Debugger.this.systemDebugger.getRegisterNames().length;
            int n3 = this.getAddress(n);
            int n4 = Debugger.this.systemDebugger.getStackSource(n3);
            if (n4 >= 0) {
                String string;
                int n5 = n2;
                Z80Instruction z80Instruction = Debugger.this.getInstruction(n4);
                if (z80Instruction != null && (z80Instruction.getOpCode() & 0xCF) == 197) {
                    int n6 = z80Instruction.getPrefix() != 0 ? z80Instruction.getPrefix() >> 5 & 5 : 2;
                    n5 = z80Instruction.getOpCode() >> 4 & 3;
                    if (n5 == 2) {
                        n5 = n6;
                    }
                } else if (z80Instruction != null && z80Instruction.getOpCode() == 227) {
                    n5 = 2;
                    if (z80Instruction.getPrefix() > 0) {
                        n5 = z80Instruction.getPrefix() >> 5 & 5;
                    }
                } else if (z80Instruction != null && z80Instruction.isCall()) {
                    n5 = Debugger.this.systemDebugger.indexOfPC();
                }
                if ((string = Debugger.this.getStackLabel(n3)) != null && n5 >= n2) {
                    n5 = Debugger.this.systemDebugger.indexOfPC();
                }
                return n5;
            }
            return -1;
        }

        @Override
        public int size() {
            if (this.begin == this.end) {
                return 0;
            }
            return (this.begin - this.end - 1) / 2 + 1;
        }

        @Override
        public File getFile() {
            SourceMap sourceMap = Z80Disassembler.getSourceMap();
            if (sourceMap != null) {
                return sourceMap.getFileROM(this.address);
            }
            return null;
        }

        @Override
        public int getLineNumber() {
            File file;
            SourceMap sourceMap = Z80Disassembler.getSourceMap();
            if (sourceMap != null && (file = this.getFile()) != null) {
                return sourceMap.getLineNumberROM(this.address);
            }
            if (this.address < 0 || this.address >= Debugger.this.tableRows.length) {
                return -1;
            }
            return Debugger.this.tableRows[this.address];
        }
    }

    class DebuggerCallStackModel
    implements CallStackList.CallStackModel {
        private final List<StackFrame> stackFrames = new ArrayList<StackFrame>();

        DebuggerCallStackModel() {
        }

        @Override
        public int getElementCount() {
            return this.stackFrames.size();
        }

        @Override
        public String getName(int n) {
            return n < this.stackFrames.size() ? this.stackFrames.get(n).getName() : null;
        }

        @Override
        public int getAddress(int n) {
            return n < this.stackFrames.size() ? this.stackFrames.get(n).getAddress() : 0;
        }

        @Override
        public int getStackFrameStart(int n) {
            return n < this.stackFrames.size() ? this.stackFrames.get(n).getBegin() : 0;
        }

        public void update() {
            this.stackFrames.clear();
            Deque<StackFrame> deque = Debugger.this.getCurrentStackFrames();
            while (!deque.isEmpty()) {
                this.stackFrames.add(deque.removeLast());
            }
        }
    }

    class DebuggerFlowArrowModel
    implements FlowArrowModel {
        DebuggerFlowArrowModel() {
        }

        @Override
        public int getArrowSourceRow(int n) {
            if (Debugger.this.addressToHighlightDestinationRow >= 0) {
                if (n == 0) {
                    return Debugger.this.addressToHighlightSourceRow;
                }
                --n;
            }
            int n2 = 0;
            while (n2 < Debugger.this.branchArrowSources.length) {
                if (Debugger.this.branchArrowSources[n2] >= 0 && --n < 0) {
                    return Debugger.this.branchArrowSourceRows[n2];
                }
                ++n2;
            }
            return 0;
        }

        @Override
        public int getArrowDestinationRow(int n) {
            if (Debugger.this.addressToHighlightDestinationRow >= 0) {
                if (n == 0) {
                    return Debugger.this.addressToHighlightDestinationRow;
                }
                --n;
            }
            int n2 = 0;
            while (n2 < Debugger.this.branchArrowSources.length) {
                if (Debugger.this.branchArrowSources[n2] >= 0 && --n < 0) {
                    return Debugger.this.branchArrowDestinationRows[n2];
                }
                ++n2;
            }
            return 0;
        }

        @Override
        public Color getArrowColor(int n) {
            if (Debugger.this.addressToHighlightDestinationRow >= 0) {
                if (n == 0) {
                    return COLOR_HIGHLIGHT;
                }
                --n;
            }
            int n2 = 0;
            while (n2 < Debugger.this.branchArrowSources.length) {
                if (Debugger.this.branchArrowSources[n2] >= 0 && --n < 0) {
                    return Debugger.this.branchArrowConditionsMet[n2] != null ? (Debugger.this.branchArrowConditionsMet[n2].booleanValue() ? CONDITION_MET_COLOR : Color.RED) : Color.GRAY;
                }
                ++n2;
            }
            return Color.BLACK;
        }

        @Override
        public int getArrowCount() {
            int n = 0;
            int n2 = 0;
            while (n2 < Debugger.this.branchArrowSources.length) {
                if (Debugger.this.branchArrowSources[n2] >= 0) {
                    ++n;
                }
                ++n2;
            }
            return Debugger.this.addressToHighlightDestinationRow >= 0 ? n + 1 : n;
        }
    }

    class DebuggerMenu
    extends JMenu {
        public DebuggerMenu(String string) {
            super(string);
        }

        @Override
        public Color getBackground() {
            return this.shouldUseDarkMode() ? WINDOW_BACKGROUND_DARK_MODE : super.getBackground();
        }

        @Override
        public Color getForeground() {
            return this.shouldUseDarkMode() ? WINDOW_FOREGROUND_DARK_MODE : super.getForeground();
        }

        private boolean shouldUseDarkMode() {
            return Debugger.this.table != null && super.getBackground() != null && Debugger.this.table.getBackground().getRed() < super.getBackground().getRed();
        }
    }

    class DebuggerScrollPane
    extends JScrollPane {
        private Border defaultBorder;
        private Border defaultTitleBorderBorder;

        public DebuggerScrollPane(Component component) {
            super(component);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.defaultBorder == null) {
                this.defaultBorder = this.getBorder();
                if (this.defaultBorder instanceof TitledBorder) {
                    this.defaultTitleBorderBorder = ((TitledBorder)this.defaultBorder).getBorder();
                }
            }
        }

        @Override
        protected void paintBorder(Graphics graphics) {
            Border border = this.getBorder();
            if (border instanceof TitledBorder) {
                ((TitledBorder)border).setTitleColor(this.getForeground());
                ((TitledBorder)border).setBorder(this.shouldUseDarkMode() ? LINE_BORDER_DARK_MODE : this.defaultTitleBorderBorder);
            } else {
                this.setBorder(this.shouldUseDarkMode() ? LINE_BORDER_DARK_MODE : this.defaultBorder);
            }
            super.paintBorder(graphics);
        }

        @Override
        public Color getBackground() {
            return this.shouldUseDarkMode() ? WINDOW_BACKGROUND_DARK_MODE : super.getBackground();
        }

        @Override
        public Color getForeground() {
            return this.shouldUseDarkMode() ? WINDOW_FOREGROUND_DARK_MODE : super.getForeground();
        }

        private boolean shouldUseDarkMode() {
            return Debugger.this.table != null && super.getBackground() != null && Debugger.this.table.getBackground().getRed() < super.getBackground().getRed();
        }
    }

    class DebuggerSplitPane
    extends JSplitPane {
        private Color defaultBackground;
        private Border defaultBorder;
        private Border darkBorder;

        public DebuggerSplitPane(int n, boolean bl, Component component, Component component2) {
            super(n, bl, component, component2);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(null);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.getUI() instanceof BasicSplitPaneUI) {
                BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.getUI()).getDivider();
                if (this.defaultBorder == null && this.defaultBackground == null) {
                    this.defaultBorder = basicSplitPaneDivider.getBorder();
                    this.defaultBackground = basicSplitPaneDivider.getBackground();
                }
                if (this.shouldUseDarkMode()) {
                    if (this.darkBorder == null) {
                        this.darkBorder = BorderFactory.createLineBorder(WINDOW_BACKGROUND_DARK_MODE, 2);
                    }
                    basicSplitPaneDivider.setBackground(LINE_BORDER_COLOR_DARK_MODE);
                    basicSplitPaneDivider.setBorder(this.darkBorder);
                } else {
                    basicSplitPaneDivider.setBackground(this.defaultBackground);
                    basicSplitPaneDivider.setBorder(this.defaultBorder);
                }
            }
            super.paintComponent(graphics);
        }

        private boolean shouldUseDarkMode() {
            return Debugger.this.table != null && super.getBackground() != null && Debugger.this.table.getBackground().getRed() < super.getBackground().getRed();
        }
    }

    class DebuggerTabbedPane
    extends TabbedPane {
        private boolean gettingForegroundOfNonBasicTabbedPane;

        DebuggerTabbedPane() {
        }

        @Override
        public Color getForeground() {
            if (this.gettingForegroundOfNonBasicTabbedPane) {
                this.gettingForegroundOfNonBasicTabbedPane = false;
                return null;
            }
            return this.shouldUseDarkMode() ? WINDOW_FOREGROUND_DARK_MODE : super.getForeground();
        }

        @Override
        public Color getBackground() {
            return this.shouldUseDarkMode() ? WINDOW_BACKGROUND_DARK_MODE : super.getBackground();
        }

        private boolean shouldUseDarkMode() {
            return Debugger.this.table != null && super.getBackground() != null && Debugger.this.table.getBackground().getRed() < super.getBackground().getRed();
        }

        @Override
        public Color getLightHighlight() {
            return this.shouldUseDarkMode() ? LIGHT_HIGHLIGHT_DARK_MODE : super.getLightHighlight();
        }

        @Override
        public Color getShadow() {
            return this.shouldUseDarkMode() ? SHADOW_DARK_MODE : super.getShadow();
        }

        @Override
        public Color getDarkShadow() {
            return this.shouldUseDarkMode() ? DARK_SHADOW_DARK_MODE : super.getDarkShadow();
        }

        @Override
        public Color getBackgroundAt(int n) {
            return this.getBackground();
        }

        @Override
        public Color getForegroundAt(int n) {
            this.gettingForegroundOfNonBasicTabbedPane = !this.hasBasicTabbedPaneUI();
            return this.gettingForegroundOfNonBasicTabbedPane ? null : this.getForeground();
        }
    }

    class DisassemblerCellRenderer
    extends DefaultTableCellRenderer {
        private final HashMap<String> ADDRESS_STRINGS = new HashMap();
        private final int digits;
        private boolean prevDisplayOffsets;
        private Color prevBackground;
        private Color addressForeground;
        private Color addressForegroundLighter;

        DisassemblerCellRenderer() {
            int n = Debugger.this.memory.length - 1;
            int n2 = 0;
            while (n > 0) {
                n /= 16;
                ++n2;
            }
            this.digits = Math.max(1, n2);
        }

        private String getAddressString(int n) {
            String string;
            boolean bl = Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerDisplayOffsets"));
            if (bl != this.prevDisplayOffsets) {
                this.prevDisplayOffsets = bl;
                this.ADDRESS_STRINGS.clear();
            }
            if ((string = this.ADDRESS_STRINGS.get(n)) == null) {
                if (bl) {
                    string = "";
                    int n2 = n;
                    int n3 = this.digits;
                    while (n3 > 0) {
                        if (n3 >= 4) {
                            string = String.valueOf(Debugger.getHexStringWord(n2 & 0xFFFF)) + string;
                            n2 >>= 16;
                            n3 -= 4;
                            continue;
                        }
                        if (n3 >= 2) {
                            string = String.valueOf(Debugger.getHexStringByte(n2 & 0xFF)) + string;
                            n2 >>= 8;
                            n3 -= 2;
                            continue;
                        }
                        string = String.valueOf(Debugger.getHexStringByte(n2 & 0xF).substring(1)) + string;
                        --n3;
                    }
                } else {
                    string = Debugger.this.systemDebugger.romAddressToString(n);
                }
                string = "  " + string + "  ";
                if (bl || Debugger.this.systemDebugger.isCartridgeEnabled()) {
                    this.ADDRESS_STRINGS.put(n, string);
                }
            }
            return string;
        }

        private void showCoverage(Component component, int n) {
            Color color = Debugger.this.getCoverageColor(n);
            if (color != null) {
                component.setBackground(color);
            }
        }

        private void highlightSelectedWord(JLabel jLabel, boolean bl) {
            int n;
            String string = jLabel.getText();
            String string2 = "";
            if (bl && Debugger.this.highlighter != null) {
                while (!string.isEmpty() && '<' == string.charAt(0)) {
                    string2 = String.valueOf(string2) + string.substring(0, string.indexOf(62) + 1);
                    string = string.substring(string.indexOf(62) + 1);
                }
                n = 0;
                while (n < Debugger.this.selectedWordStart && string.indexOf(60) >= 0) {
                    int n2 = Math.min(Debugger.this.selectedWordStart - n, Math.min(string.indexOf(38) & 0xFFFF, string.indexOf(60) & 0xFFFF));
                    n += n2;
                    string2 = String.valueOf(string2) + string.substring(0, n2);
                    string = string.substring(n2);
                    while (!(string.isEmpty() || '&' != string.charAt(0) && '<' != string.charAt(0))) {
                        if ('&' == string.charAt(0)) {
                            string2 = String.valueOf(string2) + string.substring(0, string.indexOf(59) + 1);
                            string = string.substring(string.indexOf(59) + 1);
                            ++n;
                            continue;
                        }
                        if ('<' != string.charAt(0)) continue;
                        string2 = String.valueOf(string2) + string.substring(0, string.indexOf(62) + 1);
                        string = string.substring(string.indexOf(62) + 1);
                    }
                }
            } else if (Debugger.this.selectedWordStart < string.length()) {
                string2 = string.substring(0, Debugger.this.selectedWordStart).replace(" ", "&nbsp;");
                string = string.substring(Debugger.this.selectedWordStart).replace(" ", "&nbsp;");
            }
            if ((n = Math.min(Debugger.this.selectedWordEnd - Debugger.this.selectedWordStart, Math.min(string.indexOf(38) & 0xFFFF, string.indexOf(60) & 0xFFFF))) <= string.length()) {
                string = String.valueOf(string2) + "<font color =\"white\" style=\"background-color:blue\">" + string.substring(0, n) + "</font>" + string.substring(n);
            }
            if (!string.startsWith("<html>")) {
                string = "<html>" + string + "</html>";
            }
            jLabel.setText(string);
        }

        private void showDisplacement(Z80Instruction z80Instruction, JLabel jLabel) {
            if (!z80Instruction.hasDisplacement()) {
                return;
            }
            String string = "";
            if (z80Instruction.getDisplacement() > 0) {
                string = "+" + Integer.toString(z80Instruction.getDisplacement());
            } else if (z80Instruction.getDisplacement() < 0) {
                string = Integer.toString(z80Instruction.getDisplacement());
            }
            int n = Debugger.this.systemDebugger.getRegisterValue(z80Instruction.getPrefix() >> 5 & 5) + z80Instruction.getDisplacement() & 0xFFFF;
            String string2 = null;
            if (Debugger.this.systemDebugger.isRAMaddress(n)) {
                string2 = Debugger.this.getRamLabel(Debugger.this.systemDebugger.mapAddress(n));
            } else if (Debugger.this.systemDebugger.isROMaddress(n)) {
                string2 = Debugger.this.getLabel(n);
            }
            if (string2 != null) {
                jLabel.setText(String.valueOf(jLabel.getText()) + "\t; " + Debugger.this.systemDebugger.getRegisterNames()[z80Instruction.getPrefix() >> 5 & 5].toLowerCase() + string + " = " + string2);
            } else {
                jLabel.setText(String.valueOf(jLabel.getText()) + "\t; " + Debugger.this.systemDebugger.getRegisterNames()[z80Instruction.getPrefix() >> 5 & 5].toLowerCase() + string + " = $" + Integer.toHexString(n).toUpperCase());
            }
        }

        private void showAddressAndByteCode(int n, Z80Disassembler.SourceLine sourceLine, JLabel jLabel) {
            if (this.getBackground() != this.prevBackground) {
                this.addressForeground = new Color(this.getForeground().getRGB() ^ Color.DARK_GRAY.getRGB());
                this.addressForegroundLighter = new Color(this.getForeground().getRGB() ^ Color.GRAY.getRGB());
            }
            this.prevBackground = this.getBackground();
            boolean bl = Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerShowAddresses"));
            Z80Instruction z80Instruction = sourceLine.getInstruction();
            if (z80Instruction != null && Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerShowByteCode"))) {
                if (Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerBoldAddressAndByteCode"))) {
                    jLabel.setFont(this.getFont().deriveFont(1));
                    if (Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerGrayAddressAndByteCode"))) {
                        jLabel.setForeground(this.addressForegroundLighter);
                    }
                } else if (Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerGrayAddressAndByteCode"))) {
                    jLabel.setForeground(this.addressForeground);
                }
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = Debugger.this.isRomRow(n);
                if (bl) {
                    stringBuilder.append(bl2 ? this.getAddressString(sourceLine.getAddress()) : Debugger.this.cpuAddressToString(sourceLine.getAddress()));
                }
                int n2 = 0;
                while (n2 < sourceLine.getSize()) {
                    stringBuilder.append(' ').append(Debugger.getHexStringByte(bl2 ? Debugger.this.memory[sourceLine.getAddress() + n2] : Debugger.this.systemDebugger.peekByte(sourceLine.getAddress() + n2)));
                    ++n2;
                }
                jLabel.setText(stringBuilder.append("  ").toString());
            } else if (bl) {
                if (Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerBoldAddressAndByteCode"))) {
                    jLabel.setFont(this.getFont().deriveFont(1));
                    if (Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerGrayAddressAndByteCode"))) {
                        jLabel.setForeground(this.addressForegroundLighter);
                    }
                } else if (Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerGrayAddressAndByteCode"))) {
                    jLabel.setForeground(this.addressForeground);
                }
                jLabel.setText(Debugger.this.isRomRow(n) ? this.getAddressString(sourceLine.getAddress()) : Debugger.this.cpuAddressToString(sourceLine.getAddress()));
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            try {
                int n3;
                JComponent jComponent;
                JComponent jComponent2 = jComponent = component instanceof JComponent ? (JComponent)component : null;
                if (jComponent != null) {
                    jComponent.setBorder(null);
                }
                if (!(jTable.getValueAt(n, 1) instanceof Z80Disassembler.SourceLine)) {
                    return component;
                }
                Z80Disassembler.SourceLine sourceLine = (Z80Disassembler.SourceLine)jTable.getValueAt(n, 1);
                if (!bl) {
                    component.setForeground(jTable.getForeground());
                    component.setBackground(jTable.getBackground());
                }
                if (sourceLine == null) {
                    return component;
                }
                boolean bl3 = Debugger.this.isRomRow(n);
                int n4 = n3 = bl3 ? Debugger.this.address : Debugger.this.pc;
                if (!bl3 && sourceLine.getAddress() >= 0) {
                    if (Debugger.this.shouldUpdateCpuLines) {
                        Debugger.this.systemDebugger.requestGUIupdate();
                    } else if (sourceLine.getInstruction() == null && Debugger.this.systemDebugger.isROMaddress(sourceLine.getAddress()) && ((Z80Disassembler.SourceLine)Debugger.this.lines.get(Debugger.this.tableRows[Debugger.this.systemDebugger.mapAddress(sourceLine.getAddress())])).getInstruction() != null || !Debugger.this.isMatchingInstruction(sourceLine)) {
                        Debugger debugger = Debugger.this;
                        debugger.cpuLinesRangeRequiresUpdate = debugger.cpuLinesRangeRequiresUpdate | 1L << sourceLine.getAddress() / (Debugger.this.systemDebugger.getMemoryLength() / Debugger.this.cpuLines.getNumberOfBlocks());
                        Debugger.this.shouldUpdateCpuLines = true;
                        Debugger.this.systemDebugger.requestGUIupdate();
                    }
                }
                if (n == Debugger.this.addressToHighlightDestinationRow) {
                    component.setForeground(jTable.getForeground());
                    component.setBackground(COLOR_HIGHLIGHT);
                } else if (!bl) {
                    if (n3 >= sourceLine.getAddress() && n3 < sourceLine.getAddress() + sourceLine.getSize()) {
                        component.setForeground(Debugger.this.getCurrentLineForeground());
                        component.setBackground(Debugger.this.getCurrentLineBackground());
                    } else if (Debugger.this.systemDebugger.isSuspended() && Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerHighlightTrace"))) {
                        CyclicIntStack cyclicIntStack = Debugger.this.getTrace();
                        int n5 = cyclicIntStack.indexOf(bl3 ? sourceLine.getAddress() : Debugger.this.systemDebugger.convertAddress(sourceLine.getAddress()));
                        int n6 = cyclicIntStack.size();
                        if (n5 >= 0) {
                            component.setBackground(Debugger.this.getColorTrace(n5 * (COLORS_TRACE.length - 1) / (n6 - 1)));
                        } else if (Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerShowCoverage")) && !Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerShowCoverageInRulerOnly"))) {
                            this.showCoverage(component, n);
                        }
                    } else if (Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerShowCoverage")) && !Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerShowCoverageInRulerOnly"))) {
                        this.showCoverage(component, n);
                    }
                }
                if (component instanceof JLabel) {
                    boolean bl4 = Debugger.this.highlighting && (Debugger.this.highlightWhileRunning || Debugger.this.systemDebugger.isSuspended() || Debugger.this.systemDebugger.isStepping());
                    JLabel jLabel = (JLabel)component;
                    if (n2 < 1 && sourceLine.getAddress() >= 0) {
                        this.showAddressAndByteCode(n, sourceLine, jLabel);
                    } else {
                        if (object instanceof Z80Disassembler.SourceLine) {
                            String string;
                            int n7;
                            Z80Instruction z80Instruction = ((Z80Disassembler.SourceLine)object).getInstruction();
                            if (sourceLine.getAddress() >= n3 && sourceLine.getAddress() - n3 < 8) {
                                int n8 = 0;
                                n7 = 0;
                                while (n7 < Debugger.this.branchArrowSources.length) {
                                    if (Debugger.this.branchArrowSources[n7] == sourceLine.getAddress()) {
                                        n8 = n7;
                                    }
                                    if (Debugger.this.branchArrowSources[n7] < n3 || Debugger.this.branchArrowSources[n7] - n3 >= 8) {
                                        ((Debugger)Debugger.this).branchArrowSources[n7] = -1;
                                    }
                                    ++n7;
                                }
                                if (Debugger.this.branchArrowSources[n8] != sourceLine.getAddress()) {
                                    while (n8 < Debugger.this.branchArrowSources.length && Debugger.this.branchArrowSources[n8] >= 0) {
                                        ++n8;
                                    }
                                }
                                if (n8 < Debugger.this.branchArrowSources.length && z80Instruction != null && (z80Instruction.isBranch() || z80Instruction.isRet())) {
                                    int n9 = Debugger.this.getDestination(n);
                                    n7 = bl3 ? (n9 >= 0 && n9 < Debugger.this.tableRows.length ? Debugger.this.tableRows[n9] : -1) : Debugger.this.getCpuRow(n9);
                                    if (n7 >= 0) {
                                        ((Debugger)Debugger.this).branchArrowSources[n8] = sourceLine.getAddress();
                                        ((Debugger)Debugger.this).branchArrowSourceRows[n8] = bl3 ? Debugger.this.tableRows[sourceLine.getAddress()] : Debugger.this.getCpuRow(sourceLine.getAddress());
                                        ((Debugger)Debugger.this).branchArrowDestinationRows[n8] = n7;
                                        ((Debugger)Debugger.this).branchArrowConditionsMet[n8] = null;
                                        Debugger.this.repaintRuler();
                                    }
                                }
                                if (z80Instruction != null && z80Instruction.isConditional()) {
                                    n7 = Debugger.this.systemDebugger.isConditionMet(z80Instruction.getCondition()) ? 1 : 0;
                                    if (bl4 && Debugger.this.highlighter != null) {
                                        jLabel.setText(String.valueOf(jLabel.getText()) + (n7 != 0 ? Debugger.CONDITION_MET_HIGHLIGHTED_COMMENT : Debugger.CONDITION_UNMET_HIGHLIGHTED_COMMENT));
                                    } else {
                                        jLabel.setText(String.valueOf(jLabel.getText()) + (n7 != 0 ? Debugger.CONDITION_MET_COMMENT : Debugger.CONDITION_UNMET_COMMENT));
                                    }
                                    if (n8 < Debugger.this.branchArrowSources.length) {
                                        ((Debugger)Debugger.this).branchArrowConditionsMet[n8] = n7 != 0;
                                        if (n7 == 0) {
                                            int n10 = ((Debugger)Debugger.this).branchArrowDestinationRows[n8] = bl3 ? Debugger.this.tableRows[sourceLine.getAddress() + sourceLine.getSize()] : Debugger.this.getCpuRow(sourceLine.getAddress() + sourceLine.getSize());
                                        }
                                    }
                                }
                            }
                            if (n3 >= sourceLine.getAddress() && n3 < sourceLine.getAddress() + sourceLine.getSize() && Debugger.this.systemDebugger.isBreakpointHit() && (string = Debugger.this.systemDebugger.getBreakpointMessage()) != null) {
                                if (bl4 && Debugger.this.highlighter != null) {
                                    jLabel.setText(String.valueOf(jLabel.getText()) + "\t; <font color=\"red\">" + Debugger.this.systemDebugger.getBreakpointMessage() + "</font>");
                                } else {
                                    jLabel.setText(String.valueOf(jLabel.getText()) + "\t; " + Debugger.this.systemDebugger.getBreakpointMessage());
                                }
                            }
                            if (Math.abs(sourceLine.getAddress() - n3) < 128) {
                                if (Boolean.parseBoolean(Debugger.this.properties.getProperty("DebuggerDisplayMemoryValues")) && z80Instruction != null && z80Instruction.isMemoryAccess()) {
                                    String string2;
                                    int n11 = z80Instruction.getMemoryAccessRegister();
                                    n7 = z80Instruction.getArgSize() == 2 ? z80Instruction.getArg() : 0xFF00 | (z80Instruction.getArgSize() == 1 ? z80Instruction.getArg() : Debugger.this.systemDebugger.getRegisterValue(0) & 0xFF);
                                    String string3 = n11 < 0 ? Debugger.this.getRamOrPortLabel(n7) : null;
                                    int n12 = Debugger.this.getMemoryAccessAddress(z80Instruction);
                                    String string4 = string2 = z80Instruction.getMemoryAccessSize() == 2 ? Debugger.getHexStringWord(Debugger.this.systemDebugger.peekByte(n12 + 1) << 8 | Debugger.this.systemDebugger.peekByte(n12)) : Debugger.getHexStringByte(Debugger.this.systemDebugger.peekByte(n12));
                                    if (n11 < 0) {
                                        jLabel.setText(String.valueOf(jLabel.getText()) + "\t; (" + (string3 != null ? string3 : "$" + Debugger.getHexStringWord(n7)) + ") = $" + string2);
                                    } else {
                                        String string5 = Debugger.this.systemDebugger.getRegisterNames()[n11];
                                        if (z80Instruction.hasDisplacement()) {
                                            string5 = String.valueOf(string5) + (z80Instruction.getDisplacement() < 0 ? "-" + -z80Instruction.getDisplacement() : "+" + z80Instruction.getDisplacement());
                                        }
                                        jLabel.setText(String.valueOf(jLabel.getText()) + "\t; " + string5 + " = $" + Debugger.getHexStringWord(n12) + ", (" + string5 + ") = $" + string2);
                                    }
                                } else if (z80Instruction != null && z80Instruction.getPrefix() > 0) {
                                    this.showDisplacement(z80Instruction, jLabel);
                                }
                            }
                        }
                        if (object instanceof Z80Disassembler.SourceLine && bl4 && Debugger.this.highlighter != null) {
                            jLabel.setText(Debugger.this.highlighter.highlight(jLabel.getText()));
                        } else {
                            jLabel.setText(jLabel.getText().replace("\t", "    "));
                        }
                        if (bl && Debugger.this.isWordSelected()) {
                            this.highlightSelectedWord(jLabel, bl4);
                        }
                    }
                }
                if (component instanceof JComponent && component.getPreferredSize().width > jTable.getColumnModel().getColumn(n2).getWidth()) {
                    if (sourceLine.getAddress() >= 0 || n2 == 1) {
                        Debugger.this.resizeColumn(n2, component.getPreferredSize());
                    } else {
                        ((JComponent)component).setToolTipText(object.toString());
                    }
                } else {
                    ((JComponent)component).setToolTipText(null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return component;
        }
    }

    class DisassemblerTableModel
    extends DefaultTableModel {
        DisassemblerTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Z80Disassembler.SourceLine sourceLine = this.getLineAt(n);
            if (sourceLine == null) {
                return Z80Disassembler.SourceLine.EMPTY_LINE;
            }
            if (n2 != this.getLineColumn(sourceLine, n)) {
                return Z80Disassembler.SourceLine.EMPTY_LINE;
            }
            return sourceLine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Z80Disassembler.SourceLine getLineAt(int n) {
            Z80Disassembler.CpuLines cpuLines = Debugger.this.cpuLines;
            synchronized (cpuLines) {
                if (n < 0 || n >= this.getRowCount()) {
                    return Z80Disassembler.SourceLine.EMPTY_LINE;
                }
                return n < Debugger.this.lines.size() ? (Z80Disassembler.SourceLine)Debugger.this.lines.get(n) : Debugger.this.cpuLines.get(n - Debugger.this.lines.size());
            }
        }

        private int getLineColumn(Z80Disassembler.SourceLine sourceLine, int n) {
            if (sourceLine.getAddress() >= 0 || this.isCodeComment(n)) {
                return 1;
            }
            return 0;
        }

        private boolean isCodeComment(int n) {
            Z80Disassembler.SourceLine sourceLine = this.getLineAt(n);
            if (sourceLine == null || this.isCommentLine(sourceLine)) {
                return this.isCodeComment(n + 1);
            }
            return sourceLine.getAddress() >= 0;
        }

        private boolean isCommentLine(Z80Disassembler.SourceLine sourceLine) {
            if (sourceLine == null) {
                return false;
            }
            String string = sourceLine.toString();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == ';') {
                    return true;
                }
                if (c > ' ') {
                    return false;
                }
                ++n;
            }
            return false;
        }

        @Override
        public String getColumnName(int n) {
            return " ";
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return Debugger.this.lines.size() + Debugger.this.cpuLines.size();
        }
    }

    final class Expression {
        private final SystemDebugger systemDebugger;
        private final CharSequence expressionString;
        private final expressions.Expression expression;

        public Expression(SystemDebugger systemDebugger, CharSequence charSequence) throws ParseException {
            this.systemDebugger = systemDebugger;
            this.expressionString = charSequence;
            this.expression = new expressions.Expression(charSequence, SystemDebugger.getTokenizer());
        }

        public Expression(SystemDebugger systemDebugger, CharSequence charSequence, expressions.Expression expression) {
            this.systemDebugger = systemDebugger;
            this.expressionString = charSequence;
            this.expression = expression;
        }

        public Expression wrapInRead() {
            return new Expression(this.systemDebugger, "@(" + this.expressionString + ")", this.expression.wrapInRead());
        }

        public Set<String> getVariableNames() throws UnknownVariableException {
            Set<String> set = this.expression.getVariableNames();
            Debugger.this.getVariableValues(set);
            return set;
        }

        public Set<Expression> getReadLocations(VariableProvider variableProvider) throws UnknownVariableException {
            return this.wrap(this.expression.getReadLocations(variableProvider));
        }

        public int getValue(VariableProvider variableProvider) throws UnknownVariableException {
            return (int)this.expression.getValue(variableProvider, this.systemDebugger.getFunctions(), false);
        }

        public boolean isTrue(VariableProvider variableProvider) throws UnknownVariableException {
            return this.expression.isTrue(variableProvider, this.systemDebugger.getFunctions(), false);
        }

        public String getValueString(VariableProvider variableProvider) {
            return this.expression.getValueString(variableProvider, this.systemDebugger.getFunctions());
        }

        public boolean isConstant(VariableProvider variableProvider) throws UnknownVariableException {
            return this.expression.isConstant(variableProvider, this.systemDebugger.getFunctions());
        }

        public Expression optimize(VariableProvider variableProvider) throws UnknownVariableException {
            return new Expression(this.systemDebugger, this.expressionString, this.expression.optimize(variableProvider, this.systemDebugger.getFunctions()));
        }

        public Set<Expression> getReadLocations() throws UnknownVariableException {
            return this.getReadLocations(this.systemDebugger.getVariables());
        }

        public int getValue() throws UnknownVariableException {
            return this.getValue(this.systemDebugger.getVariables());
        }

        public boolean isTrue() throws UnknownVariableException {
            return this.isTrue(this.systemDebugger.getVariables());
        }

        public String getValueString() {
            return this.getValueString(this.systemDebugger.getVariables());
        }

        public boolean isConstant() throws UnknownVariableException {
            return this.isConstant(this.systemDebugger.getVariables());
        }

        public Expression optimize() throws UnknownVariableException {
            return this.optimize(this.systemDebugger.getVariables());
        }

        private Set<Expression> wrap(final Set<expressions.Expression> set) {
            final SystemDebugger systemDebugger = this.systemDebugger;
            return new AbstractSet<Expression>(){

                @Override
                public Iterator<Expression> iterator() {
                    final Iterator iterator = set.iterator();
                    return new Iterator<Expression>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public Expression next() {
                            expressions.Expression expression = (expressions.Expression)iterator.next();
                            return new Expression(systemDebugger, expression.toString(), expression);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return set.size();
                }
            };
        }

        public boolean isString() {
            return this.expression instanceof ConcatenatedExpression;
        }

        public String toString() {
            return this.expressionString.toString();
        }
    }

    private static class FindDialog
    extends JDialog {
        private final HistoryBox find = new HistoryBox("DebuggerFind", 16);
        private final JCheckBox checkBoxCS = new JCheckBox("Case sensitive");
        private final JCheckBox checkBoxWrapSearch = new JCheckBox("Wrap search");
        private final JCheckBox checkBoxWholeWord = new JCheckBox("Whole word");
        private final JCheckBox checkBoxSearchWhileTyping = new JCheckBox("Search while typing");
        private final JCheckBox checkBoxRegularExpression = new JCheckBox("Regular expression");

        private FindDialog(Window window) {
            super(window, "Find");
            final HistoryBox historyBox = this.find;
            final JCheckBox jCheckBox = this.checkBoxCS;
            final JCheckBox jCheckBox2 = this.checkBoxWrapSearch;
            final JCheckBox jCheckBox3 = this.checkBoxWholeWord;
            final JCheckBox jCheckBox4 = this.checkBoxSearchWhileTyping;
            final JCheckBox jCheckBox5 = this.checkBoxRegularExpression;
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.add(new JLabel("Find:"));
            jPanel.add(historyBox);
            this.add((Component)jPanel, "North");
            JPanel jPanel2 = new JPanel(new GridLayout(3, 2));
            jPanel2.setBorder(BorderFactory.createTitledBorder("Options"));
            jPanel2.add(jCheckBox);
            jPanel2.add(jCheckBox2);
            jPanel2.add(jCheckBox3);
            jPanel2.add(jCheckBox4);
            jPanel2.add(jCheckBox5);
            jPanel2.add(jCheckBox5);
            this.add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 2));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            final JLabel jLabel = new JLabel();
            JButton jButton = new JButton("Find Previous");
            jButton.setAction(new AbstractAction(jButton.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jLabel.setText(debugger.findPrev(historyBox.getText(), jCheckBox.isSelected(), jCheckBox2.isSelected(), jCheckBox3.isSelected(), jCheckBox5.isSelected()));
                    historyBox.rememberCurrentText();
                }
            });
            JButton jButton2 = new JButton("Find Next");
            jButton2.setAction(new AbstractAction(jButton2.getText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jLabel.setText(debugger.findNext(historyBox.getText(), jCheckBox.isSelected(), jCheckBox2.isSelected(), jCheckBox3.isSelected(), jCheckBox5.isSelected(), false));
                    historyBox.rememberCurrentText();
                }
            });
            JButton jButton3 = new JButton(new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FindDialog.this.setVisible(false);
                }
            });
            this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "Close");
            this.getRootPane().getActionMap().put("Close", jButton3.getAction());
            this.setDefaultCloseOperation(1);
            jPanel3.add(jButton);
            jPanel3.add(jButton2);
            jPanel3.add(jLabel);
            jPanel3.add(jButton3);
            this.add((Component)jPanel3, "South");
            this.pack();
            this.setLocationRelativeTo(window);
            this.getRootPane().setDefaultButton(jButton2);
            this.loadState(Emulicious.getProperties());
            JTextComponent jTextComponent = (JTextComponent)historyBox.getEditor().getEditorComponent();
            jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.textChanged();
                }

                private void textChanged() {
                    if (jCheckBox4.isSelected()) {
                        jLabel.setText(debugger.findNext(historyBox.getText(), jCheckBox.isSelected(), jCheckBox2.isSelected(), jCheckBox3.isSelected(), jCheckBox5.isSelected(), true));
                    }
                }
            });
        }

        public void loadState(Properties properties) {
            this.find.loadHistory(Emulicious.getProperties());
            this.checkBoxCS.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerFindCaseSensitive")));
            this.checkBoxWrapSearch.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerFindWrapSearch")));
            this.checkBoxWholeWord.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerFindWholeWord")));
            this.checkBoxSearchWhileTyping.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerFindSearchWhileTyping")));
            this.checkBoxRegularExpression.setSelected(Boolean.parseBoolean(properties.getProperty("DebuggerFindRegularExpression")));
        }

        public void saveState(Properties properties) {
            this.find.saveHistory(properties);
            properties.setProperty("DebuggerFindCaseSensitive", Boolean.toString(this.checkBoxCS.isSelected()));
            properties.setProperty("DebuggerFindWrapSearch", Boolean.toString(this.checkBoxWrapSearch.isSelected()));
            properties.setProperty("DebuggerFindWholeWord", Boolean.toString(this.checkBoxWholeWord.isSelected()));
            properties.setProperty("DebuggerFindSearchWhileTyping", Boolean.toString(this.checkBoxSearchWhileTyping.isSelected()));
            properties.setProperty("DebuggerFindRegularExpression", Boolean.toString(this.checkBoxRegularExpression.isSelected()));
        }

        public static void open(Window window) {
            if (findDialog == null) {
                Debugger.findDialog = new FindDialog(window);
            }
            findDialog.find.requestFocus();
            findDialog.setVisible(true);
        }
    }

    static interface StackFrame {
        public String getName();

        public int getBegin();

        public int getEnd();

        public int getAddress();

        public int size();

        public int getAddress(int var1);

        public int getValue(int var1);

        public int getSource(int var1);

        public File getFile();

        public int getLineNumber();
    }

    class StackListModel
    extends DefaultListModel<Object> {
        private final String[] REGISTER_STRINGS;
        private final HashMap<String> ADDRESS_STRINGS = new HashMap();
        private final HashMap<String> ADDRESS_VALUE_STRINGS = new HashMap();

        public StackListModel(SystemDebugger systemDebugger) {
            String[] stringArray = systemDebugger.getRegisterNames();
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (systemDebugger.isAdditionalRegister(n2)) break;
                ++n;
                ++n2;
            }
            this.REGISTER_STRINGS = new String[n];
            n2 = 0;
            while (n2 < this.REGISTER_STRINGS.length) {
                this.REGISTER_STRINGS[n2] = "  (" + stringArray[n2] + ")";
                ++n2;
            }
        }

        private final String getAddressString(int n) {
            String string = this.ADDRESS_STRINGS.get(n);
            if (string == null) {
                string = String.valueOf(Debugger.getHexStringWord(n)) + ": ";
                this.ADDRESS_STRINGS.put(n, string);
            }
            return string;
        }

        private final String getAddressValueString(int n, int n2) {
            int n3 = n << 16 | n2;
            String string = this.ADDRESS_VALUE_STRINGS.get(n3);
            if (string == null) {
                string = String.valueOf(this.getAddressString(n)) + Debugger.getHexStringWord(n2);
                this.ADDRESS_VALUE_STRINGS.put(n3, string);
            }
            return string;
        }

        @Override
        public Object getElementAt(int n) {
            int n2 = Debugger.this.systemDebugger.getStackStart() + (this.getSize() - n - 1) * 2 + (Debugger.this.systemDebugger.getStackPointer() & 1);
            int n3 = Debugger.this.systemDebugger.peekByte(n2 + 1) << 8 | Debugger.this.systemDebugger.peekByte(n2);
            int n4 = Debugger.this.systemDebugger.getStackPointer() - 1 & 0xFFFF & ~(Debugger.this.systemDebugger.getStackLength() - 1) | n2 & Debugger.this.systemDebugger.getStackLength() - 1;
            int n5 = Debugger.this.systemDebugger.getStackSource(n2);
            if (n5 >= 0) {
                String string;
                int n6 = this.REGISTER_STRINGS.length;
                Z80Instruction z80Instruction = Debugger.this.getInstruction(n5);
                if (z80Instruction != null && (z80Instruction.getOpCode() & 0xCF) == 197) {
                    int n7 = z80Instruction.getPrefix() != 0 ? z80Instruction.getPrefix() >> 5 & 5 : 2;
                    n6 = z80Instruction.getOpCode() >> 4 & 3;
                    if (n6 == 2) {
                        n6 = n7;
                    }
                } else if (z80Instruction != null && z80Instruction.getOpCode() == 227) {
                    n6 = 2;
                    if (z80Instruction.getPrefix() > 0) {
                        n6 = z80Instruction.getPrefix() >> 5 & 5;
                    }
                } else if (z80Instruction != null && z80Instruction.isCall()) {
                    n6 = Debugger.this.systemDebugger.indexOfPC();
                }
                if ((string = Debugger.this.getStackLabel(n2)) != null) {
                    if (n6 >= this.REGISTER_STRINGS.length) {
                        n6 = Debugger.this.systemDebugger.indexOfPC();
                    }
                    return String.valueOf(string) + ": " + this.getAddressValueString(n4, n3) + this.REGISTER_STRINGS[n6];
                }
                if (n6 >= this.REGISTER_STRINGS.length) {
                    return String.valueOf(this.getAddressValueString(n4, n3)) + "  (??)";
                }
                return String.valueOf(this.getAddressValueString(n4, n3)) + this.REGISTER_STRINGS[n6];
            }
            return this.getAddressValueString(n4, n3);
        }

        @Override
        public int getSize() {
            return (Debugger.this.systemDebugger.getStackLength() + 1) / 2;
        }
    }
}

