/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;

public class CallStackList
extends JList<String> {
    private final CallStackListModel listModel = new CallStackListModel();
    protected CallStackModel model;

    public CallStackList(CallStackModel callStackModel) {
        this.setModel(this.listModel);
        this.setModel(callStackModel);
        this.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (component instanceof JComponent && !bl2) {
                    ((JComponent)component).setBorder(null);
                }
                return component;
            }
        });
    }

    public void setModel(CallStackModel callStackModel) {
        this.model = callStackModel;
    }

    public void update() {
        this.listModel.update();
    }

    @Override
    public String getPrototypeCellValue() {
        return this.getModel().getSize() > 0 ? (String)this.getModel().getElementAt(0) : null;
    }

    @Override
    public int getFixedCellWidth() {
        return this.getPrototypeCellValue() != null ? this.getCellRenderer().getListCellRendererComponent(this, this.getPrototypeCellValue(), (int)0, (boolean)false, (boolean)false).getPreferredSize().width : super.getFixedCellWidth();
    }

    @Override
    public int getFixedCellHeight() {
        return this.getPrototypeCellValue() != null ? this.getCellRenderer().getListCellRendererComponent(this, this.getPrototypeCellValue(), (int)0, (boolean)false, (boolean)false).getPreferredSize().height : super.getFixedCellHeight();
    }

    class CallStackListModel
    extends DefaultListModel<String> {
        CallStackListModel() {
        }

        @Override
        public int getSize() {
            return CallStackList.this.model != null ? CallStackList.this.model.getElementCount() : 0;
        }

        @Override
        public String getElementAt(int n) {
            return String.valueOf(CallStackList.this.model.getName(n)) + " $" + Integer.toHexString(CallStackList.this.model.getAddress(n));
        }

        public void update() {
            super.fireContentsChanged(this, 0, this.getSize());
        }
    }

    static interface CallStackModel {
        public int getElementCount();

        public String getName(int var1);

        public int getAddress(int var1);

        public int getStackFrameStart(int var1);
    }
}

